# Wstęp[[introduction]]

Witamy w kursie Hugging Face! Ten wstęp poprowadzi Cię przez konfigurację twojego środowiska. Jeśli jesteś tutaj nowy, polecamy najpierw spojrzeć na [pierwszy rozdział](/course/chapter1) i następnie wrócić tutaj żeby skonfigurować środowisko i korzystać z kodu.

Wszystkie biblioteki jakich będziemy używać w tym kursie są dostępne jako pakiety języka Python, więc w tym miejscu pokażemy Ci jak skonfigurować środowisko do pracy z Pythonem i zainstalować biblioteki których będziesz potrzebować.

Pokażemy Ci dwa sposoby na skonfigurowanie środowiska, jeden korzystając z notatnika Colab lub drugi korzystając z wirtualnego środowiska Pythona. Skorzystaj z tego który Ci najbardziej pasuje. Dla początkujących, zalecamy rozpoczęcie pracy z notatnikiem Colab.

Zwróć uwagę, że nie będziemy korzystać z systemu Windows. Jeśli z niego korzystasz, zalecamy korzystanie z notatnika Colab. Jeśli korzystasz z dystrybucji systemu Linux lub z macOS, możesz korzystać z obu sposobów.

Większość kursu zależy od posiadania konta Hugging Face. Polecamy stworzenie jednego w tym miejscu: [stwórz konto](https://huggingface.co/join).

## Korzystanie z notatnika Google Colab [[using-a-google-colab-notebook]]

Korzystanie z notatnika Colab jest najłatwiejszym możliwym podejściem; odpal notatnik w swojej przeglądarce i zacznij programować!

Jeśli nie korzystałeś nigdy wcześniej z Colaba, zalecamy rozpocząć ze [wstępem](https://colab.research.google.com/notebooks/intro.ipynb). Dzięki Colab możesz korzystać z akceleracji sprzętowej z GPU lub TPU i jest darmowe dla mniejszych obciążeń.

Jak poczujesz się komfortowo z Colabem, stwórz nowy notatnik i skonfiguruj swoje środowisko:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="Pusty notatnik Colab" width="80%"/>
</div>

Następnym krokiem jest zainstalowanie bibliotek których będziemy używać w kursie. Skorzystamy z `pip` do instalacji, który jest menadżerem pakietów dla języka Python. W notatnikach możesz korzystać z komend systemowych rozpoczynając je od znaku `!`, więc możesz zainstalować bibliotekę 🤗 Transformers następująco:

```
!pip install transformers
```

Możesz sprawdzić czy pakiety zainstalowały się poprawnie importując jest wewnątrz notatnika:

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

To instaluje bardzo lekką wersję 🤗 Transformers. Ściślej rzecz ujmując, żadna specyficzna biblioteka uczenia maszynowego (jak PyTorch lub TensorFlow) nie jest instalowana. Ponieważ będziemy używać wiele różnych funkcji biblioteki zalecamy zainstalowanie wersji deweloperskiej, która zawiera wszystkie wymagane zależności dla praktycznie każdego zastosowania:

```
!pip install transformers[sentencepiece]
```

To zajmie trochę czasu, ale będzie z głowy na resztę kursu!

## Korzystanie z wirtualnego środowiska Pythona[[using-a-python-virtual-environment]]

Jeśli wolisz korzystać z wirtualnego środowiska Pythona, pierwszym krokiem będzie jego zainstalowanie na systemie. Polecamy następujący [poradnik](https://realpython.com/installing-python/) na początek.

Jak Python zostanie zainstalowany, będziesz w stanie uruchomić komendy Pythona w terminualu. Możesz zacząć uruchamiając następującą komendę żeby się upewnić, że został poprawnie zainstalowany przed pójściem dalej: `python --version`. To powinno wypisac wersję Pythona dostępną na twoim systemie.

Uruchamiając komendę Pythona w terminalu, taką jak `python --version`, pomyśl o programie wykonującym twoją komendę jako o "głównym" Pythonie na twoim systemie. Zalecamy trzymanie głównej instalacji Pythona bez żadnych pakietów i korzystanie z niej do tworzenia osobnych środowisk dla każdej aplikacji nad która pracujesz. W ten sposób, każda aplikacja będzie miała swoje własne odosobnione zależności i pakiety, więc nie będzie problemu z potencjalnymi konfliktami między różnymi aplikacjami.

W Pythonie robi się to za pomocą [*wirtualnych środowisk*](https://docs.python.org/3/tutorial/venv.html), które są samozawierającymi się katalogami posiadającymi instalacje Pythona o odpowiedniej wersji wraz z pakietami jakie aplikacja wymaga. Tworzenie takiego wirtualnego środowiska może być wykonane na kilka sposobów, ale my skorzystamy z oficjalnego pakietu Pythona [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

Na początek, stworzymy katalog dla twojej aplikacji - na przykład, możemy stworzyć nowy katalog o nazwie *transformers-course* w twoim katalogu domowym:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

Z wewnątrz tego katalogu, tworzymy wirtualne środowisko korzystając z modułu `venv` Pythona:

```
python -m venv .env
```

Teraz powinien powstać katalog o nazwie *.env*: 

```
ls -a
```

```out
.      ..    .env
```

Możesz aktywować i dezaktywować swoje wirtualne środowiska korzystając ze skryptów `activate` oraz `deactivate`:

```
# Aktywuj wirtualne środowisko
source .env/bin/activate

# Dezaktywuj wirtualne środowisko
deactivate
```

Możesz się upewnić że środowisko jest aktywne uruchamiając komendę `which python`: jeśli zwraca ścieżkę do twojego wirtualnego środowiska, to udało Ci się je poprawnie aktywować!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### Instalowanie zależności[[installing-dependencies]]

Tak jak w poprzedniej sekcji o korzystaniu z notatnika Google Colab, musisz teraz zainstalować odpowiednie pakiety żeby kontynuować. Ponownie, możesz zainstalować wersję deweloperską biblioteki 🤗 Transformers korzystając z menadżera pakietów `pip`:

```
pip install "transformers[sentencepiece]"
```

Zaczynajmy!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pl/chapter0/1.mdx" />