# Questionário de fim de capítulo

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Este capítulo cobriu muito terreno! Não se preocupe se você não entendeu todos os detalhes; os próximos capítulos o ajudarão a entender como as coisas funcionam debaixo do capô.

Primeiro, porém, vamos testar o que você aprendeu neste capítulo!

### 1. Explore o Hub e olhe para o checkpoint `roberta-large-mnli` . Que tarefa ele executa?

<Question
	choices={[
		{
			text: "Summarização",
			explain: "Olhe novamente na página <a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli</a>."
		},
		{
			text: "Classificação de texto",
			explain: "Mais precisamente, ele classifica se duas ou mais sentenças estão logicamente conectadas entre três rótulos (contradição, neutro, vinculação) — uma tarefa também chamada de <em>inferência de linguagem natural</em>.",
			correct: true
		},
		{
			text: "Geração de texto",
			explain: "Olhe novamente na página <a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli</a>."
		}
	]}
/>

### 2. O que o código a seguir retornará?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "Ele retornará pontuações de classificação para esta frase, com rótulos 'positivo' ou 'negativo'.",
			explain: "Isso está incorreto - isso seria um pipeline de 'análise de sentimentos'."
		},
		{
			text: "Ele retornará um texto gerado completando esta frase.",
			explain: "Isso está incorreto - seria um pipeline de ``geração de texto`."
		},
		{
			text: "Ele retornará as palavras que representam pessoas, organizações ou locais.",
			explain: "Além disso, com `grouped_entities=True`, ele agrupará as palavras pertencentes à mesma entidade, como 'Hugging Face'.",
      			correct: true
		}
	]}
/>

### 3. O que deverá substituir ... nesse trecho de código?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```


<Question
	choices={[
		{
			text: "Esta <mask> está esperando por você.",
			explain: "Isso está incorreto. Confira o cartão modelo `bert-base-cased` e tente identificar seu erro."
		},
		{
			text: "Esta [MASK] está esperando por você.",
			explain: "Correto! O token de máscara deste modelo é [MASK]",
      			correct: true
		},
		{
			text: "Este homem está esperando por você.",
			explain: "Isso está incorreto. Esse pipeline preenche palavras mascaradas, portanto, precisa de um token de máscara em algum lugar."
		}
	]}
/>

### 4. Por que esse código irá dar erro?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```


<Question
	choices={[
		{
			text: "Esse pipeline exige que sejam fornecidos rótulos para classificar esse texto.",
			explain: "Certo — o código correto precisa incluir `candidate_labels=[...]`.",
      			correct: true
		},
		{
			text: "Esse pipeline requer várias frases, não apenas uma.",
			explain: "Isso é incorreto, mas quando usado corretamente, esse pipeline pode levar uma lista de frases para processar (como todos os outros pipelines)."
		},
		{
			text: "A biblioteca 🤗 Transformers está quebrada, como sempre.",
			explain: "Não vamos dignificar esta resposta com um comentário!"
		},
    {
			text: "Esse pipeline requer entradas mais longas; esta é muito curta.",
			explain: "Isso está incorreto. Observe que um texto muito longo será truncado quando processado por esse pipeline."
		}
	]}
/>

### 5. O que "transfer learning" significa?

<Question
	choices={[
		{
			text: "Transferir o conhecimento de um modelo pré-treinado para um novo modelo treinando-o no mesmo conjunto de dados.",
			explain: "Não, seriam duas versões do mesmo modelo."
		},
		{
			text: "Transferir o conhecimento de um modelo pré-treinado para um novo modelo inicializando o segundo modelo com os pesos do primeiro modelo.",
			explain: "Correto: quando o segundo modelo é treinado em uma nova tarefa, ele _transfere_ o conhecimento do primeiro modelo.",
      			correct: true
		},
		{
			text: "Transferir o conhecimento de um modelo pré-treinado para um novo modelo construindo o segundo modelo com a mesma arquitetura do primeiro modelo",
			explain: "A arquitetura é apenas a forma como o modelo é construído; não há conhecimento compartilhado ou transferido neste caso."
		}
	]}
/>

### 6. Verdadeiro ou Falso? Um modelo de linguagem geralmente não precisa de rótulos para seu pré-treino.

<Question 
  	choices={[ 
    		{ 
      			text: "Verdadeiro",
      			explain: "O pré-treinamento geralmente é _autosupervisionado_, o que significa que os rótulos são criados automaticamente a partir das entradas (como prever a próxima palavra ou preencher algumas palavras mascaradas).", 
      			correct: true 
    		}, 
    		{ 
      			text: "Falso", 
      			explain:"Essa não é a resposta correta."
    		} 
  	]} 
/>

### 7. Selecione a sentença que melhor descreve os termos "modelo", "arquitetura" e "pesos".

<Question 
  	choices={[ 
    		{ 
      			text: "Se um modelo é um edifício, sua arquitetura é a planta e os pesos são as pessoas que vivem dentro dele.", 
      			explain: "Seguindo essa metáfora, os pesos seriam os tijolos e outros materiais utilizados na construção do edifício." 
    		}, 
    		{ 
      			text: "Uma arquitetura é um mapa para construir um modelo e seus pesos são as cidades representadas no mapa.", 
      			explain: "O problema com essa metáfora é que um mapa geralmente representa uma realidade existente (há apenas uma cidade na França chamada Paris). Para uma determinada arquitetura, vários pesos são possíveis." 
    		}, 
    		{ 
      			text: "Uma arquitetura é uma sucessão de funções matemáticas para construir um modelo e seus pesos são os parâmetros dessas funções.", 
      			explain: "O mesmo conjunto de funções matemáticas (arquitetura) pode ser usado para construir diferentes modelos usando diferentes parâmetros (pesos).", 
      			correct: true 
    		} 
  	]} 
/>

### 8. Quais desses tipos de modelos você usaria para completar comandos com textos gerados?

<Question 
  	choices={[ 
    		{ 
      			text: "Um modelo de codificador", 
      			explain: "Um modelo de codificador gera uma representação de toda a frase que é mais adequada para tarefas como classificação." 
    		}, 
    		{ 
      			text: "Um modelo de decodificador", 
      			explain: "Os modelos de decodificadores são perfeitamente adequados para geração de texto a partir de um prompt.", 
      			correct: true 
    		}, 
    		{ 
      			text: "Um modelo de sequência a sequência", 
      			explain: "Os modelos de sequência a sequência são mais adequados para tarefas em que você deseja gerar frases em relação às frases de entrada, não a um determinado prompt." 
    		} 
  	]} 
/>

### 9. Quais desses tipos de modelos você usaria para resumir textos?

<Question 
  choices={[ 
    		{ 
      			text: "Um modelo de codificador", 
      			explain: "Um modelo de codificador gera uma representação de toda a frase que é mais adequada para tarefas como classificação." 
    		}, 
    		{ 
      			text: "Um modelo de decodificador", 
      			explain: "Os modelos decodificadores são bons para gerar texto de saída (como resumos), mas não têm a capacidade de explorar um contexto como o texto inteiro para resumir."
    		},
    		{
      			text: "Um modelo de sequência a sequência",
      			explain: "Os modelos de sequência a sequência são perfeitamente adequados para uma tarefa de sumarização.", 
      			correct: true 
    		} 
  	]} 
/>

### 10. Quais desses tipos de modelos você usaria para classificar entradas de texto de acordo com determinados rótulos?

<Question 
  choices={[ 
    		{ 
      			text: "Um modelo de codificador", 
      			explain: "Um modelo de codificador gera uma representação de toda a frase que é perfeitamente adequada para uma tarefa como classificação.", 
      			correct: true 
    		}, 
    		{ 
      			text: "Um modelo de decodificador", 
      			explain: "Os modelos decodificadores são bons para gerar textos de saída, não para extrair um rótulo de uma frase." 
    		}, 
    		{
      			text: "Um modelo de sequência a sequência",
      			explain: "Os modelos de sequência a sequência são mais adequados para tarefas em que você deseja gerar texto com base em uma frase de entrada, não em um rótulo."
    		} 
  	]} 
/>

### 11. Que possível fonte o viés observado em um modelo pode ter?

<Question 
  choices={[ 
    		{ 
      			text: "O modelo é uma versão afinada de um modelo pré-treinado e pega seu viés a partir dele.", 
      			explain: "Ao aplicar o Transfer Learning, o viés no modelo pré-treinado usado persiste no modelo ajustado.", 
      			correct: true 
    		}, 
    		{ 
      			text: "Os dados em que o modelo foi treinado são enviesados.", 
      			explain: "Esta é a fonte mais óbvia de viés, mas não a única.", 
      			correct: true 
    		}, 
    		{ 
      			text: "A métrica para a qual o modelo estava otimizando é enviesada.", 
      			explain: "Uma fonte menos óbvia de viés é a forma como o modelo é treinado. Seu modelo será otimizado cegamente para qualquer métrica que você escolher, sem pensar duas vezes.", 
      			correct: true 
    		} 
  	]} 
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter1/10.mdx" />