# Vieses e limitações

<CourseFloatingBanner chapter={1} classNames="absolute z-10 right-0 top-0" notebooks={[ {label: "Google Colab", value: "[https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/pt/chapter1/section8.ipynb](https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/pt/chapter1/section8.ipynb)"}, {label: "Aws Studio", value: "[https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/pt/chapter1/section8.ipynb](https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/pt/chapter1/section8.ipynb)"}, ]} />

Se sua intenção é usar um modelo pré-treinado ou uma versão ajustada em produção, esteja ciente de que, embora esses modelos sejam ferramentas poderosas, eles vêm com limitações. A maior delas é que, para possibilitar o pré-treinamento em grandes quantidades de dados, os pesquisadores muitas vezes raspam todo o conteúdo que encontram, tirando o melhor e o pior do que está disponível na internet.

Para dar uma ilustração rápida, vamos voltar ao exemplo de um pipeline `fill-mask` com o modelo BERT:
```py
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])

["lawyer", "carpenter", "doctor", "waiter", "mechanic"]
["nurse", "waitress", "teacher", "maid", "prostitute"]
```

Quando solicitado a preencher a palavra que falta nessas duas frases, o modelo dá apenas uma resposta livre de gênero (garçom/garçonete). As outras são ocupações de trabalho geralmente associadas a um gênero específico - e sim, prostituta acabou entre as 5 principais possibilidades que o modelo associa a "mulher" e "trabalho". Isso acontece mesmo que o BERT seja um dos raros modelos de Transformer não construídos por meio de coleta de dados de toda a Internet, mas usando dados aparentemente neutros (ele é treinado com datasets da [Wikipedia em inglês](https://huggingface.co/datasets/wikipedia ) e [BookCorpus](https://huggingface.co/datasets/bookcorpus)).

Quando você usa essas ferramentas, você precisa ter em mente que o modelo original que você está usando pode facilmente gerar conteúdo sexista, racista ou homofóbico. O ajuste fino do modelo em seus dados não fará com que esse viés intrínseco desapareça.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter1/8.mdx" />