# Introdução

<CourseFloatingBanner
    chapter={6}
    classNames="absolute z-10 right-0 top-0"
/>

No [Capítulo 3](/course/chapter3), nós estudamos como realizar o ajuste fino em um modelo para uma dada tarefa. Quando nós fazemos isso, usamos o mesmo tokenizador utilizado pelo modelo pré-treinado -- mas o que podemos fazer quando queremos treinar um modelo do início? Nestes casos, utilizar um tokenizador que foi pré-treinado em um corpus de outro domínio ou linguagem é tipicamente subótimo. Por exemplo, um tokenizador que é treinado em um corpus de lingua inglesa terá um desempenho ruim em um corpus de textos em japonês, visto que o uso de espaços e pontuações é muito diferente nestes dois idiomas.

Neste capítulo, você aprenderá como treinar um novo tokenizador em um corpus de textos, para então ser usado no treinamento de um modelo de linguagem. Isto tudo será feito com ajuda da biblioteca [🤗 Tokenizers](https://github.com/huggingface/tokenizers), que provê o tokenizador rápido na biblioteca [🤗 Transformers](https://github.com/huggingface/transformers). Daremos uma olhada a fundo sobre as funcionalidades oferecidas pela biblioteca, e explorar como os tokenizadores rápidos diferem das versões "lentas".

Os tópicos que iremos cobrir incluem:

* Como treinar um novo tokenizador semelhante ao usado por um determinado checkpoint em um novo corpus de textos
* Os recursos especiais dos tokenizadores rápidos
* As diferenças entre os três principais algoritmos de tokenização de subpalavras usados ​​no processamento de linguagem natural hoje
* Como construir um tokenizador do zero com a biblioteca 🤗 Tokenizers e treiná-lo em alguns dados

As técnicas introduzidas neste capítulo irão te preparar para a seção no [Capítulo 7](/course/chapter7/6) onde iremos analisar a criação de um modelo de linguagem para a linguagem Python. Primeiramente, vamos começar analisando o que significa "treinar" um tokenizador.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter6/1.mdx" />