# Cum funcționează Transformers?[[cum-funcționează-transformers]]

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

În această secțiune, vom analiza arhitectura modelelor Transformer.

## Un pic despre istoria modelelor Transformer[[un-pic-despre-istoria-modelelor-transformer]]

Iată câteva puncte de referință în (scurta) istorie a modelelor Transformer:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono.svg" alt="A brief chronology of Transformers models.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono-dark.svg" alt="A brief chronology of Transformers models.">
</div>

[Arhitectura Transformer](https://arxiv.org/abs/1706.03762) a fost introdusă în iunie 2017. Cercetarea inițială s-a concentrat pe sarcinile de traducere. Ulterior, au fost introduse mai multe modele influente, inclusiv:

- **Iunie 2018**: [GPT](https://cdn.openai.com/research-covers/language-unsupervised/language_understanding_paper.pdf), primul model Transformer preinstruit, utilizat pentru fine-tuning-ul diferitor sarcini NLP și a obținut rezultate de top

- **Octombrie 2018**: [BERT](https://arxiv.org/abs/1810.04805), un alt model mare preantrenat, conceput pentru a produce rezumate mai bune ale propozițiilor (mai multe despre el în capitolul următor!)

- **Februarie 2019**: [GPT-2](https://cdn.openai.com/better-language-models/language_models_are_unsupervised_multitask_learners.pdf), o versiune îmbunătățită (și mai mare) a GPT care nu a fost lansată public imediat din motive etice

- **Octombrie 2019**: [DistilBERT](https://arxiv.org/abs/1910.01108), o versiune distilată a BERT care este cu 60% mai rapidă, cu 40% mai ușoară în memorie și care păstrează încă 97% din performanța BERT

- **Octombrie 2019**: [BART](https://arxiv.org/abs/1910.13461) și [T5](https://arxiv.org/abs/1910.10683), două modele mari preantrenate folosind aceeași arhitectură ca modelul original Transformer (primul care face acest lucru)

- **Mai 2020**, [GPT-3](https://arxiv.org/abs/2005.14165), o versiune și mai mare a GPT-2, care este capabilă să se descurce bine într-o varietate de sarcini, fără a fi nevoie de o reglare fină (numită _zero-shot learning_)

Această listă este departe de a fi completă și este menită doar să evidențieze câteva dintre diferitele tipuri de modele Transformer. În linii mari, acestea pot fi grupate în trei categorii:

- Tip GPT (numite și modele de Transformer autoregresive)
- Tip BERT (numite și modele de Transformer _auto-encoding_) 
- Tip BART/T5 (denumite și modele de Transformer _sequence-to-sequence_)

Vom analiza aceste familii în detaliu mai târziu.

## Transformers sunt modele de limbaj[transformers-sunt-modele-de-limbaj]]

Toate modelele Transformer menționate mai sus (GPT, BERT, BART, T5 etc.) au fost antrenate ca *modele lingvistice*. Aceasta înseamnă că au fost antrenate pe volume mari de text brut într-un mod autosupravegheat. Învățarea autosupravegheată este un tip de antrenare în care obiectivul este calculat automat din datele de intrare ale modelului. Aceasta înseamnă că nu este nevoie de oameni pentru a eticheta datele!

Acest tip de model dezvoltă o înțelegere statistică a limbii pe care a fost antrenat, dar nu este foarte util pentru sarcini practice specifice. Din acest motiv, modelul general preantrenat trece apoi printr-un proces numit *transfer learning*. În timpul acestui proces, modelul este ajustat într-un mod supravegheat - adică folosind etichete notate de oameni - pentru o anumită sarcină.

Un exemplu de sarcină este prezicerea următorului cuvânt dintr-o propoziție după citirea a *n* cuvinte anterioare. Aceasta se numește *modelare cauzală a limbajului* deoarece rezultatul depinde de intrările trecute și prezente, dar nu și de cele viitoare.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling-dark.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
</div>

Un alt exemplu este *modelarea limbajului mascat*, în care modelul prezice un cuvânt mascat din propoziție.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling-dark.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
</div>

## Modelele Transformer sunt mari[[modelele-transformer-sunt-mari]]

Cu excepția câtorva cazuri excepționale (cum ar fi DistilBERT), strategia generală pentru a obține performanțe mai bune constă în creșterea dimensiunilor modelelor, precum și a cantității de date pe care acestea sunt preantrenate.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/model_parameters.png" alt="Number of parameters of recent Transformers models" width="90%">
</div>

Din păcate, antrenarea unui model, în special a unuia mare, necesită o cantitate mare de date. Acest lucru devine foarte costisitor în termeni de timp și resurse de calcul. Aceasta se reflectă chiar și în impactul asupra mediului, după cum se poate vedea în graficul următor.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint.svg" alt="The carbon footprint of a large language model.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint-dark.svg" alt="The carbon footprint of a large language model.">
</div>

<Youtube id="ftWlj4FBHTg"/>

Iar acest lucru arată un proiect pentru un model (foarte mare) condus de o echipă care încearcă în mod conștient să reducă impactul de mediu al preinstruirii. Amprenta lăsată de efectuarea multor teste pentru a obține cei mai buni hiperparametri ar fi și mai mare.

Imaginați-vă dacă de fiecare dată când o echipă de cercetare, o organizație studențească sau o companie ar dori să antreneze un model, ar face-o de la zero. Acest lucru ar conduce la costuri globale uriașe și inutile!

Acesta este motivul pentru care partajarea modelelor lingvistice este esențială: partajarea ponderilor antrenate și construirea pe baza ponderilor deja antrenate reduce costul global de calcul și amprenta de carbon a comunității.

Apropo, puteți evalua amprenta de carbon a formării modelelor dvs. prin intermediul mai multor instrumente. De exemplu [ML CO2 Impact](https://mlco2.github.io/impact/) sau [Code Carbon]( https://codecarbon.io/) care este integrat în 🤗 Transformers. Pentru a afla mai multe despre acest lucru, puteți citi această [postare pe blog](https://huggingface.co/blog/carbon-emissions-on-the-hub) care vă va arăta cum să generați un fișier `emissions.csv` cu o estimare a amprentei formării dvs., precum și [documentația](https://huggingface.co/docs/hub/model-cards-co2) din 🤗 Transformers care abordează acest subiect.


## Transfer Learning[[transfer-learning]]

<Youtube id="BqqfQnyjmgg" />

*Preinstruirea* este acțiunea de formare a unui model de la zero: ponderile sunt inițializate aleatoriu, iar formarea începe fără nicio cunoaștere prealabilă.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining.svg" alt="The pretraining of a language model is costly in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining-dark.svg" alt="The pretraining of a language model is costly in both time and money.">
</div>

Această preinstruire se face de obicei pe cantități foarte mari de date. Prin urmare, este nevoie de un corpus foarte mare de date, iar formarea poate dura până la câteva săptămâni.

*Reglarea-fină*, pe de altă parte, este instruirea efectuată **după** ce un model a fost preinstruit. Pentru a efectua reglarea fină, obțineți mai întâi un model lingvistic preinstruit, apoi efectuați o instruire suplimentară cu un set de date specific sarcinii dumneavoastră. Stați - de ce să nu instruiți de la început modelul pentru cazul dvs. final de utilizare (**scratch**)? Există câteva motive:

* Modelul preinstruit a fost deja instruit pe un set de date care are unele similitudini cu setul de date pentru reglarea fină. Procesul de reglare fină este astfel capabil să profite de cunoștințele dobândite de modelul inițial în timpul preantrenării (de exemplu, în cazul problemelor de NLP, modelul preantrenat va avea un anumit tip de înțelegere statistică a limbajului pe care îl utilizați pentru sarcina dumneavoastră). 
* Deoarece modelul preinstruit a fost deja instruit pe o mulțime de date, fine-tuning-ul necesită mult mai puține date pentru a obține rezultate decente.
* Din același motiv, timpul și resursele necesare pentru a obține rezultate bune sunt mult mai reduse.

De exemplu, se poate folosi un model preantrenat pe limba engleză și ajustat ulterior pe un corpus arXiv, obținându-se astfel un model adaptat domeniului științific/cercetare. Fine-tuning-ul necesita doar o cantitate limitată de date: cunoștințele dobândite de modelul preantrenat sunt „transferate”, de unde și termenul de *transfer learning*.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning-dark.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
</div>

Prin urmare, reglarea fină a unui model are costuri mai reduse în ceea ce privește timpul, datele, resursele financiare și impactul asupra mediului. De asemenea, este mai rapid și mai ușor să experimentați pe diferite scheme de fine-tuning, deoarece antrenarea este mai puțin constrângătoare decât o preantrenare completă.

Acest proces va obține, de asemenea, rezultate mai bune decât formarea de la zero (cu excepția cazului în care dispuneți de o mulțime de date), motiv pentru care ar trebui să încercați întotdeauna să valorificați un model preformat - unul cât mai apropiat posibil de sarcina pe care o aveți la îndemână - și să îl reglați fin.

## Arhitectura generală[[arhitectura-generală]]

În această secțiune, vom analiza arhitectura generală a modelului Transformer. Nu vă faceți griji dacă nu înțelegeți anumite concepte; mai târziu există secțiuni detaliate care acoperă fiecare dintre componente.

<Youtube id="H39Z_720T5s" />

## Introducere[[introducere]]

Modelul este compus în principal din două blocuri:

* **Codificator (stânga)**: Codificatorul primește o intrare și construiește o reprezentare a acesteia (caracteristicile sale). Aceasta înseamnă că modelul este optimizat pentru a dobândi cunoștințe din datele de intrare.
* **Decodificator (dreapta)**: Decodificatorul utilizează reprezentarea codificatorului (caracteristicile) împreună cu alte intrări pentru a genera o secvență țintă. Aceasta înseamnă că modelul este optimizat pentru a genera ieșiri.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks-dark.svg" alt="Architecture of a Transformers models">
</div>

Fiecare dintre aceste părți poate fi utilizată independent, în funcție de sarcină: 

* **Modeluri exclusiv de codare**: Bune pentru sarcini care necesită înțelegerea datelor de intrare, cum ar fi clasificarea propozițiilor și recunoașterea entităților numite.
* **Modele exclusiv decodificatoare**: Bune pentru sarcini generative, cum ar fi generarea de text.
* **Modele encoder-decoder** sau **modele sequence-to-sequence**: Bune pentru sarcinile generative care necesită o intrare, cum ar fi traducerea sau rezumarea.

Vom analiza aceste arhitecturi în mod independent în secțiunile următoare.

## Attention layers(straturi de atenție)[[attention-layers]]

O caracteristică cheie a modelelor Transformer este faptul că acestea sunt construite cu straturi speciale numite *attention layers*. De fapt, titlul lucrării de prezentare a arhitecturii Transformer a fost [„Attention Is All You Need”] (https://arxiv.org/abs/1706.03762)! Vom explora detaliile attention layers-urilor mai târziu în curs; pentru moment, tot ce trebuie să știți este că acest strat va spune modelului să acorde o atenție specifică anumitor cuvinte din propoziția pe care i-ați transmis-o (și să le ignore mai mult sau mai puțin pe celelalte) atunci când se ocupă de reprezentarea fiecărui cuvânt.

Pentru a pune acest lucru în context, luați în considerare sarcina de a traduce un text din engleză în franceză. Având în vedere intrarea „Vă place acest curs”, un model de traducere va trebui să se ocupe și de cuvântul adiacent „You” pentru a obține traducerea corectă pentru cuvântul „like”, deoarece în franceză verbul „like” se conjugă diferit în funcție de subiect. Cu toate acestea, restul propoziției nu este util pentru traducerea acestui cuvânt. În aceeași ordine de idei, la traducerea cuvântului „this”, modelul va trebui, de asemenea, să acorde atenție cuvântului „course”, deoarece „this” se traduce diferit în funcție de faptul dacă substantivul asociat este masculin sau feminin. Din nou, celelalte cuvinte din propoziție nu vor conta pentru traducerea cuvântului „course”. În cazul unor propoziții mai complexe (și al unor reguli gramaticale mai complexe), modelul ar trebui să acorde o atenție deosebită cuvintelor care ar putea apărea mai departe în propoziție pentru a traduce corect fiecare cuvânt.

Același concept se aplică oricărei sarcini asociate cu limbajul natural: un cuvânt în sine are o semnificație, dar această semnificație este profund afectată de context, care poate fi orice alt cuvânt (sau cuvinte) înainte sau după cuvântul studiat.

Acum, că aveți o idee despre ce sunt attention layers, să analizăm mai îndeaproape arhitectura Transformer.

## Arhitectura originală[[arhitectura-originală]

Arhitectura Transformer a fost concepută inițial pentru traducere. În timpul formării, codificatorul primește intrări (propoziții) într-o anumită limbă, în timp ce decodificatorul primește aceleași propoziții în limba țintă dorită. În codificator, attention layers pot utiliza toate cuvintele dintr-o propoziție (deoarece, după cum tocmai am văzut, traducerea unui anumit cuvânt poate depinde de ceea ce se află înainte și după el în propoziție). Cu toate acestea, decodificatorul funcționează secvențial și poate acorda atenție numai cuvintelor din propoziție pe care le-a tradus deja (deci, numai cuvintelor anterioare cuvântului generat în prezent). De exemplu, atunci când am prezis primele trei cuvinte din ținta tradusă, le dăm decodificatorului, care utilizează apoi toate intrările codificatorului pentru a încerca să prezică al patrulea cuvânt.

Pentru a accelera lucrurile în timpul formării (atunci când modelul are acces la propozițiile țintă), decodorul primește întreaga țintă, dar nu i se permite să utilizeze cuvintele viitoare (dacă ar avea acces la cuvântul din poziția 2 atunci când încearcă să prezică cuvântul din poziția 2, problema nu ar fi foarte dificilă!) De exemplu, atunci când încearcă să prezică al patrulea cuvânt, stratul de atenție va avea acces doar la cuvintele de la pozițiile 1 și 3.

Arhitectura originală a Transformer arăta astfel, cu codificatorul în stânga și decodificatorul în dreapta:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers-dark.svg" alt="Architecture of a Transformers models">
</div>

Rețineți că primul attention layer dintr-un bloc decodor acordă atenție tuturor intrărilor (trecute) către decodor, dar al doilea attention layer utilizează ieșirea codorului. Astfel, acesta poate accesa întreaga propoziție de intrare pentru a prezice cel mai bine cuvântul curent. Acest lucru este foarte util deoarece diferite limbi pot avea reguli gramaticale care pun cuvintele în ordine diferită sau un context furnizat mai târziu în propoziție poate fi util pentru a determina cea mai bună traducere a unui cuvânt dat.

*attention mask* poate fi, de asemenea, utilizată în codificator/decodificator pentru a împiedica modelul să acorde atenție anumitor cuvinte speciale - de exemplu, cuvântul special de umplutură utilizat pentru a face ca toate intrările să aibă aceeași lungime atunci când se grupează propozițiile.

##  Architectura vs. punctele de control[[architectura-vs-punctele-de-control]]

Pe măsură ce analizăm modelele Transformer în acest curs, veți vedea mențiuni despre *arhitecturi* și *puncte de control*, precum și despre *modele*. Toți acești termeni au semnificații ușor diferite: 

* **Arhitectură**: Acesta este scheletul modelului - definiția fiecărui strat și a fiecărei operațiuni care are loc în cadrul modelului. 
* **Puncte de control**: Acestea sunt ponderile care vor fi încărcate într-o anumită arhitectură.
* **Model**: Acesta este un termen generic care nu este la fel de precis ca „arhitectură” sau „punct de control”: poate însemna ambele. Acest curs va specifica *arhitectură* sau *punct de control* atunci când este necesar pentru a reduce ambiguitatea.

De exemplu, BERT este o arhitectură, în timp ce `bert-base-cased`, un set de ponderi antrenate de echipa Google pentru prima versiune a BERT, este un punct de control. Cu toate acestea, se poate spune „modelul BERT” și „modelul `bert-base-cased`”.

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter1/4.mdx" />