# Încărcați setul de date în Argilla[[încărcați-setul-de-date-în-argilla]]

<CourseFloatingBanner chapter={10}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter10/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter10/section3.ipynb"},
]} />

În funcție de sarcina NLP cu care lucrați și cazul de utilizare sau aplicația specifică, datele dvs. și sarcina de adnotare vor arăta diferit. Pentru această secțiune a cursului, vom folosi [un set de date care colectează știri](https://huggingface.co/datasets/SetFit/ag_news) pentru a completa două sarcini: o clasificare de text asupra subiectului fiecărui text și o clasificare de token-uri pentru a identifica entitățile numite menționate.

<iframe
  src="https://huggingface.co/datasets/SetFit/ag_news/embed/viewer/default/train"
  frameborder="0"
  width="100%"
  height="560px"
></iframe>

Este posibil să importați seturi de date din Hub folosind direct interfața Argilla, dar vom folosi SDK-ul pentru a învăța cum putem face editări suplimentare la date dacă este necesar.

## Configurați setul de date

Primul pas este să ne conectăm la instanța Argilla așa cum am făcut în secțiunea anterioară:

```python
import argilla as rg

HF_TOKEN = "..."  # doar pentru space-uri private

client = rg.Argilla(
    api_url="...",
    api_key="...",
    headers={"Authorization": f"Bearer {HF_TOKEN}"},  # doar pentru space-uri private
)
```

Acum putem gândi la setările setului nostru de date în Argilla. Acestea reprezintă sarcina de adnotare pe care o vom face asupra datelor noastre. Mai întâi, putem încărca setul de date din Hub și să inspectăm caracteristicile acestuia, astfel încât să ne asigurăm că configurăm setul de date corect.

```python
from datasets import load_dataset

data = load_dataset("SetFit/ag_news", split="train")
data.features
```

Acestea sunt caracteristicile setului nostru de date:

```python out
{'text': Value(dtype='string', id=None),
 'label': Value(dtype='int64', id=None),
 'label_text': Value(dtype='string', id=None)}
```

Conține un `text` și de asemenea câteva etichete inițiale pentru clasificarea textului. Le vom adăuga la setările setului nostru de date împreună cu o întrebare `spans` pentru entitățile numite:

```python
settings = rg.Settings(
    fields=[rg.TextField(name="text")],
    questions=[
        rg.LabelQuestion(
            name="label", title="Clasificați textul:", labels=data.unique("label_text")
        ),
        rg.SpanQuestion(
            name="entities",
            title="Evidențiați toate entitățile din text:",
            labels=["PERSON", "ORG", "LOC", "EVENT"],
            field="text",
        ),
    ],
)
```

Să aprofundăm puțin ce înseamnă aceste setări. Mai întâi, am definit **fields** (câmpuri), acestea includ informațiile pe care le vom anota. În acest caz, avem doar un câmp și vine sub forma unui text, așa că am ales un `TextField`.

Apoi, definim **questions** (întrebări) care reprezintă sarcinile pe care vrem să le efectuăm asupra datelor noastre:

- Pentru sarcina de clasificare de text am ales o `LabelQuestion` și am folosit valorile unice ale coloanei `label_text` ca etichetele noastre, pentru a ne asigura că întrebarea este compatibilă cu etichetele care există deja în setul de date.
- Pentru sarcina de clasificare de token-uri, vom avea nevoie de o `SpanQuestion`. Am definit un set de etichete pe care le vom folosi pentru acea sarcină, plus câmpul pe care vom desena intervalele.

Pentru a afla mai multe despre toate tipurile disponibile de câmpuri și întrebări și alte setări avansate, precum metadatele și vectorii, mergeți la [documentația Argilla](https://docs.argilla.io/latest/how_to_guides/dataset/#define-dataset-settings).

## Încărcați setul de date

Acum că am definit câteva setări, putem crea setul de date:

```python
dataset = rg.Dataset(name="ag_news", settings=settings)

dataset.create()
```

Setul de date apare acum în instanța noastră Argilla, dar veți vedea că este gol:

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter10/empty_dataset.png" alt="Captură de ecran cu setul de date gol."/>

Acum trebuie să adăugăm înregistrările pe care le vom anota, adică rândurile din setul nostru de date. Pentru a face asta, va trebui pur și simplu să înregistrăm datele ca înregistrări și să oferim o mapare pentru acele elemente care nu au același nume în seturile de date din hub și Argilla:

```python
dataset.records.log(data, mapping={"label_text": "label"})
```

În maparea noastră, am specificat că coloana `label_text` din setul de date ar trebui mapată la întrebarea cu numele `label`. În acest fel, vom folosi etichetele existente din setul de date ca pre-adnotări astfel încât să putem anota mai rapid.

În timp ce înregistrările continuă să se înregistreze, puteți începe deja să lucrați cu setul de date în interfața Argilla. În acest moment, ar trebui să arate așa:

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter10/argilla_initial_dataset.png" alt="Captură de ecran cu setul de date în Argilla."/>

Acum setul nostru de date este gata să începem adnotarea! 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter10/3.mdx" />