# Quiz la final de capitol [[quiz-la-final-de-capitol]]

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. Care este ordinea pipeline-ului de modelare a limbajului?

<Question
	choices={[
		{
			text: "Primul, modelul, care gestionează textul și returnează predicții brute. Apoi, tokenizatorul interpretează aceste predicții și le convertește înapoi în text atunci când este necesar.",
			explain: "Modelul nu poate înțelege textul! Tokenizatorul trebuie mai întâi să tokenizeze textul și să îl convertească în ID-uri, astfel încât să poată fi înțeles de model."
		},
		{
			text: "Primul este tokenizatorul, care gestionează textul și returnează ID-uri. Modelul gestionează aceste ID-uri și generează o predicție, care poate fi un text.",
			explain: "Predicția modelului nu poate fi transformată imediat în text. Trebuie utilizat tokenizatorul pentru a converti predicția înapoi în text!"
		},
		{
			text: "Tokenizatorul gestionează textul și returnează ID-uri. Modelul gestionează aceste ID-uri și generează o predicție. Tokenizatorul poate fi apoi utilizat din nou pentru a converti aceste predicții înapoi în text.",
			explain: "Corect! Tokenizatorul poate fi utilizat atât pentru tokenizare, cât și pentru de-tokenizare.",
            correct: true
		}
	]}
/>

### 2. Câte dimensiuni are tensorul generat de modelul Transformer și care sunt acestea?

<Question
	choices={[
		{
			text: "2: Lungimea secvenței și mărimea lotului",
			explain: "Fals! Tensor-ul generat de model are a treia dimensiune: mărimea ascunsă."
		},
		{
			text: "2: Lungimea secvenței și mărimea ascunsă",
			explain: "Fals! Toate modelele Transformer gestionează loturi, chiar și cu o singură secvență; aceasta ar fi o dimensiune a lotului de 1!"
		},
		{
			text: "3: Lungimea secvenței, dimensiunea lotului și dimensiunea ascunsă",
			explain: "Corect!",
            correct: true
		}
	]}
/>

### 3. Care dintre următoarele este un exemplu de tokenizare a cuvintelor secundare?

<Question
	choices={[
		{
			text: "WordPiece",
			explain: "Da, acesta este un exemplu de tokenizare a cuvintelor secundare!",
            correct: true
		},
		{
			text: "Tokenizare bazată pe caractere",
			explain: "Tokenizarea bazată pe caractere nu este un tip de tokenizare a cuvintelor secundare."
		},
		{
			text: "Separarea pe baza spațiului și a punctuației",
			explain: "Corect, aceasta este o schemă de tokenizare bazată pe cuvinte!"
		},
		{
			text: "BPE",
			explain: "Da, acesta este un exemplu de tokenizare a cuvintelor secundare!",
            correct: true
        },
		{
			text: "Unigram",
			explain: "Da, acesta este un exemplu de tokenizare a cuvintelor secundare!",
            correct: true
        },
		{
			text: "Nimic din cele de mai sus",
			explain: "Incorect!"
        }
	]}
/>

### 4. Ce este un model head?

<Question
	choices={[
		{
			text: "O componentă a rețelei Transformer de bază care redirecționează tensorii către straturile lor corecte",
			explain: "Incorect! Nu există o astfel de componentă."
		},
		{
			text: "Cunoscut și sub denumirea de mecanism de auto-atenție, acesta adaptează reprezentarea unui token în funcție de celelalte token-uri din secvență",
			explain: "Incorect! Layerul de auto-atenție conține „heads” de atenție, dar nu acestea sunt adaptation heads."
		},
		{
			text: "O componentă suplimentară, alcătuită de obicei din unul sau mai multe straturi, pentru a converti predicțiile transformatorului într-o sarcină specifică de ieșire",
			explain: "Corect. Adaptation heads (sau simplu heads) apar în diverse forme: language modeling heads, question answering heads, sequence classification heads...",
			correct: true
		} 
	]}
/>

{#if fw === 'pt'}
### 5. Ce este un AutoModel?

<Question
	choices={[
		{
			text: "Un model care se antrenează automat pe baza datelor dumneavoastră",
			explain: "Incorect. Poate îl confundați cu produsul nostru <a href='https://huggingface.co/autotrain'>AutoTrain</a>?"
		},
		{
			text: "Un obiect care returnează arhitectura corespunzătoare bazată pe checkpoint.",
			explain: "Exact: <code>AutoModel</code> are nevoie doar să știe checkpoint-ul din care să se inițializeze pentru a returna arhitectura corectă.",
			correct: true
		},
		{
			text: "Un model care detectează automat limba utilizată pentru intrările sale pentru a încărca ponderile corecte",
			explain: "Incorect; deși unele checkpoint-uri și modele pot gestiona mai multe limbi, nu există instrumente integrate pentru selectarea automată a checkpoint-ului în funcție de limbă. Ar trebui să consultați <a href='https://huggingface.co/models'>Model Hub</a> pentru a găsi cel mai bun checkpoint pentru sarcina dumneavoastră!"
		} 
	]}
/>

{:else}
### 5. Ce este un TFAutoModel?

<Question
	choices={[
		{
			text: "Un model care se antrenează automat pe baza datelor dumneavoastră",
			explain: "Incorect. Poate îl confundați cu produsul nostru <a href='https://huggingface.co/autotrain'>AutoTrain</a>?"
		},
		{
			text: "Un obiect care returnează arhitectura corespunzătoare bazată pe checkpoint",
			explain: "Exact: <code>TFAutoModel</code> are nevoie doar să știe checkpoint-ul din care să se inițializeze pentru a returna arhitectura corectă.",
			correct: true
		},
		{
			text: "Un model care detectează automat limba utilizată pentru intrările sale pentru a încărca ponderile corecte",
			explain: "Incorect; deși unele checkpoint-uri și modele pot gestiona mai multe limbi, nu există instrumente integrate pentru selectarea automată a checkpoint-ului în funcție de limbă. Ar trebui să consultați <a href='https://huggingface.co/models'>Model Hub</a> pentru a găsi cel mai bun checkpoint pentru sarcina dumneavoastră!"
		} 
	]}
/>

{/if}

### 6. Care sunt tehnicile de care trebuie să țineți cont atunci când grupați secvențe de diferite lungimi?

<Question
	choices={[
		{
			text: "Trunchierea",
			explain: "Da, trunchierea este o modalitate corectă de a uniformiza secvențele astfel încât acestea să se încadreze într-o formă dreptunghiulară. Este totuși singura modalitate?",
			correct: true
		},
		{
			text: "Returning tensors",
			explain: "Deși celelalte tehnici vă permit să returnați tensori dreptunghiulari, doar a returna tensori nu ajută când combinați secvențele într-un lot."
		},
		{
			text: "Padding",
			explain: "Da, padding-ul este o modalitate corectă de a egaliza secvențele, astfel încât să se potrivească într-o formă dreptunghiulară. Este, însă, singura?",
			correct: true
		}, 
		{
			text: "Attention masking",
			explain: "Absolut! Măștile de atenție sunt extrem de importante atunci când gestionați secvențe de lungimi diferite. Totuși, nu este singura tehnică de care trebuie să țineți cont.",
			correct: true
		} 
	]}
/>

### 7. Care este scopul aplicării unei funcții SoftMax asupra logit-urilor produse de un model de clasificare a secvențelor?

<Question
	choices={[
		{
			text: "Le atenuează logiturile pentru a fi mai de încredere.",
			explain: "Nu, funcția SoftMax nu afectează fiabilitatea rezultatelor."
		},
		{
			text: "Aplică o limită inferioară și superioară astfel încât valorile să fie inteligibile.",
			explain: "Corect! Valorile rezultate sunt cuprinse între 0 și 1. Totuși, nu este singurul motiv pentru care folosim o funcție SoftMax.",
            correct: true
		},
		{
			text: "Suma totală a ieșirii devine 1, ducând la o interpretare probabilistică posibilă.",
			explain: "Corect! Totuși, nu este singurul motiv pentru care folosim o funcție SoftMax.",
            correct: true
		}
	]}
/>

### 8. În jurul cărei metode se concentrează cea mai mare parte a API-ului tokenizer?

<Question
	choices={[
		{
			text: "<code>encode</code>, deoarece poate codifica textul în ID-uri și ID-urile în predicții",
			explain: "Greșit! Deși metoda <code>encode</code> există pe tokenizers, ea nu există pe modele."
		},
		{
			text: "Apelarea directă a obiectului tokenizer.",
			explain: "Exact! Metoda <code>__call__</code> a tokenizatorului este foarte puternică și poate gestiona aproape orice. Este și metoda folosită pentru a obține predicții de la un model.",
			correct: true
		},
		{
			text: "<code>pad</code>",
			explain: "Greșit! Padding-ul este foarte util, dar este doar o parte a API-ului tokenizer."
		},
		{
			text: "<code>tokenize</code>",
			explain: "Metoda <code>tokenize</code> este, fără îndoială, una dintre cele mai utile, dar nu reprezintă nucleul API-ului tokenizer."
		}
	]}
/>

### 9. Ce conține variabila `result` în acest exemplu de cod?

```py
from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
result = tokenizer.tokenize("Hello!")
```

<Question
	choices={[
		{
			text: "O listă de șiruri de caractere, fiecare șir fiind un token",
			explain: "Desigur! Convertiți aceste șiruri în ID-uri și transmiteți-le către un model!",
            correct: true
		},
		{
			text: "O listă de ID-uri",
			explain: "Incorect; pentru asta folosim metoda <code>__call__</code> sau <code>convert_tokens_to_ids</code>!"
		},
		{
			text: "Un șir care conține toate token-urile",
			explain: "Nu ar fi optim, deoarece scopul este de a separa șirul inițial în mai multe token-uri."
		}
	]}
/>

{#if fw === 'pt'}
### 10. Este ceva greșit în următorul cod?

```py
from transformers import AutoTokenizer, AutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = AutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Nu, pare corect.",
			explain: "Din păcate, asocierea unui model cu un tokenizator care a fost antrenat cu un alt checkpoint rareori este o idee bună. Modelul nu a fost antrenat să interpreteze ieșirea acestui tokenizator, așa că ieșirea modelului (dacă va rula chiar!) nu va avea sens."
		},
		{
			text: "Tokenizerul și modelul trebuie să provină întotdeauna din același checkpoint.",
			explain: "Corect!",
            correct: true
		},
		{
			text: "Este o bună practică să folosiți trunchierea și padding-ul cu tokenizatorul, întrucât fiecare intrare este un lot.",
			explain: "Este adevărat că orice intrare de model are nevoie să fie sub formă de lot. Totuși, trunchierea sau padding-ul acestei secvențe nu ar avea neapărat sens deoarece este singura intrare, iar aceste tehnici se folosesc pentru a trata o listă de propoziții."
		}
	]}
/>

{:else}
### 10. Este ceva greșit în următorul cod?

```py
from transformers import AutoTokenizer, TFAutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = TFAutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Nu, pare corect.",
			explain: "Din păcate, asocierea unui model cu un tokenizator care a fost antrenat cu un alt checkpoint rareori este o idee bună. Modelul nu a fost antrenat să interpreteze ieșirea acestui tokenizator, așa că ieșirea modelului (dacă va rula chiar!) nu va avea sens."
		},
		{
			text: "Tokenizerul și modelul trebuie să provină întotdeauna din același checkpoint.",
			explain: "Corect!",
            correct: true
		},
		{
			text: "Este o bună practică să folosiți trunchierea și padding-ul cu tokenizatorul, întrucât fiecare intrare este un lot.",
			explain: "Este adevărat că orice intrare de model trebuie să fie sub formă de batch. Totuși, trunchierea sau padding-ul acestei secvențe nu ar avea neapărat sens deoarece este singura intrare, iar aceste tehnici se folosesc pentru a grupa o listă de propoziții într-un batch."
		}
	]}
/>

{/if}

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter2/9.mdx" />