# Partajarea modelelor preantrenate[[sharing-pretrained-models]]

{#if fw === 'pt'}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter4/section3_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter4/section3_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter4/section3_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter4/section3_tf.ipynb"},
]} />

{/if}

În următoarele etape, vom explora modalitățile cele mai ușoare de a partaja modelele preantrenate pe 🤗 Hub. Există tooluri și utilities disponibile care fac posibilă partajarea și actualizarea modelelor direct pe Hub, despre care vom vorbi mai jos.

<Youtube id="9yY3RB_GSPM"/>

Recomandăm tuturor utilizatorilor care antrenează modele să contribuie prin partajarea lor cu comunitatea - partajarea modelelor, chiar și atunci când sunt antrenate pe dateseturi foarte specifice, va ajuta la economisind timpul altor utilizatori și resurselor și va oferi acces la artefacte antrenate folositoare. În schimb, puteți beneficia de munca altora!

Există trei moduri de a crea noi repositorii cu modele:

- Utilizând API-ul `push_to_hub`
- Utilizând biblioteca Python `huggingface_hub`
- Utilizând interfața web

Odată ce aveți creat un repository, puteți încărca fișiere în el folosind git și git-lfs. Vom trece împreună prin crearea model repositories și încărcarea fișierelor în el în următoarele secțiuni.


## Utilizând API-ul `push_to_hub`[[using-the-pushtohub-api]]

{#if fw === 'pt'}

<Youtube id="Zh0FfmVrKX0"/>

{:else}

<Youtube id="pUh5cGmNV8Y"/>

{/if}

Cea mai simplă modalitate de a încărca fișiere pe Hub este utilizând API-ul `push_to_hub`.

Înainte de a continua, aveți nevoie să creați un token de autentificare astfel încât API-ul `huggingface_hub` să știe cine sunteți și care sunt namespaces la care aveți acces de scriere. Asigurați-vă că sunteți într-un environment unde aveți instalat `transformers` (vedeti [Configurarea](/course/chapter0)). Dacă sunteți într-un notebook, puteți folosi următoarea funcție pentru a vă autentifica:

```python
from huggingface_hub import notebook_login

notebook_login()
```

În terminal, puteți rula următoarea comandă:

```bash
huggingface-cli login
```

În ambele cazuri, veți fi rugați să introduceți numele utilizatorului și parola, care sunt aceleași cu cele folosite la autentificare pe Hub. Dacă nu aveți încă un profil pe Hub, vă rugăm să creați unul [aici](https://huggingface.co/join).

Excelent! Acum aveți tokenul de autentificare stocat în folder-ul cache. Vom crea acum niște repositorii!

{#if fw === 'pt'}

Dacă ați lucrat cu API-ul `Trainer` pentru a antrena un model, cea mai ușoară modalitate de a o încărca pe Hub este să setați `push_to_hub=True` când definiți `TrainingArguments`:

```py
from transformers import TrainingArguments

training_args = TrainingArguments(
    "bert-finetuned-mrpc", save_strategy="epoch", push_to_hub=True
)
```

Când chemați `trainer.train()`, `Trainer` va încărca modelul pe Hub de fiecare dată când este salvat (aici, la fiecare epocă) într-un repository namespace-ul tău. Acest repository va fi numit după output directory-ul ales (aici `bert-finetuned-mrpc`), dar puteți alege un alt nume cu `hub_model_id = "un_nume_diferit"`.

Pentru a încărca modelul într-o organizație din care faceți parte, este suficient să introduceți aceasta în `hub_model_id = "organizația_mea/numele_repositoriului"`.

Odată ce antrenarea s-a terminat, trebuie să faceți `trainer.push_to_hub()` pentru a încărca ultima versiune a modelului. Acesta va genera apoi un model card cu toate informațiile relevante, inclusiv metadatele despre hyperparametrii utilizați și rezultatele evaluării! Aici este exemplul unui astfel de model card:

<div class="flex justify-center">
  <img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/model_card.png" alt="Un exemplu de un card auto-generat." width="100%"/>
</div>

{:else}

Dacă utilizați Keras pentru a antrena modelul dumneavoastră, cea mai ușoară modalitate de a încărca-o pe Hub este să transmiteți un `PushToHubCallback` când chemați `model.fit()`:

```py
from transformers import PushToHubCallback

callback = PushToHubCallback(
    "bert-finetuned-mrpc", save_strategy="epoch", tokenizer=tokenizer
)
```

Apoi, adăugați `callbacks=[callback]` în apelul la `model.fit()`. Callback-ul va încărca apoi modelul pe Hub de fiecare dată când se salvează (aici, la fiecare epocă) într-un repository din namespace-ul tău. Acest repository va fi numit după output directory ales (aici `bert-finetuned-mrpc`), dar puteți alege un alt nume cu `hub_model_id = "un_nume_diferit"`.

Pentru a încărca modelul într-o organizație din care faceți parte, este suficient să introduceți aceasta în `hub_model_id = "organizația_mea/numele_repositoriului"`.

{/if}

La un nivel inferior, accesarea Hub-ului se poate face direct pe modele, tokenizers și configurations objects prin metoda `push_to_hub()`. Această metodă se ocupă atât de crearea repositoriului cât si de încărcarea modelului și tokenizerului direct în el. Nu este nevoie de o interacțiune manuală, precum fața de API-ul pe care îl vom vedea mai jos.

Pentru a înțelege cum funcționează, luați în considerare inițializarea unui model și a unui tokenizer:

{#if fw === 'pt'}
```py
from transformers import AutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = AutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
```
{:else}
```py
from transformers import TFAutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = TFAutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
```
{/if}

Sunteți liberi să faceți orice ați vrea cu acestea - adăugați tokens la tokenizer, antrenați modelul sau faceți fine-tune. Odată ce sunteți mulțumiți de modelul obținut, weighturile și tokenizerul acestuia , puteți folosi metoda `push_to_hub()` disponibilă direct pe obiectul `model`:

```py
model.push_to_hub("dummy-model")
```
Acest lucru va crea un nou repository `dummy-model` în profilul tău și o va popula cu fișierele modelului tău.
Încercați același lucru cu tokenizerul, astfel încât toate fișierele să fie acum disponibile în acest repository:

```py
tokenizer.push_to_hub("dummy-model")
```

Dacă aparțineți unei organizații, specificați doar argumentul `organization` pentru a încărca în namespace-ul acestei organizații:

```py
tokenizer.push_to_hub("dummy-model", organization="huggingface")
```

Dacă doriți să utilizați un anumit token Hugging Face, sunteți liberi să specificați acest lucru metodei `push_to_hub()`:

```py
tokenizer.push_to_hub("dummy-model", organization="huggingface", use_auth_token="<TOKEN>")
```

Acum, mergeți la Model Hub pentru a găsi modelul încărcat: *https://huggingface.co/user-or-organization/dummy-model*.

Apăsați pe tabul "Files and versions", iar acum ar trebui să vedeți fișierele vizibile în următorul screenshot:

{#if fw === 'pt'}
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/push_to_hub_dummy_model.png" alt="Dummy model containing both the tokenizer and model files." width="80%"/>
</div>
{:else}
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/push_to_hub_dummy_model_tf.png" alt="Dummy model containing both the tokenizer and model files." width="80%"/>
</div>
{/if}

<Tip>

✏️ **Încercați!** Luați modelul și tokenizerul asociat cu checkpointul `bert-base-cased` și încărcați-l pe un repo în namespace-ul tău folosind metoda `push_to_hub()`. Verificați că repo-ul apare  în pagina dumneavoastră înainte de a-l șterge.

</Tip>

Ați văzut că metoda `push_to_hub()` acceptă mai multe argumente, ceea ce permite încărcarea într-un repository specific sau namespace al unei organizații, sau utilizarea unui token API diferit. Vă recomandăm să vă uitați la specificația metodei disponibilă direct în [documentația 🤗 Transformers](https://huggingface.co/transformers/model_sharing) pentru a înțelge ceea ce este posibil.

Metoda `push_to_hub()` este backed de packageul Python [`huggingface_hub`](https://github.com/huggingface/huggingface_hub), care oferă un API direct la Hub-ul Hugging Face. Acesta este integrat în 🤗 Transformers și în mai multe biblioteci pentru machine learning, ca de exemplu [`allenlp`](https://github.com/allenai/allennlp). Deși ne concentrăm pe integrarea în 🤗 Transformers în acest capitol, integrarea sa în propriul dumneavoastră cod sau bibliotecă este simplu.

Săriți la ultima secțiune pentru a vedea cum să încărcați fișierele în noul repository-ul creat!

## Utilizarea bibliotecii Python `huggingface_hub`[[using-the-huggingfacehub-python-library]]

Biblioteca Python `huggingface_hub` este un package care oferă un set de instrumente pentru model și datasets hubs. Oferă metode simple și clase pentru sarcini comune ca 
obținerea informațiilor despre repositorii pe hub și gestionarea lor. Oferă API-uri simple care lucrează pe lângă git pentru a gestiona conținutul acestor repositorii și integrarea Hub-ului
în proiectele și bibliotecile tale.

Similar cu utilizarea API-ului `push_to_hub`, asta va necesita un token de autentificare salvat în cache. Pentru a face acest lucru, veți avea nevoie să folosiți comanda `login` din CLI, cum am menționat în secțiunea anterioară (din nou, asigurați-vă prefixați această comandă cu simbolul `!` dacă rulați în Google Colab):

```bash
huggingface-cli login
```

Packageul `huggingface_hub` oferă mai multe metode și clase utile pentru noi. În primul rând, există câteva metode pentru crearea, ștergerea și gestionarea repositoriilor:

```python no-format
from huggingface_hub import (
    # Gestionarea utilizatorilor
    login,
    logout,
    whoami,

    # Crearea și gestionarea repositoriilor
    create_repo,
    delete_repo,
    update_repo_visibility,

    # Și câteva metode pentru a obține/schimba informațiile despre conținut
    list_models,
    list_datasets,
    list_metrics,
    list_repo_files,
    upload_file,
    delete_file,
)
```




De asemenea, el oferă clasa foarte puternică `Repository` pentru gestionarea unei repository local. Vom explora aceste metode și clasa în următoarele secțiuni pentru a înțelege cum să le utilizați.

Metoda `create_repo` poate fi utilizată pentru crearea unui nou repository în hub:

```py
from huggingface_hub import create_repo

create_repo("dummy-model")
```

Acesta va crea repositarul `dummy-model` în namespace-ul tău. Dacă doriți, puteți specifica care organizație să aparțină repositoriului folosind argumentul `organization`:

```py
from huggingface_hub import create_repo

create_repo("dummy-model", organization="huggingface")
```

Acesta va crea repositoriul `dummy-model` în spațiul organizației `huggingface`, cu condiția că dumneavoastră să apartineți acestei organizații.
Alte argumente care pot fi utile sunt:

- `private`, pentru a specifica dacă repositarul trebuie să fie vizibil celorlați sau nu.
- `token`, dacă doriți să vă înlocuiți token-ul stocat în cache cu un anumit token.
- `repo_type`, dacă doriți să creați un `dataset` sau `space` în loc de model. Valorile acceptate sunt `"dataset"` și `"space"`.

Odată ce repositoriul este creat, trebuie să adăugați fișierele în el! Săriți la secțiunea următoare pentru a vedea cele trei moduri în care se poate face acest lucru.

## Utilizarea interfeței web[[using-the-web-interface]]

Interfața web oferă instrumente pentru a gestiona repositorii direct în Hub. Cu ajutorul acestei interfețe, puteți crea ușor repositorii, adăuga fișiere (și chiar și fișiere mari!), explora modele, vizualiza diffuri, și multe altele.

Pentru a crea un nou repositoriu, vizitați [huggingface.co/new](https://huggingface.co/new):

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/new_model.png" alt="Pagină care prezintă modelul utilizat pentru crearea unui nou repository." width="80%"/>
</div>

În primul rând, specificați deținătorul repositoriului: acesta puteți fi fie dumneavoastră, fie orice organizație cu care sunteți afiliat. Dacă alegeți o organizație, modelul va fi prezent pe pagina organizației și toți membrii acesteia vor avea posibilitatea să contribuie la repositoriu.

În al doilea rând, introduceți numele modelului dumneavoastră. Acest lucru va fi și denumirea repositoriului. În final, puteți specifica dacă doriți ca modelul dumneavoastră să fie public sau privat. Modelele private nu sunt vizibile ceilorlalți.

După crearea repositoriului, ar trebui să vedeți o pagină ca aceasta:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/empty_model.png" alt="O pagină goală a modelului după crearea unui nou repository." width="80%"/>
</div>

Acesta este locul unde va fi găzduit modelul. Pentru a începe să populați acesta, puteți adăuga un fișier README direct din interfața web.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/dummy_model.png" alt="Fișierul README care arată capacitățile Markdown." width="80%"/>
</div>

Fișierul README este scris în format Markdown - vă rugăm să fiți creativi cu el! A treia parte a acestui capitol se ocupă de crearea unui model card. Acestea sunt foarte importante pentru a aduce valoare modelului dumneavoastră, deoarece este acolo unde spuneți celorlalți ce poate face.

Dacă vă uitați la secțiunea "Fișiere și versiuni", veți vedea că nu sunt prea multe fișiere acolo încă - doar *README.md* pe care l-ați creat dumneavoastră și *.gitattributes* care urmărește fișierele mari.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/files.png" alt="Secțiunea 'Fișiere și versiuni' arată doar fișierul .gitattributes și README.md." width="80%"/>
</div>

Vom vedea mai târziu cum să adăugați câteva fișiere noi.

## Încărcarea fișierelor modelului[[uploading-the-model-files]]

Sistemul pentru a gestiona fișierele în Hugging Face Hub se bazează pe git pentru fișierele obișnuite, și pe git-lfs (care se descrifrează ca [Git Large File Storage](https://git-lfs.github.com/)) pentru fișierele mai mari.

În secțiunea următoare, vom discuta despre trei metode diferite de încărcare a fișierelor în Hub: prin `huggingface_hub` și prin comanda git.

### Metoda `upload_file`[[the-uploadfile-approach]]

Prin `upload_file` nu este necesar să instalați git și git-lfs pe sistemul dumneavoastră. Acest lucru încarcă direct fișierele în 🤗 Hub folosind HTTP POST requests. O limitare a acestei metode este că ea nu se ocupă de fișiere care sunt mai mari de 5GB.
Dacă fișierele dumneavoastră sunt mai mari decât 5 GB, vă rugăm să urmați celelalte două metode descrise mai jos.

API-ul poate fi folosit astfel:

```py
from huggingface_hub import upload_file

upload_file(
    "<path_to_file>/config.json",
    path_in_repo="config.json",
    repo_id="<namespace>/dummy-model",
)
```

Acest lucru va încărca fișierul `config.json` disponibil la `<path_to_file>` la rootul repositoriului ca `config.json`, în `dummy-model` repository.
Alte argumente utile pot fi:

- `token`, dacă doriți să înlocuiți tokenul stocat în cache cu un alt token.
- `repo_type`, dacă doriți să încărcați într-un `dataset` sau într-un `space` în locul modelului. Valorile acceptate sunt `"dataset"` și `"space"`.

### Clasa `Repository`[[the-repository-class]]

Clasa `Repository` gestionează un repository local în-tro manieră asemănătoare gitului. Ea abstracționează majoritatea problemelor pe care le întâlniți cu git pentru a oferi toate caracteristicile necesare.

Utilizarea acestei clase necesită ca dumneavoastră să aveți instalat git și git-lfs, așadar asigurați-vă că aveți instalat git-lfs (vezi [aici](https://git-lfs.github.com/) pentru instrucțiunile de instalare) și setat înainte de a începe.

Pentru a vă juca cu repositoriul pe care l-am creat, puteți porni prin inițializarea lui ca un folder local printr-un clonarea repositoriului remote:

```py
from huggingface_hub import Repository

repo = Repository("<path_to_dummy_folder>", clone_from="<namespace>/dummy-model")
```

Acesta a creat folderele `<path_to_dummy_folder>` în folderul de lucru. Acest folder conține doar fișierul `.gitattributes` pentru că acesta este singurul fișier creat atunci când inițializați repositoriul prin `create_repo`.

Acum puteți folosi majoritatea metodelor tradiționale ale gitului:

```py
repo.git_pull()
repo.git_add()
repo.git_commit()
repo.git_push()
repo.git_tag()
```

Și altele! Vă recomandăm să vă uitați la documentația `Repository` disponibilă [aici](https://github.com/huggingface/huggingface_hub/tree/main/src/huggingface_hub#advanced-programmatic-repository-management) pentru o înțelegere generală a tuturor metodelor disponibile.

Pentru moment, avem un model și un tokenizer pe care doriți să îl trimiteți în hub. Am reușit să clonăm repositoriul local, deci putem salva fișierele în acesta.

În primul rând asigurați-vă că copia locală este la zi cu ultimele schimbări:

```py
repo.git_pull()
```

Odată ce am facut asta, salvați fișierele modelului și al tokenizerul:

```py
model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```

Folder-ul `<path_to_dummy_folder>` acum conține toate fișierele modelului dumneavoastră și ale tokenizerul. Vom urma fluxul tradițional de git adăugând fișiere în zona de pregătire, făcând commit și push fișierelor în hub:

```py
repo.git_add()
repo.git_commit("Adăugarea fișierelor modelului și ale tokenizerului")
repo.git_push()
```

Felicitări! Ați reușit să încărcați primele fișiere în hub.

### Folosirea Git[[the-git-based-approach]]

Acesta este abordarea cea mai de bază pentru încărcarea fișierelor: vom face asta cu ajutorul git și git-lfs direct. Cea mai grea parte este abstractizată prin abordări anterioare, dar există câteva excepții cu metoda următoare, așadar ne vom referi la un use-case mai complicat.

Pentru această clasă se cere să aveți instalate git și git-lfs, așadar asigurați-vă că aveți [git-lfs](https://git-lfs.github.com/) instalat (vedeți aici instrucțiunile de instalare) și configurat înainte să începeți.

În primul rând, inițializați git-lfs:

```bash
git lfs install
```

```bash
Updated git hooks.
Git LFS initialized.
```

După ce ați făcut acest lucru, primul pas este să faceți o copie a repositoriului dumneavoastră:

```bash
git clone https://huggingface.co/<namespace>/<your-model-id>
```

Numele meu de utilizator este `lysandre` și am folosit numele modelului `dummy`, așadar comanda mea se termină cu următorul rezultat:

```
git clone https://huggingface.co/lysandre/dummy
```

Acum am un folder denumit *dummy* în folderul meu de lucru. Pot intra în folder cu ajutorul `cd` și pot examina conținutul:

```bash
cd dummy && ls
```

```bash
README.md
```

Dacă ați creat repositoriul dumneavoastră folosind metodă din partea Hugging Face Hub, `create_repo` , acest folder ar trebui să conțină doar un fișier cu numele *.gitattributes*. Dacă ați urmat instrucțiunile din secțiunea anterioară pentru crearea repositoriului folosind interfața web, atunci folderul ar trebui să conțină un singur fișier *README.md* și, de asemenea, un fișier cu numele *.gitattributes*, pe care nu-l puteți vedea.

Adăugarea unui fișier de mărime obișnuită, precum un fișier de configurare, un vocabulary file sau orice alt tip de fișier care au mai puțin de câțiva megabytes se realizează exact așa cum ați face în orice sistem git. Cu toate acestea, pentru a încărca fișiere mai mari, este necesară utilizarea a git-lfs pentru a le trimite spre *huggingface.co*.

Să ne întoarcem la Python pentru a genera un model și tokenizer pe care am dori să le facem commit în repositoriul nostru dummy:

{#if fw === 'pt'}
```py
from transformers import AutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = AutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

# Faceți orice cu modelul, antrenați-l, aplicați fine-tuning...

model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```
{:else}
```py
from transformers import TFAutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = TFAutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

# Faceți orice cu modelul, antrenați-l, aplicați fine-tuning...

model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```
{/if}

Acum am salvat câteva artefacte de model și tokenizer, așadar să examinăm din nou folderul *dummy*:

```bash
ls
```

{#if fw === 'pt'}
```bash
config.json  pytorch_model.bin  README.md  sentencepiece.bpe.model  special_tokens_map.json tokenizer_config.json  tokenizer.json
```
Dacă priviți la dimensiunile fișierelor (de exemplu, folosind `ls -lh`), ar trebui să vedeți că singurul outlier este model state dict file (*pytorch_model.bin*), care are mai mult de 400 MB.

{:else}
```bash
config.json  README.md  sentencepiece.bpe.model  special_tokens_map.json  tf_model.h5  tokenizer_config.json  tokenizer.json
```
Dacă priviți la dimensiunile fișierelor (de exemplu, folosind `ls -lh`), ar trebui să vedeți că singurul outlier este model state dict file (*tf_model.h5*), care are mai mult de 400 MB.

{/if}

<Tip>
✏️ Dacă creați repositoriul folosind interfața web, fișierul *.gitattributes* va fi automat configurat pentru a considera anumite extensii de fișiere, precum *.bin* și *.h5*, ca fiind fișiere mari. În acest caz nu este necesară nici o setare suplimentară din partea ta, pentru că git-lfs le va urmări automat.
</Tip>

Acum putem continua procesul în felul nostru obișnuit cu repositoriurile Git tradiționale. Putem adăuga toate fișierele în mediul de stocare a Git folosind comanda `git add`:

```bash
git add .
```

Puteți verifica fișierele curente care sunt în stare de stocare utilizând următoarea comandă:

```bash
git status
```


{#if fw === 'pt'}
```bash
On branch main
Your branch is up to date with 'origin/main'.

Changes to be committed:
  (use "git restore --staged <file>..." to unstage)
  modified:   .gitattributes
	new file:   config.json
	new file:   pytorch_model.bin
	new file:   sentencepiece.bpe.model
	new file:   special_tokens_map.json
	new file:   tokenizer.json
	new file:   tokenizer_config.json
```
{:else}
```bash
On branch main
Your branch is up to date with 'origin/main'.

Changes to be committed:
  (use "git restore --staged <file>..." to unstage)
  modified:   .gitattributes
	new file:   config.json
	new file:   sentencepiece.bpe.model
	new file:   special_tokens_map.json
	new file:   tf_model.h5
	new file:   tokenizer.json
	new file:   tokenizer_config.json
```
{/if}

De asemenea, putem verifica dacă git-lfs monitorizează fisierele corecte folosind comanda sa `status`:

```bash
git lfs status
```


{#if fw === 'pt'}
```bash
On branch main
Objects to be pushed to origin/main:


Objects to be committed:

	config.json (Git: bc20ff2)
	pytorch_model.bin (LFS: 35686c2)
	sentencepiece.bpe.model (LFS: 988bc5a)
	special_tokens_map.json (Git: cb23931)
	tokenizer.json (Git: 851ff3e)
	tokenizer_config.json (Git: f0f7783)

Objects not staged for commit:


```

Vom observa că toate fișierele au `Git` ca handler, cu excepția *pytorch_model.bin* și *sentencepiece.bpe.model*, care au `LFS`. Excelent!

{:else}
```bash
On branch main
Objects to be pushed to origin/main:


Objects to be committed:

	config.json (Git: bc20ff2)
	sentencepiece.bpe.model (LFS: 988bc5a)
	special_tokens_map.json (Git: cb23931)
	tf_model.h5 (LFS: 86fce29)
	tokenizer.json (Git: 851ff3e)
	tokenizer_config.json (Git: f0f7783)

Objects not staged for commit:


```

Observăm că toate fișierele au `Git` ca handler, cu excepția *tf_model.h5*, care are `LFS`. Excelent!

{/if}

Acum vom continua cu ultimii pași: commiting și pushing la repo-urile *huggingface.co*:

```
git commit -m "Prima versiune a modelului"
```


{#if fw === 'pt'}
```bash
[main b08aab1] Prima versiune a modelului
 7 files changed, 29027 insertions(+)
  6 files changed, 36 insertions(+)
 create mode 100644 config.json
 create mode 100644 pytorch_model.bin
 create mode 100644 sentencepiece.bpe.model
 create mode 100644 special_tokens_map.json
 create mode 100644 tokenizer.json
 create mode 100644 tokenizer_config.json
```
{:else}
```bash
[main b08aab1] Prima versiune a modelului
 6 files changed, 36 insertions(+)
 create mode 100644 config.json
 create mode 100644 sentencepiece.bpe.model
 create mode 100644 special_tokens_map.json
 create mode 100644 tf_model.h5
 create mode 100644 tokenizer.json
 create mode 100644 tokenizer_config.json
```
{/if}

Pushingul poate lua câteva minute, în funcție de viteza conexiunii tale la internet și mărimea fișierelor:

```bash
git push
```

```bash
Uploading LFS objects: 100% (1/1), 433 MB | 1.3 MB/s, done.
Enumerating objects: 11, done.
Counting objects: 100% (11/11), done.
Delta compression using up to 12 threads
Compressing objects: 100% (9/9), done.
Writing objects: 100% (9/9), 288.27 KiB | 6.27 MiB/s, done.
Total 9 (delta 1), reused 0 (delta 0), pack-reused 0
To https://huggingface.co/lysandre/dummy
   891b41d..b08aab1  main -> main
```

{#if fw === 'pt'}
Dacă ne uităm la repositoriul modelului când acest lucru este finalizat, putem vedea toate fișierele recent adăugate:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/full_model.png" alt="Tabul 'Files and versions' conține acum toate fișierele recente adăugate." width="80%"/>
</div>

Interfața permite explorarea fișierelor modelului și a commiturilor și vizualizarea diferenței introduse de fiecare commit:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/diffs.gif" alt="Diferența introdusă de ultimul commit." width="80%"/>
</div>
{:else}
Dacă ne uităm la repositoriul modelului când acest lucru este finalizat, putem vedea toate fișierele recent adăugate:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/full_model_tf.png" alt="Tabul 'Files and versions' conține acum toate fișierele recente adăugate." width="80%"/>
</div>

Interfața permite explorarea fișierelor modelului și a commiturilor și vizualizarea diferenței introduse de fiecare commit:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/diffstf.gif" alt="Diferența introdusă de ultimul commit." width="80%"/>
</div>
{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter4/3.mdx" />