# Quiz la final de capitol[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Să testăm ceea ce ai învățat în acest capitol!
  
### 1. La ce sunt limitate modelele din Hub?

<Question
	choices={[ 
		{
			text: "Modelele din biblioteca 🤗 Transformers.",
			explicație: "Ținând cont că modelele din biblioteca 🤗 Transformers sunt disponibile pe Hugging Face Hub, ele nu sunt singurele!"
		},
		{
			text: "Toate modelele cu o interfață similară cu 🤗 Transformers.",
			explicație: "Nu există nicio cerință de interfață când se încarcă modelele pe Hugging Face Hub."
		},
		{
			text: "Nu există limite.",
			explicație: "Adevărat! Nu există nici o limită când se încarcă modele pe Hub.",
            corect: true
		},
        {
			text: "Modele care, într-o anumită măsură, sunt legate de NLP.",
			explicație: "Nu există nicio cerință privind domeniul aplicației!"
		}
	] }
/>

### 2. Cum poți gestiona modelele pe Hub?

<Question
	choices={[ 
		{
			text: "Printr-un cont GCP.",
			explicație: "Greșit! "
		},
		{
			text: "Prin distribuția peer-to-peer.",
			explicație: "Greșit!"
		},
		{
			text: "Prin git și git-lfs.",
			explicație: "Corect! Modelele din Hub sunt simple repositorii Git, care utilizează <code>git-lfs</code> pentru fișiere mari.",
            corect: true
		}
	] }
/>

### 3. Ce poți face utilizând interfața web a Hugging Face Hub?

<Question
	choices={[ 
		{
			text: "Forkingul unui repositoriu existent.",
			explicație: "Nu se poate face forking la un repositoriu pe Hugging Face Hub."
		},
		{
			text: "Crearea unui nou model repository.",
			explicație: "Corect! Dar nu este singurul lucru pe care îl poți face...",
            corect: true
		},
		{
			text: "Gestionarea și editarea fișierelor.",
			explicație: "Corect! Dar nuu este singurul lucru pe care îl poți face...",
            correct: true
		},
        {
			text: "Încărcarea de fișiere.",
			explicație: "Corect! Dar nu este singurul lucru...",
            correct: true
		},
        {
			text: "Vizualizarea diferențelor între versiuni.",
			explicație: "Corect! Dar nu este singurul lucru pe care îl poți face...",
            corect: true
		}
	] }
/>

### 4. Ce este un model card?

<Question
	choices={[ 
		{
			text: "O descriere a modelului, deci mai puțin importantă decât fișierele model și tokenizer.",
			explicație: "Este într-adevăr o descriere a modelului, dar este un element important. Dacă descrierea nu este completă sau absentă, utilitatea modelului se reduce drastic."
		},
		{
			text: "Un mod de asigurare a reproducerii, reutilizării și egalității.",
			explicație: "Corect! Oferirea informațiilor adecvate în model card va ajuta utilizatorii să utilizeze modelul și să fie conștienți de limitele și biasurile acestuia. ",
            corect: true
		},
		{
			text: "Un fișier Python care poate fi rulat pentru a obține informații despre model.",
			explicație: "Model cardurile sunt simple fișiere Markdown."
		}
	] }
/>

Chapitru 4

### 5. Câte dintre obiectele bibliotecii 🤗 Transformers pot fi împărtășite direct pe Hub cu `push_to_hub()`?

{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "Un tokenizer",
			explain: "Corect! Toți tokenizerii au metoda <code>push_to_hub</code>, și utilizând-o, vor împărtăși toate fișierele tokenizerului (vocabular, arhitectură tokenizerului, etc.) către un repo. Însă acesta nu este singura soluție corectă!",
            correct: true
		},
		{
			text: "O configurare a modelului",
			explain: "Corect! Toate configurațiile modelelor au metoda <code>push_to_hub</code>, și utilizând-o, vor împărtăși configurația către un repo. Și ce altceva poți oferi?",
            correct: true
		},
		{
			text: "Un model",
			explain: "Corect! Toate modelele au metoda <code>push_to_hub</code>, și utilizând-o, vor împărtăși ei, precum și fișierele de configurare către un repo. Și nu numai asta!",
            correct: true
		},
        {
			text: "Un Trainer",
			explain: "Corect — <code>Trainer</code> implementează metoda <code>push_to_hub</code>, și utilizând-o, vor încărca modelul, configurarea sa, tokenizerul, precum și un draft a unui model card către un repo. Încearcă și altă opțiune!",
            correct: true
		}
	]}
/>

{:else}
<Question
	choices={[
		{
			text: "Un tokenizer",
			explain: "Corect! Toți tokenizerii au metoda <code>push_to_hub</code>, și utilizând-o, vor împărtăși toate fișierele tokenizerului (vocabular, arhitectură tokenizerului, etc.) către un repo. Însă acesta nu este singura soluție corectă!",
            correct: true
		},
		{
			text: "O configurare a modelului",
			explain: "Corect! Toate configurațiile modelelor au metoda <code>push_to_hub</code>, și utilizând-o, vor împărtăși configurația către un repo. Și ce altceva poți oferi?",
            correct: true
		},
		{
			text: "Un model",
			explain: "Corect! Toate modelele au metoda <code>push_to_hub</code>, și utilizând-o, vor împărtăși ei, precum și fișierele de configurare către un repo. Și nu numai asta!",
            correct: true
		},
        {
			text: "Toate cele trei cu un callback dedicat",
			explain: "Corect — <code>PushToHubCallback</code> va trimite regular toate aceste obiecte către un repo în timpul antrenării.",
            correct: true
		}
	]}
/>
{/if}

### 6. Care este primul pas atunci când utilizați metoda `push_to_hub()` sau instrumentele CLI?

<Question
	choices={[
		{
			text: "Logarea pe website",
			explain: "Acest lucru nu vă va ajuta local."
		},
		{
			text: "Rulați 'huggingface-cli login' în terminal.",
			explain: "Corect — acest lucru va descărca și va stoca tokenul personal.",
            correct: true
		},
		{
			text: "Rulați 'notebook_login()' într-un notebook",
			explain: "Corect — acest lucru va afișa un widget pentru a vă autentifica.",
            correct: true
		},
	]
    }
/>


### 7. Aveți un model și un tokenizer, cum le puteți încărca pe ambele în Hub?

<Question
	choices={[
		{
			text: "Prin apelarea directă a metodei `push_to_hub` pe model și tokenizer",
			explain: "Corect!",
            correct: true
		},
		{
			text: "În cadrul runtime-ului Python, prin wrappingul acestora într-un <code>huggingface_hub</code>",
			explain: "Modelele și tokenizerii deja beneficiază de utilitățile <code>huggingface_hub</code>: nu vă trebuie nici un wrapping suplimentar!"
		},
		{
			text: "Prin salvarea lor pe disc și apelarea <code>transformers-cli upload-model</code>",
			explain: "Comanda <code>upload-model</code> nu există."
		}
	]}
/>

### 8. Ce operații git poți face cu clasa `Repository`?

<Question
	choices={[
		{
			text: "Un commit",
			explain: "Corect, metoda <code>git_commit()</code> este acolo pentru a face commit.",
            correct: true
		},
		{
			text: "Un pull",
			explain: "Acesta este scopul metodei <code>git_pull()</code>",
            correct: true
		},
		{
			text: "Un push",
			explain: "Metoda <code>git_push()</code> face acest lucru.",
            correct: true
		},
		{
			text: "Un merge",
			explain: "Nu, această operație nu va fi niciodată posibilă cu acest API."
		}
	]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter4/6.mdx" />