# Quiz de sfârșit de capitol[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={6}
    classNames="absolute z-10 right-0 top-0"
/>

Hai să testăm ceea ce ai învățat în acest capitol!

### 1. Când ar trebui să antrenezi un nou tokenizer?

<Question
	choices={[
		{
			text: "Când datasetul tău este similar cu cel utilizat de un model preantrenat și doriți să preantrenați un model nou",
			explain: "În acest caz, pentru a economisi timp și resurse, o alegere mai bună ar fi să folosești același tokenizer ca și modelul preantrenat și să faceți fine-tune acelui model."
		},
		{
			text: "Atunci când datasetul tău este similar cu cel utilizat de un model preantrenat existent și doriți să faceți fine-tune unui nou model utilizând acest model preantrenat",
			explain: "Pentru a face fine-tune unui model dintr-un model preantrenat, trebuie să utilizați întotdeauna același tokenizer."
		},
		{
			text: "Atunci când datasetul tău este diferit de cel utilizat de un model preantrenat existent și doriți să preantrenați un nou model",
			explain: "Corect! În acest caz nu există niciun avantaj în a utiliza același tokenizer.",
            correct: true
		},
        {
			text: "Atunci datasetul tău este diferit de cel utilizat de un model preantrenat existent, dar doriți să faceți fine-tune unui model nou utilizând acest model preantrenat",
			explain: "Pentru a face fine-tune unui model dintr-un model preantrenat, trebuie să utilizați întotdeauna același tokenizer."
		}
	]}
/>

### 2. Care este avantajul utilizării unui generator de liste de texte în comparație cu o listă de liste de texte atunci când utilizați `train_new_from_iterator()`?

<Question
	choices={[
		{
			text: "Acesta este singurul tip pe care metoda <code>train_new_from_iterator()</code> îl acceptă.",
			explain: "O listă de liste de texte este un tip special de generator de liste de texte, astfel încât metoda o va accepta și pe aceasta. Încercați din nou!"
		},
		{
			text: "Veți evita încărcarea întregului dataset în memorie.",
			explain: "Corect! Fiecare batch de texte va fi eliberat din memorie atunci când iterați, iar câștigul va fi vizibil mai ales dacă utilizați 🤗 Datasets pentru a stoca textele.",
			correct: true
		},
		{
			text: "Acest lucru va permite bibliotecii 🤗 Tokenizers să utilizeze multiprocessing.",
			explain: "Nu, oricum va folosi multiprocessing."
		},
        {
			text: "Tokenizerul pe care îl vei antrena va genera texte mai bune.",
			explain: "Tokenizerul nu generează text - îl confundați cu un model lingvistic?"
		}
	]}
/>

### 3. Care sunt avantajele utilizării unui tokenizer "rapid"?

<Question
	choices={[
		{
			text: "Acesta poate procesa inputuri mai rapid decât un tokenizator lent atunci când faci batch mai multor inputuri împreună.",
			explain: "Corect! Datorită paralelismului implementat în Rust, acesta va fi mai rapid pe batch-uri de inputuri. La ce alt beneficiu te poți gândi?",
			correct: true
		},
		{
			text: "Tokenizerele rapide tokenizează întotdeauna mai rapid decât omologii lor lenți.",
			explain: "Un tokenizer rapid poate fi de fapt mai lent atunci când îi dai doar unul sau foarte puține texte, deoarece nu poate utiliza paralelismul."
		},
		{
			text: "Poate aplica padding și truncation.",
			explain: "Adevărat, dar și tokenizerele lente fac asta."
		},
        {
			text: "Acesta are unele caracteristici suplimentare care vă permit să asociați tokenii cu intervalul de text care le-a creat.",
			explain: "Într-adevăr - acestea se numesc offset mappings. Totuși, acesta nu este singurul avantaj.",
			correct: true
		}
	]}
/>

### 4. Cum tratează pipelineul `token-classification` entitățile care se întind pe mai mulți tokeni?

<Question
	choices={[
		{
			text: "Entitățile cu același label sunt merged într-o singură entitate.",
			explain: "Explicația aceasta e prea simplă. Încearcă din nou!"
		},
		{
			text: "Există un label pentru începutul unei entități și un label pentru continuarea unei entități.",
			explain: "Corect!",
			correct: true
		},
		{
			text: "Într-un cuvânt dat, atâta timp cât primul token are labelul entității, întregul cuvânt este considerat etichetat cu entitatea respectivă.",
			explain: "Aceasta este o strategie de gestionare a entităților. Ce alte răspunsuri se aplică aici?",
			correct: true
		},
        {
			text: "Atunci când un token are labelul unei entități date, orice alt token următor cu aceeași label este considerat parte a aceleiași entități, cu excepția cazului în care este etichetat ca fiind începutul unei noi entități.",
			explain: "Acesta este cel mai comun mod de a grupa entitățile împreună - deși nu este singurul răspuns corect.",
			correct: true
		}
	]}
/>

### 5. Cum gestionează pipelineul `question-answering` contextele lungi?

<Question
	choices={[
		{
			text: "De fapt, nu o face, deoarece trunchiază contextul lung la lungimea maximă acceptată de model.",
			explain: "Există un truc pe care îl poți folosi pentru a gestiona contextele lungi. Îți amintești care este acesta?"
		},
		{
			text: "Acesta împarte contextul în mai multe părți și calculează media rezultatelor obținute.",
			explain: "Nu, nu ar avea sens să se facă o medie a rezultatelor, deoarece unele părți ale contextului nu vor include răspunsul."
		},
		{
			text: "Acesta împarte contextul în mai multe părți (cu suprapuneri) și găsește scorul maxim pentru un răspuns în fiecare parte.",
			explain: "Acesta este răspunsul corect!",
			correct: true
		},
        {
			text: "Acesta împarte contextul în mai multe părți (fără suprapunere, pentru eficiență) și găsește scorul maxim pentru un răspuns în fiecare parte.",
			explain: "Nu, acesta include o anumită suprapunere între părți pentru a evita situația în care răspunsul ar fi împărțit în două părți."
		}
	]}
/>

### 6. Ce este normalizarea?

<Question
	choices={[
		{
			text: "Este vorba de orice curățare pe care tokenizerul o efectuează asupra textelor în etapele inițiale.",
			explain: "Corect - de exemplu, ar putea implica eliminarea accentelor sau a spațiilor, sau scrierea cu mijuscule a inputurilor.",
			correct: true
		},
		{
			text: "Este o tehnică de augmentare a datelor care constă în a face textul mai normal prin eliminarea cuvintelor rare.",
			explain: "Este incorect! Încearcă din nou."
		},
		{
			text: "Acesta este ultimul pas de post-procesare în care tokenizerul adaugă tokenii speciali.",
			explain: "Această etapă se numește pur și simplu post-procesare."
		},
        {
			text: "Este atunci când embeddingurile sunt realizate cu media 0 și standard deviation 1, prin scăderea mediei și împărțirea la std.",
			explain: "Acest proces se numește de obicei normalizare atunci când este aplicat valorilor pixelilor în computer vision, dar nu este ceea ce înseamnă normalizare în NLP."
		}
	]}
/>

### 7. Ce este pre-tokenizarea pentru un subword tokenizer?

<Question
	choices={[
		{
			text: "Acesta este pasul dinaintea tokenizării, în care se aplică augmentarea datelor (cum ar fi mascarea aleatorie).",
			explain: "Nu, acest pas face parte din preprocesare."
		},
		{
			text: "Este pasul de dinaintea tokenizării, în care operațiile de curățare dorite sunt aplicate textului.",
			explain: "Nu, acesta este pasul de normalizare."
		},
		{
			text: "Acesta este pasul dinaintea aplicării modelul de tokenizer, pentru a împărți inputul în cuvinte.",
			explain: "Acesta este răspunsul corect!",
			correct: true
		},
        {
			text: "Acesta este pasul dinaintea aplicării modelul de  tokenizer, pentru a împărți inputul în tokenuri.",
			explain: "Nu, împărțirea în tokenuri este sarcina modelul de tokenizer."
		}
	]}
/>

### 8. Selectați propozițiile care se aplică modelului de tokenizare BPE.

<Question
	choices={[
		{
			text: "BPE este un algoritm de tokenizare a subcuvintelor care începe cu un vocabular mic și învață reguli de merge.",
			explain: "Acesta este într-adevăr cazul!",
			correct: true
		},
		{
			text: "BPE este un algoritm de tokenizare a subcuvintelor care începe cu un vocabular mare și elimină progresiv tokenii din acesta.",
			explain: "Nu, aceasta este abordarea adoptată de un alt algoritm de tokenizare."
		},
		{
			text: "Tokenizerele BPE învață regulile de merge prin mergeul perechii de tokeni care este cea mai frecventă.",
			explain: "Acest lucru este corect!",
			correct: true
		},
		{
			text: "Un tokenizer BPE învață o regulă de merge prin mergeul perechii de tokeni care maximizează un scor care privilegiază perechile frecvente cu părți individuale mai puțin frecvente.",
			explain: "Nu, aceasta este strategia aplicată de un alt algoritm de tokenizare."
		},
		{
			text: "BPE tokenizează cuvintele în subcuvinte prin divizarea lor în caractere și apoi prin aplicarea regulilor de merge.",
			explain: "Acest lucru este corect!",
			correct: true
		},
		{
			text: "BPE tokenizează cuvintele în subcuvinte prin găsirea celui mai lung subcuvânt de la început care se află în vocabular, apoi repetă procesul pentru restul textului.",
			explain: "Nu, acesta este un alt mod de a face lucrurile al algoritmului de tokenizare."
		},
	]}
/>

### 9. Selectați propozițiile care se aplică modelului de tokenizare WordPiece.

<Question
	choices={[
		{
			text: "WordPiece este un algoritm de tokenizare a subcuvintelor care începe cu un vocabular mic și învață reguli de merge.",
			explain: "Acesta este într-adevăr cazul!",
			correct: true
		},
		{
			text: "WordPiece este un algoritm de tokenizare a subcuvintelor care începe cu un vocabular mare și elimină progresiv tokenii din acesta.",
			explain: "Nu, aceasta este abordarea adoptată de un alt algoritm de tokenizare."
		},
		{
			text: "Tokenizerele WordPiece învață regulile de merge prin mergeul perechii de tokeni care este cea mai frecventă.",
			explain: "Nu, aceasta este abordarea adoptată de un alt algoritm de tokenizare!",
		},
		{
			text: "Un tokenizer WordPiece învață o regulă de merge prin mergeul perechii de tokeni care maximizează un scor care privilegiază perechile frecvente cu părți individuale mai puțin frecvente.",
			explain: "Acest lucru este corect!",
			correct: true
		},
		{
			text: "WordPiece tokenizează cuvintele în subcuvinte prin găsirea celei mai probabile segmentări în tokeni, în conformitate cu modelul.",
			explain: "Nu, acesta este modul în care funcționează un alt algoritm de tokenizare."
		},
		{
			text: "WordPiece tokenizează cuvintele în subcuvinte prin găsirea celui mai lung subcuvânt de la început care se află în vocabular, apoi repetă procesul pentru restul textului.",
			explain: "Da, acesta este modul în care WordPiece procedează pentru encoding.",
			correct: true
		},
	]}
/>

### 10. Selectați propozițiile care se aplică modelului de tokenizare Unigram.

<Question
	choices={[
		{
			text: "Unigram este un algoritm de tokenizare a subcuvintelor care începe cu un vocabular mic și învață reguli de merge.",
			explain: "Nu, aceasta este abordarea adoptată de un alt algoritm de tokenizare."
		},
		{
			text: "Unigram este un algoritm de tokenizare a subcuvintelor care începe cu un vocabular mare și elimină progresiv tokenurile din el.",
			explain: "Acest lucru este corect!",
			correct: true
		},
		{
			text: "Unigram își adaptează vocabularul prin minimizarea unei pierderi calculate pe întregul corpus.",
			explain: "Acest lucru este corect!",
			correct: true
		},
		{
			text: "Unigram își adaptează vocabularul prin păstrarea celor mai frecvente subcuvinte.",
			explain: "Nu, acest lucru este incorect."
		},
		{
			text: "Unigram tokenizează cuvintele în subcuvinte prin găsirea celei mai probabile segmentări în tokenuri, conform modelului.",
			explain: "Acest lucru este corect!",
			correct: true
		},
		{
			text: "Unigram tokenizează cuvintele în subcuvinte prin divizarea lor în caractere, apoi aplică regulile de merge.",
			explain: "Nu, acesta este modul în care funcționează un alt algoritm de tokenizare."
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter6/10.mdx" />