# Înțelegerea clasei Interface[[understanding-the-interface-class]]

<CourseFloatingBanner chapter={9}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},
]} />

În această secțiune, vom examina mai îndeaproape clasa `Interface` și vom înțelege
parametrii principali folosiți pentru a crea una.

## Cum să creați o Interface[[how-to-create-an-interface]]

Veți observa că clasa `Interface` are 3 parametri necesari:

`Interface(fn, inputs, outputs, ...)`

Acești parametri sunt:

  - `fn`: funcția de predicție care este încapsulată de interfața Gradio. Această funcție poate lua unul sau mai mulți parametri și poate returna una sau mai multe valori
  - `inputs`: tipul(tipurile) componentei de intrare. Gradio oferă multe componente pre-construite precum `"image"` sau `"mic"`.
  - `outputs`: tipul(tipurile) componentei de ieșire. Din nou, Gradio oferă multe componente pre-construite de ex. `"image"` sau `"label"`.

Pentru o listă completă a componentelor, [consultați documentația Gradio](https://gradio.app/docs). Fiecare componentă pre-construită poate fi personalizată prin instanțierea clasei corespunzătoare componentei.

De exemplu, așa cum am văzut în [secțiunea anterioară](/course/chapter9/2),
în loc să transmiteți `"textbox"` la parametrul `inputs`, puteți transmite o componentă `Textbox(lines=7, label="Prompt")` pentru a crea o cutie de text cu 7 linii și o etichetă.

Să aruncăm o privire la un alt exemplu, de data aceasta cu o componentă `Audio`.

## Un exemplu simplu cu audio[[a-simple-example-with-audio]]

Așa cum am menționat mai devreme, Gradio oferă multe intrări și ieșiri diferite.
Deci să construim o `Interface` care funcționează cu audio.

În acest exemplu, vom construi o funcție audio-la-audio care primește un
fișier audio și pur și simplu îl inversează.

Vom folosi pentru intrare componenta `Audio`. Când folosiți componenta `Audio`,
puteți specifica dacă doriți ca `source`-ul audio să fie un fișier pe care utilizatorul
îl încarcă sau un microfon cu care utilizatorul își înregistrează vocea. În acest caz, să
o setăm la `"microphone"`. Doar pentru distracție, vom adăuga o etichetă la `Audio`-ul nostru care spune
"Vorbiți aici...".

În plus, am dori să primim audio-ul ca un array numpy pentru a putea cu ușurință
să îl "inversăm". Deci vom seta `"type"`-ul să fie `"numpy"`, care transmite datele de intrare
ca un tuplu de (`sample_rate`, `data`) în funcția noastră.

Vom folosi și componenta de ieșire `Audio` care poate reda automat
un tuplu cu o rată de eșantionare și un array numpy de date ca fișier audio redabil.
În acest caz, nu avem nevoie să facem nicio personalizare, deci vom folosi scurtătura string
`"audio"`.


```py
import numpy as np
import gradio as gr


def reverse_audio(audio):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    return reversed_audio


mic = gr.Audio(source="microphone", type="numpy", label="Vorbiți aici...")
gr.Interface(reverse_audio, mic, "audio").launch()
```

Codul de mai sus va produce o interfață ca cea de mai jos (dacă browserul dvs. nu
vă cere permisiuni pentru microfon, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">deschideți demo-ul într-o filă separată</a>.)

<iframe src="https://course-demos-audio-reverse.hf.space" frameBorder="0" height="250" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Acum ar trebui să puteți să vă înregistrați vocea și să vă auziți vorbind în sens invers - înfricoșător 👻!

## Gestionarea intrărilor și ieșirilor multiple[[handling-multiple-inputs-and-outputs]]

Să spunem că avem o funcție mai complicată, cu intrări și ieșiri multiple.
În exemplul de mai jos, avem o funcție care primește un index dropdown, o valoare slider și un număr,
și returnează un eșantion audio al unui ton muzical.

Priviți cum transmitem o listă de componente de intrare și ieșire,
și vedeți dacă puteți urmări ce se întâmplă.

Cheia aici este că atunci când transmiteți:
* o listă de componente de intrare, fiecare componentă corespunde unui parametru în ordine.
* o listă de componente de ieșire, fiecare componentă corespunde unei valori returnate.

Fragmentul de cod de mai jos arată cum trei componente de intrare se aliniază cu cei trei argumente ai funcției `generate_tone()`:

```py
import numpy as np
import gradio as gr

notes = ["C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"]


def generate_tone(note, octave, duration):
    sr = 48000
    a4_freq, tones_from_a4 = 440, 12 * (octave - 4) + (note - 9)
    frequency = a4_freq * 2 ** (tones_from_a4 / 12)
    duration = int(duration)
    audio = np.linspace(0, duration, duration * sr)
    audio = (20000 * np.sin(audio * (2 * np.pi * frequency))).astype(np.int16)
    return (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, type="index"),
        gr.Slider(minimum=4, maximum=6, step=1),
        gr.Number(value=1, label="Durata în secunde"),
    ],
    "audio",
).launch()
```

<iframe src="https://course-demos-generate-tone.hf.space" frameBorder="0" height="450" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>


### Metoda `launch()`[[the-launch-method]]

Până acum, am folosit metoda `launch()` pentru a lansa interfața, dar nu
am discutat cu adevărat ce face.

În mod implicit, metoda `launch()` va lansa demo-ul într-un server web care
rulează local. Dacă rulați codul într-un notebook Jupyter sau Colab, atunci
Gradio va incorpora interfața GUI demo în notebook pentru a o putea folosi cu ușurință.

Puteți personaliza comportamentul `launch()` prin parametri diferiți:

  - `inline` - dacă să afișeze interfața inline în notebook-urile Python.
  - `inbrowser` - dacă să lanseze automat interfața într-o filă nouă în browserul implicit.
  - `share` - dacă să creeze un link partajabil public de pe calculatorul dvs. pentru interfață. Cam ca un link Google Drive!

Vom acoperi parametrul `share` în mult mai multe detalii în următoarea secțiune!

## ✏️ Să aplicăm![[lets-apply-it]]

Să construim o interfață care vă permite să demonstrați un model de **recunoaștere vocală**.
Pentru a o face interesantă, vom accepta *fie* o intrare de microfon, fie un fișier încărcat.

Ca de obicei, vom încărca modelul nostru de recunoaștere vocală folosind funcția `pipeline()` din 🤗 Transformers.
Dacă aveți nevoie de o reîmprospătare rapidă, puteți să vă întoarceți la [acea secțiune din Capitolul 1](/course/chapter1/3). Următorul, vom implementa o funcție `transcribe_audio()` care procesează audio-ul și returnează transcrierea. În final, vom încapsula această funcție într-o `Interface` cu componentele `Audio` pentru intrări și doar text pentru ieșire. În ansamblu, codul pentru această aplicație este următorul:

```py
from transformers import pipeline
import gradio as gr

model = pipeline("automatic-speech-recognition")


def transcribe_audio(audio):
    transcription = model(audio)["text"]
    return transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=gr.Audio(type="filepath"),
    outputs="text",
).launch()
```

Dacă browserul dvs. nu vă cere permisiuni pentru microfon, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">deschideți demo-ul într-o filă separată</a>.

<iframe src="https://course-demos-asr.hf.space" frameBorder="0" height="550" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>


Asta e! Acum puteți folosi această interfață pentru a transcrie audio. Observați aici că
prin transmiterea parametrului `optional` ca `True`, permitem utilizatorului să ofere fie
un microfon, fie un fișier audio (sau niciunul, dar asta va returna un mesaj de eroare).

Continuați să vedeți cum să vă partajați interfața cu alții! 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter9/3.mdx" />