# Использование предобученных моделей

{#if fw === 'pt'}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/ru/chapter4/section2_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/ru/chapter4/section2_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/ru/chapter4/section2_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/ru/chapter4/section2_tf.ipynb"},
]} />

{/if}

Hub упрощает выбор подходящей модели, поэтому ее использование в любой задаче заключается в запуске нескольких строк кода. Давайте посмотрим, как это сделать и как внести свой вклад в сообщество.

Допустим, мы ищем модель для французского языка, которая может выполнять заполнение пропущенных слов в предложении.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/camembert.gif" alt="Selecting the Camembert model." width="80%"/>
</div>

Мы выберем для этой задачи чекпоинт `camembert-base`. Идентификатор `camembert-base` – все, что нам нужно, чтобы начать использовать модель! Как вы видели в предыдущих главах, мы можем инициализировать модель с использованием функции `pipeline()`: 

```py
from transformers import pipeline

camembert_fill_mask = pipeline("fill-mask", model="camembert-base")
results = camembert_fill_mask("Le camembert est <mask> :)")
```

```python out
[
  {'sequence': 'Le camembert est délicieux :)', 'score': 0.49091005325317383, 'token': 7200, 'token_str': 'délicieux'}, 
  {'sequence': 'Le camembert est excellent :)', 'score': 0.1055697426199913, 'token': 2183, 'token_str': 'excellent'}, 
  {'sequence': 'Le camembert est succulent :)', 'score': 0.03453313186764717, 'token': 26202, 'token_str': 'succulent'}, 
  {'sequence': 'Le camembert est meilleur :)', 'score': 0.0330314114689827, 'token': 528, 'token_str': 'meilleur'}, 
  {'sequence': 'Le camembert est parfait :)', 'score': 0.03007650189101696, 'token': 1654, 'token_str': 'parfait'}
]
```

Как видите, загрузить модель в пайплайн очень просто. Единственное, на что вам нужно обратить внимание, это чтобы выбранный чекпоинт подходил для задачи, для которой он будет использоваться. Например, здесь мы загружаем чекпоинт `camembert-base` в пайплайн `fill-mask`, что совершенно нормально. Но если бы мы загрузили эту контрольную точку в пайплайн `text-classification`, результаты не имели бы никакого смысла, потому что выходной слой `camembert-base` не подходит для этой задачи! Мы рекомендуем использовать селектор задач в интерфейсе Hugging Face Hub, чтобы выбрать соответствующие чекпоинты:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/tasks.png" alt="The task selector on the web interface." width="80%"/>
</div>

Вы также можете инициализировать модель не через пайплайн, а путем создания экземпляра класса модели:

{#if fw === 'pt'}
```py
from transformers import CamembertTokenizer, CamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = CamembertForMaskedLM.from_pretrained("camembert-base")
```

Однако вместо этого мы рекомендуем использовать [`Auto*` классы](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes), так как они по своей конструкции не зависят от архитектуры используемой модели. В то время как предыдущий пример кода ограничивает пользователей чекпоинтами, загружаемыми в архитектуре CamemBERT, использование классов `Auto*` упрощает переключение между чекпоинтами:

```py
from transformers import AutoTokenizer, AutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = AutoModelForMaskedLM.from_pretrained("camembert-base")
```
{:else}
```py
from transformers import CamembertTokenizer, TFCamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = TFCamembertForMaskedLM.from_pretrained("camembert-base")
```

Однако вместо этого мы рекомендуем использовать [`TFAuto*` classes](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes) так как они по своей конструкции не зависят от архитектуры используемой модели. В то время как предыдущий пример кода ограничивает пользователей чекпоинтами, загружаемыми в архитектуре CamemBERT, использование классов `TFAuto*` упрощает переключение между чекпоинтами: 

```py
from transformers import AutoTokenizer, TFAutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = TFAutoModelForMaskedLM.from_pretrained("camembert-base")
```
{/if}

<Tip>

При использовании предварительно обученной модели обязательно проверьте: как она была обучена, на каких наборах данных, ее ограничениях и смещениях. Вся эта информация должна быть указана в карточке модели.
</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter4/2.mdx" />