# Публикация обученых моделей в общий доступ

{#if fw === 'pt'}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/ru/chapter4/section3_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/ru/chapter4/section3_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/ru/chapter4/section3_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/ru/chapter4/section3_tf.ipynb"},
]} />

{/if}

Далее мы рассмотрим самые простые способы публикации предварительно обученных моделей в 🤗 Hub: доступные инструменты и утилиты, упрощающие совместное использование и обновление моделей непосредственно в Hub. 

<Youtube id="9yY3RB_GSPM"/>

Мы призываем всех пользователей, которые обучают модели, вносить свой вклад, делясь ими с сообществом — совместное использование моделей, даже если они обучены на очень конкретных наборах данных, поможет другим, сэкономив им время и вычислительные ресурсы! В свою очередь, вы можете извлечь выгоду из работы, которую проделали другие!

Есть три пути создания репозитория с моделью:

- С использованием API `push_to_hub` 
- С использованием python-библиотеки `huggingface_hub`
- С использованием веб-интерфейса

После создания репозитория вы можете загружать в него файлы через git и git-lfs. В следующих разделах мы познакомим вас с созданием репозиториев моделей и загрузкой в них файлов. 

## Использование API `push_to_hub` 

{#if fw === 'pt'}

<Youtube id="Zh0FfmVrKX0"/>

{:else}

<Youtube id="pUh5cGmNV8Y"/>

{/if}

Простейший путь загрузки файлов на Hub – `push_to_hub` API. 

Перед тем, как пойдем дальше, необходимо сгенерировать токен аутентификации. Это необходимо сделать для того, чтобы `huggingface_hub` API «узнал» вас и предоставил вам необходимые права на запись. Убедитесь, что вы находитесь в окружении, в котором установлена библиотека `transformers` (см. [Установка](../chapter0)). Если вы работаете в Jupyter'е, вы можете использовать следующую функцию для авторизации: 

```python
from huggingface_hub import notebook_login

notebook_login()
```

В терминале можно запустить: 

```bash
huggingface-cli login
```

В обоих случаях вам будет предложено ввести свой логин и пароль (это должны быть те же данные, которые вы используете для входа на Hub). Если у вас нет учетной записи HuggingFace, вы можете создать ее [здесь](https://huggingface.co/join). 

Отлично! После авторизации ваш токен сохранится во временную папку. Давайте создадим репозитории!

{#if fw === 'pt'}

Если вы уже пользовались `Trainer` API для обучения модели, то самый простой способ загрузить модель на Hub – установить аргумент `push_to_hub=True` во время инициализации `TrainingArguments`: 

```py
from transformers import TrainingArguments

training_args = TrainingArguments(
    "bert-finetuned-mrpc", save_strategy="epoch", push_to_hub=True
)
```

При вызове `trainer.train()` `Trainer` будет загружать модель на Hub каждый раз, когда она будет сохраняться (в данном примере каждую эпоху). Репозиторий будет назван так же, как вы назовете папку для сохранения (в примере это `bert-finetuned-mrpc`), но вы можете задать имя репозитория самостоятельно: задайте аргумент `hub_model_id = "a_different_name"`.

Для загрузки модели в репозиторий организации, представитем которой вы являетесь, укажите `hub_model_id = "my_organization/my_repo_name"`.

После окончания обучения следует вызвать метод `trainer.push_to_hub()`, который загрузит последнюю версию вашей модели в репозиторий. Также он сгенерирует карточку модели со всей необходимой информацией, использованными гиперпараметрами и результатами валидации. Ниже приведено то, что вы можете найти в подобной карточке модели: 

<div class="flex justify-center">
  <img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/model_card.png" alt="An example of an auto-generated model card." width="100%"/>
</div>

{:else}

Если вы используете Keras для обучения моделей, простейший способ загрузить модель на Hub – вызвать callback `PushToHubCallback` при вызове `model.fit()`: 

```py
from transformers import PushToHubCallback

callback = PushToHubCallback(
    "bert-finetuned-mrpc", save_strategy="epoch", tokenizer=tokenizer
)
```

Затем необходимо добавить `callbacks=[callback]` в вызов `model.fit()`. Callback будет загружать модель на Hub каждый раз, когда она будет сохраняться (в данном примере каждую эпоху). Репозиторий будет назван так же, как вы назовете папку для сохранения (в примере это `bert-finetuned-mrpc`), но вы можете задать имя репозитория самостоятельно: задайте аргумент `hub_model_id = "a_different_name"`.

Для загрузки модели в репозиторий организации, представитем которой вы являетесь, укажите `hub_model_id = "my_organization/my_repo_name"`.

{/if}

На более низком уровне доступ к Model Hub может быть осуществлен прямо через метод `push_to_hub()`, который можно вызвать у моделей, токенизаторов и конфигурационных объектов. Этот метод отвечает сразу и за создание репозитория, и за загрузку файлов моделей и токенизаторов. Никак

At a lower level, accessing the Model Hub can be done directly on models, tokenizers, and configuration objects via their `push_to_hub()` method. This method takes care of both the repository creation and pushing the model and tokenizer files directly to the repository. В отличие от API, который мы рассмотрим ниже, здесь никакая ручная обработка не применяется. 

Чтобы понять, как это работает, давайте инициализируем модель и токенизатор:

{#if fw === 'pt'}
```py
from transformers import AutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = AutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
```
{:else}
```py
from transformers import TFAutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = TFAutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
```
{/if}

Вы можете сделать с этими объектами что угодно – измените настройки токенизатора, обучите модель, дообучите предобученную и т.д. После того, как вы получите приемлемый результат, вы можете вызвать `push_to_hub()` прямо у экземпляра модели: 

```py
model.push_to_hub("dummy-model")
```

Эта операция создаст новый репозиторий `dummy-model` в вашем профиле и загрузит все необходимые файлы. Сделайте это же с токенизатором: 

```py
tokenizer.push_to_hub("dummy-model")
```

Если вы являетесь членом организации, просто укажите `organization` и данные будут загружены в профиль организации: 

```py
tokenizer.push_to_hub("dummy-model", organization="huggingface")
```

Если вы хотите использовать какой-то конкретный токен, вы можете указать его в методе `push_to_hub()`: 

```py
tokenizer.push_to_hub("dummy-model", organization="huggingface", use_auth_token="<TOKEN>")
```

Теперь перейдите в Model Hub и найдите свою модель: *https://huggingface.co/user-or-organization/dummy-model*. 

Выберите вкладку "Files and versions", вы должны увидеть файлы, похожие на приведенные на скриншоте ниже: 

{#if fw === 'pt'}
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/push_to_hub_dummy_model.png" alt="Dummy model containing both the tokenizer and model files." width="80%"/>
</div>
{:else}
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/push_to_hub_dummy_model_tf.png" alt="Dummy model containing both the tokenizer and model files." width="80%"/>
</div>
{/if}

<Tip>
✏️ **Попробуйте!** Используйте модель и токенайзер чекпоинта `bert-base-cased` и загрузите их в собственный профиль с помощью метода `push_to_hub()`. Проверьте, что репозиторий корректно создался перед его удалением. 
</Tip>

Как мы увидели выше, метод `push_to_hub()` поддерживает несколько аргументов, позволяющих загрузить данные в конкретный профиль или профиль организации или использовать конкретный токен. Мы рекомендуем обратить внимание на спецификацию метода, доступную по ссылке [🤗 Transformers documentation](https://huggingface.co/transformers/model_sharing.html), и ознакомиться с остальными возможностями метода. 

Метод `push_to_hub()` реализован с использованием python-пакета [`huggingface_hub`](https://github.com/huggingface/huggingface_hub), который напрямую использует API Hugging Face Hub. Этот пакет интегрирован в 🤗 Transformers и несколько других библиотек машинного обучения, например [`allenlp`](https://github.com/allenai/allennlp). Хотя в этой главе мы сосредоточимся на интеграции с 🤗 Transformers, интегрировать его в ваш собственный код или библиотеку очень просто.

Перейдите к последнему разделу, чтобы узнать, как загружать файлы в только что созданный репозиторий!

## Использование библиотеки `huggingface_hub`

Библиотека `huggingface_hub` - это инструмент, который предлагает наборы различных моделей и датасетов. В ней есть возможность использования  простых методов и классов для общих задач, таких как получение информации о репозиториях на хабе и управление ими. Также доступны простые API-интерфейсы, которые работают поверх git для управления содержимым этих репозиториев и интеграции Hub в ваших проектах и библиотеках.

Как и при использовании API `push_to_hub` необходимо, чтобы ваш токен API был сохранен в кэше. Для этого вам нужно будет использовать команду `login` из CLI, как упоминалось в предыдущем разделе (опять же, убедитесь, что перед этими командами стоит символ `!`, если вы работаете в Google Colab):

```bash
huggingface-cli login
```

Пакет `huggingface_hub` предлагает несколько методов и классов, полезных для наших целей. Во-первых, есть несколько способов управления созданием, удалением и прочего:

```python no-format
from huggingface_hub import (
    # Пользовательские настройки
    login,
    logout,
    whoami,

    # Создание и управление репозиториями
    create_repo,
    delete_repo,
    update_repo_visibility,

    # И несколько способов для получения или изменения информации о содержимом
    list_models,
    list_datasets,
    list_metrics,
    list_repo_files,
    upload_file,
    delete_file,
)
```
Кроме того, `huggingface_hub` предлагает очень мощный класс `Repository` для управления локальным хранилищем. Мы рассмотрим эти методы и этот класс в следующих нескольких разделах, чтобы понять, как их использовать.

Метод `create_repo` можно использовать для создания нового репозитория на хабе:

```py
from huggingface_hub import create_repo

create_repo("dummy-model")
```
Это создаст репозиторий `dummy-model` в вашем пространстве. Если хотите, вы можете указать, какой организации должен принадлежать репозиторий, используя аргумент `organization`:

```py
from huggingface_hub import create_repo

create_repo("dummy-model", organization="huggingface")
```

Это создаст репозиторий `dummy-model` в пространстве `huggingface`, предполагая, что вы принадлежите к этой организации.
Другие аргументы, которые могут быть полезны:

- `private`, чтобы указать, должен ли репозиторий быть видимым для других или нет.
- `token`, если вы хотите переопределить токен, хранящийся в вашем кэше, указанным токеном.
- `repo_type`, если вы хотите создать `dataset` или `space` вместо модели. Допустимые значения: `"dataset"` и `"space"`.

Как только репозиторий создан, мы должны добавить в него файлы! Перейдите к следующему разделу, чтобы увидеть три способа сделать это.


## Использование веб-интерфейса

Веб-интерфейс предлагает инструменты для управления репозиториями прямо в хабе. Используя интерфейс, вы можете легко создавать репозитории, добавлять файлы (даже большие!), исследовать модели, визуализировать различия и многое другое.

Для создания нового репозитория перейдите по ссылке: [huggingface.co/new](https://huggingface.co/new):

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/new_model.png" alt="Page showcasing the model used for the creation of a new model repository." width="80%"/>
</div>

Во-первых, укажите владельца репозитория: это можете быть как вы, так и любая из организаций, с которыми вы связаны. Если вы выберете организацию, модель будет размещена на странице организации, и каждый член организации сможет внести свой вклад в репозиторий.

Затем введите название вашей модели. Это также будет имя репозитория. Наконец, вы можете указать, хотите ли вы, чтобы ваша модель была общедоступной или приватной. Приватные модели скрыты от посторонних глаз.

После создания репозитория моделей вы должны увидеть страницу, подобную этой: 

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/empty_model.png" alt="An empty model page after creating a new repository." width="80%"/>
</div>

Здесь будет размещена ваша модель. Чтобы начать заполнение репозитория, вы можете добавить файл README прямо из веб-интерфейса.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/dummy_model.png" alt="The README file showing the Markdown capabilities." width="80%"/>
</div>

Файл README хранится в формате Markdown! Третья часть этой главы посвящена заполнению карточки модели. Она имеет первостепенное значение для повышения ценности вашей модели, поскольку именно здесь вы рассказываете другим, на что способна модель.

Если вы посмотрите на вкладку «Файлы и версии», то увидите, что там пока не так много файлов — только только что созданный *README.md* и файл *.gitattributes*, который отслеживает большие файлы.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/files.png" alt="The 'Files and versions' tab only shows the .gitattributes and README.md files." width="80%"/>
</div>

Позже мы посмотрим, как добавить новые файлы. 

## Загрузка файлов модели

Система управления файлами в Hugging Face Hub основана на git для обычных файлов и git-lfs (что означает [Git Large File Storage](https://git-lfs.github.com/)) для больших файлов.

В следующем разделе мы рассмотрим три различных способа загрузки файлов в Hub: через `huggingface_hub` и через команды git.

### Функция `upload_file` 

Использование `upload_file` не требует установки git и git-lfs в вашей системе. Функция отправляет файлы напрямую в 🤗 Hub с помощью HTTP-запросов POST. Ограничение этого подхода заключается в том, что он не обрабатывает файлы размером более 5 ГБ.
Если размер ваших файлов превышает 5 ГБ, воспользуйтесь двумя другими способами, описанными ниже.

API можно использовать следующим образом:

```py
from huggingface_hub import upload_file

upload_file(
    "<path_to_file>/config.json",
    path_in_repo="config.json",
    repo_id="<namespace>/dummy-model",
)
```

Это загрузит файл `config.json`, доступный по адресу `<path_to_file>`, в корень как `config.json` в репозиторий `dummy-model`.
Другие аргументы, которые могут быть полезны:

- `token`, если вы хотите переопределить токен, хранящийся в вашем кеше, указанным токеном.
- `repo_type`, если вы хотите загрузить в `dataset` или `space`. Допустимые значения: `"dataset"` и `"space"`. 


### Класс `Repository`

Класс `Repository` управляет локальным репозиторием подобно git. Он абстрагирует большинство проблемных моментов, которые могут возникнуть с git, чтобы предоставить все функции, которые нам нужны.

Использование этого класса требует наличия установленных git и git-lfs, поэтому убедитесь, что у вас установлен и настроен git-lfs (см. [здесь] (https://git-lfs.github.com/) для инструкций по установке), прежде чем начать .

Чтобы начать использование только что созданного репозитория, его нужно инициализировать в локальной папке путем клонирования удаленного репозитория:

```py
from huggingface_hub import Repository

repo = Repository("<path_to_dummy_folder>", clone_from="<namespace>/dummy-model")
```

Этот код создал папку `<path_to_dummy_folder>` в нашем рабочем каталоге. Эта папка содержит только файл `.gitattributes`, поскольку это единственный файл, созданный при создании экземпляра репозитория с помощью `create_repo`.

С этого момента мы можем использовать несколько традиционных методов git:

```py
repo.git_pull()
repo.git_add()
repo.git_commit()
repo.git_push()
repo.git_tag()
```

и другие. Мы рекомендуем ознакомиться с доступной документацией `Repository` [здесь] (https://github.com/huggingface/huggingface_hub/tree/main/src/huggingface_hub#advanced-programmatic-repository-management) для обзора всех доступных методов.

В настоящее время у нас есть модель и токенизатор, которые мы хотели бы отправить в хаб. Мы успешно клонировали репозиторий, поэтому мы можем сохранить файлы в этом репозитории.

Сначала мы убедимся, что наш локальный репозиторий обновлен: запросим оттуда все изменения:

```py
repo.git_pull()
```
После того, как это сделано, мы сохраним файлы модели и токенизатора:

```py
model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```
`<path_to_dummy_folder>` сейчас содержит пути к модели и токенизатору. Мы последуем обычной процедуре добавления файлов с помощью git, зафиксируем изменения и отправим их в удаленный репозиторий:

```py
repo.git_add()
repo.git_commit("Add model and tokenizer files")
repo.git_push()
```

Поздравляем! Вы только что сделали первый коммит в хаб! 

### git-подход

Это очень простой подход к загрузке файлов: мы сделаем это напрямую с помощью git и git-lfs. 

Использование этого подхода требует наличия установленных git и git-lfs, поэтому убедитесь, что у вас установлен и настроен [git-lfs](https://git-lfs.github.com/) (см. здесь инструкции по установке), прежде чем начать.

Начните с инициализации git-lfs:

```bash
git lfs install
```

```bash
Updated git hooks.
Git LFS initialized.
```

После инициализации клонируйте репозиторий с моделью.

Once that's done, the first step is to clone your model repository:

```bash
git clone https://huggingface.co/<namespace>/<your-model-id>
```

Мое имя пользователя `lysandre` и я использую модель под названием `dummy`, поэтому команда выглядит следующим образом: 

```
git clone https://huggingface.co/lysandre/dummy
```

Теперь у меня есть папка *dummy* в моей рабочей директории. Командной `cd` я могу перейти в эту директорию и посмотреть на ее содержимое:

```bash
cd dummy && ls
```

```bash
README.md
```

Если вы только что создали репозиторий с помощью метода `create_repo` в Hugging Face Hub, эта папка должна содержать только скрытый файл `.gitattributes`. Если вы следовали инструкциям из предыдущего раздела для создания репозитория с помощью веб-интерфейса, папка должна содержать один файл *README.md* вместе со скрытым файлом `.gitattributes`, как показано здесь.

Добавление файла обычного размера, такого как файл конфигурации, файл словаря или практически любого файла размером менее нескольких мегабайт, выполняется точно так же, как это делается в любой системе на основе git. Однако файлы большего размера должны быть зарегистрированы через git-lfs, тогда появится возможность отправить их на *huggingface.co*.

Давайте ненадолго вернемся к Python, чтобы сгенерировать модель и токенизатор, которые мы хотели бы зафиксировать в нашем демонстрацинном репозитории:

{#if fw === 'pt'}
```py
from transformers import AutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = AutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

# Сделайте с моделью что угодно: обучите с нуля, дообучите и тд

model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```
{:else}
```py
from transformers import TFAutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = TFAutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

# Do whatever with the model, train it, fine-tune it...

model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```
{/if}

Давайте взглянем на нашу директорию после выполненных выше шагов:

```bash
ls
```

{#if fw === 'pt'}
```bash
config.json  pytorch_model.bin  README.md  sentencepiece.bpe.model  special_tokens_map.json tokenizer_config.json  tokenizer.json
```

If you look at the file sizes (for example, with `ls -lh`), you should see that the model state dict file (*pytorch_model.bin*) is the only outlier, at more than 400 MB.

{:else}
```bash
config.json  README.md  sentencepiece.bpe.model  special_tokens_map.json  tf_model.h5  tokenizer_config.json  tokenizer.json
```

Если вы обратите внимание на размеры файлов (например, с помощью команды `ls -lh`), вы заметите, что файл модели (*t5_model.h5*) является единственным большим файлом, он занимает более 400 Мб.

{/if}

<Tip>
✏️ При создании репозитория с помощью веб-интерфейса, файл *.gitattributes* автоматически фиксирует файлы с определенными расширениями (*.bin* и *.h5*) как большие файлы, и git-lfs отследит их без необходимости делать это вручную. 
</Tip> 

Теперь мы можем продолжить и продолжить, как обычно делаем с традиционными репозиториями Git. Мы можем добавить все файлы в промежуточную среду Git с помощью команды `git add`:

```bash
git add .
```

Затем мы можем взглянуть на файлы, которые в настоящее время размещены:

```bash
git status
```

{#if fw === 'pt'}
```bash
On branch main
Your branch is up to date with 'origin/main'.

Changes to be committed:
  (use "git restore --staged <file>..." to unstage)
  modified:   .gitattributes
	new file:   config.json
	new file:   pytorch_model.bin
	new file:   sentencepiece.bpe.model
	new file:   special_tokens_map.json
	new file:   tokenizer.json
	new file:   tokenizer_config.json
```
{:else}
```bash
On branch main
Your branch is up to date with 'origin/main'.

Changes to be committed:
  (use "git restore --staged <file>..." to unstage)
  modified:   .gitattributes
  	new file:   config.json
	new file:   sentencepiece.bpe.model
	new file:   special_tokens_map.json
	new file:   tf_model.h5
	new file:   tokenizer.json
	new file:   tokenizer_config.json
```
{/if}

Точно так же мы можем убедиться, что git-lfs отслеживает правильные файлы, используя команду `status`:

```bash
git lfs status
```

{#if fw === 'pt'}
```bash
On branch main
Objects to be pushed to origin/main:


Objects to be committed:

	config.json (Git: bc20ff2)
	pytorch_model.bin (LFS: 35686c2)
	sentencepiece.bpe.model (LFS: 988bc5a)
	special_tokens_map.json (Git: cb23931)
	tokenizer.json (Git: 851ff3e)
	tokenizer_config.json (Git: f0f7783)

Objects not staged for commit:


```

Мы видим, что все файлы имеют `Git` в качестве обработчика, кроме *pytorch_model.bin* и *sentencepiece.bpe.model*, у которых есть `LFS`. Отлично!

{:else}
```bash
On branch main
Objects to be pushed to origin/main:


Objects to be committed:

	config.json (Git: bc20ff2)
	sentencepiece.bpe.model (LFS: 988bc5a)
	special_tokens_map.json (Git: cb23931)
	tf_model.h5 (LFS: 86fce29)
	tokenizer.json (Git: 851ff3e)
	tokenizer_config.json (Git: f0f7783)

Objects not staged for commit:


```

Мы видим, что все файлы имеют `Git` в качестве обработчика, кроме *t5_model.h5*, у которых есть `LFS`. Отлично!

{/if}

Перейдем к последним шагам - коммиту и отправке в удаленный репозиторий *huggingface.co*:

```bash
git commit -m "First model version"
```

{#if fw === 'pt'}
```bash
[main b08aab1] First model version
 7 files changed, 29027 insertions(+)
  6 files changed, 36 insertions(+)
 create mode 100644 config.json
 create mode 100644 pytorch_model.bin
 create mode 100644 sentencepiece.bpe.model
 create mode 100644 special_tokens_map.json
 create mode 100644 tokenizer.json
 create mode 100644 tokenizer_config.json
```
{:else}
```bash
[main b08aab1] First model version
 6 files changed, 36 insertions(+)
 create mode 100644 config.json
 create mode 100644 sentencepiece.bpe.model
 create mode 100644 special_tokens_map.json
 create mode 100644 tf_model.h5
 create mode 100644 tokenizer.json
 create mode 100644 tokenizer_config.json
```
{/if}

Отправка может занять некоторое время, в зависимости от скорости вашего интернет-соединения и размера ваших файлов:

```bash
git push
```

```bash
Uploading LFS objects: 100% (1/1), 433 MB | 1.3 MB/s, done.
Enumerating objects: 11, done.
Counting objects: 100% (11/11), done.
Delta compression using up to 12 threads
Compressing objects: 100% (9/9), done.
Writing objects: 100% (9/9), 288.27 KiB | 6.27 MiB/s, done.
Total 9 (delta 1), reused 0 (delta 0), pack-reused 0
To https://huggingface.co/lysandre/dummy
   891b41d..b08aab1  main -> main
```

{#if fw === 'pt'}
Если мы посмотрим на репозиторий модели после завершения отправки, мы увидим все недавно добавленные файлы:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/full_model.png" alt="The 'Files and versions' tab now contains all the recently uploaded files." width="80%"/>
</div>

Интерфейс позволяет вам исследовать файлы моделей и коммиты, а также видеть разницу, представленную каждым коммитом:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/diffs.gif" alt="The diff introduced by the recent commit." width="80%"/>
</div>
{:else}
Если мы посмотрим на репозиторий модели после завершения отправки, мы увидим все недавно добавленные файлы:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/full_model_tf.png" alt="The 'Files and versions' tab now contains all the recently uploaded files." width="80%"/>
</div>

Интерфейс позволяет вам исследовать файлы моделей и коммиты, а также видеть разницу, представленную каждым коммитом:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/diffstf.gif" alt="The diff introduced by the recent commit." width="80%"/>
</div>
{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter4/3.mdx" />