# Тест в конце главы[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Проверим, что вы усвоили в результате изучения данной главы!
  
### 1. Чем ограничиваются модели с Hub?

<Question
	choices={[
		{
			text: "Моделями из библиотеки 🤗 Transformers.",
			explain: "Модели из библиотеки 🤗 Transformers присутствуют на Hugging Face Hub, но не только они!"
		},
		{
			text: "Все модели имеют похожий с  🤗 Transformers интерфейс.",
			explain: "Hugging Face Hub не предъявляет никаких требований к интерфейсам моделей."
		},
		{
			text: "Никаких ограничений",
			explain: "Верно! Никаких ограничений для загрузки моделей на Hub нет!",
            correct: true
		},
        {
			text: "Моделями так или иначе связанным с обработкой естесственного языка.",
			explain: "Модели не ограничены областью использования!"
		}
	]}
/>

### 2. Как можно управлять моделями на Hub?

<Question
	choices={[
		{
			text: "Через аккаунт GCP.",
			explain: "Неправильно!"
		},
		{
			text: "Peer-to-peer взаимодействием.",
			explain: "Неправильно!"
		},
		{
			text: "Через git и git-lfs.",
			explain: "Верно! Модели на Hub – обычные git-репозитории, использующие <code>git-lfs</code> для больших файлов.",
            correct: true
		}
	]}
/>

### 3. Что вы можете сделать, используя веб-интерфейс Hugging Face Hub? 

<Question
	choices={[
		{
			text: "Сделать fork существующего репозитория.",
			explain: "Форкинг на Hugging Face Hub недоступен."
		},
		{
			text: "Сделать новый репозиторий для модели.",
			explain: "Верно! Но это не все, что вы можете сделать.",
            correct: true
		},
		{
			text: "Управлять файлами и редактировать их.",
			explain: "Верно! Но это не единственный правильный ответ.",
            correct: true
		},
        {
			text: "Загружать файлы",
			explain: "Верно! Но это еще не все.",
            correct: true
		},
        {
			text: "Отслеживать изменения между версиями.",
			explain: "Верно! Но это не все, что вы можете делать.",
            correct: true
		}
	]}
/>

### 4. Что такое карточка модели?

<Question
	choices={[
		{
			text: "Примерное описание модели, поэтому оно менее важно, чем файлы модели и токенизатора.",
			explain: "Это действительно описание модели, но это важная часть: если оно неполное или отсутствует, полезность модели резко снижается."
		},
		{
			text: "Способ обеспечить воспроизводимость, возможность повторного использования и честность.",
			explain: "Правильно! Размещение правильной информации в карточке модели поможет пользователям использовать вашу модель и узнать о ее ограничениях и предвзятости.",
            correct: true
		},
		{
			text: "Файл Python, который можно запустить для получения информации о модели.",
			explain: "Карточка модели – это просто файл Markdown."
		}
	]}
/>

### 5. Какие из этих объектов библиотеки 🤗 Transformers могут быть напрямую выложены на  Hub с помощью функции `push_to_hub()`?

{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "Токенизатор",
			explain: "Верно! Все токенизаторы обладают методом <code>push_to_hub</code>, его применение отправит все файлы токенизатора (словарь, архитектуру и пр.) в указанный репозиторий. Тем не менее, это не единственный верный ответ!",
            correct: true
		},
		{
			text: "Конфигурация модели",
			explain: "Верно! Все конфигурации моделей обладают методом <code>push_to_hub</code>, его применение отправит необходимые файлы в указанный репозиторий. Тем не менее, это не единственный верный ответ!",
            correct: true
		},
		{
			text: "Модель",
			explain: "Верно! Все модели обладают методом <code>push_to_hub</code>, его применение отправит сответствующие файлы и конфигурации в указанный репозиторий. Но это не всё, чем вы можете поделиться!",
            correct: true
		},
        {
			text: "Экземпляр Trainer",
			explain: "Правильно: <code>Trainer</code> также обладает методом <code>push_to_hub</code>, его применение загрузит модель, конфигурацию, токенизатор и черновик карточки модели в указанный репозиторий. Попробуйте и другие ответы!",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: "Токенизатор",
			explain: "Верно! Все токенизаторы обладают методом <code>push_to_hub</code>, его применение отправит все файлы токенизатора (словарь, архитектуру и пр.) в указанный репозиторий. Тем не менее, это не единственный верный ответ!",
            correct: true
		},
		{
			text: "Конфигурация модели",
			explain: "Верно! Все конфигурации моделей обладают методом <code>push_to_hub</code>, его применение отправит необходимые файлы в указанный репозиторий. Тем не менее, это не единственный верный ответ!",
            correct: true
		},
		{
			text: "Модель",
			explain: "Верно! Все модели обладают методом <code>push_to_hub</code>, его применение отправит сответствующие файлы и конфигурации в указанный репозиторий. Но это не всё, чем вы можете поделиться!",
            correct: true
		},
		{
			text: "Все вышеперечисленной с помощью специального callback",
			explain: "Верно: <code>PushToHubCallback</code> будет регулярно отсылать все объекты в репозиторий во время обучения.",
            correct: true
		}
	]}
/>
{/if}

### 6. Какой первый шаг при использовани `push_to_hub()` метода или инструментов командной строки?

<Question
	choices={[
		{
			text: "Залогиниться на сайте Hub.",
			explain: "Это не поможет во время работы на локальной машине."
		},
		{
			text: "Запустить'huggingface-cli login' в терминале.",
			explain: "Верно — это загрузит и закэширует ваш персональный токен.",
            correct: true
		},
		{
			text: "Запустить 'notebook_login()' в ноутбуке.",
			explain: "Верно — это отобразит виджет для авторизации.",
            correct: true
		},
	]}
/>

### 7.Если вы используете модель и токенизатор – как вы можете загрузить их на Hub?

<Question
	choices={[
		{
			text: "Вызвав метод `push_to_hub` у модели и токенизатора.",
			explain: "Верно!",
            correct: true
		},
		{
			text: "С использованием среды Python обернуть их в <code>huggingface_hub</code> утилиту.",
			explain: "Модели и токенизаторы уже используют утилиты <code>huggingface_hub</code>: нет необходимости в дополнительных утилитах!"
		},
		{
			text: "Сохранив их на диск и вызвав <code>transformers-cli upload-model</code>",
			explain: "Команды <code>upload-model</code> не существует."
		}
	]}
/>

### 8. Какие операции git вы можете проводить с экземпляром класса `Repository`?

<Question
	choices={[
		{
			text: "Commit",
			explain: "Верно, <code>git_commit()</code> метод как раз для этого.",
            correct: true
		},
		{
			text: "Pull",
			explain: "Это предназначение метода <code>git_pull()</code>.",
            correct: true
		},
		{
			text: "Push",
			explain: "Метод <code>git_push()</code> делает это.",
            correct: true
		},
		{
			text: "Merge",
			explain: "Нет, такая операция невозможная с данным API."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter4/6.mdx" />