# Тест в конце главы[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={9}
    classNames="absolute z-10 right-0 top-0"
/>

Давайте проверим, чему вы научились в этой главе!

### 1. Для чего можно использовать Gradio?

<Question
	choices={[
        {
			text: "Создание демо для вашей модели машинного обучения",
			explain: "С помощью нескольких строк кода на python вы можете создать демо для вашей ML-модели, используя нашу библиотеку готовых компонентов.",
			correct: true
		},
		{
			text: "Поделиться своей моделью машинного обучения с другими",
			explain: "Используя параметр <code>share=True</code> в методе запуска, вы можете сгенерировать ссылку для общего доступа, чтобы отправить ее всем желающим.",
            correct: true
		},
		{
			text: "Отладка вашей модели",
			explain: "Одно из преимуществ демо Gradio - возможность протестировать модель на реальных данных, которые можно изменять и наблюдать за изменением прогнозов модели в режиме реального времени, что поможет вам отладить модель.",
			correct: true
		},
		{
			text: "Обучить вашу модель",
			explain: "Gradio разработана для инференса модели, ПОСЛЕ того как модель обучена.",
		}
	]}
/>

### 2. Gradio работает ТОЛЬКО с моделями PyTorch

<Question
	choices={[
        {
			text: "Истина",
			explain: "Gradio работает с моделями PyTorch, но также работает с любым типом моделей машинного обучения!"
        },
        {
			text: "Ложь",
			explain: "Gradio не зависит от модели, то есть вы можете создать демо для любого типа модели машинного обучения.",
			correct: true
        }
	]}
/>

### 3. Где можно запустить демо Gradio?

<Question
	choices={[
        {
			text: "Стандартные IDE для python",
			explain: "Gradio отлично работает с вашей любимой IDE.",
            correct: true
        },
        {
			text: "Блокноты Google Colab",
			explain: "Вы можете создать и запустить демо в своем блокноте Google colab.",
			correct: true
        },
        {
			text: "Блокноты Jupyter",
			explain: "Отличный выбор - вы можете создать и запустить демо в блокноте Jupyter.",
			correct: true
        }
	]}
/>

### 4. Gradio предназначен в первую очередь для моделей NLP

<Question
	choices={[
        {
			text: "Истина",
			explain: "Gradio работает практически с любым типом данных, а не только с NLP."
        },
        {
			text: "Ложь",
			explain: "Gradio предоставляет разработчикам библиотеку готовых компонентов практически для всех типов данных.",
            correct: true
        }
	]}
/>

### 5. Какие из следующих функций поддерживаются Gradio?

<Question
	choices={[
        {
			text: "Множественные входы и выходы",
			explain: "С помощью Gradio можно использовать несколько входов и выходов. Все, что вам нужно сделать, это передать список входов и выходов в соответствующие им параметры",
            correct: true
        },
        {
			text: "Сохранение состояния данных",
			explain: "Gradio позволяет добавлять состояние в ваш интерфейс.",
			correct: true
        },
        {
			text: "Аутентификация с помощью имен пользователей и паролей",
			explain: "Передайте список кортежей имен пользователей/паролей в метод запуска для добавления аутентификации.",
			correct: true
        },
        {
			text: "Автоматический анализ того, кто использует ваше демо Gradio",
			explain: "Попробуйте еще раз - Gradio не предоставляет разработчикам аналитику о том, кто использует их демо."
        },
        {
			text: "Загрузка модели из хаба моделей Hugging Face Hub или Hugging Face Spaces",
			explain: "Абсолютно точно - загрузите любую модель Hugging Face, используя метод <code>gr.Interface.load()</code>.",
			correct: true
        }
	]}
/>

### 6. Какие из следующих способов загрузки модели Hugging Face из Hub или Spaces являются правильными?

<Question
	choices={[
        {
			text: "gr.Interface.load('huggingface/{user}/{model_name}')",
			explain: "Это правильный метод загрузки модели Hugging Face из Hub",
            correct: true
        },
        {
			text: "gr.Interface.load('model/{user}/{model_name}')",
			explain: "Это правильный метод загрузки модели Hugging Face из Hub",
			correct: true
        },
        {
			text: "gr.Interface.load('demos/{user}/{model_name}')",
			explain: "Попробуйте еще раз - вы не можете загрузить модель, используя префикс 'demos'."
        },
        {
			text: "gr.Interface.load('spaces/{user}/{model_name}')",
			explain: "Это правильный метод загрузки модели Hugging Face из Spaces",
			correct: true
        }
	]}
/>

### 7. Выберите все шаги, необходимые для добавления состояния в интерфейс Gradio

<Question
	choices={[
        {
			text: "Передать в функцию прогнозирования дополнительный параметр, который представляет собой состояние интерфейса.",
			explain: "Необходим дополнительный параметр, хранящий историю или состояние вашего интерфейса.",
            correct: true
        },
        {
			text: "В конце функции прогнозирования верните обновленное значение состояния в качестве дополнительного возвращаемого значения.",
			explain: "Это значение истории или состояния должно быть возвращено вашей функцией.",
            correct: true
        },
        {
			text: "Добавьте компоненты ввода состояния и вывода состояния при создании интерфейса",
			explain: "Gradio предоставляет компонент ввода и вывода состояния для сохранения данных.",
            correct: true
        }
	]}
/>

### 8. Какие из перечисленных ниже компонентов входят в библиотеку Gradio?

<Question
	choices={[
        {
			text: "Textbox.",
			explain: "Да, вы можете создавать текстовые поля с помощью компонента Textbox.",
            correct: true
        },
        {
			text: "Graph.",
			explain: "В настоящее время компонент Graph отсутствует.",
        },
        {
			text: "Image.",
			explain: "Да, вы можете создать виджет загрузки изображений с помощью компонента Image.",
            correct: true
        },
        {
			text: "Audio.",
			explain: "Да, вы можете создать виджет загрузки звука с помощью компонента Audio.",
            correct: true
        },
	]}
/>

### 9. Что позволяет делать Gradio `Blocks`?

<Question
	choices={[
        {
			text: "Объедините несколько демо в одно веб-приложение",
			explain: "Вы можете использовать функцию `with gradio.Tabs():`, чтобы добавить вкладки для нескольких демо",
			correct: true
        },
        {
			text: "Назначение триггеров событий, таких как clicked/changed/ и так далее, для компонентов `Blocks`.",
			explain: "Когда вы назначаете событие, вы передаете три параметра: fn - функция, которая должна быть вызвана, inputs - (список) компонентов ввода и outputs - (список) компонентов вывода, которые должны быть вызваны.",
			correct: true
        },
        {
			text: "Автоматическое определение того, какой компонент `Blocks` должен быть интерактивным, а какой статичным",
			explain: "Основываясь на определенных вами триггерах событий, `Blocks` автоматически определяет, должен ли компонент принимать пользовательский ввод или нет.",
			correct: true
        },
		 {
			text: "Создавать многоступенчатые демо; это означает, что вы можете повторно использовать результаты работы одного компонента в качестве исходных данных для следующего.",
			explain: "Вы можете использовать компонент в качестве входа для одного триггера событий, но выхода для другого.",
            correct: true
        },
	]}
/>

### 10. Вы можете поделиться публичной ссылкой на демо `Blocks` и разместить демо `Blocks` в пространстве Hugging Face.

<Question
	choices={[
        {
			text: "Истина",
			explain: "Как и в случае с `Interface`, все возможности обмена и хостинга одинаковы для демо `Blocks`!",
			correct: true
        },
        {
			text: "Ложь",
			explain: "Как и в случае с `Interface`, все возможности обмена и хостинга одинаковы для демо `Blocks`!",
			correct: false
        }
	]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter9/9.mdx" />