# సారాంశం[[summary]]

<CourseFloatingBanner chapter={1} classNames="absolute z-10 right-0 top-0" />

ఈ అధ్యాయంలో, మీరు Transformer నమూనాలు, Large Language Models (LLMs) యొక్క ప్రాథమిక అంశాలకు పరిచయం చేయబడ్డారు, మరియు అవి AI మరియు అంతకు మించి ఎలా విప్లవాత్మకంగా మారుస్తున్నాయో తెలుసుకున్నారు.

## చర్చించిన ముఖ్యమైన అంశాలు

### Natural Language Processing మరియు LLMs

NLP అంటే ఏమిటి మరియు Large Language Models ఈ రంగాన్ని ఎలా మార్చాయో మేము అన్వేషించాము. మీరు నేర్చుకున్నవి:

- NLP వర్గీకరణ నుండి జనరేషన్ వరకు విస్తృత శ్రేణి పనులను కలిగి ఉంటుంది
- LLMs అనేవి భారీ మొత్తంలో టెక్స్ట్ డేటాపై శిక్షణ పొందిన శక్తివంతమైన నమూనాలు
- ఈ నమూనాలు ఒకే ఆర్కిటెక్చర్‌లో బహుళ పనులను చేయగలవు
- వాటి సామర్థ్యాలు ఉన్నప్పటికీ, LLMs కు భ్రాంతులు మరియు పక్షపాతం వంటి పరిమితులు ఉన్నాయి

### Transformer సామర్థ్యాలు

🤗 Transformers నుండి `pipeline()` ఫంక్షన్ వివిధ పనుల కోసం ముందుగా శిక్షణ పొందిన నమూనాలను ఉపయోగించడాన్ని ఎలా సులభతరం చేస్తుందో మీరు చూశారు:

- టెక్స్ట్ వర్గీకరణ, టోకెన్ వర్గీకరణ, మరియు ప్రశ్న సమాధానం
- టెక్స్ట్ జనరేషన్ మరియు సారాంశం
- అనువాదం మరియు ఇతర సీక్వెన్స్-టు-సీక్వెన్స్ పనులు
- ప్రసంగ గుర్తింపు మరియు చిత్ర వర్గీకరణ

### Transformer ఆర్కిటెక్చర్

Transformer నమూనాలు ఉన్నత స్థాయిలో ఎలా పనిచేస్తాయో మేము చర్చించాము, వీటితో సహా:

- అటెన్షన్ మెకానిజం యొక్క ప్రాముఖ్యత
- ట్రాన్స్‌ఫర్ లెర్నింగ్ నమూనాలను నిర్దిష్ట పనులకు అనుగుణంగా మార్చడానికి ఎలా వీలు కల్పిస్తుంది
- మూడు ప్రధాన ఆర్కిటెక్చరల్ వేరియంట్‌లు: ఎన్‌కోడర్-మాత్రమే, డీకోడర్-మాత్రమే, మరియు ఎన్‌కోడర్-డీకోడర్

### మోడల్ ఆర్కిటెక్చర్‌లు మరియు వాటి అనువర్తనాలు

ఈ అధ్యాయంలోని ఒక ముఖ్యమైన అంశం ఏమిటంటే, వివిధ పనుల కోసం ఏ ఆర్కిటెక్చర్‌ను ఉపయోగించాలో అర్థం చేసుకోవడం:

| మోడల్             | ఉదాహరణలు                     | పనులు                                                                         |
| ----------------- | ---------------------------- | ----------------------------------------------------------------------------- |
| ఎన్‌కోడర్-మాత్రమే | BERT, DistilBERT, ModernBERT | వాక్య వర్గీకరణ, నేమ్డ్ ఎంటిటీ రికగ్నిషన్, ఎక్స్‌ట్రాక్టివ్ క్వశ్చన్ ఆన్సరింగ్ |
| డీకోడర్-మాత్రమే   | GPT, LLaMA, Gemma, SmolLM    | టెక్స్ట్ జనరేషన్, సంభాషణ AI, సృజనాత్మక రచన                                    |
| ఎన్‌కోడర్-డీకోడర్ | BART, T5, Marian, mBART      | సారాంశం, అనువాదం, జెనరేటివ్ క్వశ్చన్ ఆన్సరింగ్                                |

### ఆధునిక LLM అభివృద్ధిలు

ఈ రంగంలో ఇటీవలి పరిణామాల గురించి కూడా మీరు తెలుసుకున్నారు:

- కాలక్రమేణా LLMs పరిమాణంలో మరియు సామర్థ్యంలో ఎలా పెరిగాయి
- స్కేలింగ్ చట్టాల భావన మరియు అవి మోడల్ అభివృద్ధికి ఎలా మార్గనిర్దేశం చేస్తాయి
- పొడవైన సీక్వెన్స్‌లను ప్రాసెస్ చేయడానికి మోడళ్లకు సహాయపడే ప్రత్యేక అటెన్షన్ మెకానిజమ్స్
- ప్రీట్రైనింగ్ మరియు ఇన్‌స్ట్రక్షన్ ట్యూనింగ్ యొక్క రెండు-దశల శిక్షణ విధానం

### ఆచరణాత్మక అనువర్తనాలు

అధ్యాయం అంతటా, ఈ నమూనాలను వాస్తవ-ప్రపంచ సమస్యలకు ఎలా వర్తింపజేయవచ్చో మీరు చూశారు:

- ముందుగా శిక్షణ పొందిన నమూనాలను కనుగొని ఉపయోగించడానికి Hugging Face Hub ను ఉపయోగించడం
- మీ బ్రౌజర్‌లో నేరుగా నమూనాలను పరీక్షించడానికి Inference API ని ఉపయోగించడం
- నిర్దిష్ట పనులకు ఏ నమూనాలు ఉత్తమంగా సరిపోతాయో అర్థం చేసుకోవడం

## భవిష్యత్తు ప్రణాళిక

Transformer నమూనాలు అంటే ఏమిటి మరియు అవి ఉన్నత స్థాయిలో ఎలా పనిచేస్తాయో ఇప్పుడు మీకు దృఢమైన అవగాహన ఉంది కాబట్టి, వాటిని సమర్థవంతంగా ఎలా ఉపయోగించాలో లోతుగా పరిశోధించడానికి మీరు సిద్ధంగా ఉన్నారు. తదుపరి అధ్యాయాలలో, మీరు ఎలా చేయాలో నేర్చుకుంటారు:

- నమూనాలను లోడ్ చేయడానికి మరియు ఫైన్-ట్యూన్ చేయడానికి Transformers లైబ్రరీని ఉపయోగించడం
- మోడల్ ఇన్‌పుట్ కోసం వివిధ రకాల డేటాను ప్రాసెస్ చేయడం
- మీ నిర్దిష్ట పనులకు ముందుగా శిక్షణ పొందిన నమూనాలను అనుకూలీకరించడం
- ఆచరణాత్మక అనువర్తనాల కోసం నమూనాలను అమలు చేయడం

ఈ అధ్యాయంలో మీరు నిర్మించుకున్న పునాది, రాబోయే విభాగాలలో మీరు మరింత ఆధునిక అంశాలు మరియు పద్ధతులను అన్వేషించేటప్పుడు మీకు బాగా ఉపయోగపడుతుంది.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/te/chapter1/10.mdx" />