# Transformerలు ఎలా పనిచేస్తాయి?[[how-do-transformers-work]]

<CourseFloatingBanner chapter={1} classNames="absolute z-10 right-0 top-0" />

ఈ విభాగంలో, మనం Transformer మోడల్స్ యొక్క ఆర్కిటెక్చర్‌ను పరిశీలిద్దాం మరియు అటెన్షన్, ఎన్‌కోడర్-డీకోడర్ ఆర్కిటెక్చర్ వంటి భావనలను లోతుగా చర్చిద్దాం.

<Tip warning={true}>

🚀 ఇక్కడ మనం విషయాలను మరింత లోతుగా తెలుసుకుంటున్నాం. ఈ విభాగం వివరంగా మరియు సాంకేతికంగా ఉంటుంది, కాబట్టి మీరు వెంటనే అన్నింటినీ అర్థం చేసుకోకపోయినా చింతించకండి. కోర్సులో తరువాత ఈ భావనల వద్దకు మనం తిరిగి వస్తాము.

</Tip>

## Transformerల చరిత్ర గురించి కొంచెం[[a-bit-of-transformer-history]]

Transformer మోడల్స్ యొక్క (సంక్షిప్త) చరిత్రలో కొన్ని ముఖ్యమైన ఘట్టాలు ఇక్కడ ఉన్నాయి:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono.svg" alt="A brief chronology of Transformers models.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono-dark.svg" alt="A brief chronology of Transformers models.">
</div>

[Transformer ఆర్కిటెక్చర్](https://arxiv.org/abs/1706.03762) జూన్ 2017లో పరిచయం చేయబడింది. అసలు పరిశోధన యొక్క ముఖ్య ఉద్దేశ్యం అనువాద పనులపై ఉండేది. దీని తర్వాత అనేక ప్రభావవంతమైన మోడల్స్ వచ్చాయి, వాటిలో కొన్ని:

- **జూన్ 2018**: [GPT](https://cdn.openai.com/research-covers/language-unsupervised/language_understanding_paper.pdf), మొదటి ప్రీ-ట్రైన్డ్ Transformer మోడల్. ఇది వివిధ NLP పనులపై ఫైన్-ట్యూనింగ్ కోసం ఉపయోగించబడింది మరియు అత్యుత్తమ ఫలితాలను సాధించింది.

- **అక్టోబర్ 2018**: [BERT](https://arxiv.org/abs/1810.04805), మరొక పెద్ద ప్రీ-ట్రైన్డ్ మోడల్. ఇది వాక్యాల యొక్క మెరుగైన సారాంశాలను ఉత్పత్తి చేయడానికి రూపొందించబడింది (దీని గురించి తదుపరి అధ్యాయంలో మరింత!)

- **ఫిబ్రవరి 2019**: [GPT-2](https://cdn.openai.com/better-language-models/language_models_are_unsupervised_multitask_learners.pdf), GPT యొక్క మెరుగైన (మరియు పెద్ద) వెర్షన్, ఇది నైతిక ఆందోళనల కారణంగా వెంటనే బహిరంగంగా విడుదల కాలేదు.

- **అక్టోబర్ 2019**: [T5](https://huggingface.co/papers/1910.10683), సీక్వెన్స్-టు-సీక్వెన్స్ Transformer ఆర్కిటెక్చర్ యొక్క బహుళ-పని ఆధారిత అమలు.

- **మే 2020**, [GPT-3](https://huggingface.co/papers/2005.14165), GPT-2 యొక్క మరింత పెద్ద వెర్షన్. ఇది ఫైన్-ట్యూనింగ్ అవసరం లేకుండా వివిధ పనులపై బాగా పనిచేయగలదు (_zero-shot learning_ అని పిలుస్తారు).

- **జనవరి 2022**: [InstructGPT](https://huggingface.co/papers/2203.02155), సూచనలను మరింత మెరుగ్గా పాటించడానికి శిక్షణ పొందిన GPT-3 యొక్క వెర్షన్.

- **జనవరి 2023**: [Llama](https://huggingface.co/papers/2302.13971), వివిధ భాషలలో టెక్స్ట్‌ను ఉత్పత్తి చేయగల ఒక పెద్ద భాషా నమూనా.

- **మార్చి 2023**: [Mistral](https://huggingface.co/papers/2310.06825), 7-బిలియన్-పారామీటర్ల భాషా నమూనా, ఇది అన్ని మూల్యాంకన బెంచ్‌మార్క్‌లలో Llama 2 13B ను అధిగమించింది. వేగవంతమైన ఇన్ఫరెన్స్ కోసం గ్రూప్డ్-క్వరీ అటెన్షన్ మరియు ఏకపక్ష పొడవు గల సీక్వెన్సులను నిర్వహించడానికి స్లైడింగ్ విండో అటెన్షన్‌ను ఉపయోగిస్తుంది.

- **మే 2024**: [Gemma 2](https://huggingface.co/papers/2408.00118), 2B నుండి 27B పారామీటర్ల వరకు ఉండే తేలికపాటి, అత్యాధునిక ఓపెన్ మోడల్స్ యొక్క కుటుంబం. ఇవి ఇంటర్లీవ్డ్ లోకల్-గ్లోబల్ అటెన్షన్స్ మరియు గ్రూప్-క్వరీ అటెన్షన్‌ను కలిగి ఉంటాయి, మరియు 2-3 రెట్లు పెద్ద మోడల్స్‌తో పోటీపడే పనితీరును అందించడానికి నాలెడ్జ్ డిస్టిలేషన్ ఉపయోగించి చిన్న మోడల్స్‌కు శిక్షణ ఇవ్వబడింది.

- **నవంబర్ 2024**: [SmolLM2](https://huggingface.co/papers/2502.02737), అత్యాధునిక చిన్న భాషా నమూనా (135 మిలియన్ల నుండి 1.7 బిలియన్ల పారామీటర్లు), ఇది దాని కాంపాక్ట్ సైజు ఉన్నప్పటికీ ఆకట్టుకునే పనితీరును సాధిస్తుంది మరియు మొబైల్ మరియు ఎడ్జ్ పరికరాల కోసం కొత్త అవకాశాలను అన్‌లాక్ చేస్తుంది.

ఈ జాబితా పూర్తి కాదు మరియు ఇది కేవలం కొన్ని రకాల Transformer నమూనాలను హైలైట్ చేయడానికి మాత్రమే ఉద్దేశించబడింది. విస్తృతంగా, వీటిని మూడు వర్గాలుగా విభజించవచ్చు:

- GPT-లాంటి (వీటిని _auto-regressive_ Transformer మోడల్స్ అని కూడా అంటారు)
- BERT-లాంటి (వీటిని _auto-encoding_ Transformer మోడల్స్ అని కూడా అంటారు)
- T5-లాంటి (వీటిని _sequence-to-sequence_ Transformer మోడల్స్ అని కూడా అంటారు)

మనం ఈ కుటుంబాల గురించి తరువాత మరింత లోతుగా చర్చిస్తాము.

## Transformer లు భాషా నమూనాలు[[transformers-are-language-models]]

పైన పేర్కొన్న అన్ని Transformer మోడల్స్ (GPT, BERT, T5, మొదలైనవి) _భాషా నమూనాలుగా_ శిక్షణ పొందాయి. అంటే అవి స్వీయ-పర్యవేక్షిత పద్ధతిలో భారీ మొత్తంలో ముడి టెక్స్ట్‌పై శిక్షణ పొందాయి.

స్వీయ-పర్యవేక్షిత అభ్యాసం (Self-supervised learning) అనేది ఒక రకమైన శిక్షణ, దీనిలో మోడల్ యొక్క ఇన్‌పుట్‌ల నుండి లక్ష్యం స్వయంచాలకంగా లెక్కించబడుతుంది. అంటే డేటాను లేబుల్ చేయడానికి మానవులు అవసరం లేదు!

ఈ రకమైన మోడల్, శిక్షణ పొందిన భాషపై గణాంక అవగాహనను పెంచుకుంటుంది, కానీ ఇది నిర్దిష్ట ఆచరణాత్మక పనులకు అంతగా ఉపయోగపడదు. ఈ కారణంగా, సాధారణ ప్రీ-ట్రైన్డ్ మోడల్ తరువాత _ట్రాన్స్‌ఫర్ లెర్నింగ్_ లేదా _ఫైన్-ట్యూనింగ్_ అనే ప్రక్రియ ద్వారా వెళుతుంది. ఈ ప్రక్రియలో, మోడల్ ఒక నిర్దిష్ట పనిపై పర్యవేక్షిత పద్ధతిలో — అంటే, మానవ-అన్నొటేటెడ్ లేబుల్స్ ఉపయోగించి — ఫైన్-ట్యూన్ చేయబడుతుంది.

ఒక పనికి ఉదాహరణ, ఒక వాక్యం లోని _n_ మునుపటి పదాలను చదివిన తరువాత తదుపరి పదాన్ని అంచనా వేయడం. దీనిని _కాజువల్ లాంగ్వేజ్ మోడలింగ్_ అని అంటారు, ఎందుకంటే అవుట్‌పుట్ గతం మరియు ప్రస్తుత ఇన్‌పుట్‌లపై ఆధారపడి ఉంటుంది, కానీ భవిష్యత్తు వాటిపై కాదు.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling-dark.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
</div>

మరొక ఉదాహరణ _Masked language modelling_, దీనిలో మోడల్ వాక్యంలోని మాస్క్ చేయబడిన పదాన్ని అంచనా వేస్తుంది.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling-dark.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
</div>

## Transformerలు పెద్ద నమూనాలు[[transformers-are-big-models]]

కొన్ని మినహాయింపులు (DistilBERT వంటివి) తప్ప, మెరుగైన పనితీరును సాధించడానికి సాధారణ వ్యూహం, మోడల్స్ యొక్క పరిమాణాలను అలాగే అవి ప్రీ-ట్రైనింగ్ చేయబడిన డేటా మొత్తాన్ని పెంచడం.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/model_parameters.png" alt="Number of parameters of recent Transformers models" width="90%">
</div>

దురదృష్టవశాత్తు, ఒక మోడల్‌ను, ముఖ్యంగా పెద్ద మోడల్‌ను శిక్షణ ఇవ్వడానికి, పెద్ద మొత్తంలో డేటా అవసరం. సమయం మరియు గణన వనరుల పరంగా ఇది చాలా ఖర్చుతో కూడుకున్నది. ఇది పర్యావరణ ప్రభావానికి కూడా దారితీస్తుంది, కింది గ్రాఫ్‌లో చూడవచ్చు.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint.svg" alt="The carbon footprint of a large language model.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint-dark.svg" alt="The carbon footprint of a large language model.">
</div>

<Youtube id="ftWlj4FBHTg" />

మరియు ఇది ప్రీ-ట్రైనింగ్ యొక్క పర్యావరణ ప్రభావాన్ని తగ్గించడానికి స్పృహతో ప్రయత్నిస్తున్న ఒక బృందం నేతృత్వంలోని ఒక (చాలా పెద్ద) మోడల్ కోసం ఒక ప్రాజెక్ట్‌ను చూపుతోంది. ఉత్తమ హైపర్‌పారామీటర్‌లను పొందడానికి చాలా ట్రయల్స్ నడపడం యొక్క ఫుట్‌ప్రింట్ ఇంకా ఎక్కువగా ఉంటుంది.

ఒక పరిశోధన బృందం, ఒక విద్యార్థి సంస్థ, లేదా ఒక సంస్థ ప్రతిసారీ ఒక మోడల్‌ను శిక్షణ ఇవ్వాలనుకుంటే, అది మొదటి నుండి అలా చేస్తే ఎలా ఉంటుందో ఊహించండి. ఇది భారీ, అనవసరమైన ప్రపంచ వ్యయాలకు దారితీస్తుంది!

అందుకే భాషా నమూనాలను పంచుకోవడం చాలా ముఖ్యం: శిక్షణ పొందిన వెయిట్స్ పంచుకోవడం మరియు ఇప్పటికే శిక్షణ పొందిన వెయిట్స్ పైన నిర్మించడం ద్వారా కమ్యూనిటీ యొక్క మొత్తం గణన వ్యయాన్ని మరియు కార్బన్ ఫుట్‌ప్రింట్‌ను తగ్గిస్తుంది.

అలాగే, మీరు మీ మోడల్స్ శిక్షణ యొక్క కార్బన్ ఫుట్‌ప్రింట్‌ను అనేక సాధనాల ద్వారా మూల్యాంకనం చేయవచ్చు. ఉదాహరణకు [ML CO2 Impact](https://mlco2.github.io/impact/) లేదా [Code Carbon](https://codecarbon.io/) ఇది 🤗 Transformers లో విలీనం చేయబడింది. దీని గురించి మరింత తెలుసుకోవడానికి, మీరు ఈ [బ్లాగ్ పోస్ట్](https://huggingface.co/blog/carbon-emissions-on-the-hub) చదవచ్చు, ఇది మీ శిక్షణ యొక్క ఫుట్‌ప్రింట్ యొక్క అంచనాతో `emissions.csv` ఫైల్‌ను ఎలా రూపొందించాలో చూపుతుంది, అలాగే ఈ అంశాన్ని పరిష్కరించే 🤗 Transformers యొక్క [డాక్యుమెంటేషన్](https://huggingface.co/docs/hub/model-cards-co2) కూడా చూడవచ్చు.

## ట్రాన్స్‌ఫర్ లెర్నింగ్[[transfer-learning]]

<Youtube id="BqqfQnyjmgg" />

_Pretraining_ అంటే ఒక మోడల్‌ను మొదటి నుండి శిక్షణ ఇవ్వడం: వెయిట్స్ యాదృచ్ఛికంగా ప్రారంభించబడతాయి మరియు శిక్షణ ఎటువంటి ముందస్తు జ్ఞానం లేకుండా మొదలవుతుంది.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining.svg" alt="The pretraining of a language model is costly in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining-dark.svg" alt="The pretraining of a language model is costly in both time and money.">
</div>

ఈ ప్రీ-ట్రైనింగ్ సాధారణంగా చాలా పెద్ద మొత్తంలో డేటాపై జరుగుతుంది. అందువల్ల, దీనికి చాలా పెద్ద డేటా కార్పస్ అవసరం, మరియు శిక్షణ పూర్తి కావడానికి చాలా వారాలు పట్టవచ్చు.

_Fine-tuning_ అనేది, ఒక మోడల్ ప్రీ-ట్రైనింగ్ చేయబడిన **తరువాత** జరిగే శిక్షణ. ఫైన్-ట్యూనింగ్ చేయడానికి, మీరు మొదట ఒక ప్రీ-ట్రైన్డ్ భాషా నమూనాను పొందుతారు, ఆపై మీ పనికి సంబంధించిన నిర్దిష్ట డేటాసెట్‌తో అదనపు శిక్షణ ఇస్తారు. ఒక్క నిమిషం -- మీ తుది వినియోగం కోసం మోడల్‌ను మొదటి నుండి (**scratch**) ఎందుకు శిక్షణ ఇవ్వకూడదు? దీనికి కొన్ని కారణాలు ఉన్నాయి:

- ప్రీ-ట్రైన్డ్ మోడల్ ఇప్పటికే ఫైన్-ట్యూనింగ్ డేటాసెట్‌తో కొన్ని సారూప్యతలను కలిగి ఉన్న డేటాసెట్‌పై శిక్షణ పొందింది. అందువల్ల ఫైన్-ట్యూనింగ్ ప్రక్రియ ప్రీ-ట్రైనింగ్ సమయంలో ప్రారంభ మోడల్ పొందిన జ్ఞానాన్ని ఉపయోగించుకోగలదు (ఉదాహరణకు, NLP సమస్యలతో, ప్రీ-ట్రైన్డ్ మోడల్ మీ పని కోసం మీరు ఉపయోగిస్తున్న భాషపై ఒకరకమైన గణాంక అవగాహనను కలిగి ఉంటుంది).
- ప్రీ-ట్రైన్డ్ మోడల్ ఇప్పటికే చాలా డేటాపై శిక్షణ పొందింది కాబట్టి, ఫైన్-ట్యూనింగ్‌కు మంచి ఫలితాలను పొందడానికి చాలా తక్కువ డేటా అవసరం.
- అదే కారణంతో, మంచి ఫలితాలను పొందడానికి అవసరమైన సమయం మరియు వనరులు చాలా తక్కువ.

ఉదాహరణకు, ఇంగ్లీష్ భాషపై శిక్షణ పొందిన ఒక ప్రీ-ట్రైన్డ్ మోడల్‌ను ఉపయోగించి, ఆ తర్వాత దాన్ని ఒక arXiv కార్పస్‌పై ఫైన్-ట్యూన్ చేయడం ద్వారా ఒక సైన్స్/పరిశోధన ఆధారిత మోడల్‌ను పొందవచ్చు. ఫైన్-ట్యూనింగ్‌కు పరిమిత మొత్తంలో డేటా మాత్రమే అవసరం: ప్రీ-ట్రైన్డ్ మోడల్ పొందిన జ్ఞానం "బదిలీ" చేయబడుతుంది, అందుకే _ట్రాన్స్‌ఫర్ లెర్నింగ్_ అనే పదం వచ్చింది.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning-dark.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
</div>

అందువల్ల, ఒక మోడల్‌ను ఫైన్-ట్యూన్ చేయడం తక్కువ సమయం, డేటా, ఆర్థిక, మరియు పర్యావరణ వ్యయాలను కలిగి ఉంటుంది. పూర్తి ప్రీ-ట్రైనింగ్ కంటే శిక్షణ తక్కువ నిర్బంధంగా ఉన్నందున, వివిధ ఫైన్-ట్యూనింగ్ స్కీమ్‌లను పునరావృతం చేయడం కూడా వేగంగా మరియు సులభంగా ఉంటుంది.

ఈ ప్రక్రియ సున్నా నుండి శిక్షణ ఇవ్వడం కంటే మెరుగైన ఫలితాలను సాధిస్తుంది (మీరు చాలా డేటాను కలిగి ఉంటే తప్ప), అందుకే మీరు ఎల్లప్పుడూ ఒక ప్రీ-ట్రైన్డ్ మోడల్‌ను ఉపయోగించుకోవడానికి ప్రయత్నించాలి -- మీ చేతిలో ఉన్న పనికి వీలైనంత దగ్గరగా ఉన్న దాన్ని — మరియు దానిని ఫైన్-ట్యూన్ చేయాలి.

## సాధారణ Transformer ఆర్కిటెక్చర్[[general-transformer-architecture]]

ఈ విభాగంలో, మనం Transformer మోడల్ యొక్క సాధారణ ఆర్కిటెక్చర్‌ను పరిశీలిద్దాం. మీకు కొన్ని భావనలు అర్థం కాకపోయినా చింతించకండి; ప్రతి భాగాన్ని కవర్ చేసే వివరణాత్మక విభాగాలు తరువాత ఉన్నాయి.

<Youtube id="H39Z_720T5s" />

ఈ మోడల్ ప్రధానంగా రెండు బ్లాక్‌లతో కూడి ఉంటుంది:

- **ఎన్‌కోడర్ (ఎడమవైపు)**: ఎన్‌కోడర్ ఒక ఇన్‌పుట్‌ను స్వీకరించి దాని యొక్క ప్రాతినిధ్యాన్ని (దాని ఫీచర్స్) నిర్మిస్తుంది. అంటే ఈ మోడల్ ఇన్‌పుట్ నుండి అవగాహనను పొందడానికి ఆప్టిమైజ్ చేయబడింది.
- **డీకోడర్ (కుడివైపు)**: డీకోడర్, ఎన్‌కోడర్ యొక్క ప్రాతినిధ్యాన్ని (ఫీచర్స్) మరియు ఇతర ఇన్‌పుట్‌లను ఉపయోగించి ఒక లక్ష్య సీక్వెన్స్‌ను ఉత్పత్తి చేస్తుంది. అంటే ఈ మోడల్ అవుట్‌పుట్‌లను ఉత్పత్తి చేయడానికి ఆప్టిమైజ్ చేయబడింది.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks-dark.svg" alt="Architecture of a Transformers models">
</div>

ఈ భాగాలలో ప్రతి ఒక్కటి పనిని బట్టి స్వతంత్రంగా ఉపయోగించవచ్చు:

- **ఎన్‌కోడర్-మాత్రమే మోడల్స్**: వాక్య వర్గీకరణ మరియు పేరుగల ఎంటిటీ గుర్తింపు వంటి ఇన్‌పుట్ అవగాహన అవసరమయ్యే పనులకు మంచివి.
- **డీకోడర్-మాత్రమే మోడల్స్**: టెక్స్ట్ జనరేషన్ వంటి ఉత్పాదక పనులకు మంచివి.
- **ఎన్‌కోడర్-డీకోడర్ మోడల్స్** లేదా **సీక్వెన్స్-టు-సీక్వెన్స్ మోడల్స్**: అనువాదం లేదా సారాంశీకరణ వంటి ఇన్‌పుట్ అవసరమయ్యే ఉత్పాదక పనులకు మంచివి.

మనం ఈ ఆర్కిటెక్చర్లను తరువాత విభాగాలలో స్వతంత్రంగా పరిశీలిస్తాము.

## అటెన్షన్ లేయర్లు[[attention-layers]]

Transformer మోడల్స్ యొక్క ఒక ముఖ్య లక్షణం ఏమిటంటే, అవి _అటెన్షన్ లేయర్లు_ అనే ప్రత్యేక లేయర్లతో నిర్మించబడ్డాయి. నిజానికి, Transformer ఆర్కిటెక్చర్‌ను పరిచయం చేసిన పేపర్ శీర్షిక ["Attention Is All You Need"](https://arxiv.org/abs/1706.03762)! మనం కోర్సులో తరువాత అటెన్షన్ లేయర్ల వివరాలను అన్వేషిస్తాము; ప్రస్తుతానికి, మీరు తెలుసుకోవలసినది ఏమిటంటే, ఈ లేయర్, మీరు పంపిన వాక్యంలోని ప్రతి పదం యొక్క ప్రాతినిధ్యంతో వ్యవహరించేటప్పుడు, ఆ వాక్యంలోని కొన్ని నిర్దిష్ట పదాలపై ప్రత్యేక శ్రద్ధ పెట్టమని మోడల్‌కు చెబుతుంది (మరియు ఇతరులను ఎక్కువ లేదా తక్కువ విస్మరించమని).

దీనిని సందర్భంలో ఉంచాలంటే, ఇంగ్లీష్ నుండి ఫ్రెంచ్‌కు టెక్స్ట్‌ను అనువదించే పనిని పరిగణించండి. "You like this course" అనే ఇన్‌పుట్ ఇచ్చినప్పుడు, ఒక అనువాద మోడల్ "like" అనే పదం యొక్క సరైన అనువాదాన్ని పొందడానికి ప్రక్కనే ఉన్న "You" అనే పదంపై కూడా శ్రద్ధ పెట్టాలి, ఎందుకంటే ఫ్రెంచ్‌లో "like" అనే క్రియ సబ్జెక్ట్‌ను బట్టి విభిన్నంగా సంయోగం చేయబడుతుంది. అయితే, వాక్యంలోని మిగిలిన భాగం ఆ పదం యొక్క అనువాదానికి ఉపయోగపడదు. అదే విధంగా, "this" ను అనువదించేటప్పుడు మోడల్ "course" అనే పదంపై కూడా శ్రద్ధ పెట్టాలి, ఎందుకంటే దానికి సంబంధించిన నామవాచకం పుంలింగమా లేదా స్త్రీలింగమా అనే దానిపై ఆధారపడి "this" విభిన్నంగా అనువదించబడుతుంది. మళ్లీ, వాక్యంలోని ఇతర పదాలు "course" యొక్క అనువాదానికి పట్టింపు లేదు. మరింత సంక్లిష్టమైన వాక్యాలతో (మరియు మరింత సంక్లిష్టమైన వ్యాకరణ నియమాలతో), ప్రతి పదాన్ని సరిగ్గా అనువదించడానికి మోడల్ వాక్యంలో ఇంకా దూరంగా కనిపించే పదాలపై ప్రత్యేక శ్రద్ధ పెట్టాల్సి ఉంటుంది.

సహజ భాషతో సంబంధం ఉన్న ఏ పనికైనా ఇదే భావన వర్తిస్తుంది: ఒక పదానికి దానంతట అదే ఒక అర్థం ఉంటుంది, కానీ ఆ అర్థం సందర్భం ద్వారా తీవ్రంగా ప్రభావితమవుతుంది, ఇది అధ్యయనం చేయబడుతున్న పదం ముందు లేదా తరువాత ఉన్న ఏ ఇతర పదం (లేదా పదాలు) అయినా కావచ్చు.

ఇప్పుడు మీకు అటెన్షన్ లేయర్ల గురించి ఒక ఆలోచన వచ్చింది కాబట్టి, Transformer ఆర్కిటెక్చర్‌ను మరింత నిశితంగా పరిశీలిద్దాం.

## అసలు ఆర్కిటెక్చర్[[the-original-architecture]]

Transformer ఆర్కిటెక్చర్ వాస్తవానికి అనువాదం కోసం రూపొందించబడింది. శిక్షణ సమయంలో, ఎన్‌కోడర్ ఒక నిర్దిష్ట భాషలో ఇన్‌పుట్‌లను (వాక్యాలను) స్వీకరిస్తుంది, అయితే డీకోడర్ అవే వాక్యాలను కావలసిన లక్ష్య భాషలో స్వీకరిస్తుంది. ఎన్‌కోడర్‌లో, అటెన్షన్ లేయర్లు ఒక వాక్యంలోని అన్ని పదాలను ఉపయోగించగలవు (ఎందుకంటే, మనం ఇప్పుడు చూసినట్లుగా, ఒక నిర్దిష్ట పదం యొక్క అనువాదం వాక్యంలోని దాని తరువాత మరియు ముందు ఉన్న వాటిపై ఆధారపడి ఉండవచ్చు). అయితే, డీకోడర్ వరుసగా పనిచేస్తుంది మరియు అది ఇప్పటికే అనువదించిన వాక్యంలోని పదాలపై మాత్రమే శ్రద్ధ పెట్టగలదు (అందుకే, ప్రస్తుతం ఉత్పత్తి చేయబడుతున్న పదం ముందు ఉన్న పదాలు మాత్రమే). ఉదాహరణకు, మనం అనువదించబడిన లక్ష్యం యొక్క మొదటి మూడు పదాలను అంచనా వేసినప్పుడు, వాటిని డీకోడర్‌కు ఇస్తాము, అది తరువాత నాల్గవ పదాన్ని అంచనా వేయడానికి ఎన్‌కోడర్ యొక్క అన్ని ఇన్‌పుట్‌లను ఉపయోగిస్తుంది.

శిక్షణ సమయంలో వేగాన్ని పెంచడానికి (మోడల్‌కు లక్ష్య వాక్యాలకు యాక్సెస్ ఉన్నప్పుడు), డీకోడర్‌కు మొత్తం లక్ష్యం ఇవ్వబడుతుంది, కానీ భవిష్యత్తు పదాలను ఉపయోగించడానికి అనుమతించబడదు (స్థానం 2 వద్ద పదాన్ని అంచనా వేయడానికి ప్రయత్నిస్తున్నప్పుడు స్థానం 2 వద్ద పదానికి యాక్సెస్ ఉంటే, సమస్య చాలా కష్టంగా ఉండదు!). ఉదాహరణకు, నాల్గవ పదాన్ని అంచనా వేయడానికి ప్రయత్నిస్తున్నప్పుడు, అటెన్షన్ లేయర్ కేవలం 1 నుండి 3 వరకు ఉన్న స్థానాలలోని పదాలకు మాత్రమే యాక్సెస్ కలిగి ఉంటుంది.

అసలు Transformer ఆర్కిటెక్చర్ ఇలా ఉండేది, ఎడమవైపు ఎన్‌కోడర్ మరియు కుడివైపు డీకోడర్‌తో:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers-dark.svg" alt="Architecture of a Transformers models">
</div>

డీకోడర్ బ్లాక్‌లోని మొదటి అటెన్షన్ లేయర్ డీకోడర్‌కు అన్ని (గత) ఇన్‌పుట్‌లపై శ్రద్ధ చూపుతుంది, కానీ రెండవ అటెన్షన్ లేయర్ ఎన్‌కోడర్ యొక్క అవుట్‌పుట్‌ను ఉపయోగిస్తుంది. అందువల్ల ఇది ప్రస్తుత పదాన్ని ఉత్తమంగా అంచనా వేయడానికి మొత్తం ఇన్‌పుట్ వాక్యాన్ని యాక్సెస్ చేయగలదు. విభిన్న భాషలు పదాలను విభిన్న క్రమాలలో ఉంచే వ్యాకరణ నియమాలను కలిగి ఉండవచ్చు కాబట్టి లేదా వాక్యంలో తరువాత అందించిన కొన్ని సందర్భాలు ఒక నిర్దిష్ట పదం యొక్క ఉత్తమ అనువాదాన్ని నిర్ధారించడానికి సహాయకరంగా ఉండవచ్చు కాబట్టి ఇది చాలా ఉపయోగకరంగా ఉంటుంది.

_attention mask_ ను ఎన్‌కోడర్/డీకోడర్‌లో కూడా ఉపయోగించవచ్చు, మోడల్ కొన్ని ప్రత్యేక పదాలపై శ్రద్ధ పెట్టకుండా నిరోధించడానికి -- ఉదాహరణకు, వాక్యాలను బ్యాచింగ్ చేసేటప్పుడు అన్ని ఇన్‌పుట్‌లను ఒకే పొడవుకు తీసుకురావడానికి ఉపయోగించే ప్రత్యేక ప్యాడింగ్ పదం.

## ఆర్కిటెక్చర్లు vs. చెక్‌పాయింట్లు[[architecture-vs-checkpoints]]

ఈ కోర్సులో మనం Transformer మోడల్స్‌లోకి లోతుగా వెళ్తున్నప్పుడు, మీరు _architectures_ మరియు _checkpoints_ అలాగే _models_ అనే ప్రస్తావనలు చూస్తారు. ఈ పదాలకు అన్నింటికీ కొద్దిగా భిన్నమైన అర్థాలు ఉన్నాయి:

- **_architectures_**: ఇది మోడల్ యొక్క అస్థిపంజరం -- ప్రతి లేయర్ యొక్క నిర్వచనం మరియు మోడల్ లోపల జరిగే ప్రతి ఆపరేషన్.
- **_checkpoints_**: ఇవి ఒక నిర్దిష్ట ఆర్కిటెక్చర్‌లో లోడ్ చేయబడే వెయిట్స్.
- **_models_**: ఇది ఒక గొడుగు పదం, "ఆర్కిటెక్చర్" లేదా "చెక్‌పాయింట్" అంత కచ్చితమైనది కాదు: ఇది రెండు అర్థాలను సూచించవచ్చు. అస్పష్టతను తగ్గించడానికి ఈ కోర్సు ముఖ్యం అయినప్పుడు _ఆర్కిటెక్చర్_ లేదా _చెక్‌పాయింట్_ అని నిర్దిష్టంగా చెబుతుంది.

ఉదాహరణకు, BERT ఒక ఆర్కిటెక్చర్ అయితే, `bert-base-cased` అనేది BERT యొక్క మొదటి విడుదల కోసం Google బృందం శిక్షణ ఇచ్చిన వెయిట్స్ యొక్క సెట్, ఇది ఒక చెక్‌పాయింట్. అయితే, ఒకరు "BERT మోడల్" మరియు "`bert-base-cased` మోడల్" అని చెప్పవచ్చు.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/te/chapter1/4.mdx" />