# การสร้างการ์ดโมเดล (model card)

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

การ์ดโมเดลเป็นไฟล์ที่เรียกได้ว่าสำคัญพอๆกับไฟล์โมเดลและ tokenizer ใน model repository มันคือคำนิยามส่วนกลางของโมเดล เป็นสิ่งที่ทำให้มั่นใจว่าสมาชิกของชุมชนสามารถนำไปใช้ได้ (reusability) และสามารถทำซ้ำและได้ผลลัพธ์เหมือนเดิมได้ (reproducibility) และมันยังจัดเตรียมแพลตฟอร์มให้สมาชิกคนอื่นๆอาจใช้สร้างสิ่งประดิษฐ์ (artifacts) ของเขาเองได้ 

การสร้างหนังสืออ้างอิง (documenting) ถึงกระบวนการเทรนและประเมินผลช่วยให้ผู้อื่นเข้าใจถึงสิ่งที่คาดหวังได้จากโมเดลๆหนึ่ง และการให้ข้อมูลที่เพียงพอเกี่ยวกับข้อมูลที่ถูกใช้, กระบวนการเตรียมข้อมูล (preprocessing) และกระบวนการหลังจากใช้โมเดล (postprocessing) ที่ถูกทำมาทำให้มั่นใจถึงขีดจำกัด (limitations), ความลำเอียง (biases) และบริบท (contexts) ที่โมเดลเป็นและไม่เป็น ซึ่งเป็นสิ่งที่เป็นประโยชน์มากถ้าหากสามารถระบุและเข้าใจได้

ดังนั้นการสร้างการ์ดโมเดลที่อธิบายถึงโมเดลของคุณอย่างละเอียดถือเป็นขั้นตอนหนึ่งที่สำคัญมาก ในส่วนนี้เรามีเคล็ดลับบางอย่างที่จะช่วยให้คุณทำสิ่งนี้ได้ การสร้างการ์ดโมเดลนั้นถูกทำผ่านไฟล์ *README.md* ที่คุณได้เห็นก่อนหน้านี่ ซึ่งมันก็คือไฟล์ Markdown ไฟล์หนึ่ง

แนวคิด “การ์ดโมเดล” เกิดขึ้นมาจากทิศทางของงานวิจัยชิ้นหนึ่งจาก Google ซึ่งถูกแบ่งปันครั้งแรกใน ["Model Cards for Model Reporting"](https://arxiv.org/abs/1810.03993) โดย Margaret Mitchell et al. ข้อมูลส่วนใหญ่ที่เราจะพูดถึงในที่นี้มีฐานมาจากงานวิจัยชิ้นนี้ และเราแนะนำให้คุณลองดูงานวิจัยนี้เพื่อจะได้เข้าใจถึงว่าทำไมการ์ดโมเดลถึงมีความสำคัญต่อโลกที่ให้ค่าแก่ความสามารถในการทำซ้ำ (reproducibility), ความสามารถในการนำกลับมาใช้ (reusability) และความเท่าเทียม (fairness) อย่างมาก

โดยทั่วไปแล้วการ์ดโมเดลมักเริ่มต้นด้วยภาพรวมแบบสรุปย่อของโมเดลว่าโมเดลนี้มีไว้ทำอะไร ตามมาด้วยข้อมูลเพิ่มเติมในส่วนต่างๆต่อไปนี้:

- คำอธิบายโมเดล
- การนำไปใช้งานที่ควรจะเป็นและข้อจำกัดต่างๆ
- วิธีใช้
- ข้อจำกัดและความลำเอียง
- ข้อมูลที่ใช้เทรน
- ขั้นตอนการเทรน
- ผลจากการประเมิน

มาดูกันดีกว่าว่าแต่ละส่วนนี้ควรมีอะไรบ้าง

### คำอธิบายโมเดล

คำอธิบายโมเดลควรบอกรายละเอียดพื้นฐานเกี่ยวกับโมเดล ซึ่งหมายถึงสถาปัตยกรรม (architecture), เวอร์ชั่น, มาจากงานวิจัยหรือไม่, มี implementation จากแหล่งต้นทางหรือไม่, ผู้เขียน และข้อมูลทั่วไปเกี่ยวกับโมเดล ลิขสิทธิ์ทุกอย่างควรจะถูกระบุอยู่ในส่วนนี้ ข้อมูลโดยทั่วไปเกี่ยวกับกระบวนการเทรน, พารามิเตอร์ และข้อจำกัดความรับผิดชอบ (disclaimers) ที่สำคัญสามารถถูกพูดถึงในส่วนนี้ได้เช่นกัน

### การนำไปใช้งานที่ควรจะเป็นและข้อจำกัดต่างๆ

ในส่วนนี้คุณควรอธิบายกรณีการใช้งาน (use cases) ที่โมเดลถูกตั้งใจสร้างขึ้นมาเพื่อให้ใช้งาน รวมถึงภาษา, ประเภทงาน และโดเมนที่โมเดลสามารถประยุกต์ใช้ได้ ในส่วนนี้ของการ์ดโมเดลสามารถพูดถึงเกี่ยวกับสายงานที่ไม่อยู่ในขอบเขตของโมเดล และสายงานที่โมเดลไม่สามารถปฏิบัติการได้ดีที่สุด

### วิธีใช้

ส่วนนี้ควรมีตัวอย่างของการใช้งานโมเดล สามารถเป็นในรูปแบบของการใช้งานฟังก์ชั่น `pipeline()`, การใช้งานคลาสโมเดลและ tokenizer และโค้ดอื่นๆที่คุณคิดว่าน่าจะเป็นประโยชน์ได้

### ข้อมูลที่ใช้เทรน

ส่วนนี้ควรระบุถึงชุดข้อมูลที่โมเดลได้ถูกเทรนมา ถ้าหากมีคำอธิบายโดยสรุปของชุดข้อมูลก็จะดีมาก

### ขั้นตอนการเทรน

ในส่วนนี้คุณควรอธิบายทุกอย่างที่เกี่ยวข้องกับการเทรนที่เป็นประโยชน์ในมุมมองของการนำไปทำซ้ำ ซึ่งควรมีกระบวนการเตรียมข้อมูล (preprocessing) และกระบวนการหลังจากใช้โมเดล (postprocessing) ที่ถูกทำไว้กับชุดข้อมูลนี้ รวมถึงรายละเอียดเกี่ยวกับจำนวนรอบ (epochs) ที่ใช้ในการเทรนโมเดล, ขนาด batch (batch size), อัตราการเรียนรู้ (learning rate) และอื่นๆ

### ตัวแปรและเมตริก

ส่วนนี้คุณควรอธิบายเมตริก (metrics) ที่คุณใช้ในการประเมินผล และปัจจัยต่างๆที่คุณตรวจวัด การกล่าวถึงเมตริกต่างๆที่ถูกใช้ กับชุดข้อมูลไหนและแบ่งอย่างไร ช่วยทำให้การเปรียบเทียบประสิทธิภาพของโมเดลของคุณกับโมเดลอื่นๆเป็นไปได้ง่าย ซึ่งสิ่งเหล่านี้ควรจะถูกระบุอยู่ในส่วนที่ผ่านมา เช่น ผู้ใช้และการนำไปใช้งานที่ควรจะเป็น 

### ผลจากการประเมิน

ส่วนสุดท้าย คุณควรระบุข้อบ่งชี้ว่าโมเดลของคุณทำงานได้ดีแค่ไหนกับชุดข้อมูลสำหรับประเมินผล (evaluation dataset) ถ้าโมเดลมีการใช้เกณฑ์ในการตัดสินใจ (decision threshold) คุณควรระบุค่าที่ใช้เป็นเกณฑ์นั้นในการประเมินผล หรือระบุรายละเอียดของการประเมินผลที่เกณฑ์ต่างกันสำหรับการใช้งานที่ควรจะเป็น

## ตัวอย่าง

ลองเข้าไปดู links เหล่านี้เป็นตัวอย่างสำหรับการ์ดโมเดลที่ถูกขัดเกลามาอย่างดี:

- [`bert-base-cased`](https://huggingface.co/bert-base-cased)
- [`gpt2`](https://huggingface.co/gpt2)
- [`distilbert`](https://huggingface.co/distilbert-base-uncased)

ตัวอย่างเพิ่มเติมจากองค์กรและบริษัทต่างๆ สามารถดูได้จาก [ที่นี่](https://github.com/huggingface/model_card/blob/master/examples.md)

## หมายเหตุ

การ์ดโมเดลไม่ได้เป็นหนึ่งในสิ่งที่เรียกร้อง (requirement) เมื่อจะทำการเปิดเผยโมเดลสู่สาธารณะ คุณไม่จำเป็นต้องใส่ทุกส่วนที่เราได้พูดถึงไปข้างบนถ้าคุณต้องการจะทำมัน  อย่างไรก็ได้หนังสืออ้างอิงที่ชัดเจนของโมเดลสามารถสร้างประโยชน์กับผู้ใช้ในอนาคตได้ ดังนั้นเราจึงแนะนำให้คุณเติมส่วนต่างๆที่คุณรู้ให้ได้มากที่สุดเท่าที่จะเป็นไปได้
## ข้อมูลเมตาของการ์ดโมเดล (Model card metadata)

ถ้าคุณได้ทำการสำรวจ Hugging Face Hub มาบ้างแล้ว คุณน่าจะได้เห็นบางโมเดลในหมวดหมู่ต่างๆ ที่คุณสามารถคัดกรองพวกมันได้ด้วยประเภทงาน, ภาษา, libraries และอื่นๆ หมวดหมู่ที่โมเดลๆหนึ่งอยู่ถูกระบุตามข้อมูลเมตา (metadata) ที่คุณเพิ่มเข้าไปในหัวของการ์ดโมเดล

ตัวอย่างเช่น ถ้าคุณลองดูที่ [การ์ดโมเดล `camembert-base`](https://huggingface.co/camembert-base/blob/main/README.md) คุณจะเห็นบรรทัดต่อไปนี้ในหัวการ์ดโมเดล:

```
---
language: fr
license: mit
datasets:
- oscar
---
```

ข้อมูลเมตานี้ถูกแยกวิเคราะห์โดย Hugging Face Hub ซึ่งต่อจากนั้นจะถูกใช้เป็นตัวระบุว่าโมเดลนี้เป็นโมเดลภาษาฝรั่งเศส มีใบอนุญาต MIT และถูกเทรนมากับชุดข้อมูล Oscar

[รายละเอียดการ์ดโมเดลแบบเต็ม](https://github.com/huggingface/hub-docs/blame/main/modelcard.md) ช่วยให้สามารถระบุภาษา, ใบอนุญาต, แท็ก, ชุดข้อมูล, เมตริก รวมไปถึงผลลัพธ์จากการประเมินผลที่โมเดลได้จากการเทรน

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter4/4.mdx" />