# Xử lý đa chuỗi

{#if fw === 'pt'}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter2/section5_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter2/section5_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter2/section5_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter2/section5_tf.ipynb"},
]} />

{/if}

{#if fw === 'pt'}
<Youtube id="M6adb1j2jPI"/>
{:else}
<Youtube id="ROxrFOEbsQE"/>
{/if}

Trong phần trước, chúng ta đã khám phá các trường hợp sử dụng đơn giản nhất: thực hiện luận suy trên một dãy đơn có độ dài nhỏ. Tuy nhiên, một số câu hỏi được đề cập như:

- Làm thế nào để chúng ta xử lý nhiều chuỗi?
- Làm thế nào để chúng ta xử lý nhiều chuỗi *có độ dài khác nhau*?
- Các chỉ số từ vựng có phải là đầu vào duy nhất cho phép một mô hình hoạt động tốt không?
- Nếu như một chuỗi quá dài thì sao?

Hãy xem những câu hỏi này đặt ra những loại vấn đề nào và cách chúng tôi có thể giải quyết chúng bằng cách sử dụng API 🤗 Transformers.

## Mô hình kì vọng một lô các đầu vào

Trong bài tập trước, bạn đã thấy cách các chuỗi được chuyển thành danh sách các số. Hãy chuyển đổi danh sách các số này thành một tensor và gửi nó đến mô hình:

{#if fw === 'pt'}
```py
import torch
from transformers import AutoTokenizer, AutoModelForSequenceClassification

checkpoint = "distilbert-base-uncased-finetuned-sst-2-english"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint)

sequence = "I've been waiting for a HuggingFace course my whole life."

tokens = tokenizer.tokenize(sequence)
ids = tokenizer.convert_tokens_to_ids(tokens)
input_ids = torch.tensor(ids)
# This line will fail.
model(input_ids)
```

```python out
IndexError: Dimension out of range (expected to be in range of [-1, 0], but got 1)
```
{:else}
```py
import tensorflow as tf
from transformers import AutoTokenizer, TFAutoModelForSequenceClassification

checkpoint = "distilbert-base-uncased-finetuned-sst-2-english"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = TFAutoModelForSequenceClassification.from_pretrained(checkpoint)

sequence = "I've been waiting for a HuggingFace course my whole life."

tokens = tokenizer.tokenize(sequence)
ids = tokenizer.convert_tokens_to_ids(tokens)
input_ids = tf.constant(ids)
# This line will fail.
model(input_ids)
```

```py out
InvalidArgumentError: Input to reshape is a tensor with 14 values, but the requested shape has 196 [Op:Reshape]
```
{/if}

Ôi không! Tại sao đoạn mã lại không thành công? Chúng ta đã làm theo các bước từ pipeline trong phần 2.

Vấn đề ở đây đó là chúng ta đã gửi một chuỗi đơn cho mô hình, trong khi mô hình 🤗 Transformers mong đợi nhiều câu theo mặc định. Ở đây, chúng ta đã cố gắng thực hiện mọi thứ mà tokenizer đã làm ở phía sau khi áp dụng nó vào một `chuỗi`, nhưng nếu bạn nhìn kỹ, bạn sẽ thấy rằng nó không chỉ chuyển đổi danh sách ID đầu vào thành một tensor, nó  còn thêm một chiều lên trên:

{#if fw === 'pt'}
```py
tokenized_inputs = tokenizer(sequence, return_tensors="pt")
print(tokenized_inputs["input_ids"])
```

```python out
tensor([[  101,  1045,  1005,  2310,  2042,  3403,  2005,  1037, 17662, 12172,
          2607,  2026,  2878,  2166,  1012,   102]])
```
{:else}
```py
tokenized_inputs = tokenizer(sequence, return_tensors="tf")
print(tokenized_inputs["input_ids"])
```

```py out
<tf.Tensor: shape=(1, 16), dtype=int32, numpy=
array([[  101,  1045,  1005,  2310,  2042,  3403,  2005,  1037, 17662,
        12172,  2607,  2026,  2878,  2166,  1012,   102]], dtype=int32)>
```
{/if}

Hãy cũng thử lại và thêm một chiều mới:

{#if fw === 'pt'}
```py
import torch
from transformers import AutoTokenizer, AutoModelForSequenceClassification

checkpoint = "distilbert-base-uncased-finetuned-sst-2-english"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint)

sequence = "I've been waiting for a HuggingFace course my whole life."

tokens = tokenizer.tokenize(sequence)
ids = tokenizer.convert_tokens_to_ids(tokens)

input_ids = torch.tensor([ids])
print("Input IDs:", input_ids)

output = model(input_ids)
print("Logits:", output.logits)
```
{:else}
```py
import tensorflow as tf
from transformers import AutoTokenizer, TFAutoModelForSequenceClassification

checkpoint = "distilbert-base-uncased-finetuned-sst-2-english"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = TFAutoModelForSequenceClassification.from_pretrained(checkpoint)

sequence = "I've been waiting for a HuggingFace course my whole life."

tokens = tokenizer.tokenize(sequence)
ids = tokenizer.convert_tokens_to_ids(tokens)

input_ids = tf.constant([ids])
print("Input IDs:", input_ids)

output = model(input_ids)
print("Logits:", output.logits)
```
{/if}

Ta in ra các ID đầu vào cũng như kết quả logit như sau:

{#if fw === 'pt'}
```python out
Input IDs: [[ 1045,  1005,  2310,  2042,  3403,  2005,  1037, 17662, 12172,  2607, 2026,  2878,  2166,  1012]]
Logits: [[-2.7276,  2.8789]]
```
{:else}
```py out
Input IDs: tf.Tensor(
[[ 1045  1005  2310  2042  3403  2005  1037 17662 12172  2607  2026  2878
   2166  1012]], shape=(1, 14), dtype=int32)
Logits: tf.Tensor([[-2.7276208  2.8789377]], shape=(1, 2), dtype=float32)
```
{/if}

*Batching* hay *Lô* là hành động gửi nhiều câu qua mô hình, tất cả cùng một lúc. Nếu bạn chỉ có một câu, bạn chỉ có thể xây dựng một lô với một chuỗi duy nhất:

```
batched_ids = [ids, ids]
```

Đây là một lô chứa hai chuỗi giống nhau!

<Tip>

✏️ **Thử nghiệm thôi!** Chuyển đổi danh sách `batch_ids` này thành một tensor và chuyển nó qua mô hình của bạn. Kiểm tra để đảm bảo rằng bạn có được logit giống như trước đây (nhưng hai lần)!

</Tip>

Việc phân phối lô cho phép mô hình hoạt động khi bạn đưa vào nhiều câu. Việc sử dụng nhiều chuỗi cũng đơn giản như xây dựng một lô với một chuỗi duy nhất. Tuy nhiên, có một vấn đề thứ hai. Khi bạn cố gắng ghép hai (hoặc nhiều) câu lại với nhau, chúng có thể có độ dài khác nhau. Nếu bạn đã từng làm việc với tensor trước đây, bạn biết rằng chúng cần có dạng hình chữ nhật, vì vậy bạn sẽ không thể chuyển đổi trực tiếp danh sách ID đầu vào thành tensor. Để giải quyết vấn đề này, chúng tôi thường *đệm* các đầu vào.

## Đêm thêm vào đầu vào

Danh sách các danh sách dưới đây không thể chuyển đổi thành một tensor:

```py no-format
batched_ids = [
    [200, 200, 200],
    [200, 200]
]
```

Để giải quyết vấn đề này, chúng ta sẽ sử dụng *đệm* để làm cho các tensor của chúng ta có hình chữ nhật. Đệm đảm bảo tất cả các câu của chúng ta có cùng độ dài bằng cách thêm một từ đặc biệt được gọi là *padding token* hay *token được đệm thêm* vào các câu có ít giá trị hơn. Ví dụ: nếu bạn có 10 câu 10 từ và 1 câu 20 từ, phần đệm sẽ đảm bảo tất cả các câu có 20 từ. Trong ví dụ của chúng tôi, tensor kết quả trông giống như sau:

```py no-format
padding_id = 100

batched_ids = [
    [200, 200, 200],
    [200, 200, padding_id],
]
```

ID của token đệm có thể tìm thấy ở `tokenizer.pad_token_id`. Hãy sử dụng nó và gửi hai câu của chúng ta thông qua mô hình riêng lẻ và theo lô với nhau:

{#if fw === 'pt'}
```py no-format
model = AutoModelForSequenceClassification.from_pretrained(checkpoint)

sequence1_ids = [[200, 200, 200]]
sequence2_ids = [[200, 200]]
batched_ids = [
    [200, 200, 200],
    [200, 200, tokenizer.pad_token_id],
]

print(model(torch.tensor(sequence1_ids)).logits)
print(model(torch.tensor(sequence2_ids)).logits)
print(model(torch.tensor(batched_ids)).logits)
```

```python out
tensor([[ 1.5694, -1.3895]], grad_fn=<AddmmBackward>)
tensor([[ 0.5803, -0.4125]], grad_fn=<AddmmBackward>)
tensor([[ 1.5694, -1.3895],
        [ 1.3373, -1.2163]], grad_fn=<AddmmBackward>)
```
{:else}
```py no-format
model = TFAutoModelForSequenceClassification.from_pretrained(checkpoint)

sequence1_ids = [[200, 200, 200]]
sequence2_ids = [[200, 200]]
batched_ids = [
    [200, 200, 200],
    [200, 200, tokenizer.pad_token_id],
]

print(model(tf.constant(sequence1_ids)).logits)
print(model(tf.constant(sequence2_ids)).logits)
print(model(tf.constant(batched_ids)).logits)
```

```py out
tf.Tensor([[ 1.5693678 -1.3894581]], shape=(1, 2), dtype=float32)
tf.Tensor([[ 0.5803005  -0.41252428]], shape=(1, 2), dtype=float32)
tf.Tensor(
[[ 1.5693681 -1.3894582]
 [ 1.3373486 -1.2163193]], shape=(2, 2), dtype=float32)
```
{/if}

Có điều gì đó không ổn với các logit trong các dự đoán theo lô của chúng ta: hàng thứ hai phải giống với logit cho câu thứ hai, nhưng chúng ta có các giá trị hoàn toàn khác nhau!

Điều này là do tính năng chính của các mô hình Transformer là các lớp attention đã *ngữ cảnh hóa* mỗi token. Chúng sẽ tính đến các padding token vì chúng tham gia vào tất cả các token của một chuỗi. Để có được kết quả tương tự khi chuyển các câu riêng lẻ có độ dài khác nhau qua mô hình hoặc khi chuyển một lô với các câu và phần đệm giống nhau được áp dụng, chúng ta cần yêu cầu các lớp attention đó bỏ qua các thẻ đệm. Điều này được thực hiện bằng cách sử dụng attention mask.

## Attention masks

*Attention masks* là các tensor có hình dạng chính xác như tensor ID đầu vào, được lấp đầy bởi 0 và 1: 1 cho biết các tokenn tương ứng nên được tham gia và các số 0 cho biết các token tương ứng không được tham gia (tức là chúng phải bị bỏ qua bởi các lớp attention của mô hình).

Hãy hoàn thành ví dụ trước với một attention mask:

{#if fw === 'pt'}
```py no-format
batched_ids = [
    [200, 200, 200],
    [200, 200, tokenizer.pad_token_id],
]

attention_mask = [
    [1, 1, 1],
    [1, 1, 0],
]

outputs = model(torch.tensor(batched_ids), attention_mask=torch.tensor(attention_mask))
print(outputs.logits)
```

```python out
tensor([[ 1.5694, -1.3895],
        [ 0.5803, -0.4125]], grad_fn=<AddmmBackward>)
```
{:else}
```py no-format
batched_ids = [
    [200, 200, 200],
    [200, 200, tokenizer.pad_token_id],
]

attention_mask = [
    [1, 1, 1],
    [1, 1, 0],
]

outputs = model(tf.constant(batched_ids), attention_mask=tf.constant(attention_mask))
print(outputs.logits)
```

```py out
tf.Tensor(
[[ 1.5693681  -1.3894582 ]
 [ 0.5803021  -0.41252586]], shape=(2, 2), dtype=float32)
```
{/if}

Bây giờ chúng ta nhận được các logit tương tự cho câu thứ hai trong lô.

Lưu ý cách giá trị cuối cùng của chuỗi thứ hai là ID đệm, là giá trị 0 trong attention mask.

<Tip>

✏️ **Thử nghiệm thôi!** Áp dụng thủ công tokenize cho hai câu được sử dụng trong phần 2 ("I've been waiting for a HuggingFace course my whole life." và "I hate this so much!"). Đưa chúng vào mô hình và kiểm tra xem bạn có nhận được các logit giống như trong phần 2 không. Bây giờ, gộp chúng lại với nhau bằng cách sử dụng token đệm, sau đó tạo attention mask thích hợp. Kiểm tra xem bạn có đạt được kết quả tương tự khi đưa qua mô hình không!

</Tip>

## Những chuỗi dài hơn

Với các mô hình Transformer, có một giới hạn về độ dài của các chuỗi mà chúng tôi có thể vượt qua các mô hình. Hầu hết các mô hình xử lý chuỗi lên đến 512 hoặc 1024 token và sẽ bị lỗi khi được yêu cầu xử lý chuỗi dài hơn. Có hai giải pháp cho vấn đề này:

- Sử dụng mô hình có độ dài chuỗi được hỗ trợ dài hơn.
- Cắt ngắn chuỗi của bạn.

Các mô hình có độ dài chuỗi được hỗ trợ khác nhau và một số mô hình chuyên xử lý các trình tự rất dài. [Longformer](https://huggingface.co/transformers/model_doc/longformer.html) là một ví dụ và một ví dụ khác là [LED](https://huggingface.co/transformers/model_doc/led.html). Nếu bạn đang thực hiện một công việc đòi hỏi trình tự rất dài, chúng tôi khuyên bạn nên xem các mô hình đó.

Nếu không, chúng tôi khuyên bạn nên cắt bớt các chuỗi của mình bằng cách chỉ định tham số `max_sequence_length`:

```py
sequence = sequence[:max_sequence_length]
```


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter2/5.mdx" />