# 模型 [[模型]]

{#if fw === 'pt'}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter2/section3_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter2/section3_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter2/section3_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter2/section3_tf.ipynb"},
]} />

{/if}

{#if fw === 'pt'}
<Youtube id="AhChOFRegn4"/>
{:else}
<Youtube id="d3JVgghSOew"/>
{/if}

{#if fw === 'pt'}

在本节中，我们将更详细地了解如何创建和使用模型。我们将使用 `AutoModel` 类，当你希望从 checkpoint 实例化任何模型时，使用它非常方便。

`AutoModel` 类及其所有的相关类其实就是对库中可用的各种模型的简单包装。它是一个智能的包装，因为它可以自动猜测你的 checkpoint 适合的模型架构，然后实例化一个具有相同架构的模型。

{:else}

在本节中，我们将更详细地了解如何创建和使用模型。我们将使用 `TFAutoModel` 类，当你希望从 checkpoint 实例化任何模型时，这非常方便。

`TFAutoModel` 类及其所有的相关类其实就是对库中可用的各种模型的简单包装。它是一个智能的包装，因为它可以自动猜测你的 checkpoint 适合的模型架构，然后实例化一个具有相同架构的模型。

{/if}

然而，如果你知道要使用模型的类型，你可以直接使用其架构相对应的模型类。让我们看看如何使用 BERT 模型。

## 创建 Transformer 模型 [[创建 Transformer 模型]]

初始化 BERT 模型需要做的第一件事是加载 `Config` 对象：

{#if fw === 'pt'}
```py
from transformers import BertConfig, BertModel

# 初始化 Config 类
config = BertConfig()

# 从 Config 类初始化模型
model = BertModel(config)
```

{:else}

```py
from transformers import BertConfig, TFBertModel

# 初始化 Config 类
config = BertConfig()

# 从 Config 类初始化模型
model = TFBertModel(config)
```
{/if}

`config` 中包含许多用于构建模型的属性：

```py
print(config)
```

```python out
BertConfig {
  [...]
  "hidden_size": 768,
  "intermediate_size": 3072,
  "max_position_embeddings": 512,
  "num_attention_heads": 12,
  "num_hidden_layers": 12,
  [...]
}
```

虽然可能你还不知道这些属性的含义，但其中一部分应该比较眼熟： `hidden_size` 属性定义了 `hidden_states（隐状态）` 向量的大小，而 `num_hidden_layers` 定义了 Transformer 模型的层数。

### 使用不同的加载方式 [[使用不同的加载方式]]

使用默认配置创建模型会使用随机值对其进行初始化：

{#if fw === 'pt'}
```py
from transformers import BertConfig, BertModel

config = BertConfig()
model = BertModel(config)

# 模型已随机初始化!
```
{:else}
```py
from transformers import BertConfig, TFBertModel

config = BertConfig()
model = TFBertModel(config)

# 模型已随机初始化!
```
{/if}

这个模型是可以运行并得到结果的，但它会输出胡言乱语；它需要先进行训练才能正常使用。我们可以根据手头的任务从头开始训练模型，但正如你在 [第一章](/course/chapter1) 中看到的，这将需要很长的时间和大量的数据，并且产生的碳足迹会对环境产生不可忽视的影响。为了避免不必要的重复工作，能够共享和复用已经训练过的模型是非常重要的。

加载已经训练过的 Transformers 模型很简单——我们可以使用 `from_pretrained()` 方法：

{#if fw === 'pt'}
```py
from transformers import BertModel

model = BertModel.from_pretrained("bert-base-cased")
```

正如你在上一小节看到的，从现在开始，我们会将 `BertModel` 替换为等效的 `AutoModel` 类，这样可以摆脱对 checkpoint 的依赖；如果你的代码适用于一个 checkpoint 那么它就可以在另一个 checkpoint 无缝地工作。即使体系结构不同，这也适用，只要 checkpoint 是针对同类的任务（例如，情绪分析任务）训练的。

{:else}
```py
from transformers import TFBertModel

model = TFBertModel.from_pretrained("bert-base-cased")
```

正如你在上一小节看到的，从现在开始，我们将用等效的 `TFAutoModel` 类替换 `TFBert` 模型。这样可以摆脱对 checkpoint 的依赖；如果你的代码适用于一个 checkpoint 那么它应该与另一个 checkpoint 无缝地工作。即使体系结构不同，这也适用，只要 checkpoint 是针对类似任务（例如，情绪分析任务）训练的。

{/if}

在上述代码示例中，我们没有使用 `BertConfig` ，而是通过 `bert-base-cased` 标签加载了一个预训练模型。这是一个由 BERT 的作者训练的模型 checkpoint 权重；你可以在其 [模型卡片](https://huggingface.co/bert-base-cased) 中查看更多详细信息。

现在，此模型已经用 checkpoint 的所有权重进行了初始化。它可以直接用于推理它训练过的任务，也可以在新任务上进行微调。通过使用预训练的权重进行训练，相比于从头开始训练，我们可以迅速获得比较好的结果。

权重已下载并缓存在缓存文件夹中（因此，未来调用 `from_pretrained()` 方法的调用将不会重新下载它们）默认为 `~/.cache/huggingface/transformers` 。你可以通过设置 `HF_HOME` 环境变量来自定义缓存文件夹。

加载模型的标识符可以是 Model Hub 上任何模型的标签，只要它与 BERT 架构兼容。可用的 BERT  checkpoint 的完整列表可以在 [这里](https://huggingface.co/models?filter=bert) 找到。

### 保存模型 [[保存模型]]

保存模型和加载模型一样简单--我们使用 `save_pretrained()` 方法，该方法类似于 `from_pretrained()` 方法：

```py
model.save_pretrained("directory_on_my_computer")
```

这会将两个文件保存到磁盘：

{#if fw === 'pt'}
```
ls directory_on_my_computer

config.json model.safetensors
```
{:else}
```
ls directory_on_my_computer

config.json tf_model.h5
```
{/if}

如果你看一下 `config.json` 文件，你会认出构建模型架构所需的属性。这个文件还包含一些元数据，例如 checkpoint 的来源，以及你上次保存 checkpoint 时所使用的 🤗 Transformers 版本。

{#if fw === 'pt'}

`pytorch_model.safetensors` 文件被称为 `state dictionary（状态字典）` ；它包含了你的模型的所有权重。这两个文件是相辅相成的；配置文件是构建你的模型架构所必需的，而模型权重就是你的模型参数。

{:else}

`tf_model.h5` 文件被称为 `state dictionary（状态字典）` ；它包含了你的模型的所有权重。这两个文件是相辅相成的；配置文件是构建你的模型架构所必需的，而模型权重就是你的模型参数。

{/if}

### 使用 Transformers 模型进行推理 [[使用 Transformers 模型进行推理]]

既然你知道了如何加载和保存模型，那么让我们尝试使用它进行一些预测。Transformer 模型只能处理数字——由 tokenizer 转化后的数字。但在我们讨论 tokenizer 之前，让我们探讨一下模型可以接受的输入是什么。

可以将输入转换为适当的框架张量，但为了帮助你了解发生了什么，我们将快速了解在将输入发送到模型之前必须做什么。

假设我们有几个句子：

```py
sequences = ["Hello!", "Cool.", "Nice!"]
```

tokenizer 将这些转换为词汇表索引，通常称为 `input IDs` 。每个句子现在都是一个数字列表！结果输出是：

```py no-format
encoded_sequences = [
    [101, 7592, 999, 102],
    [101, 4658, 1012, 102],
    [101, 3835, 999, 102],
]
```

这是一个编码序列列表：一个列表列表。张量只接受矩形（形状规则的的列表：每一列元素的数量都相同）。这个数组已经是矩形了，因此将其转换为张量很容易：

{#if fw === 'pt'}

```py
import torch

model_inputs = torch.tensor(encoded_sequences)
```

{:else}

```py
import tensorflow as tf

model_inputs = tf.constant(encoded_sequences)
```
{/if}

### 使用张量作为模型的输入 [[使用张量作为模型的输入]]

将张量输入给模型非常简单 —— 我们只需调用模型并输入：

```python
output = model(model_inputs)
```

虽然模型接受很多不同的参数，但只有 input IDs 是必需的。我们稍后会解释其他参数的作用以及何时需要它们，但首先我们需要仔细研究一下如何构建 Transformer 模型能理解的输入。


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter2/3.mdx" />