# 构建模型卡片 [[构建模型卡片]]

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

模型卡片是一个配置文件，可以说与模型存储库中的模型和 tokenizer 文件一样重要。它包含了模型的核心定义，确保了社区成员可以复现模型的结果，并提供一个其他成员可以在这个模型基础上构建他们的组件的平台。

记录训练和评估过程并提供有关使用的数据以及已完成的预处理和后续处理的足够信息，有助于其他人了解对模型的能力——模型存的局限性、偏见以及模型有效或无效的使用场景。

因此，创建一个清晰定义你的模型的模型卡片是非常重要的一步。在这里，我们提供了一些可以帮助你创建模型卡片的建议。创建模型卡片的内容保存在你之前看到的 README.md 文件中，这是一个 Markdown 文件。

“模型卡片”的概念源于谷歌的一个研究方向，Margaret Mitchell 等人在论文 [“模型卡片用于模型报告”](https://arxiv.org/abs/1810.03993) 中首次提出，这里许多内容均基于该论文，我们建议你查看这篇论文以了解为什么模型卡片在实现可复现性、可重用性和公平性的中如此重要。

模型卡通常以非常简短的概述开始，说明模型的用途，然后是模型卡片需要的其他信息：

- 模型描述
- 预期用途和限制
- 如何使用
- 局限性和偏见
- 训练数据
- 训练程序
- 评价结果

让我们来看看每个部分应该包含什么。

### 模型描述：[[模型描述：]]

提供了有关模型的基本详细信息。这包括架构、版本、如果它是在论文中介绍的，是否有原始的实现可用？作者以及有关模型的一般信息、任何版权都应归于此处。这一部分还可以提及有关训练程序、参数和重要免责声明的一般信息。

### 预期用途和限制：[[预期用途和限制：]]

在此描述模型可以适用的例子，包括可以应用它的语言、领域。模型卡的这一部分还可以记录已知超出模型范围的区域，或者可能表现不佳的区域。

### 使用方法：[[使用方法：]]

此部分应包括一些有关如何使用模型的示例。这可以展示使用 `pipeline()` 函数、模型和 tokenizer 的使用以及其他任何你认为可能有帮助的代码。

### 训练数据：[[训练数据：]]

这部分应该指出模型是在哪个数据集上训练的。也欢迎对数据集进行简要描述。

### 训练过程：[[训练过程：]]

此部分中，你应该描述从再现性角度来看有用的训练的所有相关方面。这包括对数据进行的任何预处理和后处理，以及模型训练的批量数、批量大小、学习率等细节。

### 变量和指标：[[变量和指标：]]

在这里，你应该描述你用于评估的指标，以及你测量的不同因素。提及使用了哪些指标、在哪个数据集上以及哪个数据集部分，可以轻松地将你的模型的性能与其他模型的性能进行比较。

### 评估结果：[[评估结果：]]

这些应该提前在前面的部分告知，例如预期的使用效果和示例。最后，提供模型在评估数据集上的表现的指示。如果模型使用决策阈值，要么提供评估中使用的决策阈值，要么提供在不同阈值下针对预期用途进行评估的详细信息。

## 示例 [[示例]]

请查看以下几个精心制作的模型卡的示例：

* [bert-base-cased](https://huggingface.co/bert-base-cased) 
* [gpt2](https://huggingface.co/gpt2) 
* [distilbert](https://huggingface.co/distilbert-base-uncased) 

更多来自于不同组织和公司的示例可以在 [模型卡片示例](https://github.com/huggingface/model_card/blob/master/examples.md) 中查阅．

## 注意事项 [[注意事项]]

发布模型时，并非必须有模型卡片，制作一个模型时不需要包含上述所有部分。但是，模型的文档会使未来的用户受益，因此我们建议你尽你所知和能力所及地尽可能填写尽可能多的部分。

## 模型卡片元数据 [[模型卡片元数据]]

如果你对 Hugging Face Hub 进行了一些探索，你应该已经看到某些模型属于某些类别：你可以按任务、语言、库等对其进行筛选。模型所属的类别来自于你在模型卡片头部中添加的元数据。

例如，如果你看一下 [`camembert-base` 模型卡片](https://huggingface.co/camembert-base/blob/main/README.md) ，你应该在模型卡头部中看到以下几行：

```
---
language: fr
license: mit
datasets:
- oscar
---
```

该元数据由 Hugging Face Hub 解析，然后将这个模型为法语模型，拥有 MIT 许可证，在 Oscar 数据集上训练。

可以在 [全部模型卡片的规格](https://raw.githubusercontent.com/huggingface/huggingface_hub/main/modelcard.md) 查阅支持的语言、许可证、标签、数据集、指标以及模型在训练时获得的评估结果。

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter4/4.mdx" />