# 构建你的第一个演示 [[构建你的第一个演示]]

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section2.ipynb"},
]} />

让我们从安装 Gradio 开始吧！与安装其他 Python 包一样，只需运行：

```bash
pip install gradio

```

Gradio 支持所有常见的平台，无论是从你最喜欢的 Python IDE、Jupyter notebook 还是 Google Colab 🤯！

所以无论你在哪里运行 Python，都可以安装 Gradio！

让我们从一个简单的“Hello World”示例开始熟悉 Gradio 语法：

```py
import gradio as gr


def greet(name):
    return "Hello " + name


demo = gr.Interface(fn=greet, inputs="text", outputs="text")

demo.launch()
```

让我们逐步解释上面的代码：

- 首先，我们定义一个名为 `greet()` 的函数。在这个例子中，它是一个在你的名字前添加“Hello”的简单函数，不过它可以被替换为任意的 Python 函数。例如，在机器学习的演示中，该函数可以调用机器学习模型对输入进行预测并返回输出。
- 然后，我们创建一个带有三个参数 `fn` 、 `inputs` 和 `outputs` 的 Gradio `Interface` 。这些参数定义了预测函数，以及我们想要的输入和输出组件的类型。在我们的这个例子中，输入和输出组件都是简单的文本框。
- 最后我们调用创建的 `Interface` 上的 `launch()` 方法。

如果你运行这段代码，下面的界面会自动出现在 Jupyter/Colab notebook 中，或者如果在一个脚本中运行，会自动在浏览器中弹出 ** [http://localhost:7860](http://localhost:7860) ** 。

<iframe src="https://course-demos-hello-world.hf.space" frameBorder="0" height="250" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

现在，试着使用你自己的名字或其他的输入来试一试这个 GUI！

你会注意到，在这个 GUI 中，在这个例子中，Gradio 会根据输入参数的名称（`name`）自动推断文本框顶部的标签。如果你想改变这个标签怎么办？或者，如果你想自定义这个文本框的其他属性？在这种情况下，你可以实例化一个表示输入组件的类。

看看下面的例子：

```py
import gradio as gr


def greet(name):
    return "Hello " + name


# 我们将文本框类实例化
textbox = gr.Textbox(label="Type your name here:", placeholder="John Doe", lines=2)

gr.Interface(fn=greet, inputs=textbox, outputs="text").launch()
```

<iframe src="https://course-demos-hello-world-custom.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

在上面的代码中，我们创建了一个带有自定义标签、预设的占位符和固定行数的输入文本框。同时，你也可以自定义输出文本框，但我们现在先不管它。

我们已经看到，只需几行代码，Gradio 就能让你围绕任何函数创建一个简单的界面，同时兼容各种类型的输入或输出。在本节中，我们先从一个简单的文本框开始，但在接下来的节中，我们将介绍其他类型的输入和输出。现在让我们看一下如何在 Gradio 应用中包含一些自然语言处理（NLP）模型。

## 🤖 使用模型预测 [[🤖 使用模型预测]]

现在让我们构建一个简单的界面，让你可以在这个界面中演示像 GPT-2 这样的**文本生成**模型。

我们将使用 🤗 Transformers 中的 `pipeline()` 函数加载我们的模型。
如果你需要快速复习，你可以返回到 [第一章](/course/chapter1/3#text-generation) 进行回顾。

首先，我们定义一个预测函数，它接收一个文本输入并返回文本生成的结果：

```py
from transformers import pipeline

model = pipeline("text-generation")


def predict(prompt):
    completion = model(prompt)[0]["generated_text"]
    return completion
```

此函数会不断接龙补全输入，你可以自己尝试各种输入来查看它是如何运行的。下面是一个示例（你可能会得到不同的输出结果）：

```
predict("My favorite programming language is")
```

```
>> My favorite programming language is Haskell. I really enjoyed the Haskell language, but it doesn't have all the features that can be applied to any other language. For example, all it does is compile to a byte array.
```

现在我们有了一个生成预测的函数，接下来可以像之前一样创建和启动一个 `Interface` ：

```py
import gradio as gr

gr.Interface(fn=predict, inputs="text", outputs="text").launch()
```


就是这样！你现在可以在 Interface 创建的 Web 网页上使用 GPT-2 模型生成文本，如下所示 🤯：

<iframe src="https://course-demos-gpt-2.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

接下来，让我们一起了解一下如何使用 Gradio 构建其他输入输出类型的演示！

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter9/2.mdx" />