# 章末小測試

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. 語言建模 Pipeline 的順序是什麼？
<Question
	choices={[
		{
			text: "首先是模型它處理文本並返回原始預測。然後，分詞器會對這些預測進行解釋，並在需要時將它們轉換回文本",
			explain: "模型不能理解文本！必須首先使用標記器(Tokenizer)將文本轉換為id，之後才可以輸入給模型。"
		},
		{
			text: "首先是 標記器(Tokenizer)，它處理文本並返回id。模型根據這些 id 並輸出預測，可以是一些文本。",
			explain: "該模型的預測結果是id而不是文本。為了將預測轉換回文本，必須使用標記器(Tokenizer)！"
		},
		{
			text: "標記器(Tokenizer) 處理文本並返回 id。模型處理這些 id 並輸出一個預測。然後可以再次使用 標記器(Tokenizer) 將這些預測轉換回某些文本。",
			explain: "正確! 標記器(Tokenizer)可以用於id與文本的相互轉換。",
            correct: true
		}
	]}
/>

### 2. Transformer模型的輸出有多少個維度，每個維度分別是什麼？
<Question
	choices={[
		{
			text: "兩個維度，分別是: 序列長度(Sequence Length)和批次大小(Batch Size)",
			explain: "錯! 該模型的張量輸出還具有第三個維度: 隱藏層大小(Hidden Size)。"
		},
		{
			text: "兩個維度，分別是: 序列長度(Sequence Length)和隱藏層大小(Hidden Size)",
			explain: "錯! 所有Transformer模型都批量進行計算，即使是單個序列; 那麼批次大小(Batch Size)為1！"
		},
		{
			text: "三個維度，分別是: 序列長度(Sequence Length)、批次大小(Batch Size)和隱藏層大小(Hidden Size)",
			explain: "正確！",
            correct: true
		}
	]}
/>

### 3.下列哪一個是Subword標記(Tokenization)的例子（從分詞的顆粒度來劃分）？
<Question
	choices={[
		{
			text: "WordPiece",
			explain: "是的，這是一個Subword 標記化(Tokenization)的例子！",
            correct: true
		},
		{
			text: "基於單個字符的標記(Tokenization)",
			explain: "基於字符的標記(Tokenization)不是一種Subword 標記化(Tokenization)。"
		},
		{
			text: "基於空格和標點符號的分割",
			explain: "這是一種基於單詞標記化(Tokenization)！"
		},
		{
			text: "BPE(Byte Pair Encoding)",
			explain: "是的，這是一個Subword 標記化(Tokenization)的例子！",
            correct: true
        },
		{
			text: "Unigram",
			explain: "是的，這是一個Subword 標記化(Tokenization)的例子！",
            correct: true
        },
		{
			text: "以上都不是",
			explain: "不對！"
        }
	]}
/>

### 4.什麼是模型的 Head 層？
<Question
	choices={[
		{
			text: "原始Transformer網絡的一種組件，將張量(Tensors)重定向到它們的正確層",
			explain: "不對! 沒有這樣的組件。"
		},
		{
			text: "也稱為自注意力(self-attention)機制，它根據序列中的其他標記(Token)來調整一個標記(Token)",
			explain: "不對！ 自注意力層確實包含注意力“Head”層，但這些不是模型的head層。"
		},
		{
			text: "一個附加組件，通常由一個或幾個層組成，用於將Transformer的預測轉換為特定於任務的輸出",
			explain: "沒錯。它的全名是Adaptation Heads，也被簡單地稱為模型的頭部，在不同的任務上有不同的形式: 語言模型Heads，問題回答Heads，序列分類Heads..。",
			correct: true
		} 
	]}
/>

{#if fw === 'pt'}
### 5.什麼是AutoModel？
<Question
	choices={[
		{
			text: "根據您的數據自動進行訓練的模型",
			explain: "錯誤。您可能把AutoModel與我們的<a href='https://huggingface.co/autonlp'>AutoNLP</a> 產品相混淆了？"
		},
		{
			text: "一個根據Checkpoint(檢查點)返回模型體系結構的對象",
			explain: "確切地說: <code>AutoModel</code>只需要知道初始化的Checkpoint(檢查點)就可以返回正確的體系結構。",
			correct: true
		},
		{
			text: "一種可以自動檢測輸入語言來加載正確權重的模型",
			explain: "不正確; 雖然有些Checkpoint(檢查點)和模型能夠處理多種語言，但是沒有內置的工具可以根據語言自動選擇Checkpoint(檢查點)。您應該前往 <a href='https://huggingface.co/models'>Model Hub</a> 尋找完成所需任務的最佳Checkpoint(檢查點)！"
		} 
	]}
/>

{:else}
### 5.什麼是 TFAutoModel？
<Question
	choices={[
		{
			text: "根據您的數據自動進行訓練的模型",
			explain: "錯誤。您可能把TFAutoModel與我們的<a href='https://huggingface.co/autonlp'>AutoNLP</a> 產品相混淆了？"
		},
		{
			text: "一個根據Checkpoint(檢查點)返回模型體系結構的對象",
			explain: "確切地說: <code>TFAutoModel</code>只需要知道初始化的Checkpoint(檢查點)就可以返回正確的體系結構。",
			correct: true
		},
		{
			text: "一種可以自動檢測輸入語言來加載正確權重的模型",
			explain: "不正確; 雖然有些Checkpoint(檢查點)和模型能夠處理多種語言，但是沒有內置的工具可以根據語言自動選擇Checkpoint(檢查點)。您應該前往 <a href='https://huggingface.co/models'>Model Hub</a> 尋找完成所需任務的最佳Checkpoint(檢查點)！"
		} 
	]}
/>

{/if}

### 6.當將不同長度的序列批處理在一起時，需要進行哪些處理？
<Question
	choices={[
		{
			text: "截短",
			explain: "是的，截斷是一個正確的方式，可以將他們轉化為一個固定長度的矩形序列。這是唯一的一個答案嗎？",
			correct: true
		},
		{
			text: "返回Tensors",
			explain: "雖然其他技術允許返回矩形張量，但在批處理序列時不可以直接返回長度不一致的Tensors。(序列必須是固定長度)"
		},
		{
			text: "填充",
			explain: "是的，填充是一個正確的方式，可以將他們轉化為一個固定長度的矩形序列。這是唯一的一個答案嗎？",
			correct: true
		}, 
		{
			text: "注意力遮蔽(Attention masking)",
			explain: "當然！當處理不同長度的序列時，注意力遮蔽是最重要的。然而，這並不是唯一需要進行的處理。",
			correct: true
		} 
	]}
/>

### 7.將 SoftMax激活函數應用於序列分類(Sequence Classification)模型的 logits 輸出有什麼意義？
<Question
	choices={[
		{
			text: "它軟化了logits輸出，使結果更可靠。",
			explain: "不， SoftMax激活函數不會影響結果的可靠性。"
		},
		{
			text: "它限定了上下界，使模型的輸出結果可以被解釋。",
			explain: "正確！結果值被壓縮到了0和1之間。不過，這並不是我們使用SoftMax激活函數的唯一原因。",
            correct: true
		},
		{
			text: "輸出的和是1，從而產生一個可能的概率解釋。",
			explain: "沒錯，但這並不是我們使用SoftMax激活函數的唯一原因。",
            correct: true
		}
	]}
/>

### 8.大多數標記器(Tokenizer)的API以什麼方法為核心？
<Question
	choices={[
		{
			text: "<code>編碼</code> ，因為它可以將文本編碼為id，將預測的id解碼為文本",
			explain: "錯! 雖然 <code>編碼</code> 方法確實存在於標記器中，但是它不存在於模型中。"
		},
		{
			text: "直接調用標記器(Tokenizer)對象。",
			explain: "完全正確！標記化器(Tokenizer) 的 <code>__call__</code>方法是一個非常強大的方法，可以處理幾乎任何事情。它也是從模型中獲取預測的方法。",
			correct: true
		},
		{
			text: "<code>pad</code>(填充)",
			explain: "錯! <code>pad</code>(填充)非常有用，但它只是標記器(Tokenizer) API的一部分。"
		},
		{
			text: "<code>tokenize</code>(標記)",
			explain: "可以說，<code>tokenize</code>(標記)方法是最有用的方法之一，但它不是標記器(Tokenizer) API的核心方法。"
		}
	]}
/>

### 9.這個代碼示例中的`result`變量包含什麼？
```py
from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
result = tokenizer.tokenize("Hello!")
```

<Question
	choices={[
		{
			text: "字符串列表，每個字符串都是一個標記(Token)",
			explain: "正確! 把這個轉換成id後，就可以傳輸給模型了！",
            correct: true
		},
		{
			text: "一個ID的列表",
			explain: "不正確; 這就是 <code>__call__</code> 或 <code>convert_tokens_to_ids</code>方法的作用！"
		},
		{
			text: "包含所有標記(Token)的字符串",
			explain: "這將是次優的，因為Tokenizer會將字符串拆分為多個標記的列表。"
		}
	]}
/>

{#if fw === 'pt'}
### 10.下面的代碼有什麼錯誤嗎？
```py
from transformers import AutoTokenizer, AutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = AutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "不，看起來是對的。",
			explain: "不幸的是，將一個模型與一個用不同Checkpoint(檢查點)訓練的Tokenizer(標記器)耦合在並不是一個好主意。模型沒有在這個這個Tokenizer(標記器)上訓練來理解Tokenizer(標記器)的輸出，因此模型輸出(如果它可以運行的話)不會有任何意義。"
		},
		{
			text: "Tokenizer(標記器)和模型應該來自相同的Checkpoint(檢查點)。",
			explain: "對！",
            correct: true
		},
		{
			text: "由於每個輸入都是一個Batch，因此可以使用標記器(Tokenizer)對其進行平移和截斷來改善這段代碼。",
			explain: "的確，每個模型都需要Batch類型的輸入。然而，截斷或填充這個序列並不一定有意義，這裡只有一句話，而這些技術是用來批處理一個句子列表的。"
		}
	]}
/>

{:else}
### 10.下面的代碼有什麼錯誤嗎？
```py
from transformers import AutoTokenizer, TFAutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = TFAutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "不，看起來是對的。",
			explain: "不幸的是，將一個模型與一個用不同Checkpoint(檢查點)訓練的Tokenizer(標記器)耦合在並不是一個好主意。模型沒有在這個這個Tokenizer(標記器)上訓練來理解Tokenizer(標記器)的輸出，因此模型輸出(如果它可以運行的話)不會有任何意義。"
		},
		{
			text: "Tokenizer(標記器)和模型應該來自相同的Checkpoint(檢查點)。",
			explain: "對！",
            correct: true
		},
		{
			text: "由於每個輸入都是一個Batch，因此可以使用標記器(Tokenizer)對其進行平移和截斷來改善這段代碼。",
			explain: "的確，每個模型都需要Batch類型的輸入。然而，截斷或填充這個序列並不一定有意義，這裡只有一句話，而這些技術是用來批處理一個句子列表的。"
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter2/8.mdx" />