# The Hugging Face Hub

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

[Hugging Face Hub](https://huggingface.co/) -- 我們的主網站，是一個中央平臺，在這個網站上任何人都可以查找、使用和貢獻新的最先進的模型和數據集。它擁有各種各樣的模型，公開可用的模型超過 10,000個。我們在本章去探索Hub中的模型，並在第 5 章中探索Hub中的數據集。

Hub 中的模型不僅限於 🤗 Transformers 甚至 NLP。有用於自然語言處理的[Flair](https://github.com/flairNLP/flair)，[AllenNLP](https://github.com/allenai/allennlp)，[Asteroid](https://github.com/asteroid-team/asteroid)和用於音頻檢測的[pyannote](https://github.com/pyannote/pyannote-audio)，以及對於視覺的[timm](https://github.com/rwightman/pytorch-image-models)，這些例子只是Hub中冰山一角，更多的模型。可以由你去探索。

這些模型中的每一個都作為 Git 存儲庫託管，這允許進行版本控制和重現。在 Hub 上共享模型意味著將其向社區開放，讓任何希望使用它的人都可以輕鬆訪問它，從而使其他人不用為訓練模型而苦惱就可以直接使用模型。

此外，在 Hub 上共享模型會自動為該模型部署託管的推理 API。社區中的任何人都可以直接在模型頁面上自由地測試它，使用自定義輸入和適當的小部件。

最棒的是是在 Hub 上共享和使用任何公共模型是完全免費的！如果您不想公開模型，也存在[付費計劃](https://huggingface.co/pricing)。下面的視頻顯示瞭如何使用 Hub。

<Youtube id="XvSGPZFEjDY"/>

這部分需要有一個 Huggingface.co 帳戶，因為我們將在 Hugging Face Hub 上創建和管理存儲庫：[創建一個賬戶](https://huggingface.co/join)

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter4/1.mdx" />