# Gradio 簡介

在本章中，我們將學習如何為您的機器學習構建**交互式演示**模型。

為什麼首先要為您的機器學習模型構建演示或 GUI？演示可以帶來：

- **機器學習開發人員**可以輕鬆地向包括非技術團隊或客戶在內的廣大受眾展示他們的工作
- **研究人員**更輕鬆地重現機器學習模型和行為
- **質量測試人員**或**最終用戶**更容易識別和調試模型的故障點
- **不同的用戶**發現模型中的算法偏差

我們將使用 Gradio 庫為我們的模型構建演示。 Gradio 允許您完全使用 Python 為任何機器學習模型構建、自定義和共享基於 Web 的演示。

以下是一些使用 Gradio 構建的機器學習演示示例：

* 一個**草圖識別**模型，它接收草圖並輸出它認為正在繪製的標籤：

<iframe src="https://course-demos-draw2.hf.space" frameBorder="0" height="450" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

* 一個抽取式**問題回答**模型，它接受上下文段落和一個任務並輸出一個結果和一個概率分數（我們在[第7章](/course/chapter7/7)中討論了這種模型）：

<iframe src="https://course-demos-question-answering-simple.hf.space" frameBorder="0" height="640" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

* 一個**背景去除**模型，它接收圖像並輸出去除背景的圖像：

<iframe src="https://course-demos-remove-bg-original.hf.space" frameBorder="0" height="640" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

本章分為兩個部分，包括_概念_和_應用程序_。在您瞭解每個部分的概念後，您將應用它來構建特定類型的演示，範圍從圖像分類到語音識別。當你讀完本章時，你將能夠用幾行 Python 代碼構建這些演示（以及更多！）。

👀 點擊 <a href="https://huggingface.co/spaces" target="_blank">Hugging Face Spaces</a> 以查看機器學習社區構建的許多機器學習演示的最新示例！

## Gradio 方塊派對🥳

如果你想充分利用本章中的知識，就加入 Gradio 積木派對吧！這是由 Hugging Face 於**5 月 16 日至 31 日**舉辦的社區活動。在此活動中，您將使用 Gradio 構建酷炫的機器學習演示，並參與贏取 Hugging Face 禮物和獎品！

查看 [活動描述](https://github.com/AK391/community-events/blob/main/gradio-blocks/README.md) 可以瞭解如何參與的詳細信息 - 我們迫不及待地想看看你構建的🤗演示！


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter9/1.mdx" />