# 與他人分享演示

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section4.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section4.ipynb"},
]} />

現在您已經構建了一個演示，您可能希望與其他人分享它。 梯度演示
可以通過兩種方式共享：使用 ***temporary share link*** 或 ***permanent hosting on Spaces***。

我們將很快介紹這兩種方法。 但在分享演示之前，您可能需要完善它 💅.

### 打磨你的 Gradio 演示:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview.png" alt="Overview of a gradio interface">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview-dark.png" alt="Overview of a gradio interface">
</div>

為了給你的演示添加額外的內容，`Interface` 類支持一些可選參數：
    - `title`：你可以給你的演示一個標題，它出現在輸入和輸出組件的上方。
    - `description`：您可以為界面提供描述（文本、Markdown 或 HTML），顯示在輸入和輸出組件的上方和標題下方。
    - `article`：您還可以編寫擴展文章（文本、Markdown 或 HTML）來解釋界面。如果提供，它會出現在輸入和輸出組件的_下方。
    - `theme`：不喜歡默認顏色？將主題設置為使用 `default`、`huggingface`、`grass`、`peach` 之一。您還可以添加 `dark-` 前綴，例如`dark-peach` 用於深色主題（或者只是 `dark` 用於默認的深色主題）。
    - `examples`：為了讓您的演示*更易於使用*，您可以為函數提供一些示例輸入。它們出現在 UI 組件下方，可用於填充界面。這些應該作為嵌套列表提供，其中外部列表​​由樣本組成，每個內部列表對應於每個輸入組件的輸入組成。
    - `live`：如果你想讓你的演示“活”，這意味著你的模型每次輸入更改時都會重新運行，你可以設置 `live=True`。這對使用快速模型很有意義（我們將在本節末尾看到一個示例）
使用上面的選項，我們最終得到了一個更完整的界面。 運行下面的代碼，以便與 Rick and Morty 聊天：

```py
title = "Ask Rick a Question"
description = """
The bot was trained to answer questions based on Rick and Morty dialogues. Ask Rick anything!
<img src="https://huggingface.co/spaces/course-demos/Rick_and_Morty_QA/resolve/main/rick.png" width=200px>
"""

article = "Check out [the original Rick and Morty Bot](https://huggingface.co/spaces/kingabzpro/Rick_and_Morty_Bot) that this demo is based off of."

gr.Interface(
    fn=predict,
    inputs="textbox",
    outputs="text",
    title=title,
    description=description,
    article=article,
    examples=[["What are you doing?"], ["Where should we time travel to?"]],
).launch()
```

使用上面的選項，我們最終得到了一個更完整的界面。 試試下面的界面：

<iframe src="https://course-demos-Rick-and-Morty-QA.hf.space" frameBorder="0" height="800" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

### 使用臨時鏈接分享您的演示
現在我們已經有了機器學習模型的工作演示，讓我們學習如何輕鬆共享指向我們界面的鏈接。
通過在 `launch()` 方法中設置 `share=True` 可以輕鬆地公開共享接口：

```python
gr.Interface(classify_image, "image", "label").launch(share=True)
```

這會生成一個公開的、可共享的鏈接，您可以將其發送給任何人！ 當您發送此鏈接時，另一方的用戶可以在瀏覽器中試用該模型長達 72 小時。 因為處理發生在您的設備上（只要您的設備保持開啟！），您不必擔心打包任何依賴項。 如果您使用 Google Colab 筆記本工作，則始終會自動創建共享鏈接。 它通常看起來像這樣：**XXXXX.gradio.app**。 雖然鏈接是通過 Gradio 鏈接提供的，但我們只是您本地服務器的代理，不會存儲通過接口發送的任何數據。

但是請記住，這些鏈接是可公開訪問的，這意味著任何人都可以使用您的模型進行預測！ 因此，請確保不要通過您編寫的函數公開任何敏感信息，或允許在您的設備上發生任何關鍵更改。 如果設置 `share=False`（默認值），則僅創建本地鏈接。

### 在 Hugging Face Spaces 上託管您的演示

可以傳遞給同事的共享鏈接很酷，但是如何永久託管您的演示並讓它存在於互聯網上自己的“空間”中？

Hugging Face Spaces 提供了在互聯網上永久託管 Gradio 模型的基礎設施，**免費**！ Spaces 允許您創建並推送到（公共或私人）存儲庫，
你的 Gradio 在哪裡
接口代碼將存在於 `app.py` 文件中。 [閱讀分步教程](https://huggingface.co/blog/gradio-spaces) 開始使用，或觀看下面的示例視頻。

<Youtube id="LS9Y2wDVI0k" />

## ✏️ 讓我們應用它!

使用到目前為止我們在各節中學到的知識，讓我們創建我們在[本章第一節](/course/chapter9/1)中看到的草圖識別演示。 讓我們為我們的界面添加一些自定義並設置 `share=True` 以創建一個我們可以傳遞的公共鏈接。

我們可以從 [class_names.txt](https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/class_names.txt) 加載標籤，並從 [pytorch_model.bin](https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/pytorch_model.bin)加載預訓練的 pytorch 模型 。 通過點擊鏈接並單擊文件預覽左上角的下載來下載這些文件。 讓我們看看下面的代碼，看看我們如何使用這些文件來加載我們的模型並創建一個`predict()`函數：
```py
from pathlib import Path
import torch
import gradio as gr
from torch import nn

LABELS = Path("class_names.txt").read_text().splitlines()

model = nn.Sequential(
    nn.Conv2d(1, 32, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Conv2d(32, 64, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Conv2d(64, 128, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Flatten(),
    nn.Linear(1152, 256),
    nn.ReLU(),
    nn.Linear(256, len(LABELS)),
)
state_dict = torch.load("pytorch_model.bin", map_location="cpu")
model.load_state_dict(state_dict, strict=False)
model.eval()


def predict(im):
    x = torch.tensor(im, dtype=torch.float32).unsqueeze(0).unsqueeze(0) / 255.0
    with torch.no_grad():
        out = model(x)
    probabilities = torch.nn.functional.softmax(out[0], dim=0)
    values, indices = torch.topk(probabilities, 5)
    return {LABELS[i]: v.item() for i, v in zip(indices, values)}
```

現在我們有了一個`predict()`函數。 下一步是定義並啟動我們的漸變界面：

```py
interface = gr.Interface(
    predict,
    inputs="sketchpad",
    outputs="label",
    theme="huggingface",
    title="Sketch Recognition",
    description="Who wants to play Pictionary? Draw a common object like a shovel or a laptop, and the algorithm will guess in real time!",
    article="<p style='text-align: center'>Sketch Recognition | Demo Model</p>",
    live=True,
)
interface.launch(share=True)
```

<iframe src="https://course-demos-Sketch-Recognition.hf.space" frameBorder="0" height="650" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>


注意 `Interface` 中的 `live=True` 參數，這意味著草圖演示使
每次有人在畫板上畫畫時的預測（沒有提交按鈕！）。

此外，我們還在 `launch()` 方法中設置了 `share=True` 參數。
這將創建一個公共鏈接，您可以發送給任何人！ 當您發送此鏈接時，對方的用戶可以嘗試草圖識別模型。 重申一下，您還可以在 Hugging Face Spaces 上託管模型，這就是我們能夠嵌入上面的演示的方式。

接下來，我們將介紹 Gradio 可用於 Hugging Face 生態系統的其他方式！

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter9/4.mdx" />