import{s as Cn,n as bn,o as vn}from"../chunks/scheduler.ddeee2a5.js";import{S as xn,i as kn,e as i,s as a,c as r,h as An,a as p,d as s,b as n,f as gn,g as u,j as o,k as T,l as qn,m as l,n as c,t as M,o as y,p as h}from"../chunks/index.10b70568.js";import{C as Bn}from"../chunks/CopyLLMTxtMenu.15d785e4.js";import{C as J}from"../chunks/CodeBlock.7ca4c11d.js";import{H as d,E as $n}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.dd6ac5e9.js";function Hn(Ol){let m,Gt,$t,Zt,q,_t,B,Rt,j,Kl='<p>Want to be listed as an Inference Provider on the Hugging Face Hub? Let’s get in touch!</p> <p>Please reach out to us on social networks or <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">here on the Hub</a>.</p>',Wt,U,ea='<p>Note that Step 3 will require your organization to upgrade their Hub account to a <a href="https://huggingface.co/pricing" rel="nofollow">Team or Enterprise plan</a>.</p>',St,$,ta="This guide details the steps for registering as an inference provider on the Hub and provides implementation guidance.",Vt,H,sa='<li><strong>Implement standard task APIs</strong> - Follow our task API schemas for compatibility (see <a href="#1-prerequisites">Prerequisites</a>).</li> <li><strong>Submit a PR for JS client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> (see <a href="#2-js-client-integration">JS Client Integration</a>).</li> <li><strong>Register model mappings</strong> - Use our Model Mapping API to link your models to Hub models (see <a href="#3-model-mapping-api">Model Mapping API</a>).</li> <li><strong>Implement a billing endpoint</strong> - Provide an API for billing (see <a href="#4-billing">Billing</a>).</li> <li><strong>Submit a PR for Python client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> (see <a href="#5-python-client-integration">Python client integration</a>).</li> <li><strong>Register your provider server-side and provide an icon</strong> - Reach out to us to add your provider server-side and provide your SVG icon.</li> <li><strong>Create documentation on your side</strong> - Add documentation and do a lot of communication on your side.</li> <li><strong>Add a documentation page</strong> - Open a Pull Request in this repo (huggingface/hub-docs) to add a provider-specific page in the documentation.</li> <li><strong>Share share share</strong> do a lot of comms so that your integration is as successful as possible!</li>',Xt,G,Qt,w,la='<p>If your implementation strictly follows the OpenAI API for LLMs and VLMs, you may be able to skip most of this section. In that case, simply open a PR on <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> to register.</p>',Et,Z,aa=`The first step to understand the integration is to take a look at the JS inference client that lives
inside the <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> repo.`,Yt,_,na=`This is the client that powers our Inference widgets on model pages, and is the blueprint
implementation downstream (for Python SDK, to generate code snippets, etc.).`,Nt,R,Ft,W,ia=`You will see that inference methods (<code>textToImage</code>, <code>chatCompletion</code>, etc.) have names that closely
mirror the task names. A task, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of
model (basically which types of inputs and outputs the model has), for instance “text-generation”
or “text-to-image”. It is indicated prominently on model pages, here:`,Lt,f,pa='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-dark.png"/></picture>',Pt,S,oa='The list of all possible tasks can be found at <a href="https://huggingface.co/tasks" rel="nofollow">https://huggingface.co/tasks</a> and the list of JS method names is documented in the README at <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>.',zt,I,ra=`<p>Note that <code>chatCompletion</code> is an exception as it is not a pipeline_tag, per se. Instead, it
includes models with either <code>pipeline_tag=&quot;text-generation&quot;</code> or <code>pipeline_tag=&quot;image-text-to-text&quot;</code>
which are tagged as “conversational”.</p>`,Dt,V,Ot,X,ua=`For each task type, we enforce an API schema to make it easier for end users to use different
models interchangeably. To be compatible, your third-party API must adhere to a “standard” shape API we expect on HF model pages for each pipeline task type.`,Kt,Q,ca=`This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be
more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there
exists no standard API.`,es,E,Ma='For example, you can find the expected schema for Text to Speech here: <a href="https://github.com/huggingface/huggingface.js/blob/0a690a14d52041a872dc103846225603599f4a33/packages/tasks/src/tasks/text-to-speech/spec/input.json#L4" rel="nofollow">https://github.com/huggingface/huggingface.js/packages/src/tasks/text-to-speech/spec/input.json#L4</a>, and similarly for other supported tasks. If your API for a given task is different from HF’s, it is not an issue: you can tweak the code in <code>huggingface.js</code> to be able to call your models, i.e., provide some kind of “translation” of parameter names and output names. However, API specs should not be model-specific, only task-specific. Run the JS code and add some <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/test/HfInference.spec.ts" rel="nofollow">tests</a> to make sure it works well. We can help with this step!',ts,Y,ss,N,ya="Before proceeding with the next steps, ensure you’ve implemented the necessary code to integrate with the JS client and thoroughly tested your implementation. Here are the steps to follow:",ls,F,as,L,ha="Create a new file under <code>packages/inference/src/providers/{provider_name}.ts</code> and copy-paste the following snippet.",ns,P,is,z,da="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. You have to define at least <code>makeRoute</code>, <code>preparePayload</code> and <code>getResponse</code>.",ps,D,Ja='If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern used in the existing providers implementation, e.g. <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/together.ts" rel="nofollow">Together AI provider implementation</a>.',os,O,Ta='For text-generation and conversational tasks, you can just inherit from <code>BaseTextGenerationTask</code> and <code>BaseConversationalTask</code> respectively (defined in <a href="(https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/providerHelper.ts)">providerHelper.ts</a>) and override the methods if needed. Examples can be found in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/cerebras.ts" rel="nofollow">Cerebras</a> or <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/fireworks.ts" rel="nofollow">Fireworks</a> provider implementations.',rs,K,us,ee,ma='Go to <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/lib/getProviderHelper.ts" rel="nofollow">packages/inference/src/lib/getProviderHelper.ts</a> and add your provider to <code>PROVIDERS</code>. You will need to add your provider to the <code>INFERENCE_PROVIDERS</code> list as well in <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/types.ts" rel="nofollow">packages/inference/src/types.ts</a>. Please try to respect alphabetical order.',cs,te,ja='Update the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/README.md" rel="nofollow">README.md</a> in the <code>packages/inference</code> directory to include your provider in the list of supported providers and the list of supported models links.',Ms,se,ys,le,Ua="Congratulations! You now have a JS implementation to successfully make inference calls on your infra! Time to integrate with the Hub!",hs,ae,wa="First step is to use the Model Mapping API to register which HF models are supported.",ds,g,fa=`<p>The completion of step 1. and 2. are pre-requisites for this step.
To proceed with this step, we have to enable your account server-side. Make sure you have an organization on the Hub for your company, and upgrade it to a <a href="https://huggingface.co/pricing" rel="nofollow">Team or Enterprise plan</a>.</p>`,Js,ne,Ts,ie,ms,pe,Ia="Create a new mapping item, with the following body (JSON-encoded):",js,oe,Us,re,ga=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>hfModel</code> is the model id on the Hub’s side.</li> <li><code>providerModel</code> is the model id on your side (can be the same or different. In general, we encourage you to use the HF model ids on your side as well, but this is up to you).</li>`,ws,ue,Ca="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",fs,ce,Is,Me,ba=`You need to be in the <em>provider</em> Hub organization (e.g. <a href="https://huggingface.co/togethercomputer" rel="nofollow">https://huggingface.co/togethercomputer</a>
for TogetherAI) with <strong>Write</strong> permissions to be able to access this endpoint.`,gs,ye,Cs,he,va="The endpoint validates that:",bs,de,xa=`<li><code>hfModel</code> is indeed of <code>pipeline_tag == task</code> OR <code>task</code> is “conversational” and the model is
compatible (i.e. the <code>pipeline_tag</code> is either “text-generation” or “image-text-to-text” AND the model is tagged as “conversational”).</li> <li>After the mapping creation (asynchronously) we automatically test whether the Partner API correctly handles huggingface.js/inference calls for the relevant task, ensuring the API specifications are valid. See the <a href="#automatic-validation">Automatic validation</a> section below.</li>`,vs,Je,xs,Te,ka=`We also support mapping HF models based on their <code>tags</code>. Using tag filters, you can automatically map multiple HF models to a single inference endpoint on your side.
For example, any model tagged with both <code>lora</code> and <code>base_model:adapter:black-forest-labs/FLUX.1-dev</code> can be mapped to your Flux-dev LoRA inference endpoint.`,ks,C,Aa='<p>Important: Make sure that the JS client library can handle LoRA weights for your provider. Check out <a href="https://github.com/huggingface/huggingface.js/blob/904964c9f8cd10ed67114ccb88b9028e89fd6cad/packages/inference/src/providers/fal-ai.ts#L78-L124" rel="nofollow">fal’s implementation</a> for more details.</p>',As,me,qa="The API is as follows:",qs,je,Bs,Ue,Ba="Create a new mapping item, with the following body (JSON-encoded):",$s,we,Hs,fe,$a=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>tags</code> is the set of model tags to match. For example, to match all LoRAs of Flux, you can use: <code>[&quot;lora&quot;, &quot;base_model:adapter:black-forest-labs/FLUX.1-dev&quot;]</code></li> <li><code>providerModel</code> is the model ID on your side (can be the same or different from the HF model ID).</li> <li><code>adapterType</code> is a literal value that helps client libraries interpret how to call your API. The only supported value at the moment is <code>&quot;lora&quot;</code>.</li>`,Gs,Ie,Ha="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",Zs,ge,_s,Ce,Rs,be,Ga=`Where <code>mapping ID</code> is the mapping’s <code>_id</code> field obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,Ws,ve,Ss,xe,Za="Call this HTTP PUT endpoint:",Vs,ke,Xs,Ae,_a="With the following body (JSON-encoded):",Qs,qe,Es,Be,Ra=`Where <code>mapping ID</code> is the mapping’s <code>_id</code> field obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,Ys,$e,Ns,He,Fs,Ge,Wa="This gets all mapping items from the DB. For clarity, the output is grouped by task.",Ls,b,Sa="<p>This is publicly accessible. It’s useful to be transparent by default and it helps debug client SDKs, etc.</p>",Ps,Ze,Va="Here is an example of response:",zs,_e,Ds,Re,Os,We,Xa="Once a mapping is created through the API, Hugging Face performs periodic automated tests to ensure the mapped endpoint functions correctly.",Ks,Se,Qa="Each model is tested every 6 hours by making API calls to your service. If the test is successful, the model remains active and continues to be tested periodically. However, if the test fails (e.g., your service returns an HTTP error status during an inference request), the provider will be temporarily removed from the list of active providers.",el,v,Ea='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/automatic-validation-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/automatic-validation-dark.png"/></picture>',tl,Ve,Ya="A failed mapping undergoes retesting every hour. Additionally, updating the status of a model mapping triggers an immediate validation test.",sl,Xe,Na="The validation process checks the following:",ll,Qe,Fa=`<li>The Inference API is reachable, and the HTTP call succeeds.</li> <li>The output format is compatible with the Hugging Face JavaScript Inference Client.</li> <li>Latency requirements are met:
<ul><li>For conversational and text models: under 5 seconds (time to first token in streaming mode).</li> <li>For other tasks: under 30 seconds.</li></ul></li>`,al,Ee,La="For large language models (LLMs), additional behavioral tests are conducted:",nl,Ye,Pa="<li>Tool calling support.</li> <li>Structured output support.</li>",il,Ne,za="These tests involve sending specific inference requests to the model and verifying that the responses meet the expected format.",pl,Fe,ol,Le,Da=`For routed requests (see figure below), i.e. when users authenticate via HF, our intent is that
our users only pay the standard provider API rates. There’s no additional markup from us, we
just pass through the provider costs directly.
More details about the pricing structure can be found on the <a href="./pricing">pricing page</a>.`,rl,x,Oa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/types_of_billing.png"/>',ul,Pe,Ka=`We propose an easier way to figure out this cost and charge it to our users, by asking you to
provide the cost for each request via an HTTP API you host on your end.`,cl,ze,Ml,De,en=`We ask that you expose an API that supports a HTTP POST request.
The body of the request is a JSON-encoded object containing a list of request IDs for which we
request the cost.
The authentication system should be the same as your Inference service; for example, a bearer token.`,yl,Oe,hl,Ke,tn=`The response is also JSON-encoded. The response contains an array of objects specifying the
request’s ID and its cost in nano-USD (10^-9 USD).`,dl,et,Jl,tt,sn="This API endpoint will be requested by our system every minute, in batches of up to 10,000 requests.",Tl,st,ml,lt,ln="We require the price to be a <strong>non-negative integer</strong> number of <strong>nano-USDs</strong> (10^-9 USD).",jl,at,Ul,nt,an=`For each request/generation you serve, you should define a unique request (or response) ID,
and provide it as a response Header. We will use this ID as the request ID for the billing API
above.`,wl,it,nn="As part of those requirements, please let us know your Header name. If you don’t already have one, we suggest the <code>Inference-Id</code> name for instance, and it should contain a UUID character string.",fl,pt,pn="<strong>Example</strong>: Defining an <code>Inference-Id</code> header in your inference response.",Il,ot,gl,rt,Cl,ut,on='If your API is OpenAI-compatible, we expect that you expose LLM pricing information and context length through the <a href="https://platform.openai.com/docs/api-reference/models/list" rel="nofollow"><code>/v1/models</code> endpoint</a>.',bl,ct,rn='This powers our <a href="https://huggingface.co/inference/models" rel="nofollow">provider comparison table</a> and other provider selection features like <code>:cheapest</code> (which selects the cheapest provider for a model).',vl,k,un='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/provider-comparison-table.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/provider-comparison-table-dark.png"/></picture>',xl,Mt,cn="The format we expect is as follows:",kl,yt,Al,ht,ql,A,Mn="<p>Before adding a new provider to the <code>huggingface_hub</code> Python library, make sure that all the previous steps have been completed and everything is working on the Hub. Support in the Python library comes as a second step.</p>",Bl,dt,$l,Jt,yn="Create a new file under <code>src/huggingface_hub/inference/_providers/{provider_name}.py</code> and copy-paste the following snippet.",Hl,Tt,hn="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. At least one of <code>_prepare_payload_as_dict</code> or <code>_prepare_payload_as_bytes</code> must be overwritten.",Gl,mt,dn="If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern shown in fal_ai.py.",Zl,jt,Jn="For text-generation and conversational tasks, one can just inherit from BaseTextGenerationTask and BaseConversationalTask respectively (defined in _common.py) and override the methods if needed. Examples can be found in fireworks_ai.py and together.py.",_l,Ut,Rl,wt,Wl,ft,Tn='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_providers/__init__.py" rel="nofollow">src/huggingface_hub/inference/_providers/<strong>init</strong>.py</a> and add your provider to <code>PROVIDER_T</code> and <code>PROVIDERS</code>. Please try to respect alphabetical order.</li> <li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py" rel="nofollow">src/huggingface_hub/inference/_client.py</a> and update docstring in <code>InferenceClient.__init__</code> to document your provider.</li>',Sl,It,Vl,gt,mn='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_providers.py" rel="nofollow">tests/test_inference_providers.py</a> and add static tests for overridden methods.</li>',Xl,Ct,Ql,bt,jn="Create a dedicated documentation page for your provider within the Hugging Face documentation. This page should contain a concise description of your provider services, highlight the benefits for users, set expectations regarding performance or features, and include any relevant details such as pricing models or data retention policies. Essentially, provide any information that would be valuable to end users.",El,vt,Un="Here’s how to add your documentation page:",Yl,xt,wn=`<li>Provide Your Logo: You can send your logo files (separate light and dark mode versions) directly to us. This is often the simplest way. Alternatively, if you prefer, you can open a PR in the <a href="https://huggingface.co/datasets/huggingface/documentation-images/tree/main/inference-providers/logos" rel="nofollow">huggingface/documentation-images</a> repository. If you choose to open a PR:
<ul><li>Logos must be in <code>.png</code> format.</li> <li>Name them <code>{provider-name}-light.png</code> and <code>{provider-name}-dark.png</code>.</li> <li>Please ping <code>@Wauplin</code> and <code>@celinah</code> on the PR.</li></ul></li> <li>Create the Documentation File:
<ul><li>Use an existing provider page as a template. For example, check out the template for <a href="https://github.com/huggingface/hub-docs/blob/main/scripts/inference-providers/templates/providers/fal-ai.handlebars" rel="nofollow">Fal AI</a>.</li> <li>The file should be located under <code>scripts/inference-providers/templates/providers/{your-provider-name}.handlebars</code>.</li></ul></li> <li>Submit the Documentation PR:
<ul><li>Add your new <code>{provider-name}.handlebars</code> file.</li> <li>Update the <a href="./index#partners">partners table</a> to include your company or product.</li> <li>Update the <code>_toctree.yml</code> file in the <code>docs/inference-providers/</code> directory to include your new documentation page in the “Providers” section, maintaining alphabetical order.</li> <li>Update the <code>scripts/inference-providers/scripts/generate.ts</code> file to include your provider in the <code>PROVIDERS_HUB_ORGS</code> and <code>PROVIDERS_URLS</code> constants, maintaining alphabetical order.</li> <li>Run <code>pnpm install</code> (if you haven’t already) and then <code>pnpm run generate</code> at the root of the <code>scripts/inference-providers</code> repository to generate the documentation.</li> <li>Commit all your changes, including the manually edited files (provider page, <code>_toctree.yml</code>, partners table) and the files generated by the script.</li> <li>When you open the PR, please ping @Wauplin, @SBrandeis, @julien-c, and @hanouticelina for a review. If you need any assistance with these steps, please reach out – we’re here to help you!</li></ul></li>`,Nl,kt,Fl,At,fn="<strong>Question:</strong> By default, in which order do we list providers in the settings page?",Ll,qt,In="<strong>Answer:</strong> The default sort is by total number of requests routed by HF over the last 7 days. This order defines which provider will be used in priority by the widget on the model page (but the user’s order takes precedence).",Pl,Bt,zl,Ht,Dl;return q=new Bn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),B=new d({props:{title:"How to be registered as an inference provider on the Hub?",local:"how-to-be-registered-as-an-inference-provider-on-the-hub",headingTag:"h1"}}),G=new d({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),R=new d({props:{title:"What is a Task",local:"what-is-a-task",headingTag:"h3"}}),V=new d({props:{title:"Task API schema",local:"task-api-schema",headingTag:"h3"}}),Y=new d({props:{title:"2. JS Client Integration",local:"2-js-client-integration",headingTag:"h2"}}),F=new d({props:{title:"Implement the provider helper (JS)",local:"implement-the-provider-helper-js",headingTag:"h3"}}),P=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">TaskProviderHelper</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;./providerHelper&quot;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTask</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">TaskProviderHelper</span> {

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params"></span>) {
		<span class="hljs-variable language_">super</span>(<span class="hljs-string">&quot;your-provider-name&quot;</span>, <span class="hljs-string">&quot;your-api-base-url&quot;</span>, <span class="hljs-string">&quot;task-name&quot;</span>);
	}

    <span class="hljs-keyword">override</span> <span class="hljs-title function_">prepareHeaders</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">HeaderParams</span>, <span class="hljs-attr">binary</span>: <span class="hljs-built_in">boolean</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">string</span>&gt; {
        <span class="hljs-comment">// Override the headers to use for the request.</span>
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">super</span>.<span class="hljs-title function_">prepareHeaders</span>(params, binary);
    }

	<span class="hljs-title function_">makeRoute</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">UrlParams</span>): <span class="hljs-built_in">string</span> {
        <span class="hljs-comment">// Return the route to use for the request. e.g. /v1/chat/completions route is commonly use for chat completion.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">preparePayload</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">BodyParams</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">unknown</span>&gt; {
        <span class="hljs-comment">// Return the payload to use for the request, as a dict.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">getResponse</span>(<span class="hljs-attr">response</span>: <span class="hljs-built_in">unknown</span>, outputType?: <span class="hljs-string">&quot;url&quot;</span> | <span class="hljs-string">&quot;blob&quot;</span>): <span class="hljs-built_in">string</span> | <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-title class_">Blob</span>&gt;{
		<span class="hljs-comment">// Return the response in the expected format.</span>
        <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
    }
}`,wrap:!1}}),K=new d({props:{title:"Register the provider",local:"register-the-provider",headingTag:"h3"}}),se=new d({props:{title:"3. Model Mapping API",local:"3-model-mapping-api",headingTag:"h2"}}),ne=new d({props:{title:"Register a mapping item",local:"register-a-mapping-item",headingTag:"h3"}}),ie=new J({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),oe=new J({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMldpZGdldFR5cGUlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMmhmTW9kZWwlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwb24lMjBIRiUzQSUyMG5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlck1vZGVsJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjB0aGUlMjBwYXJ0bmVyJ3MlMjAlMjJtb2RlbCUyMGlkJTIyJTIwaS5lLiUyMGlkJTIwb24lMjB5b3VyJTIwc2lkZSUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the name of the model on HF: namespace/model-name</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ce=new d({props:{title:"Authentication",local:"authentication",headingTag:"h4"}}),ye=new d({props:{title:"Validation",local:"validation",headingTag:"h4"}}),Je=new d({props:{title:"Using a tag-filter to map several HF models to a single inference endpoint",local:"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint",headingTag:"h3"}}),je=new J({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),we=new J({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnRhZy1maWx0ZXIlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlMjJXaWRnZXRUeXBlJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlMEElMjAlMjAlMjAlMjAlMjJ0YWdzJTIyJTNBJTIwJTVCJTIyc3RyaW5nJTIyJTVEJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjBhbnklMjBIRiUyMG1vZGVsJTIwd2l0aCUyMGFsbCUyMG9mJTIwdGhvc2UlMjB0YWdzJTIwd2lsbCUyMGJlJTIwbWFwcGVkJTIwdG8lMjBwcm92aWRlck1vZGVsJTBBJTIwJTIwJTIwJTIwJTIycHJvdmlkZXJNb2RlbCUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUyMCUyRiUyRiUyMHJlcXVpcmVkJTNBJTIwdGhlJTIwcGFydG5lcidzJTIwJTIybW9kZWwlMjBpZCUyMiUyMGkuZS4lMjBpZCUyMG9uJTIweW91ciUyMHNpZGUlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyVHlwZSUyMiUzQSUyMCUyMmxvcmElMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMG9ubHklMjAlMjJsb3JhJTIyJTIwaXMlMjBzdXBwb3J0ZWQlMjBhdCUyMHRoZSUyMG1vbWVudCUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tag-filter&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: any HF model with all of those tags will be mapped to providerModel</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: only &quot;lora&quot; is supported at the moment</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ge=new d({props:{title:"Delete a mapping item",local:"delete-a-mapping-item",headingTag:"h3"}}),Ce=new J({props:{code:"REVMRVRFJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RA==",highlighted:"DELETE /api/partners/{provider}/models/{mapping ID}",wrap:!1}}),ve=new d({props:{title:"Update a mapping item’s status",local:"update-a-mapping-items-status",headingTag:"h3"}}),ke=new J({props:{code:"UFVUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RCUyRnN0YXR1cw==",highlighted:"PUT /api/partners/{provider}/models/{mapping ID}/status",wrap:!1}}),qe=new J({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIybGl2ZSUyMiUyMCU3QyUyMCUyMnN0YWdpbmclMjIlMjAlMkYlMkYlMjBUaGUlMjBuZXclMjBzdGF0dXMlMkMlMjBvbmUlMjBvZiUyMCUyMnN0YWdpbmclMjIlMjBvciUyMCUyMmxpdmUlMjIlMEElN0QlMjAlMjAlMjA=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// The new status, one of &quot;staging&quot; or &quot;live&quot;</span>
<span class="hljs-punctuation">}</span>   `,wrap:!1}}),$e=new d({props:{title:"List the whole mapping",local:"list-the-whole-mapping",headingTag:"h3"}}),He=new J({props:{code:"R0VUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRnN0YXR1cyUzRHN0YWdpbmclN0NsaXZl",highlighted:"GET /api/partners/{provider}/models?status=staging|live",wrap:!1}}),_e=new J({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text-to-image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-canny&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-depth&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;tag-filter=base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0,lora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sdxl-lora-mutualized&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
                <span class="hljs-string">&quot;base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-string">&quot;lora&quot;</span>
            <span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;conversational&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text-generation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Re=new d({props:{title:"Automatic validation",local:"automatic-validation",headingTag:"h3"}}),Fe=new d({props:{title:"4. Billing",local:"4-billing",headingTag:"h2"}}),ze=new d({props:{title:"HTTP API Specs",local:"http-api-specs",headingTag:"h3"}}),Oe=new J({props:{code:"UE9TVCUyMCU3QnlvdXIlMjBVUkwlMjBoZXJlJTdEJTBBQXV0aG9yaXphdGlvbiUzQSUyMCU3QmF1dGhlbnRpY2F0aW9uJTIwaW5mbyUyMC0lMjBlZyUyMCUyMkJlYXJlciUyMHRva2VuJTIyJTdEJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdElkcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMyUyMiUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`POST {your URL here}
<span class="hljs-attribute">Authorization</span><span class="hljs-punctuation">: </span>{authentication info - eg &quot;Bearer token&quot;}
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

{
    &quot;requestIds&quot;: [
        &quot;deadbeef0&quot;,
        &quot;deadbeef1&quot;,
        &quot;deadbeef2&quot;,
        &quot;deadbeef3&quot;
    ]
}`,wrap:!1}}),et=new J({props:{code:"SFRUUCUyRjEuMSUyMDIwMCUyME9LJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjAlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnJlcXVlc3RJZCUyMiUzQSUyMCUyMmRlYWRiZWVmMSUyMiUyQyUyMCUyMmNvc3ROYW5vVXNkJTIyJTNBJTIwMTAwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIycmVxdWVzdElkJTIyJTNBJTIwJTIyZGVhZGJlZWYyJTIyJTJDJTIwJTIyY29zdE5hbm9Vc2QlMjIlM0ElMjAxMDAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjMlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

<span class="language-prolog">{
    <span class="hljs-string">&quot;requests&quot;</span>: [
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef0&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef1&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef2&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef3&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> }
    ]
}</span>`,wrap:!1}}),st=new d({props:{title:"Price Unit",local:"price-unit",headingTag:"h3"}}),at=new d({props:{title:"How to define the request ID",local:"how-to-define-the-request-id",headingTag:"h3"}}),ot=new J({props:{code:"UE9TVCUyMCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTVCcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEElNUJyZXF1ZXN0JTIwYm9keSU1RCUwQS0tLS0tLSUwQUhUVFAlMkYxLjElMjAyMDAlMjBPSyUwQUNvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUwQSU1Qm90aGVyJTIwcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEFJbmZlcmVuY2UtSWQlM0ElMjB1bmlxdWUtaWQtMDAxMzElMEElNUJyZXNwb25zZSUyMGJvZHklNUQ=",highlighted:`POST /v1/chat/completions
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[request headers]
[request body]
------
<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[other request headers]
<span class="hljs-attribute">Inference-Id</span><span class="hljs-punctuation">: </span>unique-id-00131
[response body]`,wrap:!1}}),rt=new d({props:{title:"Exposing pricing through OpenAI /models routes",local:"exposing-pricing-through-openai-models-routes",headingTag:"h3"}}),yt=new J({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaWQlMjIlM0ElMjAlMjJtb2RlbC1pZC0wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2JqZWN0JTIyJTNBJTIwJTIybW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjcmVhdGVkJTIyJTNBJTIwMTY4NjkzNTAwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm93bmVkX2J5JTIyJTNBJTIwJTIyb3JnYW5pemF0aW9uLW93bmVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTJGJTIwJTVCLi4uJTVEJTIwb3RoZXIlMjBmaWVsZHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwcmljaW5nJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXQlMjIlM0ElMjAwLjIlMkMlMjAlMkYlMkYlMkYlMjBQcmljZSUyMGluJTIwVVMlMjBkb2xsYXJzJTIwcGVyJTIwbWlsbGlvbiUyMGlucHV0JTIwdG9rZW5zJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3V0cHV0JTIyJTNBJTIwMiUyQyUyMCUyRiUyRiUyRiUyMFByaWNlJTIwaW4lMjBVUyUyMGRvbGxhcnMlMjBwZXIlMjBtaWxsaW9uJTIwb3V0cHV0JTIwdG9rZW5zJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGV4dF9sZW5ndGglMjIlM0ElMjAyMDAwMDAlMkMlMjAlMkYlMkYlMkYlMjBTdXBwb3J0ZWQlMjBjb250ZXh0JTIwbGVuZ3RoJTIwaW4lMjB0b2tlbnMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;model-id-0&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;object&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;model&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;created&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1686935002</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;owned_by&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;organization-owner&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-comment">/// [...] other fields</span>
      <span class="hljs-attr">&quot;pricing&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.2</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">/// Price in US dollars per million input tokens</span>
        <span class="hljs-attr">&quot;output&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">/// Price in US dollars per million output tokens</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;context_length&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">200000</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">/// Supported context length in tokens</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ht=new d({props:{title:"5. Python client integration",local:"5-python-client-integration",headingTag:"h2"}}),dt=new d({props:{title:"Implement the provider helper (Python)",local:"implement-the-provider-helper-python",headingTag:"h3"}}),Ut=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">from</span> ._common <span class="hljs-keyword">import</span> TaskProviderHelper


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTaskProviderHelper</span>(<span class="hljs-title class_ inherited__">TaskProviderHelper</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Define high-level parameters.&quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(provider=..., base_url=..., task=...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_response</span>(<span class="hljs-params">
        self,
        response: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bytes</span>, <span class="hljs-type">Dict</span>],
        request_params: <span class="hljs-type">Optional</span>[RequestParameters] = <span class="hljs-literal">None</span>,
    </span>) -&gt; <span class="hljs-type">Any</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return the response in the expected format.

        Override this method in subclasses for customized response handling.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().get_response(response)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_headers</span>(<span class="hljs-params">self, headers: <span class="hljs-type">Dict</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the headers to use for the request.

        Override this method in subclasses for customized headers.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_headers(headers, api_key)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_route</span>(<span class="hljs-params">self, mapped_model: <span class="hljs-built_in">str</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the route to use for the request.

        Override this method in subclasses for customized routes.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_route(mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_dict</span>(<span class="hljs-params">self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the payload to use for the request, as a dict.

        Override this method in subclasses for customized payloads.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_dict(inputs, parameters, mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_bytes</span>(<span class="hljs-params">
        self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span>, extra_payload: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]
    </span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bytes</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the body to use for the request, as bytes.

        Override this method in subclasses for customized body data.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_bytes(inputs, parameters, mapped_model, extra_payload)`,wrap:!1}}),wt=new d({props:{title:"Register the Provider",local:"register-the-provider",headingTag:"h3"}}),It=new d({props:{title:"Add tests",local:"add-tests",headingTag:"h3"}}),Ct=new d({props:{title:"6. Add provider documentation",local:"6-add-provider-documentation",headingTag:"h2"}}),kt=new d({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),Bt=new $n({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/register-as-a-provider.md"}}),{c(){m=i("meta"),Gt=a(),$t=i("p"),Zt=a(),r(q.$$.fragment),_t=a(),r(B.$$.fragment),Rt=a(),j=i("blockquote"),j.innerHTML=Kl,Wt=a(),U=i("blockquote"),U.innerHTML=ea,St=a(),$=i("p"),$.textContent=ta,Vt=a(),H=i("ol"),H.innerHTML=sa,Xt=a(),r(G.$$.fragment),Qt=a(),w=i("blockquote"),w.innerHTML=la,Et=a(),Z=i("p"),Z.innerHTML=aa,Yt=a(),_=i("p"),_.textContent=na,Nt=a(),r(R.$$.fragment),Ft=a(),W=i("p"),W.innerHTML=ia,Lt=a(),f=i("div"),f.innerHTML=pa,Pt=a(),S=i("p"),S.innerHTML=oa,zt=a(),I=i("blockquote"),I.innerHTML=ra,Dt=a(),r(V.$$.fragment),Ot=a(),X=i("p"),X.textContent=ua,Kt=a(),Q=i("p"),Q.textContent=ca,es=a(),E=i("p"),E.innerHTML=Ma,ts=a(),r(Y.$$.fragment),ss=a(),N=i("p"),N.textContent=ya,ls=a(),r(F.$$.fragment),as=a(),L=i("p"),L.innerHTML=ha,ns=a(),r(P.$$.fragment),is=a(),z=i("p"),z.innerHTML=da,ps=a(),D=i("p"),D.innerHTML=Ja,os=a(),O=i("p"),O.innerHTML=Ta,rs=a(),r(K.$$.fragment),us=a(),ee=i("p"),ee.innerHTML=ma,cs=a(),te=i("p"),te.innerHTML=ja,Ms=a(),r(se.$$.fragment),ys=a(),le=i("p"),le.textContent=Ua,hs=a(),ae=i("p"),ae.textContent=wa,ds=a(),g=i("blockquote"),g.innerHTML=fa,Js=a(),r(ne.$$.fragment),Ts=a(),r(ie.$$.fragment),ms=a(),pe=i("p"),pe.textContent=Ia,js=a(),r(oe.$$.fragment),Us=a(),re=i("ul"),re.innerHTML=ga,ws=a(),ue=i("p"),ue.textContent=Ca,fs=a(),r(ce.$$.fragment),Is=a(),Me=i("p"),Me.innerHTML=ba,gs=a(),r(ye.$$.fragment),Cs=a(),he=i("p"),he.textContent=va,bs=a(),de=i("ul"),de.innerHTML=xa,vs=a(),r(Je.$$.fragment),xs=a(),Te=i("p"),Te.innerHTML=ka,ks=a(),C=i("blockquote"),C.innerHTML=Aa,As=a(),me=i("p"),me.textContent=qa,qs=a(),r(je.$$.fragment),Bs=a(),Ue=i("p"),Ue.textContent=Ba,$s=a(),r(we.$$.fragment),Hs=a(),fe=i("ul"),fe.innerHTML=$a,Gs=a(),Ie=i("p"),Ie.textContent=Ha,Zs=a(),r(ge.$$.fragment),_s=a(),r(Ce.$$.fragment),Rs=a(),be=i("p"),be.innerHTML=Ga,Ws=a(),r(ve.$$.fragment),Ss=a(),xe=i("p"),xe.textContent=Za,Vs=a(),r(ke.$$.fragment),Xs=a(),Ae=i("p"),Ae.textContent=_a,Qs=a(),r(qe.$$.fragment),Es=a(),Be=i("p"),Be.innerHTML=Ra,Ys=a(),r($e.$$.fragment),Ns=a(),r(He.$$.fragment),Fs=a(),Ge=i("p"),Ge.textContent=Wa,Ls=a(),b=i("blockquote"),b.innerHTML=Sa,Ps=a(),Ze=i("p"),Ze.textContent=Va,zs=a(),r(_e.$$.fragment),Ds=a(),r(Re.$$.fragment),Os=a(),We=i("p"),We.textContent=Xa,Ks=a(),Se=i("p"),Se.textContent=Qa,el=a(),v=i("div"),v.innerHTML=Ea,tl=a(),Ve=i("p"),Ve.textContent=Ya,sl=a(),Xe=i("p"),Xe.textContent=Na,ll=a(),Qe=i("ul"),Qe.innerHTML=Fa,al=a(),Ee=i("p"),Ee.textContent=La,nl=a(),Ye=i("ul"),Ye.innerHTML=Pa,il=a(),Ne=i("p"),Ne.textContent=za,pl=a(),r(Fe.$$.fragment),ol=a(),Le=i("p"),Le.innerHTML=Da,rl=a(),x=i("div"),x.innerHTML=Oa,ul=a(),Pe=i("p"),Pe.textContent=Ka,cl=a(),r(ze.$$.fragment),Ml=a(),De=i("p"),De.textContent=en,yl=a(),r(Oe.$$.fragment),hl=a(),Ke=i("p"),Ke.textContent=tn,dl=a(),r(et.$$.fragment),Jl=a(),tt=i("p"),tt.textContent=sn,Tl=a(),r(st.$$.fragment),ml=a(),lt=i("p"),lt.innerHTML=ln,jl=a(),r(at.$$.fragment),Ul=a(),nt=i("p"),nt.textContent=an,wl=a(),it=i("p"),it.innerHTML=nn,fl=a(),pt=i("p"),pt.innerHTML=pn,Il=a(),r(ot.$$.fragment),gl=a(),r(rt.$$.fragment),Cl=a(),ut=i("p"),ut.innerHTML=on,bl=a(),ct=i("p"),ct.innerHTML=rn,vl=a(),k=i("div"),k.innerHTML=un,xl=a(),Mt=i("p"),Mt.textContent=cn,kl=a(),r(yt.$$.fragment),Al=a(),r(ht.$$.fragment),ql=a(),A=i("blockquote"),A.innerHTML=Mn,Bl=a(),r(dt.$$.fragment),$l=a(),Jt=i("p"),Jt.innerHTML=yn,Hl=a(),Tt=i("p"),Tt.innerHTML=hn,Gl=a(),mt=i("p"),mt.textContent=dn,Zl=a(),jt=i("p"),jt.textContent=Jn,_l=a(),r(Ut.$$.fragment),Rl=a(),r(wt.$$.fragment),Wl=a(),ft=i("ul"),ft.innerHTML=Tn,Sl=a(),r(It.$$.fragment),Vl=a(),gt=i("ul"),gt.innerHTML=mn,Xl=a(),r(Ct.$$.fragment),Ql=a(),bt=i("p"),bt.textContent=jn,El=a(),vt=i("p"),vt.textContent=Un,Yl=a(),xt=i("ul"),xt.innerHTML=wn,Nl=a(),r(kt.$$.fragment),Fl=a(),At=i("p"),At.innerHTML=fn,Ll=a(),qt=i("p"),qt.innerHTML=In,Pl=a(),r(Bt.$$.fragment),zl=a(),Ht=i("p"),this.h()},l(e){const t=An("svelte-u9bgzb",document.head);m=p(t,"META",{name:!0,content:!0}),t.forEach(s),Gt=n(e),$t=p(e,"P",{}),gn($t).forEach(s),Zt=n(e),u(q.$$.fragment,e),_t=n(e),u(B.$$.fragment,e),Rt=n(e),j=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-x496yh"&&(j.innerHTML=Kl),Wt=n(e),U=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-l0yerj"&&(U.innerHTML=ea),St=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-eo2v07"&&($.textContent=ta),Vt=n(e),H=p(e,"OL",{"data-svelte-h":!0}),o(H)!=="svelte-8emskd"&&(H.innerHTML=sa),Xt=n(e),u(G.$$.fragment,e),Qt=n(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-zeuxd7"&&(w.innerHTML=la),Et=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-iwney4"&&(Z.innerHTML=aa),Yt=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1xoupob"&&(_.textContent=na),Nt=n(e),u(R.$$.fragment,e),Ft=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-hjt0h1"&&(W.innerHTML=ia),Lt=n(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1cxy3tx"&&(f.innerHTML=pa),Pt=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-vmhaok"&&(S.innerHTML=oa),zt=n(e),I=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-10s1rk5"&&(I.innerHTML=ra),Dt=n(e),u(V.$$.fragment,e),Ot=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-epfhsj"&&(X.textContent=ua),Kt=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-n5dyw"&&(Q.textContent=ca),es=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-qm2nt8"&&(E.innerHTML=Ma),ts=n(e),u(Y.$$.fragment,e),ss=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-aqaw0f"&&(N.textContent=ya),ls=n(e),u(F.$$.fragment,e),as=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1ccsiy1"&&(L.innerHTML=ha),ns=n(e),u(P.$$.fragment,e),is=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-qutua8"&&(z.innerHTML=da),ps=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-uj5o95"&&(D.innerHTML=Ja),os=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1ozzcb1"&&(O.innerHTML=Ta),rs=n(e),u(K.$$.fragment,e),us=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-dq2kwm"&&(ee.innerHTML=ma),cs=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-kajnqt"&&(te.innerHTML=ja),Ms=n(e),u(se.$$.fragment,e),ys=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1vjzmk"&&(le.textContent=Ua),hs=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1147onl"&&(ae.textContent=wa),ds=n(e),g=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-1x4cl45"&&(g.innerHTML=fa),Js=n(e),u(ne.$$.fragment,e),Ts=n(e),u(ie.$$.fragment,e),ms=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-f1hll8"&&(pe.textContent=Ia),js=n(e),u(oe.$$.fragment,e),Us=n(e),re=p(e,"UL",{"data-svelte-h":!0}),o(re)!=="svelte-ul55gk"&&(re.innerHTML=ga),ws=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-khk897"&&(ue.textContent=Ca),fs=n(e),u(ce.$$.fragment,e),Is=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1avk6lq"&&(Me.innerHTML=ba),gs=n(e),u(ye.$$.fragment,e),Cs=n(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-pwj71q"&&(he.textContent=va),bs=n(e),de=p(e,"UL",{"data-svelte-h":!0}),o(de)!=="svelte-gmdx7h"&&(de.innerHTML=xa),vs=n(e),u(Je.$$.fragment,e),xs=n(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1s9oaze"&&(Te.innerHTML=ka),ks=n(e),C=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1nwdy9v"&&(C.innerHTML=Aa),As=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-m8oll3"&&(me.textContent=qa),qs=n(e),u(je.$$.fragment,e),Bs=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-f1hll8"&&(Ue.textContent=Ba),$s=n(e),u(we.$$.fragment,e),Hs=n(e),fe=p(e,"UL",{"data-svelte-h":!0}),o(fe)!=="svelte-amxywc"&&(fe.innerHTML=$a),Gs=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-khk897"&&(Ie.textContent=Ha),Zs=n(e),u(ge.$$.fragment,e),_s=n(e),u(Ce.$$.fragment,e),Rs=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1wwgzam"&&(be.innerHTML=Ga),Ws=n(e),u(ve.$$.fragment,e),Ss=n(e),xe=p(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-18yjufw"&&(xe.textContent=Za),Vs=n(e),u(ke.$$.fragment,e),Xs=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1ar1qn2"&&(Ae.textContent=_a),Qs=n(e),u(qe.$$.fragment,e),Es=n(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1wwgzam"&&(Be.innerHTML=Ra),Ys=n(e),u($e.$$.fragment,e),Ns=n(e),u(He.$$.fragment,e),Fs=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-16sv3hm"&&(Ge.textContent=Wa),Ls=n(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1tlxndq"&&(b.innerHTML=Sa),Ps=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1ovcz13"&&(Ze.textContent=Va),zs=n(e),u(_e.$$.fragment,e),Ds=n(e),u(Re.$$.fragment,e),Os=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-aop9q6"&&(We.textContent=Xa),Ks=n(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-11lkosy"&&(Se.textContent=Qa),el=n(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(v)!=="svelte-32c4s1"&&(v.innerHTML=Ea),tl=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1s4io98"&&(Ve.textContent=Ya),sl=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-2tk9q6"&&(Xe.textContent=Na),ll=n(e),Qe=p(e,"UL",{"data-svelte-h":!0}),o(Qe)!=="svelte-3d87kx"&&(Qe.innerHTML=Fa),al=n(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-kzwdhh"&&(Ee.textContent=La),nl=n(e),Ye=p(e,"UL",{"data-svelte-h":!0}),o(Ye)!=="svelte-ao16pi"&&(Ye.innerHTML=Pa),il=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1rp1v84"&&(Ne.textContent=za),pl=n(e),u(Fe.$$.fragment,e),ol=n(e),Le=p(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-lf5sv5"&&(Le.innerHTML=Da),rl=n(e),x=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(x)!=="svelte-1roilif"&&(x.innerHTML=Oa),ul=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1072wo1"&&(Pe.textContent=Ka),cl=n(e),u(ze.$$.fragment,e),Ml=n(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-ogq2gt"&&(De.textContent=en),yl=n(e),u(Oe.$$.fragment,e),hl=n(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-krncuc"&&(Ke.textContent=tn),dl=n(e),u(et.$$.fragment,e),Jl=n(e),tt=p(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1qjt2rq"&&(tt.textContent=sn),Tl=n(e),u(st.$$.fragment,e),ml=n(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-bpbibl"&&(lt.innerHTML=ln),jl=n(e),u(at.$$.fragment,e),Ul=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-speu7d"&&(nt.textContent=an),wl=n(e),it=p(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-13ler1d"&&(it.innerHTML=nn),fl=n(e),pt=p(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-ub059v"&&(pt.innerHTML=pn),Il=n(e),u(ot.$$.fragment,e),gl=n(e),u(rt.$$.fragment,e),Cl=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-j3nwqb"&&(ut.innerHTML=on),bl=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-1wtje4i"&&(ct.innerHTML=rn),vl=n(e),k=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-1t803ai"&&(k.innerHTML=un),xl=n(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1urjnn1"&&(Mt.textContent=cn),kl=n(e),u(yt.$$.fragment,e),Al=n(e),u(ht.$$.fragment,e),ql=n(e),A=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(A)!=="svelte-yl0e6m"&&(A.innerHTML=Mn),Bl=n(e),u(dt.$$.fragment,e),$l=n(e),Jt=p(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-102eqn3"&&(Jt.innerHTML=yn),Hl=n(e),Tt=p(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-lavds"&&(Tt.innerHTML=hn),Gl=n(e),mt=p(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-f0qt8k"&&(mt.textContent=dn),Zl=n(e),jt=p(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-w9ft7n"&&(jt.textContent=Jn),_l=n(e),u(Ut.$$.fragment,e),Rl=n(e),u(wt.$$.fragment,e),Wl=n(e),ft=p(e,"UL",{"data-svelte-h":!0}),o(ft)!=="svelte-117ozzs"&&(ft.innerHTML=Tn),Sl=n(e),u(It.$$.fragment,e),Vl=n(e),gt=p(e,"UL",{"data-svelte-h":!0}),o(gt)!=="svelte-vl7c7p"&&(gt.innerHTML=mn),Xl=n(e),u(Ct.$$.fragment,e),Ql=n(e),bt=p(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-ccionj"&&(bt.textContent=jn),El=n(e),vt=p(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1dt3smc"&&(vt.textContent=Un),Yl=n(e),xt=p(e,"UL",{"data-svelte-h":!0}),o(xt)!=="svelte-1lgvq31"&&(xt.innerHTML=wn),Nl=n(e),u(kt.$$.fragment,e),Fl=n(e),At=p(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1yfr1yr"&&(At.innerHTML=fn),Ll=n(e),qt=p(e,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-1duzsqa"&&(qt.innerHTML=In),Pl=n(e),u(Bt.$$.fragment,e),zl=n(e),Ht=p(e,"P",{}),gn(Ht).forEach(s),this.h()},h(){T(m,"name","hf:doc:metadata"),T(m,"content",Gn),T(j,"class","tip"),T(U,"class","warning"),T(w,"class","tip"),T(f,"class","flex justify-center"),T(I,"class","tip"),T(g,"class","tip"),T(C,"class","tip"),T(b,"class","warning"),T(v,"class","flex justify-center"),T(x,"class","flex justify-center"),T(k,"class","flex justify-center"),T(A,"class","tip")},m(e,t){qn(document.head,m),l(e,Gt,t),l(e,$t,t),l(e,Zt,t),c(q,e,t),l(e,_t,t),c(B,e,t),l(e,Rt,t),l(e,j,t),l(e,Wt,t),l(e,U,t),l(e,St,t),l(e,$,t),l(e,Vt,t),l(e,H,t),l(e,Xt,t),c(G,e,t),l(e,Qt,t),l(e,w,t),l(e,Et,t),l(e,Z,t),l(e,Yt,t),l(e,_,t),l(e,Nt,t),c(R,e,t),l(e,Ft,t),l(e,W,t),l(e,Lt,t),l(e,f,t),l(e,Pt,t),l(e,S,t),l(e,zt,t),l(e,I,t),l(e,Dt,t),c(V,e,t),l(e,Ot,t),l(e,X,t),l(e,Kt,t),l(e,Q,t),l(e,es,t),l(e,E,t),l(e,ts,t),c(Y,e,t),l(e,ss,t),l(e,N,t),l(e,ls,t),c(F,e,t),l(e,as,t),l(e,L,t),l(e,ns,t),c(P,e,t),l(e,is,t),l(e,z,t),l(e,ps,t),l(e,D,t),l(e,os,t),l(e,O,t),l(e,rs,t),c(K,e,t),l(e,us,t),l(e,ee,t),l(e,cs,t),l(e,te,t),l(e,Ms,t),c(se,e,t),l(e,ys,t),l(e,le,t),l(e,hs,t),l(e,ae,t),l(e,ds,t),l(e,g,t),l(e,Js,t),c(ne,e,t),l(e,Ts,t),c(ie,e,t),l(e,ms,t),l(e,pe,t),l(e,js,t),c(oe,e,t),l(e,Us,t),l(e,re,t),l(e,ws,t),l(e,ue,t),l(e,fs,t),c(ce,e,t),l(e,Is,t),l(e,Me,t),l(e,gs,t),c(ye,e,t),l(e,Cs,t),l(e,he,t),l(e,bs,t),l(e,de,t),l(e,vs,t),c(Je,e,t),l(e,xs,t),l(e,Te,t),l(e,ks,t),l(e,C,t),l(e,As,t),l(e,me,t),l(e,qs,t),c(je,e,t),l(e,Bs,t),l(e,Ue,t),l(e,$s,t),c(we,e,t),l(e,Hs,t),l(e,fe,t),l(e,Gs,t),l(e,Ie,t),l(e,Zs,t),c(ge,e,t),l(e,_s,t),c(Ce,e,t),l(e,Rs,t),l(e,be,t),l(e,Ws,t),c(ve,e,t),l(e,Ss,t),l(e,xe,t),l(e,Vs,t),c(ke,e,t),l(e,Xs,t),l(e,Ae,t),l(e,Qs,t),c(qe,e,t),l(e,Es,t),l(e,Be,t),l(e,Ys,t),c($e,e,t),l(e,Ns,t),c(He,e,t),l(e,Fs,t),l(e,Ge,t),l(e,Ls,t),l(e,b,t),l(e,Ps,t),l(e,Ze,t),l(e,zs,t),c(_e,e,t),l(e,Ds,t),c(Re,e,t),l(e,Os,t),l(e,We,t),l(e,Ks,t),l(e,Se,t),l(e,el,t),l(e,v,t),l(e,tl,t),l(e,Ve,t),l(e,sl,t),l(e,Xe,t),l(e,ll,t),l(e,Qe,t),l(e,al,t),l(e,Ee,t),l(e,nl,t),l(e,Ye,t),l(e,il,t),l(e,Ne,t),l(e,pl,t),c(Fe,e,t),l(e,ol,t),l(e,Le,t),l(e,rl,t),l(e,x,t),l(e,ul,t),l(e,Pe,t),l(e,cl,t),c(ze,e,t),l(e,Ml,t),l(e,De,t),l(e,yl,t),c(Oe,e,t),l(e,hl,t),l(e,Ke,t),l(e,dl,t),c(et,e,t),l(e,Jl,t),l(e,tt,t),l(e,Tl,t),c(st,e,t),l(e,ml,t),l(e,lt,t),l(e,jl,t),c(at,e,t),l(e,Ul,t),l(e,nt,t),l(e,wl,t),l(e,it,t),l(e,fl,t),l(e,pt,t),l(e,Il,t),c(ot,e,t),l(e,gl,t),c(rt,e,t),l(e,Cl,t),l(e,ut,t),l(e,bl,t),l(e,ct,t),l(e,vl,t),l(e,k,t),l(e,xl,t),l(e,Mt,t),l(e,kl,t),c(yt,e,t),l(e,Al,t),c(ht,e,t),l(e,ql,t),l(e,A,t),l(e,Bl,t),c(dt,e,t),l(e,$l,t),l(e,Jt,t),l(e,Hl,t),l(e,Tt,t),l(e,Gl,t),l(e,mt,t),l(e,Zl,t),l(e,jt,t),l(e,_l,t),c(Ut,e,t),l(e,Rl,t),c(wt,e,t),l(e,Wl,t),l(e,ft,t),l(e,Sl,t),c(It,e,t),l(e,Vl,t),l(e,gt,t),l(e,Xl,t),c(Ct,e,t),l(e,Ql,t),l(e,bt,t),l(e,El,t),l(e,vt,t),l(e,Yl,t),l(e,xt,t),l(e,Nl,t),c(kt,e,t),l(e,Fl,t),l(e,At,t),l(e,Ll,t),l(e,qt,t),l(e,Pl,t),c(Bt,e,t),l(e,zl,t),l(e,Ht,t),Dl=!0},p:bn,i(e){Dl||(M(q.$$.fragment,e),M(B.$$.fragment,e),M(G.$$.fragment,e),M(R.$$.fragment,e),M(V.$$.fragment,e),M(Y.$$.fragment,e),M(F.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(ye.$$.fragment,e),M(Je.$$.fragment,e),M(je.$$.fragment,e),M(we.$$.fragment,e),M(ge.$$.fragment,e),M(Ce.$$.fragment,e),M(ve.$$.fragment,e),M(ke.$$.fragment,e),M(qe.$$.fragment,e),M($e.$$.fragment,e),M(He.$$.fragment,e),M(_e.$$.fragment,e),M(Re.$$.fragment,e),M(Fe.$$.fragment,e),M(ze.$$.fragment,e),M(Oe.$$.fragment,e),M(et.$$.fragment,e),M(st.$$.fragment,e),M(at.$$.fragment,e),M(ot.$$.fragment,e),M(rt.$$.fragment,e),M(yt.$$.fragment,e),M(ht.$$.fragment,e),M(dt.$$.fragment,e),M(Ut.$$.fragment,e),M(wt.$$.fragment,e),M(It.$$.fragment,e),M(Ct.$$.fragment,e),M(kt.$$.fragment,e),M(Bt.$$.fragment,e),Dl=!0)},o(e){y(q.$$.fragment,e),y(B.$$.fragment,e),y(G.$$.fragment,e),y(R.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),y(F.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(oe.$$.fragment,e),y(ce.$$.fragment,e),y(ye.$$.fragment,e),y(Je.$$.fragment,e),y(je.$$.fragment,e),y(we.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y(ke.$$.fragment,e),y(qe.$$.fragment,e),y($e.$$.fragment,e),y(He.$$.fragment,e),y(_e.$$.fragment,e),y(Re.$$.fragment,e),y(Fe.$$.fragment,e),y(ze.$$.fragment,e),y(Oe.$$.fragment,e),y(et.$$.fragment,e),y(st.$$.fragment,e),y(at.$$.fragment,e),y(ot.$$.fragment,e),y(rt.$$.fragment,e),y(yt.$$.fragment,e),y(ht.$$.fragment,e),y(dt.$$.fragment,e),y(Ut.$$.fragment,e),y(wt.$$.fragment,e),y(It.$$.fragment,e),y(Ct.$$.fragment,e),y(kt.$$.fragment,e),y(Bt.$$.fragment,e),Dl=!1},d(e){e&&(s(Gt),s($t),s(Zt),s(_t),s(Rt),s(j),s(Wt),s(U),s(St),s($),s(Vt),s(H),s(Xt),s(Qt),s(w),s(Et),s(Z),s(Yt),s(_),s(Nt),s(Ft),s(W),s(Lt),s(f),s(Pt),s(S),s(zt),s(I),s(Dt),s(Ot),s(X),s(Kt),s(Q),s(es),s(E),s(ts),s(ss),s(N),s(ls),s(as),s(L),s(ns),s(is),s(z),s(ps),s(D),s(os),s(O),s(rs),s(us),s(ee),s(cs),s(te),s(Ms),s(ys),s(le),s(hs),s(ae),s(ds),s(g),s(Js),s(Ts),s(ms),s(pe),s(js),s(Us),s(re),s(ws),s(ue),s(fs),s(Is),s(Me),s(gs),s(Cs),s(he),s(bs),s(de),s(vs),s(xs),s(Te),s(ks),s(C),s(As),s(me),s(qs),s(Bs),s(Ue),s($s),s(Hs),s(fe),s(Gs),s(Ie),s(Zs),s(_s),s(Rs),s(be),s(Ws),s(Ss),s(xe),s(Vs),s(Xs),s(Ae),s(Qs),s(Es),s(Be),s(Ys),s(Ns),s(Fs),s(Ge),s(Ls),s(b),s(Ps),s(Ze),s(zs),s(Ds),s(Os),s(We),s(Ks),s(Se),s(el),s(v),s(tl),s(Ve),s(sl),s(Xe),s(ll),s(Qe),s(al),s(Ee),s(nl),s(Ye),s(il),s(Ne),s(pl),s(ol),s(Le),s(rl),s(x),s(ul),s(Pe),s(cl),s(Ml),s(De),s(yl),s(hl),s(Ke),s(dl),s(Jl),s(tt),s(Tl),s(ml),s(lt),s(jl),s(Ul),s(nt),s(wl),s(it),s(fl),s(pt),s(Il),s(gl),s(Cl),s(ut),s(bl),s(ct),s(vl),s(k),s(xl),s(Mt),s(kl),s(Al),s(ql),s(A),s(Bl),s($l),s(Jt),s(Hl),s(Tt),s(Gl),s(mt),s(Zl),s(jt),s(_l),s(Rl),s(Wl),s(ft),s(Sl),s(Vl),s(gt),s(Xl),s(Ql),s(bt),s(El),s(vt),s(Yl),s(xt),s(Nl),s(Fl),s(At),s(Ll),s(qt),s(Pl),s(zl),s(Ht)),s(m),h(q,e),h(B,e),h(G,e),h(R,e),h(V,e),h(Y,e),h(F,e),h(P,e),h(K,e),h(se,e),h(ne,e),h(ie,e),h(oe,e),h(ce,e),h(ye,e),h(Je,e),h(je,e),h(we,e),h(ge,e),h(Ce,e),h(ve,e),h(ke,e),h(qe,e),h($e,e),h(He,e),h(_e,e),h(Re,e),h(Fe,e),h(ze,e),h(Oe,e),h(et,e),h(st,e),h(at,e),h(ot,e),h(rt,e),h(yt,e),h(ht,e),h(dt,e),h(Ut,e),h(wt,e),h(It,e),h(Ct,e),h(kt,e),h(Bt,e)}}}const Gn='{"title":"How to be registered as an inference provider on the Hub?","local":"how-to-be-registered-as-an-inference-provider-on-the-hub","sections":[{"title":"1. Prerequisites","local":"1-prerequisites","sections":[{"title":"What is a Task","local":"what-is-a-task","sections":[],"depth":3},{"title":"Task API schema","local":"task-api-schema","sections":[],"depth":3}],"depth":2},{"title":"2. JS Client Integration","local":"2-js-client-integration","sections":[{"title":"Implement the provider helper (JS)","local":"implement-the-provider-helper-js","sections":[],"depth":3},{"title":"Register the provider","local":"register-the-provider","sections":[],"depth":3}],"depth":2},{"title":"3. Model Mapping API","local":"3-model-mapping-api","sections":[{"title":"Register a mapping item","local":"register-a-mapping-item","sections":[{"title":"Authentication","local":"authentication","sections":[],"depth":4},{"title":"Validation","local":"validation","sections":[],"depth":4}],"depth":3},{"title":"Using a tag-filter to map several HF models to a single inference endpoint","local":"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint","sections":[],"depth":3},{"title":"Delete a mapping item","local":"delete-a-mapping-item","sections":[],"depth":3},{"title":"Update a mapping item’s status","local":"update-a-mapping-items-status","sections":[],"depth":3},{"title":"List the whole mapping","local":"list-the-whole-mapping","sections":[],"depth":3},{"title":"Automatic validation","local":"automatic-validation","sections":[],"depth":3}],"depth":2},{"title":"4. Billing","local":"4-billing","sections":[{"title":"HTTP API Specs","local":"http-api-specs","sections":[],"depth":3},{"title":"Price Unit","local":"price-unit","sections":[],"depth":3},{"title":"How to define the request ID","local":"how-to-define-the-request-id","sections":[],"depth":3},{"title":"Exposing pricing through OpenAI /models routes","local":"exposing-pricing-through-openai-models-routes","sections":[],"depth":3}],"depth":2},{"title":"5. Python client integration","local":"5-python-client-integration","sections":[{"title":"Implement the provider helper (Python)","local":"implement-the-provider-helper-python","sections":[],"depth":3},{"title":"Register the Provider","local":"register-the-provider","sections":[],"depth":3},{"title":"Add tests","local":"add-tests","sections":[],"depth":3}],"depth":2},{"title":"6. Add provider documentation","local":"6-add-provider-documentation","sections":[],"depth":2},{"title":"FAQ","local":"faq","sections":[],"depth":2}],"depth":1}';function Zn(Ol){return vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xn extends xn{constructor(m){super(),kn(this,m,Zn,Hn,Cn,{})}}export{Xn as component};
