import{s as Gt,n as St,o as _t}from"../chunks/scheduler.f9cad8c1.js";import{S as zt,i as Xt,e as n,s,c as M,h as qt,a as T,d as e,b as U,f as xt,g as i,j as a,k as yt,l as Yt,m as J,n as p,t as C,o as y,p as o}from"../chunks/index.6e06ef99.js";import{C as Wt,H as w,E as Ht}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.36dfee0e.js";import{C as Cl}from"../chunks/CodeBlock.4da67c88.js";import{D as Lt}from"../chunks/DocNotebookDropdown.77f2c2c1.js";function Pt(ot){let V,wl,yl,Vl,g,Il,Q,rl,j,gl,m,Ql,c,wt="검색 증강 생성(Retrieval-Augmented Generation, RAG)은 대규모 언어 모델의 능력과 외부 지식 검색을 결합하여 더 정확하고 사실에 기반을 두며 문맥에 맞는 응답을 생성합니다. RAG의 핵심은 “대규모 언어 모델을 사용해 사용자 쿼리에 답변을 제공하되, 지식 베이스에서 검색된 정보에 기반하여 답변하는 것”입니다.",jl,u,ml,R,Vt="RAG는 기본 대규모 언어 모델이나 미세 조정된 모델을 사용하는 것에 비해 다음과 같은 몇 가지 중요한 장점을 제공합니다.",cl,h,It="<li><strong>사실 기반 생성</strong>: 답변의 근거를 검색 결과에 두어 환각 현상을 줄입니다.</li> <li><strong>도메인 특화</strong>: 모델을 다시 훈련시키지 않고도 특정 도메인의 지식을 제공합니다.</li> <li><strong>최신 지식 반영</strong>: 모델의 훈련 시점 이후의 정보에도 접근할 수 있습니다.</li> <li><strong>투명성</strong>: 생성된 콘텐츠의 출처를 인용할 수 있습니다.</li> <li><strong>제어</strong>: 모델이 접근할 수 있는 정보를 세밀하게 제어할 수 있습니다.</li>",ul,E,Rl,f,rt="이러한 장점에도 불구하고, 전통적인 RAG 접근 방식은 다음과 같은 몇 가지 문제가 있습니다.",hl,b,gt="<li><strong>단일 검색 단계</strong>: 초기 검색 결과가 좋지 않으면 최종 생성 결과의 품질이 저하됩니다.</li> <li><strong>쿼리-문서 불일치</strong>: 사용자 쿼리(주로 질문)가 답변을 포함하는 문서(주로 서술문)와 잘 일치하지 않을 수 있습니다.</li> <li><strong>제한된 추론</strong>: 단순한 RAG 파이프라인은 다단계 논리적 추론이나 쿼리 정제를 허용하지 않습니다.</li> <li><strong>컨텍스트 윈도우 제약</strong>: 검색된 문서는 모델의 컨텍스트 윈도우 크기에 맞춰야 합니다.</li>",El,d,fl,B,Qt="<strong>Agentic RAG</strong> 시스템, 즉 검색 능력을 갖춘 에이전트를 구현함으로써 이러한 한계를 극복할 수 있습니다. 이 접근 방식은 RAG를 경직된 파이프라인에서 논리적 추론 중심의 상호작용적 프로세스로 탈바꿈시키는 방식입니다.",bl,k,dl,D,jt="검색 도구를 갖춘 에이전트는 다음을 수행할 수 있습니다.",Bl,A,mt="<li>✅ <strong>최적화된 쿼리 생성</strong>: 에이전트는 사용자 질문을 검색에 적합한 쿼리로 변환할 수 있습니다.</li> <li>✅ <strong>다중 검색 수행</strong>: 에이전트는 필요에 따라 반복적으로 정보를 검색할 수 있습니다.</li> <li>✅ <strong>검색 결과 기반 논리적 추론</strong>: 에이전트는 여러 소스의 정보를 분석, 종합하고 결론을 도출할 수 있습니다.</li> <li>✅ <strong>자체 평가 및 개선</strong>: 에이전트는 검색 결과를 평가하고 접근 방식을 조정할 수 있습니다.</li>",kl,$,ct="이 접근 방식은 다음과 같은 Agentic RAG 기술을 자연스럽게 구현합니다.",Dl,F,ut='<li><strong>가상 문서 임베딩(HyDE)</strong>: 사용자 쿼리를 직접 사용하는 대신, 에이전트가 검색에 최적화된 쿼리를 생성합니다 (<a href="https://huggingface.co/papers/2212.10496" rel="nofollow">논문 참조</a>)</li> <li><strong>자가 쿼리 정제</strong>: 에이전트가 초기 결과를 분석하고 정제된 쿼리로 후속 검색을 수행할 수 있습니다 (<a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">기술 참조</a>)</li>',Al,O,$l,v,Rt="이제 단계별로 Agentic RAG 시스템을 구축해 보겠습니다. 이 예제에서는 허깅 페이스 Transformers 라이브러리 설명서를 검색해 질문에 답할 수 있는 에이전트를 만들어 보겠습니다.",Fl,Z,ht='아래 코드 스니펫을 따라 하거나, smolagents GitHub 리포지토리에서 전체 예제를 확인할 수 있습니다: <a href="https://github.com/huggingface/smolagents/blob/main/examples/rag.py" rel="nofollow">examples/rag.py</a>.',Ol,N,vl,x,Et="먼저, 필요한 패키지를 설치해야 합니다.",Zl,G,Nl,S,ft="허깅 페이스의 추론 API를 사용하려면 API 토큰을 설정해야 합니다.",xl,_,Gl,z,Sl,X,bt="허깅 페이스 설명서가 포함된 데이터 세트를 불러와 검색에 사용할 준비를 해보겠습니다.",_l,q,zl,Y,Xl,W,dt="이제 에이전트가 지식 베이스에서 정보를 검색하는 데 사용할 수 있는 사용자 정의 도구를 만들어 보겠습니다.",ql,H,Yl,I,Bt='<p>단순성과 속도를 위해 어휘 검색 방식인 BM25를 사용하고 있습니다. 실제 서비스 환경에서는 검색 품질을 높이기 위해 임베딩을 활용한 의미 기반 검색을 사용하는 것이 좋습니다. 고품질 임베딩 모델은 <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB 리더보드</a>에서 확인하세요.</p>',Wl,L,Hl,P,kt="다음으로 앞서 만든 검색 도구를 활용해 질문에 답할 수 있는 에이전트를 구성해 봅시다.",Ll,K,Pl,r,Dt='<p>Inference Provider는 서버리스 추론 파트너가 제공하는 수백 개의 모델에 대한 액세스를 제공합니다. 지원되는 제공업체 목록은 <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">여기</a>에서 찾을 수 있습니다.</p>',Kl,ll,lt,tl,At="마지막으로 에이전트를 실행해 Transformers 관련 질문에 답해 보겠습니다.",tt,el,et,Jl,Jt,sl,$t="Agentic RAG 시스템은 다양한 사용 사례에 적용될 수 있습니다.",st,Ul,Ft="<li><strong>기술 문서 지원</strong>: 사용자가 복잡한 기술 문서를 탐색하는 데 도움을 줍니다.</li> <li><strong>연구 논문 분석</strong>: 과학 논문에서 정보를 추출하고 종합합니다.</li> <li><strong>법률 문서 검토</strong>: 법률 문서에서 관련 판례와 조항을 찾습니다.</li> <li><strong>고객 지원</strong>: 제품 설명서와 지식 베이스를 기반으로 질문에 답변합니다.</li> <li><strong>교육 튜터링</strong>: 교과서와 학습 자료를 기반으로 설명을 제공합니다.</li>",Ut,nl,nt,Tl,Ot="Agentic RAG는 전통적인 RAG 파이프라인을 뛰어넘는 중요한 발전을 의미합니다. 대형 언어 모델 에이전트의 추론 능력과 검색 시스템의 사실 기반을 결합함으로써, 우리는 더 강력하고 유연하며 정확한 정보 시스템을 구축할 수 있습니다.",Tt,al,vt="저희가 보여드린 접근 방식은 다음과 같은 특징이 있습니다:",at,Ml,Zt="<li>단일 단계 검색의 한계를 극복합니다.</li> <li>지식 베이스와의 상호작용이 더 자연스러워집니다.</li> <li>자체 평가와 쿼리 정제를 통해 지속해서 개선할 수 있는 프레임워크를 제공합니다.</li>",Mt,il,Nt="자신만의 Agentic RAG 시스템을 구축할 때에는, 다양한 검색 방법과 에이전트 아키텍처, 지식 소스를 실험하며 사용 사례에 최적화된 구성을 찾아보세요.",it,pl,pt,ol,Ct;return g=new Wt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),Q=new Lt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/tensorflow/rag.ipynb"}]}}),j=new w({props:{title:"Agentic RAG",local:"agentic-rag",headingTag:"h1"}}),m=new w({props:{title:"RAG(검색 증강 생성) 소개",local:"introduction-to-retrieval-augmented-generation-rag",headingTag:"h2"}}),u=new w({props:{title:"RAG를 사용하는 이유",local:"why-use-rag",headingTag:"h3"}}),E=new w({props:{title:"전통적인 RAG의 한계",local:"limitations-of-traditional-rag",headingTag:"h3"}}),d=new w({props:{title:"Agentic RAG: 더 강력한 접근 방식",local:"agentic-rag-a-more-powerful-approach",headingTag:"h2"}}),k=new w({props:{title:"Agentic RAG의 주요 장점",local:"key-benefits-of-agentic-rag",headingTag:"h3"}}),O=new w({props:{title:"Agentic RAG 시스템 구축하기",local:"building-an-agentic-rag-system",headingTag:"h2"}}),N=new w({props:{title:"1단계: 필요한 의존성 설치하기",local:"step-1-install-required-dependencies",headingTag:"h3"}}),G=new Cl({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZGF0YXNldHMlMjBweXRob24tZG90ZW52JTIwcmFua19ibTI1JTIwLS11cGdyYWRl",highlighted:"pip install smolagents pandas langchain langchain-community sentence-transformers datasets python-dotenv rank_bm25 --upgrade",wrap:!1}}),_=new Cl({props:{code:"JTIzJTIwJUVEJTk5JTk4JUVBJUIyJUJEJTIwJUVCJUIzJTgwJUVDJTg4JTk4JTIwJUVCJUExJTlDJUVCJTkzJTlDJTIwKEhGX1RPS0VOJTIwJUVEJThGJUFDJUVEJTk1JUE4KSUwQWZyb20lMjBkb3RlbnYlMjBpbXBvcnQlMjBsb2FkX2RvdGVudiUwQWxvYWRfZG90ZW52KCk=",highlighted:`<span class="hljs-comment"># 환경 변수 로드 (HF_TOKEN 포함)</span>
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),z=new w({props:{title:"2단계: 지식 베이스 준비하기",local:"step-2-prepare-the-knowledge-base",headingTag:"h3"}}),q=new Cl({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

<span class="hljs-comment"># 허깅 페이스 설명서 데이터 세트 로드</span>
knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Transformers 라이브러리 설명서만 포함하도록 필터링</span>
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

<span class="hljs-comment"># 데이터 세트 항목을 메타데이터가 있는 Document 객체로 변환</span>
source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

<span class="hljs-comment"># 더 나은 검색을 위해 문서를 작은 청크로 분할</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,  <span class="hljs-comment"># 청크당 문자 수</span>
    chunk_overlap=<span class="hljs-number">50</span>,  <span class="hljs-comment"># 컨텍스트 유지를 위한 청크 간 중첩</span>
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],  <span class="hljs-comment"># 분할 우선순위</span>
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Knowledge base prepared with <span class="hljs-subst">{<span class="hljs-built_in">len</span>(docs_processed)}</span> document chunks&quot;</span>)`,wrap:!1}}),Y=new w({props:{title:"3단계: 검색 도구 만들기",local:"step-3-create-a-retriever-tool",headingTag:"h3"}}),H=new Cl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;의미 기반 검색을 사용하여 쿼리에 답변하는 데 가장 관련성이 높은 transformers 설명서 부분을 검색합니다.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;수행할 쿼리입니다. 대상 문서와 의미적으로 가까워야 합니다. 질문보다는 긍정문을 사용하세요.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        <span class="hljs-comment"># 처리된 문서로 검색기 초기화</span>
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>  <span class="hljs-comment"># 가장 관련성 높은 상위 10개 문서 반환</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;제공된 쿼리를 기반으로 검색을 실행합니다.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        <span class="hljs-comment"># 관련 문서 검색</span>
        docs = self.retriever.invoke(query)

        <span class="hljs-comment"># 가독성을 위해 검색된 문서 형식 지정</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># 처리된 문서로 검색 도구 초기화</span>
retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),L=new w({props:{title:"4단계: 고급 검색 에이전트 만들기",local:"step-4-create-an-advanced-retrieval-agent",headingTag:"h3"}}),K=new Cl({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMCVFQSVCMiU4MCVFQyU4MyU4OSUyMCVFQiU4RiU4NCVFQSVCNSVBQyVFQiVBMSU5QyUyMCVFQyU5NyU5MCVFQyU5RCVCNCVFQyVBMCU4NCVFRCU4QSVCOCUyMCVFQyVCNCU4OCVFQSVCOCVCMCVFRCU5OSU5NCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjAlMjAlMjMlMjAlRUMlOTclOTAlRUMlOUQlQjQlRUMlQTAlODQlRUQlOEElQjglRUElQjAlODAlMjAlRUMlODIlQUMlRUMlOUElQTklRUQlOTUlQTAlMjAlRUMlODglOTglMjAlRUMlOUUlODglRUIlOEElOTQlMjAlRUIlOEYlODQlRUElQjUlQUMlMjAlRUIlQUElQTklRUIlQTElOUQlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCklMkMlMjAlMjAlMjMlMjAlRUElQjglQjAlRUIlQjMlQjglMjAlRUIlQUElQTglRUIlOEQlQjglMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0JTJDJTIwJTIwJTIzJTIwJUVCJTg1JUJDJUVCJUE2JUFDJUVDJUEwJTgxJTIwJUVDJUI2JTk0JUVCJUExJUEwJTIwJUVCJThCJUE4JUVBJUIzJTg0JTIwJUVDJTg4JTk4JTIwJUVDJUEwJTlDJUVEJTk1JTlDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMiUyQyUyMCUyMCUyMyUyMCVFQyU5NyU5MCVFQyU5RCVCNCVFQyVBMCU4NCVFRCU4QSVCOCVFQyU5RCU5OCUyMCVFQyU4MyU4MSVFQyU4NCVCOCVFRCU5NSU5QyUyMCVFQiU4NSVCQyVFQiVBNiVBQyVFQyVBMCU4MSUyMCVFQyVCNiU5NCVFQiVBMSVBMCUyMCVFQSVCMyVCQyVFQyVBMCU5NSUyMCVFRCU5MSU5QyVFQyU4QiU5QyUwQSklMEElMEElMjMlMjAlRUQlOEElQjklRUMlQTAlOTUlMjAlRUIlQUElQTglRUIlOEQlQjglRUMlOUQlODQlMjAlRUMlODIlQUMlRUMlOUElQTklRUQlOTUlOTglRUIlQTAlQTQlRUIlQTklQjQlMjAlRUIlOEIlQTQlRUMlOUQlOEMlRUElQjMlQkMlMjAlRUElQjAlOTklRUMlOUQlQjQlMjAlRUMlQTclODAlRUMlQTAlOTUlRUQlOTUlQTAlMjAlRUMlODglOTglMjAlRUMlOUUlODglRUMlOEElQjUlRUIlOEIlODglRUIlOEIlQTQlM0ElMEElMjMlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># 검색 도구로 에이전트 초기화</span>
agent = CodeAgent(
    tools=[retriever_tool],  <span class="hljs-comment"># 에이전트가 사용할 수 있는 도구 목록</span>
    model=InferenceClientModel(),  <span class="hljs-comment"># 기본 모델 &quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>
    max_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># 논리적 추론 단계 수 제한</span>
    verbosity_level=<span class="hljs-number">2</span>,  <span class="hljs-comment"># 에이전트의 상세한 논리적 추론 과정 표시</span>
)

<span class="hljs-comment"># 특정 모델을 사용하려면 다음과 같이 지정할 수 있습니다:</span>
<span class="hljs-comment"># model=InferenceClientModel(model_id=&quot;meta-llama/Llama-3.3-70B-Instruct&quot;)</span>`,wrap:!1}}),ll=new w({props:{title:"5단계: 에이전트를 실행하여 질문에 답하기",local:"step-5-run-the-agent-to-answer-questions",headingTag:"h3"}}),el=new Cl({props:{code:"JTIzJTIwJUVDJUEwJTk1JUVCJUIzJUI0JTIwJUVBJUIyJTgwJUVDJTgzJTg5JUVDJTlEJUI0JTIwJUVEJTk1JTg0JUVDJTlBJTk0JUVEJTk1JTlDJTIwJUVDJUE3JTg4JUVCJUFDJUI4JUVEJTk1JTk4JUVBJUI4JUIwJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJGb3IlMjBhJTIwdHJhbnNmb3JtZXJzJTIwbW9kZWwlMjB0cmFpbmluZyUyQyUyMHdoaWNoJTIwaXMlMjBzbG93ZXIlMkMlMjB0aGUlMjBmb3J3YXJkJTIwb3IlMjB0aGUlMjBiYWNrd2FyZCUyMHBhc3MlM0YlMjIlMEElMEElMjMlMjAlRUMlOTclOTAlRUMlOUQlQjQlRUMlQTAlODQlRUQlOEElQjglRUIlQTUlQkMlMjAlRUMlOEIlQTQlRUQlOTYlODklRUQlOTUlOTglRUMlOTclQUMlMjAlRUIlOEIlQjUlRUIlQjMlODAlMjAlRUMlOTYlQkIlRUElQjglQjAlMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4ocXVlc3Rpb24pJTBBJTBBJTIzJTIwJUVDJUI1JTlDJUVDJUEyJTg1JTIwJUVCJThCJUI1JUVCJUIzJTgwJTIwJUVEJTkxJTlDJUVDJThCJTlDJTBBcHJpbnQoJTIyJTVDbkZpbmFsJTIwYW5zd2VyJTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`<span class="hljs-comment"># 정보 검색이 필요한 질문하기</span>
question = <span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>

<span class="hljs-comment"># 에이전트를 실행하여 답변 얻기</span>
agent_output = agent.run(question)

<span class="hljs-comment"># 최종 답변 표시</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nFinal answer:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),Jl=new w({props:{title:"Agentic RAG의 실제 적용 사례",local:"practical-applications-of-agentic-rag",headingTag:"h2"}}),nl=new w({props:{title:"결론",local:"conclusion",headingTag:"h2"}}),pl=new Ht({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/ko/examples/rag.md"}}),{c(){V=n("meta"),wl=s(),yl=n("p"),Vl=s(),M(g.$$.fragment),Il=s(),M(Q.$$.fragment),rl=s(),M(j.$$.fragment),gl=s(),M(m.$$.fragment),Ql=s(),c=n("p"),c.textContent=wt,jl=s(),M(u.$$.fragment),ml=s(),R=n("p"),R.textContent=Vt,cl=s(),h=n("ol"),h.innerHTML=It,ul=s(),M(E.$$.fragment),Rl=s(),f=n("p"),f.textContent=rt,hl=s(),b=n("ul"),b.innerHTML=gt,El=s(),M(d.$$.fragment),fl=s(),B=n("p"),B.innerHTML=Qt,bl=s(),M(k.$$.fragment),dl=s(),D=n("p"),D.textContent=jt,Bl=s(),A=n("ol"),A.innerHTML=mt,kl=s(),$=n("p"),$.textContent=ct,Dl=s(),F=n("ul"),F.innerHTML=ut,Al=s(),M(O.$$.fragment),$l=s(),v=n("p"),v.textContent=Rt,Fl=s(),Z=n("p"),Z.innerHTML=ht,Ol=s(),M(N.$$.fragment),vl=s(),x=n("p"),x.textContent=Et,Zl=s(),M(G.$$.fragment),Nl=s(),S=n("p"),S.textContent=ft,xl=s(),M(_.$$.fragment),Gl=s(),M(z.$$.fragment),Sl=s(),X=n("p"),X.textContent=bt,_l=s(),M(q.$$.fragment),zl=s(),M(Y.$$.fragment),Xl=s(),W=n("p"),W.textContent=dt,ql=s(),M(H.$$.fragment),Yl=s(),I=n("blockquote"),I.innerHTML=Bt,Wl=s(),M(L.$$.fragment),Hl=s(),P=n("p"),P.textContent=kt,Ll=s(),M(K.$$.fragment),Pl=s(),r=n("blockquote"),r.innerHTML=Dt,Kl=s(),M(ll.$$.fragment),lt=s(),tl=n("p"),tl.textContent=At,tt=s(),M(el.$$.fragment),et=s(),M(Jl.$$.fragment),Jt=s(),sl=n("p"),sl.textContent=$t,st=s(),Ul=n("ol"),Ul.innerHTML=Ft,Ut=s(),M(nl.$$.fragment),nt=s(),Tl=n("p"),Tl.textContent=Ot,Tt=s(),al=n("p"),al.textContent=vt,at=s(),Ml=n("ul"),Ml.innerHTML=Zt,Mt=s(),il=n("p"),il.textContent=Nt,it=s(),M(pl.$$.fragment),pt=s(),ol=n("p"),this.h()},l(l){const t=qt("svelte-u9bgzb",document.head);V=T(t,"META",{name:!0,content:!0}),t.forEach(e),wl=U(l),yl=T(l,"P",{}),xt(yl).forEach(e),Vl=U(l),i(g.$$.fragment,l),Il=U(l),i(Q.$$.fragment,l),rl=U(l),i(j.$$.fragment,l),gl=U(l),i(m.$$.fragment,l),Ql=U(l),c=T(l,"P",{"data-svelte-h":!0}),a(c)!=="svelte-blf6o0"&&(c.textContent=wt),jl=U(l),i(u.$$.fragment,l),ml=U(l),R=T(l,"P",{"data-svelte-h":!0}),a(R)!=="svelte-1sfoerf"&&(R.textContent=Vt),cl=U(l),h=T(l,"OL",{"data-svelte-h":!0}),a(h)!=="svelte-1ygu5hb"&&(h.innerHTML=It),ul=U(l),i(E.$$.fragment,l),Rl=U(l),f=T(l,"P",{"data-svelte-h":!0}),a(f)!=="svelte-psw5jn"&&(f.textContent=rt),hl=U(l),b=T(l,"UL",{"data-svelte-h":!0}),a(b)!=="svelte-4jwuro"&&(b.innerHTML=gt),El=U(l),i(d.$$.fragment,l),fl=U(l),B=T(l,"P",{"data-svelte-h":!0}),a(B)!=="svelte-1o6nqh9"&&(B.innerHTML=Qt),bl=U(l),i(k.$$.fragment,l),dl=U(l),D=T(l,"P",{"data-svelte-h":!0}),a(D)!=="svelte-1rn1yy9"&&(D.textContent=jt),Bl=U(l),A=T(l,"OL",{"data-svelte-h":!0}),a(A)!=="svelte-1k3dapo"&&(A.innerHTML=mt),kl=U(l),$=T(l,"P",{"data-svelte-h":!0}),a($)!=="svelte-6kpjgz"&&($.textContent=ct),Dl=U(l),F=T(l,"UL",{"data-svelte-h":!0}),a(F)!=="svelte-73hk90"&&(F.innerHTML=ut),Al=U(l),i(O.$$.fragment,l),$l=U(l),v=T(l,"P",{"data-svelte-h":!0}),a(v)!=="svelte-7n5l6a"&&(v.textContent=Rt),Fl=U(l),Z=T(l,"P",{"data-svelte-h":!0}),a(Z)!=="svelte-1wv8p93"&&(Z.innerHTML=ht),Ol=U(l),i(N.$$.fragment,l),vl=U(l),x=T(l,"P",{"data-svelte-h":!0}),a(x)!=="svelte-113kjmx"&&(x.textContent=Et),Zl=U(l),i(G.$$.fragment,l),Nl=U(l),S=T(l,"P",{"data-svelte-h":!0}),a(S)!=="svelte-vlb59e"&&(S.textContent=ft),xl=U(l),i(_.$$.fragment,l),Gl=U(l),i(z.$$.fragment,l),Sl=U(l),X=T(l,"P",{"data-svelte-h":!0}),a(X)!=="svelte-124nc69"&&(X.textContent=bt),_l=U(l),i(q.$$.fragment,l),zl=U(l),i(Y.$$.fragment,l),Xl=U(l),W=T(l,"P",{"data-svelte-h":!0}),a(W)!=="svelte-zbjvaj"&&(W.textContent=dt),ql=U(l),i(H.$$.fragment,l),Yl=U(l),I=T(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),a(I)!=="svelte-l03npq"&&(I.innerHTML=Bt),Wl=U(l),i(L.$$.fragment,l),Hl=U(l),P=T(l,"P",{"data-svelte-h":!0}),a(P)!=="svelte-sxdcw3"&&(P.textContent=kt),Ll=U(l),i(K.$$.fragment,l),Pl=U(l),r=T(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),a(r)!=="svelte-1887k6t"&&(r.innerHTML=Dt),Kl=U(l),i(ll.$$.fragment,l),lt=U(l),tl=T(l,"P",{"data-svelte-h":!0}),a(tl)!=="svelte-1cc0zzq"&&(tl.textContent=At),tt=U(l),i(el.$$.fragment,l),et=U(l),i(Jl.$$.fragment,l),Jt=U(l),sl=T(l,"P",{"data-svelte-h":!0}),a(sl)!=="svelte-cmsisq"&&(sl.textContent=$t),st=U(l),Ul=T(l,"OL",{"data-svelte-h":!0}),a(Ul)!=="svelte-9uo92d"&&(Ul.innerHTML=Ft),Ut=U(l),i(nl.$$.fragment,l),nt=U(l),Tl=T(l,"P",{"data-svelte-h":!0}),a(Tl)!=="svelte-cznxa3"&&(Tl.textContent=Ot),Tt=U(l),al=T(l,"P",{"data-svelte-h":!0}),a(al)!=="svelte-oztlgf"&&(al.textContent=vt),at=U(l),Ml=T(l,"UL",{"data-svelte-h":!0}),a(Ml)!=="svelte-1l34ep4"&&(Ml.innerHTML=Zt),Mt=U(l),il=T(l,"P",{"data-svelte-h":!0}),a(il)!=="svelte-9nl6kp"&&(il.textContent=Nt),it=U(l),i(pl.$$.fragment,l),pt=U(l),ol=T(l,"P",{}),xt(ol).forEach(e),this.h()},h(){yt(V,"name","hf:doc:metadata"),yt(V,"content",Kt),yt(I,"class","tip"),yt(r,"class","tip")},m(l,t){Yt(document.head,V),J(l,wl,t),J(l,yl,t),J(l,Vl,t),p(g,l,t),J(l,Il,t),p(Q,l,t),J(l,rl,t),p(j,l,t),J(l,gl,t),p(m,l,t),J(l,Ql,t),J(l,c,t),J(l,jl,t),p(u,l,t),J(l,ml,t),J(l,R,t),J(l,cl,t),J(l,h,t),J(l,ul,t),p(E,l,t),J(l,Rl,t),J(l,f,t),J(l,hl,t),J(l,b,t),J(l,El,t),p(d,l,t),J(l,fl,t),J(l,B,t),J(l,bl,t),p(k,l,t),J(l,dl,t),J(l,D,t),J(l,Bl,t),J(l,A,t),J(l,kl,t),J(l,$,t),J(l,Dl,t),J(l,F,t),J(l,Al,t),p(O,l,t),J(l,$l,t),J(l,v,t),J(l,Fl,t),J(l,Z,t),J(l,Ol,t),p(N,l,t),J(l,vl,t),J(l,x,t),J(l,Zl,t),p(G,l,t),J(l,Nl,t),J(l,S,t),J(l,xl,t),p(_,l,t),J(l,Gl,t),p(z,l,t),J(l,Sl,t),J(l,X,t),J(l,_l,t),p(q,l,t),J(l,zl,t),p(Y,l,t),J(l,Xl,t),J(l,W,t),J(l,ql,t),p(H,l,t),J(l,Yl,t),J(l,I,t),J(l,Wl,t),p(L,l,t),J(l,Hl,t),J(l,P,t),J(l,Ll,t),p(K,l,t),J(l,Pl,t),J(l,r,t),J(l,Kl,t),p(ll,l,t),J(l,lt,t),J(l,tl,t),J(l,tt,t),p(el,l,t),J(l,et,t),p(Jl,l,t),J(l,Jt,t),J(l,sl,t),J(l,st,t),J(l,Ul,t),J(l,Ut,t),p(nl,l,t),J(l,nt,t),J(l,Tl,t),J(l,Tt,t),J(l,al,t),J(l,at,t),J(l,Ml,t),J(l,Mt,t),J(l,il,t),J(l,it,t),p(pl,l,t),J(l,pt,t),J(l,ol,t),Ct=!0},p:St,i(l){Ct||(C(g.$$.fragment,l),C(Q.$$.fragment,l),C(j.$$.fragment,l),C(m.$$.fragment,l),C(u.$$.fragment,l),C(E.$$.fragment,l),C(d.$$.fragment,l),C(k.$$.fragment,l),C(O.$$.fragment,l),C(N.$$.fragment,l),C(G.$$.fragment,l),C(_.$$.fragment,l),C(z.$$.fragment,l),C(q.$$.fragment,l),C(Y.$$.fragment,l),C(H.$$.fragment,l),C(L.$$.fragment,l),C(K.$$.fragment,l),C(ll.$$.fragment,l),C(el.$$.fragment,l),C(Jl.$$.fragment,l),C(nl.$$.fragment,l),C(pl.$$.fragment,l),Ct=!0)},o(l){y(g.$$.fragment,l),y(Q.$$.fragment,l),y(j.$$.fragment,l),y(m.$$.fragment,l),y(u.$$.fragment,l),y(E.$$.fragment,l),y(d.$$.fragment,l),y(k.$$.fragment,l),y(O.$$.fragment,l),y(N.$$.fragment,l),y(G.$$.fragment,l),y(_.$$.fragment,l),y(z.$$.fragment,l),y(q.$$.fragment,l),y(Y.$$.fragment,l),y(H.$$.fragment,l),y(L.$$.fragment,l),y(K.$$.fragment,l),y(ll.$$.fragment,l),y(el.$$.fragment,l),y(Jl.$$.fragment,l),y(nl.$$.fragment,l),y(pl.$$.fragment,l),Ct=!1},d(l){l&&(e(wl),e(yl),e(Vl),e(Il),e(rl),e(gl),e(Ql),e(c),e(jl),e(ml),e(R),e(cl),e(h),e(ul),e(Rl),e(f),e(hl),e(b),e(El),e(fl),e(B),e(bl),e(dl),e(D),e(Bl),e(A),e(kl),e($),e(Dl),e(F),e(Al),e($l),e(v),e(Fl),e(Z),e(Ol),e(vl),e(x),e(Zl),e(Nl),e(S),e(xl),e(Gl),e(Sl),e(X),e(_l),e(zl),e(Xl),e(W),e(ql),e(Yl),e(I),e(Wl),e(Hl),e(P),e(Ll),e(Pl),e(r),e(Kl),e(lt),e(tl),e(tt),e(et),e(Jt),e(sl),e(st),e(Ul),e(Ut),e(nt),e(Tl),e(Tt),e(al),e(at),e(Ml),e(Mt),e(il),e(it),e(pt),e(ol)),e(V),o(g,l),o(Q,l),o(j,l),o(m,l),o(u,l),o(E,l),o(d,l),o(k,l),o(O,l),o(N,l),o(G,l),o(_,l),o(z,l),o(q,l),o(Y,l),o(H,l),o(L,l),o(K,l),o(ll,l),o(el,l),o(Jl,l),o(nl,l),o(pl,l)}}}const Kt='{"title":"Agentic RAG","local":"agentic-rag","sections":[{"title":"RAG(검색 증강 생성) 소개","local":"introduction-to-retrieval-augmented-generation-rag","sections":[{"title":"RAG를 사용하는 이유","local":"why-use-rag","sections":[],"depth":3},{"title":"전통적인 RAG의 한계","local":"limitations-of-traditional-rag","sections":[],"depth":3}],"depth":2},{"title":"Agentic RAG: 더 강력한 접근 방식","local":"agentic-rag-a-more-powerful-approach","sections":[{"title":"Agentic RAG의 주요 장점","local":"key-benefits-of-agentic-rag","sections":[],"depth":3}],"depth":2},{"title":"Agentic RAG 시스템 구축하기","local":"building-an-agentic-rag-system","sections":[{"title":"1단계: 필요한 의존성 설치하기","local":"step-1-install-required-dependencies","sections":[],"depth":3},{"title":"2단계: 지식 베이스 준비하기","local":"step-2-prepare-the-knowledge-base","sections":[],"depth":3},{"title":"3단계: 검색 도구 만들기","local":"step-3-create-a-retriever-tool","sections":[],"depth":3},{"title":"4단계: 고급 검색 에이전트 만들기","local":"step-4-create-an-advanced-retrieval-agent","sections":[],"depth":3},{"title":"5단계: 에이전트를 실행하여 질문에 답하기","local":"step-5-run-the-agent-to-answer-questions","sections":[],"depth":3}],"depth":2},{"title":"Agentic RAG의 실제 적용 사례","local":"practical-applications-of-agentic-rag","sections":[],"depth":2},{"title":"결론","local":"conclusion","sections":[],"depth":2}],"depth":1}';function le(ot){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ne extends zt{constructor(V){super(),Xt(this,V,le,Pt,Gt,{})}}export{ne as component};
