import{s as ml,a as pl,n as ul,o as bl}from"../chunks/scheduler.00b97157.js";import{S as dl,i as rl,e as a,s as n,c as M,h as cl,a as i,d as l,b as o,f as Ml,g as m,j as p,k as Tt,l as hl,m as s,n as u,t as b,o as d,p as r}from"../chunks/index.a7c1a7a1.js";import{C as fl,H as ht,E as yl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.57b00158.js";import{C as c}from"../chunks/CodeBlock.26f0cff9.js";import{D as Tl}from"../chunks/DocNotebookDropdown.be7b60e3.js";function wl(ve){let h,Ut,wt,Jt,T,Ct,w,jt,g,vt,U,_e="在这里，我们将学习高级工具的使用。",_t,f,Ie='<p>如果你是构建 agent 的新手，请确保先阅读 <a href="../conceptual_guides/intro_agents">agent 介绍</a> 和 <a href="../guided_tour">smolagents 导览</a>。</p>',It,J,$e='<li><a href="#%E5%B7%A5%E5%85%B7">工具</a> <ul><li><a href="#%E4%BB%80%E4%B9%88%E6%98%AF%E5%B7%A5%E5%85%B7%E5%A6%82%E4%BD%95%E6%9E%84%E5%BB%BA%E4%B8%80%E4%B8%AA%E5%B7%A5%E5%85%B7">什么是工具，如何构建一个工具？</a></li> <li><a href="#%E5%B0%86%E4%BD%A0%E7%9A%84%E5%B7%A5%E5%85%B7%E5%88%86%E4%BA%AB%E5%88%B0-hub">将你的工具分享到 Hub</a></li> <li><a href="#%E5%B0%86-space-%E5%AF%BC%E5%85%A5%E4%B8%BA%E5%B7%A5%E5%85%B7">将 Space 导入为工具</a></li> <li><a href="#%E4%BD%BF%E7%94%A8-langchain-%E5%B7%A5%E5%85%B7">使用 LangChain 工具</a></li> <li><a href="#%E7%AE%A1%E7%90%86%E4%BD%A0%E7%9A%84-agent-%E5%B7%A5%E5%85%B7%E7%AE%B1">管理你的 agent 工具箱</a></li> <li><a href="#%E4%BD%BF%E7%94%A8%E5%B7%A5%E5%85%B7%E9%9B%86%E5%90%88">使用工具集合</a></li></ul></li>',$t,C,Zt,j,Ze="工具主要是 LLM 可以在 agent 系统中使用的函数。",Bt,v,Be="但要使用它，LLM 需要被提供一个 API：名称、工具描述、输入类型和描述、输出类型。",Et,_,Ee="所以它不能仅仅是一个函数。它应该是一个类。",xt,I,xe="因此，核心上，工具是一个类，它包装了一个函数，并带有帮助 LLM 理解如何使用它的元数据。",Ht,$,He="以下是它的结构：",Gt,Z,kt,B,Ge='自定义工具继承 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool">Tool</a> 以继承有用的方法。子类还定义了：',Wt,E,ke='<li>一个属性 <code>name</code>，对应于工具本身的名称。名称通常描述工具的功能。由于代码返回任务中下载量最多的模型，我们将其命名为 <code>model_download_counter</code>。</li> <li>一个属性 <code>description</code>，用于填充 agent 的系统提示。</li> <li>一个 <code>inputs</code> 属性，它是一个带有键 <code>&quot;type&quot;</code> 和 <code>&quot;description&quot;</code> 的字典。它包含帮助 Python 解释器对输入做出明智选择的信息。</li> <li>一个 <code>output_type</code> 属性，指定输出类型。<code>inputs</code> 和 <code>output_type</code> 的类型应为 <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic 格式</a>，它们可以是以下之一：<code>[&quot;string&quot;, &quot;boolean&quot;,&quot;integer&quot;, &quot;number&quot;, &quot;image&quot;, &quot;audio&quot;, &quot;array&quot;, &quot;object&quot;, &quot;any&quot;, &quot;null&quot;]</code>。</li> <li>一个 <code>forward</code> 方法，包含要执行的推理代码。</li>',Rt,x,We="这就是它在 agent 中使用所需的全部内容！",Vt,H,Re='还有另一种构建工具的方法。在 <a href="../guided_tour">guided_tour</a> 中，我们使用 <code>@tool</code> 装饰器实现了一个工具。<a href="/docs/smolagents/main/zh/reference/tools#smolagents.tool">tool()</a> 装饰器是定义简单工具的推荐方式，但有时你需要更多：在类中使用多个方法以获得更清晰的代码，或使用额外的类属性。',Qt,G,Ve='在这种情况下，你可以通过如上所述继承 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool">Tool</a> 来构建你的工具。',qt,k,At,W,Qe='你可以通过调用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> 将你的自定义工具分享到 Hub。确保你已经在 Hub 上为其创建了一个仓库，并且使用的是具有读取权限的 token。',Nt,R,St,V,qe="为了使推送到 Hub 正常工作，你的工具需要遵守一些规则：",Lt,Q,Ae='<li>所有方法都是自包含的，例如使用来自其参数中的变量。</li> <li>根据上述要点，<strong>所有导入应直接在工具的函数中定义</strong>，否则在尝试使用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.save">save()</a> 或 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> 调用你的自定义工具时会出现错误。</li> <li>如果你继承了 <code>__init__</code> 方法，除了 <code>self</code> 之外，你不能给它任何其他参数。这是因为在特定工具实例初始化期间设置的参数很难跟踪，这阻碍了将它们正确分享到 Hub。无论如何，创建特定类的想法是你已经可以为任何需要硬编码的内容设置类属性（只需在 <code>class YourTool(Tool):</code> 行下直接设置 <code>your_variable=(...)</code>）。当然，你仍然可以通过将内容分配给 <code>self.your_variable</code> 在代码中的任何地方创建类属性。</li>',Ft,q,Ne='一旦你的工具被推送到 Hub，你就可以查看它。<a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">这里</a> 是我推送的 <code>model_downloads_tool</code>。它有一个漂亮的 gradio 界面。',zt,A,Se='在深入工具文件时，你可以发现所有工具的逻辑都在 <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a> 下。这是你可以检查其他人分享的工具的地方。',Xt,N,Le=`然后你可以使用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.load_tool">load_tool()</a> 加载工具或使用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.from_hub">from_hub()</a> 创建它，并将其传递给 agent 中的 <code>tools</code> 参数。
由于运行工具意味着运行自定义代码，你需要确保你信任该仓库，因此我们需要传递 <code>trust_remote_code=True</code> 来从 Hub 加载工具。`,Yt,S,Pt,L,Dt,F,Fe='你可以使用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> 方法直接从 Hub 导入一个 Space 作为工具！',Kt,z,ze='你只需要提供 Hub 上 Space 的 id、它的名称和一个帮助你的 agent 理解工具功能的描述。在底层，这将使用 <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> 库来调用 Space。',Ot,X,Xe='例如，让我们从 Hub 导入 <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space 并使用它生成一张图片。',te,Y,ee,P,Ye="瞧，这是你的图片！🏖️",le,ft,Pe,se,D,De="然后你可以像使用任何其他工具一样使用这个工具。例如，让我们改进提示 <code>A rabbit wearing a space suit</code> 并生成它的图片。",ne,K,oe,O,ae,yt,Ke,ie,tt,Oe="这得有多酷？🤩",pe,et,Me,lt,tl=`我们喜欢 Langchain，并认为它有一套非常吸引人的工具。
要从 LangChain 导入工具，请使用 <code>from_langchain()</code> 方法。`,me,st,el=`以下是如何使用它来重现介绍中的搜索结果，使用 LangChain 的 web 搜索工具。
这个工具需要 <code>pip install langchain google-search-results -q</code> 才能正常工作。`,ue,nt,be,ot,de,at,ll="你可以通过添加或替换工具来管理 agent 的工具箱。",re,it,sl="让我们将 <code>model_download_tool</code> 添加到一个仅使用默认工具箱初始化的现有 agent 中。",ce,pt,he,Mt,nl="现在我们可以利用新工具：",fe,mt,ye,y,ol="<p>注意不要向 agent 添加太多工具：这可能会让较弱的 LLM 引擎不堪重负。</p>",Te,ut,we,bt,al=`你可以通过使用 ToolCollection 对象来利用工具集合，使用你想要使用的集合的 slug。
然后将它们作为列表传递给 agent 初始化，并开始使用它们！`,ge,dt,Ue,rt,il="为了加快启动速度，工具仅在 agent 调用时加载。",Je,ct,Ce,gt,je;return T=new fl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new Tl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/tools.ipynb"}]}}),g=new ht({props:{title:"工具",local:"工具",headingTag:"h1"}}),C=new ht({props:{title:"什么是工具，如何构建一个工具？",local:"什么是工具如何构建一个工具",headingTag:"h3"}}),Z=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),k=new ht({props:{title:"将你的工具分享到 Hub",local:"将你的工具分享到-hub",headingTag:"h3"}}),R=new c({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),S=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),L=new ht({props:{title:"将 Space 导入为工具",local:"将-space-导入为工具",headingTag:"h3"}}),Y=new c({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),K=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjMtTmV4dC04MEItQTNCLVRoaW5raW5nJTIyKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IndXNlcl9wcm9tcHQnJTNBJTIwJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen3-Next-80B-A3B-Thinking&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),O=new c({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),et=new ht({props:{title:"使用 LangChain 工具",local:"使用-langchain-工具",headingTag:"h3"}}),nt=new c({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),ot=new ht({props:{title:"管理你的 agent 工具箱",local:"管理你的-agent-工具箱",headingTag:"h3"}}),pt=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjMtTmV4dC04MEItQTNCLVRoaW5raW5nJTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEFhZ2VudC50b29scyU1Qm1vZGVsX2Rvd25sb2FkX3Rvb2wubmFtZSU1RCUyMCUzRCUyMG1vZGVsX2Rvd25sb2FkX3Rvb2w=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen3-Next-80B-A3B-Thinking&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),mt=new c({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),ut=new ht({props:{title:"使用工具集合",local:"使用工具集合",headingTag:"h3"}}),dt=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),ct=new yl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/zh/tutorials/tools.md"}}),{c(){h=a("meta"),Ut=n(),wt=a("p"),Jt=n(),M(T.$$.fragment),Ct=n(),M(w.$$.fragment),jt=n(),M(g.$$.fragment),vt=n(),U=a("p"),U.textContent=_e,_t=n(),f=a("blockquote"),f.innerHTML=Ie,It=n(),J=a("ul"),J.innerHTML=$e,$t=n(),M(C.$$.fragment),Zt=n(),j=a("p"),j.textContent=Ze,Bt=n(),v=a("p"),v.textContent=Be,Et=n(),_=a("p"),_.textContent=Ee,xt=n(),I=a("p"),I.textContent=xe,Ht=n(),$=a("p"),$.textContent=He,Gt=n(),M(Z.$$.fragment),kt=n(),B=a("p"),B.innerHTML=Ge,Wt=n(),E=a("ul"),E.innerHTML=ke,Rt=n(),x=a("p"),x.textContent=We,Vt=n(),H=a("p"),H.innerHTML=Re,Qt=n(),G=a("p"),G.innerHTML=Ve,qt=n(),M(k.$$.fragment),At=n(),W=a("p"),W.innerHTML=Qe,Nt=n(),M(R.$$.fragment),St=n(),V=a("p"),V.textContent=qe,Lt=n(),Q=a("ul"),Q.innerHTML=Ae,Ft=n(),q=a("p"),q.innerHTML=Ne,zt=n(),A=a("p"),A.innerHTML=Se,Xt=n(),N=a("p"),N.innerHTML=Le,Yt=n(),M(S.$$.fragment),Pt=n(),M(L.$$.fragment),Dt=n(),F=a("p"),F.innerHTML=Fe,Kt=n(),z=a("p"),z.innerHTML=ze,Ot=n(),X=a("p"),X.innerHTML=Xe,te=n(),M(Y.$$.fragment),ee=n(),P=a("p"),P.textContent=Ye,le=n(),ft=a("img"),se=n(),D=a("p"),D.innerHTML=De,ne=n(),M(K.$$.fragment),oe=n(),M(O.$$.fragment),ae=n(),yt=a("img"),ie=n(),tt=a("p"),tt.textContent=Oe,pe=n(),M(et.$$.fragment),Me=n(),lt=a("p"),lt.innerHTML=tl,me=n(),st=a("p"),st.innerHTML=el,ue=n(),M(nt.$$.fragment),be=n(),M(ot.$$.fragment),de=n(),at=a("p"),at.textContent=ll,re=n(),it=a("p"),it.innerHTML=sl,ce=n(),M(pt.$$.fragment),he=n(),Mt=a("p"),Mt.textContent=nl,fe=n(),M(mt.$$.fragment),ye=n(),y=a("blockquote"),y.innerHTML=ol,Te=n(),M(ut.$$.fragment),we=n(),bt=a("p"),bt.textContent=al,ge=n(),M(dt.$$.fragment),Ue=n(),rt=a("p"),rt.textContent=il,Je=n(),M(ct.$$.fragment),Ce=n(),gt=a("p"),this.h()},l(t){const e=cl("svelte-u9bgzb",document.head);h=i(e,"META",{name:!0,content:!0}),e.forEach(l),Ut=o(t),wt=i(t,"P",{}),Ml(wt).forEach(l),Jt=o(t),m(T.$$.fragment,t),Ct=o(t),m(w.$$.fragment,t),jt=o(t),m(g.$$.fragment,t),vt=o(t),U=i(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-143y1x4"&&(U.textContent=_e),_t=o(t),f=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-13sctmd"&&(f.innerHTML=Ie),It=o(t),J=i(t,"UL",{"data-svelte-h":!0}),p(J)!=="svelte-62wtbm"&&(J.innerHTML=$e),$t=o(t),m(C.$$.fragment,t),Zt=o(t),j=i(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-tzzqok"&&(j.textContent=Ze),Bt=o(t),v=i(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-mmees0"&&(v.textContent=Be),Et=o(t),_=i(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-8tjsnw"&&(_.textContent=Ee),xt=o(t),I=i(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1marvpp"&&(I.textContent=xe),Ht=o(t),$=i(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-1ezxif7"&&($.textContent=He),Gt=o(t),m(Z.$$.fragment,t),kt=o(t),B=i(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-mjq2a7"&&(B.innerHTML=Ge),Wt=o(t),E=i(t,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-j76s85"&&(E.innerHTML=ke),Rt=o(t),x=i(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-150sce8"&&(x.textContent=We),Vt=o(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-19qr9pn"&&(H.innerHTML=Re),Qt=o(t),G=i(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1u11zff"&&(G.innerHTML=Ve),qt=o(t),m(k.$$.fragment,t),At=o(t),W=i(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1t9emcf"&&(W.innerHTML=Qe),Nt=o(t),m(R.$$.fragment,t),St=o(t),V=i(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-f7adnf"&&(V.textContent=qe),Lt=o(t),Q=i(t,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-zpe3on"&&(Q.innerHTML=Ae),Ft=o(t),q=i(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-ek1m24"&&(q.innerHTML=Ne),zt=o(t),A=i(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-15ghlir"&&(A.innerHTML=Se),Xt=o(t),N=i(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-r1pjtl"&&(N.innerHTML=Le),Yt=o(t),m(S.$$.fragment,t),Pt=o(t),m(L.$$.fragment,t),Dt=o(t),F=i(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-rbz41a"&&(F.innerHTML=Fe),Kt=o(t),z=i(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-4qew2a"&&(z.innerHTML=ze),Ot=o(t),X=i(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1tvwij"&&(X.innerHTML=Xe),te=o(t),m(Y.$$.fragment,t),ee=o(t),P=i(t,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1ubl722"&&(P.textContent=Ye),le=o(t),ft=i(t,"IMG",{src:!0}),se=o(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-ecwb7g"&&(D.innerHTML=De),ne=o(t),m(K.$$.fragment,t),oe=o(t),m(O.$$.fragment,t),ae=o(t),yt=i(t,"IMG",{src:!0}),ie=o(t),tt=i(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-frli2c"&&(tt.textContent=Oe),pe=o(t),m(et.$$.fragment,t),Me=o(t),lt=i(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-m1ii5p"&&(lt.innerHTML=tl),me=o(t),st=i(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-17sjd0f"&&(st.innerHTML=el),ue=o(t),m(nt.$$.fragment,t),be=o(t),m(ot.$$.fragment,t),de=o(t),at=i(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-p6yc33"&&(at.textContent=ll),re=o(t),it=i(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-u6gh5x"&&(it.innerHTML=sl),ce=o(t),m(pt.$$.fragment,t),he=o(t),Mt=i(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1dm2bi"&&(Mt.textContent=nl),fe=o(t),m(mt.$$.fragment,t),ye=o(t),y=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-q94bc0"&&(y.innerHTML=ol),Te=o(t),m(ut.$$.fragment,t),we=o(t),bt=i(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-17n2ifn"&&(bt.textContent=al),ge=o(t),m(dt.$$.fragment,t),Ue=o(t),rt=i(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-nvusln"&&(rt.textContent=il),Je=o(t),m(ct.$$.fragment,t),Ce=o(t),gt=i(t,"P",{}),Ml(gt).forEach(l),this.h()},h(){Tt(h,"name","hf:doc:metadata"),Tt(h,"content",gl),Tt(f,"class","tip"),pl(ft.src,Pe="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||Tt(ft,"src",Pe),pl(yt.src,Ke="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||Tt(yt,"src",Ke),Tt(y,"class","tip")},m(t,e){hl(document.head,h),s(t,Ut,e),s(t,wt,e),s(t,Jt,e),u(T,t,e),s(t,Ct,e),u(w,t,e),s(t,jt,e),u(g,t,e),s(t,vt,e),s(t,U,e),s(t,_t,e),s(t,f,e),s(t,It,e),s(t,J,e),s(t,$t,e),u(C,t,e),s(t,Zt,e),s(t,j,e),s(t,Bt,e),s(t,v,e),s(t,Et,e),s(t,_,e),s(t,xt,e),s(t,I,e),s(t,Ht,e),s(t,$,e),s(t,Gt,e),u(Z,t,e),s(t,kt,e),s(t,B,e),s(t,Wt,e),s(t,E,e),s(t,Rt,e),s(t,x,e),s(t,Vt,e),s(t,H,e),s(t,Qt,e),s(t,G,e),s(t,qt,e),u(k,t,e),s(t,At,e),s(t,W,e),s(t,Nt,e),u(R,t,e),s(t,St,e),s(t,V,e),s(t,Lt,e),s(t,Q,e),s(t,Ft,e),s(t,q,e),s(t,zt,e),s(t,A,e),s(t,Xt,e),s(t,N,e),s(t,Yt,e),u(S,t,e),s(t,Pt,e),u(L,t,e),s(t,Dt,e),s(t,F,e),s(t,Kt,e),s(t,z,e),s(t,Ot,e),s(t,X,e),s(t,te,e),u(Y,t,e),s(t,ee,e),s(t,P,e),s(t,le,e),s(t,ft,e),s(t,se,e),s(t,D,e),s(t,ne,e),u(K,t,e),s(t,oe,e),u(O,t,e),s(t,ae,e),s(t,yt,e),s(t,ie,e),s(t,tt,e),s(t,pe,e),u(et,t,e),s(t,Me,e),s(t,lt,e),s(t,me,e),s(t,st,e),s(t,ue,e),u(nt,t,e),s(t,be,e),u(ot,t,e),s(t,de,e),s(t,at,e),s(t,re,e),s(t,it,e),s(t,ce,e),u(pt,t,e),s(t,he,e),s(t,Mt,e),s(t,fe,e),u(mt,t,e),s(t,ye,e),s(t,y,e),s(t,Te,e),u(ut,t,e),s(t,we,e),s(t,bt,e),s(t,ge,e),u(dt,t,e),s(t,Ue,e),s(t,rt,e),s(t,Je,e),u(ct,t,e),s(t,Ce,e),s(t,gt,e),je=!0},p:ul,i(t){je||(b(T.$$.fragment,t),b(w.$$.fragment,t),b(g.$$.fragment,t),b(C.$$.fragment,t),b(Z.$$.fragment,t),b(k.$$.fragment,t),b(R.$$.fragment,t),b(S.$$.fragment,t),b(L.$$.fragment,t),b(Y.$$.fragment,t),b(K.$$.fragment,t),b(O.$$.fragment,t),b(et.$$.fragment,t),b(nt.$$.fragment,t),b(ot.$$.fragment,t),b(pt.$$.fragment,t),b(mt.$$.fragment,t),b(ut.$$.fragment,t),b(dt.$$.fragment,t),b(ct.$$.fragment,t),je=!0)},o(t){d(T.$$.fragment,t),d(w.$$.fragment,t),d(g.$$.fragment,t),d(C.$$.fragment,t),d(Z.$$.fragment,t),d(k.$$.fragment,t),d(R.$$.fragment,t),d(S.$$.fragment,t),d(L.$$.fragment,t),d(Y.$$.fragment,t),d(K.$$.fragment,t),d(O.$$.fragment,t),d(et.$$.fragment,t),d(nt.$$.fragment,t),d(ot.$$.fragment,t),d(pt.$$.fragment,t),d(mt.$$.fragment,t),d(ut.$$.fragment,t),d(dt.$$.fragment,t),d(ct.$$.fragment,t),je=!1},d(t){t&&(l(Ut),l(wt),l(Jt),l(Ct),l(jt),l(vt),l(U),l(_t),l(f),l(It),l(J),l($t),l(Zt),l(j),l(Bt),l(v),l(Et),l(_),l(xt),l(I),l(Ht),l($),l(Gt),l(kt),l(B),l(Wt),l(E),l(Rt),l(x),l(Vt),l(H),l(Qt),l(G),l(qt),l(At),l(W),l(Nt),l(St),l(V),l(Lt),l(Q),l(Ft),l(q),l(zt),l(A),l(Xt),l(N),l(Yt),l(Pt),l(Dt),l(F),l(Kt),l(z),l(Ot),l(X),l(te),l(ee),l(P),l(le),l(ft),l(se),l(D),l(ne),l(oe),l(ae),l(yt),l(ie),l(tt),l(pe),l(Me),l(lt),l(me),l(st),l(ue),l(be),l(de),l(at),l(re),l(it),l(ce),l(he),l(Mt),l(fe),l(ye),l(y),l(Te),l(we),l(bt),l(ge),l(Ue),l(rt),l(Je),l(Ce),l(gt)),l(h),r(T,t),r(w,t),r(g,t),r(C,t),r(Z,t),r(k,t),r(R,t),r(S,t),r(L,t),r(Y,t),r(K,t),r(O,t),r(et,t),r(nt,t),r(ot,t),r(pt,t),r(mt,t),r(ut,t),r(dt,t),r(ct,t)}}}const gl='{"title":"工具","local":"工具","sections":[{"title":"什么是工具，如何构建一个工具？","local":"什么是工具如何构建一个工具","sections":[],"depth":3},{"title":"将你的工具分享到 Hub","local":"将你的工具分享到-hub","sections":[],"depth":3},{"title":"将 Space 导入为工具","local":"将-space-导入为工具","sections":[],"depth":3},{"title":"使用 LangChain 工具","local":"使用-langchain-工具","sections":[],"depth":3},{"title":"管理你的 agent 工具箱","local":"管理你的-agent-工具箱","sections":[],"depth":3},{"title":"使用工具集合","local":"使用工具集合","sections":[],"depth":3}],"depth":1}';function Ul(ve){return bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends dl{constructor(h){super(),rl(this,h,Ul,wl,ml,{})}}export{Il as component};
