import{s as pl,f as nl,o as dl,n as ul}from"../chunks/scheduler.f6319a2a.js";import{S as hl,i as ml,g as n,s,r as p,A as cl,h as i,f as l,c as a,j as il,u as d,x as r,k as Je,y as Ml,a as o,v as h,d as m,t as c,w as M}from"../chunks/index.85aa684c.js";import{T as rl}from"../chunks/Tip.3d397a88.js";import{C as f}from"../chunks/CodeBlock.97b48fd2.js";import{D as yl}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as ft,E as bl}from"../chunks/EditOnGithub.006048dd.js";function fl(gt){let u,b='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){u=n("p"),u.innerHTML=b},l(y){u=i(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1p1d9vw"&&(u.innerHTML=b)},m(y,g){o(y,u,g)},p:ul,d(y){y&&l(u)}}}function gl(gt){let u,b="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){u=n("p"),u.textContent=b},l(y){u=i(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-h9mzfm"&&(u.textContent=b)},m(y,g){o(y,u,g)},p:ul,d(y){y&&l(u)}}}function wl(gt){let u,b,y,g,T,vt,v,Jt,J,Ce="Here, we’re going to see advanced tool usage.",Ct,w,jt,C,je='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',$t,j,_t,$,$e="A tool is mostly a function that an LLM can use in an agentic system.",It,_,_e="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Zt,I,Ie="So it cannot be only a function. It should be a class.",Ht,Z,Ze="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",Gt,H,He="Here’s how it looks:",kt,G,xt,k,Ge='The custom tool subclasses <a href="/docs/smolagents/v1.2.2/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',Bt,x,ke='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',Rt,B,xe="And that’s all it needs to be used in an agent!",Wt,R,Be='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/v1.2.2/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',Vt,W,Re='In this case, you can build your tool by subclassing <a href="/docs/smolagents/v1.2.2/en/reference/tools#smolagents.Tool">Tool</a> as described above.',Qt,V,At,Q,We='You can share your custom tool to the Hub by calling <a href="/docs/smolagents/v1.2.2/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Et,A,Lt,E,Ve="For the push to Hub to work, your tool will need to respect some rules:",Nt,L,Qe='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/v1.2.2/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/v1.2.2/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',St,N,Ae='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',Ft,S,Ee='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',qt,F,Le=`Then you can load the tool with <a href="/docs/smolagents/v1.2.2/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/v1.2.2/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,Yt,q,zt,Y,Xt,z,Ne='You can directly import a Space from the Hub as a tool using the <a href="/docs/smolagents/v1.2.2/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',Pt,X,Se='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',Dt,P,Fe='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',Kt,D,Ot,K,qe="And voilà, here’s your image! 🏖️",te,wt,Ye,ee,O,ze="Then you can use this tool just like any other tool.  For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code> and generate an image of it.",le,tt,oe,et,se,Ut,Xe,ae,lt,Pe="How cool is this? 🤩",ne,ot,ie,st,De=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,re,at,Ke=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,ue,nt,pe,it,de,rt,Oe="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",he,ut,tl="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",me,pt,ce,dt,el="Now we can leverage the new tool:",Me,ht,ye,U,be,mt,fe,ct,ll=`You can leverage tool collections by using the ToolCollection object, with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,ge,Mt,we,yt,ol="To speed up the start, tools are loaded only if called by the agent.",Ue,bt,Te,Tt,ve;return T=new ft({props:{title:"Tools",local:"tools",headingTag:"h1"}}),v=new yl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),w=new rl({props:{warning:!1,$$slots:{default:[fl]},$$scope:{ctx:gt}}}),j=new ft({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),G=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),V=new ft({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),A=new f({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),q=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Y=new ft({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),D=new f({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),tt=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTIwcHJvbXB0JTNEJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, prompt=<span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>
)`,wrap:!1}}),et=new f({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),ot=new ft({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),nt=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),it=new ft({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),pt=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBYWdlbnQudG9vbHMlNUJtb2RlbF9kb3dubG9hZF90b29sLm5hbWUlNUQlMjAlM0QlMjBtb2RlbF9kb3dubG9hZF90b29s",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),ht=new f({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),U=new rl({props:{warning:!1,$$slots:{default:[gl]},$$scope:{ctx:gt}}}),mt=new ft({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),Mt=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),bt=new bl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){u=n("meta"),b=s(),y=n("p"),g=s(),p(T.$$.fragment),vt=s(),p(v.$$.fragment),Jt=s(),J=n("p"),J.textContent=Ce,Ct=s(),p(w.$$.fragment),jt=s(),C=n("ul"),C.innerHTML=je,$t=s(),p(j.$$.fragment),_t=s(),$=n("p"),$.textContent=$e,It=s(),_=n("p"),_.textContent=_e,Zt=s(),I=n("p"),I.textContent=Ie,Ht=s(),Z=n("p"),Z.textContent=Ze,Gt=s(),H=n("p"),H.textContent=He,kt=s(),p(G.$$.fragment),xt=s(),k=n("p"),k.innerHTML=Ge,Bt=s(),x=n("ul"),x.innerHTML=ke,Rt=s(),B=n("p"),B.textContent=xe,Wt=s(),R=n("p"),R.innerHTML=Be,Vt=s(),W=n("p"),W.innerHTML=Re,Qt=s(),p(V.$$.fragment),At=s(),Q=n("p"),Q.innerHTML=We,Et=s(),p(A.$$.fragment),Lt=s(),E=n("p"),E.textContent=Ve,Nt=s(),L=n("ul"),L.innerHTML=Qe,St=s(),N=n("p"),N.innerHTML=Ae,Ft=s(),S=n("p"),S.innerHTML=Ee,qt=s(),F=n("p"),F.innerHTML=Le,Yt=s(),p(q.$$.fragment),zt=s(),p(Y.$$.fragment),Xt=s(),z=n("p"),z.innerHTML=Ne,Pt=s(),X=n("p"),X.innerHTML=Se,Dt=s(),P=n("p"),P.innerHTML=Fe,Kt=s(),p(D.$$.fragment),Ot=s(),K=n("p"),K.textContent=qe,te=s(),wt=n("img"),ee=s(),O=n("p"),O.innerHTML=ze,le=s(),p(tt.$$.fragment),oe=s(),p(et.$$.fragment),se=s(),Ut=n("img"),ae=s(),lt=n("p"),lt.textContent=Pe,ne=s(),p(ot.$$.fragment),ie=s(),st=n("p"),st.innerHTML=De,re=s(),at=n("p"),at.innerHTML=Ke,ue=s(),p(nt.$$.fragment),pe=s(),p(it.$$.fragment),de=s(),rt=n("p"),rt.innerHTML=Oe,he=s(),ut=n("p"),ut.innerHTML=tl,me=s(),p(pt.$$.fragment),ce=s(),dt=n("p"),dt.textContent=el,Me=s(),p(ht.$$.fragment),ye=s(),p(U.$$.fragment),be=s(),p(mt.$$.fragment),fe=s(),ct=n("p"),ct.textContent=ll,ge=s(),p(Mt.$$.fragment),we=s(),yt=n("p"),yt.textContent=ol,Ue=s(),p(bt.$$.fragment),Te=s(),Tt=n("p"),this.h()},l(t){const e=cl("svelte-u9bgzb",document.head);u=i(e,"META",{name:!0,content:!0}),e.forEach(l),b=a(t),y=i(t,"P",{}),il(y).forEach(l),g=a(t),d(T.$$.fragment,t),vt=a(t),d(v.$$.fragment,t),Jt=a(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-8951oz"&&(J.textContent=Ce),Ct=a(t),d(w.$$.fragment,t),jt=a(t),C=i(t,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-gdosxb"&&(C.innerHTML=je),$t=a(t),d(j.$$.fragment,t),_t=a(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-50z9h0"&&($.textContent=$e),It=a(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1llqfcr"&&(_.textContent=_e),Zt=a(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-eilpgu"&&(I.textContent=Ie),Ht=a(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-suz7fy"&&(Z.textContent=Ze),Gt=a(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-x18ywb"&&(H.textContent=He),kt=a(t),d(G.$$.fragment,t),xt=a(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-16kyykf"&&(k.innerHTML=Ge),Bt=a(t),x=i(t,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-xqgwuf"&&(x.innerHTML=ke),Rt=a(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-220ayw"&&(B.textContent=xe),Wt=a(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1bizqqz"&&(R.innerHTML=Be),Vt=a(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1bnrj69"&&(W.innerHTML=Re),Qt=a(t),d(V.$$.fragment,t),At=a(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16ql1jn"&&(Q.innerHTML=We),Et=a(t),d(A.$$.fragment,t),Lt=a(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-hoocvd"&&(E.textContent=Ve),Nt=a(t),L=i(t,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-12sa3x3"&&(L.innerHTML=Qe),St=a(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-4n5s3c"&&(N.innerHTML=Ae),Ft=a(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1knl8v8"&&(S.innerHTML=Ee),qt=a(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1un5trg"&&(F.innerHTML=Le),Yt=a(t),d(q.$$.fragment,t),zt=a(t),d(Y.$$.fragment,t),Xt=a(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-n2izlj"&&(z.innerHTML=Ne),Pt=a(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1xkj0c9"&&(X.innerHTML=Se),Dt=a(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1gucs20"&&(P.innerHTML=Fe),Kt=a(t),d(D.$$.fragment,t),Ot=a(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-sgspwr"&&(K.textContent=qe),te=a(t),wt=i(t,"IMG",{src:!0}),ee=a(t),O=i(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-3y2998"&&(O.innerHTML=ze),le=a(t),d(tt.$$.fragment,t),oe=a(t),d(et.$$.fragment,t),se=a(t),Ut=i(t,"IMG",{src:!0}),ae=a(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-i5dtbz"&&(lt.textContent=Pe),ne=a(t),d(ot.$$.fragment,t),ie=a(t),st=i(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1rq40pf"&&(st.innerHTML=De),re=a(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1g7jkvd"&&(at.innerHTML=Ke),ue=a(t),d(nt.$$.fragment,t),pe=a(t),d(it.$$.fragment,t),de=a(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-69p3x"&&(rt.innerHTML=Oe),he=a(t),ut=i(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-ocb8u2"&&(ut.innerHTML=tl),me=a(t),d(pt.$$.fragment,t),ce=a(t),dt=i(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-o3ledg"&&(dt.textContent=el),Me=a(t),d(ht.$$.fragment,t),ye=a(t),d(U.$$.fragment,t),be=a(t),d(mt.$$.fragment,t),fe=a(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1wn4mt5"&&(ct.textContent=ll),ge=a(t),d(Mt.$$.fragment,t),we=a(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-6r1jgt"&&(yt.textContent=ol),Ue=a(t),d(bt.$$.fragment,t),Te=a(t),Tt=i(t,"P",{}),il(Tt).forEach(l),this.h()},h(){Je(u,"name","hf:doc:metadata"),Je(u,"content",Ul),nl(wt.src,Ye="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||Je(wt,"src",Ye),nl(Ut.src,Xe="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||Je(Ut,"src",Xe)},m(t,e){Ml(document.head,u),o(t,b,e),o(t,y,e),o(t,g,e),h(T,t,e),o(t,vt,e),h(v,t,e),o(t,Jt,e),o(t,J,e),o(t,Ct,e),h(w,t,e),o(t,jt,e),o(t,C,e),o(t,$t,e),h(j,t,e),o(t,_t,e),o(t,$,e),o(t,It,e),o(t,_,e),o(t,Zt,e),o(t,I,e),o(t,Ht,e),o(t,Z,e),o(t,Gt,e),o(t,H,e),o(t,kt,e),h(G,t,e),o(t,xt,e),o(t,k,e),o(t,Bt,e),o(t,x,e),o(t,Rt,e),o(t,B,e),o(t,Wt,e),o(t,R,e),o(t,Vt,e),o(t,W,e),o(t,Qt,e),h(V,t,e),o(t,At,e),o(t,Q,e),o(t,Et,e),h(A,t,e),o(t,Lt,e),o(t,E,e),o(t,Nt,e),o(t,L,e),o(t,St,e),o(t,N,e),o(t,Ft,e),o(t,S,e),o(t,qt,e),o(t,F,e),o(t,Yt,e),h(q,t,e),o(t,zt,e),h(Y,t,e),o(t,Xt,e),o(t,z,e),o(t,Pt,e),o(t,X,e),o(t,Dt,e),o(t,P,e),o(t,Kt,e),h(D,t,e),o(t,Ot,e),o(t,K,e),o(t,te,e),o(t,wt,e),o(t,ee,e),o(t,O,e),o(t,le,e),h(tt,t,e),o(t,oe,e),h(et,t,e),o(t,se,e),o(t,Ut,e),o(t,ae,e),o(t,lt,e),o(t,ne,e),h(ot,t,e),o(t,ie,e),o(t,st,e),o(t,re,e),o(t,at,e),o(t,ue,e),h(nt,t,e),o(t,pe,e),h(it,t,e),o(t,de,e),o(t,rt,e),o(t,he,e),o(t,ut,e),o(t,me,e),h(pt,t,e),o(t,ce,e),o(t,dt,e),o(t,Me,e),h(ht,t,e),o(t,ye,e),h(U,t,e),o(t,be,e),h(mt,t,e),o(t,fe,e),o(t,ct,e),o(t,ge,e),h(Mt,t,e),o(t,we,e),o(t,yt,e),o(t,Ue,e),h(bt,t,e),o(t,Te,e),o(t,Tt,e),ve=!0},p(t,[e]){const sl={};e&2&&(sl.$$scope={dirty:e,ctx:t}),w.$set(sl);const al={};e&2&&(al.$$scope={dirty:e,ctx:t}),U.$set(al)},i(t){ve||(m(T.$$.fragment,t),m(v.$$.fragment,t),m(w.$$.fragment,t),m(j.$$.fragment,t),m(G.$$.fragment,t),m(V.$$.fragment,t),m(A.$$.fragment,t),m(q.$$.fragment,t),m(Y.$$.fragment,t),m(D.$$.fragment,t),m(tt.$$.fragment,t),m(et.$$.fragment,t),m(ot.$$.fragment,t),m(nt.$$.fragment,t),m(it.$$.fragment,t),m(pt.$$.fragment,t),m(ht.$$.fragment,t),m(U.$$.fragment,t),m(mt.$$.fragment,t),m(Mt.$$.fragment,t),m(bt.$$.fragment,t),ve=!0)},o(t){c(T.$$.fragment,t),c(v.$$.fragment,t),c(w.$$.fragment,t),c(j.$$.fragment,t),c(G.$$.fragment,t),c(V.$$.fragment,t),c(A.$$.fragment,t),c(q.$$.fragment,t),c(Y.$$.fragment,t),c(D.$$.fragment,t),c(tt.$$.fragment,t),c(et.$$.fragment,t),c(ot.$$.fragment,t),c(nt.$$.fragment,t),c(it.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(U.$$.fragment,t),c(mt.$$.fragment,t),c(Mt.$$.fragment,t),c(bt.$$.fragment,t),ve=!1},d(t){t&&(l(b),l(y),l(g),l(vt),l(Jt),l(J),l(Ct),l(jt),l(C),l($t),l(_t),l($),l(It),l(_),l(Zt),l(I),l(Ht),l(Z),l(Gt),l(H),l(kt),l(xt),l(k),l(Bt),l(x),l(Rt),l(B),l(Wt),l(R),l(Vt),l(W),l(Qt),l(At),l(Q),l(Et),l(Lt),l(E),l(Nt),l(L),l(St),l(N),l(Ft),l(S),l(qt),l(F),l(Yt),l(zt),l(Xt),l(z),l(Pt),l(X),l(Dt),l(P),l(Kt),l(Ot),l(K),l(te),l(wt),l(ee),l(O),l(le),l(oe),l(se),l(Ut),l(ae),l(lt),l(ne),l(ie),l(st),l(re),l(at),l(ue),l(pe),l(de),l(rt),l(he),l(ut),l(me),l(ce),l(dt),l(Me),l(ye),l(be),l(fe),l(ct),l(ge),l(we),l(yt),l(Ue),l(Te),l(Tt)),l(u),M(T,t),M(v,t),M(w,t),M(j,t),M(G,t),M(V,t),M(A,t),M(q,t),M(Y,t),M(D,t),M(tt,t),M(et,t),M(ot,t),M(nt,t),M(it,t),M(pt,t),M(ht,t),M(U,t),M(mt,t),M(Mt,t),M(bt,t)}}}const Ul='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[],"depth":3}],"depth":1}';function Tl(gt){return dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends hl{constructor(u){super(),ml(this,u,Tl,wl,pl,{})}}export{Il as component};
