import{s as st,n as nt,o as at}from"../chunks/scheduler.f6319a2a.js";import{S as ot,i as it,g as o,s as n,r as d,A as rt,h as i,f as l,c as a,j as lt,u as m,x as r,k as Be,y as dt,a as s,v as p,d as g,t as u,w as c}from"../chunks/index.85aa684c.js";import{C as He}from"../chunks/CodeBlock.3400fc53.js";import{D as mt}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as M,E as pt}from"../chunks/getInferenceSnippets.054af502.js";function gt(Le){let f,K,D,O,w,ee,b,Ee='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/license_to_call.png" style="max-width:700px"/>',te,y,le,T,Ge="<code>smolagents</code> is an open-source Python library designed to make it extremely easy to build and run agents using just a few lines of code.",se,x,Ve="Key features of <code>smolagents</code> include:",ne,$,Qe="✨ <strong>Simplicity</strong>: The logic for agents fits in ~thousand lines of code. We kept abstractions to their minimal shape above raw code!",ae,v,Re='🧑‍💻 <strong>First-class support for Code Agents</strong>: <a href="reference/agents#smolagents.CodeAgent"><code>CodeAgent</code></a> writes its actions in code (as opposed to “agents being used to write code”) to invoke tools or perform computations, enabling natural composability (function nesting, loops, conditionals). To make it secure, we support <a href="tutorials/secure_code_execution">executing in sandboxed environment</a> via <a href="https://e2b.dev/" rel="nofollow">E2B</a> or via Docker.',oe,j,Se='📡 <strong>Common Tool-Calling Agent Support</strong>: In addition to CodeAgents, <a href="reference/agents#smolagents.ToolCallingAgent"><code>ToolCallingAgent</code></a> supports usual JSON/text-based tool-calling for scenarios where that paradigm is preferred.',ie,C,Ne="🤗 <strong>Hub integrations</strong>: Seamlessly share and load agents and tools to/from the Hub as Gradio Spaces.",re,J,Ae='🌐 <strong>Model-agnostic</strong>: Easily integrate any large language model (LLM), whether it’s hosted on the Hub via <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference providers</a>, accessed via APIs such as OpenAI, Anthropic, or many others via LiteLLM integration, or run locally using Transformers or Ollama. Powering an agent with your preferred LLM is straightforward and flexible.',de,W,Fe='👁️ <strong>Modality-agnostic</strong>: Beyond text, agents can handle vision, video, and audio inputs, broadening the range of possible applications. Check out <a href="examples/web_browser">this tutorial</a> for vision.',me,k,Pe='🛠️ <strong>Tool-agnostic</strong>: You can use tools from any <a href="reference/tools#smolagents.ToolCollection.from_mcp">MCP server</a>, from <a href="reference/tools#smolagents.Tool.from_langchain">LangChain</a>, you can even use a <a href="reference/tools#smolagents.Tool.from_space">Hub Space</a> as a tool.',pe,U,Ye="💻 <strong>CLI Tools</strong>: Comes with command-line utilities (smolagent, webagent) for quickly running agents without writing boilerplate code.",ge,I,ue,Z,ce,_,ze="Get started with smolagents in just a few minutes! This guide will show you how to create and run your first agent.",fe,B,be,H,qe="Install smolagents with pip:",he,L,Me,E,we,G,De="Here’s a minimal example to create and run an agent:",ye,V,Te,Q,Xe="That’s it! Your agent will use Python code to solve the task and return the result.",xe,R,$e,S,Ke="Let’s make our agent more capable by adding some tools:",ve,N,je,A,Ce,F,Oe="You can use various models with your agent:",Je,P,We,Y,ke,z,et='<li>Learn how to set up smolagents with various models and tools in the <a href="installation">Installation Guide</a></li> <li>Check out the <a href="guided_tour">Guided Tour</a> for more advanced features</li> <li>Learn about <a href="tutorials/tools">building custom tools</a></li> <li>Explore <a href="tutorials/secure_code_execution">secure code execution</a></li> <li>See how to create <a href="tutorials/building_good_agents">multi-agent systems</a></li>',Ue,h,tt='<div class="w-full flex flex-col space-y-4 md:space-y-0 md:grid md:grid-cols-2 md:gap-y-4 md:gap-x-5"><a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./guided_tour"><div class="w-full text-center bg-gradient-to-br from-blue-400 to-blue-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Guided tour</div> <p class="text-gray-700">Learn the basics and become familiar with using Agents. Start here if you are using Agents for the first time!</p></a> <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./examples/text_to_sql"><div class="w-full text-center bg-gradient-to-br from-indigo-400 to-indigo-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">How-to guides</div> <p class="text-gray-700">Practical guides to help you achieve a specific goal: create an agent to generate and test SQL queries!</p></a> <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./conceptual_guides/intro_agents"><div class="w-full text-center bg-gradient-to-br from-pink-400 to-pink-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Conceptual guides</div> <p class="text-gray-700">High-level explanations for building a better understanding of important topics.</p></a> <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./tutorials/building_good_agents"><div class="w-full text-center bg-gradient-to-br from-purple-400 to-purple-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Tutorials</div> <p class="text-gray-700">Horizontal tutorials that cover important aspects of building agents.</p></a></div>',Ie,q,Ze,X,_e;return w=new M({props:{title:"smolagents",local:"smolagents",headingTag:"h1"}}),y=new M({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),I=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),Z=new mt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/index.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/index.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/index.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/index.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/index.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/index.ipynb"}]}}),B=new M({props:{title:"Installation",local:"installation",headingTag:"h3"}}),L=new He({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlNUJ0b29sa2l0JTVEJTIwJTIwJTIzJTIwSW5jbHVkZXMlMjBkZWZhdWx0JTIwdG9vbHMlMjBsaWtlJTIwd2ViJTIwc2VhcmNo",highlighted:'pip install smolagents[toolkit]  <span class="hljs-comment"># Includes default tools like web search</span>',wrap:!1}}),E=new M({props:{title:"Create Your First Agent",local:"create-your-first-agent",headingTag:"h3"}}),V=new He({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBhJTIwbW9kZWwlMjAodXNpbmclMjBIdWdnaW5nJTIwRmFjZSUyMEluZmVyZW5jZSUyMEFQSSklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCklMjAlMjAlMjMlMjBVc2VzJTIwYSUyMGRlZmF1bHQlMjBtb2RlbCUwQSUwQSUyMyUyMENyZWF0ZSUyMGFuJTIwYWdlbnQlMjB3aXRoJTIwbm8lMjB0b29scyUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBhJTIwdGFzayUwQXJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJDYWxjdWxhdGUlMjB0aGUlMjBzdW0lMjBvZiUyMG51bWJlcnMlMjBmcm9tJTIwMSUyMHRvJTIwMTAlMjIpJTBBcHJpbnQocmVzdWx0KQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-comment"># Initialize a model (using Hugging Face Inference API)</span>
model = InferenceClientModel()  <span class="hljs-comment"># Uses a default model</span>

<span class="hljs-comment"># Create an agent with no tools</span>
agent = CodeAgent(tools=[], model=model)

<span class="hljs-comment"># Run the agent with a task</span>
result = agent.run(<span class="hljs-string">&quot;Calculate the sum of numbers from 1 to 10&quot;</span>)
<span class="hljs-built_in">print</span>(result)`,wrap:!1}}),R=new M({props:{title:"Adding Tools",local:"adding-tools",headingTag:"h3"}}),N=new He({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSklMEElMEElMjMlMjBOb3clMjB0aGUlMjBhZ2VudCUyMGNhbiUyMHNlYXJjaCUyMHRoZSUyMHdlYiElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTIyV2hhdCUyMGlzJTIwdGhlJTIwY3VycmVudCUyMHdlYXRoZXIlMjBpbiUyMFBhcmlzJTNGJTIyKSUwQXByaW50KHJlc3VsdCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, DuckDuckGoSearchTool

model = InferenceClientModel()
agent = CodeAgent(
    tools=[DuckDuckGoSearchTool()],
    model=model,
)

<span class="hljs-comment"># Now the agent can search the web!</span>
result = agent.run(<span class="hljs-string">&quot;What is the current weather in Paris?&quot;</span>)
<span class="hljs-built_in">print</span>(result)`,wrap:!1}}),A=new M({props:{title:"Using Different Models",local:"using-different-models",headingTag:"h3"}}),P=new He({props:{code:"JTIzJTIwVXNpbmclMjBhJTIwc3BlY2lmaWMlMjBtb2RlbCUyMGZyb20lMjBIdWdnaW5nJTIwRmFjZSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03MGItY2hhdC1oZiUyMiklMEElMEElMjMlMjBVc2luZyUyME9wZW5BSSUyRkFudGhyb3BpYyUyMChyZXF1aXJlcyUyMHNtb2xhZ2VudHMlNUJsaXRlbGxtJTVEKSUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwTGl0ZUxMTU1vZGVsJTBBbW9kZWwlMjAlM0QlMjBMaXRlTExNTW9kZWwobW9kZWxfaWQlM0QlMjJncHQtNCUyMiklMEElMEElMjMlMjBVc2luZyUyMGxvY2FsJTIwbW9kZWxzJTIwKHJlcXVpcmVzJTIwc21vbGFnZW50cyU1QnRyYW5zZm9ybWVycyU1RCklMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMFRyYW5zZm9ybWVyc01vZGVsJTBBbW9kZWwlMjAlM0QlMjBUcmFuc2Zvcm1lcnNNb2RlbChtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWNoYXQtaGYlMjIp",highlighted:`<span class="hljs-comment"># Using a specific model from Hugging Face</span>
model = InferenceClientModel(model_id=<span class="hljs-string">&quot;meta-llama/Llama-2-70b-chat-hf&quot;</span>)

<span class="hljs-comment"># Using OpenAI/Anthropic (requires smolagents[litellm])</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> LiteLLMModel
model = LiteLLMModel(model_id=<span class="hljs-string">&quot;gpt-4&quot;</span>)

<span class="hljs-comment"># Using local models (requires smolagents[transformers])</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> TransformersModel
model = TransformersModel(model_id=<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)`,wrap:!1}}),Y=new M({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),q=new pt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/index.md"}}),{c(){f=o("meta"),K=n(),D=o("p"),O=n(),d(w.$$.fragment),ee=n(),b=o("div"),b.innerHTML=Ee,te=n(),d(y.$$.fragment),le=n(),T=o("p"),T.innerHTML=Ge,se=n(),x=o("p"),x.innerHTML=Ve,ne=n(),$=o("p"),$.innerHTML=Qe,ae=n(),v=o("p"),v.innerHTML=Re,oe=n(),j=o("p"),j.innerHTML=Se,ie=n(),C=o("p"),C.innerHTML=Ne,re=n(),J=o("p"),J.innerHTML=Ae,de=n(),W=o("p"),W.innerHTML=Fe,me=n(),k=o("p"),k.innerHTML=Pe,pe=n(),U=o("p"),U.innerHTML=Ye,ge=n(),d(I.$$.fragment),ue=n(),d(Z.$$.fragment),ce=n(),_=o("p"),_.textContent=ze,fe=n(),d(B.$$.fragment),be=n(),H=o("p"),H.textContent=qe,he=n(),d(L.$$.fragment),Me=n(),d(E.$$.fragment),we=n(),G=o("p"),G.textContent=De,ye=n(),d(V.$$.fragment),Te=n(),Q=o("p"),Q.textContent=Xe,xe=n(),d(R.$$.fragment),$e=n(),S=o("p"),S.textContent=Ke,ve=n(),d(N.$$.fragment),je=n(),d(A.$$.fragment),Ce=n(),F=o("p"),F.textContent=Oe,Je=n(),d(P.$$.fragment),We=n(),d(Y.$$.fragment),ke=n(),z=o("ul"),z.innerHTML=et,Ue=n(),h=o("div"),h.innerHTML=tt,Ie=n(),d(q.$$.fragment),Ze=n(),X=o("p"),this.h()},l(e){const t=rt("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(l),K=a(e),D=i(e,"P",{}),lt(D).forEach(l),O=a(e),m(w.$$.fragment,e),ee=a(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-179djvt"&&(b.innerHTML=Ee),te=a(e),m(y.$$.fragment,e),le=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-jhl2ln"&&(T.innerHTML=Ge),se=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1pqihaz"&&(x.innerHTML=Ve),ne=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1mb244l"&&($.innerHTML=Qe),ae=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-j73xkp"&&(v.innerHTML=Re),oe=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-yoh19t"&&(j.innerHTML=Se),ie=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1lg6pu7"&&(C.innerHTML=Ne),re=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1qzseh1"&&(J.innerHTML=Ae),de=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1rmitxe"&&(W.innerHTML=Fe),me=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-a167ry"&&(k.innerHTML=Pe),pe=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-s12dt5"&&(U.innerHTML=Ye),ge=a(e),m(I.$$.fragment,e),ue=a(e),m(Z.$$.fragment,e),ce=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1e03v1f"&&(_.textContent=ze),fe=a(e),m(B.$$.fragment,e),be=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-edafpj"&&(H.textContent=qe),he=a(e),m(L.$$.fragment,e),Me=a(e),m(E.$$.fragment,e),we=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-d4prih"&&(G.textContent=De),ye=a(e),m(V.$$.fragment,e),Te=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1ys1s7w"&&(Q.textContent=Xe),xe=a(e),m(R.$$.fragment,e),$e=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-10xh9zq"&&(S.textContent=Ke),ve=a(e),m(N.$$.fragment,e),je=a(e),m(A.$$.fragment,e),Ce=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-198akbh"&&(F.textContent=Oe),Je=a(e),m(P.$$.fragment,e),We=a(e),m(Y.$$.fragment,e),ke=a(e),z=i(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1hwc194"&&(z.innerHTML=et),Ue=a(e),h=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ywybpx"&&(h.innerHTML=tt),Ie=a(e),m(q.$$.fragment,e),Ze=a(e),X=i(e,"P",{}),lt(X).forEach(l),this.h()},h(){Be(f,"name","hf:doc:metadata"),Be(f,"content",ut),Be(b,"class","flex justify-center"),Be(h,"class","mt-10")},m(e,t){dt(document.head,f),s(e,K,t),s(e,D,t),s(e,O,t),p(w,e,t),s(e,ee,t),s(e,b,t),s(e,te,t),p(y,e,t),s(e,le,t),s(e,T,t),s(e,se,t),s(e,x,t),s(e,ne,t),s(e,$,t),s(e,ae,t),s(e,v,t),s(e,oe,t),s(e,j,t),s(e,ie,t),s(e,C,t),s(e,re,t),s(e,J,t),s(e,de,t),s(e,W,t),s(e,me,t),s(e,k,t),s(e,pe,t),s(e,U,t),s(e,ge,t),p(I,e,t),s(e,ue,t),p(Z,e,t),s(e,ce,t),s(e,_,t),s(e,fe,t),p(B,e,t),s(e,be,t),s(e,H,t),s(e,he,t),p(L,e,t),s(e,Me,t),p(E,e,t),s(e,we,t),s(e,G,t),s(e,ye,t),p(V,e,t),s(e,Te,t),s(e,Q,t),s(e,xe,t),p(R,e,t),s(e,$e,t),s(e,S,t),s(e,ve,t),p(N,e,t),s(e,je,t),p(A,e,t),s(e,Ce,t),s(e,F,t),s(e,Je,t),p(P,e,t),s(e,We,t),p(Y,e,t),s(e,ke,t),s(e,z,t),s(e,Ue,t),s(e,h,t),s(e,Ie,t),p(q,e,t),s(e,Ze,t),s(e,X,t),_e=!0},p:nt,i(e){_e||(g(w.$$.fragment,e),g(y.$$.fragment,e),g(I.$$.fragment,e),g(Z.$$.fragment,e),g(B.$$.fragment,e),g(L.$$.fragment,e),g(E.$$.fragment,e),g(V.$$.fragment,e),g(R.$$.fragment,e),g(N.$$.fragment,e),g(A.$$.fragment,e),g(P.$$.fragment,e),g(Y.$$.fragment,e),g(q.$$.fragment,e),_e=!0)},o(e){u(w.$$.fragment,e),u(y.$$.fragment,e),u(I.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(L.$$.fragment,e),u(E.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(A.$$.fragment,e),u(P.$$.fragment,e),u(Y.$$.fragment,e),u(q.$$.fragment,e),_e=!1},d(e){e&&(l(K),l(D),l(O),l(ee),l(b),l(te),l(le),l(T),l(se),l(x),l(ne),l($),l(ae),l(v),l(oe),l(j),l(ie),l(C),l(re),l(J),l(de),l(W),l(me),l(k),l(pe),l(U),l(ge),l(ue),l(ce),l(_),l(fe),l(be),l(H),l(he),l(Me),l(we),l(G),l(ye),l(Te),l(Q),l(xe),l($e),l(S),l(ve),l(je),l(Ce),l(F),l(Je),l(We),l(ke),l(z),l(Ue),l(h),l(Ie),l(Ze),l(X)),l(f),c(w,e),c(y,e),c(I,e),c(Z,e),c(B,e),c(L,e),c(E,e),c(V,e),c(R,e),c(N,e),c(A,e),c(P,e),c(Y,e),c(q,e)}}}const ut='{"title":"smolagents","local":"smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Quickstart","local":"quickstart","sections":[{"title":"Installation","local":"installation","sections":[],"depth":3},{"title":"Create Your First Agent","local":"create-your-first-agent","sections":[],"depth":3},{"title":"Adding Tools","local":"adding-tools","sections":[],"depth":3},{"title":"Using Different Models","local":"using-different-models","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ct(Le){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends ot{constructor(f){super(),it(this,f,ct,gt,st,{})}}export{yt as component};
