import{s as Hn,o as Yn,n as k}from"../chunks/scheduler.f6319a2a.js";import{S as Pn,i as Dn,g as p,s as a,r as d,A as On,h as m,f as s,c as r,j as N,u as g,x as T,k as E,y,a as o,v as u,d as M,t as h,w as f}from"../chunks/index.85aa684c.js";import{T as Ct}from"../chunks/Tip.3d397a88.js";import{D as Q,E as ae}from"../chunks/ExampleCodeBlock.9dcd5494.js";import{C as U}from"../chunks/CodeBlock.3400fc53.js";import{H as L,E as Kn}from"../chunks/getInferenceSnippets.054af502.js";function el(j){let l,w=`Smolagents is an experimental API which is subject to change at any time. Results returned by the agents
can vary as the APIs or underlying models are prone to change.`;return{c(){l=p("p"),l.textContent=w},l(i){l=m(i,"P",{"data-svelte-h":!0}),T(l)!=="svelte-19v5hvw"&&(l.textContent=w)},m(i,c){o(i,l,c)},p:k,d(i){i&&s(l)}}}function tl(j){let l,w="You must have <code>transformers</code> and <code>torch</code> installed on your machine. Please run <code>pip install smolagents[transformers]</code> if it’s not the case.";return{c(){l=p("p"),l.innerHTML=w},l(i){l=m(i,"P",{"data-svelte-h":!0}),T(l)!=="svelte-1tclttn"&&(l.innerHTML=w)},m(i,c){o(i,l,c)},p:k,d(i){i&&s(l)}}}function sl(j){let l,w="You must have <code>transformers</code> and <code>torch</code> installed on your machine. Please run <code>pip install smolagents[transformers]</code> if it’s not the case.";return{c(){l=p("p"),l.innerHTML=w},l(i){l=m(i,"P",{"data-svelte-h":!0}),T(l)!=="svelte-1tclttn"&&(l.innerHTML=w)},m(i,c){o(i,l,c)},p:k,d(i){i&&s(l)}}}function nl(j){let l,w="Example:",i,c,J;return c=new U({props:{code:"ZW5naW5lJTIwJTNEJTIwVHJhbnNmb3JtZXJzTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MDAwJTJDJTBBKSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyRXhwbGFpbiUyMHF1YW50dW0lMjBtZWNoYW5pY3MlMjBpbiUyMHNpbXBsZSUyMHRlcm1zLiUyMiU3RCU1RCUwQXJlc3BvbnNlJTIwJTNEJTIwZW5naW5lKG1lc3NhZ2VzJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJFTkQlMjIlNUQpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>engine = TransformersModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    device=<span class="hljs-string">&quot;cuda&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5000</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Explain quantum mechanics in simple terms.&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>response = engine(messages, stop_sequences=[<span class="hljs-string">&quot;END&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response)
<span class="hljs-string">&quot;Quantum mechanics is the branch of physics that studies...&quot;</span>`,wrap:!1}}),{c(){l=p("p"),l.textContent=w,i=a(),d(c.$$.fragment)},l(n){l=m(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-11lpom8"&&(l.textContent=w),i=r(n),g(c.$$.fragment,n)},m(n,I){o(n,l,I),o(n,i,I),u(c,n,I),J=!0},p:k,i(n){J||(M(c.$$.fragment,n),J=!0)},o(n){h(c.$$.fragment,n),J=!1},d(n){n&&(s(l),s(i)),f(c,n)}}}function ll(j){let l,w="Example:",i,c,J;return c=new U({props:{code:"ZW5naW5lJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMm5lYml1cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyeW91cl9oZl90b2tlbl9oZXJlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDUwMDAlMkMlMEEpJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJFeHBsYWluJTIwcXVhbnR1bSUyMG1lY2hhbmljcyUyMGluJTIwc2ltcGxlJTIwdGVybXMuJTIyJTdEJTVEJTBBcmVzcG9uc2UlMjAlM0QlMjBlbmdpbmUobWVzc2FnZXMlMkMlMjBzdG9wX3NlcXVlbmNlcyUzRCU1QiUyMkVORCUyMiU1RCklMEFwcmludChyZXNwb25zZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>engine = InferenceClientModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;nebius&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;your_hf_token_here&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">5000</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Explain quantum mechanics in simple terms.&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>response = engine(messages, stop_sequences=[<span class="hljs-string">&quot;END&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response)
<span class="hljs-string">&quot;Quantum mechanics is the branch of physics that studies...&quot;</span>`,wrap:!1}}),{c(){l=p("p"),l.textContent=w,i=a(),d(c.$$.fragment)},l(n){l=m(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-11lpom8"&&(l.textContent=w),i=r(n),g(c.$$.fragment,n)},m(n,I){o(n,l,I),o(n,i,I),u(c,n,I),J=!0},p:k,i(n){J||(M(c.$$.fragment,n),J=!0)},o(n){h(c.$$.fragment,n),J=!1},d(n){n&&(s(l),s(i)),f(c,n)}}}function ol(j){let l,w="Example:",i,c,J;return c=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, WebSearchTool, LiteLLMRouterModel
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;AWS_ACCESS_KEY_ID&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;AWS_SECRET_ACCESS_KEY&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;AWS_REGION&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>llm_loadbalancer_model_list = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;model-group-1&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;litellm_params&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;gpt-4o-mini&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;api_key&quot;</span>: os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;model-group-1&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;litellm_params&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;bedrock/anthropic.claude-3-sonnet-20240229-v1:0&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;aws_access_key_id&quot;</span>: os.getenv(<span class="hljs-string">&quot;AWS_ACCESS_KEY_ID&quot;</span>),
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;aws_secret_access_key&quot;</span>: os.getenv(<span class="hljs-string">&quot;AWS_SECRET_ACCESS_KEY&quot;</span>),
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;aws_region_name&quot;</span>: os.getenv(<span class="hljs-string">&quot;AWS_REGION&quot;</span>),
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">&gt;&gt;&gt; </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LiteLLMRouterModel(
<span class="hljs-meta">... </span>   model_id=<span class="hljs-string">&quot;model-group-1&quot;</span>,
<span class="hljs-meta">... </span>   model_list=llm_loadbalancer_model_list,
<span class="hljs-meta">... </span>   client_kwargs={
<span class="hljs-meta">... </span>       <span class="hljs-string">&quot;routing_strategy&quot;</span>:<span class="hljs-string">&quot;simple-shuffle&quot;</span>
<span class="hljs-meta">... </span>   }
<span class="hljs-meta">&gt;&gt;&gt; </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = CodeAgent(tools=[WebSearchTool()], model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>agent.run(<span class="hljs-string">&quot;How many seconds would it take for a leopard at full speed to run through Pont des Arts?&quot;</span>)`,wrap:!1}}),{c(){l=p("p"),l.textContent=w,i=a(),d(c.$$.fragment)},l(n){l=m(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-11lpom8"&&(l.textContent=w),i=r(n),g(c.$$.fragment,n)},m(n,I){o(n,l,I),o(n,i,I),u(c,n,I),J=!0},p:k,i(n){J||(M(c.$$.fragment,n),J=!0)},o(n){h(c.$$.fragment,n),J=!1},d(n){n&&(s(l),s(i)),f(c,n)}}}function al(j){let l,w="Creating a model instance with default settings:",i,c,J;return c=new U({props:{code:"YmVkcm9ja19tb2RlbCUyMCUzRCUyMEFtYXpvbkJlZHJvY2tTZXJ2ZXJNb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCd1cy5hbWF6b24ubm92YS1wcm8tdjElM0EwJyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>bedrock_model = AmazonBedrockServerModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&#x27;us.amazon.nova-pro-v1:0&#x27;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){l=p("p"),l.textContent=w,i=a(),d(c.$$.fragment)},l(n){l=m(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-1368o2k"&&(l.textContent=w),i=r(n),g(c.$$.fragment,n)},m(n,I){o(n,l,I),o(n,i,I),u(c,n,I),J=!0},p:k,i(n){J||(M(c.$$.fragment,n),J=!0)},o(n){h(c.$$.fragment,n),J=!1},d(n){n&&(s(l),s(i)),f(c,n)}}}function rl(j){let l,w="Creating a model instance with a custom boto3 client:",i,c,J;return c=new U({props:{code:"aW1wb3J0JTIwYm90bzMlMEFjbGllbnQlMjAlM0QlMjBib3RvMy5jbGllbnQoJ2JlZHJvY2stcnVudGltZSclMkMlMjByZWdpb25fbmFtZSUzRCd1cy13ZXN0LTInKSUwQWJlZHJvY2tfbW9kZWwlMjAlM0QlMjBBbWF6b25CZWRyb2NrU2VydmVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QndXMuYW1hem9uLm5vdmEtcHJvLXYxJTNBMCclMkMlMEElMjAlMjAlMjAlMjBjbGllbnQlM0RjbGllbnQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> boto3
<span class="hljs-meta">&gt;&gt;&gt; </span>client = boto3.client(<span class="hljs-string">&#x27;bedrock-runtime&#x27;</span>, region_name=<span class="hljs-string">&#x27;us-west-2&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bedrock_model = AmazonBedrockServerModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&#x27;us.amazon.nova-pro-v1:0&#x27;</span>,
<span class="hljs-meta">... </span>    client=client
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){l=p("p"),l.textContent=w,i=a(),d(c.$$.fragment)},l(n){l=m(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-11isg5i"&&(l.textContent=w),i=r(n),g(c.$$.fragment,n)},m(n,I){o(n,l,I),o(n,i,I),u(c,n,I),J=!0},p:k,i(n){J||(M(c.$$.fragment,n),J=!0)},o(n){h(c.$$.fragment,n),J=!1},d(n){n&&(s(l),s(i)),f(c,n)}}}function il(j){let l,w="Creating a model instance with client_kwargs for internal client creation:",i,c,J;return c=new U({props:{code:"YmVkcm9ja19tb2RlbCUyMCUzRCUyMEFtYXpvbkJlZHJvY2tTZXJ2ZXJNb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCd1cy5hbWF6b24ubm92YS1wcm8tdjElM0EwJyUyQyUwQSUyMCUyMCUyMCUyMGNsaWVudF9rd2FyZ3MlM0QlN0IncmVnaW9uX25hbWUnJTNBJTIwJ3VzLXdlc3QtMiclMkMlMjAnZW5kcG9pbnRfdXJsJyUzQSUyMCdodHRwcyUzQSUyRiUyRmN1c3RvbS1lbmRwb2ludC5jb20nJTdEJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>bedrock_model = AmazonBedrockServerModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&#x27;us.amazon.nova-pro-v1:0&#x27;</span>,
<span class="hljs-meta">... </span>    client_kwargs={<span class="hljs-string">&#x27;region_name&#x27;</span>: <span class="hljs-string">&#x27;us-west-2&#x27;</span>, <span class="hljs-string">&#x27;endpoint_url&#x27;</span>: <span class="hljs-string">&#x27;https://custom-endpoint.com&#x27;</span>}
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){l=p("p"),l.textContent=w,i=a(),d(c.$$.fragment)},l(n){l=m(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-1s85quz"&&(l.textContent=w),i=r(n),g(c.$$.fragment,n)},m(n,I){o(n,l,I),o(n,i,I),u(c,n,I),J=!0},p:k,i(n){J||(M(c.$$.fragment,n),J=!0)},o(n){h(c.$$.fragment,n),J=!1},d(n){n&&(s(l),s(i)),f(c,n)}}}function cl(j){let l,w="Creating a model instance with inference and guardrail configurations:",i,c,J;return c=new U({props:{code:"YWRkaXRpb25hbF9hcGlfY29uZmlnJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5mZXJlbmNlQ29uZmlnJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4VG9rZW5zJTIyJTNBJTIwMzAwMCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1YXJkcmFpbENvbmZpZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmd1YXJkcmFpbElkZW50aWZpZXIlMjIlM0ElMjAlMjJpZGVudGlmeTElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJndWFyZHJhaWxWZXJzaW9uJTIyJTNBJTIwJ3YxJyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU3RCUwQWJlZHJvY2tfbW9kZWwlMjAlM0QlMjBBbWF6b25CZWRyb2NrU2VydmVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QnYW50aHJvcGljLmNsYXVkZS0zLWhhaWt1LTIwMjQwMzA3LXYxJTNBMCclMkMlMEElMjAlMjAlMjAlMjAqKmFkZGl0aW9uYWxfYXBpX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>additional_api_config = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;inferenceConfig&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;maxTokens&quot;</span>: <span class="hljs-number">3000</span>
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;guardrailConfig&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;guardrailIdentifier&quot;</span>: <span class="hljs-string">&quot;identify1&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;guardrailVersion&quot;</span>: <span class="hljs-string">&#x27;v1&#x27;</span>
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>bedrock_model = AmazonBedrockServerModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&#x27;anthropic.claude-3-haiku-20240307-v1:0&#x27;</span>,
<span class="hljs-meta">... </span>    **additional_api_config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){l=p("p"),l.textContent=w,i=a(),d(c.$$.fragment)},l(n){l=m(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-4kd7m4"&&(l.textContent=w),i=r(n),g(c.$$.fragment,n)},m(n,I){o(n,l,I),o(n,i,I),u(c,n,I),J=!0},p:k,i(n){J||(M(c.$$.fragment,n),J=!0)},o(n){h(c.$$.fragment,n),J=!1},d(n){n&&(s(l),s(i)),f(c,n)}}}function pl(j){let l,w="You must have <code>mlx-lm</code> installed on your machine. Please run <code>pip install smolagents[mlx-lm]</code> if it’s not the case.";return{c(){l=p("p"),l.innerHTML=w},l(i){l=m(i,"P",{"data-svelte-h":!0}),T(l)!=="svelte-g382or"&&(l.innerHTML=w)},m(i,c){o(i,l,c)},p:k,d(i){i&&s(l)}}}function ml(j){let l,w="You must have <code>mlx-lm</code> installed on your machine. Please run <code>pip install smolagents[mlx-lm]</code> if it’s not the case.";return{c(){l=p("p"),l.innerHTML=w},l(i){l=m(i,"P",{"data-svelte-h":!0}),T(l)!=="svelte-g382or"&&(l.innerHTML=w)},m(i,c){o(i,l,c)},p:k,d(i){i&&s(l)}}}function dl(j){let l,w="Example:",i,c,J;return c=new U({props:{code:"ZW5naW5lJTIwJTNEJTIwTUxYTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJtbHgtY29tbXVuaXR5JTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QtNGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDAwMCUyQyUwQSklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkV4cGxhaW4lMjBxdWFudHVtJTIwbWVjaGFuaWNzJTIwaW4lMjBzaW1wbGUlMjB0ZXJtcy4lMjIlMEElMjAlMjAlMjAlMjAlN0QlMEElNUQlMEFyZXNwb25zZSUyMCUzRCUyMGVuZ2luZShtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTIyRU5EJTIyJTVEKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>engine = MLXModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&quot;mlx-community/Qwen2.5-Coder-32B-Instruct-4bit&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">10000</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Explain quantum mechanics in simple terms.&quot;</span>
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response = engine(messages, stop_sequences=[<span class="hljs-string">&quot;END&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response)
<span class="hljs-string">&quot;Quantum mechanics is the branch of physics that studies...&quot;</span>`,wrap:!1}}),{c(){l=p("p"),l.textContent=w,i=a(),d(c.$$.fragment)},l(n){l=m(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-11lpom8"&&(l.textContent=w),i=r(n),g(c.$$.fragment,n)},m(n,I){o(n,l,I),o(n,i,I),u(c,n,I),J=!0},p:k,i(n){J||(M(c.$$.fragment,n),J=!0)},o(n){h(c.$$.fragment,n),J=!1},d(n){n&&(s(l),s(i)),f(c,n)}}}function gl(j){let l,w="You must have <code>vllm</code> installed on your machine. Please run <code>pip install smolagents[vllm]</code> if it’s not the case.";return{c(){l=p("p"),l.innerHTML=w},l(i){l=m(i,"P",{"data-svelte-h":!0}),T(l)!=="svelte-1r5rtu3"&&(l.innerHTML=w)},m(i,c){o(i,l,c)},p:k,d(i){i&&s(l)}}}function ul(j){let l,w,i,c,J,n,I,xt,re,pn=`To learn more about agents and tools make sure to read the <a href="../index">introductory guide</a>. This page
contains the API docs for the underlying classes.`,At,ie,qt,ce,Nt,pe,mn="You’re free to create and use your own models to power your agent.",Et,me,dn=`You could subclass the base <code>Model</code> class to create a model for your agent.
The main criteria is to subclass the <code>generate</code> method, with these two criteria:`,Lt,de,gn='<li>It follows the <a href="./chat_templating">messages format</a> (<code>List[Dict[str, str]]</code>) for its input <code>messages</code>, and it returns an object with a <code>.content</code> attribute.</li> <li>It stops generating outputs at the sequences passed in the argument <code>stop_sequences</code>.</li>',Bt,ge,un=`For defining your LLM, you can make a <code>CustomModel</code> class that inherits from the base <code>Model</code> class.
It should have a generate method that takes a list of <a href="./chat_templating">messages</a> and returns an object with a .content attribute containing the text. The <code>generate</code> method also needs to accept a <code>stop_sequences</code> argument that indicates when to stop generating.`,Wt,ue,Zt,Me,Mn='Additionally, <code>generate</code> can also take a <code>grammar</code> argument. In the case where you specify a <code>grammar</code> upon agent initialization, this argument will be passed to the calls to model, with the <code>grammar</code> that you defined upon initialization, to allow <a href="https://huggingface.co/docs/text-generation-inference/conceptual/guidance" rel="nofollow">constrained generation</a> in order to force properly-formatted agent outputs.',Qt,he,Vt,fe,hn="For convenience, we have added a <code>TransformersModel</code> that implements the points above by building a local <code>transformers</code> pipeline for the model_id given at initialization.",St,ye,Rt,Te,zt,X,Xt,v,Je,Ns,dt,fn="A class that uses Hugging Face’s Transformers library for language model interaction.",Es,gt,yn="This model allows you to load and use Hugging Face’s models locally using the Transformers library. It supports features like stop sequences and grammar customization.",Ls,F,Bs,G,Ft,we,Gt,Ie,Tn='The <code>InferenceClientModel</code> wraps huggingface_hub’s <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/inference" rel="nofollow">InferenceClient</a> for the execution of the LLM. It supports all <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a> available on the Hub: Cerebras, Cohere, Fal, Fireworks, HF-Inference, Hyperbolic, Nebius, Novita, Replicate, SambaNova, Together, and more.',Ht,je,Jn="You can also set a rate limit in requests per minute by using the <code>requests_per_minute</code> argument.",Yt,be,Pt,Ue,Dt,_,$e,Ws,ut,wn="A class to interact with Hugging Face’s Inference Providers for language model interaction.",Zs,Mt,In="This model allows you to communicate with Hugging Face’s models using Inference Providers. It can be used in both serverless mode, with a dedicated endpoint, or even with a local URL, supporting features like stop sequences and grammar customization.",Qs,ht,jn="Providers include Cerebras, Cohere, Fal, Fireworks, HF-Inference, Hyperbolic, Nebius, Novita, Replicate, SambaNova, Together, and more.",Vs,H,Ss,Y,_e,Rs,ft,bn="Create the Hugging Face client.",Ot,ve,Kt,Ce,Un=`The <code>LiteLLMModel</code> leverages <a href="https://www.litellm.ai/" rel="nofollow">LiteLLM</a> to support 100+ LLMs from various providers.
You can pass kwargs upon model initialization that will then be used whenever using the model, for instance below we pass <code>temperature</code>. You can also set a rate limit in requests per minute by using the <code>requests_per_minute</code> argument.`,es,ke,ts,B,xe,zs,yt,$n='Model to use <a href="https://docs.litellm.ai/docs/#litellm-python-sdk" rel="nofollow">LiteLLM Python SDK</a> to access hundreds of LLMs.',Xs,P,Ae,Fs,Tt,_n="Create the LiteLLM client.",ss,qe,ns,Ne,vn=`The <code>LiteLLMRouterModel</code> is a wrapper around the <a href="https://docs.litellm.ai/docs/routing" rel="nofollow">LiteLLM Router</a> that leverages
advanced routing strategies: load-balancing across multiple deployments, prioritizing critical requests via queueing,
and implementing basic reliability measures such as cooldowns, fallbacks, and exponential backoff retries.`,ls,Ee,os,x,Le,Gs,Jt,Cn='Router‑based client for interacting with the <a href="https://docs.litellm.ai/docs/routing" rel="nofollow">LiteLLM Python SDK Router</a>.',Hs,wt,kn=`This class provides a high-level interface for distributing requests among multiple language models using
the LiteLLM SDK’s routing capabilities. It is responsible for initializing and configuring the router client,
applying custom role conversions, and managing message formatting to ensure seamless integration with various LLMs.`,Ys,D,as,Be,rs,We,xn=`This class lets you call any OpenAIServer compatible model.
Here’s how you can set it (you can customise the <code>api_base</code> url to point to another server):`,is,Ze,cs,V,Qe,Ps,It,An="This model connects to an OpenAI-compatible API server.",ps,Ve,ms,Se,qn="<code>AzureOpenAIServerModel</code> allows you to connect to any Azure OpenAI deployment.",ds,Re,Nn="Below you can find an example of how to set it up, note that you can omit the <code>azure_endpoint</code>, <code>api_key</code>, and <code>api_version</code> arguments, provided you’ve set the corresponding environment variables — <code>AZURE_OPENAI_ENDPOINT</code>, <code>AZURE_OPENAI_API_KEY</code>, and <code>OPENAI_API_VERSION</code>.",gs,ze,En='Pay attention to the lack of an <code>AZURE_</code> prefix for <code>OPENAI_API_VERSION</code>, this is due to the way the underlying <a href="https://github.com/openai/openai-python" rel="nofollow">openai</a> package is designed.',us,Xe,Ms,S,Fe,Ds,jt,Ln="This model connects to an Azure OpenAI deployment.",hs,Ge,fs,He,Bn="<code>AmazonBedrockServerModel</code> helps you connect to Amazon Bedrock and run your agent with any available models.",ys,Ye,Wn="Below is an example setup. This class also offers additional options for customization.",Ts,Pe,Js,b,De,Os,bt,Zn="A model class for interacting with Amazon Bedrock Server models through the Bedrock API.",Ks,Ut,Qn=`This class provides an interface to interact with various Bedrock language models,
allowing for customized model inference, guardrail configuration, message handling,
and other parameters allowed by boto3 API.`,en,$t,Vn="Examples:",tn,O,sn,K,nn,ee,ln,te,ws,Oe,Is,Ke,js,et,bs,se,Us,A,tt,on,_t,Sn="A class to interact with models loaded using MLX on Apple silicon.",an,ne,rn,le,$s,st,_s,nt,Rn='Model to use <a href="https://docs.vllm.ai/" rel="nofollow">vLLM</a> for fast LLM inference and serving.',vs,lt,Cs,oe,ks,R,ot,cn,vt,zn='Model to use <a href="https://docs.vllm.ai/" rel="nofollow">vLLM</a> for fast LLM inference and serving.',xs,at,As,kt,qs;return J=new L({props:{title:"Models",local:"models",headingTag:"h1"}}),I=new Ct({props:{warning:!0,$$slots:{default:[el]},$$scope:{ctx:j}}}),ie=new L({props:{title:"Models",local:"models",headingTag:"h2"}}),ce=new L({props:{title:"Your custom Model",local:"your-custom-model",headingTag:"h3"}}),ue=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTJDJTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBbG9naW4oJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4zLTcwQi1JbnN0cnVjdCUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRG1vZGVsX2lkKSUwQSUwQWNsYXNzJTIwQ3VzdG9tTW9kZWwoTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZ2VuZXJhdGUobWVzc2FnZXMlMkMlMjBzdG9wX3NlcXVlbmNlcyUzRCU1QiUyMlRhc2slMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQuY2hhdF9jb21wbGV0aW9uKG1lc3NhZ2VzJTJDJTIwc3RvcCUzRHN0b3Bfc2VxdWVuY2VzJTJDJTIwbWF4X3Rva2VucyUzRDEwMjQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYW5zd2VyJTIwJTNEJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGFuc3dlciUwQSUwQWN1c3RvbV9tb2RlbCUyMCUzRCUyMEN1c3RvbU1vZGVsKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login, InferenceClient

login(<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

client = InferenceClient(model=model_id)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomModel</span>(<span class="hljs-title class_ inherited__">Model</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">messages, stop_sequences=[<span class="hljs-string">&quot;Task&quot;</span>]</span>):
        response = client.chat_completion(messages, stop=stop_sequences, max_tokens=<span class="hljs-number">1024</span>)
        answer = response.choices[<span class="hljs-number">0</span>].message
        <span class="hljs-keyword">return</span> answer

custom_model = CustomModel()`,wrap:!1}}),he=new L({props:{title:"TransformersModel",local:"smolagents.TransformersModel",headingTag:"h3"}}),ye=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUcmFuc2Zvcm1lcnNNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwVHJhbnNmb3JtZXJzTW9kZWwobW9kZWxfaWQlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNLTEzNU0tSW5zdHJ1Y3QlMjIpJTBBJTBBcHJpbnQobW9kZWwoJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyT2shJTIyJTdEJTVEJTdEJTVEJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJncmVhdCUyMiU1RCkp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> TransformersModel

model = TransformersModel(model_id=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)

<span class="hljs-built_in">print</span>(model([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Ok!&quot;</span>}]}], stop_sequences=[<span class="hljs-string">&quot;great&quot;</span>]))`,wrap:!1}}),Te=new U({props:{code:"V2hhdCUyMGE=",highlighted:"&gt;&gt;&gt; What a",wrap:!1}}),X=new Ct({props:{warning:!1,$$slots:{default:[tl]},$$scope:{ctx:j}}}),Je=new Q({props:{name:"class smolagents.TransformersModel",anchor:"smolagents.TransformersModel",parameters:[{name:"model_id",val:": str | None = None"},{name:"device_map",val:": str | None = None"},{name:"torch_dtype",val:": str | None = None"},{name:"trust_remote_code",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.TransformersModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The Hugging Face model ID to be used for inference. This can be a path or model identifier from the Hugging Face model hub.
For example, <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>.`,name:"model_id"},{anchor:"smolagents.TransformersModel.device_map",description:`<strong>device_map</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The device_map to initialize your model with.`,name:"device_map"},{anchor:"smolagents.TransformersModel.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The torch_dtype to initialize your model with.`,name:"torch_dtype"},{anchor:"smolagents.TransformersModel.trust_remote_code",description:`<strong>trust_remote_code</strong> (bool, default <code>False</code>) &#x2014;
Some models on the Hub require running remote code: for this model, you would have to set this flag to True.`,name:"trust_remote_code"},{anchor:"smolagents.TransformersModel.kwargs",description:`<strong>kwargs</strong> (dict, <em>optional</em>) &#x2014;
Any additional keyword arguments that you want to use in model.generate(), for instance <code>max_new_tokens</code> or <code>device</code>.`,name:"kwargs"},{anchor:"smolagents.TransformersModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to <code>model.generate()</code>, for instance <code>max_new_tokens</code> or <code>device</code>.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L761",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the model name is not provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),F=new Ct({props:{warning:!1,$$slots:{default:[sl]},$$scope:{ctx:j}}}),G=new ae({props:{anchor:"smolagents.TransformersModel.example",$$slots:{default:[nl]},$$scope:{ctx:j}}}),we=new L({props:{title:"InferenceClientModel",local:"smolagents.InferenceClientModel",headingTag:"h3"}}),be=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIySGVsbG8lMkMlMjBob3clMjBhcmUlMjB5b3UlM0YlMjIlN0QlNUQlN0QlMEElNUQlMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKHByb3ZpZGVyJTNEJTIybm92aXRhJTIyJTJDJTIwcmVxdWVzdHNfcGVyX21pbnV0ZSUzRDYwKSUwQXByaW50KG1vZGVsKG1lc3NhZ2VzKSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]}
]

model = InferenceClientModel(provider=<span class="hljs-string">&quot;novita&quot;</span>, requests_per_minute=<span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(model(messages))`,wrap:!1}}),Ue=new U({props:{code:"T2YlMjBjb3Vyc2UhJTIwSWYlMjB5b3UlMjBjaGFuZ2UlMjB5b3VyJTIwbWluZCUyQyUyMGZlZWwlMjBmcmVlJTIwdG8lMjByZWFjaCUyMG91dC4lMjBUYWtlJTIwY2FyZSE=",highlighted:"&gt;&gt;&gt; Of course! If you change your mind, feel free to reach out. Take care!",wrap:!1}}),$e=new Q({props:{name:"class smolagents.InferenceClientModel",anchor:"smolagents.InferenceClientModel",parameters:[{name:"model_id",val:": str = 'Qwen/Qwen2.5-Coder-32B-Instruct'"},{name:"provider",val:": str | None = None"},{name:"token",val:": str | None = None"},{name:"timeout",val:": int = 120"},{name:"client_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"api_key",val:": str | None = None"},{name:"bill_to",val:": str | None = None"},{name:"base_url",val:": str | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.InferenceClientModel.model_id",description:`<strong>model_id</strong> (<code>str</code>, <em>optional</em>, default <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>) &#x2014;
The Hugging Face model ID to be used for inference.
This can be a model identifier from the Hugging Face model hub or a URL to a deployed Inference Endpoint.
Currently, it defaults to <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>, but this may change in the future.`,name:"model_id"},{anchor:"smolagents.InferenceClientModel.provider",description:`<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the provider to use for inference. A list of supported providers can be found in the <a href="https://huggingface.co/docs/inference-providers/index#partners" rel="nofollow">Inference Providers documentation</a>.
Defaults to &#x201C;auto&#x201D; i.e. the first of the providers available for the model, sorted by the user&#x2019;s order <a href="https://hf.co/settings/inference-providers" rel="nofollow">here</a>.
If <code>base_url</code> is passed, then <code>provider</code> is not used.`,name:"provider"},{anchor:"smolagents.InferenceClientModel.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Token used by the Hugging Face API for authentication. This token need to be authorized &#x2018;Make calls to the serverless Inference Providers&#x2019;.
If the model is gated (like Llama-3 models), the token also needs &#x2018;Read access to contents of all public gated repos you can access&#x2019;.
If not provided, the class will try to use environment variable &#x2018;HF_TOKEN&#x2019;, else use the token stored in the Hugging Face CLI configuration.`,name:"token"},{anchor:"smolagents.InferenceClientModel.timeout",description:`<strong>timeout</strong> (<code>int</code>, <em>optional</em>, defaults to 120) &#x2014;
Timeout for the API request, in seconds.`,name:"timeout"},{anchor:"smolagents.InferenceClientModel.client_kwargs",description:`<strong>client_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the Hugging Face InferenceClient.`,name:"client_kwargs"},{anchor:"smolagents.InferenceClientModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.`,name:"custom_role_conversions"},{anchor:"smolagents.InferenceClientModel.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/smolagents/v1.20.0/en/reference/models#smolagents.InferenceClientModel">InferenceClientModel</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"},{anchor:"smolagents.InferenceClientModel.bill_to",description:`<strong>bill_to</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The billing account to use for the requests. By default the requests are billed on the user&#x2019;s account. Requests can only be billed to
an organization the user is a member of, and which has subscribed to Enterprise Hub.`,name:"bill_to"},{anchor:"smolagents.InferenceClientModel.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/smolagents/v1.20.0/en/reference/models#smolagents.InferenceClientModel">InferenceClientModel</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"smolagents.InferenceClientModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to the Hugging Face InferenceClient.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L1314",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the model name is not provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),H=new ae({props:{anchor:"smolagents.InferenceClientModel.example",$$slots:{default:[ll]},$$scope:{ctx:j}}}),_e=new Q({props:{name:"create_client",anchor:"smolagents.InferenceClientModel.create_client",parameters:[],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L1405"}}),ve=new L({props:{title:"LiteLLMModel",local:"smolagents.LiteLLMModel",headingTag:"h3"}}),ke=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBMaXRlTExNTW9kZWwlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTVEJTdEJTBBJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBMaXRlTExNTW9kZWwobW9kZWxfaWQlM0QlMjJhbnRocm9waWMlMkZjbGF1ZGUtMy01LXNvbm5ldC1sYXRlc3QlMjIlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUyMG1heF90b2tlbnMlM0QxMCUyQyUyMHJlcXVlc3RzX3Blcl9taW51dGUlM0Q2MCklMEFwcmludChtb2RlbChtZXNzYWdlcykp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> LiteLLMModel

messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]}
]

model = LiteLLMModel(model_id=<span class="hljs-string">&quot;anthropic/claude-3-5-sonnet-latest&quot;</span>, temperature=<span class="hljs-number">0.2</span>, max_tokens=<span class="hljs-number">10</span>, requests_per_minute=<span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(model(messages))`,wrap:!1}}),xe=new Q({props:{name:"class smolagents.LiteLLMModel",anchor:"smolagents.LiteLLMModel",parameters:[{name:"model_id",val:": str | None = None"},{name:"api_base",val:": str | None = None"},{name:"api_key",val:": str | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"flatten_messages_as_text",val:": bool | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.LiteLLMModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The model identifier to use on the server (e.g. &#x201C;gpt-3.5-turbo&#x201D;).`,name:"model_id"},{anchor:"smolagents.LiteLLMModel.api_base",description:`<strong>api_base</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The base URL of the provider API to call the model.`,name:"api_base"},{anchor:"smolagents.LiteLLMModel.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use for authentication.`,name:"api_key"},{anchor:"smolagents.LiteLLMModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.`,name:"custom_role_conversions"},{anchor:"smolagents.LiteLLMModel.flatten_messages_as_text",description:`<strong>flatten_messages_as_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether to flatten messages as text.
Defaults to <code>True</code> for models that start with &#x201C;ollama&#x201D;, &#x201C;groq&#x201D;, &#x201C;cerebras&#x201D;.`,name:"flatten_messages_as_text"},{anchor:"smolagents.LiteLLMModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to the OpenAI API.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L1072"}}),Ae=new Q({props:{name:"create_client",anchor:"smolagents.LiteLLMModel.create_client",parameters:[],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L1122"}}),qe=new L({props:{title:"LiteLLMRouterModel",local:"smolagents.LiteLLMRouterModel",headingTag:"h3"}}),Ee=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBMaXRlTExNUm91dGVyTW9kZWwlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTVEJTdEJTBBJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBMaXRlTExNUm91dGVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJsbGFtYS0zLjMtNzBiJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbGlzdCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1vZGVsX25hbWUlMjIlM0ElMjAlMjJsbGFtYS0zLjMtNzBiJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGl0ZWxsbV9wYXJhbXMlMjIlM0ElMjAlN0IlMjJtb2RlbCUyMiUzQSUyMCUyMmdyb3ElMkZsbGFtYS0zLjMtNzBiJTIyJTJDJTIwJTIyYXBpX2tleSUyMiUzQSUyMG9zLmdldGVudiglMjJHUk9RX0FQSV9LRVklMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMmxsYW1hLTMuMy03MGIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaXRlbGxtX3BhcmFtcyUyMiUzQSUyMCU3QiUyMm1vZGVsJTIyJTNBJTIwJTIyY2VyZWJyYXMlMkZsbGFtYS0zLjMtNzBiJTIyJTJDJTIwJTIyYXBpX2tleSUyMiUzQSUyMG9zLmdldGVudiglMjJDRVJFQlJBU19BUElfS0VZJTIyKSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGNsaWVudF9rd2FyZ3MlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb3V0aW5nX3N0cmF0ZWd5JTIyJTNBJTIwJTIyc2ltcGxlLXNodWZmbGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEpJTBBcHJpbnQobW9kZWwobWVzc2FnZXMpKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> LiteLLMRouterModel

messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]}
]

model = LiteLLMRouterModel(
    model_id=<span class="hljs-string">&quot;llama-3.3-70b&quot;</span>,
    model_list=[
        {
            <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;llama-3.3-70b&quot;</span>,
            <span class="hljs-string">&quot;litellm_params&quot;</span>: {<span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;groq/llama-3.3-70b&quot;</span>, <span class="hljs-string">&quot;api_key&quot;</span>: os.getenv(<span class="hljs-string">&quot;GROQ_API_KEY&quot;</span>)},
        },
        {
            <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;llama-3.3-70b&quot;</span>,
            <span class="hljs-string">&quot;litellm_params&quot;</span>: {<span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;cerebras/llama-3.3-70b&quot;</span>, <span class="hljs-string">&quot;api_key&quot;</span>: os.getenv(<span class="hljs-string">&quot;CEREBRAS_API_KEY&quot;</span>)},
        },
    ],
    client_kwargs={
        <span class="hljs-string">&quot;routing_strategy&quot;</span>: <span class="hljs-string">&quot;simple-shuffle&quot;</span>,
    },
)
<span class="hljs-built_in">print</span>(model(messages))`,wrap:!1}}),Le=new Q({props:{name:"class smolagents.LiteLLMRouterModel",anchor:"smolagents.LiteLLMRouterModel",parameters:[{name:"model_id",val:": str"},{name:"model_list",val:": list"},{name:"client_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"flatten_messages_as_text",val:": bool | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.LiteLLMRouterModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
Identifier for the model group to use from the model list (e.g., &#x201C;model-group-1&#x201D;).`,name:"model_id"},{anchor:"smolagents.LiteLLMRouterModel.model_list",description:`<strong>model_list</strong> (<code>list[dict[str, Any]]</code>) &#x2014;
Model configurations to be used for routing.
Each configuration should include the model group name and any necessary parameters.
For more details, refer to the <a href="https://docs.litellm.ai/docs/routing#quick-start" rel="nofollow">LiteLLM Routing</a> documentation.`,name:"model_list"},{anchor:"smolagents.LiteLLMRouterModel.client_kwargs",description:`<strong>client_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional configuration parameters for the Router client. For more details, see the
<a href="https://docs.litellm.ai/docs/routing" rel="nofollow">LiteLLM Routing Configurations</a>.`,name:"client_kwargs"},{anchor:"smolagents.LiteLLMRouterModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.`,name:"custom_role_conversions"},{anchor:"smolagents.LiteLLMRouterModel.flatten_messages_as_text",description:`<strong>flatten_messages_as_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether to flatten messages as text.
Defaults to <code>True</code> for models that start with &#x201C;ollama&#x201D;, &#x201C;groq&#x201D;, &#x201C;cerebras&#x201D;.`,name:"flatten_messages_as_text"},{anchor:"smolagents.LiteLLMRouterModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to the LiteLLM Router completion method.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L1221"}}),D=new ae({props:{anchor:"smolagents.LiteLLMRouterModel.example",$$slots:{default:[ol]},$$scope:{ctx:j}}}),Be=new L({props:{title:"OpenAIServerModel",local:"smolagents.OpenAIServerModel",headingTag:"h3"}}),Ze=new U({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyME9wZW5BSVNlcnZlck1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlTZXJ2ZXJNb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMmdwdC00byUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9iYXNlJTNEJTIyaHR0cHMlM0ElMkYlMkZhcGkub3BlbmFpLmNvbSUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRG9zLmVudmlyb24lNUIlMjJPUEVOQUlfQVBJX0tFWSUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel

model = OpenAIServerModel(
    model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>,
    api_base=<span class="hljs-string">&quot;https://api.openai.com/v1&quot;</span>,
    api_key=os.environ[<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>],
)`,wrap:!1}}),Qe=new Q({props:{name:"class smolagents.OpenAIServerModel",anchor:"smolagents.OpenAIServerModel",parameters:[{name:"model_id",val:": str"},{name:"api_base",val:": str | None = None"},{name:"api_key",val:": str | None = None"},{name:"organization",val:": str | None = None"},{name:"project",val:": str | None = None"},{name:"client_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"flatten_messages_as_text",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.OpenAIServerModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The model identifier to use on the server (e.g. &#x201C;gpt-3.5-turbo&#x201D;).`,name:"model_id"},{anchor:"smolagents.OpenAIServerModel.api_base",description:`<strong>api_base</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The base URL of the OpenAI-compatible API server.`,name:"api_base"},{anchor:"smolagents.OpenAIServerModel.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use for authentication.`,name:"api_key"},{anchor:"smolagents.OpenAIServerModel.organization",description:`<strong>organization</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The organization to use for the API request.`,name:"organization"},{anchor:"smolagents.OpenAIServerModel.project",description:`<strong>project</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The project to use for the API request.`,name:"project"},{anchor:"smolagents.OpenAIServerModel.client_kwargs",description:`<strong>client_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the OpenAI client (like organization, project, max_retries etc.).`,name:"client_kwargs"},{anchor:"smolagents.OpenAIServerModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.`,name:"custom_role_conversions"},{anchor:"smolagents.OpenAIServerModel.flatten_messages_as_text",description:`<strong>flatten_messages_as_text</strong> (<code>bool</code>, default <code>False</code>) &#x2014;
Whether to flatten messages as text.`,name:"flatten_messages_as_text"},{anchor:"smolagents.OpenAIServerModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to the OpenAI API.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L1501"}}),Ve=new L({props:{title:"AzureOpenAIServerModel",local:"smolagents.AzureOpenAIServerModel",headingTag:"h3"}}),Xe=new U({props:{code:"aW1wb3J0JTIwb3MlMEElMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMEF6dXJlT3BlbkFJU2VydmVyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMEF6dXJlT3BlbkFJU2VydmVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMjAlM0QlMjBvcy5lbnZpcm9uLmdldCglMjJBWlVSRV9PUEVOQUlfTU9ERUwlMjIpJTJDJTBBJTIwJTIwJTIwJTIwYXp1cmVfZW5kcG9pbnQlM0Rvcy5lbnZpcm9uLmdldCglMjJBWlVSRV9PUEVOQUlfRU5EUE9JTlQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRG9zLmVudmlyb24uZ2V0KCUyMkFaVVJFX09QRU5BSV9BUElfS0VZJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV92ZXJzaW9uJTNEb3MuZW52aXJvbi5nZXQoJTIyT1BFTkFJX0FQSV9WRVJTSU9OJTIyKSUyMCUyMCUyMCUyMCUwQSk=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> AzureOpenAIServerModel

model = AzureOpenAIServerModel(
    model_id = os.environ.get(<span class="hljs-string">&quot;AZURE_OPENAI_MODEL&quot;</span>),
    azure_endpoint=os.environ.get(<span class="hljs-string">&quot;AZURE_OPENAI_ENDPOINT&quot;</span>),
    api_key=os.environ.get(<span class="hljs-string">&quot;AZURE_OPENAI_API_KEY&quot;</span>),
    api_version=os.environ.get(<span class="hljs-string">&quot;OPENAI_API_VERSION&quot;</span>)    
)`,wrap:!1}}),Fe=new Q({props:{name:"class smolagents.AzureOpenAIServerModel",anchor:"smolagents.AzureOpenAIServerModel",parameters:[{name:"model_id",val:": str"},{name:"azure_endpoint",val:": str | None = None"},{name:"api_key",val:": str | None = None"},{name:"api_version",val:": str | None = None"},{name:"client_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.AzureOpenAIServerModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The model deployment name to use when connecting (e.g. &#x201C;gpt-4o-mini&#x201D;).`,name:"model_id"},{anchor:"smolagents.AzureOpenAIServerModel.azure_endpoint",description:`<strong>azure_endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The Azure endpoint, including the resource, e.g. <code>https://example-resource.azure.openai.com/</code>. If not provided, it will be inferred from the <code>AZURE_OPENAI_ENDPOINT</code> environment variable.`,name:"azure_endpoint"},{anchor:"smolagents.AzureOpenAIServerModel.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use for authentication. If not provided, it will be inferred from the <code>AZURE_OPENAI_API_KEY</code> environment variable.`,name:"api_key"},{anchor:"smolagents.AzureOpenAIServerModel.api_version",description:`<strong>api_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API version to use. If not provided, it will be inferred from the <code>OPENAI_API_VERSION</code> environment variable.`,name:"api_version"},{anchor:"smolagents.AzureOpenAIServerModel.client_kwargs",description:`<strong>client_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the AzureOpenAI client (like organization, project, max_retries etc.).`,name:"client_kwargs"},{anchor:"smolagents.AzureOpenAIServerModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.`,name:"custom_role_conversions"},{anchor:"smolagents.AzureOpenAIServerModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to the Azure OpenAI API.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L1652"}}),Ge=new L({props:{title:"AmazonBedrockServerModel",local:"smolagents.AmazonBedrockServerModel",headingTag:"h3"}}),Pe=new U({props:{code:"aW1wb3J0JTIwb3MlMEElMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMEFtYXpvbkJlZHJvY2tTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQW1hem9uQmVkcm9ja1NlcnZlck1vZGVsKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTIwJTNEJTIwb3MuZW52aXJvbi5nZXQoJTIyQU1BWk9OX0JFRFJPQ0tfTU9ERUxfSUQlMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> AmazonBedrockServerModel

model = AmazonBedrockServerModel(
    model_id = os.environ.get(<span class="hljs-string">&quot;AMAZON_BEDROCK_MODEL_ID&quot;</span>),
)`,wrap:!1}}),De=new Q({props:{name:"class smolagents.AmazonBedrockServerModel",anchor:"smolagents.AmazonBedrockServerModel",parameters:[{name:"model_id",val:": str"},{name:"client",val:" = None"},{name:"client_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.AmazonBedrockServerModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The model identifier to use on Bedrock (e.g. &#x201C;us.amazon.nova-pro-v1:0&#x201D;).`,name:"model_id"},{anchor:"smolagents.AmazonBedrockServerModel.client",description:`<strong>client</strong> (<code>boto3.client</code>, <em>optional</em>) &#x2014;
A custom boto3 client for AWS interactions. If not provided, a default client will be created.`,name:"client"},{anchor:"smolagents.AmazonBedrockServerModel.client_kwargs",description:`<strong>client_kwargs</strong> (dict[str, Any], <em>optional</em>) &#x2014;
Keyword arguments used to configure the boto3 client if it needs to be created internally.
Examples include <code>region_name</code>, <code>config</code>, or <code>endpoint_url</code>.`,name:"client_kwargs"},{anchor:"smolagents.AmazonBedrockServerModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.
Defaults to converting all roles to &#x201C;user&#x201D; role to enable using all the Bedrock models.`,name:"custom_role_conversions"},{anchor:"smolagents.AmazonBedrockServerModel.flatten_messages_as_text",description:`<strong>flatten_messages_as_text</strong> (<code>bool</code>, default <code>False</code>) &#x2014;
Whether to flatten messages as text.`,name:"flatten_messages_as_text"},{anchor:"smolagents.AmazonBedrockServerModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments passed directly to the underlying API calls.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L1712"}}),O=new ae({props:{anchor:"smolagents.AmazonBedrockServerModel.example",$$slots:{default:[al]},$$scope:{ctx:j}}}),K=new ae({props:{anchor:"smolagents.AmazonBedrockServerModel.example-2",$$slots:{default:[rl]},$$scope:{ctx:j}}}),ee=new ae({props:{anchor:"smolagents.AmazonBedrockServerModel.example-3",$$slots:{default:[il]},$$scope:{ctx:j}}}),te=new ae({props:{anchor:"smolagents.AmazonBedrockServerModel.example-4",$$slots:{default:[cl]},$$scope:{ctx:j}}}),Oe=new L({props:{title:"MLXModel",local:"smolagents.MLXModel",headingTag:"h3"}}),Ke=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNTFhNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwTUxYTW9kZWwobW9kZWxfaWQlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNLTEzNU0tSW5zdHJ1Y3QlMjIpJTBBJTBBcHJpbnQobW9kZWwoJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyT2shJTIyJTdEJTVEJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJncmVhdCUyMiU1RCkp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MLXModel

model = MLXModel(model_id=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)

<span class="hljs-built_in">print</span>(model([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Ok!&quot;</span>}], stop_sequences=[<span class="hljs-string">&quot;great&quot;</span>]))`,wrap:!1}}),et=new U({props:{code:"V2hhdCUyMGE=",highlighted:"&gt;&gt;&gt; What a",wrap:!1}}),se=new Ct({props:{warning:!1,$$slots:{default:[pl]},$$scope:{ctx:j}}}),tt=new Q({props:{name:"class smolagents.MLXModel",anchor:"smolagents.MLXModel",parameters:[{name:"model_id",val:": str"},{name:"trust_remote_code",val:": bool = False"},{name:"load_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"apply_chat_template_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.MLXModel.model_id",description:`<strong>model_id</strong> (str) &#x2014;
The Hugging Face model ID to be used for inference. This can be a path or model identifier from the Hugging Face model hub.`,name:"model_id"},{anchor:"smolagents.MLXModel.tool_name_key",description:`<strong>tool_name_key</strong> (str) &#x2014;
The key, which can usually be found in the model&#x2019;s chat template, for retrieving a tool name.`,name:"tool_name_key"},{anchor:"smolagents.MLXModel.tool_arguments_key",description:`<strong>tool_arguments_key</strong> (str) &#x2014;
The key, which can usually be found in the model&#x2019;s chat template, for retrieving tool arguments.`,name:"tool_arguments_key"},{anchor:"smolagents.MLXModel.trust_remote_code",description:`<strong>trust_remote_code</strong> (bool, default <code>False</code>) &#x2014;
Some models on the Hub require running remote code: for this model, you would have to set this flag to True.`,name:"trust_remote_code"},{anchor:"smolagents.MLXModel.load_kwargs",description:`<strong>load_kwargs</strong> (dict[str, Any], <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the <code>mlx.lm.load</code> method when loading the model and tokenizer.`,name:"load_kwargs"},{anchor:"smolagents.MLXModel.apply_chat_template_kwargs",description:`<strong>apply_chat_template_kwargs</strong> (dict, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the <code>apply_chat_template</code> method of the tokenizer.`,name:"apply_chat_template_kwargs"},{anchor:"smolagents.MLXModel.kwargs",description:`<strong>kwargs</strong> (dict, <em>optional</em>) &#x2014;
Any additional keyword arguments that you want to use in model.generate(), for instance <code>max_tokens</code>.`,name:"kwargs"}],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L651"}}),ne=new Ct({props:{warning:!1,$$slots:{default:[ml]},$$scope:{ctx:j}}}),le=new ae({props:{anchor:"smolagents.MLXModel.example",$$slots:{default:[dl]},$$scope:{ctx:j}}}),st=new L({props:{title:"VLLMModel",local:"smolagents.VLLMModel",headingTag:"h3"}}),lt=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBWTExNTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFZMTE1Nb2RlbChtb2RlbF9pZCUzRCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0tMTM1TS1JbnN0cnVjdCUyMiklMEElMEFwcmludChtb2RlbCglNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJPayElMjIlN0QlNUQlMkMlMjBzdG9wX3NlcXVlbmNlcyUzRCU1QiUyMmdyZWF0JTIyJTVEKSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> VLLMModel

model = VLLMModel(model_id=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)

<span class="hljs-built_in">print</span>(model([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Ok!&quot;</span>}], stop_sequences=[<span class="hljs-string">&quot;great&quot;</span>]))`,wrap:!1}}),oe=new Ct({props:{warning:!1,$$slots:{default:[gl]},$$scope:{ctx:j}}}),ot=new Q({props:{name:"class smolagents.VLLMModel",anchor:"smolagents.VLLMModel",parameters:[{name:"model_id",val:""},{name:"model_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.VLLMModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The Hugging Face model ID to be used for inference.
This can be a path or model identifier from the Hugging Face model hub.`,name:"model_id"},{anchor:"smolagents.VLLMModel.model_kwargs",description:`<strong>model_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the vLLM model (like revision, max_model_len, etc.).`,name:"model_kwargs"}],source:"https://github.com/huggingface/smolagents/blob/v1.20.0/src/smolagents/models.py#L544"}}),at=new Kn({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/reference/models.md"}}),{c(){l=p("meta"),w=a(),i=p("p"),c=a(),d(J.$$.fragment),n=a(),d(I.$$.fragment),xt=a(),re=p("p"),re.innerHTML=pn,At=a(),d(ie.$$.fragment),qt=a(),d(ce.$$.fragment),Nt=a(),pe=p("p"),pe.textContent=mn,Et=a(),me=p("p"),me.innerHTML=dn,Lt=a(),de=p("ol"),de.innerHTML=gn,Bt=a(),ge=p("p"),ge.innerHTML=un,Wt=a(),d(ue.$$.fragment),Zt=a(),Me=p("p"),Me.innerHTML=Mn,Qt=a(),d(he.$$.fragment),Vt=a(),fe=p("p"),fe.innerHTML=hn,St=a(),d(ye.$$.fragment),Rt=a(),d(Te.$$.fragment),zt=a(),d(X.$$.fragment),Xt=a(),v=p("div"),d(Je.$$.fragment),Ns=a(),dt=p("p"),dt.textContent=fn,Es=a(),gt=p("p"),gt.textContent=yn,Ls=a(),d(F.$$.fragment),Bs=a(),d(G.$$.fragment),Ft=a(),d(we.$$.fragment),Gt=a(),Ie=p("p"),Ie.innerHTML=Tn,Ht=a(),je=p("p"),je.innerHTML=Jn,Yt=a(),d(be.$$.fragment),Pt=a(),d(Ue.$$.fragment),Dt=a(),_=p("div"),d($e.$$.fragment),Ws=a(),ut=p("p"),ut.textContent=wn,Zs=a(),Mt=p("p"),Mt.textContent=In,Qs=a(),ht=p("p"),ht.textContent=jn,Vs=a(),d(H.$$.fragment),Ss=a(),Y=p("div"),d(_e.$$.fragment),Rs=a(),ft=p("p"),ft.textContent=bn,Ot=a(),d(ve.$$.fragment),Kt=a(),Ce=p("p"),Ce.innerHTML=Un,es=a(),d(ke.$$.fragment),ts=a(),B=p("div"),d(xe.$$.fragment),zs=a(),yt=p("p"),yt.innerHTML=$n,Xs=a(),P=p("div"),d(Ae.$$.fragment),Fs=a(),Tt=p("p"),Tt.textContent=_n,ss=a(),d(qe.$$.fragment),ns=a(),Ne=p("p"),Ne.innerHTML=vn,ls=a(),d(Ee.$$.fragment),os=a(),x=p("div"),d(Le.$$.fragment),Gs=a(),Jt=p("p"),Jt.innerHTML=Cn,Hs=a(),wt=p("p"),wt.textContent=kn,Ys=a(),d(D.$$.fragment),as=a(),d(Be.$$.fragment),rs=a(),We=p("p"),We.innerHTML=xn,is=a(),d(Ze.$$.fragment),cs=a(),V=p("div"),d(Qe.$$.fragment),Ps=a(),It=p("p"),It.textContent=An,ps=a(),d(Ve.$$.fragment),ms=a(),Se=p("p"),Se.innerHTML=qn,ds=a(),Re=p("p"),Re.innerHTML=Nn,gs=a(),ze=p("p"),ze.innerHTML=En,us=a(),d(Xe.$$.fragment),Ms=a(),S=p("div"),d(Fe.$$.fragment),Ds=a(),jt=p("p"),jt.textContent=Ln,hs=a(),d(Ge.$$.fragment),fs=a(),He=p("p"),He.innerHTML=Bn,ys=a(),Ye=p("p"),Ye.textContent=Wn,Ts=a(),d(Pe.$$.fragment),Js=a(),b=p("div"),d(De.$$.fragment),Os=a(),bt=p("p"),bt.textContent=Zn,Ks=a(),Ut=p("p"),Ut.textContent=Qn,en=a(),$t=p("p"),$t.textContent=Vn,tn=a(),d(O.$$.fragment),sn=a(),d(K.$$.fragment),nn=a(),d(ee.$$.fragment),ln=a(),d(te.$$.fragment),ws=a(),d(Oe.$$.fragment),Is=a(),d(Ke.$$.fragment),js=a(),d(et.$$.fragment),bs=a(),d(se.$$.fragment),Us=a(),A=p("div"),d(tt.$$.fragment),on=a(),_t=p("p"),_t.textContent=Sn,an=a(),d(ne.$$.fragment),rn=a(),d(le.$$.fragment),$s=a(),d(st.$$.fragment),_s=a(),nt=p("p"),nt.innerHTML=Rn,vs=a(),d(lt.$$.fragment),Cs=a(),d(oe.$$.fragment),ks=a(),R=p("div"),d(ot.$$.fragment),cn=a(),vt=p("p"),vt.innerHTML=zn,xs=a(),d(at.$$.fragment),As=a(),kt=p("p"),this.h()},l(e){const t=On("svelte-u9bgzb",document.head);l=m(t,"META",{name:!0,content:!0}),t.forEach(s),w=r(e),i=m(e,"P",{}),N(i).forEach(s),c=r(e),g(J.$$.fragment,e),n=r(e),g(I.$$.fragment,e),xt=r(e),re=m(e,"P",{"data-svelte-h":!0}),T(re)!=="svelte-17nnzxz"&&(re.innerHTML=pn),At=r(e),g(ie.$$.fragment,e),qt=r(e),g(ce.$$.fragment,e),Nt=r(e),pe=m(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-nwgagp"&&(pe.textContent=mn),Et=r(e),me=m(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-1982g4m"&&(me.innerHTML=dn),Lt=r(e),de=m(e,"OL",{"data-svelte-h":!0}),T(de)!=="svelte-otqs16"&&(de.innerHTML=gn),Bt=r(e),ge=m(e,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-ww7ptk"&&(ge.innerHTML=un),Wt=r(e),g(ue.$$.fragment,e),Zt=r(e),Me=m(e,"P",{"data-svelte-h":!0}),T(Me)!=="svelte-1j71ekz"&&(Me.innerHTML=Mn),Qt=r(e),g(he.$$.fragment,e),Vt=r(e),fe=m(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-ulv590"&&(fe.innerHTML=hn),St=r(e),g(ye.$$.fragment,e),Rt=r(e),g(Te.$$.fragment,e),zt=r(e),g(X.$$.fragment,e),Xt=r(e),v=m(e,"DIV",{class:!0});var q=N(v);g(Je.$$.fragment,q),Ns=r(q),dt=m(q,"P",{"data-svelte-h":!0}),T(dt)!=="svelte-1ex1ahr"&&(dt.textContent=fn),Es=r(q),gt=m(q,"P",{"data-svelte-h":!0}),T(gt)!=="svelte-1140acn"&&(gt.textContent=yn),Ls=r(q),g(F.$$.fragment,q),Bs=r(q),g(G.$$.fragment,q),q.forEach(s),Ft=r(e),g(we.$$.fragment,e),Gt=r(e),Ie=m(e,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-iu01g0"&&(Ie.innerHTML=Tn),Ht=r(e),je=m(e,"P",{"data-svelte-h":!0}),T(je)!=="svelte-1cavb4l"&&(je.innerHTML=Jn),Yt=r(e),g(be.$$.fragment,e),Pt=r(e),g(Ue.$$.fragment,e),Dt=r(e),_=m(e,"DIV",{class:!0});var C=N(_);g($e.$$.fragment,C),Ws=r(C),ut=m(C,"P",{"data-svelte-h":!0}),T(ut)!=="svelte-axkcn3"&&(ut.textContent=wn),Zs=r(C),Mt=m(C,"P",{"data-svelte-h":!0}),T(Mt)!=="svelte-bducrc"&&(Mt.textContent=In),Qs=r(C),ht=m(C,"P",{"data-svelte-h":!0}),T(ht)!=="svelte-12eu297"&&(ht.textContent=jn),Vs=r(C),g(H.$$.fragment,C),Ss=r(C),Y=m(C,"DIV",{class:!0});var rt=N(Y);g(_e.$$.fragment,rt),Rs=r(rt),ft=m(rt,"P",{"data-svelte-h":!0}),T(ft)!=="svelte-ym2f5u"&&(ft.textContent=bn),rt.forEach(s),C.forEach(s),Ot=r(e),g(ve.$$.fragment,e),Kt=r(e),Ce=m(e,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-1m09ddd"&&(Ce.innerHTML=Un),es=r(e),g(ke.$$.fragment,e),ts=r(e),B=m(e,"DIV",{class:!0});var z=N(B);g(xe.$$.fragment,z),zs=r(z),yt=m(z,"P",{"data-svelte-h":!0}),T(yt)!=="svelte-5g97zk"&&(yt.innerHTML=$n),Xs=r(z),P=m(z,"DIV",{class:!0});var it=N(P);g(Ae.$$.fragment,it),Fs=r(it),Tt=m(it,"P",{"data-svelte-h":!0}),T(Tt)!=="svelte-12r14rd"&&(Tt.textContent=_n),it.forEach(s),z.forEach(s),ss=r(e),g(qe.$$.fragment,e),ns=r(e),Ne=m(e,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-cark4"&&(Ne.innerHTML=vn),ls=r(e),g(Ee.$$.fragment,e),os=r(e),x=m(e,"DIV",{class:!0});var W=N(x);g(Le.$$.fragment,W),Gs=r(W),Jt=m(W,"P",{"data-svelte-h":!0}),T(Jt)!=="svelte-2o2pf3"&&(Jt.innerHTML=Cn),Hs=r(W),wt=m(W,"P",{"data-svelte-h":!0}),T(wt)!=="svelte-1cq7nyu"&&(wt.textContent=kn),Ys=r(W),g(D.$$.fragment,W),W.forEach(s),as=r(e),g(Be.$$.fragment,e),rs=r(e),We=m(e,"P",{"data-svelte-h":!0}),T(We)!=="svelte-juyrd0"&&(We.innerHTML=xn),is=r(e),g(Ze.$$.fragment,e),cs=r(e),V=m(e,"DIV",{class:!0});var ct=N(V);g(Qe.$$.fragment,ct),Ps=r(ct),It=m(ct,"P",{"data-svelte-h":!0}),T(It)!=="svelte-1bc1pfc"&&(It.textContent=An),ct.forEach(s),ps=r(e),g(Ve.$$.fragment,e),ms=r(e),Se=m(e,"P",{"data-svelte-h":!0}),T(Se)!=="svelte-1946uqd"&&(Se.innerHTML=qn),ds=r(e),Re=m(e,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-1tbo5q5"&&(Re.innerHTML=Nn),gs=r(e),ze=m(e,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-16r94fh"&&(ze.innerHTML=En),us=r(e),g(Xe.$$.fragment,e),Ms=r(e),S=m(e,"DIV",{class:!0});var pt=N(S);g(Fe.$$.fragment,pt),Ds=r(pt),jt=m(pt,"P",{"data-svelte-h":!0}),T(jt)!=="svelte-1fspdqk"&&(jt.textContent=Ln),pt.forEach(s),hs=r(e),g(Ge.$$.fragment,e),fs=r(e),He=m(e,"P",{"data-svelte-h":!0}),T(He)!=="svelte-72042c"&&(He.innerHTML=Bn),ys=r(e),Ye=m(e,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-l4p418"&&(Ye.textContent=Wn),Ts=r(e),g(Pe.$$.fragment,e),Js=r(e),b=m(e,"DIV",{class:!0});var $=N(b);g(De.$$.fragment,$),Os=r($),bt=m($,"P",{"data-svelte-h":!0}),T(bt)!=="svelte-nngfd4"&&(bt.textContent=Zn),Ks=r($),Ut=m($,"P",{"data-svelte-h":!0}),T(Ut)!=="svelte-1milklp"&&(Ut.textContent=Qn),en=r($),$t=m($,"P",{"data-svelte-h":!0}),T($t)!=="svelte-kvfsh7"&&($t.textContent=Vn),tn=r($),g(O.$$.fragment,$),sn=r($),g(K.$$.fragment,$),nn=r($),g(ee.$$.fragment,$),ln=r($),g(te.$$.fragment,$),$.forEach(s),ws=r(e),g(Oe.$$.fragment,e),Is=r(e),g(Ke.$$.fragment,e),js=r(e),g(et.$$.fragment,e),bs=r(e),g(se.$$.fragment,e),Us=r(e),A=m(e,"DIV",{class:!0});var Z=N(A);g(tt.$$.fragment,Z),on=r(Z),_t=m(Z,"P",{"data-svelte-h":!0}),T(_t)!=="svelte-t9ku5w"&&(_t.textContent=Sn),an=r(Z),g(ne.$$.fragment,Z),rn=r(Z),g(le.$$.fragment,Z),Z.forEach(s),$s=r(e),g(st.$$.fragment,e),_s=r(e),nt=m(e,"P",{"data-svelte-h":!0}),T(nt)!=="svelte-1vi10v1"&&(nt.innerHTML=Rn),vs=r(e),g(lt.$$.fragment,e),Cs=r(e),g(oe.$$.fragment,e),ks=r(e),R=m(e,"DIV",{class:!0});var mt=N(R);g(ot.$$.fragment,mt),cn=r(mt),vt=m(mt,"P",{"data-svelte-h":!0}),T(vt)!=="svelte-1vi10v1"&&(vt.innerHTML=zn),mt.forEach(s),xs=r(e),g(at.$$.fragment,e),As=r(e),kt=m(e,"P",{}),N(kt).forEach(s),this.h()},h(){E(l,"name","hf:doc:metadata"),E(l,"content",Ml),E(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){y(document.head,l),o(e,w,t),o(e,i,t),o(e,c,t),u(J,e,t),o(e,n,t),u(I,e,t),o(e,xt,t),o(e,re,t),o(e,At,t),u(ie,e,t),o(e,qt,t),u(ce,e,t),o(e,Nt,t),o(e,pe,t),o(e,Et,t),o(e,me,t),o(e,Lt,t),o(e,de,t),o(e,Bt,t),o(e,ge,t),o(e,Wt,t),u(ue,e,t),o(e,Zt,t),o(e,Me,t),o(e,Qt,t),u(he,e,t),o(e,Vt,t),o(e,fe,t),o(e,St,t),u(ye,e,t),o(e,Rt,t),u(Te,e,t),o(e,zt,t),u(X,e,t),o(e,Xt,t),o(e,v,t),u(Je,v,null),y(v,Ns),y(v,dt),y(v,Es),y(v,gt),y(v,Ls),u(F,v,null),y(v,Bs),u(G,v,null),o(e,Ft,t),u(we,e,t),o(e,Gt,t),o(e,Ie,t),o(e,Ht,t),o(e,je,t),o(e,Yt,t),u(be,e,t),o(e,Pt,t),u(Ue,e,t),o(e,Dt,t),o(e,_,t),u($e,_,null),y(_,Ws),y(_,ut),y(_,Zs),y(_,Mt),y(_,Qs),y(_,ht),y(_,Vs),u(H,_,null),y(_,Ss),y(_,Y),u(_e,Y,null),y(Y,Rs),y(Y,ft),o(e,Ot,t),u(ve,e,t),o(e,Kt,t),o(e,Ce,t),o(e,es,t),u(ke,e,t),o(e,ts,t),o(e,B,t),u(xe,B,null),y(B,zs),y(B,yt),y(B,Xs),y(B,P),u(Ae,P,null),y(P,Fs),y(P,Tt),o(e,ss,t),u(qe,e,t),o(e,ns,t),o(e,Ne,t),o(e,ls,t),u(Ee,e,t),o(e,os,t),o(e,x,t),u(Le,x,null),y(x,Gs),y(x,Jt),y(x,Hs),y(x,wt),y(x,Ys),u(D,x,null),o(e,as,t),u(Be,e,t),o(e,rs,t),o(e,We,t),o(e,is,t),u(Ze,e,t),o(e,cs,t),o(e,V,t),u(Qe,V,null),y(V,Ps),y(V,It),o(e,ps,t),u(Ve,e,t),o(e,ms,t),o(e,Se,t),o(e,ds,t),o(e,Re,t),o(e,gs,t),o(e,ze,t),o(e,us,t),u(Xe,e,t),o(e,Ms,t),o(e,S,t),u(Fe,S,null),y(S,Ds),y(S,jt),o(e,hs,t),u(Ge,e,t),o(e,fs,t),o(e,He,t),o(e,ys,t),o(e,Ye,t),o(e,Ts,t),u(Pe,e,t),o(e,Js,t),o(e,b,t),u(De,b,null),y(b,Os),y(b,bt),y(b,Ks),y(b,Ut),y(b,en),y(b,$t),y(b,tn),u(O,b,null),y(b,sn),u(K,b,null),y(b,nn),u(ee,b,null),y(b,ln),u(te,b,null),o(e,ws,t),u(Oe,e,t),o(e,Is,t),u(Ke,e,t),o(e,js,t),u(et,e,t),o(e,bs,t),u(se,e,t),o(e,Us,t),o(e,A,t),u(tt,A,null),y(A,on),y(A,_t),y(A,an),u(ne,A,null),y(A,rn),u(le,A,null),o(e,$s,t),u(st,e,t),o(e,_s,t),o(e,nt,t),o(e,vs,t),u(lt,e,t),o(e,Cs,t),u(oe,e,t),o(e,ks,t),o(e,R,t),u(ot,R,null),y(R,cn),y(R,vt),o(e,xs,t),u(at,e,t),o(e,As,t),o(e,kt,t),qs=!0},p(e,[t]){const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),I.$set(q);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),X.$set(C);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),F.$set(rt);const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),G.$set(z);const it={};t&2&&(it.$$scope={dirty:t,ctx:e}),H.$set(it);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),D.$set(W);const ct={};t&2&&(ct.$$scope={dirty:t,ctx:e}),O.$set(ct);const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),K.$set(pt);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),ee.$set($);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),te.$set(Z);const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),se.$set(mt);const Xn={};t&2&&(Xn.$$scope={dirty:t,ctx:e}),ne.$set(Xn);const Fn={};t&2&&(Fn.$$scope={dirty:t,ctx:e}),le.$set(Fn);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),oe.$set(Gn)},i(e){qs||(M(J.$$.fragment,e),M(I.$$.fragment,e),M(ie.$$.fragment,e),M(ce.$$.fragment,e),M(ue.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(Te.$$.fragment,e),M(X.$$.fragment,e),M(Je.$$.fragment,e),M(F.$$.fragment,e),M(G.$$.fragment,e),M(we.$$.fragment,e),M(be.$$.fragment,e),M(Ue.$$.fragment,e),M($e.$$.fragment,e),M(H.$$.fragment,e),M(_e.$$.fragment,e),M(ve.$$.fragment,e),M(ke.$$.fragment,e),M(xe.$$.fragment,e),M(Ae.$$.fragment,e),M(qe.$$.fragment,e),M(Ee.$$.fragment,e),M(Le.$$.fragment,e),M(D.$$.fragment,e),M(Be.$$.fragment,e),M(Ze.$$.fragment,e),M(Qe.$$.fragment,e),M(Ve.$$.fragment,e),M(Xe.$$.fragment,e),M(Fe.$$.fragment,e),M(Ge.$$.fragment,e),M(Pe.$$.fragment,e),M(De.$$.fragment,e),M(O.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(Oe.$$.fragment,e),M(Ke.$$.fragment,e),M(et.$$.fragment,e),M(se.$$.fragment,e),M(tt.$$.fragment,e),M(ne.$$.fragment,e),M(le.$$.fragment,e),M(st.$$.fragment,e),M(lt.$$.fragment,e),M(oe.$$.fragment,e),M(ot.$$.fragment,e),M(at.$$.fragment,e),qs=!0)},o(e){h(J.$$.fragment,e),h(I.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(X.$$.fragment,e),h(Je.$$.fragment,e),h(F.$$.fragment,e),h(G.$$.fragment,e),h(we.$$.fragment,e),h(be.$$.fragment,e),h(Ue.$$.fragment,e),h($e.$$.fragment,e),h(H.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(xe.$$.fragment,e),h(Ae.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(Le.$$.fragment,e),h(D.$$.fragment,e),h(Be.$$.fragment,e),h(Ze.$$.fragment,e),h(Qe.$$.fragment,e),h(Ve.$$.fragment,e),h(Xe.$$.fragment,e),h(Fe.$$.fragment,e),h(Ge.$$.fragment,e),h(Pe.$$.fragment,e),h(De.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(se.$$.fragment,e),h(tt.$$.fragment,e),h(ne.$$.fragment,e),h(le.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(oe.$$.fragment,e),h(ot.$$.fragment,e),h(at.$$.fragment,e),qs=!1},d(e){e&&(s(w),s(i),s(c),s(n),s(xt),s(re),s(At),s(qt),s(Nt),s(pe),s(Et),s(me),s(Lt),s(de),s(Bt),s(ge),s(Wt),s(Zt),s(Me),s(Qt),s(Vt),s(fe),s(St),s(Rt),s(zt),s(Xt),s(v),s(Ft),s(Gt),s(Ie),s(Ht),s(je),s(Yt),s(Pt),s(Dt),s(_),s(Ot),s(Kt),s(Ce),s(es),s(ts),s(B),s(ss),s(ns),s(Ne),s(ls),s(os),s(x),s(as),s(rs),s(We),s(is),s(cs),s(V),s(ps),s(ms),s(Se),s(ds),s(Re),s(gs),s(ze),s(us),s(Ms),s(S),s(hs),s(fs),s(He),s(ys),s(Ye),s(Ts),s(Js),s(b),s(ws),s(Is),s(js),s(bs),s(Us),s(A),s($s),s(_s),s(nt),s(vs),s(Cs),s(ks),s(R),s(xs),s(As),s(kt)),s(l),f(J,e),f(I,e),f(ie,e),f(ce,e),f(ue,e),f(he,e),f(ye,e),f(Te,e),f(X,e),f(Je),f(F),f(G),f(we,e),f(be,e),f(Ue,e),f($e),f(H),f(_e),f(ve,e),f(ke,e),f(xe),f(Ae),f(qe,e),f(Ee,e),f(Le),f(D),f(Be,e),f(Ze,e),f(Qe),f(Ve,e),f(Xe,e),f(Fe),f(Ge,e),f(Pe,e),f(De),f(O),f(K),f(ee),f(te),f(Oe,e),f(Ke,e),f(et,e),f(se,e),f(tt),f(ne),f(le),f(st,e),f(lt,e),f(oe,e),f(ot),f(at,e)}}}const Ml='{"title":"Models","local":"models","sections":[{"title":"Models","local":"models","sections":[{"title":"Your custom Model","local":"your-custom-model","sections":[],"depth":3},{"title":"TransformersModel","local":"smolagents.TransformersModel","sections":[],"depth":3},{"title":"InferenceClientModel","local":"smolagents.InferenceClientModel","sections":[],"depth":3},{"title":"LiteLLMModel","local":"smolagents.LiteLLMModel","sections":[],"depth":3},{"title":"LiteLLMRouterModel","local":"smolagents.LiteLLMRouterModel","sections":[],"depth":3},{"title":"OpenAIServerModel","local":"smolagents.OpenAIServerModel","sections":[],"depth":3},{"title":"AzureOpenAIServerModel","local":"smolagents.AzureOpenAIServerModel","sections":[],"depth":3},{"title":"AmazonBedrockServerModel","local":"smolagents.AmazonBedrockServerModel","sections":[],"depth":3},{"title":"MLXModel","local":"smolagents.MLXModel","sections":[],"depth":3},{"title":"VLLMModel","local":"smolagents.VLLMModel","sections":[],"depth":3}],"depth":2}],"depth":1}';function hl(j){return Yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends Pn{constructor(l){super(),Dn(this,l,hl,ul,Hn,{})}}export{jl as component};
