import{s as Cs,n as ws,o as gs}from"../chunks/scheduler.b108d059.js";import{S as Js,i as bs,g as a,s,r,A as vs,h as o,f as l,c as i,j as Mn,u as c,x as u,k as dt,y as hn,a as n,v as p,d,t as M,w as h}from"../chunks/index.008de539.js";import{C as m}from"../chunks/CodeBlock.7b00c886.js";import{H as y,E as js}from"../chunks/getInferenceSnippets.618f977a.js";function Is(mn){let T,mt,Mt,yt,g,Tt,J,yn='Deploying Text Embeddings Inference (TEI) on Google Cloud Platform (GCP) allows to benefit from the underlying <a href="https://kubernetes.io/" rel="nofollow">Kubernetes</a> technology which ensures that TEI can scale automatically up or down based on demand.',Ut,b,Tn="On Google Cloud, there are 3 main options for deploying TEI (or any other Docker container):",ft,v,Un="<li>Cloud Run</li> <li>Vertex AI endpoints</li> <li>GKE (Google Kubernetes Engine).</li>",Ct,j,fn="This guide explains how to deploy TEI on Cloud Run, a fully managed service by Google. Cloud Run is a so-called serverless offering. This means that the server infrastructure is handled by Google, you only need to provide a Docker container. The benefit of this is that you only pay for compute when there is demand for your application. Cloud Run will automatically spin up servers when there’s demand, and scale down to zero when there is no demand.",wt,I,Cn="We will showcase how to deploy any text embedding model with or without a GPU.",gt,f,wn='<p>At the time of writing, GPU support on Cloud Run is generally available in 4 regions. If you’re interested in using it, <a href="https://cloud.google.com/run/quotas#increase" rel="nofollow">request a quota increase</a> for <code>Total Nvidia L4 GPU allocation, per project per region</code>. So far, NVIDIA L4 GPUs (24GiB VRAM) are the only available GPUs on Cloud Run; enabling automatic scaling up to 7 instances by default (more available via quota), as well as scaling down to zero instances when there are no requests.</p>',Jt,$,bt,A,gn='This guide already assumes you have set up a Google Cloud project and have enabled billing. This can be done at <a href="https://console.cloud.google.com/" rel="nofollow">https://console.cloud.google.com/</a>.',vt,V,Jn='First, you need to install the <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">gcloud CLI</a> on your local machine. This allows to programmatically interact with your Google Cloud project.',jt,E,bn="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",It,R,$t,N,vn="Some clarifications:",At,Z,jn='<li>We provide the latest official Docker image URI based on the <a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/containers/tei/README.md" rel="nofollow">README</a>.</li> <li>We choose to deploy the <a href="https://huggingface.co/ibm-granite/granite-embedding-278m-multilingual" rel="nofollow">IBM granite</a> embedding model given its strong multilingual capabilities. One can of course choose any other embedding model from the hub. It’s recommended to look for models tagged with either <code>feature-extraction</code>, <code>sentence-similarity</code> or <code>text-ranking</code>.</li>',Vt,S,In="Then you need to login into your Google Cloud account and set the project ID you want to use to deploy Cloud Run.",Et,x,Rt,L,$n="Once you are logged in, you need to enable the Cloud Run API, which is required for the Hugging Face DLC for TEI deployment on Cloud Run.",Nt,k,Zt,G,St,W,An="Once you are all set, you can call the <code>gcloud run deploy</code> command to deploy the Docker image.",xt,_,Vn="The command needs you to specify the following parameters:",Lt,Q,En='<li><code>--image</code>: The container image URI to deploy.</li> <li><code>--args</code>: The arguments to pass to the container entrypoint, being <code>text-embeddings-inference</code> for the Hugging Face DLC for TEI. Read more about the supported arguments <a href="https://huggingface.co/docs/text-embeddings-inference/cli_arguments" rel="nofollow">here</a>.<ul><li><code>--model-id</code>: The model ID to use, in this case, <a href="https://huggingface.co/ibm-granite/granite-embedding-278m-multilingual" rel="nofollow"><code>ibm-granite/granite-embedding-278m-multilingual</code></a>.</li> <li><code>--quantize</code>: The quantization method to use. If not specified, it will be retrieved from the <code>quantization_config-&gt;quant_method</code> in the <code>config.json</code> file.</li> <li><code>--max-concurrent-requests</code>: The maximum amount of concurrent requests for this particular deployment. Having a low limit will refuse clients requests instead of having them wait for too long and is usually good to handle back pressure correctly. Set to 64, but default is 128.</li></ul></li> <li><code>--port</code>: The port the container listens to.</li> <li><code>--cpu</code> and <code>--memory</code>: The number of CPUs and amount of memory to allocate to the container. Needs to be set to 4 and 16Gi (16 GiB), respectively; as that’s the minimum requirement for using the GPU.</li> <li><code>--no-cpu-throttling</code>: Disables CPU throttling, which is required for using the GPU.</li> <li><code>--gpu</code> and <code>--gpu-type</code>: The number of GPUs and the GPU type to use. Needs to be set to 1 and <code>nvidia-l4</code>, respectively; as at the time of writing this tutorial, those are the only available options as Cloud Run on GPUs.</li> <li><code>--max-instances</code>: The maximum number of instances to run, set to 3, but default maximum value is 7. Alternatively, one could set it to 1 too, but that could eventually lead to downtime during infrastructure migrations, so anything above 1 is recommended.</li> <li><code>--concurrency</code>: the maximum number of concurrent requests per instance, set to 64. Note that this value is also aligned with the <a href="https://huggingface.co/docs/text-embeddings-inference/cli_arguments" rel="nofollow"><code>--max-concurrent-requests</code></a> argument in TEI.</li> <li><code>--region</code>: The region to deploy the Cloud Run service.</li> <li><code>--no-allow-unauthenticated</code>: Disables unauthenticated access to the service, which is a good practice as adds an authentication layer managed by Google Cloud IAM.</li>',kt,U,pt,Rn='Optionally, you can include the arguments <code>--vpc-egress=all-traffic</code> and <code>--subnet=default</code>, as there is external traffic being sent to the public internet, so in order to speed the network, you need to route all traffic through the VPC network by setting those flags. Note that besides setting the flags, you need to set up Google Cloud NAT to reach the public internet, which is a paid product. Find more information in <a href="https://cloud.google.com/run/docs/configuring/networking-best-practices" rel="nofollow">Cloud Run Documentation - Networking best practices</a>.',dn,B,Gt,X,Nn="Finally, you can run the <code>gcloud run deploy</code> command to deploy TEI on Cloud Run as:",Wt,F,_t,q,Zn="If you want to deploy with a GPU, run the following command:",Qt,H,Bt,P,Sn="Or as it follows if you created the Cloud NAT:",Xt,O,Ft,C,xn="<p>The first time you deploy a new container on Cloud Run it will take around 5 minutes to deploy as it needs to import it from the Google Cloud Artifact Registry, but on the follow up deployments it will take less time as the image has been already imported before.</p>",qt,Y,Ht,D,Ln='Once deployed, you can send requests to the service via any of the supported TEI endpoints, check TEI’s <a href="https://huggingface.github.io/text-embeddings-inference/" rel="nofollow">OpenAPI Specification</a> to see all the available endpoints and their respective parameters.',Pt,z,kn="All Cloud Run services are deployed privately by default, which means that they can’t be accessed without providing authentication credentials in the request headers. These services are secured by IAM and are only callable by Project Owners, Project Editors, and Cloud Run Admins and Cloud Run Invokers.",Ot,K,Gn="In this case, a couple of alternatives to enable developer access will be showcased; while the other use cases are out of the scope of this example, as those are either not secure due to the authentication being disabled (for public access scenarios), or require additional setup for production-ready scenarios (service-to-service authentication, end-user access).",Yt,w,Wn='<p>The alternatives mentioned below are for development scenarios, and should not be used in production-ready scenarios as is. The approach below is following the guide defined in <a href="https://cloud.google.com/run/docs/authenticating/developers" rel="nofollow">Cloud Run Documentation - Authenticate Developers</a>; but you can find every other guide as mentioned above in <a href="https://cloud.google.com/run/docs/authenticating/overview" rel="nofollow">Cloud Run Documentation - Authentication overview</a>.</p>',Dt,ee,zt,te,_n="Cloud Run Proxy runs a server on localhost that proxies requests to the specified Cloud Run Service with credentials attached; which is useful for testing and experimentation.",Kt,le,el,ne,Qn="Then you can send requests to the deployed service on Cloud Run, using the http://localhost:8080 URL, with no authentication, exposed by the proxy as shown in the examples below. You can check the API docs at http://localhost:8080/docs in your browser.",tl,se,ll,ie,Bn="To send a POST request to the TEI service using cURL, you can run the following command:",nl,ae,sl,oe,Xn="Alternatively, one can also send requests to the OpenAI-compatible endpoint:",il,ue,al,re,ol,ce,Fn='To run inference using Python, you can either use the <a href="https://huggingface.co/docs/huggingface_hub/en/index" rel="nofollow">huggingface_hub</a> Python SDK (recommended) or the openai Python SDK.',ul,pe,rl,de,qn="You can install it via pip as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",cl,Me,pl,he,dl,me,Hn="You can install it via pip as <code>pip install --upgrade openai</code>, and then run:",Ml,ye,hl,Te,ml,Ue,Pn="Cloud Run Service has an unique URL assigned that can be used to send requests from anywhere, using the Google Cloud Credentials with Cloud Run Invoke access to the service; which is the recommended approach as it’s more secure and consistent than using the Cloud Run Proxy.",yl,fe,On="The URL of the Cloud Run service can be obtained via the following command (assigned to the SERVICE_URL variable for convenience):",Tl,Ce,Ul,we,Yn="Then you can send requests to the deployed service on Cloud Run, using the <code>SERVICE_URL</code> and any Google Cloud Credentials with Cloud Run Invoke access. For setting up the credentials there are multiple approaches, some of those are listed below:",fl,ge,Dn="Using the default identity token from the Google Cloud SDK:",Cl,Je,zn="<li>Via gcloud as:</li>",wl,be,gl,ve,Kn="<li>Via Python as:</li>",Jl,je,bl,Ie,es="<li>Using a Service Account with Cloud Run Invoke access, which can either be done with any of the following approaches:</li>",vl,$e,ts="<strong>Create a Service Account before the Cloud Run Service was created, and then set the service-account flag to the Service Account email when creating the Cloud Run Service. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.</strong> Create a Service Account after the Cloud Run Service was created, and then update the Cloud Run Service to use the Service Account. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.",jl,Ae,ls="The recommended approach is to use a Service Account (SA), as the access can be controlled better and the permissions are more granular; as the Cloud Run Service was not created using a SA, which is another nice option, you need to now create the SA, gran it the necessary permissions, update the Cloud Run Service to use the SA, and then generate an access token to set as the authentication token within the requests, that can be revoked later once you are done using it.",Il,Ve,ns="<li>Set the SERVICE_ACCOUNT_NAME environment variable for convenience:</li>",$l,Ee,Al,Re,ss="<li>Create the Service Account:</li>",Vl,Ne,El,Ze,is="<li>Grant the Service Account the Cloud Run Invoker role:</li>",Rl,Se,Nl,xe,as="Generate the Access Token for the Service Account:",Zl,Le,Sl,ke,os="<p>The access token is short-lived and will expire, by default after 1 hour. If you want to extend the token lifetime beyond the default, you must create and organization policy and use the —lifetime argument when creating the token. Refer to Access token lifetime to learn more. Otherwise, you can also generate a new token by running the same command again.</p>",xl,Ge,us="Now you can already dive into the different alternatives for sending the requests to the deployed Cloud Run Service using the <code>SERVICE_URL</code> AND <code>ACCESS_TOKEN</code> as described above.",Ll,We,kl,_e,rs="To send a POST request to the TEI service using cURL, you can run the following command:",Gl,Qe,Wl,Be,_l,Xe,cs='To run inference using Python, you can either use the <a href="https://huggingface.co/docs/huggingface_hub/en/index" rel="nofollow">huggingface_hub</a> Python SDK (recommended) or the openai Python SDK.',Ql,Fe,Bl,qe,ps="You can install it via pip as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",Xl,He,Fl,Pe,ql,Oe,ds="You can install it via pip as <code>pip install --upgrade openai</code>, and then run:",Hl,Ye,Pl,De,Ol,ze,Ms="Finally, once you are done using TEI on the Cloud Run Service, you can safely delete it to avoid incurring in unnecessary costs e.g. if the Cloud Run services are inadvertently invoked more times than your monthly Cloud Run invoke allocation in the free tier.",Yl,Ke,hs='To delete the Cloud Run Service you can either go to the Google Cloud Console at <a href="https://console.cloud.google.com/run" rel="nofollow">https://console.cloud.google.com/run</a> and delete it manually; or use the Google Cloud SDK via gcloud as follows:',Dl,et,zl,tt,ms="Additionally, if you followed the steps in via Cloud Run Service URL and generated a Service Account and an access token, you can either remove the Service Account, or just revoke the access token if it is still valid.",Kl,lt,ys="<li>(recommended) Revoke the Access Token as:</li>",en,nt,tn,st,Ts="<li>(optional) Delete the Service Account as:</li>",ln,it,nn,at,Us="Finally, if you decided to enable the VPC network via Cloud NAT, you can also remove the Cloud NAT (which is a paid product) as:",sn,ot,an,ut,on,rt,fs='<li><a href="https://cloud.google.com/run/docs" rel="nofollow">Cloud Run documentation - Overview</a></li> <li><a href="https://cloud.google.com/run/docs/configuring/services/gpu" rel="nofollow">Cloud Run documentation - GPU services</a></li> <li><a href="https://cloud.google.com/blog/products/application-development/run-your-ai-inference-applications-on-cloud-run-with-nvidia-gpus" rel="nofollow">Google Cloud blog - Run your AI inference applications on Cloud Run with NVIDIA GPUs</a></li>',un,ct,rn,ht,cn;return g=new y({props:{title:"Deploying TEI on Google Cloud Run",local:"deploying-tei-on-google-cloud-run",headingTag:"h1"}}),$=new y({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),R=new m({props:{code:"ZXhwb3J0JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQWV4cG9ydCUyMExPQ0FUSU9OJTNEZXVyb3BlLXdlc3QxJTIwJTIwJTIzJTIwb3IlMjBhbnklMjBsb2NhdGlvbiUyMHlvdSUyMHByZWZlciUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQuZ29vZ2xlLmNvbSUyRnJ1biUyRmRvY3MlMkZsb2NhdGlvbnMlMEFleHBvcnQlMjBDT05UQUlORVJfVVJJJTNEJTIyZ2NyLmlvJTJGZGVlcGxlYXJuaW5nLXBsYXRmb3JtLXJlbGVhc2UlMkZodWdnaW5nZmFjZS10ZXh0LWVtYmVkZGluZ3MtaW5mZXJlbmNlLWNwdS4xLTYlMjIlMEFleHBvcnQlMjBTRVJWSUNFX05BTUUlM0QlMjJ0ZXh0LWVtYmVkZGluZy1zZXJ2ZXIlMjIlMjAlMjMlMjBjaG9vc2UlMjBhJTIwbmFtZSUyMGZvciUyMHlvdXIlMjBzZXJ2aWNlJTBBZXhwb3J0JTIwTU9ERUxfSUQlM0QlMjJpYm0tZ3Jhbml0ZSUyRmdyYW5pdGUtZW1iZWRkaW5nLTI3OG0tbXVsdGlsaW5ndWFsJTIyJTIwJTIzJTIwY2hvb3NlJTIwYW55JTIwZW1iZWRkaW5nJTIwbW9kZWw=",highlighted:`<span class="hljs-built_in">export</span> PROJECT_ID=your-project-id
<span class="hljs-built_in">export</span> LOCATION=europe-west1  <span class="hljs-comment"># or any location you prefer: https://cloud.google.com/run/docs/locations</span>
<span class="hljs-built_in">export</span> CONTAINER_URI=<span class="hljs-string">&quot;gcr.io/deeplearning-platform-release/huggingface-text-embeddings-inference-cpu.1-6&quot;</span>
<span class="hljs-built_in">export</span> SERVICE_NAME=<span class="hljs-string">&quot;text-embedding-server&quot;</span> <span class="hljs-comment"># choose a name for your service</span>
<span class="hljs-built_in">export</span> MODEL_ID=<span class="hljs-string">&quot;ibm-granite/granite-embedding-278m-multilingual&quot;</span> <span class="hljs-comment"># choose any embedding model</span>`,wrap:!1}}),x=new m({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMGxvZ2luJTBBZ2Nsb3VkJTIwYXV0aCUyMGFwcGxpY2F0aW9uLWRlZmF1bHQlMjBsb2dpbiUyMCUyMCUyMyUyMEZvciUyMGxvY2FsJTIwZGV2ZWxvcG1lbnQlMEFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`gcloud auth login
gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
gcloud config <span class="hljs-built_in">set</span> project <span class="hljs-variable">$PROJECT_ID</span>`,wrap:!1}}),k=new m({props:{code:"Z2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBydW4uZ29vZ2xlYXBpcy5jb20=",highlighted:'gcloud services <span class="hljs-built_in">enable</span> run.googleapis.com',wrap:!1}}),G=new y({props:{title:"Deploy TEI on Cloud Run",local:"deploy-tei-on-cloud-run",headingTag:"h2"}}),B=new m({props:{code:"Z2Nsb3VkJTIwY29tcHV0ZSUyMHJvdXRlcnMlMjBjcmVhdGUlMjBuYXQtcm91dGVyJTIwLS1uZXR3b3JrJTNEZGVmYXVsdCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMEFnY2xvdWQlMjBjb21wdXRlJTIwcm91dGVycyUyMG5hdHMlMjBjcmVhdGUlMjB2bS1uYXQlMjAtLXJvdXRlciUzRG5hdC1yb3V0ZXIlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9OJTIwLS1hdXRvLWFsbG9jYXRlLW5hdC1leHRlcm5hbC1pcHMlMjAtLW5hdC1hbGwtc3VibmV0LWlwLXJhbmdlcw==",highlighted:`gcloud compute routers create nat-router --network=default --region=<span class="hljs-variable">$LOCATION</span>
gcloud compute routers nats create vm-nat --router=nat-router --region=<span class="hljs-variable">$LOCATION</span> --auto-allocate-nat-external-ips --nat-all-subnet-ip-ranges`,wrap:!1}}),F=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwZGVwbG95JTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1pbWFnZSUzRCUyNENPTlRBSU5FUl9VUkklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWFyZ3MlM0QlMjItLW1vZGVsLWlkJTNEJTI0TU9ERUxfSUQlMkMtLW1heC1jb25jdXJyZW50LXJlcXVlc3RzJTNENjQlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNldC1lbnYtdmFycyUzREhGX0hVQl9FTkFCTEVfSEZfVFJBTlNGRVIlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wb3J0JTNEODA4MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1JTNEOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtb3J5JTNEMzJHaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWFsbG93LXVuYXV0aGVudGljYXRlZA==",highlighted:`gcloud run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=<span class="hljs-variable">$MODEL_ID</span>,--max-concurrent-requests=64&quot;</span> \\
    --set-env-vars=HF_HUB_ENABLE_HF_TRANSFER=1 \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated`,wrap:!1}}),H=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwZGVwbG95JTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1pbWFnZSUzRCUyNENPTlRBSU5FUl9VUkklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWFyZ3MlM0QlMjItLW1vZGVsLWlkJTNEJTI0TU9ERUxfSUQlMkMtLW1heC1jb25jdXJyZW50LXJlcXVlc3RzJTNENjQlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNldC1lbnYtdmFycyUzREhGX0hVQl9FTkFCTEVfSEZfVFJBTlNGRVIlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wb3J0JTNEODA4MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1JTNEOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtb3J5JTNEMzJHaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbm8tY3B1LXRocm90dGxpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdSUzRDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdS10eXBlJTNEbnZpZGlhLWw0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXgtaW5zdGFuY2VzJTNEMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY29uY3VycmVuY3klM0Q2NCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWFsbG93LXVuYXV0aGVudGljYXRlZA==",highlighted:`gcloud run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=<span class="hljs-variable">$MODEL_ID</span>,--max-concurrent-requests=64&quot;</span> \\
    --set-env-vars=HF_HUB_ENABLE_HF_TRANSFER=1 \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --no-cpu-throttling \\
    --gpu=1 \\
    --gpu-type=nvidia-l4 \\
    --max-instances=3 \\
    --concurrency=64 \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated`,wrap:!1}}),O=new m({props:{code:"Z2Nsb3VkJTIwYmV0YSUyMHJ1biUyMGRlcGxveSUyMCUyNFNFUlZJQ0VfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taW1hZ2UlM0QlMjRDT05UQUlORVJfVVJJJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1hcmdzJTNEJTIyLS1tb2RlbC1pZCUzRCUyNE1PREVMX0lEJTJDLS1tYXgtY29uY3VycmVudC1yZXF1ZXN0cyUzRDY0JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZXQtZW52LXZhcnMlM0RIRl9IVUJfRU5BQkxFX0hGX1RSQU5TRkVSJTNEMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcG9ydCUzRDgwODAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNwdSUzRDglMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1lbW9yeSUzRDMyR2klMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWNwdS10aHJvdHRsaW5nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncHUlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncHUtdHlwZSUzRG52aWRpYS1sNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4LWluc3RhbmNlcyUzRDMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNvbmN1cnJlbmN5JTNENjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9OJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1uby1hbGxvdy11bmF1dGhlbnRpY2F0ZWQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXZwYy1lZ3Jlc3MlM0RhbGwtdHJhZmZpYyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc3VibmV0JTNEZGVmYXVsdA==",highlighted:`gcloud beta run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=<span class="hljs-variable">$MODEL_ID</span>,--max-concurrent-requests=64&quot;</span> \\
    --set-env-vars=HF_HUB_ENABLE_HF_TRANSFER=1 \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --no-cpu-throttling \\
    --gpu=1 \\
    --gpu-type=nvidia-l4 \\
    --max-instances=3 \\
    --concurrency=64 \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated \\
    --vpc-egress=all-traffic \\
    --subnet=default`,wrap:!1}}),Y=new y({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ee=new y({props:{title:"Via Cloud Run Proxy",local:"via-cloud-run-proxy",headingTag:"h3"}}),le=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBwcm94eSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04=",highlighted:'gcloud run services proxy <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),se=new y({props:{title:"cURL",local:"curl",headingTag:"h4"}}),ae=new m({props:{code:"Y3VybCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGZW1iZWQlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0ZWklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTdEJw==",highlighted:`curl http://localhost:8080/embed \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tei&quot;,
        &quot;text&quot;: &quot;What is deep learning?&quot;
    }&#x27;</span>`,wrap:!1}}),ue=new m({props:{code:"Y3VybCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkZlbWJlZGRpbmdzJTIwJTVDJTBBJTIwJTIwJTIwJTIwLVglMjBQT1NUJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGVpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCc=",highlighted:`curl http://localhost:8080/v1/embeddings \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tei&quot;,
        &quot;text&quot;: &quot;What is deep learning?&quot;
    }&#x27;</span>`,wrap:!1}}),re=new y({props:{title:"Python",local:"python",headingTag:"h4"}}),pe=new y({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),Me=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBZW1iZWRkaW5nJTIwJTNEJTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGZW1iZWQlMjIpJTBBcHJpbnQobGVuKGVtYmVkZGluZyU1QjAlNUQpKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient()
embedding = client.feature_extraction(<span class="hljs-string">&quot;What is deep learning?&quot;</span>,
                                      model=<span class="hljs-string">&quot;http://localhost:8080/embed&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(embedding[<span class="hljs-number">0</span>]))`,wrap:!1}}),he=new y({props:{title:"OpenAI",local:"openai",headingTag:"h4"}}),ye=new m({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSShiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkZlbWJlZGRpbmdzJTIyJTJDJTIwYXBpX2tleSUzRCUyMiUyMiklMEElMEFyZXNwb25zZSUyMCUzRCUyMGNsaWVudC5lbWJlZGRpbmdzLmNyZWF0ZSglMEElMjAlMjBtb2RlbCUzRCUyMnRlaSUyMiUyQyUwQSUyMCUyMGlucHV0JTNEJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBKSUwQSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(base_url=<span class="hljs-string">&quot;http://localhost:8080/v1/embeddings&quot;</span>, api_key=<span class="hljs-string">&quot;&quot;</span>)

response = client.embeddings.create(
  model=<span class="hljs-string">&quot;tei&quot;</span>,
  <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;What is deep learning?&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),Te=new y({props:{title:"(recommended) Via Cloud Run Service URL",local:"recommended-via-cloud-run-service-url",headingTag:"h3"}}),Ce=new m({props:{code:"U0VSVklDRV9VUkwlM0QlMjQoZ2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZXNjcmliZSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04lMjAtLWZvcm1hdCUyMCd2YWx1ZShzdGF0dXMudXJsKScp",highlighted:'SERVICE_URL=$(gcloud run services describe <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span> --format <span class="hljs-string">&#x27;value(status.url)&#x27;</span>)',wrap:!1}}),be=new m({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHByaW50LWlkZW50aXR5LXRva2Vu",highlighted:"gcloud auth print-identity-token",wrap:!1}}),je=new m({props:{code:"aW1wb3J0JTIwZ29vZ2xlLmF1dGglMEFmcm9tJTIwZ29vZ2xlLmF1dGgudHJhbnNwb3J0LnJlcXVlc3RzJTIwaW1wb3J0JTIwUmVxdWVzdCUyMGFzJTIwR29vZ2xlQXV0aFJlcXVlc3QlMEElMEFhdXRoX3JlcSUyMCUzRCUyMEdvb2dsZUF1dGhSZXF1ZXN0KCklMEFjcmVkcyUyQyUyMF8lMjAlM0QlMjBnb29nbGUuYXV0aC5kZWZhdWx0KCklMEFjcmVkcy5yZWZyZXNoKGF1dGhfcmVxKSUwQSUwQWlkX3Rva2VuJTIwJTNEJTIwY3JlZHMuaWRfdG9rZW4=",highlighted:`import google.auth
from google.auth.transport.requests import Request as GoogleAuthRequest

auth_req = GoogleAuthRequest()
creds, _ = google.auth.default()
creds.refresh(auth_req)

id_token = creds.id_token`,wrap:!1}}),Ee=new m({props:{code:"ZXhwb3J0JTIwU0VSVklDRV9BQ0NPVU5UX05BTUUlM0R0ZWktaW52b2tlcg==",highlighted:'<span class="hljs-built_in">export</span> SERVICE_ACCOUNT_NAME=tei-invoker',wrap:!1}}),Ne=new m({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGNyZWF0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1F",highlighted:'gcloud iam service-accounts create <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>',wrap:!1}}),Se=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBhZGQtaWFtLXBvbGljeS1iaW5kaW5nJTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tZW1iZXIlM0QlMjJzZXJ2aWNlQWNjb3VudCUzQSUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9sZSUzRCUyMnJvbGVzJTJGcnVuLmludm9rZXIlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9O",highlighted:`gcloud run services add-iam-policy-binding <span class="hljs-variable">$SERVICE_NAME</span> \\
    --member=<span class="hljs-string">&quot;serviceAccount:<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com&quot;</span> \\
    --role=<span class="hljs-string">&quot;roles/run.invoker&quot;</span> \\
    --region=<span class="hljs-variable">$LOCATION</span>`,wrap:!1}}),Le=new m({props:{code:"ZXhwb3J0JTIwQUNDRVNTX1RPS0VOJTNEJTI0KGdjbG91ZCUyMGF1dGglMjBwcmludC1hY2Nlc3MtdG9rZW4lMjAtLWltcGVyc29uYXRlLXNlcnZpY2UtYWNjb3VudCUzRCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSk=",highlighted:'<span class="hljs-built_in">export</span> ACCESS_TOKEN=$(gcloud auth print-access-token --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com)',wrap:!1}}),We=new y({props:{title:"cURL",local:"curl",headingTag:"h4"}}),Qe=new m({props:{code:"Y3VybCUyMCUyNFNFUlZJQ0VfVVJMJTJGdjElMkZlbWJlZGRpZ3MlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMkF1dGhvcml6YXRpb24lM0ElMjBCZWFyZXIlMjAlMjRBQ0NFU1NfVE9LRU4lMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0ZWklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTdEJw==",highlighted:`curl <span class="hljs-variable">$SERVICE_URL</span>/v1/embeddigs \\
    -X POST \\
    -H <span class="hljs-string">&quot;Authorization: Bearer <span class="hljs-variable">$ACCESS_TOKEN</span>&quot;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tei&quot;,
        &quot;text&quot;: &quot;What is deep learning?&quot;
    }&#x27;</span>`,wrap:!1}}),Be=new y({props:{title:"Python",local:"python",headingTag:"h4"}}),Fe=new y({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),He=new m({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFlbWJlZGRpbmclMjAlM0QlMjBjbGllbnQuZmVhdHVyZV9leHRyYWN0aW9uKCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTgwODAlMkZlbWJlZCUyMiklMEFwcmludChsZW4oZW1iZWRkaW5nJTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

embedding = client.feature_extraction(<span class="hljs-string">&quot;What is deep learning?&quot;</span>,
                                      model=<span class="hljs-string">&quot;http://localhost:8080/embed&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(embedding[<span class="hljs-number">0</span>]))`,wrap:!1}}),Pe=new y({props:{title:"OpenAI",local:"openai",headingTag:"h4"}}),Ye=new m({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFyZXNwb25zZSUyMCUzRCUyMGNsaWVudC5lbWJlZGRpbmdzLmNyZWF0ZSglMEElMjAlMjBtb2RlbCUzRCUyMnRlaSUyMiUyQyUwQSUyMCUyMGlucHV0JTNEJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBKSUwQSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

response = client.embeddings.create(
  model=<span class="hljs-string">&quot;tei&quot;</span>,
  <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;What is deep learning?&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),De=new y({props:{title:"Resource clean up",local:"resource-clean-up",headingTag:"h2"}}),et=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZWxldGUlMjAlMjRTRVJWSUNFX05BTUUlMjAtLXJlZ2lvbiUyMCUyNExPQ0FUSU9O",highlighted:'gcloud run services delete <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),nt=new m({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHJldm9rZSUyMC0taW1wZXJzb25hdGUtc2VydmljZS1hY2NvdW50JTNEJTI0U0VSVklDRV9BQ0NPVU5UX05BTUUlNDAlMjRQUk9KRUNUX0lELmlhbS5nc2VydmljZWFjY291bnQuY29t",highlighted:'gcloud auth revoke --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),it=new m({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGRlbGV0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbQ==",highlighted:'gcloud iam service-accounts delete <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),ot=new m({props:{code:"Z2Nsb3VkJTIwY29tcHV0ZSUyMHJvdXRlcnMlMjBuYXRzJTIwZGVsZXRlJTIwdm0tbmF0JTIwLS1yb3V0ZXIlM0RuYXQtcm91dGVyJTIwLS1yZWdpb24lM0QlMjRMT0NBVElPTiUwQWdjbG91ZCUyMGNvbXB1dGUlMjByb3V0ZXJzJTIwZGVsZXRlJTIwbmF0LXJvdXRlciUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04=",highlighted:`gcloud compute routers nats delete vm-nat --router=nat-router --region=<span class="hljs-variable">$LOCATION</span>
gcloud compute routers delete nat-router --region=<span class="hljs-variable">$LOCATION</span>`,wrap:!1}}),ut=new y({props:{title:"References",local:"references",headingTag:"h2"}}),ct=new js({props:{source:"https://github.com/huggingface/text-embeddings-inference/blob/main/docs/source/en/tei_cloud_run.md"}}),{c(){T=a("meta"),mt=s(),Mt=a("p"),yt=s(),r(g.$$.fragment),Tt=s(),J=a("p"),J.innerHTML=yn,Ut=s(),b=a("p"),b.textContent=Tn,ft=s(),v=a("ul"),v.innerHTML=Un,Ct=s(),j=a("p"),j.textContent=fn,wt=s(),I=a("p"),I.textContent=Cn,gt=s(),f=a("blockquote"),f.innerHTML=wn,Jt=s(),r($.$$.fragment),bt=s(),A=a("p"),A.innerHTML=gn,vt=s(),V=a("p"),V.innerHTML=Jn,jt=s(),E=a("p"),E.textContent=bn,It=s(),r(R.$$.fragment),$t=s(),N=a("p"),N.textContent=vn,At=s(),Z=a("ul"),Z.innerHTML=jn,Vt=s(),S=a("p"),S.textContent=In,Et=s(),r(x.$$.fragment),Rt=s(),L=a("p"),L.textContent=$n,Nt=s(),r(k.$$.fragment),Zt=s(),r(G.$$.fragment),St=s(),W=a("p"),W.innerHTML=An,xt=s(),_=a("p"),_.textContent=Vn,Lt=s(),Q=a("ul"),Q.innerHTML=En,kt=s(),U=a("blockquote"),pt=a("p"),pt.innerHTML=Rn,dn=s(),r(B.$$.fragment),Gt=s(),X=a("p"),X.innerHTML=Nn,Wt=s(),r(F.$$.fragment),_t=s(),q=a("p"),q.textContent=Zn,Qt=s(),r(H.$$.fragment),Bt=s(),P=a("p"),P.textContent=Sn,Xt=s(),r(O.$$.fragment),Ft=s(),C=a("blockquote"),C.innerHTML=xn,qt=s(),r(Y.$$.fragment),Ht=s(),D=a("p"),D.innerHTML=Ln,Pt=s(),z=a("p"),z.textContent=kn,Ot=s(),K=a("p"),K.textContent=Gn,Yt=s(),w=a("blockquote"),w.innerHTML=Wn,Dt=s(),r(ee.$$.fragment),zt=s(),te=a("p"),te.textContent=_n,Kt=s(),r(le.$$.fragment),el=s(),ne=a("p"),ne.textContent=Qn,tl=s(),r(se.$$.fragment),ll=s(),ie=a("p"),ie.textContent=Bn,nl=s(),r(ae.$$.fragment),sl=s(),oe=a("p"),oe.textContent=Xn,il=s(),r(ue.$$.fragment),al=s(),r(re.$$.fragment),ol=s(),ce=a("p"),ce.innerHTML=Fn,ul=s(),r(pe.$$.fragment),rl=s(),de=a("p"),de.innerHTML=qn,cl=s(),r(Me.$$.fragment),pl=s(),r(he.$$.fragment),dl=s(),me=a("p"),me.innerHTML=Hn,Ml=s(),r(ye.$$.fragment),hl=s(),r(Te.$$.fragment),ml=s(),Ue=a("p"),Ue.textContent=Pn,yl=s(),fe=a("p"),fe.textContent=On,Tl=s(),r(Ce.$$.fragment),Ul=s(),we=a("p"),we.innerHTML=Yn,fl=s(),ge=a("p"),ge.textContent=Dn,Cl=s(),Je=a("ul"),Je.innerHTML=zn,wl=s(),r(be.$$.fragment),gl=s(),ve=a("ul"),ve.innerHTML=Kn,Jl=s(),r(je.$$.fragment),bl=s(),Ie=a("ul"),Ie.innerHTML=es,vl=s(),$e=a("p"),$e.innerHTML=ts,jl=s(),Ae=a("p"),Ae.textContent=ls,Il=s(),Ve=a("ul"),Ve.innerHTML=ns,$l=s(),r(Ee.$$.fragment),Al=s(),Re=a("ul"),Re.innerHTML=ss,Vl=s(),r(Ne.$$.fragment),El=s(),Ze=a("ul"),Ze.innerHTML=is,Rl=s(),r(Se.$$.fragment),Nl=s(),xe=a("p"),xe.textContent=as,Zl=s(),r(Le.$$.fragment),Sl=s(),ke=a("blockquote"),ke.innerHTML=os,xl=s(),Ge=a("p"),Ge.innerHTML=us,Ll=s(),r(We.$$.fragment),kl=s(),_e=a("p"),_e.textContent=rs,Gl=s(),r(Qe.$$.fragment),Wl=s(),r(Be.$$.fragment),_l=s(),Xe=a("p"),Xe.innerHTML=cs,Ql=s(),r(Fe.$$.fragment),Bl=s(),qe=a("p"),qe.innerHTML=ps,Xl=s(),r(He.$$.fragment),Fl=s(),r(Pe.$$.fragment),ql=s(),Oe=a("p"),Oe.innerHTML=ds,Hl=s(),r(Ye.$$.fragment),Pl=s(),r(De.$$.fragment),Ol=s(),ze=a("p"),ze.textContent=Ms,Yl=s(),Ke=a("p"),Ke.innerHTML=hs,Dl=s(),r(et.$$.fragment),zl=s(),tt=a("p"),tt.textContent=ms,Kl=s(),lt=a("ul"),lt.innerHTML=ys,en=s(),r(nt.$$.fragment),tn=s(),st=a("ul"),st.innerHTML=Ts,ln=s(),r(it.$$.fragment),nn=s(),at=a("p"),at.textContent=Us,sn=s(),r(ot.$$.fragment),an=s(),r(ut.$$.fragment),on=s(),rt=a("ul"),rt.innerHTML=fs,un=s(),r(ct.$$.fragment),rn=s(),ht=a("p"),this.h()},l(e){const t=vs("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),mt=i(e),Mt=o(e,"P",{}),Mn(Mt).forEach(l),yt=i(e),c(g.$$.fragment,e),Tt=i(e),J=o(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-1jywelx"&&(J.innerHTML=yn),Ut=i(e),b=o(e,"P",{"data-svelte-h":!0}),u(b)!=="svelte-kstn30"&&(b.textContent=Tn),ft=i(e),v=o(e,"UL",{"data-svelte-h":!0}),u(v)!=="svelte-1ri0d6u"&&(v.innerHTML=Un),Ct=i(e),j=o(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-jq2f1f"&&(j.textContent=fn),wt=i(e),I=o(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1kwnf1q"&&(I.textContent=Cn),gt=i(e),f=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(f)!=="svelte-1j7knwx"&&(f.innerHTML=wn),Jt=i(e),c($.$$.fragment,e),bt=i(e),A=o(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-9iv4wv"&&(A.innerHTML=gn),vt=i(e),V=o(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-p3n1a9"&&(V.innerHTML=Jn),jt=i(e),E=o(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1i8n6rq"&&(E.textContent=bn),It=i(e),c(R.$$.fragment,e),$t=i(e),N=o(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-12btpyf"&&(N.textContent=vn),At=i(e),Z=o(e,"UL",{"data-svelte-h":!0}),u(Z)!=="svelte-1pcxftj"&&(Z.innerHTML=jn),Vt=i(e),S=o(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-pfbeqd"&&(S.textContent=In),Et=i(e),c(x.$$.fragment,e),Rt=i(e),L=o(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-13jr0pj"&&(L.textContent=$n),Nt=i(e),c(k.$$.fragment,e),Zt=i(e),c(G.$$.fragment,e),St=i(e),W=o(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1aiwb7r"&&(W.innerHTML=An),xt=i(e),_=o(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1f5ji1s"&&(_.textContent=Vn),Lt=i(e),Q=o(e,"UL",{"data-svelte-h":!0}),u(Q)!=="svelte-1loprp1"&&(Q.innerHTML=En),kt=i(e),U=o(e,"BLOCKQUOTE",{class:!0});var pn=Mn(U);pt=o(pn,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-1o1t3au"&&(pt.innerHTML=Rn),dn=i(pn),c(B.$$.fragment,pn),pn.forEach(l),Gt=i(e),X=o(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-wzi9ad"&&(X.innerHTML=Nn),Wt=i(e),c(F.$$.fragment,e),_t=i(e),q=o(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-cltr6v"&&(q.textContent=Zn),Qt=i(e),c(H.$$.fragment,e),Bt=i(e),P=o(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-vtd23h"&&(P.textContent=Sn),Xt=i(e),c(O.$$.fragment,e),Ft=i(e),C=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(C)!=="svelte-zk4klx"&&(C.innerHTML=xn),qt=i(e),c(Y.$$.fragment,e),Ht=i(e),D=o(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-12bs2xr"&&(D.innerHTML=Ln),Pt=i(e),z=o(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1gzo66i"&&(z.textContent=kn),Ot=i(e),K=o(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-8buc6k"&&(K.textContent=Gn),Yt=i(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(w)!=="svelte-yzbjnr"&&(w.innerHTML=Wn),Dt=i(e),c(ee.$$.fragment,e),zt=i(e),te=o(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1n42sxg"&&(te.textContent=_n),Kt=i(e),c(le.$$.fragment,e),el=i(e),ne=o(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1wqv6zg"&&(ne.textContent=Qn),tl=i(e),c(se.$$.fragment,e),ll=i(e),ie=o(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-1je3wgp"&&(ie.textContent=Bn),nl=i(e),c(ae.$$.fragment,e),sl=i(e),oe=o(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-7nrnml"&&(oe.textContent=Xn),il=i(e),c(ue.$$.fragment,e),al=i(e),c(re.$$.fragment,e),ol=i(e),ce=o(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-h8hgtx"&&(ce.innerHTML=Fn),ul=i(e),c(pe.$$.fragment,e),rl=i(e),de=o(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-1pmfr0a"&&(de.innerHTML=qn),cl=i(e),c(Me.$$.fragment,e),pl=i(e),c(he.$$.fragment,e),dl=i(e),me=o(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-17lqblq"&&(me.innerHTML=Hn),Ml=i(e),c(ye.$$.fragment,e),hl=i(e),c(Te.$$.fragment,e),ml=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1o5h253"&&(Ue.textContent=Pn),yl=i(e),fe=o(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-govem3"&&(fe.textContent=On),Tl=i(e),c(Ce.$$.fragment,e),Ul=i(e),we=o(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-niuemd"&&(we.innerHTML=Yn),fl=i(e),ge=o(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-4rg0sg"&&(ge.textContent=Dn),Cl=i(e),Je=o(e,"UL",{"data-svelte-h":!0}),u(Je)!=="svelte-h09l2v"&&(Je.innerHTML=zn),wl=i(e),c(be.$$.fragment,e),gl=i(e),ve=o(e,"UL",{"data-svelte-h":!0}),u(ve)!=="svelte-b6nbfv"&&(ve.innerHTML=Kn),Jl=i(e),c(je.$$.fragment,e),bl=i(e),Ie=o(e,"UL",{"data-svelte-h":!0}),u(Ie)!=="svelte-93kat8"&&(Ie.innerHTML=es),vl=i(e),$e=o(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-1hrh7sd"&&($e.innerHTML=ts),jl=i(e),Ae=o(e,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-18iwnqm"&&(Ae.textContent=ls),Il=i(e),Ve=o(e,"UL",{"data-svelte-h":!0}),u(Ve)!=="svelte-1v8yusc"&&(Ve.innerHTML=ns),$l=i(e),c(Ee.$$.fragment,e),Al=i(e),Re=o(e,"UL",{"data-svelte-h":!0}),u(Re)!=="svelte-1e2np3q"&&(Re.innerHTML=ss),Vl=i(e),c(Ne.$$.fragment,e),El=i(e),Ze=o(e,"UL",{"data-svelte-h":!0}),u(Ze)!=="svelte-m7ycff"&&(Ze.innerHTML=is),Rl=i(e),c(Se.$$.fragment,e),Nl=i(e),xe=o(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-v6tnr5"&&(xe.textContent=as),Zl=i(e),c(Le.$$.fragment,e),Sl=i(e),ke=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(ke)!=="svelte-dmerw2"&&(ke.innerHTML=os),xl=i(e),Ge=o(e,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-ur1pan"&&(Ge.innerHTML=us),Ll=i(e),c(We.$$.fragment,e),kl=i(e),_e=o(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1je3wgp"&&(_e.textContent=rs),Gl=i(e),c(Qe.$$.fragment,e),Wl=i(e),c(Be.$$.fragment,e),_l=i(e),Xe=o(e,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-h8hgtx"&&(Xe.innerHTML=cs),Ql=i(e),c(Fe.$$.fragment,e),Bl=i(e),qe=o(e,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-1pmfr0a"&&(qe.innerHTML=ps),Xl=i(e),c(He.$$.fragment,e),Fl=i(e),c(Pe.$$.fragment,e),ql=i(e),Oe=o(e,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-17lqblq"&&(Oe.innerHTML=ds),Hl=i(e),c(Ye.$$.fragment,e),Pl=i(e),c(De.$$.fragment,e),Ol=i(e),ze=o(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-8fqmhw"&&(ze.textContent=Ms),Yl=i(e),Ke=o(e,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-1stcxhv"&&(Ke.innerHTML=hs),Dl=i(e),c(et.$$.fragment,e),zl=i(e),tt=o(e,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-1umuozh"&&(tt.textContent=ms),Kl=i(e),lt=o(e,"UL",{"data-svelte-h":!0}),u(lt)!=="svelte-uuoqil"&&(lt.innerHTML=ys),en=i(e),c(nt.$$.fragment,e),tn=i(e),st=o(e,"UL",{"data-svelte-h":!0}),u(st)!=="svelte-1toh59e"&&(st.innerHTML=Ts),ln=i(e),c(it.$$.fragment,e),nn=i(e),at=o(e,"P",{"data-svelte-h":!0}),u(at)!=="svelte-1xv6mwy"&&(at.textContent=Us),sn=i(e),c(ot.$$.fragment,e),an=i(e),c(ut.$$.fragment,e),on=i(e),rt=o(e,"UL",{"data-svelte-h":!0}),u(rt)!=="svelte-1i59rl0"&&(rt.innerHTML=fs),un=i(e),c(ct.$$.fragment,e),rn=i(e),ht=o(e,"P",{}),Mn(ht).forEach(l),this.h()},h(){dt(T,"name","hf:doc:metadata"),dt(T,"content",$s),dt(f,"class","note"),dt(U,"class","note"),dt(C,"class","note"),dt(w,"class","note")},m(e,t){hn(document.head,T),n(e,mt,t),n(e,Mt,t),n(e,yt,t),p(g,e,t),n(e,Tt,t),n(e,J,t),n(e,Ut,t),n(e,b,t),n(e,ft,t),n(e,v,t),n(e,Ct,t),n(e,j,t),n(e,wt,t),n(e,I,t),n(e,gt,t),n(e,f,t),n(e,Jt,t),p($,e,t),n(e,bt,t),n(e,A,t),n(e,vt,t),n(e,V,t),n(e,jt,t),n(e,E,t),n(e,It,t),p(R,e,t),n(e,$t,t),n(e,N,t),n(e,At,t),n(e,Z,t),n(e,Vt,t),n(e,S,t),n(e,Et,t),p(x,e,t),n(e,Rt,t),n(e,L,t),n(e,Nt,t),p(k,e,t),n(e,Zt,t),p(G,e,t),n(e,St,t),n(e,W,t),n(e,xt,t),n(e,_,t),n(e,Lt,t),n(e,Q,t),n(e,kt,t),n(e,U,t),hn(U,pt),hn(U,dn),p(B,U,null),n(e,Gt,t),n(e,X,t),n(e,Wt,t),p(F,e,t),n(e,_t,t),n(e,q,t),n(e,Qt,t),p(H,e,t),n(e,Bt,t),n(e,P,t),n(e,Xt,t),p(O,e,t),n(e,Ft,t),n(e,C,t),n(e,qt,t),p(Y,e,t),n(e,Ht,t),n(e,D,t),n(e,Pt,t),n(e,z,t),n(e,Ot,t),n(e,K,t),n(e,Yt,t),n(e,w,t),n(e,Dt,t),p(ee,e,t),n(e,zt,t),n(e,te,t),n(e,Kt,t),p(le,e,t),n(e,el,t),n(e,ne,t),n(e,tl,t),p(se,e,t),n(e,ll,t),n(e,ie,t),n(e,nl,t),p(ae,e,t),n(e,sl,t),n(e,oe,t),n(e,il,t),p(ue,e,t),n(e,al,t),p(re,e,t),n(e,ol,t),n(e,ce,t),n(e,ul,t),p(pe,e,t),n(e,rl,t),n(e,de,t),n(e,cl,t),p(Me,e,t),n(e,pl,t),p(he,e,t),n(e,dl,t),n(e,me,t),n(e,Ml,t),p(ye,e,t),n(e,hl,t),p(Te,e,t),n(e,ml,t),n(e,Ue,t),n(e,yl,t),n(e,fe,t),n(e,Tl,t),p(Ce,e,t),n(e,Ul,t),n(e,we,t),n(e,fl,t),n(e,ge,t),n(e,Cl,t),n(e,Je,t),n(e,wl,t),p(be,e,t),n(e,gl,t),n(e,ve,t),n(e,Jl,t),p(je,e,t),n(e,bl,t),n(e,Ie,t),n(e,vl,t),n(e,$e,t),n(e,jl,t),n(e,Ae,t),n(e,Il,t),n(e,Ve,t),n(e,$l,t),p(Ee,e,t),n(e,Al,t),n(e,Re,t),n(e,Vl,t),p(Ne,e,t),n(e,El,t),n(e,Ze,t),n(e,Rl,t),p(Se,e,t),n(e,Nl,t),n(e,xe,t),n(e,Zl,t),p(Le,e,t),n(e,Sl,t),n(e,ke,t),n(e,xl,t),n(e,Ge,t),n(e,Ll,t),p(We,e,t),n(e,kl,t),n(e,_e,t),n(e,Gl,t),p(Qe,e,t),n(e,Wl,t),p(Be,e,t),n(e,_l,t),n(e,Xe,t),n(e,Ql,t),p(Fe,e,t),n(e,Bl,t),n(e,qe,t),n(e,Xl,t),p(He,e,t),n(e,Fl,t),p(Pe,e,t),n(e,ql,t),n(e,Oe,t),n(e,Hl,t),p(Ye,e,t),n(e,Pl,t),p(De,e,t),n(e,Ol,t),n(e,ze,t),n(e,Yl,t),n(e,Ke,t),n(e,Dl,t),p(et,e,t),n(e,zl,t),n(e,tt,t),n(e,Kl,t),n(e,lt,t),n(e,en,t),p(nt,e,t),n(e,tn,t),n(e,st,t),n(e,ln,t),p(it,e,t),n(e,nn,t),n(e,at,t),n(e,sn,t),p(ot,e,t),n(e,an,t),p(ut,e,t),n(e,on,t),n(e,rt,t),n(e,un,t),p(ct,e,t),n(e,rn,t),n(e,ht,t),cn=!0},p:ws,i(e){cn||(d(g.$$.fragment,e),d($.$$.fragment,e),d(R.$$.fragment,e),d(x.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(O.$$.fragment,e),d(Y.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(ue.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),d(he.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(Ce.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(Ee.$$.fragment,e),d(Ne.$$.fragment,e),d(Se.$$.fragment,e),d(Le.$$.fragment,e),d(We.$$.fragment,e),d(Qe.$$.fragment,e),d(Be.$$.fragment,e),d(Fe.$$.fragment,e),d(He.$$.fragment,e),d(Pe.$$.fragment,e),d(Ye.$$.fragment,e),d(De.$$.fragment,e),d(et.$$.fragment,e),d(nt.$$.fragment,e),d(it.$$.fragment,e),d(ot.$$.fragment,e),d(ut.$$.fragment,e),d(ct.$$.fragment,e),cn=!0)},o(e){M(g.$$.fragment,e),M($.$$.fragment,e),M(R.$$.fragment,e),M(x.$$.fragment,e),M(k.$$.fragment,e),M(G.$$.fragment,e),M(B.$$.fragment,e),M(F.$$.fragment,e),M(H.$$.fragment,e),M(O.$$.fragment,e),M(Y.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(ue.$$.fragment,e),M(re.$$.fragment,e),M(pe.$$.fragment,e),M(Me.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(Te.$$.fragment,e),M(Ce.$$.fragment,e),M(be.$$.fragment,e),M(je.$$.fragment,e),M(Ee.$$.fragment,e),M(Ne.$$.fragment,e),M(Se.$$.fragment,e),M(Le.$$.fragment,e),M(We.$$.fragment,e),M(Qe.$$.fragment,e),M(Be.$$.fragment,e),M(Fe.$$.fragment,e),M(He.$$.fragment,e),M(Pe.$$.fragment,e),M(Ye.$$.fragment,e),M(De.$$.fragment,e),M(et.$$.fragment,e),M(nt.$$.fragment,e),M(it.$$.fragment,e),M(ot.$$.fragment,e),M(ut.$$.fragment,e),M(ct.$$.fragment,e),cn=!1},d(e){e&&(l(mt),l(Mt),l(yt),l(Tt),l(J),l(Ut),l(b),l(ft),l(v),l(Ct),l(j),l(wt),l(I),l(gt),l(f),l(Jt),l(bt),l(A),l(vt),l(V),l(jt),l(E),l(It),l($t),l(N),l(At),l(Z),l(Vt),l(S),l(Et),l(Rt),l(L),l(Nt),l(Zt),l(St),l(W),l(xt),l(_),l(Lt),l(Q),l(kt),l(U),l(Gt),l(X),l(Wt),l(_t),l(q),l(Qt),l(Bt),l(P),l(Xt),l(Ft),l(C),l(qt),l(Ht),l(D),l(Pt),l(z),l(Ot),l(K),l(Yt),l(w),l(Dt),l(zt),l(te),l(Kt),l(el),l(ne),l(tl),l(ll),l(ie),l(nl),l(sl),l(oe),l(il),l(al),l(ol),l(ce),l(ul),l(rl),l(de),l(cl),l(pl),l(dl),l(me),l(Ml),l(hl),l(ml),l(Ue),l(yl),l(fe),l(Tl),l(Ul),l(we),l(fl),l(ge),l(Cl),l(Je),l(wl),l(gl),l(ve),l(Jl),l(bl),l(Ie),l(vl),l($e),l(jl),l(Ae),l(Il),l(Ve),l($l),l(Al),l(Re),l(Vl),l(El),l(Ze),l(Rl),l(Nl),l(xe),l(Zl),l(Sl),l(ke),l(xl),l(Ge),l(Ll),l(kl),l(_e),l(Gl),l(Wl),l(_l),l(Xe),l(Ql),l(Bl),l(qe),l(Xl),l(Fl),l(ql),l(Oe),l(Hl),l(Pl),l(Ol),l(ze),l(Yl),l(Ke),l(Dl),l(zl),l(tt),l(Kl),l(lt),l(en),l(tn),l(st),l(ln),l(nn),l(at),l(sn),l(an),l(on),l(rt),l(un),l(rn),l(ht)),l(T),h(g,e),h($,e),h(R,e),h(x,e),h(k,e),h(G,e),h(B),h(F,e),h(H,e),h(O,e),h(Y,e),h(ee,e),h(le,e),h(se,e),h(ae,e),h(ue,e),h(re,e),h(pe,e),h(Me,e),h(he,e),h(ye,e),h(Te,e),h(Ce,e),h(be,e),h(je,e),h(Ee,e),h(Ne,e),h(Se,e),h(Le,e),h(We,e),h(Qe,e),h(Be,e),h(Fe,e),h(He,e),h(Pe,e),h(Ye,e),h(De,e),h(et,e),h(nt,e),h(it,e),h(ot,e),h(ut,e),h(ct,e)}}}const $s='{"title":"Deploying TEI on Google Cloud Run","local":"deploying-tei-on-google-cloud-run","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Deploy TEI on Cloud Run","local":"deploy-tei-on-cloud-run","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[{"title":"Via Cloud Run Proxy","local":"via-cloud-run-proxy","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5}],"depth":4},{"title":"OpenAI","local":"openai","sections":[],"depth":4}],"depth":3},{"title":"(recommended) Via Cloud Run Service URL","local":"recommended-via-cloud-run-service-url","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5}],"depth":4},{"title":"OpenAI","local":"openai","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Resource clean up","local":"resource-clean-up","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function As(mn){return gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends Js{constructor(T){super(),bs(this,T,As,Is,Cs,{})}}export{Zs as component};
