import{s as Tn,o as Un,n as oe}from"../chunks/scheduler.b9285784.js";import{S as Cn,i as jn,e as f,s as a,c,h as Jn,a as u,d as o,b as n,f as w,g as r,j as b,k as y,l as d,m as s,n as i,t as m,o as h,p}from"../chunks/index.26bc89a1.js";import{T as da}from"../chunks/Tip.e4eba3d6.js";import{C as Gn,H as x,E as In}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f2e029e4.js";import{D as M}from"../chunks/Docstring.4f61f748.js";import{C as qt}from"../chunks/CodeBlock.191169df.js";import{E as Qt}from"../chunks/ExampleCodeBlock.1e7c3bb6.js";function Nn(C){let l,k="Example:",g,v,$;return v=new qt({props:{code:"aW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEElMEElMjMlMjBJbml0aWFsaXplJTIwYSUyMG1vZGVsJTIwd2l0aCUyMDEwMCUyMGJpbGxpb25zJTIwcGFyYW1ldGVycyUyMGluJTIwbm8lMjB0aW1lJTIwYW5kJTIwd2l0aG91dCUyMHVzaW5nJTIwYW55JTIwUkFNLiUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMHRzdCUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoKiU1Qm5uLkxpbmVhcigxMDAwMCUyQyUyMDEwMDAwKSUyMGZvciUyMF8lMjBpbiUyMHJhbmdlKDEwMDApJTVEKQ==",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights

<span class="hljs-comment"># Initialize a model with 100 billions parameters in no time and without using any RAM.</span>
<span class="hljs-keyword">with</span> init_empty_weights():
    tst = nn.Sequential(*[nn.Linear(<span class="hljs-number">10000</span>, <span class="hljs-number">10000</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)])`,wrap:!1}}),{c(){l=f("p"),l.textContent=k,g=a(),c(v.$$.fragment)},l(_){l=u(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=k),g=n(_),r(v.$$.fragment,_)},m(_,T){s(_,l,T),s(_,g,T),i(v,_,T),$=!0},p:oe,i(_){$||(m(v.$$.fragment,_),$=!0)},o(_){h(v.$$.fragment,_),$=!1},d(_){_&&(o(l),o(g)),p(v,_)}}}function Fn(C){let l,k=`Any model created under this context manager has no weights. As such you can’t do something like
<code>model.to(some_device)</code> with it. To load weights inside your empty model, see <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>.
Make sure to overwrite the default device_map param for <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>, otherwise dispatch is not
called.`;return{c(){l=f("p"),l.innerHTML=k},l(g){l=u(g,"P",{"data-svelte-h":!0}),b(l)!=="svelte-18rw2wy"&&(l.innerHTML=k)},m(g,v){s(g,l,v)},p:oe,d(g){g&&o(l)}}}function Hn(C){let l,k="Example:",g,v,$;return v=new qt({props:{code:"bW9kZWxfMSUyQyUyMGhvb2tfMSUyMCUzRCUyMGNwdV9vZmZsb2FkX3dpdGhfaG9vayhtb2RlbF8xJTJDJTIwY3VkYV9kZXZpY2UpJTBBbW9kZWxfMiUyQyUyMGhvb2tfMiUyMCUzRCUyMGNwdV9vZmZsb2FkX3dpdGhfaG9vayhtb2RlbF8yJTJDJTIwY3VkYV9kZXZpY2UlMkMlMjBwcmV2X21vZHVsZV9ob29rJTNEaG9va18xKSUwQW1vZGVsXzMlMkMlMjBob29rXzMlMjAlM0QlMjBjcHVfb2ZmbG9hZF93aXRoX2hvb2sobW9kZWxfMyUyQyUyMGN1ZGFfZGV2aWNlJTJDJTIwcHJldl9tb2R1bGVfaG9vayUzRGhvb2tfMiklMEElMEFoaWRfMSUyMCUzRCUyMG1vZGVsXzEoaW5wdXQpJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoNTApJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWwxJTIwaXMlMjBvZmZsb2FkZWQlMjBvbiUyMHRoZSUyMENQVSUyMGF0JTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBtb2RlbCUyMDIlMjBzdGF5cyUyMG9uJTIwdGhlJTIwR1BVJTIwZm9yJTIwdGhpcyUyMHdob2xlJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBoaWRfMiUyMCUzRCUyMG1vZGVsXzIoaGlkXzEpJTBBJTIzJTIwbW9kZWwyJTIwaXMlMjBvZmZsb2FkZWQlMjB0byUyMHRoZSUyMENQVSUyMGp1c3QlMjBiZWZvcmUlMjB0aGlzJTIwZm9yd2FyZC4lMEFoaWRfMyUyMCUzRCUyMG1vZGVsXzMoaGlkXzMpJTBBJTBBJTIzJTIwRm9yJTIwbW9kZWwzJTJDJTIweW91JTIwbmVlZCUyMHRvJTIwbWFudWFsbHklMjBjYWxsJTIwdGhlJTIwaG9vayUyMG9mZmxvYWQlMjBtZXRob2QuJTBBaG9va18zLm9mZmxvYWQoKQ==",highlighted:`model_1, hook_1 = cpu_offload_with_hook(model_1, cuda_device)
model_2, hook_2 = cpu_offload_with_hook(model_2, cuda_device, prev_module_hook=hook_1)
model_3, hook_3 = cpu_offload_with_hook(model_3, cuda_device, prev_module_hook=hook_2)

hid_1 = model_1(<span class="hljs-built_in">input</span>)
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">50</span>):
    <span class="hljs-comment"># model1 is offloaded on the CPU at the first iteration, model 2 stays on the GPU for this whole loop.</span>
    hid_2 = model_2(hid_1)
<span class="hljs-comment"># model2 is offloaded to the CPU just before this forward.</span>
hid_3 = model_3(hid_3)

<span class="hljs-comment"># For model3, you need to manually call the hook offload method.</span>
hook_3.offload()`,wrap:!1}}),{c(){l=f("p"),l.textContent=k,g=a(),c(v.$$.fragment)},l(_){l=u(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=k),g=n(_),r(v.$$.fragment,_)},m(_,T){s(_,l,T),s(_,g,T),i(v,_,T),$=!0},p:oe,i(_){$||(m(v.$$.fragment,_),$=!0)},o(_){h(v.$$.fragment,_),$=!1},d(_){_&&(o(l),o(g)),p(v,_)}}}function Wn(C){let l,k="Example:",g,v,$;return v=new qt({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMkMlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMHRoZSUyMFdlaWdodHMlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1qLTZCJTIyJTBBd2VpZ2h0c19sb2NhdGlvbiUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZChjaGVja3BvaW50JTJDJTIwJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMG1vZGVsJTIwYW5kJTIwaW5pdGlhbGl6ZSUyMGl0JTIwd2l0aCUyMGVtcHR5JTIwd2VpZ2h0cyUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX2NvbmZpZyhjb25maWcpJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMGNoZWNrcG9pbnQlMjBhbmQlMjBkaXNwYXRjaCUyMGl0JTIwdG8lMjB0aGUlMjByaWdodCUyMGRldmljZXMlMEFtb2RlbCUyMCUzRCUyMGxvYWRfY2hlY2twb2ludF9hbmRfZGlzcGF0Y2goJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjB3ZWlnaHRzX2xvY2F0aW9uJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBub19zcGxpdF9tb2R1bGVfY2xhc3NlcyUzRCU1QiUyMkdQVEpCbG9jayUyMiU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights, load_checkpoint_and_dispatch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download the Weights</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/gpt-j-6B&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>weights_location = hf_hub_download(checkpoint, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create a model and initialize it with empty weights</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> init_empty_weights():
<span class="hljs-meta">... </span>    model = AutoModelForCausalLM.from_config(config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the checkpoint and dispatch it to the right devices</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = load_checkpoint_and_dispatch(
<span class="hljs-meta">... </span>    model, weights_location, device_map=<span class="hljs-string">&quot;auto&quot;</span>, no_split_module_classes=[<span class="hljs-string">&quot;GPTJBlock&quot;</span>]
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){l=f("p"),l.textContent=k,g=a(),c(v.$$.fragment)},l(_){l=u(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=k),g=n(_),r(v.$$.fragment,_)},m(_,T){s(_,l,T),s(_,g,T),i(v,_,T),$=!0},p:oe,i(_){$||(m(v.$$.fragment,_),$=!0)},o(_){h(v.$$.fragment,_),$=!1},d(_){_&&(o(l),o(g)),p(v,_)}}}function Zn(C){let l,k=`Once loaded across devices, you still need to call <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.dispatch_model">dispatch_model()</a> on your model to make it able to run. To
group the checkpoint loading and dispatch in one single call, use <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>.`;return{c(){l=f("p"),l.innerHTML=k},l(g){l=u(g,"P",{"data-svelte-h":!0}),b(l)!=="svelte-13sragn"&&(l.innerHTML=k)},m(g,v){s(g,l,v)},p:oe,d(g){g&&o(l)}}}function Dn(C){let l,k=`All computation is done analyzing sizes and dtypes of the model parameters. As a result, the model can be on the
meta device (as it would if initialized within the <code>init_empty_weights</code> context manager).`;return{c(){l=f("p"),l.innerHTML=k},l(g){l=u(g,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1d9m3bn"&&(l.innerHTML=k)},m(g,v){s(g,l,v)},p:oe,d(g){g&&o(l)}}}function Bn(C){let l,k=`If the module already contains a hook, this will replace it with the new hook passed by default. To chain two hooks
together, pass <code>append=True</code>, so it chains the current and new hook into an instance of the <code>SequentialHook</code> class.`;return{c(){l=f("p"),l.innerHTML=k},l(g){l=u(g,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1dclc89"&&(l.innerHTML=k)},m(g,v){s(g,l,v)},p:oe,d(g){g&&o(l)}}}function Ln(C){let l,k="Example:",g,v,$;return v=new qt({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUuaG9va3MlMjBpbXBvcnQlMjBhdHRhY2hfbGF5ZXJ3aXNlX2Nhc3RpbmdfaG9va3MlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyME1vZGVsJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZncHQtai02QiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBJTIzJTIwQXR0YWNoJTIwaG9va3MlMjBhbmQlMjBwZXJmb3JtJTIwaW5mZXJlbmNlJTBBYXR0YWNoX2xheWVyd2lzZV9jYXN0aW5nX2hvb2tzKG1vZGVsJTJDJTIwc3RvcmFnZV9kdHlwZSUzRHRvcmNoLmZsb2F0OF9lNG0zZm4lMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsKC4uLik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.hooks <span class="hljs-keyword">import</span> attach_layerwise_casting_hooks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/gpt-j-6B&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Attach hooks and perform inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>attach_layerwise_casting_hooks(model, storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    model(...)`,wrap:!1}}),{c(){l=f("p"),l.textContent=k,g=a(),c(v.$$.fragment)},l(_){l=u(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=k),g=n(_),r(v.$$.fragment,_)},m(_,T){s(_,l,T),s(_,g,T),i(v,_,T),$=!0},p:oe,i(_){$||(m(v.$$.fragment,_),$=!0)},o(_){h(v.$$.fragment,_),$=!1},d(_){_&&(o(l),o(g)),p(v,_)}}}function Vn(C){let l,k;return l=new qt({props:{code:"YXR0YWNoX2xheWVyd2lzZV9jYXN0aW5nX2hvb2tzKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwc3RvcmFnZV9kdHlwZSUzRHRvcmNoLmZsb2F0OF9lNG0zZm4lMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBza2lwX21vZHVsZXNfcGF0dGVybiUzRCU1QiUyMm5vcm0lMjIlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>attach_layerwise_casting_hooks(
<span class="hljs-meta">... </span>    model, storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16, skip_modules_pattern=[<span class="hljs-string">&quot;norm&quot;</span>]
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){c(l.$$.fragment)},l(g){r(l.$$.fragment,g)},m(g,v){i(l,g,v),k=!0},p:oe,i(g){k||(m(l.$$.fragment,g),k=!0)},o(g){h(l.$$.fragment,g),k=!1},d(g){p(l,g)}}}function An(C){let l,k,g,v,$,_,T,Yt,_e,St,ge,Ot,G,ve,ca,gt,Ya=`A context manager under which models are initialized with all parameters on the meta device, therefore creating an
empty model. Useful when just initializing the model would blow the available RAM.`,ra,ae,ia,ne,Kt,be,eo,L,ke,ma,vt,Sa=`Activates full CPU offload for a model. As a result, all parameters of the model will be offloaded and only one
copy of the state dict of the model will be kept. During the forward pass, parameters will be extracted from that
state dict and put on the execution device passed as they are needed, then offloaded again.`,to,$e,oo,N,we,ha,bt,Oa=`Offloads a model on the CPU and puts it back to an execution device when executed. The difference with
<a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.cpu_offload">cpu_offload()</a> is that the model stays on the execution device after the forward and is only offloaded again when
the <code>offload</code> method of the returned <code>hook</code> is called. Useful for pipelines running a model in a loop.`,pa,se,ao,ye,no,V,xe,fa,kt,Ka=`Activates full disk offload for a model. As a result, all parameters of the model will be offloaded as
memory-mapped array in a given folder. During the forward pass, parameters will be accessed from that folder and
put on the execution device passed as they are needed, then offloaded again.`,so,Me,lo,A,Te,ua,$t,en=`Dispatches a model according to a given device map. Layers of the model might be spread across GPUs, offloaded on
the CPU or even the disk.`,co,Ue,ro,F,Ce,_a,wt,tn=`Loads a (potentially sharded) checkpoint inside a model, potentially sending weights to a given device as they are
loaded and adds the various hooks that will make this model run properly (even if split across devices).`,ga,le,io,je,mo,H,Je,va,yt,on=`Loads a (potentially sharded) checkpoint inside a model, potentially sending weights to a given device as they are
loaded.`,ba,de,ho,Ge,po,I,Ie,ka,xt,an=`Compute a device map for a given model giving priority to GPUs, then offload on CPU and finally offload to disk,
such that:`,$a,Mt,nn=`<li>we don’t exceed the memory available of any of the GPU.</li> <li>if offload to the CPU is needed, there is always room left on GPU 0 to put back the layer offloaded on CPU that
has the largest size.</li> <li>if offload to the CPU is needed,we don’t exceed the RAM available on the CPU.</li> <li>if offload to the disk is needed, there is always room left on the CPU to put back the layer offloaded on disk
that has the largest size.</li>`,wa,ce,fo,Ne,uo,Fe,_o,U,He,ya,Tt,sn=`A hook that contains callbacks to be executed just before and after the forward method of a model. The difference
with PyTorch existing hooks is that they get passed along the kwargs.`,xa,Ut,ln="Class attribute:",Ma,Ct,dn=`<li><strong>no_grad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) — Whether or not to execute the actual forward pass under
the <code>torch.no_grad()</code> context manager.</li>`,Ta,re,We,Ua,jt,cn="To be executed when the hook is detached from a module.",Ca,ie,Ze,ja,Jt,rn="To be executed when the hook is attached to the module.",Ja,me,De,Ga,Gt,mn="To be executed just after the forward method of the model.",Ia,he,Be,Na,It,hn="To be executed just before the forward method of the model.",go,Le,vo,P,Ve,Fa,Nt,pn=`A generic <code>ModelHook</code> that ensures inputs and model weights are on the same device for the forward pass of the
associated module, potentially offloading the weights after the forward pass.`,bo,Ae,ko,R,Pe,Ha,Ft,fn="A hook that can contain several hooks and iterates through them at each event.",$o,Re,wo,X,Xe,Wa,Ht,un=`A hook that casts the weights of a module to a high precision dtype for computation, and to a low precision dtype
for storage. This process may lead to quality loss in the output, but can significantly reduce the memory
footprint.`,yo,Ee,xo,ze,Mo,W,Qe,Za,Wt,_n=`Adds a hook to a given module. This will rewrite the <code>forward</code> method of the module to include the hook, to remove
this behavior and restore the original <code>forward</code> method, use <code>remove_hook_from_module</code>.`,Da,pe,To,qe,Uo,E,Ye,Ba,Zt,gn=`Recursively attaches <code>AlignDevicesHook</code> to all submodules of a given model to make sure they have the right
execution device`,Co,Se,jo,z,Oe,La,Dt,vn=`Recursively attaches <code>AlignDevicesHook</code> to all submodules of a given model that have direct parameters and/or
buffers.`,Jo,Ke,Go,Q,et,Va,Bt,bn="Attaches <code>AlignDevicesHook</code> to all blocks of a given model as needed.",Io,tt,No,J,ot,Aa,Lt,kn=`Applies layerwise casting to a given module. The module expected here is a PyTorch <code>nn.Module</code>. This is helpful for
reducing memory requirements when one doesn’t want to fully quantize a model. Model params can be kept in say,
<code>torch.float8_e4m3fn</code> and upcasted to a higher precision like <code>torch.bfloat16</code> during forward pass and downcasted
back to <code>torch.float8_e4m3fn</code> to realize memory savings.`,Pa,fe,Ra,Vt,$n="Users can also pass modules they want to avoid from getting downcasted.",Xa,ue,Fo,at,Ho,nt,Wo,q,st,Ea,At,wn="Removes any hook attached to a module via <code>add_hook_to_module</code>.",Zo,lt,Do,Y,dt,za,Pt,yn="Recursively removes all hooks attached on the submodules of a given model.",Bo,ct,Lo,rt,Vo,S,it,Qa,Rt,xn=`Checks if a module has offloaded parameters by checking if the given module has a AlignDevicesHook attached with
offloading enabled`,Ao,mt,Po,O,ht,qa,Xt,Mn="Context manager that moves a module’s parameters to the specified execution device.",Ro,pt,Xo,zt,Eo;return $=new Gn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new x({props:{title:"Working with large models",local:"working-with-large-models",headingTag:"h1"}}),_e=new x({props:{title:"Dispatch and offload",local:"dispatch-and-offload",headingTag:"h2"}}),ge=new x({props:{title:"init_empty_weights",local:"accelerate.init_empty_weights",headingTag:"h3"}}),ve=new M({props:{name:"accelerate.init_empty_weights",anchor:"accelerate.init_empty_weights",parameters:[{name:"include_buffers",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"accelerate.init_empty_weights.include_buffers",description:`<strong>include_buffers</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to also put all buffers on the meta device while initializing.`,name:"include_buffers"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L60"}}),ae=new Qt({props:{anchor:"accelerate.init_empty_weights.example",$$slots:{default:[Nn]},$$scope:{ctx:C}}}),ne=new da({props:{warning:!0,$$slots:{default:[Fn]},$$scope:{ctx:C}}}),be=new x({props:{title:"cpu_offload",local:"accelerate.cpu_offload",headingTag:"h3"}}),ke=new M({props:{name:"accelerate.cpu_offload",anchor:"accelerate.cpu_offload",parameters:[{name:"model",val:": Module"},{name:"execution_device",val:": typing.Optional[torch.device] = None"},{name:"offload_buffers",val:": bool = False"},{name:"state_dict",val:": typing.Optional[dict[str, torch.Tensor]] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"}],parametersDescription:[{anchor:"accelerate.cpu_offload.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to offload.`,name:"model"},{anchor:"accelerate.cpu_offload.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which the forward pass of the model will be executed (should be a GPU). Will default to the
model first parameter device.`,name:"execution_device"},{anchor:"accelerate.cpu_offload.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to offload the buffers with the model parameters.`,name:"offload_buffers"},{anchor:"accelerate.cpu_offload.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
The state dict of the model that will be kept on CPU.`,name:"state_dict"},{anchor:"accelerate.cpu_offload.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L173"}}),$e=new x({props:{title:"cpu_offload_with_hook",local:"accelerate.cpu_offload_with_hook",headingTag:"h3"}}),we=new M({props:{name:"accelerate.cpu_offload_with_hook",anchor:"accelerate.cpu_offload_with_hook",parameters:[{name:"model",val:": Module"},{name:"execution_device",val:": typing.Union[int, str, torch.device, NoneType] = None"},{name:"prev_module_hook",val:": typing.Optional[accelerate.hooks.UserCpuOffloadHook] = None"}],parametersDescription:[{anchor:"accelerate.cpu_offload_with_hook.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to offload.`,name:"model"},{anchor:"accelerate.cpu_offload_with_hook.execution_device(str,",description:`<strong>execution_device(<code>str</code>,</strong> <code>int</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which the model should be executed. Will default to the MPS device if it&#x2019;s available, then
GPU 0 if there is a GPU, and finally to the CPU.`,name:"execution_device(str,"},{anchor:"accelerate.cpu_offload_with_hook.prev_module_hook",description:`<strong>prev_module_hook</strong> (<code>UserCpuOffloadHook</code>, <em>optional</em>) &#x2014;
The hook sent back by this function for a previous model in the pipeline you are running. If passed, its
offload method will be called just before the forward of the model to which this hook is attached.`,name:"prev_module_hook"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L219"}}),se=new Qt({props:{anchor:"accelerate.cpu_offload_with_hook.example",$$slots:{default:[Hn]},$$scope:{ctx:C}}}),ye=new x({props:{title:"disk_offload",local:"accelerate.disk_offload",headingTag:"h3"}}),xe=new M({props:{name:"accelerate.disk_offload",anchor:"accelerate.disk_offload",parameters:[{name:"model",val:": Module"},{name:"offload_dir",val:": typing.Union[str, os.PathLike]"},{name:"execution_device",val:": typing.Optional[torch.device] = None"},{name:"offload_buffers",val:": bool = False"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"}],parametersDescription:[{anchor:"accelerate.disk_offload.model",description:"<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014; The model to offload.",name:"model"},{anchor:"accelerate.disk_offload.offload_dir",description:`<strong>offload_dir</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The folder in which to offload the model weights (or where the model weights are already offloaded).`,name:"offload_dir"},{anchor:"accelerate.disk_offload.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which the forward pass of the model will be executed (should be a GPU). Will default to the
model&#x2019;s first parameter device.`,name:"execution_device"},{anchor:"accelerate.disk_offload.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to offload the buffers with the model parameters.`,name:"offload_buffers"},{anchor:"accelerate.disk_offload.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L263"}}),Me=new x({props:{title:"dispatch_model",local:"accelerate.dispatch_model",headingTag:"h3"}}),Te=new M({props:{name:"accelerate.dispatch_model",anchor:"accelerate.dispatch_model",parameters:[{name:"model",val:": Module"},{name:"device_map",val:": dict"},{name:"main_device",val:": typing.Optional[torch.device] = None"},{name:"state_dict",val:": typing.Optional[dict[str, torch.Tensor]] = None"},{name:"offload_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"offload_index",val:": typing.Optional[dict[str, str]] = None"},{name:"offload_buffers",val:": bool = False"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"force_hooks",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.dispatch_model.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to dispatch.`,name:"model"},{anchor:"accelerate.dispatch_model.device_map",description:`<strong>device_map</strong> (<code>Dict[str, Union[str, int, torch.device]]</code>) &#x2014;
A dictionary mapping module names in the models <code>state_dict</code> to the device they should go to. Note that
<code>&quot;disk&quot;</code> is accepted even if it&#x2019;s not a proper value for <code>torch.device</code>.`,name:"device_map"},{anchor:"accelerate.dispatch_model.main_device",description:`<strong>main_device</strong> (<code>str</code>, <code>int</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The main execution device. Will default to the first device in the <code>device_map</code> different from <code>&quot;cpu&quot;</code> or
<code>&quot;disk&quot;</code>.`,name:"main_device"},{anchor:"accelerate.dispatch_model.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
The state dict of the part of the model that will be kept on CPU.`,name:"state_dict"},{anchor:"accelerate.dispatch_model.offload_dir",description:`<strong>offload_dir</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The folder in which to offload the model weights (or where the model weights are already offloaded).`,name:"offload_dir"},{anchor:"accelerate.dispatch_model.offload_index",description:`<strong>offload_index</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary from weight name to their information (<code>dtype</code>/ <code>shape</code> or safetensors filename). Will default
to the index saved in <code>save_folder</code>.`,name:"offload_index"},{anchor:"accelerate.dispatch_model.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to offload the buffers with the model parameters.`,name:"offload_buffers"},{anchor:"accelerate.dispatch_model.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.dispatch_model.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.dispatch_model.force_hooks",description:`<strong>force_hooks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force device hooks to be attached to the model even if all layers are dispatched to a
single device.`,name:"force_hooks"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L309"}}),Ue=new x({props:{title:"load_checkpoint_and_dispatch",local:"accelerate.load_checkpoint_and_dispatch",headingTag:"h3"}}),Ce=new M({props:{name:"accelerate.load_checkpoint_and_dispatch",anchor:"accelerate.load_checkpoint_and_dispatch",parameters:[{name:"model",val:": Module"},{name:"checkpoint",val:": typing.Union[str, os.PathLike]"},{name:"device_map",val:": typing.Union[str, dict[str, typing.Union[int, str, torch.device]], NoneType] = None"},{name:"max_memory",val:": typing.Optional[dict[typing.Union[int, str], typing.Union[int, str]]] = None"},{name:"no_split_module_classes",val:": typing.Optional[list[str]] = None"},{name:"offload_folder",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"offload_buffers",val:": bool = False"},{name:"dtype",val:": typing.Union[str, torch.dtype, NoneType] = None"},{name:"offload_state_dict",val:": typing.Optional[bool] = None"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"force_hooks",val:": bool = False"},{name:"strict",val:": bool = False"},{name:"full_state_dict",val:": bool = True"},{name:"broadcast_from_rank0",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.load_checkpoint_and_dispatch.model",description:"<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014; The model in which we want to load a checkpoint.",name:"model"},{anchor:"accelerate.load_checkpoint_and_dispatch.checkpoint",description:`<strong>checkpoint</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The folder checkpoint to load. It can be:</p>
<ul>
<li>a path to a file containing a whole model state dict</li>
<li>a path to a <code>.json</code> file containing the index to a sharded checkpoint</li>
<li>a path to a folder containing a unique <code>.index.json</code> file and the shards of a checkpoint.</li>
</ul>`,name:"checkpoint"},{anchor:"accelerate.load_checkpoint_and_dispatch.device_map",description:`<strong>device_map</strong> (<code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be refined to each parameter/buffer
name, once a given module name is inside, every submodule of it will be sent to the same device.</p>
<p>To have Accelerate compute the most optimized <code>device_map</code> automatically, set <code>device_map=&quot;auto&quot;</code>. For more
information about each option see <a href="../concept_guides/big_model_inference#designing-a-device-map">here</a>.
Defaults to None, which means <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.dispatch_model">dispatch_model()</a> will not be called.`,name:"device_map"},{anchor:"accelerate.load_checkpoint_and_dispatch.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier to maximum memory. Will default to the maximum memory available for each GPU
and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"accelerate.load_checkpoint_and_dispatch.no_split_module_classes",description:`<strong>no_split_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of layer class names that should never be split across device (for instance any layer that has a
residual connection).`,name:"no_split_module_classes"},{anchor:"accelerate.load_checkpoint_and_dispatch.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
If the <code>device_map</code> contains any value <code>&quot;disk&quot;</code>, the folder where we will offload weights.`,name:"offload_folder"},{anchor:"accelerate.load_checkpoint_and_dispatch.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In the layers that are offloaded on the CPU or the hard drive, whether or not to offload the buffers as
well as the parameters.`,name:"offload_buffers"},{anchor:"accelerate.load_checkpoint_and_dispatch.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
If provided, the weights will be converted to that type when loaded.`,name:"dtype"},{anchor:"accelerate.load_checkpoint_and_dispatch.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, will temporarily offload the CPU state dict on the hard drive to avoid getting out of CPU RAM if
the weight of the CPU state dict + the biggest shard does not fit. Will default to <code>True</code> if the device map
picked contains <code>&quot;disk&quot;</code> values.`,name:"offload_state_dict"},{anchor:"accelerate.load_checkpoint_and_dispatch.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.load_checkpoint_and_dispatch.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.load_checkpoint_and_dispatch.force_hooks",description:`<strong>force_hooks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force device hooks to be attached to the model even if all layers are dispatched to a
single device.`,name:"force_hooks"},{anchor:"accelerate.load_checkpoint_and_dispatch.strict",description:`<strong>strict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to strictly enforce that the keys in the checkpoint state_dict match the keys of the model&#x2019;s
state_dict.`,name:"strict"},{anchor:"accelerate.load_checkpoint_and_dispatch.full_state_dict",description:`<strong>full_state_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; if this is set to <code>True</code>, all the tensors in the
loaded state_dict will be gathered. No ShardedTensor and DTensor will be in the loaded state_dict.`,name:"full_state_dict"},{anchor:"accelerate.load_checkpoint_and_dispatch.broadcast_from_rank0",description:`<strong>broadcast_from_rank0</strong> (<code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; when the option is <code>True</code>, a distributed
<code>ProcessGroup</code> must be initialized. rank0 should receive a full state_dict and will broadcast the tensors
in the state_dict one by one to other ranks. Other ranks will receive the tensors and shard (if applicable)
according to the local shards in the model.`,name:"broadcast_from_rank0"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L512"}}),le=new Qt({props:{anchor:"accelerate.load_checkpoint_and_dispatch.example",$$slots:{default:[Wn]},$$scope:{ctx:C}}}),je=new x({props:{title:"load_checkpoint_in_model",local:"accelerate.load_checkpoint_in_model",headingTag:"h3"}}),Je=new M({props:{name:"accelerate.load_checkpoint_in_model",anchor:"accelerate.load_checkpoint_in_model",parameters:[{name:"model",val:": Module"},{name:"checkpoint",val:": typing.Union[str, os.PathLike]"},{name:"device_map",val:": typing.Optional[dict[str, typing.Union[int, str, torch.device]]] = None"},{name:"offload_folder",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"dtype",val:": typing.Union[str, torch.dtype, NoneType] = None"},{name:"offload_state_dict",val:": bool = False"},{name:"offload_buffers",val:": bool = False"},{name:"keep_in_fp32_modules",val:": typing.Optional[list[str]] = None"},{name:"offload_8bit_bnb",val:": bool = False"},{name:"strict",val:": bool = False"},{name:"full_state_dict",val:": bool = True"},{name:"broadcast_from_rank0",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.load_checkpoint_in_model.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model in which we want to load a checkpoint.`,name:"model"},{anchor:"accelerate.load_checkpoint_in_model.checkpoint",description:`<strong>checkpoint</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The folder checkpoint to load. It can be:
<ul>
<li>a path to a file containing a whole model state dict</li>
<li>a path to a <code>.json</code> file containing the index to a sharded checkpoint</li>
<li>a path to a folder containing a unique <code>.index.json</code> file and the shards of a checkpoint.</li>
<li>a path to a folder containing a unique pytorch_model.bin or a model.safetensors file.</li>
</ul>`,name:"checkpoint"},{anchor:"accelerate.load_checkpoint_in_model.device_map",description:`<strong>device_map</strong> (<code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be refined to each parameter/buffer
name, once a given module name is inside, every submodule of it will be sent to the same device.`,name:"device_map"},{anchor:"accelerate.load_checkpoint_in_model.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
If the <code>device_map</code> contains any value <code>&quot;disk&quot;</code>, the folder where we will offload weights.`,name:"offload_folder"},{anchor:"accelerate.load_checkpoint_in_model.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
If provided, the weights will be converted to that type when loaded.`,name:"dtype"},{anchor:"accelerate.load_checkpoint_in_model.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, will temporarily offload the CPU state dict on the hard drive to avoid getting out of CPU RAM if
the weight of the CPU state dict + the biggest shard does not fit.`,name:"offload_state_dict"},{anchor:"accelerate.load_checkpoint_in_model.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the buffers in the weights offloaded to disk.`,name:"offload_buffers"},{anchor:"accelerate.load_checkpoint_in_model.keep_in_fp32_modules(List[str],",description:`<strong>keep_in_fp32_modules(<code>List[str]</code>,</strong> <em>optional</em>) &#x2014;
A list of the modules that we keep in <code>torch.float32</code> dtype.`,name:"keep_in_fp32_modules(List[str],"},{anchor:"accelerate.load_checkpoint_in_model.offload_8bit_bnb",description:`<strong>offload_8bit_bnb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to enable offload of 8-bit modules on cpu/disk.`,name:"offload_8bit_bnb"},{anchor:"accelerate.load_checkpoint_in_model.strict",description:`<strong>strict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to strictly enforce that the keys in the checkpoint state_dict match the keys of the model&#x2019;s
state_dict.`,name:"strict"},{anchor:"accelerate.load_checkpoint_in_model.full_state_dict",description:`<strong>full_state_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; if this is set to <code>True</code>, all the tensors in the
loaded state_dict will be gathered. No ShardedTensor and DTensor will be in the loaded state_dict.`,name:"full_state_dict"},{anchor:"accelerate.load_checkpoint_in_model.broadcast_from_rank0",description:`<strong>broadcast_from_rank0</strong> (<code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; when the option is <code>True</code>, a distributed
<code>ProcessGroup</code> must be initialized. rank0 should receive a full state_dict and will broadcast the tensors
in the state_dict one by one to other ranks. Other ranks will receive the tensors and shard (if applicable)
according to the local shards in the model.`,name:"broadcast_from_rank0"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/modeling.py#L1788"}}),de=new da({props:{warning:!0,$$slots:{default:[Zn]},$$scope:{ctx:C}}}),Ge=new x({props:{title:"infer_auto_device_map",local:"accelerate.infer_auto_device_map",headingTag:"h3"}}),Ie=new M({props:{name:"accelerate.infer_auto_device_map",anchor:"accelerate.infer_auto_device_map",parameters:[{name:"model",val:": Module"},{name:"max_memory",val:": typing.Optional[dict[typing.Union[int, str], typing.Union[int, str]]] = None"},{name:"no_split_module_classes",val:": typing.Optional[list[str]] = None"},{name:"dtype",val:": typing.Union[str, torch.dtype, NoneType] = None"},{name:"special_dtypes",val:": typing.Optional[dict[str, typing.Union[str, torch.dtype]]] = None"},{name:"verbose",val:": bool = False"},{name:"clean_result",val:": bool = True"},{name:"offload_buffers",val:": bool = False"},{name:"fallback_allocation",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.infer_auto_device_map.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to analyze.`,name:"model"},{anchor:"accelerate.infer_auto_device_map.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier to maximum memory. Will default to the maximum memory available if unset.
Example: <code>max_memory={0: &quot;1GB&quot;}</code>.`,name:"max_memory"},{anchor:"accelerate.infer_auto_device_map.no_split_module_classes",description:`<strong>no_split_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of layer class names that should never be split across device (for instance any layer that has a
residual connection).`,name:"no_split_module_classes"},{anchor:"accelerate.infer_auto_device_map.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
If provided, the weights will be converted to that type when loaded.`,name:"dtype"},{anchor:"accelerate.infer_auto_device_map.special_dtypes",description:`<strong>special_dtypes</strong> (<code>Dict[str, Union[str, torch.device]]</code>, <em>optional</em>) &#x2014;
If provided, special dtypes to consider for some specific weights (will override dtype used as default for
all weights).`,name:"special_dtypes"},{anchor:"accelerate.infer_auto_device_map.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to provide debugging statements as the function builds the device_map.`,name:"verbose"},{anchor:"accelerate.infer_auto_device_map.clean_result",description:`<strong>clean_result</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Clean the resulting device_map by grouping all submodules that go on the same device together.`,name:"clean_result"},{anchor:"accelerate.infer_auto_device_map.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In the layers that are offloaded on the CPU or the hard drive, whether or not to offload the buffers as
well as the parameters.`,name:"offload_buffers"},{anchor:"accelerate.infer_auto_device_map.fallback_allocation",description:`<strong>fallback_allocation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When regular allocation fails, try to allocate a module that fits in the size limit using BFS.`,name:"fallback_allocation"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/modeling.py#L1278"}}),ce=new da({props:{$$slots:{default:[Dn]},$$scope:{ctx:C}}}),Ne=new x({props:{title:"Hooks",local:"hooks",headingTag:"h2"}}),Fe=new x({props:{title:"ModelHook",local:"accelerate.hooks.ModelHook",headingTag:"h3"}}),He=new M({props:{name:"class accelerate.hooks.ModelHook",anchor:"accelerate.hooks.ModelHook",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L43"}}),We=new M({props:{name:"detach_hook",anchor:"accelerate.hooks.ModelHook.detach_hook",parameters:[{name:"module",val:""}],parametersDescription:[{anchor:"accelerate.hooks.ModelHook.detach_hook.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module detached from this hook.",name:"module"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L91"}}),Ze=new M({props:{name:"init_hook",anchor:"accelerate.hooks.ModelHook.init_hook",parameters:[{name:"module",val:""}],parametersDescription:[{anchor:"accelerate.hooks.ModelHook.init_hook.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module attached to this hook.",name:"module"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L55"}}),De=new M({props:{name:"post_forward",anchor:"accelerate.hooks.ModelHook.post_forward",parameters:[{name:"module",val:""},{name:"output",val:""}],parametersDescription:[{anchor:"accelerate.hooks.ModelHook.post_forward.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module whose forward pass been executed just before this event.",name:"module"},{anchor:"accelerate.hooks.ModelHook.post_forward.output",description:"<strong>output</strong> (<code>Any</code>) &#x2014; The output of the module.",name:"output"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L78",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed <code>output</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Any</code></p>
`}}),Be=new M({props:{name:"pre_forward",anchor:"accelerate.hooks.ModelHook.pre_forward",parameters:[{name:"module",val:""},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"accelerate.hooks.ModelHook.pre_forward.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module whose forward pass will be executed just after this event.",name:"module"},{anchor:"accelerate.hooks.ModelHook.pre_forward.args",description:"<strong>args</strong> (<code>Tuple[Any]</code>) &#x2014; The positional arguments passed to the module.",name:"args"},{anchor:"accelerate.hooks.ModelHook.pre_forward.kwargs",description:"<strong>kwargs</strong> (<code>Dict[Str, Any]</code>) &#x2014; The keyword arguments passed to the module.",name:"kwargs"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L64",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple with the treated <code>args</code> and <code>kwargs</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Tuple[Any], Dict[Str, Any]]</code></p>
`}}),Le=new x({props:{title:"AlignDevicesHook",local:"accelerate.hooks.AlignDevicesHook",headingTag:"h3"}}),Ve=new M({props:{name:"class accelerate.hooks.AlignDevicesHook",anchor:"accelerate.hooks.AlignDevicesHook",parameters:[{name:"execution_device",val:": typing.Union[int, str, torch.device, NoneType] = None"},{name:"offload",val:": bool = False"},{name:"io_same_device",val:": bool = False"},{name:"weights_map",val:": typing.Optional[collections.abc.Mapping] = None"},{name:"offload_buffers",val:": bool = False"},{name:"place_submodules",val:": bool = False"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"tied_params_map",val:": typing.Optional[dict[int, dict[torch.device, torch.Tensor]]] = None"}],parametersDescription:[{anchor:"accelerate.hooks.AlignDevicesHook.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which inputs and model weights should be placed before the forward pass.`,name:"execution_device"},{anchor:"accelerate.hooks.AlignDevicesHook.offload",description:`<strong>offload</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the weights should be offloaded after the forward pass.`,name:"offload"},{anchor:"accelerate.hooks.AlignDevicesHook.io_same_device",description:`<strong>io_same_device</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the output should be placed on the same device as the input was.`,name:"io_same_device"},{anchor:"accelerate.hooks.AlignDevicesHook.weights_map",description:`<strong>weights_map</strong> (<code>Mapping[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
When the model weights are offloaded, a (potentially lazy) map from param names to the tensor values.`,name:"weights_map"},{anchor:"accelerate.hooks.AlignDevicesHook.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the associated module&#x2019;s buffers when offloading.`,name:"offload_buffers"},{anchor:"accelerate.hooks.AlignDevicesHook.place_submodules",description:`<strong>place_submodules</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to place the submodules on <code>execution_device</code> during the <code>init_hook</code> event.`,name:"place_submodules"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L225"}}),Ae=new x({props:{title:"SequentialHook",local:"accelerate.hooks.SequentialHook",headingTag:"h3"}}),Pe=new M({props:{name:"class accelerate.hooks.SequentialHook",anchor:"accelerate.hooks.SequentialHook",parameters:[{name:"*hooks",val:""}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L101"}}),Re=new x({props:{title:"LayerwiseCastingHook",local:"accelerate.hooks.LayerwiseCastingHook",headingTag:"h3"}}),Xe=new M({props:{name:"class accelerate.hooks.LayerwiseCastingHook",anchor:"accelerate.hooks.LayerwiseCastingHook",parameters:[{name:"storage_dtype",val:": dtype"},{name:"compute_dtype",val:": dtype"},{name:"non_blocking",val:": bool"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L752"}}),Ee=new x({props:{title:"Adding Hooks",local:"adding-hooks",headingTag:"h2"}}),ze=new x({props:{title:"add_hook_to_module",local:"accelerate.hooks.add_hook_to_module",headingTag:"h3"}}),Qe=new M({props:{name:"accelerate.hooks.add_hook_to_module",anchor:"accelerate.hooks.add_hook_to_module",parameters:[{name:"module",val:": Module"},{name:"hook",val:": ModelHook"},{name:"append",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.hooks.add_hook_to_module.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module to attach a hook to.`,name:"module"},{anchor:"accelerate.hooks.add_hook_to_module.hook",description:`<strong>hook</strong> (<code>ModelHook</code>) &#x2014;
The hook to attach.`,name:"hook"},{anchor:"accelerate.hooks.add_hook_to_module.append",description:`<strong>append</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the hook should be chained with an existing one (if module already contains a hook) or not.`,name:"append"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L130",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same module, with the hook attached (the module is modified in place, so the result can
be discarded).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.nn.Module</code></p>
`}}),pe=new da({props:{warning:!0,$$slots:{default:[Bn]},$$scope:{ctx:C}}}),qe=new x({props:{title:"attach_execution_device_hook",local:"accelerate.hooks.attach_execution_device_hook",headingTag:"h3"}}),Ye=new M({props:{name:"accelerate.hooks.attach_execution_device_hook",anchor:"accelerate.hooks.attach_execution_device_hook",parameters:[{name:"module",val:": Module"},{name:"execution_device",val:": typing.Union[int, str, torch.device]"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"tied_params_map",val:": typing.Optional[dict[int, dict[torch.device, torch.Tensor]]] = None"}],parametersDescription:[{anchor:"accelerate.hooks.attach_execution_device_hook.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module where we want to attach the hooks.`,name:"module"},{anchor:"accelerate.hooks.attach_execution_device_hook.execution_device",description:`<strong>execution_device</strong> (<code>int</code>, <code>str</code> or <code>torch.device</code>) &#x2014;
The device on which inputs and model weights should be placed before the forward pass.`,name:"execution_device"},{anchor:"accelerate.hooks.attach_execution_device_hook.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.hooks.attach_execution_device_hook.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.hooks.attach_execution_device_hook.tied_params_map",description:`<strong>tied_params_map</strong> (Optional[Dict[int, Dict[torch.device, torch.Tensor]]], <em>optional</em>, defaults to <code>None</code>) &#x2014;
A map of data pointers to dictionaries of devices to already dispatched tied weights. For a given execution
device, this parameter is useful to reuse the first available pointer of a shared weight for all others,
instead of duplicating memory.`,name:"tied_params_map"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L412"}}),Se=new x({props:{title:"attach_align_device_hook",local:"accelerate.hooks.attach_align_device_hook",headingTag:"h3"}}),Oe=new M({props:{name:"accelerate.hooks.attach_align_device_hook",anchor:"accelerate.hooks.attach_align_device_hook",parameters:[{name:"module",val:": Module"},{name:"execution_device",val:": typing.Optional[torch.device] = None"},{name:"offload",val:": bool = False"},{name:"weights_map",val:": typing.Optional[collections.abc.Mapping] = None"},{name:"offload_buffers",val:": bool = False"},{name:"module_name",val:": str = ''"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"tied_params_map",val:": typing.Optional[dict[int, dict[torch.device, torch.Tensor]]] = None"}],parametersDescription:[{anchor:"accelerate.hooks.attach_align_device_hook.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module where we want to attach the hooks.`,name:"module"},{anchor:"accelerate.hooks.attach_align_device_hook.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which inputs and model weights should be placed before the forward pass.`,name:"execution_device"},{anchor:"accelerate.hooks.attach_align_device_hook.offload",description:`<strong>offload</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the weights should be offloaded after the forward pass.`,name:"offload"},{anchor:"accelerate.hooks.attach_align_device_hook.weights_map",description:`<strong>weights_map</strong> (<code>Mapping[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
When the model weights are offloaded, a (potentially lazy) map from param names to the tensor values.`,name:"weights_map"},{anchor:"accelerate.hooks.attach_align_device_hook.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the associated module&#x2019;s buffers when offloading.`,name:"offload_buffers"},{anchor:"accelerate.hooks.attach_align_device_hook.module_name",description:`<strong>module_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The name of the module.`,name:"module_name"},{anchor:"accelerate.hooks.attach_align_device_hook.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.hooks.attach_align_device_hook.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.hooks.attach_align_device_hook.tied_params_map",description:`<strong>tied_params_map</strong> (Optional[Dict[int, Dict[torch.device, torch.Tensor]]], <em>optional</em>, defaults to <code>None</code>) &#x2014;
A map of data pointers to dictionaries of devices to already dispatched tied weights. For a given execution
device, this parameter is useful to reuse the first available pointer of a shared weight for all others,
instead of duplicating memory.`,name:"tied_params_map"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L460"}}),Ke=new x({props:{title:"attach_align_device_hook_on_blocks",local:"accelerate.hooks.attach_align_device_hook_on_blocks",headingTag:"h3"}}),et=new M({props:{name:"accelerate.hooks.attach_align_device_hook_on_blocks",anchor:"accelerate.hooks.attach_align_device_hook_on_blocks",parameters:[{name:"module",val:": Module"},{name:"execution_device",val:": typing.Union[torch.device, dict[str, torch.device], NoneType] = None"},{name:"offload",val:": typing.Union[bool, dict[str, bool]] = False"},{name:"weights_map",val:": typing.Optional[collections.abc.Mapping] = None"},{name:"offload_buffers",val:": bool = False"},{name:"module_name",val:": str = ''"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"tied_params_map",val:": typing.Optional[dict[int, dict[torch.device, torch.Tensor]]] = None"}],parametersDescription:[{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module where we want to attach the hooks.`,name:"module"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code> or <code>Dict[str, torch.device]</code>, <em>optional</em>) &#x2014;
The device on which inputs and model weights should be placed before the forward pass. It can be one device
for the whole module, or a dictionary mapping module name to device.`,name:"execution_device"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.offload",description:`<strong>offload</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the weights should be offloaded after the forward pass. It can be one boolean for the whole
module, or a dictionary mapping module name to boolean.`,name:"offload"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.weights_map",description:`<strong>weights_map</strong> (<code>Mapping[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
When the model weights are offloaded, a (potentially lazy) map from param names to the tensor values.`,name:"weights_map"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the associated module&#x2019;s buffers when offloading.`,name:"offload_buffers"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.module_name",description:`<strong>module_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The name of the module.`,name:"module_name"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.tied_params_map",description:`<strong>tied_params_map</strong> (Optional[Dict[int, Dict[torch.device, torch.Tensor]]], <em>optional</em>, defaults to <code>None</code>) &#x2014;
A map of data pointers to dictionaries of devices to already dispatched tied weights. For a given execution
device, this parameter is useful to reuse the first available pointer of a shared weight for all others,
instead of duplicating memory.`,name:"tied_params_map"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L555"}}),tt=new x({props:{title:"attach_layerwise_casting_hooks",local:"accelerate.big_modeling.attach_layerwise_casting_hooks",headingTag:"h3"}}),ot=new M({props:{name:"accelerate.big_modeling.attach_layerwise_casting_hooks",anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks",parameters:[{name:"module",val:": Module"},{name:"storage_dtype",val:": dtype"},{name:"compute_dtype",val:": dtype"},{name:"skip_modules_pattern",val:": typing.Union[str, tuple[str, ...], NoneType] = None"},{name:"skip_modules_classes",val:": typing.Optional[tuple[type[torch.nn.modules.module.Module], ...]] = None"},{name:"non_blocking",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module whose leaf modules will be cast to a high precision dtype for computation, and to a low
precision dtype for storage.`,name:"module"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.storage_dtype",description:`<strong>storage_dtype</strong> (<code>torch.dtype</code>) &#x2014;
The dtype to cast the module to before/after the forward pass for storage.`,name:"storage_dtype"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.compute_dtype",description:`<strong>compute_dtype</strong> (<code>torch.dtype</code>) &#x2014;
The dtype to cast the module to during the forward pass for computation.`,name:"compute_dtype"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.skip_modules_pattern",description:`<strong>skip_modules_pattern</strong> (<code>tuple[str, ...]</code>, defaults to <code>None</code>) &#x2014;
A list of patterns to match the names of the modules to skip during the layerwise casting process. If set
to <code>None</code> alongside <code>skip_modules_classes</code> being <code>None</code>, the layerwise casting is applied directly to the
module instead of its internal submodules.`,name:"skip_modules_pattern"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.skip_modules_classes",description:`<strong>skip_modules_classes</strong> (<code>tuple[type[torch.nn.Module], ...]</code>, defaults to <code>None</code>) &#x2014;
A list of module classes to skip during the layerwise casting process.`,name:"skip_modules_classes"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.non_blocking",description:`<strong>non_blocking</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the weight casting operations are non-blocking.`,name:"non_blocking"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L653"}}),fe=new Qt({props:{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.example",$$slots:{default:[Ln]},$$scope:{ctx:C}}}),ue=new Qt({props:{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.example-2",$$slots:{default:[Vn]},$$scope:{ctx:C}}}),at=new x({props:{title:"Removing Hooks",local:"removing-hooks",headingTag:"h2"}}),nt=new x({props:{title:"remove_hook_from_module",local:"accelerate.hooks.remove_hook_from_module",headingTag:"h3"}}),st=new M({props:{name:"accelerate.hooks.remove_hook_from_module",anchor:"accelerate.hooks.remove_hook_from_module",parameters:[{name:"module",val:": Module"},{name:"recurse",val:" = False"}],parametersDescription:[{anchor:"accelerate.hooks.remove_hook_from_module.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module to attach a hook to.",name:"module"},{anchor:"accelerate.hooks.remove_hook_from_module.recurse",description:"<strong>recurse</strong> (<code>bool</code>, <strong>optional</strong>) &#x2014; Whether to remove the hooks recursively",name:"recurse"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L188",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same module, with the hook detached (the module is modified in place, so the result can
be discarded).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.nn.Module</code></p>
`}}),lt=new x({props:{title:"remove_hook_from_submodules",local:"accelerate.hooks.remove_hook_from_submodules",headingTag:"h3"}}),dt=new M({props:{name:"accelerate.hooks.remove_hook_from_submodules",anchor:"accelerate.hooks.remove_hook_from_submodules",parameters:[{name:"module",val:": Module"}],parametersDescription:[{anchor:"accelerate.hooks.remove_hook_from_submodules.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module on which to remove all hooks.",name:"module"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L543"}}),ct=new x({props:{title:"Utilities",local:"utilities",headingTag:"h2"}}),rt=new x({props:{title:"has_offloaded_params",local:"accelerate.utils.has_offloaded_params",headingTag:"h3"}}),it=new M({props:{name:"accelerate.utils.has_offloaded_params",anchor:"accelerate.utils.has_offloaded_params",parameters:[{name:"module",val:": Module"}],parametersDescription:[{anchor:"accelerate.utils.has_offloaded_params.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module to check for an offload hook.",name:"module"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/modeling.py#L2134",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the module has an offload hook and offloading is enabled, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bool</p>
`}}),mt=new x({props:{title:"align_module_device",local:"accelerate.utils.align_module_device",headingTag:"h3"}}),ht=new M({props:{name:"accelerate.utils.align_module_device",anchor:"accelerate.utils.align_module_device",parameters:[{name:"module",val:": Module"},{name:"execution_device",val:": typing.Optional[torch.device] = None"}],parametersDescription:[{anchor:"accelerate.utils.align_module_device.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
Module with parameters to align.`,name:"module"},{anchor:"accelerate.utils.align_module_device.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
If provided, overrides the module&#x2019;s execution device within the context. Otherwise, use hook execution
device or pass`,name:"execution_device"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/modeling.py#L2150"}}),pt=new In({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/package_reference/big_modeling.md"}}),{c(){l=f("meta"),k=a(),g=f("p"),v=a(),c($.$$.fragment),_=a(),c(T.$$.fragment),Yt=a(),c(_e.$$.fragment),St=a(),c(ge.$$.fragment),Ot=a(),G=f("div"),c(ve.$$.fragment),ca=a(),gt=f("p"),gt.textContent=Ya,ra=a(),c(ae.$$.fragment),ia=a(),c(ne.$$.fragment),Kt=a(),c(be.$$.fragment),eo=a(),L=f("div"),c(ke.$$.fragment),ma=a(),vt=f("p"),vt.textContent=Sa,to=a(),c($e.$$.fragment),oo=a(),N=f("div"),c(we.$$.fragment),ha=a(),bt=f("p"),bt.innerHTML=Oa,pa=a(),c(se.$$.fragment),ao=a(),c(ye.$$.fragment),no=a(),V=f("div"),c(xe.$$.fragment),fa=a(),kt=f("p"),kt.textContent=Ka,so=a(),c(Me.$$.fragment),lo=a(),A=f("div"),c(Te.$$.fragment),ua=a(),$t=f("p"),$t.textContent=en,co=a(),c(Ue.$$.fragment),ro=a(),F=f("div"),c(Ce.$$.fragment),_a=a(),wt=f("p"),wt.textContent=tn,ga=a(),c(le.$$.fragment),io=a(),c(je.$$.fragment),mo=a(),H=f("div"),c(Je.$$.fragment),va=a(),yt=f("p"),yt.textContent=on,ba=a(),c(de.$$.fragment),ho=a(),c(Ge.$$.fragment),po=a(),I=f("div"),c(Ie.$$.fragment),ka=a(),xt=f("p"),xt.textContent=an,$a=a(),Mt=f("ul"),Mt.innerHTML=nn,wa=a(),c(ce.$$.fragment),fo=a(),c(Ne.$$.fragment),uo=a(),c(Fe.$$.fragment),_o=a(),U=f("div"),c(He.$$.fragment),ya=a(),Tt=f("p"),Tt.textContent=sn,xa=a(),Ut=f("p"),Ut.textContent=ln,Ma=a(),Ct=f("ul"),Ct.innerHTML=dn,Ta=a(),re=f("div"),c(We.$$.fragment),Ua=a(),jt=f("p"),jt.textContent=cn,Ca=a(),ie=f("div"),c(Ze.$$.fragment),ja=a(),Jt=f("p"),Jt.textContent=rn,Ja=a(),me=f("div"),c(De.$$.fragment),Ga=a(),Gt=f("p"),Gt.textContent=mn,Ia=a(),he=f("div"),c(Be.$$.fragment),Na=a(),It=f("p"),It.textContent=hn,go=a(),c(Le.$$.fragment),vo=a(),P=f("div"),c(Ve.$$.fragment),Fa=a(),Nt=f("p"),Nt.innerHTML=pn,bo=a(),c(Ae.$$.fragment),ko=a(),R=f("div"),c(Pe.$$.fragment),Ha=a(),Ft=f("p"),Ft.textContent=fn,$o=a(),c(Re.$$.fragment),wo=a(),X=f("div"),c(Xe.$$.fragment),Wa=a(),Ht=f("p"),Ht.textContent=un,yo=a(),c(Ee.$$.fragment),xo=a(),c(ze.$$.fragment),Mo=a(),W=f("div"),c(Qe.$$.fragment),Za=a(),Wt=f("p"),Wt.innerHTML=_n,Da=a(),c(pe.$$.fragment),To=a(),c(qe.$$.fragment),Uo=a(),E=f("div"),c(Ye.$$.fragment),Ba=a(),Zt=f("p"),Zt.innerHTML=gn,Co=a(),c(Se.$$.fragment),jo=a(),z=f("div"),c(Oe.$$.fragment),La=a(),Dt=f("p"),Dt.innerHTML=vn,Jo=a(),c(Ke.$$.fragment),Go=a(),Q=f("div"),c(et.$$.fragment),Va=a(),Bt=f("p"),Bt.innerHTML=bn,Io=a(),c(tt.$$.fragment),No=a(),J=f("div"),c(ot.$$.fragment),Aa=a(),Lt=f("p"),Lt.innerHTML=kn,Pa=a(),c(fe.$$.fragment),Ra=a(),Vt=f("p"),Vt.textContent=$n,Xa=a(),c(ue.$$.fragment),Fo=a(),c(at.$$.fragment),Ho=a(),c(nt.$$.fragment),Wo=a(),q=f("div"),c(st.$$.fragment),Ea=a(),At=f("p"),At.innerHTML=wn,Zo=a(),c(lt.$$.fragment),Do=a(),Y=f("div"),c(dt.$$.fragment),za=a(),Pt=f("p"),Pt.textContent=yn,Bo=a(),c(ct.$$.fragment),Lo=a(),c(rt.$$.fragment),Vo=a(),S=f("div"),c(it.$$.fragment),Qa=a(),Rt=f("p"),Rt.textContent=xn,Ao=a(),c(mt.$$.fragment),Po=a(),O=f("div"),c(ht.$$.fragment),qa=a(),Xt=f("p"),Xt.textContent=Mn,Ro=a(),c(pt.$$.fragment),Xo=a(),zt=f("p"),this.h()},l(e){const t=Jn("svelte-u9bgzb",document.head);l=u(t,"META",{name:!0,content:!0}),t.forEach(o),k=n(e),g=u(e,"P",{}),w(g).forEach(o),v=n(e),r($.$$.fragment,e),_=n(e),r(T.$$.fragment,e),Yt=n(e),r(_e.$$.fragment,e),St=n(e),r(ge.$$.fragment,e),Ot=n(e),G=u(e,"DIV",{class:!0});var Z=w(G);r(ve.$$.fragment,Z),ca=n(Z),gt=u(Z,"P",{"data-svelte-h":!0}),b(gt)!=="svelte-1u5mepw"&&(gt.textContent=Ya),ra=n(Z),r(ae.$$.fragment,Z),ia=n(Z),r(ne.$$.fragment,Z),Z.forEach(o),Kt=n(e),r(be.$$.fragment,e),eo=n(e),L=u(e,"DIV",{class:!0});var ft=w(L);r(ke.$$.fragment,ft),ma=n(ft),vt=u(ft,"P",{"data-svelte-h":!0}),b(vt)!=="svelte-1gp9ghs"&&(vt.textContent=Sa),ft.forEach(o),to=n(e),r($e.$$.fragment,e),oo=n(e),N=u(e,"DIV",{class:!0});var K=w(N);r(we.$$.fragment,K),ha=n(K),bt=u(K,"P",{"data-svelte-h":!0}),b(bt)!=="svelte-6j2oun"&&(bt.innerHTML=Oa),pa=n(K),r(se.$$.fragment,K),K.forEach(o),ao=n(e),r(ye.$$.fragment,e),no=n(e),V=u(e,"DIV",{class:!0});var ut=w(V);r(xe.$$.fragment,ut),fa=n(ut),kt=u(ut,"P",{"data-svelte-h":!0}),b(kt)!=="svelte-js7ro5"&&(kt.textContent=Ka),ut.forEach(o),so=n(e),r(Me.$$.fragment,e),lo=n(e),A=u(e,"DIV",{class:!0});var _t=w(A);r(Te.$$.fragment,_t),ua=n(_t),$t=u(_t,"P",{"data-svelte-h":!0}),b($t)!=="svelte-1p13mzc"&&($t.textContent=en),_t.forEach(o),co=n(e),r(Ue.$$.fragment,e),ro=n(e),F=u(e,"DIV",{class:!0});var ee=w(F);r(Ce.$$.fragment,ee),_a=n(ee),wt=u(ee,"P",{"data-svelte-h":!0}),b(wt)!=="svelte-1ikrez4"&&(wt.textContent=tn),ga=n(ee),r(le.$$.fragment,ee),ee.forEach(o),io=n(e),r(je.$$.fragment,e),mo=n(e),H=u(e,"DIV",{class:!0});var te=w(H);r(Je.$$.fragment,te),va=n(te),yt=u(te,"P",{"data-svelte-h":!0}),b(yt)!=="svelte-qft9nv"&&(yt.textContent=on),ba=n(te),r(de.$$.fragment,te),te.forEach(o),ho=n(e),r(Ge.$$.fragment,e),po=n(e),I=u(e,"DIV",{class:!0});var D=w(I);r(Ie.$$.fragment,D),ka=n(D),xt=u(D,"P",{"data-svelte-h":!0}),b(xt)!=="svelte-ou57jw"&&(xt.textContent=an),$a=n(D),Mt=u(D,"UL",{"data-svelte-h":!0}),b(Mt)!=="svelte-17tb5w2"&&(Mt.innerHTML=nn),wa=n(D),r(ce.$$.fragment,D),D.forEach(o),fo=n(e),r(Ne.$$.fragment,e),uo=n(e),r(Fe.$$.fragment,e),_o=n(e),U=u(e,"DIV",{class:!0});var j=w(U);r(He.$$.fragment,j),ya=n(j),Tt=u(j,"P",{"data-svelte-h":!0}),b(Tt)!=="svelte-jjeczj"&&(Tt.textContent=sn),xa=n(j),Ut=u(j,"P",{"data-svelte-h":!0}),b(Ut)!=="svelte-1aqkkwa"&&(Ut.textContent=ln),Ma=n(j),Ct=u(j,"UL",{"data-svelte-h":!0}),b(Ct)!=="svelte-1ny2lfh"&&(Ct.innerHTML=dn),Ta=n(j),re=u(j,"DIV",{class:!0});var zo=w(re);r(We.$$.fragment,zo),Ua=n(zo),jt=u(zo,"P",{"data-svelte-h":!0}),b(jt)!=="svelte-13obmts"&&(jt.textContent=cn),zo.forEach(o),Ca=n(j),ie=u(j,"DIV",{class:!0});var Qo=w(ie);r(Ze.$$.fragment,Qo),ja=n(Qo),Jt=u(Qo,"P",{"data-svelte-h":!0}),b(Jt)!=="svelte-2npthr"&&(Jt.textContent=rn),Qo.forEach(o),Ja=n(j),me=u(j,"DIV",{class:!0});var qo=w(me);r(De.$$.fragment,qo),Ga=n(qo),Gt=u(qo,"P",{"data-svelte-h":!0}),b(Gt)!=="svelte-17hlov5"&&(Gt.textContent=mn),qo.forEach(o),Ia=n(j),he=u(j,"DIV",{class:!0});var Yo=w(he);r(Be.$$.fragment,Yo),Na=n(Yo),It=u(Yo,"P",{"data-svelte-h":!0}),b(It)!=="svelte-53qfnq"&&(It.textContent=hn),Yo.forEach(o),j.forEach(o),go=n(e),r(Le.$$.fragment,e),vo=n(e),P=u(e,"DIV",{class:!0});var So=w(P);r(Ve.$$.fragment,So),Fa=n(So),Nt=u(So,"P",{"data-svelte-h":!0}),b(Nt)!=="svelte-15d0s2c"&&(Nt.innerHTML=pn),So.forEach(o),bo=n(e),r(Ae.$$.fragment,e),ko=n(e),R=u(e,"DIV",{class:!0});var Oo=w(R);r(Pe.$$.fragment,Oo),Ha=n(Oo),Ft=u(Oo,"P",{"data-svelte-h":!0}),b(Ft)!=="svelte-kxjaug"&&(Ft.textContent=fn),Oo.forEach(o),$o=n(e),r(Re.$$.fragment,e),wo=n(e),X=u(e,"DIV",{class:!0});var Ko=w(X);r(Xe.$$.fragment,Ko),Wa=n(Ko),Ht=u(Ko,"P",{"data-svelte-h":!0}),b(Ht)!=="svelte-v8znqi"&&(Ht.textContent=un),Ko.forEach(o),yo=n(e),r(Ee.$$.fragment,e),xo=n(e),r(ze.$$.fragment,e),Mo=n(e),W=u(e,"DIV",{class:!0});var Et=w(W);r(Qe.$$.fragment,Et),Za=n(Et),Wt=u(Et,"P",{"data-svelte-h":!0}),b(Wt)!=="svelte-12byttf"&&(Wt.innerHTML=_n),Da=n(Et),r(pe.$$.fragment,Et),Et.forEach(o),To=n(e),r(qe.$$.fragment,e),Uo=n(e),E=u(e,"DIV",{class:!0});var ea=w(E);r(Ye.$$.fragment,ea),Ba=n(ea),Zt=u(ea,"P",{"data-svelte-h":!0}),b(Zt)!=="svelte-rf1vym"&&(Zt.innerHTML=gn),ea.forEach(o),Co=n(e),r(Se.$$.fragment,e),jo=n(e),z=u(e,"DIV",{class:!0});var ta=w(z);r(Oe.$$.fragment,ta),La=n(ta),Dt=u(ta,"P",{"data-svelte-h":!0}),b(Dt)!=="svelte-5orloz"&&(Dt.innerHTML=vn),ta.forEach(o),Jo=n(e),r(Ke.$$.fragment,e),Go=n(e),Q=u(e,"DIV",{class:!0});var oa=w(Q);r(et.$$.fragment,oa),Va=n(oa),Bt=u(oa,"P",{"data-svelte-h":!0}),b(Bt)!=="svelte-1anoa02"&&(Bt.innerHTML=bn),oa.forEach(o),Io=n(e),r(tt.$$.fragment,e),No=n(e),J=u(e,"DIV",{class:!0});var B=w(J);r(ot.$$.fragment,B),Aa=n(B),Lt=u(B,"P",{"data-svelte-h":!0}),b(Lt)!=="svelte-q70bcf"&&(Lt.innerHTML=kn),Pa=n(B),r(fe.$$.fragment,B),Ra=n(B),Vt=u(B,"P",{"data-svelte-h":!0}),b(Vt)!=="svelte-3cloev"&&(Vt.textContent=$n),Xa=n(B),r(ue.$$.fragment,B),B.forEach(o),Fo=n(e),r(at.$$.fragment,e),Ho=n(e),r(nt.$$.fragment,e),Wo=n(e),q=u(e,"DIV",{class:!0});var aa=w(q);r(st.$$.fragment,aa),Ea=n(aa),At=u(aa,"P",{"data-svelte-h":!0}),b(At)!=="svelte-1kj8409"&&(At.innerHTML=wn),aa.forEach(o),Zo=n(e),r(lt.$$.fragment,e),Do=n(e),Y=u(e,"DIV",{class:!0});var na=w(Y);r(dt.$$.fragment,na),za=n(na),Pt=u(na,"P",{"data-svelte-h":!0}),b(Pt)!=="svelte-xlirjm"&&(Pt.textContent=yn),na.forEach(o),Bo=n(e),r(ct.$$.fragment,e),Lo=n(e),r(rt.$$.fragment,e),Vo=n(e),S=u(e,"DIV",{class:!0});var sa=w(S);r(it.$$.fragment,sa),Qa=n(sa),Rt=u(sa,"P",{"data-svelte-h":!0}),b(Rt)!=="svelte-195dvsx"&&(Rt.textContent=xn),sa.forEach(o),Ao=n(e),r(mt.$$.fragment,e),Po=n(e),O=u(e,"DIV",{class:!0});var la=w(O);r(ht.$$.fragment,la),qa=n(la),Xt=u(la,"P",{"data-svelte-h":!0}),b(Xt)!=="svelte-17fy5vm"&&(Xt.textContent=Mn),la.forEach(o),Ro=n(e),r(pt.$$.fragment,e),Xo=n(e),zt=u(e,"P",{}),w(zt).forEach(o),this.h()},h(){y(l,"name","hf:doc:metadata"),y(l,"content",Pn),y(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,l),s(e,k,t),s(e,g,t),s(e,v,t),i($,e,t),s(e,_,t),i(T,e,t),s(e,Yt,t),i(_e,e,t),s(e,St,t),i(ge,e,t),s(e,Ot,t),s(e,G,t),i(ve,G,null),d(G,ca),d(G,gt),d(G,ra),i(ae,G,null),d(G,ia),i(ne,G,null),s(e,Kt,t),i(be,e,t),s(e,eo,t),s(e,L,t),i(ke,L,null),d(L,ma),d(L,vt),s(e,to,t),i($e,e,t),s(e,oo,t),s(e,N,t),i(we,N,null),d(N,ha),d(N,bt),d(N,pa),i(se,N,null),s(e,ao,t),i(ye,e,t),s(e,no,t),s(e,V,t),i(xe,V,null),d(V,fa),d(V,kt),s(e,so,t),i(Me,e,t),s(e,lo,t),s(e,A,t),i(Te,A,null),d(A,ua),d(A,$t),s(e,co,t),i(Ue,e,t),s(e,ro,t),s(e,F,t),i(Ce,F,null),d(F,_a),d(F,wt),d(F,ga),i(le,F,null),s(e,io,t),i(je,e,t),s(e,mo,t),s(e,H,t),i(Je,H,null),d(H,va),d(H,yt),d(H,ba),i(de,H,null),s(e,ho,t),i(Ge,e,t),s(e,po,t),s(e,I,t),i(Ie,I,null),d(I,ka),d(I,xt),d(I,$a),d(I,Mt),d(I,wa),i(ce,I,null),s(e,fo,t),i(Ne,e,t),s(e,uo,t),i(Fe,e,t),s(e,_o,t),s(e,U,t),i(He,U,null),d(U,ya),d(U,Tt),d(U,xa),d(U,Ut),d(U,Ma),d(U,Ct),d(U,Ta),d(U,re),i(We,re,null),d(re,Ua),d(re,jt),d(U,Ca),d(U,ie),i(Ze,ie,null),d(ie,ja),d(ie,Jt),d(U,Ja),d(U,me),i(De,me,null),d(me,Ga),d(me,Gt),d(U,Ia),d(U,he),i(Be,he,null),d(he,Na),d(he,It),s(e,go,t),i(Le,e,t),s(e,vo,t),s(e,P,t),i(Ve,P,null),d(P,Fa),d(P,Nt),s(e,bo,t),i(Ae,e,t),s(e,ko,t),s(e,R,t),i(Pe,R,null),d(R,Ha),d(R,Ft),s(e,$o,t),i(Re,e,t),s(e,wo,t),s(e,X,t),i(Xe,X,null),d(X,Wa),d(X,Ht),s(e,yo,t),i(Ee,e,t),s(e,xo,t),i(ze,e,t),s(e,Mo,t),s(e,W,t),i(Qe,W,null),d(W,Za),d(W,Wt),d(W,Da),i(pe,W,null),s(e,To,t),i(qe,e,t),s(e,Uo,t),s(e,E,t),i(Ye,E,null),d(E,Ba),d(E,Zt),s(e,Co,t),i(Se,e,t),s(e,jo,t),s(e,z,t),i(Oe,z,null),d(z,La),d(z,Dt),s(e,Jo,t),i(Ke,e,t),s(e,Go,t),s(e,Q,t),i(et,Q,null),d(Q,Va),d(Q,Bt),s(e,Io,t),i(tt,e,t),s(e,No,t),s(e,J,t),i(ot,J,null),d(J,Aa),d(J,Lt),d(J,Pa),i(fe,J,null),d(J,Ra),d(J,Vt),d(J,Xa),i(ue,J,null),s(e,Fo,t),i(at,e,t),s(e,Ho,t),i(nt,e,t),s(e,Wo,t),s(e,q,t),i(st,q,null),d(q,Ea),d(q,At),s(e,Zo,t),i(lt,e,t),s(e,Do,t),s(e,Y,t),i(dt,Y,null),d(Y,za),d(Y,Pt),s(e,Bo,t),i(ct,e,t),s(e,Lo,t),i(rt,e,t),s(e,Vo,t),s(e,S,t),i(it,S,null),d(S,Qa),d(S,Rt),s(e,Ao,t),i(mt,e,t),s(e,Po,t),s(e,O,t),i(ht,O,null),d(O,qa),d(O,Xt),s(e,Ro,t),i(pt,e,t),s(e,Xo,t),s(e,zt,t),Eo=!0},p(e,[t]){const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),ae.$set(Z);const ft={};t&2&&(ft.$$scope={dirty:t,ctx:e}),ne.$set(ft);const K={};t&2&&(K.$$scope={dirty:t,ctx:e}),se.$set(K);const ut={};t&2&&(ut.$$scope={dirty:t,ctx:e}),le.$set(ut);const _t={};t&2&&(_t.$$scope={dirty:t,ctx:e}),de.$set(_t);const ee={};t&2&&(ee.$$scope={dirty:t,ctx:e}),ce.$set(ee);const te={};t&2&&(te.$$scope={dirty:t,ctx:e}),pe.$set(te);const D={};t&2&&(D.$$scope={dirty:t,ctx:e}),fe.$set(D);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),ue.$set(j)},i(e){Eo||(m($.$$.fragment,e),m(T.$$.fragment,e),m(_e.$$.fragment,e),m(ge.$$.fragment,e),m(ve.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(be.$$.fragment,e),m(ke.$$.fragment,e),m($e.$$.fragment,e),m(we.$$.fragment,e),m(se.$$.fragment,e),m(ye.$$.fragment,e),m(xe.$$.fragment,e),m(Me.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(Ce.$$.fragment,e),m(le.$$.fragment,e),m(je.$$.fragment,e),m(Je.$$.fragment,e),m(de.$$.fragment,e),m(Ge.$$.fragment,e),m(Ie.$$.fragment,e),m(ce.$$.fragment,e),m(Ne.$$.fragment,e),m(Fe.$$.fragment,e),m(He.$$.fragment,e),m(We.$$.fragment,e),m(Ze.$$.fragment,e),m(De.$$.fragment,e),m(Be.$$.fragment,e),m(Le.$$.fragment,e),m(Ve.$$.fragment,e),m(Ae.$$.fragment,e),m(Pe.$$.fragment,e),m(Re.$$.fragment,e),m(Xe.$$.fragment,e),m(Ee.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(pe.$$.fragment,e),m(qe.$$.fragment,e),m(Ye.$$.fragment,e),m(Se.$$.fragment,e),m(Oe.$$.fragment,e),m(Ke.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(ot.$$.fragment,e),m(fe.$$.fragment,e),m(ue.$$.fragment,e),m(at.$$.fragment,e),m(nt.$$.fragment,e),m(st.$$.fragment,e),m(lt.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),m(rt.$$.fragment,e),m(it.$$.fragment,e),m(mt.$$.fragment,e),m(ht.$$.fragment,e),m(pt.$$.fragment,e),Eo=!0)},o(e){h($.$$.fragment,e),h(T.$$.fragment,e),h(_e.$$.fragment,e),h(ge.$$.fragment,e),h(ve.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(be.$$.fragment,e),h(ke.$$.fragment,e),h($e.$$.fragment,e),h(we.$$.fragment,e),h(se.$$.fragment,e),h(ye.$$.fragment,e),h(xe.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(Ue.$$.fragment,e),h(Ce.$$.fragment,e),h(le.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),h(de.$$.fragment,e),h(Ge.$$.fragment,e),h(Ie.$$.fragment,e),h(ce.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(He.$$.fragment,e),h(We.$$.fragment,e),h(Ze.$$.fragment,e),h(De.$$.fragment,e),h(Be.$$.fragment,e),h(Le.$$.fragment,e),h(Ve.$$.fragment,e),h(Ae.$$.fragment,e),h(Pe.$$.fragment,e),h(Re.$$.fragment,e),h(Xe.$$.fragment,e),h(Ee.$$.fragment,e),h(ze.$$.fragment,e),h(Qe.$$.fragment,e),h(pe.$$.fragment,e),h(qe.$$.fragment,e),h(Ye.$$.fragment,e),h(Se.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(rt.$$.fragment,e),h(it.$$.fragment,e),h(mt.$$.fragment,e),h(ht.$$.fragment,e),h(pt.$$.fragment,e),Eo=!1},d(e){e&&(o(k),o(g),o(v),o(_),o(Yt),o(St),o(Ot),o(G),o(Kt),o(eo),o(L),o(to),o(oo),o(N),o(ao),o(no),o(V),o(so),o(lo),o(A),o(co),o(ro),o(F),o(io),o(mo),o(H),o(ho),o(po),o(I),o(fo),o(uo),o(_o),o(U),o(go),o(vo),o(P),o(bo),o(ko),o(R),o($o),o(wo),o(X),o(yo),o(xo),o(Mo),o(W),o(To),o(Uo),o(E),o(Co),o(jo),o(z),o(Jo),o(Go),o(Q),o(Io),o(No),o(J),o(Fo),o(Ho),o(Wo),o(q),o(Zo),o(Do),o(Y),o(Bo),o(Lo),o(Vo),o(S),o(Ao),o(Po),o(O),o(Ro),o(Xo),o(zt)),o(l),p($,e),p(T,e),p(_e,e),p(ge,e),p(ve),p(ae),p(ne),p(be,e),p(ke),p($e,e),p(we),p(se),p(ye,e),p(xe),p(Me,e),p(Te),p(Ue,e),p(Ce),p(le),p(je,e),p(Je),p(de),p(Ge,e),p(Ie),p(ce),p(Ne,e),p(Fe,e),p(He),p(We),p(Ze),p(De),p(Be),p(Le,e),p(Ve),p(Ae,e),p(Pe),p(Re,e),p(Xe),p(Ee,e),p(ze,e),p(Qe),p(pe),p(qe,e),p(Ye),p(Se,e),p(Oe),p(Ke,e),p(et),p(tt,e),p(ot),p(fe),p(ue),p(at,e),p(nt,e),p(st),p(lt,e),p(dt),p(ct,e),p(rt,e),p(it),p(mt,e),p(ht),p(pt,e)}}}const Pn='{"title":"Working with large models","local":"working-with-large-models","sections":[{"title":"Dispatch and offload","local":"dispatch-and-offload","sections":[{"title":"init_empty_weights","local":"accelerate.init_empty_weights","sections":[],"depth":3},{"title":"cpu_offload","local":"accelerate.cpu_offload","sections":[],"depth":3},{"title":"cpu_offload_with_hook","local":"accelerate.cpu_offload_with_hook","sections":[],"depth":3},{"title":"disk_offload","local":"accelerate.disk_offload","sections":[],"depth":3},{"title":"dispatch_model","local":"accelerate.dispatch_model","sections":[],"depth":3},{"title":"load_checkpoint_and_dispatch","local":"accelerate.load_checkpoint_and_dispatch","sections":[],"depth":3},{"title":"load_checkpoint_in_model","local":"accelerate.load_checkpoint_in_model","sections":[],"depth":3},{"title":"infer_auto_device_map","local":"accelerate.infer_auto_device_map","sections":[],"depth":3}],"depth":2},{"title":"Hooks","local":"hooks","sections":[{"title":"ModelHook","local":"accelerate.hooks.ModelHook","sections":[],"depth":3},{"title":"AlignDevicesHook","local":"accelerate.hooks.AlignDevicesHook","sections":[],"depth":3},{"title":"SequentialHook","local":"accelerate.hooks.SequentialHook","sections":[],"depth":3},{"title":"LayerwiseCastingHook","local":"accelerate.hooks.LayerwiseCastingHook","sections":[],"depth":3}],"depth":2},{"title":"Adding Hooks","local":"adding-hooks","sections":[{"title":"add_hook_to_module","local":"accelerate.hooks.add_hook_to_module","sections":[],"depth":3},{"title":"attach_execution_device_hook","local":"accelerate.hooks.attach_execution_device_hook","sections":[],"depth":3},{"title":"attach_align_device_hook","local":"accelerate.hooks.attach_align_device_hook","sections":[],"depth":3},{"title":"attach_align_device_hook_on_blocks","local":"accelerate.hooks.attach_align_device_hook_on_blocks","sections":[],"depth":3},{"title":"attach_layerwise_casting_hooks","local":"accelerate.big_modeling.attach_layerwise_casting_hooks","sections":[],"depth":3}],"depth":2},{"title":"Removing Hooks","local":"removing-hooks","sections":[{"title":"remove_hook_from_module","local":"accelerate.hooks.remove_hook_from_module","sections":[],"depth":3},{"title":"remove_hook_from_submodules","local":"accelerate.hooks.remove_hook_from_submodules","sections":[],"depth":3}],"depth":2},{"title":"Utilities","local":"utilities","sections":[{"title":"has_offloaded_params","local":"accelerate.utils.has_offloaded_params","sections":[],"depth":3},{"title":"align_module_device","local":"accelerate.utils.align_module_device","sections":[],"depth":3}],"depth":2}],"depth":1}';function Rn(C){return Un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class On extends Cn{constructor(l){super(),jn(this,l,Rn,An,Tn,{})}}export{On as component};
