import{s as Ge,n as xe,o as ke}from"../chunks/scheduler.9cda857a.js";import{S as Ce,i as Le,e as s,s as l,c as u,h as Pe,a,d as i,b as o,f as be,g as m,j as r,k as nt,l as He,m as n,n as p,t as g,o as f,p as c}from"../chunks/index.003612b0.js";import{C as _e}from"../chunks/CopyLLMTxtMenu.44d08a39.js";import{C as Nt}from"../chunks/CodeBlock.a90632f1.js";import{H as lt,E as Ee}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e5cfda8c.js";function Ue(Qt){let d,ot,et,st,$,at,w,rt,T,Kt="<code>git</code> has an authentication layer to control who can push commits to a repo, but it does not authenticate the actual commit authors.",ut,M,Vt="In other words, you can commit changes as <code>Elon Musk &lt;elon@tesla.com&gt;</code>, push them to your preferred <code>git</code> host (for instance github.com), and your commit will link to Elon’s GitHub profile. (Try it! But don’t blame us if Elon gets mad at you for impersonating him.)",mt,b,Xt="The reasons we implemented GPG signing were:",pt,G,Dt="<li>To provide finer-grained security, especially as more and more Enterprise users rely on the Hub.</li> <li>To provide ML benchmarks backed by a cryptographically-secure source.</li>",gt,x,Rt='See Ale Segala’s <a href="https://withblue.ink/2020/05/17/how-and-why-to-sign-git-commits.html" rel="nofollow">How (and why) to sign <code>git</code> commits</a> for more context.',ft,k,te="You can prove a commit was authored by you with GNU Privacy Guard (GPG) and a key server. GPG is a cryptographic tool used to verify the authenticity of a message’s origin. We’ll explain how to set this up on Hugging Face below.",ct,C,ee='The Pro Git book is, as usual, a good resource about commit signing: <a href="https://git-scm.com/book/en/v2/Git-Tools-Signing-Your-Work" rel="nofollow">Pro Git: Signing your work</a>.',dt,L,ht,P,ie='You will need to install <a href="https://gnupg.org/" rel="nofollow">GPG</a> on your system in order to execute the following commands.',yt,H,ne=`<p>It’s included by default in most Linux distributions.
On Windows, it is included in Git Bash (which comes with <code>git</code> for Windows).</p>`,vt,_,le=`You can sign your commits locally using <a href="https://gnupg.org/" rel="nofollow">GPG</a>.
Then configure your profile to mark these commits as <strong>verified</strong> on the Hub,
so other people can be confident that they come from a trusted source.`,$t,E,oe='For a more in-depth explanation of how git and GPG interact, please visit the <a href="https://git-scm.com/book/en/v2/Git-Tools-Signing-Your-Work" rel="nofollow">git documentation on the subject</a>',wt,U,se="Commits can have the following signing statuses:",Tt,S,ae="<thead><tr><th>Status</th> <th>Explanation</th></tr></thead> <tbody><tr><td>Verified</td> <td>The commit is signed and the signature is verified</td></tr> <tr><td>Unverified</td> <td>The commit is signed but the signature could not be verified</td></tr> <tr><td>No signing status</td> <td>The commit is not signed</td></tr></tbody>",Mt,I,re="For a commit to be marked as <strong>verified</strong>, you need to upload the public key used to sign it on your Hugging Face account.",bt,J,ue=`Use the <code>gpg --list-secret-keys</code> command to list the GPG keys for which you have both a public and private key.
A private key is required for signing commits or tags.`,Gt,W,me="If you don’t have a GPG key pair or you don’t want to use the existing keys to sign your commits, go to <strong>Generating a new GPG key</strong>.",xt,Y,pe='Otherwise, go straight to  <a href="#adding-a-gpg-key-to-your-account">Adding a GPG key to your account</a>.',kt,j,Ct,q,ge="To generate a GPG key, run the following:",Lt,B,Pt,F,fe="GPG will then guide you through the process of creating a GPG key pair.",Ht,O,ce='Make sure you specify an email address for this key, and that the email address matches the one you specified in your Hugging Face <a href="https://huggingface.co/settings/account" rel="nofollow">account</a>.',_t,Z,Et,A,de='<li><p>First, select or generate a GPG key on your computer. Make sure the email address of the key matches the one in your Hugging Face <a href="https://huggingface.co/settings/account" rel="nofollow">account</a> and that the email of your account is verified.</p></li> <li><p>Export the public part of the selected key:</p></li>',Ut,z,St,h,he='<li>Then visit your profile <a href="https://huggingface.co/settings/keys" rel="nofollow">settings page</a> and click on <strong>Add GPG Key</strong>.</li>',It,N,ye="Copy &amp; paste the output of the <code>gpg --export</code> command in the text area and click on <strong>Add Key</strong>.",Jt,y,ve="<li>Congratulations! 🎉  You’ve just added a GPG key to your account!</li>",Wt,Q,Yt,K,$e="The last step is to configure git to sign your commits:",jt,V,qt,X,we="Then add the <code>-S</code> flag to your <code>git commit</code> commands to sign your commits!",Bt,D,Ft,R,Te="Once pushed on the Hub, you should see the commit with a “Verified” badge.",Ot,v,Me="<p>To sign all commits by default in any local repository on your computer, you can run <code>git config —global commit.gpgsign true</code>.</p>",Zt,tt,At,it,zt;return $=new _e({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new lt({props:{title:"Signing commits with GPG",local:"signing-commits-with-gpg",headingTag:"h1"}}),L=new lt({props:{title:"Setting up signed commits verification",local:"setting-up-signed-commits-verification",headingTag:"h2"}}),j=new lt({props:{title:"Generating a new GPG key",local:"generating-a-new-gpg-key",headingTag:"h2"}}),B=new Nt({props:{code:"Z3BnJTIwLS1nZW4ta2V5",highlighted:"gpg --gen-key",wrap:!1}}),Z=new lt({props:{title:"Adding a GPG key to your account",local:"adding-a-gpg-key-to-your-account",headingTag:"h2"}}),z=new Nt({props:{code:"Z3BnJTIwLS1hcm1vciUyMC0tZXhwb3J0JTIwJTNDWU9VUiUyMEtFWSUyMElEJTNF",highlighted:'gpg --armor --<span class="hljs-built_in">export</span> &lt;YOUR KEY ID&gt;',wrap:!1}}),Q=new lt({props:{title:"Configure git to sign your commits with GPG",local:"configure-git-to-sign-your-commits-with-gpg",headingTag:"h2"}}),V=new Nt({props:{code:"Z2l0JTIwY29uZmlnJTIwdXNlci5zaWduaW5na2V5JTIwJTNDWW91ciUyMEdQRyUyMEtleSUyMElEJTNFJTBBZ2l0JTIwY29uZmlnJTIwdXNlci5lbWFpbCUyMCUzQ1lvdXIlMjBlbWFpbCUyMG9uJTIwaGYuY28lM0U=",highlighted:`git config user.signingkey &lt;Your GPG Key ID&gt;
git config user.email &lt;Your email on hf.co&gt;`,wrap:!1}}),D=new Nt({props:{code:"Z2l0JTIwY29tbWl0JTIwLVMlMjAtbSUyMCUyMk15JTIwZmlyc3QlMjBzaWduZWQlMjBjb21taXQlMjI=",highlighted:'git commit -S -m <span class="hljs-string">&quot;My first signed commit&quot;</span>',wrap:!1}}),tt=new Ee({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/security-gpg.md"}}),{c(){d=s("meta"),ot=l(),et=s("p"),st=l(),u($.$$.fragment),at=l(),u(w.$$.fragment),rt=l(),T=s("p"),T.innerHTML=Kt,ut=l(),M=s("p"),M.innerHTML=Vt,mt=l(),b=s("p"),b.textContent=Xt,pt=l(),G=s("ul"),G.innerHTML=Dt,gt=l(),x=s("p"),x.innerHTML=Rt,ft=l(),k=s("p"),k.textContent=te,ct=l(),C=s("p"),C.innerHTML=ee,dt=l(),u(L.$$.fragment),ht=l(),P=s("p"),P.innerHTML=ie,yt=l(),H=s("blockquote"),H.innerHTML=ne,vt=l(),_=s("p"),_.innerHTML=le,$t=l(),E=s("p"),E.innerHTML=oe,wt=l(),U=s("p"),U.textContent=se,Tt=l(),S=s("table"),S.innerHTML=ae,Mt=l(),I=s("p"),I.innerHTML=re,bt=l(),J=s("p"),J.innerHTML=ue,Gt=l(),W=s("p"),W.innerHTML=me,xt=l(),Y=s("p"),Y.innerHTML=pe,kt=l(),u(j.$$.fragment),Ct=l(),q=s("p"),q.textContent=ge,Lt=l(),u(B.$$.fragment),Pt=l(),F=s("p"),F.textContent=fe,Ht=l(),O=s("p"),O.innerHTML=ce,_t=l(),u(Z.$$.fragment),Et=l(),A=s("ol"),A.innerHTML=de,Ut=l(),u(z.$$.fragment),St=l(),h=s("ol"),h.innerHTML=he,It=l(),N=s("p"),N.innerHTML=ye,Jt=l(),y=s("ol"),y.innerHTML=ve,Wt=l(),u(Q.$$.fragment),Yt=l(),K=s("p"),K.textContent=$e,jt=l(),u(V.$$.fragment),qt=l(),X=s("p"),X.innerHTML=we,Bt=l(),u(D.$$.fragment),Ft=l(),R=s("p"),R.textContent=Te,Ot=l(),v=s("blockquote"),v.innerHTML=Me,Zt=l(),u(tt.$$.fragment),At=l(),it=s("p"),this.h()},l(t){const e=Pe("svelte-u9bgzb",document.head);d=a(e,"META",{name:!0,content:!0}),e.forEach(i),ot=o(t),et=a(t,"P",{}),be(et).forEach(i),st=o(t),m($.$$.fragment,t),at=o(t),m(w.$$.fragment,t),rt=o(t),T=a(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-16xioii"&&(T.innerHTML=Kt),ut=o(t),M=a(t,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1496un1"&&(M.innerHTML=Vt),mt=o(t),b=a(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-iec5lg"&&(b.textContent=Xt),pt=o(t),G=a(t,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-1ruuqle"&&(G.innerHTML=Dt),gt=o(t),x=a(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-y864g7"&&(x.innerHTML=Rt),ft=o(t),k=a(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-n96a7q"&&(k.textContent=te),ct=o(t),C=a(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-138n0c9"&&(C.innerHTML=ee),dt=o(t),m(L.$$.fragment,t),ht=o(t),P=a(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1p8rrlz"&&(P.innerHTML=ie),yt=o(t),H=a(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(H)!=="svelte-osktdt"&&(H.innerHTML=ne),vt=o(t),_=a(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-6aimav"&&(_.innerHTML=le),$t=o(t),E=a(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-f3qnla"&&(E.innerHTML=oe),wt=o(t),U=a(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-b4b7dr"&&(U.textContent=se),Tt=o(t),S=a(t,"TABLE",{"data-svelte-h":!0}),r(S)!=="svelte-8x81wm"&&(S.innerHTML=ae),Mt=o(t),I=a(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-fgh5wb"&&(I.innerHTML=re),bt=o(t),J=a(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1pe2s2l"&&(J.innerHTML=ue),Gt=o(t),W=a(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-okgo5j"&&(W.innerHTML=me),xt=o(t),Y=a(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1dhnlqh"&&(Y.innerHTML=pe),kt=o(t),m(j.$$.fragment,t),Ct=o(t),q=a(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-emmsc9"&&(q.textContent=ge),Lt=o(t),m(B.$$.fragment,t),Pt=o(t),F=a(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-yy4ur9"&&(F.textContent=fe),Ht=o(t),O=a(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1u70yn5"&&(O.innerHTML=ce),_t=o(t),m(Z.$$.fragment,t),Et=o(t),A=a(t,"OL",{"data-svelte-h":!0}),r(A)!=="svelte-1wz0fdq"&&(A.innerHTML=de),Ut=o(t),m(z.$$.fragment,t),St=o(t),h=a(t,"OL",{start:!0,"data-svelte-h":!0}),r(h)!=="svelte-1cndhv3"&&(h.innerHTML=he),It=o(t),N=a(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1gi8bl1"&&(N.innerHTML=ye),Jt=o(t),y=a(t,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-1wu31pe"&&(y.innerHTML=ve),Wt=o(t),m(Q.$$.fragment,t),Yt=o(t),K=a(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-ui06bn"&&(K.textContent=$e),jt=o(t),m(V.$$.fragment,t),qt=o(t),X=a(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-t1hkz2"&&(X.innerHTML=we),Bt=o(t),m(D.$$.fragment,t),Ft=o(t),R=a(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-j4g221"&&(R.textContent=Te),Ot=o(t),v=a(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1pyat7v"&&(v.innerHTML=Me),Zt=o(t),m(tt.$$.fragment,t),At=o(t),it=a(t,"P",{}),be(it).forEach(i),this.h()},h(){nt(d,"name","hf:doc:metadata"),nt(d,"content",Se),nt(h,"start","3"),nt(y,"start","4"),nt(v,"class","tip")},m(t,e){He(document.head,d),n(t,ot,e),n(t,et,e),n(t,st,e),p($,t,e),n(t,at,e),p(w,t,e),n(t,rt,e),n(t,T,e),n(t,ut,e),n(t,M,e),n(t,mt,e),n(t,b,e),n(t,pt,e),n(t,G,e),n(t,gt,e),n(t,x,e),n(t,ft,e),n(t,k,e),n(t,ct,e),n(t,C,e),n(t,dt,e),p(L,t,e),n(t,ht,e),n(t,P,e),n(t,yt,e),n(t,H,e),n(t,vt,e),n(t,_,e),n(t,$t,e),n(t,E,e),n(t,wt,e),n(t,U,e),n(t,Tt,e),n(t,S,e),n(t,Mt,e),n(t,I,e),n(t,bt,e),n(t,J,e),n(t,Gt,e),n(t,W,e),n(t,xt,e),n(t,Y,e),n(t,kt,e),p(j,t,e),n(t,Ct,e),n(t,q,e),n(t,Lt,e),p(B,t,e),n(t,Pt,e),n(t,F,e),n(t,Ht,e),n(t,O,e),n(t,_t,e),p(Z,t,e),n(t,Et,e),n(t,A,e),n(t,Ut,e),p(z,t,e),n(t,St,e),n(t,h,e),n(t,It,e),n(t,N,e),n(t,Jt,e),n(t,y,e),n(t,Wt,e),p(Q,t,e),n(t,Yt,e),n(t,K,e),n(t,jt,e),p(V,t,e),n(t,qt,e),n(t,X,e),n(t,Bt,e),p(D,t,e),n(t,Ft,e),n(t,R,e),n(t,Ot,e),n(t,v,e),n(t,Zt,e),p(tt,t,e),n(t,At,e),n(t,it,e),zt=!0},p:xe,i(t){zt||(g($.$$.fragment,t),g(w.$$.fragment,t),g(L.$$.fragment,t),g(j.$$.fragment,t),g(B.$$.fragment,t),g(Z.$$.fragment,t),g(z.$$.fragment,t),g(Q.$$.fragment,t),g(V.$$.fragment,t),g(D.$$.fragment,t),g(tt.$$.fragment,t),zt=!0)},o(t){f($.$$.fragment,t),f(w.$$.fragment,t),f(L.$$.fragment,t),f(j.$$.fragment,t),f(B.$$.fragment,t),f(Z.$$.fragment,t),f(z.$$.fragment,t),f(Q.$$.fragment,t),f(V.$$.fragment,t),f(D.$$.fragment,t),f(tt.$$.fragment,t),zt=!1},d(t){t&&(i(ot),i(et),i(st),i(at),i(rt),i(T),i(ut),i(M),i(mt),i(b),i(pt),i(G),i(gt),i(x),i(ft),i(k),i(ct),i(C),i(dt),i(ht),i(P),i(yt),i(H),i(vt),i(_),i($t),i(E),i(wt),i(U),i(Tt),i(S),i(Mt),i(I),i(bt),i(J),i(Gt),i(W),i(xt),i(Y),i(kt),i(Ct),i(q),i(Lt),i(Pt),i(F),i(Ht),i(O),i(_t),i(Et),i(A),i(Ut),i(St),i(h),i(It),i(N),i(Jt),i(y),i(Wt),i(Yt),i(K),i(jt),i(qt),i(X),i(Bt),i(Ft),i(R),i(Ot),i(v),i(Zt),i(At),i(it)),i(d),c($,t),c(w,t),c(L,t),c(j,t),c(B,t),c(Z,t),c(z,t),c(Q,t),c(V,t),c(D,t),c(tt,t)}}}const Se='{"title":"Signing commits with GPG","local":"signing-commits-with-gpg","sections":[{"title":"Setting up signed commits verification","local":"setting-up-signed-commits-verification","sections":[],"depth":2},{"title":"Generating a new GPG key","local":"generating-a-new-gpg-key","sections":[],"depth":2},{"title":"Adding a GPG key to your account","local":"adding-a-gpg-key-to-your-account","sections":[],"depth":2},{"title":"Configure git to sign your commits with GPG","local":"configure-git-to-sign-your-commits-with-gpg","sections":[],"depth":2}],"depth":1}';function Ie(Qt){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Be extends Ce{constructor(d){super(),Le(this,d,Ie,Ue,Ge,{})}}export{Be as component};
