import{s as $t,n as Bt,o as vt}from"../chunks/scheduler.9cda857a.js";import{S as Zt,i as Rt,e as p,s as a,c,h as Ct,a as i,d as t,b as n,f as kt,g as r,j as o,k as T,l as Vt,m as l,n as h,t as u,o as M,p as d}from"../chunks/index.003612b0.js";import{C as Gt}from"../chunks/CopyLLMTxtMenu.44d08a39.js";import{C as m}from"../chunks/CodeBlock.a90632f1.js";import{H as g,E as Lt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e5cfda8c.js";function Ht(Ws){let j,Ze,Be,Re,v,Ce,Z,Ve,R,Qs='In the following sections, you’ll learn the basics of creating a Docker Space, configuring it, and deploying your code to it. We’ll create a <strong>Text Generation</strong> Space with Docker that’ll be used to demo the <a href="https://huggingface.co/google/flan-t5-small" rel="nofollow">google/flan-t5-small</a> model, which can generate text given some input text, using FastAPI as the server.',Ge,C,_s='You can find a completed version of this hosted <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">here</a>.',Le,V,He,G,Ns='We’ll start by <a href="https://huggingface.co/new-space" rel="nofollow">creating a brand new Space</a> and choosing <strong>Docker</strong> as our SDK.',xe,w,zs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface.co_new-space_docker.jpg"/>',Ee,L,qs='Hugging Face Spaces are Git repositories, meaning that you can work on your Space incrementally (and collaboratively) by pushing commits. Take a look at the <a href="./repositories-getting-started">Getting Started with Repositories</a> guide to learn about how you can create and edit files before continuing. If you prefer to work with a UI, you can also do the work directly in the browser.',Se,H,Fs='Selecting <strong>Docker</strong> as the SDK when <a href="https://huggingface.co/new-space" rel="nofollow">creating a new Space</a> will initialize your Docker Space by setting the <code>sdk</code> property to <code>docker</code> in your <code>README.md</code> file’s YAML block.',Ae,x,Xe,E,Ys="You have the option to change the default application port of your Space by setting the <code>app_port</code> property in your <code>README.md</code> file’s YAML block. The default port is <code>7860</code>.",We,S,Qe,A,_e,X,Ds='For the <strong>Text Generation</strong> Space, we’ll be building a FastAPI app that showcases a text generation model called Flan T5. For the model inference, we’ll be using a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to use the model. We need to start by installing a few dependencies. This can be done by creating a <strong>requirements.txt</strong> file in our repository, and adding the following dependencies to it:',Ne,W,ze,Q,Ps="These dependencies will be installed in the Dockerfile we’ll create later.",qe,_,Fe,N,Os="Let’s kick off the process with a dummy FastAPI app to see that we can get an endpoint working. The first step is to create an app file, in this case, we’ll call it <code>main.py</code>.",Ye,z,De,q,Pe,F,Ks='The main step for a Docker Space is creating a Dockerfile. You can read more about Dockerfiles <a href="https://docs.docker.com/get-started/" rel="nofollow">here</a>. Although we’re using FastAPI in this tutorial, Dockerfiles give great flexibility to users allowing you to build a new generation of ML demos. Let’s write the Dockerfile for our application',Oe,Y,Ke,D,et='When the changes are saved, the Space will rebuild and your demo should be up after a couple of seconds! <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_dummy" rel="nofollow">Here</a> is an example result at this point.',es,f,st='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_dummy.jpg"/>',ss,P,ts,O,tt="<strong>Tip for power users (you can skip):</strong> If you’re developing locally, this is a good moment in which you can do <code>docker build</code> and <code>docker run</code> to debug locally, but it’s even easier to push the changes to the Hub and see how it looks like!",ls,K,as,ee,lt='If you have <a href="spaces-sdks-docker#secret-management">Secrets</a> you can use <code>docker buildx</code> and pass the secrets as build arguments',ns,se,ps,te,at="and run with <code>docker run</code> passing the secrets as environment variables",is,le,os,ae,cs,ne,nt="As mentioned before, the idea is to use a Flan T5 model for text generation. We’ll want to add some HTML and CSS for an input field, so let’s create a directory called static with <code>index.html</code>, <code>style.css</code>, and <code>script.js</code> files. At this moment, your file structure should look like this:",rs,pe,hs,ie,pt='Let’s go through all the steps to make this working. We’ll skip some of the details of the CSS and HTML. You can find the whole code in the Files and versions tab of the <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">DockerTemplates/fastapi_t5</a> Space.',us,oe,it="<li>Write the FastAPI endpoint to do inference</li>",Ms,ce,ot='We’ll use the <code>pipeline</code> from <code>transformers</code> to load the <a href="https://huggingface.co/google/flan-t5-small" rel="nofollow">google/flan-t5-small</a> model. We’ll set an endpoint called <code>infer_t5</code> that receives and input and outputs the result of the inference call',ds,re,ms,y,ct="<li>Write the <code>index.html</code> to have a simple form containing the code of the page.</li>",Ts,he,js,J,rt="<li>In the <code>main.py</code> file, mount the static files and show the html file in the root route</li>",gs,ue,ws,U,ht="<li>In the <code>script.js</code> file, make it handle the request</li>",fs,Me,ys,I,ut="<li>Grant permissions to the right directories</li>",Js,de,Mt='As discussed in the <a href="./spaces-sdks-docker#permissions">Permissions Section</a>, the container runs with user ID 1000. That means that the Space might face permission issues. For example, <code>transformers</code> downloads and caches the models in the path under the <code>HF_HOME</code> path. The easiest way to solve this is to create a user with righ permissions and use it to run the container application. We can do this by adding the following lines to the <code>Dockerfile</code>.',Us,me,Is,Te,dt="The final <code>Dockerfile</code> should look like this:",bs,je,ks,ge,mt='Success! Your app should be working now! Check out <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">DockerTemplates/fastapi_t5</a> to see the final result.',$s,b,Tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5.jpg"/>',Bs,we,jt='What a journey! Please remember that Docker Spaces give you lots of freedom, so you’re not limited to use FastAPI. From a <a href="https://huggingface.co/spaces/DockerTemplates/test-docker-go" rel="nofollow">Go Endpoint</a> to a <a href="https://huggingface.co/spaces/DockerTemplates/shiny-with-python" rel="nofollow">Shiny App</a>, the limit is the moon! Check out <a href="./spaces-sdks-docker-examples">some official examples</a>. You can also upgrade your Space to a GPU if needed 😃',vs,fe,Zs,ye,gt="You can debug your Space by checking the <strong>Build</strong> and <strong>Container</strong> logs. Click on the <strong>Open Logs</strong> button to open the modal.",Rs,k,wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_3.jpg"/>',Cs,Je,ft="If everything went well, you will see <code>Pushing Image</code> and <code>Scheduling Space</code> on the <strong>Build</strong> tab",Vs,$,yt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_1.jpg"/>',Gs,Ue,Jt="On the <strong>Container</strong> tab, you will see the application status, in this case, <code>Uvicorn running on http://0.0.0.0:7860</code>",Ls,B,Ut='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_2.jpg"/>',Hs,Ie,It='Additionally, you can enable the Dev Mode on your Space. The Dev Mode allows you to connect to your running Space via VSCode or SSH. Learn more here: <a href="https://huggingface.co/dev-mode-explorers" rel="nofollow">https://huggingface.co/dev-mode-explorers</a>',xs,be,Es,ke,bt='<li><a href="spaces-sdks-docker">Docker Spaces</a></li> <li><a href="spaces-sdks-docker-examples">List of Docker Spaces examples</a></li>',Ss,$e,As,ve,Xs;return v=new Gt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),Z=new g({props:{title:"Your First Docker Space: Text Generation with T5",local:"your-first-docker-space-text-generation-with-t5",headingTag:"h1"}}),V=new g({props:{title:"Create a new Docker Space",local:"create-a-new-docker-space",headingTag:"h2"}}),x=new m({props:{code:"c2RrJTNBJTIwZG9ja2Vy",highlighted:'<span class="hljs-attr">sdk:</span> <span class="hljs-string">docker</span>',wrap:!1}}),S=new m({props:{code:"YXBwX3BvcnQlM0ElMjA3ODYw",highlighted:'<span class="hljs-attr">app_port:</span> <span class="hljs-number">7860</span>',wrap:!1}}),A=new g({props:{title:"Add the dependencies",local:"add-the-dependencies",headingTag:"h2"}}),W=new m({props:{code:"ZmFzdGFwaSUzRCUzRDAuNzQuKiUwQXJlcXVlc3RzJTNEJTNEMi4yNy4qJTBBc2VudGVuY2VwaWVjZSUzRCUzRDAuMS4qJTBBdG9yY2glM0QlM0QxLjExLiolMEF0cmFuc2Zvcm1lcnMlM0QlM0Q0LiolMEF1dmljb3JuJTVCc3RhbmRhcmQlNUQlM0QlM0QwLjE3Lio=",highlighted:`<span class="hljs-attribute">fastapi</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.74</span>.*
<span class="hljs-attribute">requests</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">2.27</span>.*
<span class="hljs-attribute">sentencepiece</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.1</span>.*
<span class="hljs-attribute">torch</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">1.11</span>.*
<span class="hljs-attribute">transformers</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">4</span>.*
uvicorn[standard]<span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.17</span>.*`,wrap:!1}}),_=new g({props:{title:"Create the app",local:"create-the-app",headingTag:"h2"}}),z=new m({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBJTBBYXBwJTIwJTNEJTIwRmFzdEFQSSgpJTBBJTBBJTQwYXBwLmdldCglMjIlMkYlMjIpJTBBZGVmJTIwcmVhZF9yb290KCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJIZWxsbyUyMiUzQSUyMCUyMldvcmxkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

app = FastAPI()

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_root</span>():
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;Hello&quot;</span>: <span class="hljs-string">&quot;World!&quot;</span>}`,wrap:!1}}),q=new g({props:{title:"Create the Dockerfile",local:"create-the-dockerfile",headingTag:"h2"}}),Y=new m({props:{code:"JTIzJTIwcmVhZCUyMHRoZSUyMGRvYyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc3BhY2VzLXNka3MtZG9ja2VyJTBBJTIzJTIweW91JTIwd2lsbCUyMGFsc28lMjBmaW5kJTIwZ3VpZGVzJTIwb24lMjBob3clMjBiZXN0JTIwdG8lMjB3cml0ZSUyMHlvdXIlMjBEb2NrZXJmaWxlJTBBJTBBRlJPTSUyMHB5dGhvbiUzQTMuOSUwQSUwQSUyMyUyMFRoZSUyMHR3byUyMGZvbGxvd2luZyUyMGxpbmVzJTIwYXJlJTIwcmVxdWlyZW1lbnRzJTIwZm9yJTIwdGhlJTIwRGV2JTIwTW9kZSUyMHRvJTIwYmUlMjBmdW5jdGlvbmFsJTBBJTIzJTIwTGVhcm4lMjBtb3JlJTIwYWJvdXQlMjB0aGUlMjBEZXYlMjBNb2RlJTIwYXQlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGV2LW1vZGUtZXhwbG9yZXJzJTBBUlVOJTIwdXNlcmFkZCUyMC1tJTIwLXUlMjAxMDAwJTIwdXNlciUwQVdPUktESVIlMjAlMkZhcHAlMEElMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTJGcmVxdWlyZW1lbnRzLnR4dCUyMHJlcXVpcmVtZW50cy50eHQlMEFSVU4lMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjAtciUyMHJlcXVpcmVtZW50cy50eHQlMEElMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTIwJTJGYXBwJTBBQ01EJTIwJTVCJTIydXZpY29ybiUyMiUyQyUyMCUyMm1haW4lM0FhcHAlMjIlMkMlMjAlMjItLWhvc3QlMjIlMkMlMjAlMjIwLjAuMC4wJTIyJTJDJTIwJTIyLS1wb3J0JTIyJTJDJTIwJTIyNzg2MCUyMiU1RCUwQQ==",highlighted:`<span class="hljs-comment"># read the doc: https://huggingface.co/docs/hub/spaces-sdks-docker</span>
<span class="hljs-comment"># you will also find guides on how best to write your Dockerfile</span>

<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.9</span>

<span class="hljs-comment"># The two following lines are requirements for the Dev Mode to be functional</span>
<span class="hljs-comment"># Learn more about the Dev Mode at https://huggingface.co/dev-mode-explorers</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> useradd -m -u 1000 user</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user ./requirements.txt requirements.txt</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> pip install --no-cache-dir --upgrade -r requirements.txt</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user . /app</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;uvicorn&quot;</span>, <span class="hljs-string">&quot;main:app&quot;</span>, <span class="hljs-string">&quot;--host&quot;</span>, <span class="hljs-string">&quot;0.0.0.0&quot;</span>, <span class="hljs-string">&quot;--port&quot;</span>, <span class="hljs-string">&quot;7860&quot;</span>]</span>
`,wrap:!1}}),P=new g({props:{title:"Testing locally",local:"testing-locally",headingTag:"h3"}}),K=new m({props:{code:"ZG9ja2VyJTIwYnVpbGQlMjAtdCUyMGZhc3RhcGklMjAuJTBBZG9ja2VyJTIwcnVuJTIwJTIwLWl0JTIwLXAlMjA3ODYwJTNBNzg2MCUyMGZhc3RhcGk=",highlighted:`docker build -t fastapi .
docker run  -it -p 7860:7860 fastapi`,wrap:!1}}),se=new m({props:{code:"ZXhwb3J0JTIwU0VDUkVUX0VYQU1QTEUlM0QlMjJteV9zZWNyZXRfdmFsdWUlMjIlMEFkb2NrZXIlMjBidWlsZHglMjBidWlsZCUyMC0tc2VjcmV0JTIwaWQlM0RTRUNSRVRfRVhBTVBMRSUyQ2VudiUzRFNFQ1JFVF9FWEFNUExFJTIwLXQlMjBmYXN0YXBpJTIwLg==",highlighted:`<span class="hljs-built_in">export</span> SECRET_EXAMPLE=<span class="hljs-string">&quot;my_secret_value&quot;</span>
docker buildx build --secret <span class="hljs-built_in">id</span>=SECRET_EXAMPLE,<span class="hljs-built_in">env</span>=SECRET_EXAMPLE -t fastapi .`,wrap:!1}}),le=new m({props:{code:"ZXhwb3J0JTIwU0VDUkVUX0VYQU1QTEUlM0QlMjJteV9zZWNyZXRfdmFsdWUlMjIlMEFkb2NrZXIlMjBydW4lMjAtaXQlMjAtcCUyMDc4NjAlM0E3ODYwJTIwLWUlMjBTRUNSRVRfRVhBTVBMRSUzRCUyNFNFQ1JFVF9FWEFNUExFJTIwZmFzdGFwaQ==",highlighted:`<span class="hljs-built_in">export</span> SECRET_EXAMPLE=<span class="hljs-string">&quot;my_secret_value&quot;</span>
docker run -it -p 7860:7860 -e SECRET_EXAMPLE=<span class="hljs-variable">$SECRET_EXAMPLE</span> fastapi`,wrap:!1}}),ae=new g({props:{title:"Adding some ML to our app",local:"adding-some-ml-to-our-app",headingTag:"h2"}}),pe=new m({props:{code:"JTJGc3RhdGljJTBBJTJGc3RhdGljJTJGaW5kZXguaHRtbCUwQSUyRnN0YXRpYyUyRnNjcmlwdC5qcyUwQSUyRnN0YXRpYyUyRnN0eWxlLmNzcyUwQURvY2tlcmZpbGUlMEFtYWluLnB5JTBBUkVBRE1FLm1kJTBBcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`/static
/static/index.html
/static/script.js
/static/style.css
Dockerfile
main.py
README.md
requirements.txt`,wrap:!1}}),re=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZV9mbGFuJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dDJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRmZsYW4tdDUtc21hbGwlMjIpJTBBJTBBJTQwYXBwLmdldCglMjIlMkZpbmZlcl90NSUyMiklMEFkZWYlMjB0NShpbnB1dCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBwaXBlX2ZsYW4oaW5wdXQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyb3V0cHV0JTIyJTNBJTIwb3V0cHV0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTdE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe_flan = pipeline(<span class="hljs-string">&quot;text2text-generation&quot;</span>, model=<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/infer_t5&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">t5</span>(<span class="hljs-params"><span class="hljs-built_in">input</span></span>):
    output = pipe_flan(<span class="hljs-built_in">input</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;output&quot;</span>: output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]}`,wrap:!1}}),he=new m({props:{code:"JTNDbWFpbiUzRSUwQSUyMCUyMCUzQ3NlY3Rpb24lMjBpZCUzRCUyMnRleHQtZ2VuJTIyJTNFJTBBJTIwJTIwJTIwJTIwJTNDaDIlM0VUZXh0JTIwZ2VuZXJhdGlvbiUyMHVzaW5nJTIwRmxhbiUyMFQ1JTNDJTJGaDIlM0UlMEElMjAlMjAlMjAlMjAlM0NwJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwTW9kZWwlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NhJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHJlZiUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVsJTNEJTIybm9yZWZlcnJlciUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCUzRCUyMl9ibGFuayUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRWdvb2dsZSUyRmZsYW4tdDUtc21hbGwlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0MlMkZhJTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGcCUzRSUwQSUyMCUyMCUyMCUyMCUzQ2Zvcm0lMjBjbGFzcyUzRCUyMnRleHQtZ2VuLWZvcm0lMjIlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NsYWJlbCUyMGZvciUzRCUyMnRleHQtZ2VuLWlucHV0JTIyJTNFVGV4dCUyMHByb21wdCUzQyUyRmxhYmVsJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDaW5wdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUzRCUyMnRleHQtZ2VuLWlucHV0JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2YWx1ZSUzRCUyMkdlcm1hbiUzQSUyMFRoZXJlJTIwYXJlJTIwbWFueSUyMGR1Y2tzJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDYnV0dG9uJTIwaWQlM0QlMjJ0ZXh0LWdlbi1zdWJtaXQlMjIlM0VTdWJtaXQlM0MlMkZidXR0b24lM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NwJTIwY2xhc3MlM0QlMjJ0ZXh0LWdlbi1vdXRwdXQlMjIlM0UlM0MlMkZwJTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGZm9ybSUzRSUwQSUyMCUyMCUzQyUyRnNlY3Rpb24lM0UlMEElM0MlMkZtYWluJTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">main</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">section</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen&quot;</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">h2</span>&gt;</span>Text generation using Flan T5<span class="hljs-tag">&lt;/<span class="hljs-name">h2</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">p</span>&gt;</span>
      Model:
      <span class="hljs-tag">&lt;<span class="hljs-name">a</span>
        <span class="hljs-attr">href</span>=<span class="hljs-string">&quot;https://huggingface.co/google/flan-t5-small&quot;</span>
        <span class="hljs-attr">rel</span>=<span class="hljs-string">&quot;noreferrer&quot;</span>
        <span class="hljs-attr">target</span>=<span class="hljs-string">&quot;_blank&quot;</span>
        &gt;</span>google/flan-t5-small
      <span class="hljs-tag">&lt;/<span class="hljs-name">a</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">form</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;text-gen-form&quot;</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">label</span> <span class="hljs-attr">for</span>=<span class="hljs-string">&quot;text-gen-input&quot;</span>&gt;</span>Text prompt<span class="hljs-tag">&lt;/<span class="hljs-name">label</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">input</span>
        <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen-input&quot;</span>
        <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;text&quot;</span>
        <span class="hljs-attr">value</span>=<span class="hljs-string">&quot;German: There are many ducks&quot;</span>
      /&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">button</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen-submit&quot;</span>&gt;</span>Submit<span class="hljs-tag">&lt;/<span class="hljs-name">button</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">p</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;text-gen-output&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">form</span>&gt;</span>
  <span class="hljs-tag">&lt;/<span class="hljs-name">section</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">main</span>&gt;</span>`,wrap:!1}}),ue=new m({props:{code:"YXBwLm1vdW50KCUyMiUyRiUyMiUyQyUyMFN0YXRpY0ZpbGVzKGRpcmVjdG9yeSUzRCUyMnN0YXRpYyUyMiUyQyUyMGh0bWwlM0RUcnVlKSUyQyUyMG5hbWUlM0QlMjJzdGF0aWMlMjIpJTBBJTBBJTQwYXBwLmdldCglMjIlMkYlMjIpJTBBZGVmJTIwaW5kZXgoKSUyMC0lM0UlMjBGaWxlUmVzcG9uc2UlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBGaWxlUmVzcG9uc2UocGF0aCUzRCUyMiUyRmFwcCUyRnN0YXRpYyUyRmluZGV4Lmh0bWwlMjIlMkMlMjBtZWRpYV90eXBlJTNEJTIydGV4dCUyRmh0bWwlMjIp",highlighted:`app.mount(<span class="hljs-string">&quot;/&quot;</span>, StaticFiles(directory=<span class="hljs-string">&quot;static&quot;</span>, html=<span class="hljs-literal">True</span>), name=<span class="hljs-string">&quot;static&quot;</span>)

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">index</span>() -&gt; FileResponse:
    <span class="hljs-keyword">return</span> FileResponse(path=<span class="hljs-string">&quot;/app/static/index.html&quot;</span>, media_type=<span class="hljs-string">&quot;text/html&quot;</span>)`,wrap:!1}}),Me=new m({props:{code:"Y29uc3QlMjB0ZXh0R2VuRm9ybSUyMCUzRCUyMGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3IoJTIyLnRleHQtZ2VuLWZvcm0lMjIpJTNCJTBBJTBBY29uc3QlMjB0cmFuc2xhdGVUZXh0JTIwJTNEJTIwYXN5bmMlMjAodGV4dCklMjAlM0QlM0UlMjAlN0IlMEElMjAlMjBjb25zdCUyMGluZmVyUmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGZldGNoKCU2MGluZmVyX3Q1JTNGaW5wdXQlM0QlMjQlN0J0ZXh0JTdEJTYwKSUzQiUwQSUyMCUyMGNvbnN0JTIwaW5mZXJKc29uJTIwJTNEJTIwYXdhaXQlMjBpbmZlclJlc3BvbnNlLmpzb24oKSUzQiUwQSUwQSUyMCUyMHJldHVybiUyMGluZmVySnNvbi5vdXRwdXQlM0IlMEElN0QlM0IlMEElMEF0ZXh0R2VuRm9ybS5hZGRFdmVudExpc3RlbmVyKCUyMnN1Ym1pdCUyMiUyQyUyMGFzeW5jJTIwKGV2ZW50KSUyMCUzRCUzRSUyMCU3QiUwQSUyMCUyMGV2ZW50LnByZXZlbnREZWZhdWx0KCklM0IlMEElMEElMjAlMjBjb25zdCUyMHRleHRHZW5JbnB1dCUyMCUzRCUyMGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCUyMnRleHQtZ2VuLWlucHV0JTIyKSUzQiUwQSUyMCUyMGNvbnN0JTIwdGV4dEdlblBhcmFncmFwaCUyMCUzRCUyMGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3IoJTIyLnRleHQtZ2VuLW91dHB1dCUyMiklM0IlMEElMEElMjAlMjB0ZXh0R2VuUGFyYWdyYXBoLnRleHRDb250ZW50JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdGVUZXh0KHRleHRHZW5JbnB1dC52YWx1ZSklM0IlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">const</span> textGenForm = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">querySelector</span>(<span class="hljs-string">&quot;.text-gen-form&quot;</span>);

<span class="hljs-keyword">const</span> <span class="hljs-title function_">translateText</span> = <span class="hljs-keyword">async</span> (<span class="hljs-params">text</span>) =&gt; {
  <span class="hljs-keyword">const</span> inferResponse = <span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">\`infer_t5?input=<span class="hljs-subst">\${text}</span>\`</span>);
  <span class="hljs-keyword">const</span> inferJson = <span class="hljs-keyword">await</span> inferResponse.<span class="hljs-title function_">json</span>();

  <span class="hljs-keyword">return</span> inferJson.<span class="hljs-property">output</span>;
};

textGenForm.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&quot;submit&quot;</span>, <span class="hljs-keyword">async</span> (event) =&gt; {
  event.<span class="hljs-title function_">preventDefault</span>();

  <span class="hljs-keyword">const</span> textGenInput = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;text-gen-input&quot;</span>);
  <span class="hljs-keyword">const</span> textGenParagraph = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">querySelector</span>(<span class="hljs-string">&quot;.text-gen-output&quot;</span>);

  textGenParagraph.<span class="hljs-property">textContent</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translateText</span>(textGenInput.<span class="hljs-property">value</span>);
});`,wrap:!1}}),me=new m({props:{code:"JTIzJTIwU3dpdGNoJTIwdG8lMjB0aGUlMjAlMjJ1c2VyJTIyJTIwdXNlciUwQVVTRVIlMjB1c2VyJTBBJTBBJTIzJTIwU2V0JTIwaG9tZSUyMHRvJTIwdGhlJTIwdXNlcidzJTIwaG9tZSUyMGRpcmVjdG9yeSUwQUVOViUyMEhPTUUlM0QlMkZob21lJTJGdXNlciUyMCU1QyUwQSUwOVBBVEglM0QlMkZob21lJTJGdXNlciUyRi5sb2NhbCUyRmJpbiUzQSUyNFBBVEg=",highlighted:`<span class="hljs-comment"># Switch to the &quot;user&quot; user</span>
<span class="hljs-keyword">USER</span> <span class="hljs-keyword">user</span>

<span class="hljs-comment"># Set home to the user&#x27;s home directory</span>
<span class="hljs-keyword">ENV</span> HOME=/home/<span class="hljs-keyword">user</span> \\
	PATH=/home/<span class="hljs-keyword">user</span>/.local/bin:$PATH`,wrap:!1}}),je=new m({props:{code:"JTBBJTIzJTIwcmVhZCUyMHRoZSUyMGRvYyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc3BhY2VzLXNka3MtZG9ja2VyJTBBJTIzJTIweW91JTIwd2lsbCUyMGFsc28lMjBmaW5kJTIwZ3VpZGVzJTIwb24lMjBob3clMjBiZXN0JTIwdG8lMjB3cml0ZSUyMHlvdXIlMjBEb2NrZXJmaWxlJTBBJTBBRlJPTSUyMHB5dGhvbiUzQTMuOSUwQSUwQSUyMyUyMFRoZSUyMHR3byUyMGZvbGxvd2luZyUyMGxpbmVzJTIwYXJlJTIwcmVxdWlyZW1lbnRzJTIwZm9yJTIwdGhlJTIwRGV2JTIwTW9kZSUyMHRvJTIwYmUlMjBmdW5jdGlvbmFsJTBBJTIzJTIwTGVhcm4lMjBtb3JlJTIwYWJvdXQlMjB0aGUlMjBEZXYlMjBNb2RlJTIwYXQlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGV2LW1vZGUtZXhwbG9yZXJzJTBBUlVOJTIwdXNlcmFkZCUyMC1tJTIwLXUlMjAxMDAwJTIwdXNlciUwQVdPUktESVIlMjAlMkZhcHAlMEElMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTJGcmVxdWlyZW1lbnRzLnR4dCUyMHJlcXVpcmVtZW50cy50eHQlMEFSVU4lMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjAtciUyMHJlcXVpcmVtZW50cy50eHQlMEElMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTIwJTJGYXBwJTBBJTBBVVNFUiUyMHVzZXIlMEElMEFFTlYlMjBIT01FJTNEJTJGaG9tZSUyRnVzZXIlMjAlNUMlMEElMDlQQVRIJTNEJTJGaG9tZSUyRnVzZXIlMkYubG9jYWwlMkZiaW4lM0ElMjRQQVRIJTBBJTBBQ01EJTIwJTVCJTIydXZpY29ybiUyMiUyQyUyMCUyMm1haW4lM0FhcHAlMjIlMkMlMjAlMjItLWhvc3QlMjIlMkMlMjAlMjIwLjAuMC4wJTIyJTJDJTIwJTIyLS1wb3J0JTIyJTJDJTIwJTIyNzg2MCUyMiU1RA==",highlighted:`
<span class="hljs-comment"># read the doc: https://huggingface.co/docs/hub/spaces-sdks-docker</span>
<span class="hljs-comment"># you will also find guides on how best to write your Dockerfile</span>

<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.9</span>

<span class="hljs-comment"># The two following lines are requirements for the Dev Mode to be functional</span>
<span class="hljs-comment"># Learn more about the Dev Mode at https://huggingface.co/dev-mode-explorers</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> useradd -m -u 1000 user</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user ./requirements.txt requirements.txt</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> pip install --no-cache-dir --upgrade -r requirements.txt</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user . /app</span>

<span class="hljs-keyword">USER</span> <span class="hljs-keyword">user</span>

<span class="hljs-keyword">ENV</span> HOME=/home/<span class="hljs-keyword">user</span> \\
	PATH=/home/<span class="hljs-keyword">user</span>/.local/bin:$PATH

<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;uvicorn&quot;</span>, <span class="hljs-string">&quot;main:app&quot;</span>, <span class="hljs-string">&quot;--host&quot;</span>, <span class="hljs-string">&quot;0.0.0.0&quot;</span>, <span class="hljs-string">&quot;--port&quot;</span>, <span class="hljs-string">&quot;7860&quot;</span>]</span>`,wrap:!1}}),fe=new g({props:{title:"Debugging",local:"debugging",headingTag:"h2"}}),be=new g({props:{title:"Read More",local:"read-more",headingTag:"h2"}}),$e=new Lt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-sdks-docker-first-demo.md"}}),{c(){j=p("meta"),Ze=a(),Be=p("p"),Re=a(),c(v.$$.fragment),Ce=a(),c(Z.$$.fragment),Ve=a(),R=p("p"),R.innerHTML=Qs,Ge=a(),C=p("p"),C.innerHTML=_s,Le=a(),c(V.$$.fragment),He=a(),G=p("p"),G.innerHTML=Ns,xe=a(),w=p("div"),w.innerHTML=zs,Ee=a(),L=p("p"),L.innerHTML=qs,Se=a(),H=p("p"),H.innerHTML=Fs,Ae=a(),c(x.$$.fragment),Xe=a(),E=p("p"),E.innerHTML=Ys,We=a(),c(S.$$.fragment),Qe=a(),c(A.$$.fragment),_e=a(),X=p("p"),X.innerHTML=Ds,Ne=a(),c(W.$$.fragment),ze=a(),Q=p("p"),Q.textContent=Ps,qe=a(),c(_.$$.fragment),Fe=a(),N=p("p"),N.innerHTML=Os,Ye=a(),c(z.$$.fragment),De=a(),c(q.$$.fragment),Pe=a(),F=p("p"),F.innerHTML=Ks,Oe=a(),c(Y.$$.fragment),Ke=a(),D=p("p"),D.innerHTML=et,es=a(),f=p("div"),f.innerHTML=st,ss=a(),c(P.$$.fragment),ts=a(),O=p("p"),O.innerHTML=tt,ls=a(),c(K.$$.fragment),as=a(),ee=p("p"),ee.innerHTML=lt,ns=a(),c(se.$$.fragment),ps=a(),te=p("p"),te.innerHTML=at,is=a(),c(le.$$.fragment),os=a(),c(ae.$$.fragment),cs=a(),ne=p("p"),ne.innerHTML=nt,rs=a(),c(pe.$$.fragment),hs=a(),ie=p("p"),ie.innerHTML=pt,us=a(),oe=p("ol"),oe.innerHTML=it,Ms=a(),ce=p("p"),ce.innerHTML=ot,ds=a(),c(re.$$.fragment),ms=a(),y=p("ol"),y.innerHTML=ct,Ts=a(),c(he.$$.fragment),js=a(),J=p("ol"),J.innerHTML=rt,gs=a(),c(ue.$$.fragment),ws=a(),U=p("ol"),U.innerHTML=ht,fs=a(),c(Me.$$.fragment),ys=a(),I=p("ol"),I.innerHTML=ut,Js=a(),de=p("p"),de.innerHTML=Mt,Us=a(),c(me.$$.fragment),Is=a(),Te=p("p"),Te.innerHTML=dt,bs=a(),c(je.$$.fragment),ks=a(),ge=p("p"),ge.innerHTML=mt,$s=a(),b=p("div"),b.innerHTML=Tt,Bs=a(),we=p("p"),we.innerHTML=jt,vs=a(),c(fe.$$.fragment),Zs=a(),ye=p("p"),ye.innerHTML=gt,Rs=a(),k=p("div"),k.innerHTML=wt,Cs=a(),Je=p("p"),Je.innerHTML=ft,Vs=a(),$=p("div"),$.innerHTML=yt,Gs=a(),Ue=p("p"),Ue.innerHTML=Jt,Ls=a(),B=p("div"),B.innerHTML=Ut,Hs=a(),Ie=p("p"),Ie.innerHTML=It,xs=a(),c(be.$$.fragment),Es=a(),ke=p("ul"),ke.innerHTML=bt,Ss=a(),c($e.$$.fragment),As=a(),ve=p("p"),this.h()},l(e){const s=Ct("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(t),Ze=n(e),Be=i(e,"P",{}),kt(Be).forEach(t),Re=n(e),r(v.$$.fragment,e),Ce=n(e),r(Z.$$.fragment,e),Ve=n(e),R=i(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-jw7cyg"&&(R.innerHTML=Qs),Ge=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1i4ovll"&&(C.innerHTML=_s),Le=n(e),r(V.$$.fragment,e),He=n(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-v1etaf"&&(G.innerHTML=Ns),xe=n(e),w=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1t9e90m"&&(w.innerHTML=zs),Ee=n(e),L=i(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1eepspk"&&(L.innerHTML=qs),Se=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1ebivvn"&&(H.innerHTML=Fs),Ae=n(e),r(x.$$.fragment,e),Xe=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-16g740l"&&(E.innerHTML=Ys),We=n(e),r(S.$$.fragment,e),Qe=n(e),r(A.$$.fragment,e),_e=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-saf9yg"&&(X.innerHTML=Ds),Ne=n(e),r(W.$$.fragment,e),ze=n(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-nrg5eu"&&(Q.textContent=Ps),qe=n(e),r(_.$$.fragment,e),Fe=n(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-o8f96i"&&(N.innerHTML=Os),Ye=n(e),r(z.$$.fragment,e),De=n(e),r(q.$$.fragment,e),Pe=n(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1jworwg"&&(F.innerHTML=Ks),Oe=n(e),r(Y.$$.fragment,e),Ke=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1qy8wh6"&&(D.innerHTML=et),es=n(e),f=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1gv7naz"&&(f.innerHTML=st),ss=n(e),r(P.$$.fragment,e),ts=n(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1887xzo"&&(O.innerHTML=tt),ls=n(e),r(K.$$.fragment,e),as=n(e),ee=i(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1wqy5vs"&&(ee.innerHTML=lt),ns=n(e),r(se.$$.fragment,e),ps=n(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-zs1fi1"&&(te.innerHTML=at),is=n(e),r(le.$$.fragment,e),os=n(e),r(ae.$$.fragment,e),cs=n(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1gdsumy"&&(ne.innerHTML=nt),rs=n(e),r(pe.$$.fragment,e),hs=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-16tk1cq"&&(ie.innerHTML=pt),us=n(e),oe=i(e,"OL",{"data-svelte-h":!0}),o(oe)!=="svelte-42bpu9"&&(oe.innerHTML=it),Ms=n(e),ce=i(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1s0pz1q"&&(ce.innerHTML=ot),ds=n(e),r(re.$$.fragment,e),ms=n(e),y=i(e,"OL",{start:!0,"data-svelte-h":!0}),o(y)!=="svelte-k9s0qn"&&(y.innerHTML=ct),Ts=n(e),r(he.$$.fragment,e),js=n(e),J=i(e,"OL",{start:!0,"data-svelte-h":!0}),o(J)!=="svelte-fmvgb8"&&(J.innerHTML=rt),gs=n(e),r(ue.$$.fragment,e),ws=n(e),U=i(e,"OL",{start:!0,"data-svelte-h":!0}),o(U)!=="svelte-ztetn2"&&(U.innerHTML=ht),fs=n(e),r(Me.$$.fragment,e),ys=n(e),I=i(e,"OL",{start:!0,"data-svelte-h":!0}),o(I)!=="svelte-1dn7zpw"&&(I.innerHTML=ut),Js=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-6lf4gt"&&(de.innerHTML=Mt),Us=n(e),r(me.$$.fragment,e),Is=n(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-hrrqd1"&&(Te.innerHTML=dt),bs=n(e),r(je.$$.fragment,e),ks=n(e),ge=i(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-cvojof"&&(ge.innerHTML=mt),$s=n(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-7ddsz3"&&(b.innerHTML=Tt),Bs=n(e),we=i(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1m82b2h"&&(we.innerHTML=jt),vs=n(e),r(fe.$$.fragment,e),Zs=n(e),ye=i(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-40o9jr"&&(ye.innerHTML=gt),Rs=n(e),k=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-15efue1"&&(k.innerHTML=wt),Cs=n(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-86h2ue"&&(Je.innerHTML=ft),Vs=n(e),$=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-1kv7f9v"&&($.innerHTML=yt),Gs=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-10fpzqt"&&(Ue.innerHTML=Jt),Ls=n(e),B=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(B)!=="svelte-1wbh090"&&(B.innerHTML=Ut),Hs=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-yw4wzo"&&(Ie.innerHTML=It),xs=n(e),r(be.$$.fragment,e),Es=n(e),ke=i(e,"UL",{"data-svelte-h":!0}),o(ke)!=="svelte-bhfcx6"&&(ke.innerHTML=bt),Ss=n(e),r($e.$$.fragment,e),As=n(e),ve=i(e,"P",{}),kt(ve).forEach(t),this.h()},h(){T(j,"name","hf:doc:metadata"),T(j,"content",xt),T(w,"class","flex justify-center"),T(f,"class","flex justify-center"),T(y,"start","2"),T(J,"start","3"),T(U,"start","4"),T(I,"start","5"),T(b,"class","flex justify-center"),T(k,"class","flex justify-center"),T($,"class","flex justify-center"),T(B,"class","flex justify-center")},m(e,s){Vt(document.head,j),l(e,Ze,s),l(e,Be,s),l(e,Re,s),h(v,e,s),l(e,Ce,s),h(Z,e,s),l(e,Ve,s),l(e,R,s),l(e,Ge,s),l(e,C,s),l(e,Le,s),h(V,e,s),l(e,He,s),l(e,G,s),l(e,xe,s),l(e,w,s),l(e,Ee,s),l(e,L,s),l(e,Se,s),l(e,H,s),l(e,Ae,s),h(x,e,s),l(e,Xe,s),l(e,E,s),l(e,We,s),h(S,e,s),l(e,Qe,s),h(A,e,s),l(e,_e,s),l(e,X,s),l(e,Ne,s),h(W,e,s),l(e,ze,s),l(e,Q,s),l(e,qe,s),h(_,e,s),l(e,Fe,s),l(e,N,s),l(e,Ye,s),h(z,e,s),l(e,De,s),h(q,e,s),l(e,Pe,s),l(e,F,s),l(e,Oe,s),h(Y,e,s),l(e,Ke,s),l(e,D,s),l(e,es,s),l(e,f,s),l(e,ss,s),h(P,e,s),l(e,ts,s),l(e,O,s),l(e,ls,s),h(K,e,s),l(e,as,s),l(e,ee,s),l(e,ns,s),h(se,e,s),l(e,ps,s),l(e,te,s),l(e,is,s),h(le,e,s),l(e,os,s),h(ae,e,s),l(e,cs,s),l(e,ne,s),l(e,rs,s),h(pe,e,s),l(e,hs,s),l(e,ie,s),l(e,us,s),l(e,oe,s),l(e,Ms,s),l(e,ce,s),l(e,ds,s),h(re,e,s),l(e,ms,s),l(e,y,s),l(e,Ts,s),h(he,e,s),l(e,js,s),l(e,J,s),l(e,gs,s),h(ue,e,s),l(e,ws,s),l(e,U,s),l(e,fs,s),h(Me,e,s),l(e,ys,s),l(e,I,s),l(e,Js,s),l(e,de,s),l(e,Us,s),h(me,e,s),l(e,Is,s),l(e,Te,s),l(e,bs,s),h(je,e,s),l(e,ks,s),l(e,ge,s),l(e,$s,s),l(e,b,s),l(e,Bs,s),l(e,we,s),l(e,vs,s),h(fe,e,s),l(e,Zs,s),l(e,ye,s),l(e,Rs,s),l(e,k,s),l(e,Cs,s),l(e,Je,s),l(e,Vs,s),l(e,$,s),l(e,Gs,s),l(e,Ue,s),l(e,Ls,s),l(e,B,s),l(e,Hs,s),l(e,Ie,s),l(e,xs,s),h(be,e,s),l(e,Es,s),l(e,ke,s),l(e,Ss,s),h($e,e,s),l(e,As,s),l(e,ve,s),Xs=!0},p:Bt,i(e){Xs||(u(v.$$.fragment,e),u(Z.$$.fragment,e),u(V.$$.fragment,e),u(x.$$.fragment,e),u(S.$$.fragment,e),u(A.$$.fragment,e),u(W.$$.fragment,e),u(_.$$.fragment,e),u(z.$$.fragment,e),u(q.$$.fragment,e),u(Y.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(re.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(me.$$.fragment,e),u(je.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u($e.$$.fragment,e),Xs=!0)},o(e){M(v.$$.fragment,e),M(Z.$$.fragment,e),M(V.$$.fragment,e),M(x.$$.fragment,e),M(S.$$.fragment,e),M(A.$$.fragment,e),M(W.$$.fragment,e),M(_.$$.fragment,e),M(z.$$.fragment,e),M(q.$$.fragment,e),M(Y.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(se.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(re.$$.fragment,e),M(he.$$.fragment,e),M(ue.$$.fragment,e),M(Me.$$.fragment,e),M(me.$$.fragment,e),M(je.$$.fragment,e),M(fe.$$.fragment,e),M(be.$$.fragment,e),M($e.$$.fragment,e),Xs=!1},d(e){e&&(t(Ze),t(Be),t(Re),t(Ce),t(Ve),t(R),t(Ge),t(C),t(Le),t(He),t(G),t(xe),t(w),t(Ee),t(L),t(Se),t(H),t(Ae),t(Xe),t(E),t(We),t(Qe),t(_e),t(X),t(Ne),t(ze),t(Q),t(qe),t(Fe),t(N),t(Ye),t(De),t(Pe),t(F),t(Oe),t(Ke),t(D),t(es),t(f),t(ss),t(ts),t(O),t(ls),t(as),t(ee),t(ns),t(ps),t(te),t(is),t(os),t(cs),t(ne),t(rs),t(hs),t(ie),t(us),t(oe),t(Ms),t(ce),t(ds),t(ms),t(y),t(Ts),t(js),t(J),t(gs),t(ws),t(U),t(fs),t(ys),t(I),t(Js),t(de),t(Us),t(Is),t(Te),t(bs),t(ks),t(ge),t($s),t(b),t(Bs),t(we),t(vs),t(Zs),t(ye),t(Rs),t(k),t(Cs),t(Je),t(Vs),t($),t(Gs),t(Ue),t(Ls),t(B),t(Hs),t(Ie),t(xs),t(Es),t(ke),t(Ss),t(As),t(ve)),t(j),d(v,e),d(Z,e),d(V,e),d(x,e),d(S,e),d(A,e),d(W,e),d(_,e),d(z,e),d(q,e),d(Y,e),d(P,e),d(K,e),d(se,e),d(le,e),d(ae,e),d(pe,e),d(re,e),d(he,e),d(ue,e),d(Me,e),d(me,e),d(je,e),d(fe,e),d(be,e),d($e,e)}}}const xt='{"title":"Your First Docker Space: Text Generation with T5","local":"your-first-docker-space-text-generation-with-t5","sections":[{"title":"Create a new Docker Space","local":"create-a-new-docker-space","sections":[],"depth":2},{"title":"Add the dependencies","local":"add-the-dependencies","sections":[],"depth":2},{"title":"Create the app","local":"create-the-app","sections":[],"depth":2},{"title":"Create the Dockerfile","local":"create-the-dockerfile","sections":[{"title":"Testing locally","local":"testing-locally","sections":[],"depth":3}],"depth":2},{"title":"Adding some ML to our app","local":"adding-some-ml-to-our-app","sections":[],"depth":2},{"title":"Debugging","local":"debugging","sections":[],"depth":2},{"title":"Read More","local":"read-more","sections":[],"depth":2}],"depth":1}';function Et(Ws){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends Zt{constructor(j){super(),Rt(this,j,Et,Ht,$t,{})}}export{_t as component};
