import{s as kt,n as gt,o as vt}from"../chunks/scheduler.9cda857a.js";import{S as Ct,i as Ut,e as o,s as n,c,h as $t,a as i,d as s,b as a,f as jt,g as u,j as p,k as Ye,l as Bt,m as l,n as r,t as h,o as m,p as b}from"../chunks/index.003612b0.js";import{C as Nt}from"../chunks/CopyLLMTxtMenu.44d08a39.js";import{C as Oe}from"../chunks/CodeBlock.a90632f1.js";import{H as te,E as xt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e5cfda8c.js";function Qt(De){let d,ne,se,ae,M,oe,w,ie,T,ze="<p>Webhooks are now publicly available!</p>",pe,y,Xe="Here’s a short guide on how to use Hugging Face Webhooks to build a bot that replies to Discussion comments on the Hub with a response generated by BLOOM, a multilingual language model, using the free Inference API.",ce,J,ue,j,Ge='First, let’s create a Webhook from your <a href="https://huggingface.co/settings/webhooks" rel="nofollow">settings</a>.',re,k,Fe="<li>Input a few target repositories that your Webhook will listen to.</li> <li>You can put a dummy Webhook URL for now, but defining your webhook will let you look at the events that will be sent to it (and you can replay them, which will be useful for debugging).</li> <li>Input a secret as it will be more secure.</li> <li>Subscribe to Community (PR &amp; discussions) events, as we are building a Discussion bot.</li>",he,g,Ke="Your Webhook will look like this:",me,v,et='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/webhook-creation.png" alt="webhook-creation"/>',be,C,de,U,tt="In this guide, we create a separate user account to host a Space and to post comments:",Te,$,st='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/discussion-bot-profile.png" alt="discussion-bot-profile"/>',fe,f,lt="<p>When creating a bot that will interact with other users on the Hub, we ask that you clearly label the account as a “Bot” (see profile screenshot).</p>",Me,B,we,N,nt="The third step is actually to listen to the Webhook events.",ye,x,at="An easy way is to use a Space for this. We use the user account we created, but you could do it from your main user account if you wanted to.",Je,Q,ot='The Space’s code is <a href="https://huggingface.co/spaces/discussion-bot/webhook/tree/main" rel="nofollow">here</a>.',je,_,it='We used NodeJS and Typescript to implement it, but any language or framework would work equally well. Read more about Docker Spaces <a href="https://huggingface.co/docs/hub/spaces-sdks-docker" rel="nofollow">here</a>.',ke,E,pt='<strong>The main <code>server.ts</code> file is <a href="https://huggingface.co/spaces/discussion-bot/webhook/blob/main/server.ts" rel="nofollow">here</a></strong>',ge,I,ct="Let’s walk through what happens in this file:",ve,S,Ce,L,ut="Here, we listen to POST requests made to <code>/</code>, and then we check that the <code>X-Webhook-Secret</code> header is equal to the secret we had previously defined (you need to also set the <code>WEBHOOK_SECRET</code> secret in your Space’s settings to be able to verify it).",Ue,W,$e,H,rt="The event’s payload is encoded as JSON. Here, we specify that we will run our Webhook only when:",Be,A,ht="<li>the event concerns a discussion comment</li> <li>the event is a creation, i.e. a new comment has been posted</li> <li>the comment’s content contains <code>@discussion-bot</code>, i.e. our bot was just mentioned in a comment.</li>",Ne,R,mt="In that case, we will continue to the next step:",xe,V,Qe,Z,bt="This is the coolest part: we call the Inference API for the BLOOM model, prompting it with <code>PROMPT</code>, and we get the continuation text, i.e., the part generated by the model.",_e,q,dt="Finally, we will post it as a reply in the same discussion thread:",Ee,P,Ie,Y,Se,O,Tt="Last but not least, you’ll need to configure your Webhook to send POST requests to your Space.",Le,D,ft="Let’s first grab our Space’s “direct URL” from the contextual menu. Click on “Embed this Space” and copy the “Direct URL”.",We,z,Mt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/embed-space.png" alt="embed this Space"/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/direct-url.png" alt="direct URL"/>',He,X,wt="Update your webhook to send requests to that URL:",Ae,G,yt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/webhook-creation.png" alt="webhook settings"/>',Re,F,Ve,K,Jt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/discussion-result.png" alt="discussion-result"/>',Ze,ee,qe,le,Pe;return M=new Nt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new te({props:{title:"Webhook guide: build a Discussion bot based on BLOOM",local:"webhook-guide-build-a-discussion-bot-based-on-bloom",headingTag:"h1"}}),J=new te({props:{title:"Create your Webhook in your user profile",local:"create-your-webhook-in-your-user-profile",headingTag:"h2"}}),C=new te({props:{title:"Create a new Bot user profile",local:"create-a-new-bot-user-profile",headingTag:"h2"}}),B=new te({props:{title:"Create a Space that will react to your Webhook",local:"create-a-space-that-will-react-to-your-webhook",headingTag:"h2"}}),S=new Oe({props:{code:"YXBwLnBvc3QoJTIyJTJGJTIyJTJDJTIwYXN5bmMlMjAocmVxJTJDJTIwcmVzKSUyMCUzRCUzRSUyMCU3QiUwQSUwOWlmJTIwKHJlcS5oZWFkZXIoJTIyWC1XZWJob29rLVNlY3JldCUyMiklMjAhJTNEJTNEJTIwcHJvY2Vzcy5lbnYuV0VCSE9PS19TRUNSRVQpJTIwJTdCJTBBJTA5JTA5Y29uc29sZS5lcnJvciglMjJpbmNvcnJlY3QlMjBzZWNyZXQlMjIpJTNCJTBBJTA5JTA5cmV0dXJuJTIwcmVzLnN0YXR1cyg0MDApLmpzb24oJTdCJTIwZXJyb3IlM0ElMjAlMjJpbmNvcnJlY3QlMjBzZWNyZXQlMjIlMjAlN0QpJTNCJTBBJTA5JTdEJTBBJTA5Li4u",highlighted:`app.<span class="hljs-title function_">post</span>(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-keyword">async</span> (req, res) =&gt; {
	<span class="hljs-keyword">if</span> (req.<span class="hljs-title function_">header</span>(<span class="hljs-string">&quot;X-Webhook-Secret&quot;</span>) !== process.<span class="hljs-property">env</span>.<span class="hljs-property">WEBHOOK_SECRET</span>) {
		<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">error</span>(<span class="hljs-string">&quot;incorrect secret&quot;</span>);
		<span class="hljs-keyword">return</span> res.<span class="hljs-title function_">status</span>(<span class="hljs-number">400</span>).<span class="hljs-title function_">json</span>({ <span class="hljs-attr">error</span>: <span class="hljs-string">&quot;incorrect secret&quot;</span> });
	}
	...`,wrap:!1}}),W=new Oe({props:{code:"JTA5Y29uc3QlMjBldmVudCUyMCUzRCUyMHJlcS5ib2R5LmV2ZW50JTNCJTBBJTA5aWYlMjAoJTBBJTA5JTA5ZXZlbnQuYWN0aW9uJTIwJTNEJTNEJTNEJTIwJTIyY3JlYXRlJTIyJTIwJTI2JTI2JTBBJTA5JTA5ZXZlbnQuc2NvcGUlMjAlM0QlM0QlM0QlMjAlMjJkaXNjdXNzaW9uLmNvbW1lbnQlMjIlMjAlMjYlMjYlMEElMDklMDlyZXEuYm9keS5jb21tZW50LmNvbnRlbnQuaW5jbHVkZXMoQk9UX1VTRVJOQU1FKSUwQSUwOSklMjAlN0IlMEElMDklMDkuLi4=",highlighted:`	<span class="hljs-keyword">const</span> event = req.<span class="hljs-property">body</span>.<span class="hljs-property">event</span>;
	<span class="hljs-keyword">if</span> (
		event.<span class="hljs-property">action</span> === <span class="hljs-string">&quot;create&quot;</span> &amp;&amp;
		event.<span class="hljs-property">scope</span> === <span class="hljs-string">&quot;discussion.comment&quot;</span> &amp;&amp;
		req.<span class="hljs-property">body</span>.<span class="hljs-property">comment</span>.<span class="hljs-property">content</span>.<span class="hljs-title function_">includes</span>(<span class="hljs-variable constant_">BOT_USERNAME</span>)
	) {
		...`,wrap:!1}}),V=new Oe({props:{code:"JTA5Y29uc3QlMjBJTkZFUkVOQ0VfVVJMJTIwJTNEJTBBJTA5JTA5JTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnc2NpZW5jZSUyRmJsb29tJTIyJTNCJTBBJTA5Y29uc3QlMjBQUk9NUFQlMjAlM0QlMjAlNjBQcmV0ZW5kJTIwdGhhdCUyMHlvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVwbGllcyUyMHRvJTIwZGlzY3Vzc2lvbnMlMjBhYm91dCUyMG1hY2hpbmUlMjBsZWFybmluZyUyQyUyMGFuZCUyMHJlcGx5JTIwdG8lMjB0aGUlMjBmb2xsb3dpbmclMjBjb21tZW50JTNBJTVDbiU2MCUzQiUwQSUwQSUwOWNvbnN0JTIwcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGZldGNoKElORkVSRU5DRV9VUkwlMkMlMjAlN0IlMEElMDklMDltZXRob2QlM0ElMjAlMjJQT1NUJTIyJTJDJTBBJTA5JTA5Ym9keSUzQSUyMEpTT04uc3RyaW5naWZ5KCU3QiUyMGlucHV0cyUzQSUyMFBST01QVCUyMCUyQiUyMHJlcS5ib2R5LmNvbW1lbnQuY29udGVudCUyMCU3RCklMkMlMEElMDklN0QpJTNCJTBBJTA5aWYlMjAocmVzcG9uc2Uub2spJTIwJTdCJTBBJTA5JTA5Y29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHJlc3BvbnNlLmpzb24oKSUzQiUwQSUwOSUwOWNvbnN0JTIwY29udGludWF0aW9uVGV4dCUyMCUzRCUyMG91dHB1dCU1QjAlNUQuZ2VuZXJhdGVkX3RleHQucmVwbGFjZSglMEElMDklMDklMDlQUk9NUFQlMjAlMkIlMjByZXEuYm9keS5jb21tZW50LmNvbnRlbnQlMkMlMEElMDklMDklMDklMjIlMjIlMEElMDklMDkpJTNCJTBBJTA5JTA5Li4u",highlighted:`	<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">INFERENCE_URL</span> =
		<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigscience/bloom&quot;</span>;
	<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">PROMPT</span> = <span class="hljs-string">\`Pretend that you are a bot that replies to discussions about machine learning, and reply to the following comment:\\n\`</span>;

	<span class="hljs-keyword">const</span> response = <span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-variable constant_">INFERENCE_URL</span>, {
		<span class="hljs-attr">method</span>: <span class="hljs-string">&quot;POST&quot;</span>,
		<span class="hljs-attr">body</span>: <span class="hljs-title class_">JSON</span>.<span class="hljs-title function_">stringify</span>({ <span class="hljs-attr">inputs</span>: <span class="hljs-variable constant_">PROMPT</span> + req.<span class="hljs-property">body</span>.<span class="hljs-property">comment</span>.<span class="hljs-property">content</span> }),
	});
	<span class="hljs-keyword">if</span> (response.<span class="hljs-property">ok</span>) {
		<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> response.<span class="hljs-title function_">json</span>();
		<span class="hljs-keyword">const</span> continuationText = output[<span class="hljs-number">0</span>].<span class="hljs-property">generated_text</span>.<span class="hljs-title function_">replace</span>(
			<span class="hljs-variable constant_">PROMPT</span> + req.<span class="hljs-property">body</span>.<span class="hljs-property">comment</span>.<span class="hljs-property">content</span>,
			<span class="hljs-string">&quot;&quot;</span>
		);
		...`,wrap:!1}}),P=new Oe({props:{code:"JTA5Y29uc3QlMjBjb21tZW50VXJsJTIwJTNEJTIwcmVxLmJvZHkuZGlzY3Vzc2lvbi51cmwuYXBpJTIwJTJCJTIwJTIyJTJGY29tbWVudCUyMiUzQiUwQSUwQSUwOWNvbnN0JTIwY29tbWVudEFwaVJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBmZXRjaChjb21tZW50VXJsJTJDJTIwJTdCJTBBJTA5JTA5bWV0aG9kJTNBJTIwJTIyUE9TVCUyMiUyQyUwQSUwOSUwOWhlYWRlcnMlM0ElMjAlN0IlMEElMDklMDklMDlBdXRob3JpemF0aW9uJTNBJTIwJTYwQmVhcmVyJTIwJTI0JTdCcHJvY2Vzcy5lbnYuSEZfVE9LRU4lN0QlNjAlMkMlMEElMDklMDklMDklMjJDb250ZW50LVR5cGUlMjIlM0ElMjAlMjJhcHBsaWNhdGlvbiUyRmpzb24lMjIlMkMlMEElMDklMDklN0QlMkMlMEElMDklMDlib2R5JTNBJTIwSlNPTi5zdHJpbmdpZnkoJTdCJTIwY29tbWVudCUzQSUyMGNvbnRpbnVhdGlvblRleHQlMjAlN0QpJTJDJTBBJTA5JTdEKSUzQiUwQSUwQSUwOWNvbnN0JTIwYXBpT3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjb21tZW50QXBpUmVzcG9uc2UuanNvbigpJTNC",highlighted:`	<span class="hljs-keyword">const</span> commentUrl = req.<span class="hljs-property">body</span>.<span class="hljs-property">discussion</span>.<span class="hljs-property">url</span>.<span class="hljs-property">api</span> + <span class="hljs-string">&quot;/comment&quot;</span>;

	<span class="hljs-keyword">const</span> commentApiResponse = <span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(commentUrl, {
		<span class="hljs-attr">method</span>: <span class="hljs-string">&quot;POST&quot;</span>,
		<span class="hljs-attr">headers</span>: {
			<span class="hljs-title class_">Authorization</span>: <span class="hljs-string">\`Bearer <span class="hljs-subst">\${({}).HF_TOKEN}</span>\`</span>,
			<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
		},
		<span class="hljs-attr">body</span>: <span class="hljs-title class_">JSON</span>.<span class="hljs-title function_">stringify</span>({ <span class="hljs-attr">comment</span>: continuationText }),
	});

	<span class="hljs-keyword">const</span> apiOutput = <span class="hljs-keyword">await</span> commentApiResponse.<span class="hljs-title function_">json</span>();`,wrap:!1}}),Y=new te({props:{title:"Configure your Webhook to send events to your Space",local:"configure-your-webhook-to-send-events-to-your-space",headingTag:"h2"}}),F=new te({props:{title:"Result",local:"result",headingTag:"h2"}}),ee=new xt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/webhooks-guide-discussion-bot.md"}}),{c(){d=o("meta"),ne=n(),se=o("p"),ae=n(),c(M.$$.fragment),oe=n(),c(w.$$.fragment),ie=n(),T=o("blockquote"),T.innerHTML=ze,pe=n(),y=o("p"),y.textContent=Xe,ce=n(),c(J.$$.fragment),ue=n(),j=o("p"),j.innerHTML=Ge,re=n(),k=o("ul"),k.innerHTML=Fe,he=n(),g=o("p"),g.textContent=Ke,me=n(),v=o("p"),v.innerHTML=et,be=n(),c(C.$$.fragment),de=n(),U=o("p"),U.textContent=tt,Te=n(),$=o("p"),$.innerHTML=st,fe=n(),f=o("blockquote"),f.innerHTML=lt,Me=n(),c(B.$$.fragment),we=n(),N=o("p"),N.textContent=nt,ye=n(),x=o("p"),x.textContent=at,Je=n(),Q=o("p"),Q.innerHTML=ot,je=n(),_=o("p"),_.innerHTML=it,ke=n(),E=o("p"),E.innerHTML=pt,ge=n(),I=o("p"),I.textContent=ct,ve=n(),c(S.$$.fragment),Ce=n(),L=o("p"),L.innerHTML=ut,Ue=n(),c(W.$$.fragment),$e=n(),H=o("p"),H.textContent=rt,Be=n(),A=o("ul"),A.innerHTML=ht,Ne=n(),R=o("p"),R.textContent=mt,xe=n(),c(V.$$.fragment),Qe=n(),Z=o("p"),Z.innerHTML=bt,_e=n(),q=o("p"),q.textContent=dt,Ee=n(),c(P.$$.fragment),Ie=n(),c(Y.$$.fragment),Se=n(),O=o("p"),O.textContent=Tt,Le=n(),D=o("p"),D.textContent=ft,We=n(),z=o("p"),z.innerHTML=Mt,He=n(),X=o("p"),X.textContent=wt,Ae=n(),G=o("p"),G.innerHTML=yt,Re=n(),c(F.$$.fragment),Ve=n(),K=o("p"),K.innerHTML=Jt,Ze=n(),c(ee.$$.fragment),qe=n(),le=o("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(s),ne=a(e),se=i(e,"P",{}),jt(se).forEach(s),ae=a(e),u(M.$$.fragment,e),oe=a(e),u(w.$$.fragment,e),ie=a(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-19nwf8t"&&(T.innerHTML=ze),pe=a(e),y=i(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-keocbu"&&(y.textContent=Xe),ce=a(e),u(J.$$.fragment,e),ue=a(e),j=i(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-15jch62"&&(j.innerHTML=Ge),re=a(e),k=i(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-7wrx85"&&(k.innerHTML=Fe),he=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1kjjv0e"&&(g.textContent=Ke),me=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1qn956z"&&(v.innerHTML=et),be=a(e),u(C.$$.fragment,e),de=a(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-yy1y6h"&&(U.textContent=tt),Te=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1ihxq2p"&&($.innerHTML=st),fe=a(e),f=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-yptivr"&&(f.innerHTML=lt),Me=a(e),u(B.$$.fragment,e),we=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-10hvkux"&&(N.textContent=nt),ye=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-66j7b7"&&(x.textContent=at),Je=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-uznbk6"&&(Q.innerHTML=ot),je=a(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-18swlk4"&&(_.innerHTML=it),ke=a(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-13dfin0"&&(E.innerHTML=pt),ge=a(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1pwq3vv"&&(I.textContent=ct),ve=a(e),u(S.$$.fragment,e),Ce=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-fjo3lx"&&(L.innerHTML=ut),Ue=a(e),u(W.$$.fragment,e),$e=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-9uldfr"&&(H.textContent=rt),Be=a(e),A=i(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-170dc9y"&&(A.innerHTML=ht),Ne=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1wkfczu"&&(R.textContent=mt),xe=a(e),u(V.$$.fragment,e),Qe=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-b2yu1h"&&(Z.innerHTML=bt),_e=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-7n9emh"&&(q.textContent=dt),Ee=a(e),u(P.$$.fragment,e),Ie=a(e),u(Y.$$.fragment,e),Se=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-dskcrn"&&(O.textContent=Tt),Le=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-51uzae"&&(D.textContent=ft),We=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-8upc7q"&&(z.innerHTML=Mt),He=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-xwubul"&&(X.textContent=wt),Ae=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-15slbem"&&(G.innerHTML=yt),Re=a(e),u(F.$$.fragment,e),Ve=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1bgc7bn"&&(K.innerHTML=Jt),Ze=a(e),u(ee.$$.fragment,e),qe=a(e),le=i(e,"P",{}),jt(le).forEach(s),this.h()},h(){Ye(d,"name","hf:doc:metadata"),Ye(d,"content",_t),Ye(T,"class","tip"),Ye(f,"class","tip")},m(e,t){Bt(document.head,d),l(e,ne,t),l(e,se,t),l(e,ae,t),r(M,e,t),l(e,oe,t),r(w,e,t),l(e,ie,t),l(e,T,t),l(e,pe,t),l(e,y,t),l(e,ce,t),r(J,e,t),l(e,ue,t),l(e,j,t),l(e,re,t),l(e,k,t),l(e,he,t),l(e,g,t),l(e,me,t),l(e,v,t),l(e,be,t),r(C,e,t),l(e,de,t),l(e,U,t),l(e,Te,t),l(e,$,t),l(e,fe,t),l(e,f,t),l(e,Me,t),r(B,e,t),l(e,we,t),l(e,N,t),l(e,ye,t),l(e,x,t),l(e,Je,t),l(e,Q,t),l(e,je,t),l(e,_,t),l(e,ke,t),l(e,E,t),l(e,ge,t),l(e,I,t),l(e,ve,t),r(S,e,t),l(e,Ce,t),l(e,L,t),l(e,Ue,t),r(W,e,t),l(e,$e,t),l(e,H,t),l(e,Be,t),l(e,A,t),l(e,Ne,t),l(e,R,t),l(e,xe,t),r(V,e,t),l(e,Qe,t),l(e,Z,t),l(e,_e,t),l(e,q,t),l(e,Ee,t),r(P,e,t),l(e,Ie,t),r(Y,e,t),l(e,Se,t),l(e,O,t),l(e,Le,t),l(e,D,t),l(e,We,t),l(e,z,t),l(e,He,t),l(e,X,t),l(e,Ae,t),l(e,G,t),l(e,Re,t),r(F,e,t),l(e,Ve,t),l(e,K,t),l(e,Ze,t),r(ee,e,t),l(e,qe,t),l(e,le,t),Pe=!0},p:gt,i(e){Pe||(h(M.$$.fragment,e),h(w.$$.fragment,e),h(J.$$.fragment,e),h(C.$$.fragment,e),h(B.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),h(V.$$.fragment,e),h(P.$$.fragment,e),h(Y.$$.fragment,e),h(F.$$.fragment,e),h(ee.$$.fragment,e),Pe=!0)},o(e){m(M.$$.fragment,e),m(w.$$.fragment,e),m(J.$$.fragment,e),m(C.$$.fragment,e),m(B.$$.fragment,e),m(S.$$.fragment,e),m(W.$$.fragment,e),m(V.$$.fragment,e),m(P.$$.fragment,e),m(Y.$$.fragment,e),m(F.$$.fragment,e),m(ee.$$.fragment,e),Pe=!1},d(e){e&&(s(ne),s(se),s(ae),s(oe),s(ie),s(T),s(pe),s(y),s(ce),s(ue),s(j),s(re),s(k),s(he),s(g),s(me),s(v),s(be),s(de),s(U),s(Te),s($),s(fe),s(f),s(Me),s(we),s(N),s(ye),s(x),s(Je),s(Q),s(je),s(_),s(ke),s(E),s(ge),s(I),s(ve),s(Ce),s(L),s(Ue),s($e),s(H),s(Be),s(A),s(Ne),s(R),s(xe),s(Qe),s(Z),s(_e),s(q),s(Ee),s(Ie),s(Se),s(O),s(Le),s(D),s(We),s(z),s(He),s(X),s(Ae),s(G),s(Re),s(Ve),s(K),s(Ze),s(qe),s(le)),s(d),b(M,e),b(w,e),b(J,e),b(C,e),b(B,e),b(S,e),b(W,e),b(V,e),b(P,e),b(Y,e),b(F,e),b(ee,e)}}}const _t='{"title":"Webhook guide: build a Discussion bot based on BLOOM","local":"webhook-guide-build-a-discussion-bot-based-on-bloom","sections":[{"title":"Create your Webhook in your user profile","local":"create-your-webhook-in-your-user-profile","sections":[],"depth":2},{"title":"Create a new Bot user profile","local":"create-a-new-bot-user-profile","sections":[],"depth":2},{"title":"Create a Space that will react to your Webhook","local":"create-a-space-that-will-react-to-your-webhook","sections":[],"depth":2},{"title":"Configure your Webhook to send events to your Space","local":"configure-your-webhook-to-send-events-to-your-space","sections":[],"depth":2},{"title":"Result","local":"result","sections":[],"depth":2}],"depth":1}';function Et(De){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Ct{constructor(d){super(),Ut(this,d,Et,Qt,kt,{})}}export{At as component};
