import{s as Qn,n as Yn,o as Sn}from"../chunks/scheduler.9cda857a.js";import{S as En,i as Nn,e as i,s as a,c as p,h as An,a as o,d as s,b as n,f as Ge,g as d,j as r,k as ia,l as f,m as l,n as u,t as m,o as c,p as M}from"../chunks/index.003612b0.js";import{C as Dn}from"../chunks/CopyLLMTxtMenu.44d08a39.js";import{C as T}from"../chunks/CodeBlock.a90632f1.js";import{H as h,E as Pn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e5cfda8c.js";function Kn(Ja){let U,Ee,Ye,Ne,b,Ae,I,De,j,wa="<p>This guide is primarily designed for LLMs to help users upload datasets to the Hugging Face Hub in the most compatible format. Users can also reference this guide to understand the upload process and best practices.</p>",Pe,C,Ua="<p>Decision guide for uploading datasets to Hugging Face Hub. Optimized for Dataset Viewer compatibility and integration with the Hugging Face ecosystem.</p>",Ke,$,Oe,v,ja="Your goal is to help a user upload a dataset to the Hugging Face Hub. Ideally, the dataset should be compatible with the Dataset Viewer (and thus the <code>load_dataset</code> function) to ensure easy access and usability. You should aim to meet the following criteria:",ts,Z,ba="<thead><tr><th><strong>Criteria</strong></th> <th>Description</th> <th>Priority</th></tr></thead> <tbody><tr><td><strong>Respect repository limits</strong></td> <td>Ensure the dataset adheres to Hugging Face’s storage limits for file sizes, repository sizes, and file counts. See the Critical Constraints section below for specific limits.</td> <td>Required</td></tr> <tr><td><strong>Use hub-compatible formats</strong></td> <td>Use Parquet format when possible (best compression, rich typing, large dataset support). For smaller datasets (&lt;several GB), JSON/JSONL or CSV are acceptable. Raw files work well for images/audio in smaller datasets while respecting repo limits. Use WebDataset (.tar) for large media collections. Domain-specific formats can be used when conversion is impractical.</td> <td>Desired</td></tr> <tr><td><strong>Dataset Viewer compatibility</strong></td> <td>Structure data to work with the automatic Dataset Viewer, enabling preview and easy exploration. This typically means using supported formats and proper file organization. Validation steps are provided later in this guide.</td> <td>Desired</td></tr> <tr><td><strong>Organize data sensibly</strong></td> <td>Use logical folder structures that match Hub conventions (e.g., train/test splits). Configs can be used to define different configurations of the dataset. This facilitates both human understanding and automatic data loading.</td> <td>Desired</td></tr> <tr><td><strong>Use appropriate Features</strong></td> <td>When using the datasets library, specify correct feature types (e.g., Image(), Audio(), ClassLabel()) to ensure proper data handling and viewer functionality. This enables type-specific optimizations and previews.</td> <td>Required (when using datasets library)</td></tr> <tr><td><strong>Document non-standard datasets</strong></td> <td>If conversion to hub-compatible formats is impossible and custom formats must be used, ensure repository limits are strictly followed and provide clear documentation on how to download and load the dataset. Include usage examples and any special requirements.</td> <td>Required (when datasets library isn’t compatible)</td></tr></tbody>",es,_,ss,x,Ia="When you don’t have direct access to the user’s files (e.g., web interface), ask the user to run these commands to understand their dataset:",ls,G,Ca="<strong>Dataset structure</strong>:",as,B,ns,X,$a="<strong>Check file sizes</strong>:",is,F,os,W,va="<strong>Peek at data format</strong>:",rs,k,ps,q,Za="<strong>Quick file count</strong>:",ds,V,us,H,ms,L,_a="<strong>Storage Limits</strong>:",cs,R,Ms,z,xa="<strong>Human-readable summary</strong>:",fs,Q,Ga='<li>Free: 100GB private datasets</li> <li>Pro (for individuals) | Team or Enterprise (for organizations): 1TB+ private storage per seat (see <a href="https://huggingface.co/pricing" rel="nofollow">pricing</a>)</li> <li>Public: 1TB (contact <a href="mailto:datasets@huggingface.co">datasets@huggingface.co</a> for larger)</li> <li>Per file: 50GB max, 20GB recommended</li> <li>Per folder: &lt;10k files</li>',hs,Y,Ba='See <a href="https://huggingface.co/docs/hub/storage-limits#repository-limitations-and-recommendations" rel="nofollow">https://huggingface.co/docs/hub/storage-limits#repository-limitations-and-recommendations</a> for current limits for current recommendations for repository sizes and file counts.',ys,S,Ts,E,Xa='<thead><tr><th>Your Data</th> <th>Recommended Approach</th> <th>Quick Command</th></tr></thead> <tbody><tr><td><strong>CSV/JSON files</strong></td> <td>Use built-in loaders (handles any size via memory mapping)</td> <td><code>load_dataset(&quot;csv&quot;, data_files=&quot;data.csv&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>Images in folders</strong></td> <td>Use <a href="https://huggingface.co/docs/datasets/en/image_load" rel="nofollow">imagefolder</a> for automatic class detection</td> <td><code>load_dataset(&quot;imagefolder&quot;, data_dir=&quot;./images&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>Audio files</strong></td> <td>Use <a href="https://huggingface.co/docs/datasets/en/audio_load" rel="nofollow">audiofolder</a> for automatic organization</td> <td><code>load_dataset(&quot;audiofolder&quot;, data_dir=&quot;./audio&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>Video files</strong></td> <td>Use <a href="https://huggingface.co/docs/datasets/en/video_load#videofolder" rel="nofollow">videofolder</a> for automatic organization</td> <td><code>load_dataset(&quot;videofolder&quot;, data_dir=&quot;./videos&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>PDF documents</strong></td> <td>Use <a href="https://huggingface.co/docs/datasets/en/document_dataset#pdffolder" rel="nofollow">pdffolder</a> for text extraction</td> <td><code>load_dataset(&quot;pdffolder&quot;, data_dir=&quot;./pdfs&quot;).push_to_hub(&quot;username/dataset&quot;)</code></td></tr> <tr><td><strong>Very large datasets (100GB+)</strong></td> <td>Use <code>max_shard_size</code> to control memory usage</td> <td><code>dataset.push_to_hub(&quot;username/dataset&quot;, max_shard_size=&quot;5GB&quot;)</code></td></tr> <tr><td><strong>Many files / directories (&gt;10k)</strong></td> <td>Use upload_large_folder to avoid Git limitations</td> <td><code>api.upload_large_folder(folder_path=&quot;./data&quot;, repo_id=&quot;username/dataset&quot;, repo_type=&quot;dataset&quot;)</code></td></tr> <tr><td><strong>Streaming large media</strong></td> <td>WebDataset format for efficient streaming</td> <td>Create .tar shards, then <code>upload_large_folder()</code></td></tr> <tr><td><strong>Scientific data (HDF5, NetCDF)</strong></td> <td>Convert to Parquet with Array features</td> <td>See <a href="#scientific-data">Scientific Data</a> section</td></tr> <tr><td><strong>Custom/proprietary formats</strong></td> <td>Document thoroughly if conversion impossible</td> <td><code>upload_large_folder()</code> with comprehensive README</td></tr></tbody>',gs,N,Js,y,Be,Fa="<p>✓ <strong>Gather dataset information</strong> (if needed):</p> <ul><li>What type of data? (images, text, audio, CSV, etc.)</li> <li>How is it organized? (folder structure, single file, multiple files)</li> <li>What’s the approximate size?</li> <li>What format are the files in?</li> <li>Any special requirements? (e.g., streaming, private access)</li> <li>Check for existing README or documentation files that describe the dataset</li></ul>",oa,Xe,Wa="<p>✓ <strong>Authenticate</strong>:</p> <ul><li>CLI: <code>hf auth login</code></li> <li>Or use token: <code>HfApi(token=&quot;hf_...&quot;)</code> or set <code>HF_TOKEN</code> environment variable</li></ul>",ra,Fe,ka='<p>✓ <strong>Identify your data type</strong>: Check the <a href="#quick-reference-by-data-type">Quick Reference</a> table above</p>',pa,We,qa='<p>✓ <strong>Choose upload method</strong>:</p> <ul><li><strong>Small files (&lt;1GB) with hub-compatible format</strong>: Can use <a href="https://huggingface.co/new-dataset" rel="nofollow">Hub UI</a> for quick uploads</li> <li><strong>Built-in loader available</strong>: Use the loader + <code>push_to_hub()</code> (see Quick Reference table)</li> <li><strong>Large datasets or many files</strong>: Use <code>upload_large_folder()</code> for files &gt;100GB or &gt;10k files</li> <li><strong>Custom formats</strong>: Convert to hub-compatible format if possible, otherwise document thoroughly</li></ul>',da,A,ke,Va="✓ <strong>Test locally</strong> (if using built-in loader):",ua,D,ma,P,qe,Ha="✓ <strong>Upload to Hub</strong>:",ca,K,Ma,Ve,La='<p>✓ <strong>Verify your upload</strong>:</p> <ul><li>Check Dataset Viewer: <code>https://huggingface.co/datasets/username/dataset-name</code></li> <li>Test loading: <code>load_dataset(&quot;username/dataset-name&quot;)</code></li> <li>If viewer shows errors, check the <a href="#common-issues--solutions">Troubleshooting</a> section</li></ul>',ws,O,Us,tt,Ra="When built-in loaders don’t match your data structure, use the datasets library as a compatibility layer. Convert your data to a Dataset object, then use <code>push_to_hub()</code> for maximum flexibility and Dataset Viewer compatibility.",js,et,bs,st,za="If you already have your data working in pandas, polars, or other dataframe libraries, you can convert directly:",Is,lt,Cs,at,$s,nt,Qa="When built-in loaders don’t match your data format, convert to Dataset objects following these principles:",vs,it,Zs,ot,Ya="<strong>1. Prefer wide/flat structures over joins</strong>",_s,rt,Sa="<li>Denormalize relational data into single rows for better usability</li> <li>Include all relevant information in each example</li> <li>Lean towards bigger but more usable data - Hugging Face’s infrastructure uses advanced deduplication (XetHub) and Parquet optimizations to handle redundancy efficiently</li>",xs,pt,Ea="<strong>2. Use configs for logical dataset variations</strong>",Gs,dt,Na="<li>Beyond train/test/val splits, use configs for different subsets or views of your data</li> <li>Each config can have different features or data organization</li> <li>Example: language-specific configs, task-specific views, or data modalities</li>",Bs,ut,Xs,mt,Aa="<strong>Small datasets (fits in memory) - use <code>Dataset.from_dict()</code></strong>:",Fs,ct,Ws,Mt,Da="<strong>Large datasets (memory-efficient) - use <code>Dataset.from_generator()</code></strong>:",ks,ft,qs,ht,Pa="<strong>Tip</strong>: For large datasets, test with a subset first by adding a limit to your generator or using <code>.select(range(100))</code> after creation.",Vs,yt,Hs,Tt,Ls,gt,Rs,Jt,Ka="<strong>Text + Audio (speech recognition)</strong>:",zs,wt,Qs,Ut,Oa="<strong>Multiple images per example</strong>:",Ys,jt,Ss,bt,tn="<strong>Note</strong>: For text + images, consider using ImageFolder with metadata.csv which handles this automatically.",Es,It,Ns,Ct,en="Features define the schema and data types for your dataset columns. Specifying correct features ensures:",As,$t,sn="<li>Proper data handling and type conversion</li> <li>Dataset Viewer functionality (e.g., image/audio previews)</li> <li>Efficient storage and loading</li> <li>Clear documentation of your data structure</li>",Ds,vt,ln='For complete feature documentation, see: <a href="https://huggingface.co/docs/datasets/about_dataset_features" rel="nofollow">Dataset Features</a>',Ps,Zt,Ks,_t,an="<strong>Basic Types</strong>:",Os,xt,nn="<li><code>Value</code>: Scalar values - <code>string</code>, <code>int64</code>, <code>float32</code>, <code>bool</code>, <code>binary</code>, and other numeric types</li> <li><code>ClassLabel</code>: Categorical data with named classes</li> <li><code>Sequence</code>: Lists of any feature type</li> <li><code>LargeList</code>: For very large lists</li>",tl,Gt,on="<strong>Media Types</strong> (enable Dataset Viewer previews):",el,Bt,rn="<li><code>Image()</code>: Handles various image formats, returns PIL Image objects</li> <li><code>Audio(sampling_rate=16000)</code>: Audio with array data and optional sampling rate</li> <li><code>Video()</code>: Video files</li> <li><code>Pdf()</code>: PDF documents with text extraction</li>",sl,Xt,pn="<strong>Array Types</strong> (for tensors/scientific data):",ll,Ft,dn="<li><code>Array2D</code>, <code>Array3D</code>, <code>Array4D</code>, <code>Array5D</code>: Fixed or variable-length arrays</li> <li>Example: <code>Array2D(shape=(224, 224), dtype=&#39;float32&#39;)</code></li> <li>First dimension can be <code>None</code> for variable length</li>",al,Wt,un="<strong>Translation Types</strong>:",nl,kt,mn="<li><code>Translation</code>: For translation pairs with fixed languages</li> <li><code>TranslationVariableLanguages</code>: For translations with varying language pairs</li>",il,qt,cn="<strong>Note</strong>: New feature types are added regularly. Check the documentation for the latest additions.",ol,Vt,rl,Ht,Mn=`<strong>Dataset objects (use push_to_hub)</strong>:
Use when you’ve loaded/converted data using the datasets library`,pl,Lt,dl,Rt,fn=`<strong>Pre-existing files (use upload_large_folder)</strong>:
Use when you have hub-compatible files (e.g., Parquet files) already prepared and organized`,ul,zt,ml,Qt,hn="<strong>Important</strong>: Before using <code>upload_large_folder</code>, verify the files meet repository limits:",cl,Yt,yn="<li>Check folder structure if you have file access: ensure no folder contains &gt;10k files</li> <li>Ask the user to confirm: “Are your files in a hub-compatible format (Parquet/CSV/JSON) and organized appropriately?”</li> <li>For non-standard formats, consider converting to Dataset objects first to ensure compatibility</li>",Ml,St,fl,Et,Tn="<strong>Consider small reformatting</strong>: If data is close to a built-in loader format, suggest minor changes:",hl,Nt,gn="<li>Rename columns (e.g., ‘filename’ → ‘file_name’ for ImageFolder)</li> <li>Reorganize folders (e.g., move images into class subfolders)</li> <li>Rename files to match expected patterns (e.g., ‘data.csv’ → ‘train.csv’)</li>",yl,At,Jn="<strong>Pre-upload</strong>:",Tl,g,He,wn="<p>Test locally: <code>load_dataset(&quot;imagefolder&quot;, data_dir=&quot;./data&quot;)</code></p>",fa,Dt,Le,Un="Verify features work correctly:",ha,Pt,ya,Re,jn="<p>Check metadata.csv has ‘file_name’ column</p>",Ta,ze,bn="<p>Verify relative paths, no leading slashes</p>",ga,Qe,In="<p>Ensure no folder &gt;10k files</p>",gl,Kt,Cn="<strong>Post-upload</strong>:",Jl,Ot,$n="<li>Check viewer: <code>https://huggingface.co/datasets/username/dataset</code></li> <li>Test loading: <code>load_dataset(&quot;username/dataset&quot;)</code></li> <li>Verify features preserved: <code>print(dataset.features)</code></li>",wl,te,Ul,ee,vn="<thead><tr><th>Issue</th> <th>Solution</th></tr></thead> <tbody><tr><td>“Repository not found”</td> <td>Run <code>hf auth login</code></td></tr> <tr><td>Memory errors</td> <td>Use <code>max_shard_size=&quot;500MB&quot;</code></td></tr> <tr><td>Dataset viewer not working</td> <td>Wait 5-10min, check README.md config</td></tr> <tr><td>Timeout errors</td> <td>Use <code>multi_commits=True</code></td></tr> <tr><td>Files &gt;50GB</td> <td>Split into smaller files</td></tr> <tr><td>“File not found”</td> <td>Use relative paths in metadata</td></tr></tbody>",jl,se,bl,le,Zn="<strong>Note</strong>: This section is primarily for datasets uploaded directly to the Hub (via UI or <code>upload_large_folder</code>). Datasets uploaded with <code>push_to_hub()</code> typically configure the viewer automatically.",Il,ae,Cl,ne,_n="The Dataset Viewer automatically detects standard structures:",$l,ie,xn="<li>Files named: <code>train.csv</code>, <code>test.json</code>, <code>validation.parquet</code></li> <li>Directories named: <code>train/</code>, <code>test/</code>, <code>validation/</code></li> <li>Split names with delimiters: <code>test-data.csv</code> ✓ (not <code>testdata.csv</code> ✗)</li>",vl,oe,Zl,re,Gn="For custom structures, add YAML to your README.md:",_l,pe,xl,de,Bn="Multiple configurations example:",Gl,ue,Bl,me,Xl,ce,Xn="<li><strong>No viewer after upload</strong>: Wait 5-10 minutes for processing</li> <li><strong>“Config names error”</strong>: Add <code>config_name</code> field (required!)</li> <li><strong>Files not detected</strong>: Check naming patterns (needs delimiters)</li> <li><strong>Viewer disabled</strong>: Remove <code>viewer: false</code> from README YAML</li>",Fl,Me,Wl,fe,kl,he,ql,ye,Fn='<strong>Core docs</strong>: <a href="https://huggingface.co/docs/hub/datasets-adding" rel="nofollow">Adding datasets</a> | <a href="https://huggingface.co/docs/hub/datasets-viewer" rel="nofollow">Dataset viewer</a> | <a href="https://huggingface.co/docs/hub/storage-limits" rel="nofollow">Storage limits</a> | <a href="https://huggingface.co/docs/datasets/upload_dataset" rel="nofollow">Upload guide</a>',Vl,Te,Hl,ge,Wn="Remind users to add a dataset card (README.md) with:",Ll,Je,kn="<li>Dataset description and usage</li> <li>License information</li> <li>Citation details</li>",Rl,we,qn='See <a href="https://huggingface.co/docs/hub/datasets-cards" rel="nofollow">Dataset Cards guide</a> for details.',zl,Ql,Yl,Ue,Sl,je,El,be,Vn="For streaming large media datasets:",Nl,Ie,Hn="<li>Create 1-5GB tar shards</li> <li>Consistent internal structure</li> <li>Upload with <code>upload_large_folder</code></li>",Al,Ce,Dl,$e,Ln="<li>HDF5/NetCDF → Convert to Parquet with Array features</li> <li>Time series → Array2D(shape=(None, n))</li> <li>Complex metadata → Store as JSON strings</li>",Pl,ve,Kl,Ze,Rn="For very specialized or bespoke formats:",Ol,_e,zn='<li>Search the Hub for similar datasets: <code>https://huggingface.co/datasets</code></li> <li>Ask for advice on the <a href="https://discuss.huggingface.co/c/datasets/10" rel="nofollow">Hugging Face Forums</a></li> <li>Join the <a href="https://hf.co/join/discord" rel="nofollow">Hugging Face Discord</a> for real-time help</li> <li>Many domain-specific formats already have examples on the Hub</li>',ta,xe,ea,Se,sa;return b=new Dn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new h({props:{title:"Hugging Face Dataset Upload Decision Guide",local:"hugging-face-dataset-upload-decision-guide",headingTag:"h1"}}),$=new h({props:{title:"Overview",local:"overview",headingTag:"h2"}}),_=new h({props:{title:"Working Without File Access",local:"working-without-file-access",headingTag:"h2"}}),B=new T({props:{code:"JTIzJTIwU2hvdyUyMGRpcmVjdG9yeSUyMHRyZWUlMjAoaW5zdGFsbCUyMHdpdGglM0ElMjBwaXAlMjBpbnN0YWxsJTIwdHJlZSUyMG9yJTIwYnJldyUyMGluc3RhbGwlMjB0cmVlKSUwQXRyZWUlMjAtTCUyMDMlMjAtLWZpbGVsaW1pdCUyMDIwJTBBJTBBJTIzJTIwQWx0ZXJuYXRpdmUlMjB3aXRob3V0JTIwdHJlZSUzQSUwQWZpbmQlMjAuJTIwLXR5cGUlMjBmJTIwLW5hbWUlMjAlMjIqLmNzdiUyMiUyMC1vJTIwLW5hbWUlMjAlMjIqLmpzb24lMjIlMjAtbyUyMC1uYW1lJTIwJTIyKi5wYXJxdWV0JTIyJTIwJTdDJTIwaGVhZCUyMC0yMA==",highlighted:`<span class="hljs-comment"># Show directory tree (install with: pip install tree or brew install tree)</span>
tree -L 3 --filelimit 20

<span class="hljs-comment"># Alternative without tree:</span>
find . -<span class="hljs-built_in">type</span> f -name <span class="hljs-string">&quot;*.csv&quot;</span> -o -name <span class="hljs-string">&quot;*.json&quot;</span> -o -name <span class="hljs-string">&quot;*.parquet&quot;</span> | <span class="hljs-built_in">head</span> -20`,wrap:!1}}),F=new T({props:{code:"JTIzJTIwVG90YWwlMjBkYXRhc2V0JTIwc2l6ZSUwQWR1JTIwLXNoJTIwLiUwQSUwQSUyMyUyMEluZGl2aWR1YWwlMjBmaWxlJTIwc2l6ZXMlMEFscyUyMC1saCUyMGRhdGElMkY=",highlighted:`<span class="hljs-comment"># Total dataset size</span>
<span class="hljs-built_in">du</span> -sh .

<span class="hljs-comment"># Individual file sizes</span>
<span class="hljs-built_in">ls</span> -lh data/`,wrap:!1}}),k=new T({props:{code:"JTIzJTIwRmlyc3QlMjBmZXclMjBsaW5lcyUyMG9mJTIwQ1NWJTJGSlNPTiUwQWhlYWQlMjAtbiUyMDUlMjBkYXRhJTJGdHJhaW4uY3N2JTBBJTBBJTIzJTIwQ2hlY2slMjBpbWFnZSUyMGZvbGRlciUyMHN0cnVjdHVyZSUwQWxzJTIwLWxhJTIwaW1hZ2VzJTJGJTIwJTdDJTIwaGVhZCUyMC0xMA==",highlighted:`<span class="hljs-comment"># First few lines of CSV/JSON</span>
<span class="hljs-built_in">head</span> -n 5 data/train.csv

<span class="hljs-comment"># Check image folder structure</span>
<span class="hljs-built_in">ls</span> -la images/ | <span class="hljs-built_in">head</span> -10`,wrap:!1}}),V=new T({props:{code:"JTIzJTIwQ291bnQlMjBmaWxlcyUyMGJ5JTIwdHlwZSUwQWZpbmQlMjAuJTIwLW5hbWUlMjAlMjIqLmpwZyUyMiUyMCU3QyUyMHdjJTIwLWw=",highlighted:`<span class="hljs-comment"># Count files by type</span>
find . -name <span class="hljs-string">&quot;*.jpg&quot;</span> | <span class="hljs-built_in">wc</span> -l`,wrap:!1}}),H=new h({props:{title:"Critical Constraints",local:"critical-constraints",headingTag:"h2"}}),R=new T({props:{code:"JTIzJTIwTWFjaGluZS1yZWFkYWJsZSUyMEh1YiUyMGxpbWl0cyUwQWh1Yl9saW1pdHMlM0ElMEElMjAlMjBtYXhfZmlsZV9zaXplX2diJTNBJTIwNTAlMjAlMjMlMjBhYnNvbHV0ZSUyMGhhcmQlMjBzdG9wJTIwZW5mb3JjZWQlMjBieSUyMExGUyUwQSUyMCUyMHJlY29tbWVuZGVkX2ZpbGVfc2l6ZV9nYiUzQSUyMDIwJTIwJTIzJTIwYmVzdC1wcmFjdGljZSUyMHNoYXJkJTIwc2l6ZSUwQSUyMCUyMG1heF9maWxlc19wZXJfZm9sZGVyJTNBJTIwMTAwMDAlMjAlMjMlMjBHaXQlMjBwZXJmb3JtYW5jZSUyMHRocmVzaG9sZCUwQSUyMCUyMG1heF9maWxlc19wZXJfcmVwbyUzQSUyMDEwMDAwMCUyMCUyMyUyMFJlcG9zaXRvcnklMjBmaWxlJTIwY291bnQlMjBsaW1pdCUwQSUyMCUyMHJlY29tbWVuZGVkX3JlcG9fc2l6ZV9nYiUzQSUyMDMwMCUyMCUyMyUyMHB1YmxpYy1yZXBvJTIwc29mdCUyMGNhcCUzQiUyMGNvbnRhY3QlMjBIRiUyMGlmJTIwbGFyZ2VyJTBBJTIwJTIwdmlld2VyX3Jvd19zaXplX21iJTNBJTIwMiUyMCUyMyUyMGFwcHJveGltYXRlJTIwcGVyLXJvdyUyMHZpZXdlciUyMGxpbWl0",highlighted:`<span class="hljs-comment"># Machine-readable Hub limits</span>
<span class="hljs-attr">hub_limits:</span>
  <span class="hljs-attr">max_file_size_gb:</span> <span class="hljs-number">50</span> <span class="hljs-comment"># absolute hard stop enforced by LFS</span>
  <span class="hljs-attr">recommended_file_size_gb:</span> <span class="hljs-number">20</span> <span class="hljs-comment"># best-practice shard size</span>
  <span class="hljs-attr">max_files_per_folder:</span> <span class="hljs-number">10000</span> <span class="hljs-comment"># Git performance threshold</span>
  <span class="hljs-attr">max_files_per_repo:</span> <span class="hljs-number">100000</span> <span class="hljs-comment"># Repository file count limit</span>
  <span class="hljs-attr">recommended_repo_size_gb:</span> <span class="hljs-number">300</span> <span class="hljs-comment"># public-repo soft cap; contact HF if larger</span>
  <span class="hljs-attr">viewer_row_size_mb:</span> <span class="hljs-number">2</span> <span class="hljs-comment"># approximate per-row viewer limit</span>`,wrap:!1}}),S=new h({props:{title:"Quick Reference by Data Type",local:"quick-reference-by-data-type",headingTag:"h2"}}),N=new h({props:{title:"Upload Workflow",local:"upload-workflow",headingTag:"h2"}}),D=new T({props:{code:"JTIzJTIwVmFsaWRhdGUlMjB5b3VyJTIwZGF0YXNldCUyMGxvYWRzJTIwY29ycmVjdGx5JTIwYmVmb3JlJTIwdXBsb2FkaW5nJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJsb2FkZXJfbmFtZSUyMiUyQyUyMGRhdGFfZGlyJTNEJTIyLiUyRnlvdXJfZGF0YSUyMiklMEFwcmludChkYXRhc2V0KQ==",highlighted:`<span class="hljs-comment"># Validate your dataset loads correctly before uploading</span>
dataset = load_dataset(<span class="hljs-string">&quot;loader_name&quot;</span>, data_dir=<span class="hljs-string">&quot;./your_data&quot;</span>)
<span class="hljs-built_in">print</span>(dataset)`,wrap:!1}}),K=new T({props:{code:"JTIzJTIwQmFzaWMlMjB1cGxvYWQlMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldC1uYW1lJTIyKSUwQSUwQSUyMyUyMFdpdGglMjBvcHRpb25zJTIwZm9yJTIwbGFyZ2UlMjBkYXRhc2V0cyUwQWRhdGFzZXQucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwJTIydXNlcm5hbWUlMkZkYXRhc2V0LW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjVHQiUyMiUyQyUyMCUyMCUyMyUyMENvbnRyb2wlMjBtZW1vcnklMjB1c2FnZSUwQSUyMCUyMCUyMCUyMHByaXZhdGUlM0RUcnVlJTIwJTIwJTIzJTIwRm9yJTIwcHJpdmF0ZSUyMGRhdGFzZXRzJTBBKQ==",highlighted:`<span class="hljs-comment"># Basic upload</span>
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset-name&quot;</span>)

<span class="hljs-comment"># With options for large datasets</span>
dataset.push_to_hub(
    <span class="hljs-string">&quot;username/dataset-name&quot;</span>,
    max_shard_size=<span class="hljs-string">&quot;5GB&quot;</span>,  <span class="hljs-comment"># Control memory usage</span>
    private=<span class="hljs-literal">True</span>  <span class="hljs-comment"># For private datasets</span>
)`,wrap:!1}}),O=new h({props:{title:"Common Conversion Patterns",local:"common-conversion-patterns",headingTag:"h2"}}),et=new h({props:{title:"From DataFrames",local:"from-dataframes",headingTag:"h3"}}),lt=new T({props:{code:"JTIzJTIwRnJvbSUyMHBhbmRhcyUyMERhdGFGcmFtZSUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJ5b3VyX2RhdGEuY3N2JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fcGFuZGFzKGRmKSUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZkYXRhc2V0LW5hbWUlMjIpJTBBJTBBJTIzJTIwRnJvbSUyMHBvbGFycyUyMERhdGFGcmFtZSUyMChkaXJlY3QlMjBtZXRob2QpJTBBaW1wb3J0JTIwcG9sYXJzJTIwYXMlMjBwbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEElMEFkZiUyMCUzRCUyMHBsLnJlYWRfY3N2KCUyMnlvdXJfZGF0YS5jc3YlMjIpJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9wb2xhcnMoZGYpJTIwJTIwJTIzJTIwRGlyZWN0JTIwY29udmVyc2lvbiUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZkYXRhc2V0LW5hbWUlMjIpJTBBJTBBJTIzJTIwRnJvbSUyMFB5QXJyb3clMjBUYWJsZSUyMCh1c2VmdWwlMjBmb3IlMjBzY2llbnRpZmljJTIwZGF0YSklMEFpbXBvcnQlMjBweWFycm93JTIwYXMlMjBwYSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEElMEElMjMlMjBJZiUyMHlvdSUyMGhhdmUlMjBhJTIwUHlBcnJvdyUyMHRhYmxlJTBBdGFibGUlMjAlM0QlMjBwYS50YWJsZSglN0InZGF0YSclM0ElMjAlNUIxJTJDJTIwMiUyQyUyMDMlNUQlMkMlMjAnbGFiZWxzJyUzQSUyMCU1QidhJyUyQyUyMCdiJyUyQyUyMCdjJyU1RCU3RCklMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldCh0YWJsZSklMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldC1uYW1lJTIyKSUwQSUwQSUyMyUyMEZvciUyMFNwYXJrJTJGRGFzayUyMGRhdGFmcmFtZXMlMkMlMjBzZWUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZG9jcyUyRmh1YiUyRmRhdGFzZXRzLWxpYnJhcmllcw==",highlighted:`<span class="hljs-comment"># From pandas DataFrame</span>
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

df = pd.read_csv(<span class="hljs-string">&quot;your_data.csv&quot;</span>)
dataset = Dataset.from_pandas(df)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset-name&quot;</span>)

<span class="hljs-comment"># From polars DataFrame (direct method)</span>
<span class="hljs-keyword">import</span> polars <span class="hljs-keyword">as</span> pl
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

df = pl.read_csv(<span class="hljs-string">&quot;your_data.csv&quot;</span>)
dataset = Dataset.from_polars(df)  <span class="hljs-comment"># Direct conversion</span>
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset-name&quot;</span>)

<span class="hljs-comment"># From PyArrow Table (useful for scientific data)</span>
<span class="hljs-keyword">import</span> pyarrow <span class="hljs-keyword">as</span> pa
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

<span class="hljs-comment"># If you have a PyArrow table</span>
table = pa.table({<span class="hljs-string">&#x27;data&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>]})
dataset = Dataset(table)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset-name&quot;</span>)

<span class="hljs-comment"># For Spark/Dask dataframes, see https://huggingface.co/docs/hub/datasets-libraries</span>`,wrap:!1}}),at=new h({props:{title:"Custom Format Conversion",local:"custom-format-conversion",headingTag:"h2"}}),it=new h({props:{title:"Design Principles",local:"design-principles",headingTag:"h3"}}),ut=new h({props:{title:"Conversion Methods",local:"conversion-methods",headingTag:"h3"}}),ct=new T({props:{code:"JTIzJTIwUGFyc2UlMjB5b3VyJTIwY3VzdG9tJTIwZm9ybWF0JTIwaW50byUyMGElMjBkaWN0aW9uYXJ5JTBBZGF0YV9kaWN0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCU1QiUyMmV4YW1wbGUxJTIyJTJDJTIwJTIyZXhhbXBsZTIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbCUyMiUzQSUyMCU1QiUyMnBvc2l0aXZlJTIyJTJDJTIwJTIybmVnYXRpdmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMCU1QjAuOSUyQyUyMDAuMiU1RCUwQSU3RCUwQSUwQSUyMyUyMENyZWF0ZSUyMGRhdGFzZXQlMjB3aXRoJTIwYXBwcm9wcmlhdGUlMjBmZWF0dXJlcyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMkMlMjBGZWF0dXJlcyUyQyUyMFZhbHVlJTJDJTIwQ2xhc3NMYWJlbCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTBBJTIwJTIwJTIwJTIwJ3RleHQnJTNBJTIwVmFsdWUoJ3N0cmluZycpJTJDJTBBJTIwJTIwJTIwJTIwJ2xhYmVsJyUzQSUyMENsYXNzTGFiZWwobmFtZXMlM0QlNUInbmVnYXRpdmUnJTJDJTIwJ3Bvc2l0aXZlJyU1RCklMkMlMEElMjAlMjAlMjAlMjAnc2NvcmUnJTNBJTIwVmFsdWUoJ2Zsb2F0MzInKSUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoZGF0YV9kaWN0JTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldCUyMik=",highlighted:`<span class="hljs-comment"># Parse your custom format into a dictionary</span>
data_dict = {
    <span class="hljs-string">&quot;text&quot;</span>: [<span class="hljs-string">&quot;example1&quot;</span>, <span class="hljs-string">&quot;example2&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>],
    <span class="hljs-string">&quot;score&quot;</span>: [<span class="hljs-number">0.9</span>, <span class="hljs-number">0.2</span>]
}

<span class="hljs-comment"># Create dataset with appropriate features</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Value, ClassLabel
features = Features({
    <span class="hljs-string">&#x27;text&#x27;</span>: Value(<span class="hljs-string">&#x27;string&#x27;</span>),
    <span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>]),
    <span class="hljs-string">&#x27;score&#x27;</span>: Value(<span class="hljs-string">&#x27;float32&#x27;</span>)
})

dataset = Dataset.from_dict(data_dict, features=features)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>)`,wrap:!1}}),ft=new T({props:{code:"ZGVmJTIwZGF0YV9nZW5lcmF0b3IoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFBhcnNlJTIweW91ciUyMGN1c3RvbSUyMGZvcm1hdCUyMHByb2dyZXNzaXZlbHklMEElMjAlMjAlMjAlMjBmb3IlMjBpdGVtJTIwaW4lMjBwYXJzZV9sYXJnZV9maWxlKCUyMmRhdGEuY3VzdG9tJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMGl0ZW0lNUIlMjJjb250ZW50JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGFiZWwlMjIlM0ElMjBpdGVtJTVCJTIyY2F0ZWdvcnklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbWJlZGRpbmclMjIlM0ElMjBpdGVtJTVCJTIydmVjdG9yJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTBBJTIzJTIwU3BlY2lmeSUyMGZlYXR1cmVzJTIwZm9yJTIwRGF0YXNldCUyMFZpZXdlciUyMGNvbXBhdGliaWxpdHklMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBGZWF0dXJlcyUyQyUyMFZhbHVlJTJDJTIwQ2xhc3NMYWJlbCUyQyUyMExpc3QlMEFmZWF0dXJlcyUyMCUzRCUyMEZlYXR1cmVzKCU3QiUwQSUyMCUyMCUyMCUyMCd0ZXh0JyUzQSUyMFZhbHVlKCdzdHJpbmcnKSUyQyUwQSUyMCUyMCUyMCUyMCdsYWJlbCclM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJ2NhdDEnJTJDJTIwJ2NhdDInJTJDJTIwJ2NhdDMnJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCdlbWJlZGRpbmcnJTNBJTIwTGlzdChmZWF0dXJlJTNEVmFsdWUoJ2Zsb2F0MzInKSUyQyUyMGxlbmd0aCUzRDc2OCklMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9nZW5lcmF0b3IoZGF0YV9nZW5lcmF0b3IlMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZkYXRhc2V0JTIyJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjIxR0IlMjIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data_generator</span>():
    <span class="hljs-comment"># Parse your custom format progressively</span>
    <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> parse_large_file(<span class="hljs-string">&quot;data.custom&quot;</span>):
        <span class="hljs-keyword">yield</span> {
            <span class="hljs-string">&quot;text&quot;</span>: item[<span class="hljs-string">&quot;content&quot;</span>],
            <span class="hljs-string">&quot;label&quot;</span>: item[<span class="hljs-string">&quot;category&quot;</span>],
            <span class="hljs-string">&quot;embedding&quot;</span>: item[<span class="hljs-string">&quot;vector&quot;</span>]
        }

<span class="hljs-comment"># Specify features for Dataset Viewer compatibility</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Features, Value, ClassLabel, <span class="hljs-type">List</span>
features = Features({
    <span class="hljs-string">&#x27;text&#x27;</span>: Value(<span class="hljs-string">&#x27;string&#x27;</span>),
    <span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(names=[<span class="hljs-string">&#x27;cat1&#x27;</span>, <span class="hljs-string">&#x27;cat2&#x27;</span>, <span class="hljs-string">&#x27;cat3&#x27;</span>]),
    <span class="hljs-string">&#x27;embedding&#x27;</span>: <span class="hljs-type">List</span>(feature=Value(<span class="hljs-string">&#x27;float32&#x27;</span>), length=<span class="hljs-number">768</span>)
})

dataset = Dataset.from_generator(data_generator, features=features)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>)`,wrap:!1}}),yt=new h({props:{title:"Using Configs for Dataset Variations",local:"using-configs-for-dataset-variations",headingTag:"h3"}}),Tt=new T({props:{code:"JTIzJTIwUHVzaCUyMGRpZmZlcmVudCUyMGNvbmZpZ3VyYXRpb25zJTIwb2YlMjB5b3VyJTIwZGF0YXNldCUwQWRhdGFzZXRfZW4lMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdChlbmdsaXNoX2RhdGElMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUwQWRhdGFzZXRfZW4ucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZtdWx0aWxpbmd1YWwtZGF0YXNldCUyMiUyQyUyMGNvbmZpZ19uYW1lJTNEJTIyZW5nbGlzaCUyMiklMEElMEFkYXRhc2V0X2ZyJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoZnJlbmNoX2RhdGElMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUwQWRhdGFzZXRfZnIucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZtdWx0aWxpbmd1YWwtZGF0YXNldCUyMiUyQyUyMGNvbmZpZ19uYW1lJTNEJTIyZnJlbmNoJTIyKSUwQSUwQSUyMyUyMFVzZXJzJTIwY2FuJTIwdGhlbiUyMGxvYWQlMjBzcGVjaWZpYyUyMGNvbmZpZ3MlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnVzZXJuYW1lJTJGbXVsdGlsaW5ndWFsLWRhdGFzZXQlMjIlMkMlMjAlMjJlbmdsaXNoJTIyKQ==",highlighted:`<span class="hljs-comment"># Push different configurations of your dataset</span>
dataset_en = Dataset.from_dict(english_data, features=features)
dataset_en.push_to_hub(<span class="hljs-string">&quot;username/multilingual-dataset&quot;</span>, config_name=<span class="hljs-string">&quot;english&quot;</span>)

dataset_fr = Dataset.from_dict(french_data, features=features)
dataset_fr.push_to_hub(<span class="hljs-string">&quot;username/multilingual-dataset&quot;</span>, config_name=<span class="hljs-string">&quot;french&quot;</span>)

<span class="hljs-comment"># Users can then load specific configs</span>
dataset = load_dataset(<span class="hljs-string">&quot;username/multilingual-dataset&quot;</span>, <span class="hljs-string">&quot;english&quot;</span>)`,wrap:!1}}),gt=new h({props:{title:"Multi-modal Examples",local:"multi-modal-examples",headingTag:"h3"}}),wt=new T({props:{code:"ZGVmJTIwc3BlZWNoX2dlbmVyYXRvcigpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYXVkaW9fZmlsZSUyMGluJTIwUGF0aCglMjJhdWRpbyUyRiUyMikuZ2xvYiglMjIqLndhdiUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2NyaXB0X2ZpbGUlMjAlM0QlMjBhdWRpb19maWxlLndpdGhfc3VmZml4KCUyMi50eHQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMHN0cihhdWRpb19maWxlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjB0cmFuc2NyaXB0X2ZpbGUucmVhZF90ZXh0KCkuc3RyaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNwZWFrZXJfaWQlMjIlM0ElMjBhdWRpb19maWxlLnN0ZW0uc3BsaXQoJTIyXyUyMiklNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBGZWF0dXJlcyglN0IlMEElMjAlMjAlMjAlMjAnYXVkaW8nJTNBJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSUyQyUwQSUyMCUyMCUyMCUyMCd0ZXh0JyUzQSUyMFZhbHVlKCdzdHJpbmcnKSUyQyUwQSUyMCUyMCUyMCUyMCdzcGVha2VyX2lkJyUzQSUyMFZhbHVlKCdzdHJpbmcnKSUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2dlbmVyYXRvcihzcGVlY2hfZ2VuZXJhdG9yJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGc3BlZWNoLWRhdGFzZXQlMjIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">speech_generator</span>():
    <span class="hljs-keyword">for</span> audio_file <span class="hljs-keyword">in</span> Path(<span class="hljs-string">&quot;audio/&quot;</span>).glob(<span class="hljs-string">&quot;*.wav&quot;</span>):
        transcript_file = audio_file.with_suffix(<span class="hljs-string">&quot;.txt&quot;</span>)
        <span class="hljs-keyword">yield</span> {
            <span class="hljs-string">&quot;audio&quot;</span>: <span class="hljs-built_in">str</span>(audio_file),
            <span class="hljs-string">&quot;text&quot;</span>: transcript_file.read_text().strip(),
            <span class="hljs-string">&quot;speaker_id&quot;</span>: audio_file.stem.split(<span class="hljs-string">&quot;_&quot;</span>)[<span class="hljs-number">0</span>]
        }

features = Features({
    <span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">16000</span>),
    <span class="hljs-string">&#x27;text&#x27;</span>: Value(<span class="hljs-string">&#x27;string&#x27;</span>),
    <span class="hljs-string">&#x27;speaker_id&#x27;</span>: Value(<span class="hljs-string">&#x27;string&#x27;</span>)
})

dataset = Dataset.from_generator(speech_generator, features=features)
dataset.push_to_hub(<span class="hljs-string">&quot;username/speech-dataset&quot;</span>)`,wrap:!1}}),jt=new T({props:{code:"JTIzJTIwQmVmb3JlJTJGYWZ0ZXIlMjBpbWFnZXMlMkMlMjBtZWRpY2FsJTIwaW1hZ2luZyUyQyUyMGV0Yy4lMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaW1hZ2VfYmVmb3JlJTIyJTNBJTIwJTVCJTIyaW1nMV9iZWZvcmUuanBnJTIyJTJDJTIwJTIyaW1nMl9iZWZvcmUuanBnJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyaW1hZ2VfYWZ0ZXIlMjIlM0ElMjAlNUIlMjJpbWcxX2FmdGVyLmpwZyUyMiUyQyUyMCUyMmltZzJfYWZ0ZXIuanBnJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJlYXRtZW50JTIyJTNBJTIwJTVCJTIybWV0aG9kX0ElMjIlMkMlMjAlMjJtZXRob2RfQiUyMiU1RCUwQSU3RCUwQSUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTBBJTIwJTIwJTIwJTIwJ2ltYWdlX2JlZm9yZSclM0ElMjBJbWFnZSgpJTJDJTBBJTIwJTIwJTIwJTIwJ2ltYWdlX2FmdGVyJyUzQSUyMEltYWdlKCklMkMlMEElMjAlMjAlMjAlMjAndHJlYXRtZW50JyUzQSUyMENsYXNzTGFiZWwobmFtZXMlM0QlNUInbWV0aG9kX0EnJTJDJTIwJ21ldGhvZF9CJyU1RCklMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KGRhdGElMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZiZWZvcmUtYWZ0ZXItaW1hZ2VzJTIyKQ==",highlighted:`<span class="hljs-comment"># Before/after images, medical imaging, etc.</span>
data = {
    <span class="hljs-string">&quot;image_before&quot;</span>: [<span class="hljs-string">&quot;img1_before.jpg&quot;</span>, <span class="hljs-string">&quot;img2_before.jpg&quot;</span>],
    <span class="hljs-string">&quot;image_after&quot;</span>: [<span class="hljs-string">&quot;img1_after.jpg&quot;</span>, <span class="hljs-string">&quot;img2_after.jpg&quot;</span>],
    <span class="hljs-string">&quot;treatment&quot;</span>: [<span class="hljs-string">&quot;method_A&quot;</span>, <span class="hljs-string">&quot;method_B&quot;</span>]
}

features = Features({
    <span class="hljs-string">&#x27;image_before&#x27;</span>: Image(),
    <span class="hljs-string">&#x27;image_after&#x27;</span>: Image(),
    <span class="hljs-string">&#x27;treatment&#x27;</span>: ClassLabel(names=[<span class="hljs-string">&#x27;method_A&#x27;</span>, <span class="hljs-string">&#x27;method_B&#x27;</span>])
})

dataset = Dataset.from_dict(data, features=features)
dataset.push_to_hub(<span class="hljs-string">&quot;username/before-after-images&quot;</span>)`,wrap:!1}}),It=new h({props:{title:"Essential Features",local:"essential-features",headingTag:"h2"}}),Zt=new h({props:{title:"Feature Types Overview",local:"feature-types-overview",headingTag:"h3"}}),Vt=new h({props:{title:"Upload Methods",local:"upload-methods",headingTag:"h2"}}),Lt=new T({props:{code:"ZGF0YXNldC5wdXNoX3RvX2h1YiglMjJ1c2VybmFtZSUyRmRhdGFzZXQlMjIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjVHQiUyMik=",highlighted:'dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>, max_shard_size=<span class="hljs-string">&quot;5GB&quot;</span>)',wrap:!1}}),zt=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS51cGxvYWRfbGFyZ2VfZm9sZGVyKGZvbGRlcl9wYXRoJTNEJTIyLiUyRmRhdGElMjIlMkMlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZkYXRhc2V0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMG51bV93b3JrZXJzJTNEMTYp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi()
api.upload_large_folder(folder_path=<span class="hljs-string">&quot;./data&quot;</span>, repo_id=<span class="hljs-string">&quot;username/dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, num_workers=<span class="hljs-number">16</span>)`,wrap:!1}}),St=new h({props:{title:"Validation",local:"validation",headingTag:"h2"}}),Pt=new T({props:{code:"JTIzJTIwVGVzdCUyMGZpcnN0JTIwZXhhbXBsZSUwQXByaW50KGRhdGFzZXQlNUIwJTVEKSUwQSUwQSUyMyUyMEZvciUyMGltYWdlcyUzQSUyMHZlcmlmeSUyMHRoZXklMjBsb2FkJTBBaWYlMjAnaW1hZ2UnJTIwaW4lMjBkYXRhc2V0LmZlYXR1cmVzJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCU1QjAlNUQlNUInaW1hZ2UnJTVEJTIwJTIwJTIzJTIwU2hvdWxkJTIwcmV0dXJuJTIwUElMJTIwSW1hZ2UlMEElMEElMjMlMjBDaGVjayUyMGRhdGFzZXQlMjBzaXplJTIwYmVmb3JlJTIwdXBsb2FkJTBBcHJpbnQoZiUyMlNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjBleGFtcGxlcyUyMik=",highlighted:`<span class="hljs-comment"># Test first example</span>
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-number">0</span>])

<span class="hljs-comment"># For images: verify they load</span>
<span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;image&#x27;</span> <span class="hljs-keyword">in</span> dataset.features:
    dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;image&#x27;</span>]  <span class="hljs-comment"># Should return PIL Image</span>

<span class="hljs-comment"># Check dataset size before upload</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span> examples&quot;</span>)`,wrap:!1}}),te=new h({props:{title:"Common Issues → Solutions",local:"common-issues--solutions",headingTag:"h2"}}),se=new h({props:{title:"Dataset Viewer Configuration",local:"dataset-viewer-configuration",headingTag:"h2"}}),ae=new h({props:{title:"When automatic detection works",local:"when-automatic-detection-works",headingTag:"h3"}}),oe=new h({props:{title:"Manual configuration",local:"manual-configuration",headingTag:"h3"}}),pe=new T({props:{code:"LS0tJTBBY29uZmlncyUzQSUwQSUyMCUyMC0lMjBjb25maWdfbmFtZSUzQSUyMGRlZmF1bHQlMjAlMjMlMjBSZXF1aXJlZCUyMGV2ZW4lMjBmb3IlMjBzaW5nbGUlMjBjb25maWchJTBBJTIwJTIwJTIwJTIwZGF0YV9maWxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMC0lMjBzcGxpdCUzQSUyMHRyYWluJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0aCUzQSUyMCUyMmRhdGElMkZ0cmFpbiUyRioucGFycXVldCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMC0lMjBzcGxpdCUzQSUyMHRlc3QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoJTNBJTIwJTIyZGF0YSUyRnRlc3QlMkYqLnBhcnF1ZXQlMjIlMEEtLS0=",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">configs:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-attr">config_name:</span> <span class="hljs-string">default</span> <span class="hljs-comment"># Required even for single config!</span>
    <span class="hljs-attr">data_files:</span>
      <span class="hljs-bullet">-</span> <span class="hljs-attr">split:</span> <span class="hljs-string">train</span>
        <span class="hljs-attr">path:</span> <span class="hljs-string">&quot;data/train/*.parquet&quot;</span>
      <span class="hljs-bullet">-</span> <span class="hljs-attr">split:</span> <span class="hljs-string">test</span>
        <span class="hljs-attr">path:</span> <span class="hljs-string">&quot;data/test/*.parquet&quot;</span>
<span class="hljs-meta">---</span>`,wrap:!1}}),ue=new T({props:{code:"LS0tJTBBY29uZmlncyUzQSUwQSUyMCUyMC0lMjBjb25maWdfbmFtZSUzQSUyMGVuZ2xpc2glMEElMjAlMjAlMjAlMjBkYXRhX2ZpbGVzJTNBJTIwJTIyZW4lMkYqLnBhcnF1ZXQlMjIlMEElMjAlMjAtJTIwY29uZmlnX25hbWUlM0ElMjBmcmVuY2glMEElMjAlMjAlMjAlMjBkYXRhX2ZpbGVzJTNBJTIwJTIyZnIlMkYqLnBhcnF1ZXQlMjIlMEEtLS0=",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">configs:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-attr">config_name:</span> <span class="hljs-string">english</span>
    <span class="hljs-attr">data_files:</span> <span class="hljs-string">&quot;en/*.parquet&quot;</span>
  <span class="hljs-bullet">-</span> <span class="hljs-attr">config_name:</span> <span class="hljs-string">french</span>
    <span class="hljs-attr">data_files:</span> <span class="hljs-string">&quot;fr/*.parquet&quot;</span>
<span class="hljs-meta">---</span>`,wrap:!1}}),me=new h({props:{title:"Common viewer issues",local:"common-viewer-issues",headingTag:"h3"}}),Me=new h({props:{title:"Quick Templates",local:"quick-templates",headingTag:"h2"}}),fe=new T({props:{code:"JTIzJTIwSW1hZ2VGb2xkZXIlMjB3aXRoJTIwbWV0YWRhdGElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltYWdlZm9sZGVyJTIyJTJDJTIwZGF0YV9kaXIlM0QlMjIuJTJGaW1hZ2VzJTIyKSUwQWRhdGFzZXQucHVzaF90b19odWIoJTIydXNlcm5hbWUlMkZkYXRhc2V0JTIyKSUwQSUwQSUyMyUyME1lbW9yeS1lZmZpY2llbnQlMjB1cGxvYWQlMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldCUyMiUyQyUyMG1heF9zaGFyZF9zaXplJTNEJTIyNTAwTUIlMjIpJTBBJTBBJTIzJTIwTXVsdGlwbGUlMjBDU1YlMjBmaWxlcyUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ2NzdiclMkMlMjBkYXRhX2ZpbGVzJTNEJTdCJ3RyYWluJyUzQSUyMCd0cmFpbi5jc3YnJTJDJTIwJ3Rlc3QnJTNBJTIwJ3Rlc3QuY3N2JyU3RCklMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMnVzZXJuYW1lJTJGZGF0YXNldCUyMik=",highlighted:`<span class="hljs-comment"># ImageFolder with metadata</span>
dataset = load_dataset(<span class="hljs-string">&quot;imagefolder&quot;</span>, data_dir=<span class="hljs-string">&quot;./images&quot;</span>)
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>)

<span class="hljs-comment"># Memory-efficient upload</span>
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>, max_shard_size=<span class="hljs-string">&quot;500MB&quot;</span>)

<span class="hljs-comment"># Multiple CSV files</span>
dataset = load_dataset(<span class="hljs-string">&#x27;csv&#x27;</span>, data_files={<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;train.csv&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>: <span class="hljs-string">&#x27;test.csv&#x27;</span>})
dataset.push_to_hub(<span class="hljs-string">&quot;username/dataset&quot;</span>)`,wrap:!1}}),he=new h({props:{title:"Documentation",local:"documentation",headingTag:"h2"}}),Te=new h({props:{title:"Dataset Cards",local:"dataset-cards",headingTag:"h2"}}),Ue=new h({props:{title:"Appendix: Special Cases",local:"appendix-special-cases",headingTag:"h2"}}),je=new h({props:{title:"WebDataset Structure",local:"webdataset-structure",headingTag:"h3"}}),Ce=new h({props:{title:"Scientific Data",local:"scientific-data",headingTag:"h3"}}),ve=new h({props:{title:"Community Resources",local:"community-resources",headingTag:"h3"}}),xe=new Pn({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-upload-guide-llm.md"}}),{c(){U=i("meta"),Ee=a(),Ye=i("p"),Ne=a(),p(b.$$.fragment),Ae=a(),p(I.$$.fragment),De=a(),j=i("blockquote"),j.innerHTML=wa,Pe=a(),C=i("blockquote"),C.innerHTML=Ua,Ke=a(),p($.$$.fragment),Oe=a(),v=i("p"),v.innerHTML=ja,ts=a(),Z=i("table"),Z.innerHTML=ba,es=a(),p(_.$$.fragment),ss=a(),x=i("p"),x.textContent=Ia,ls=a(),G=i("p"),G.innerHTML=Ca,as=a(),p(B.$$.fragment),ns=a(),X=i("p"),X.innerHTML=$a,is=a(),p(F.$$.fragment),os=a(),W=i("p"),W.innerHTML=va,rs=a(),p(k.$$.fragment),ps=a(),q=i("p"),q.innerHTML=Za,ds=a(),p(V.$$.fragment),us=a(),p(H.$$.fragment),ms=a(),L=i("p"),L.innerHTML=_a,cs=a(),p(R.$$.fragment),Ms=a(),z=i("p"),z.innerHTML=xa,fs=a(),Q=i("ul"),Q.innerHTML=Ga,hs=a(),Y=i("p"),Y.innerHTML=Ba,ys=a(),p(S.$$.fragment),Ts=a(),E=i("table"),E.innerHTML=Xa,gs=a(),p(N.$$.fragment),Js=a(),y=i("ol"),Be=i("li"),Be.innerHTML=Fa,oa=a(),Xe=i("li"),Xe.innerHTML=Wa,ra=a(),Fe=i("li"),Fe.innerHTML=ka,pa=a(),We=i("li"),We.innerHTML=qa,da=a(),A=i("li"),ke=i("p"),ke.innerHTML=Va,ua=a(),p(D.$$.fragment),ma=a(),P=i("li"),qe=i("p"),qe.innerHTML=Ha,ca=a(),p(K.$$.fragment),Ma=a(),Ve=i("li"),Ve.innerHTML=La,ws=a(),p(O.$$.fragment),Us=a(),tt=i("p"),tt.innerHTML=Ra,js=a(),p(et.$$.fragment),bs=a(),st=i("p"),st.textContent=za,Is=a(),p(lt.$$.fragment),Cs=a(),p(at.$$.fragment),$s=a(),nt=i("p"),nt.textContent=Qa,vs=a(),p(it.$$.fragment),Zs=a(),ot=i("p"),ot.innerHTML=Ya,_s=a(),rt=i("ul"),rt.innerHTML=Sa,xs=a(),pt=i("p"),pt.innerHTML=Ea,Gs=a(),dt=i("ul"),dt.innerHTML=Na,Bs=a(),p(ut.$$.fragment),Xs=a(),mt=i("p"),mt.innerHTML=Aa,Fs=a(),p(ct.$$.fragment),Ws=a(),Mt=i("p"),Mt.innerHTML=Da,ks=a(),p(ft.$$.fragment),qs=a(),ht=i("p"),ht.innerHTML=Pa,Vs=a(),p(yt.$$.fragment),Hs=a(),p(Tt.$$.fragment),Ls=a(),p(gt.$$.fragment),Rs=a(),Jt=i("p"),Jt.innerHTML=Ka,zs=a(),p(wt.$$.fragment),Qs=a(),Ut=i("p"),Ut.innerHTML=Oa,Ys=a(),p(jt.$$.fragment),Ss=a(),bt=i("p"),bt.innerHTML=tn,Es=a(),p(It.$$.fragment),Ns=a(),Ct=i("p"),Ct.textContent=en,As=a(),$t=i("ul"),$t.innerHTML=sn,Ds=a(),vt=i("p"),vt.innerHTML=ln,Ps=a(),p(Zt.$$.fragment),Ks=a(),_t=i("p"),_t.innerHTML=an,Os=a(),xt=i("ul"),xt.innerHTML=nn,tl=a(),Gt=i("p"),Gt.innerHTML=on,el=a(),Bt=i("ul"),Bt.innerHTML=rn,sl=a(),Xt=i("p"),Xt.innerHTML=pn,ll=a(),Ft=i("ul"),Ft.innerHTML=dn,al=a(),Wt=i("p"),Wt.innerHTML=un,nl=a(),kt=i("ul"),kt.innerHTML=mn,il=a(),qt=i("p"),qt.innerHTML=cn,ol=a(),p(Vt.$$.fragment),rl=a(),Ht=i("p"),Ht.innerHTML=Mn,pl=a(),p(Lt.$$.fragment),dl=a(),Rt=i("p"),Rt.innerHTML=fn,ul=a(),p(zt.$$.fragment),ml=a(),Qt=i("p"),Qt.innerHTML=hn,cl=a(),Yt=i("ul"),Yt.innerHTML=yn,Ml=a(),p(St.$$.fragment),fl=a(),Et=i("p"),Et.innerHTML=Tn,hl=a(),Nt=i("ul"),Nt.innerHTML=gn,yl=a(),At=i("p"),At.innerHTML=Jn,Tl=a(),g=i("ul"),He=i("li"),He.innerHTML=wn,fa=a(),Dt=i("li"),Le=i("p"),Le.textContent=Un,ha=a(),p(Pt.$$.fragment),ya=a(),Re=i("li"),Re.innerHTML=jn,Ta=a(),ze=i("li"),ze.innerHTML=bn,ga=a(),Qe=i("li"),Qe.innerHTML=In,gl=a(),Kt=i("p"),Kt.innerHTML=Cn,Jl=a(),Ot=i("ul"),Ot.innerHTML=$n,wl=a(),p(te.$$.fragment),Ul=a(),ee=i("table"),ee.innerHTML=vn,jl=a(),p(se.$$.fragment),bl=a(),le=i("p"),le.innerHTML=Zn,Il=a(),p(ae.$$.fragment),Cl=a(),ne=i("p"),ne.textContent=_n,$l=a(),ie=i("ul"),ie.innerHTML=xn,vl=a(),p(oe.$$.fragment),Zl=a(),re=i("p"),re.textContent=Gn,_l=a(),p(pe.$$.fragment),xl=a(),de=i("p"),de.textContent=Bn,Gl=a(),p(ue.$$.fragment),Bl=a(),p(me.$$.fragment),Xl=a(),ce=i("ul"),ce.innerHTML=Xn,Fl=a(),p(Me.$$.fragment),Wl=a(),p(fe.$$.fragment),kl=a(),p(he.$$.fragment),ql=a(),ye=i("p"),ye.innerHTML=Fn,Vl=a(),p(Te.$$.fragment),Hl=a(),ge=i("p"),ge.textContent=Wn,Ll=a(),Je=i("ul"),Je.innerHTML=kn,Rl=a(),we=i("p"),we.innerHTML=qn,zl=a(),Ql=i("hr"),Yl=a(),p(Ue.$$.fragment),Sl=a(),p(je.$$.fragment),El=a(),be=i("p"),be.textContent=Vn,Nl=a(),Ie=i("ul"),Ie.innerHTML=Hn,Al=a(),p(Ce.$$.fragment),Dl=a(),$e=i("ul"),$e.innerHTML=Ln,Pl=a(),p(ve.$$.fragment),Kl=a(),Ze=i("p"),Ze.textContent=Rn,Ol=a(),_e=i("ul"),_e.innerHTML=zn,ta=a(),p(xe.$$.fragment),ea=a(),Se=i("p"),this.h()},l(t){const e=An("svelte-u9bgzb",document.head);U=o(e,"META",{name:!0,content:!0}),e.forEach(s),Ee=n(t),Ye=o(t,"P",{}),Ge(Ye).forEach(s),Ne=n(t),d(b.$$.fragment,t),Ae=n(t),d(I.$$.fragment,t),De=n(t),j=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1ci1pys"&&(j.innerHTML=wa),Pe=n(t),C=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(C)!=="svelte-1fajnvg"&&(C.innerHTML=Ua),Ke=n(t),d($.$$.fragment,t),Oe=n(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-hun1os"&&(v.innerHTML=ja),ts=n(t),Z=o(t,"TABLE",{"data-svelte-h":!0}),r(Z)!=="svelte-1x2va0m"&&(Z.innerHTML=ba),es=n(t),d(_.$$.fragment,t),ss=n(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-s1susn"&&(x.textContent=Ia),ls=n(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-183nx4y"&&(G.innerHTML=Ca),as=n(t),d(B.$$.fragment,t),ns=n(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-ddy51v"&&(X.innerHTML=$a),is=n(t),d(F.$$.fragment,t),os=n(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1x9yqrg"&&(W.innerHTML=va),rs=n(t),d(k.$$.fragment,t),ps=n(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1lf1f1j"&&(q.innerHTML=Za),ds=n(t),d(V.$$.fragment,t),us=n(t),d(H.$$.fragment,t),ms=n(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-15kuw4y"&&(L.innerHTML=_a),cs=n(t),d(R.$$.fragment,t),Ms=n(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-16tkzi3"&&(z.innerHTML=xa),fs=n(t),Q=o(t,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-n5n6u5"&&(Q.innerHTML=Ga),hs=n(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-bpnjb2"&&(Y.innerHTML=Ba),ys=n(t),d(S.$$.fragment,t),Ts=n(t),E=o(t,"TABLE",{"data-svelte-h":!0}),r(E)!=="svelte-1qthh5o"&&(E.innerHTML=Xa),gs=n(t),d(N.$$.fragment,t),Js=n(t),y=o(t,"OL",{start:!0});var J=Ge(y);Be=o(J,"LI",{"data-svelte-h":!0}),r(Be)!=="svelte-coqx"&&(Be.innerHTML=Fa),oa=n(J),Xe=o(J,"LI",{"data-svelte-h":!0}),r(Xe)!=="svelte-13hzcf6"&&(Xe.innerHTML=Wa),ra=n(J),Fe=o(J,"LI",{"data-svelte-h":!0}),r(Fe)!=="svelte-1x7390r"&&(Fe.innerHTML=ka),pa=n(J),We=o(J,"LI",{"data-svelte-h":!0}),r(We)!=="svelte-1lpi177"&&(We.innerHTML=qa),da=n(J),A=o(J,"LI",{});var la=Ge(A);ke=o(la,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-docjp3"&&(ke.innerHTML=Va),ua=n(la),d(D.$$.fragment,la),la.forEach(s),ma=n(J),P=o(J,"LI",{});var aa=Ge(P);qe=o(aa,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-8stqwj"&&(qe.innerHTML=Ha),ca=n(aa),d(K.$$.fragment,aa),aa.forEach(s),Ma=n(J),Ve=o(J,"LI",{"data-svelte-h":!0}),r(Ve)!=="svelte-28v5ni"&&(Ve.innerHTML=La),J.forEach(s),ws=n(t),d(O.$$.fragment,t),Us=n(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-au918z"&&(tt.innerHTML=Ra),js=n(t),d(et.$$.fragment,t),bs=n(t),st=o(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-lvop0e"&&(st.textContent=za),Is=n(t),d(lt.$$.fragment,t),Cs=n(t),d(at.$$.fragment,t),$s=n(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-ar9k36"&&(nt.textContent=Qa),vs=n(t),d(it.$$.fragment,t),Zs=n(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-iur0js"&&(ot.innerHTML=Ya),_s=n(t),rt=o(t,"UL",{"data-svelte-h":!0}),r(rt)!=="svelte-1dkzusn"&&(rt.innerHTML=Sa),xs=n(t),pt=o(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-r65yvz"&&(pt.innerHTML=Ea),Gs=n(t),dt=o(t,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-9qv5vd"&&(dt.innerHTML=Na),Bs=n(t),d(ut.$$.fragment,t),Xs=n(t),mt=o(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-iuck5z"&&(mt.innerHTML=Aa),Fs=n(t),d(ct.$$.fragment,t),Ws=n(t),Mt=o(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-15huzsb"&&(Mt.innerHTML=Da),ks=n(t),d(ft.$$.fragment,t),qs=n(t),ht=o(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-12bonk0"&&(ht.innerHTML=Pa),Vs=n(t),d(yt.$$.fragment,t),Hs=n(t),d(Tt.$$.fragment,t),Ls=n(t),d(gt.$$.fragment,t),Rs=n(t),Jt=o(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1u8i1rn"&&(Jt.innerHTML=Ka),zs=n(t),d(wt.$$.fragment,t),Qs=n(t),Ut=o(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1jgfsm0"&&(Ut.innerHTML=Oa),Ys=n(t),d(jt.$$.fragment,t),Ss=n(t),bt=o(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-wsof8w"&&(bt.innerHTML=tn),Es=n(t),d(It.$$.fragment,t),Ns=n(t),Ct=o(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1odksos"&&(Ct.textContent=en),As=n(t),$t=o(t,"UL",{"data-svelte-h":!0}),r($t)!=="svelte-t5ru0o"&&($t.innerHTML=sn),Ds=n(t),vt=o(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1qjpjc5"&&(vt.innerHTML=ln),Ps=n(t),d(Zt.$$.fragment,t),Ks=n(t),_t=o(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1qg37o8"&&(_t.innerHTML=an),Os=n(t),xt=o(t,"UL",{"data-svelte-h":!0}),r(xt)!=="svelte-3fng8i"&&(xt.innerHTML=nn),tl=n(t),Gt=o(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1x89mat"&&(Gt.innerHTML=on),el=n(t),Bt=o(t,"UL",{"data-svelte-h":!0}),r(Bt)!=="svelte-1tm6u7n"&&(Bt.innerHTML=rn),sl=n(t),Xt=o(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-s170ij"&&(Xt.innerHTML=pn),ll=n(t),Ft=o(t,"UL",{"data-svelte-h":!0}),r(Ft)!=="svelte-1rqoami"&&(Ft.innerHTML=dn),al=n(t),Wt=o(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1xno8op"&&(Wt.innerHTML=un),nl=n(t),kt=o(t,"UL",{"data-svelte-h":!0}),r(kt)!=="svelte-swic33"&&(kt.innerHTML=mn),il=n(t),qt=o(t,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-1wn0wiu"&&(qt.innerHTML=cn),ol=n(t),d(Vt.$$.fragment,t),rl=n(t),Ht=o(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-msn4wa"&&(Ht.innerHTML=Mn),pl=n(t),d(Lt.$$.fragment,t),dl=n(t),Rt=o(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-1oorzyp"&&(Rt.innerHTML=fn),ul=n(t),d(zt.$$.fragment,t),ml=n(t),Qt=o(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-egl09b"&&(Qt.innerHTML=hn),cl=n(t),Yt=o(t,"UL",{"data-svelte-h":!0}),r(Yt)!=="svelte-j2q96t"&&(Yt.innerHTML=yn),Ml=n(t),d(St.$$.fragment,t),fl=n(t),Et=o(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-tjyq6k"&&(Et.innerHTML=Tn),hl=n(t),Nt=o(t,"UL",{"data-svelte-h":!0}),r(Nt)!=="svelte-1dn48bv"&&(Nt.innerHTML=gn),yl=n(t),At=o(t,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1bpf54c"&&(At.innerHTML=Jn),Tl=n(t),g=o(t,"UL",{});var w=Ge(g);He=o(w,"LI",{"data-svelte-h":!0}),r(He)!=="svelte-v6f4tr"&&(He.innerHTML=wn),fa=n(w),Dt=o(w,"LI",{});var na=Ge(Dt);Le=o(na,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-15dlcf2"&&(Le.textContent=Un),ha=n(na),d(Pt.$$.fragment,na),na.forEach(s),ya=n(w),Re=o(w,"LI",{"data-svelte-h":!0}),r(Re)!=="svelte-1qjx0kd"&&(Re.innerHTML=jn),Ta=n(w),ze=o(w,"LI",{"data-svelte-h":!0}),r(ze)!=="svelte-u9u4qm"&&(ze.innerHTML=bn),ga=n(w),Qe=o(w,"LI",{"data-svelte-h":!0}),r(Qe)!=="svelte-1pgq06d"&&(Qe.innerHTML=In),w.forEach(s),gl=n(t),Kt=o(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1hyf2bz"&&(Kt.innerHTML=Cn),Jl=n(t),Ot=o(t,"UL",{"data-svelte-h":!0}),r(Ot)!=="svelte-8u5q5t"&&(Ot.innerHTML=$n),wl=n(t),d(te.$$.fragment,t),Ul=n(t),ee=o(t,"TABLE",{"data-svelte-h":!0}),r(ee)!=="svelte-1lkt6pd"&&(ee.innerHTML=vn),jl=n(t),d(se.$$.fragment,t),bl=n(t),le=o(t,"P",{"data-svelte-h":!0}),r(le)!=="svelte-g003c9"&&(le.innerHTML=Zn),Il=n(t),d(ae.$$.fragment,t),Cl=n(t),ne=o(t,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-16loxkj"&&(ne.textContent=_n),$l=n(t),ie=o(t,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-1hto711"&&(ie.innerHTML=xn),vl=n(t),d(oe.$$.fragment,t),Zl=n(t),re=o(t,"P",{"data-svelte-h":!0}),r(re)!=="svelte-v9qyvd"&&(re.textContent=Gn),_l=n(t),d(pe.$$.fragment,t),xl=n(t),de=o(t,"P",{"data-svelte-h":!0}),r(de)!=="svelte-mkdef3"&&(de.textContent=Bn),Gl=n(t),d(ue.$$.fragment,t),Bl=n(t),d(me.$$.fragment,t),Xl=n(t),ce=o(t,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-13hljct"&&(ce.innerHTML=Xn),Fl=n(t),d(Me.$$.fragment,t),Wl=n(t),d(fe.$$.fragment,t),kl=n(t),d(he.$$.fragment,t),ql=n(t),ye=o(t,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-vz9qls"&&(ye.innerHTML=Fn),Vl=n(t),d(Te.$$.fragment,t),Hl=n(t),ge=o(t,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-3if0hu"&&(ge.textContent=Wn),Ll=n(t),Je=o(t,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-jr8bcr"&&(Je.innerHTML=kn),Rl=n(t),we=o(t,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1f9g19l"&&(we.innerHTML=qn),zl=n(t),Ql=o(t,"HR",{}),Yl=n(t),d(Ue.$$.fragment,t),Sl=n(t),d(je.$$.fragment,t),El=n(t),be=o(t,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1cttxvh"&&(be.textContent=Vn),Nl=n(t),Ie=o(t,"UL",{"data-svelte-h":!0}),r(Ie)!=="svelte-1pv9cl9"&&(Ie.innerHTML=Hn),Al=n(t),d(Ce.$$.fragment,t),Dl=n(t),$e=o(t,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-1h00ccq"&&($e.innerHTML=Ln),Pl=n(t),d(ve.$$.fragment,t),Kl=n(t),Ze=o(t,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-qsd78w"&&(Ze.textContent=Rn),Ol=n(t),_e=o(t,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-gadoy2"&&(_e.innerHTML=zn),ta=n(t),d(xe.$$.fragment,t),ea=n(t),Se=o(t,"P",{}),Ge(Se).forEach(s),this.h()},h(){ia(U,"name","hf:doc:metadata"),ia(U,"content",On),ia(j,"class","tip"),ia(y,"start","0")},m(t,e){f(document.head,U),l(t,Ee,e),l(t,Ye,e),l(t,Ne,e),u(b,t,e),l(t,Ae,e),u(I,t,e),l(t,De,e),l(t,j,e),l(t,Pe,e),l(t,C,e),l(t,Ke,e),u($,t,e),l(t,Oe,e),l(t,v,e),l(t,ts,e),l(t,Z,e),l(t,es,e),u(_,t,e),l(t,ss,e),l(t,x,e),l(t,ls,e),l(t,G,e),l(t,as,e),u(B,t,e),l(t,ns,e),l(t,X,e),l(t,is,e),u(F,t,e),l(t,os,e),l(t,W,e),l(t,rs,e),u(k,t,e),l(t,ps,e),l(t,q,e),l(t,ds,e),u(V,t,e),l(t,us,e),u(H,t,e),l(t,ms,e),l(t,L,e),l(t,cs,e),u(R,t,e),l(t,Ms,e),l(t,z,e),l(t,fs,e),l(t,Q,e),l(t,hs,e),l(t,Y,e),l(t,ys,e),u(S,t,e),l(t,Ts,e),l(t,E,e),l(t,gs,e),u(N,t,e),l(t,Js,e),l(t,y,e),f(y,Be),f(y,oa),f(y,Xe),f(y,ra),f(y,Fe),f(y,pa),f(y,We),f(y,da),f(y,A),f(A,ke),f(A,ua),u(D,A,null),f(y,ma),f(y,P),f(P,qe),f(P,ca),u(K,P,null),f(y,Ma),f(y,Ve),l(t,ws,e),u(O,t,e),l(t,Us,e),l(t,tt,e),l(t,js,e),u(et,t,e),l(t,bs,e),l(t,st,e),l(t,Is,e),u(lt,t,e),l(t,Cs,e),u(at,t,e),l(t,$s,e),l(t,nt,e),l(t,vs,e),u(it,t,e),l(t,Zs,e),l(t,ot,e),l(t,_s,e),l(t,rt,e),l(t,xs,e),l(t,pt,e),l(t,Gs,e),l(t,dt,e),l(t,Bs,e),u(ut,t,e),l(t,Xs,e),l(t,mt,e),l(t,Fs,e),u(ct,t,e),l(t,Ws,e),l(t,Mt,e),l(t,ks,e),u(ft,t,e),l(t,qs,e),l(t,ht,e),l(t,Vs,e),u(yt,t,e),l(t,Hs,e),u(Tt,t,e),l(t,Ls,e),u(gt,t,e),l(t,Rs,e),l(t,Jt,e),l(t,zs,e),u(wt,t,e),l(t,Qs,e),l(t,Ut,e),l(t,Ys,e),u(jt,t,e),l(t,Ss,e),l(t,bt,e),l(t,Es,e),u(It,t,e),l(t,Ns,e),l(t,Ct,e),l(t,As,e),l(t,$t,e),l(t,Ds,e),l(t,vt,e),l(t,Ps,e),u(Zt,t,e),l(t,Ks,e),l(t,_t,e),l(t,Os,e),l(t,xt,e),l(t,tl,e),l(t,Gt,e),l(t,el,e),l(t,Bt,e),l(t,sl,e),l(t,Xt,e),l(t,ll,e),l(t,Ft,e),l(t,al,e),l(t,Wt,e),l(t,nl,e),l(t,kt,e),l(t,il,e),l(t,qt,e),l(t,ol,e),u(Vt,t,e),l(t,rl,e),l(t,Ht,e),l(t,pl,e),u(Lt,t,e),l(t,dl,e),l(t,Rt,e),l(t,ul,e),u(zt,t,e),l(t,ml,e),l(t,Qt,e),l(t,cl,e),l(t,Yt,e),l(t,Ml,e),u(St,t,e),l(t,fl,e),l(t,Et,e),l(t,hl,e),l(t,Nt,e),l(t,yl,e),l(t,At,e),l(t,Tl,e),l(t,g,e),f(g,He),f(g,fa),f(g,Dt),f(Dt,Le),f(Dt,ha),u(Pt,Dt,null),f(g,ya),f(g,Re),f(g,Ta),f(g,ze),f(g,ga),f(g,Qe),l(t,gl,e),l(t,Kt,e),l(t,Jl,e),l(t,Ot,e),l(t,wl,e),u(te,t,e),l(t,Ul,e),l(t,ee,e),l(t,jl,e),u(se,t,e),l(t,bl,e),l(t,le,e),l(t,Il,e),u(ae,t,e),l(t,Cl,e),l(t,ne,e),l(t,$l,e),l(t,ie,e),l(t,vl,e),u(oe,t,e),l(t,Zl,e),l(t,re,e),l(t,_l,e),u(pe,t,e),l(t,xl,e),l(t,de,e),l(t,Gl,e),u(ue,t,e),l(t,Bl,e),u(me,t,e),l(t,Xl,e),l(t,ce,e),l(t,Fl,e),u(Me,t,e),l(t,Wl,e),u(fe,t,e),l(t,kl,e),u(he,t,e),l(t,ql,e),l(t,ye,e),l(t,Vl,e),u(Te,t,e),l(t,Hl,e),l(t,ge,e),l(t,Ll,e),l(t,Je,e),l(t,Rl,e),l(t,we,e),l(t,zl,e),l(t,Ql,e),l(t,Yl,e),u(Ue,t,e),l(t,Sl,e),u(je,t,e),l(t,El,e),l(t,be,e),l(t,Nl,e),l(t,Ie,e),l(t,Al,e),u(Ce,t,e),l(t,Dl,e),l(t,$e,e),l(t,Pl,e),u(ve,t,e),l(t,Kl,e),l(t,Ze,e),l(t,Ol,e),l(t,_e,e),l(t,ta,e),u(xe,t,e),l(t,ea,e),l(t,Se,e),sa=!0},p:Yn,i(t){sa||(m(b.$$.fragment,t),m(I.$$.fragment,t),m($.$$.fragment,t),m(_.$$.fragment,t),m(B.$$.fragment,t),m(F.$$.fragment,t),m(k.$$.fragment,t),m(V.$$.fragment,t),m(H.$$.fragment,t),m(R.$$.fragment,t),m(S.$$.fragment,t),m(N.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(O.$$.fragment,t),m(et.$$.fragment,t),m(lt.$$.fragment,t),m(at.$$.fragment,t),m(it.$$.fragment,t),m(ut.$$.fragment,t),m(ct.$$.fragment,t),m(ft.$$.fragment,t),m(yt.$$.fragment,t),m(Tt.$$.fragment,t),m(gt.$$.fragment,t),m(wt.$$.fragment,t),m(jt.$$.fragment,t),m(It.$$.fragment,t),m(Zt.$$.fragment,t),m(Vt.$$.fragment,t),m(Lt.$$.fragment,t),m(zt.$$.fragment,t),m(St.$$.fragment,t),m(Pt.$$.fragment,t),m(te.$$.fragment,t),m(se.$$.fragment,t),m(ae.$$.fragment,t),m(oe.$$.fragment,t),m(pe.$$.fragment,t),m(ue.$$.fragment,t),m(me.$$.fragment,t),m(Me.$$.fragment,t),m(fe.$$.fragment,t),m(he.$$.fragment,t),m(Te.$$.fragment,t),m(Ue.$$.fragment,t),m(je.$$.fragment,t),m(Ce.$$.fragment,t),m(ve.$$.fragment,t),m(xe.$$.fragment,t),sa=!0)},o(t){c(b.$$.fragment,t),c(I.$$.fragment,t),c($.$$.fragment,t),c(_.$$.fragment,t),c(B.$$.fragment,t),c(F.$$.fragment,t),c(k.$$.fragment,t),c(V.$$.fragment,t),c(H.$$.fragment,t),c(R.$$.fragment,t),c(S.$$.fragment,t),c(N.$$.fragment,t),c(D.$$.fragment,t),c(K.$$.fragment,t),c(O.$$.fragment,t),c(et.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(it.$$.fragment,t),c(ut.$$.fragment,t),c(ct.$$.fragment,t),c(ft.$$.fragment,t),c(yt.$$.fragment,t),c(Tt.$$.fragment,t),c(gt.$$.fragment,t),c(wt.$$.fragment,t),c(jt.$$.fragment,t),c(It.$$.fragment,t),c(Zt.$$.fragment,t),c(Vt.$$.fragment,t),c(Lt.$$.fragment,t),c(zt.$$.fragment,t),c(St.$$.fragment,t),c(Pt.$$.fragment,t),c(te.$$.fragment,t),c(se.$$.fragment,t),c(ae.$$.fragment,t),c(oe.$$.fragment,t),c(pe.$$.fragment,t),c(ue.$$.fragment,t),c(me.$$.fragment,t),c(Me.$$.fragment,t),c(fe.$$.fragment,t),c(he.$$.fragment,t),c(Te.$$.fragment,t),c(Ue.$$.fragment,t),c(je.$$.fragment,t),c(Ce.$$.fragment,t),c(ve.$$.fragment,t),c(xe.$$.fragment,t),sa=!1},d(t){t&&(s(Ee),s(Ye),s(Ne),s(Ae),s(De),s(j),s(Pe),s(C),s(Ke),s(Oe),s(v),s(ts),s(Z),s(es),s(ss),s(x),s(ls),s(G),s(as),s(ns),s(X),s(is),s(os),s(W),s(rs),s(ps),s(q),s(ds),s(us),s(ms),s(L),s(cs),s(Ms),s(z),s(fs),s(Q),s(hs),s(Y),s(ys),s(Ts),s(E),s(gs),s(Js),s(y),s(ws),s(Us),s(tt),s(js),s(bs),s(st),s(Is),s(Cs),s($s),s(nt),s(vs),s(Zs),s(ot),s(_s),s(rt),s(xs),s(pt),s(Gs),s(dt),s(Bs),s(Xs),s(mt),s(Fs),s(Ws),s(Mt),s(ks),s(qs),s(ht),s(Vs),s(Hs),s(Ls),s(Rs),s(Jt),s(zs),s(Qs),s(Ut),s(Ys),s(Ss),s(bt),s(Es),s(Ns),s(Ct),s(As),s($t),s(Ds),s(vt),s(Ps),s(Ks),s(_t),s(Os),s(xt),s(tl),s(Gt),s(el),s(Bt),s(sl),s(Xt),s(ll),s(Ft),s(al),s(Wt),s(nl),s(kt),s(il),s(qt),s(ol),s(rl),s(Ht),s(pl),s(dl),s(Rt),s(ul),s(ml),s(Qt),s(cl),s(Yt),s(Ml),s(fl),s(Et),s(hl),s(Nt),s(yl),s(At),s(Tl),s(g),s(gl),s(Kt),s(Jl),s(Ot),s(wl),s(Ul),s(ee),s(jl),s(bl),s(le),s(Il),s(Cl),s(ne),s($l),s(ie),s(vl),s(Zl),s(re),s(_l),s(xl),s(de),s(Gl),s(Bl),s(Xl),s(ce),s(Fl),s(Wl),s(kl),s(ql),s(ye),s(Vl),s(Hl),s(ge),s(Ll),s(Je),s(Rl),s(we),s(zl),s(Ql),s(Yl),s(Sl),s(El),s(be),s(Nl),s(Ie),s(Al),s(Dl),s($e),s(Pl),s(Kl),s(Ze),s(Ol),s(_e),s(ta),s(ea),s(Se)),s(U),M(b,t),M(I,t),M($,t),M(_,t),M(B,t),M(F,t),M(k,t),M(V,t),M(H,t),M(R,t),M(S,t),M(N,t),M(D),M(K),M(O,t),M(et,t),M(lt,t),M(at,t),M(it,t),M(ut,t),M(ct,t),M(ft,t),M(yt,t),M(Tt,t),M(gt,t),M(wt,t),M(jt,t),M(It,t),M(Zt,t),M(Vt,t),M(Lt,t),M(zt,t),M(St,t),M(Pt),M(te,t),M(se,t),M(ae,t),M(oe,t),M(pe,t),M(ue,t),M(me,t),M(Me,t),M(fe,t),M(he,t),M(Te,t),M(Ue,t),M(je,t),M(Ce,t),M(ve,t),M(xe,t)}}}const On='{"title":"Hugging Face Dataset Upload Decision Guide","local":"hugging-face-dataset-upload-decision-guide","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Working Without File Access","local":"working-without-file-access","sections":[],"depth":2},{"title":"Critical Constraints","local":"critical-constraints","sections":[],"depth":2},{"title":"Quick Reference by Data Type","local":"quick-reference-by-data-type","sections":[],"depth":2},{"title":"Upload Workflow","local":"upload-workflow","sections":[],"depth":2},{"title":"Common Conversion Patterns","local":"common-conversion-patterns","sections":[{"title":"From DataFrames","local":"from-dataframes","sections":[],"depth":3}],"depth":2},{"title":"Custom Format Conversion","local":"custom-format-conversion","sections":[{"title":"Design Principles","local":"design-principles","sections":[],"depth":3},{"title":"Conversion Methods","local":"conversion-methods","sections":[],"depth":3},{"title":"Using Configs for Dataset Variations","local":"using-configs-for-dataset-variations","sections":[],"depth":3},{"title":"Multi-modal Examples","local":"multi-modal-examples","sections":[],"depth":3}],"depth":2},{"title":"Essential Features","local":"essential-features","sections":[{"title":"Feature Types Overview","local":"feature-types-overview","sections":[],"depth":3}],"depth":2},{"title":"Upload Methods","local":"upload-methods","sections":[],"depth":2},{"title":"Validation","local":"validation","sections":[],"depth":2},{"title":"Common Issues → Solutions","local":"common-issues--solutions","sections":[],"depth":2},{"title":"Dataset Viewer Configuration","local":"dataset-viewer-configuration","sections":[{"title":"When automatic detection works","local":"when-automatic-detection-works","sections":[],"depth":3},{"title":"Manual configuration","local":"manual-configuration","sections":[],"depth":3},{"title":"Common viewer issues","local":"common-viewer-issues","sections":[],"depth":3}],"depth":2},{"title":"Quick Templates","local":"quick-templates","sections":[],"depth":2},{"title":"Documentation","local":"documentation","sections":[],"depth":2},{"title":"Dataset Cards","local":"dataset-cards","sections":[],"depth":2},{"title":"Appendix: Special Cases","local":"appendix-special-cases","sections":[{"title":"WebDataset Structure","local":"webdataset-structure","sections":[],"depth":3},{"title":"Scientific Data","local":"scientific-data","sections":[],"depth":3},{"title":"Community Resources","local":"community-resources","sections":[],"depth":3}],"depth":2}],"depth":1}';function ti(Ja){return Sn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ii extends En{constructor(U){super(),Nn(this,U,ti,Kn,Qn,{})}}export{ii as component};
