# Academia Hub

> [!TIP]
> Ask your university's IT or Procurement Team to <a href="https://huggingface.co/contact/sales?from=academia" target="_blank">get in touch</a> from a university-affiliated email address to initiate the subscription process.

Academia Hub is a program designed to provide students, researchers and faculty members the tools, community and infrastructure to support their projects in artificial intelligence, at scale.

With Academia Hub, your institution joins a dedicated program built for higher education and labs: offering the Hub’s advanced features, streamlined administration, and academic-friendly pricing.


<a href="https://huggingface.co/contact/sales?from=academia" class="flex justify-center">
    <img class="block" src="https://huggingface.co/datasets/Chunte/documentation-images/resolve/main/AcademiaHub.png" />
</a>

#### Key features of Academia Hub

***Accessible pricing & credits***
- $10 per seat/month under an annual university contract
- Each seat includes $2/month in compute credits for Inference Providers (with the option to add more)

***Advanced compute & hosting***
- ZeroGPU: 5× usage quota and highest GPU queue priority
- Spaces Hosting: create ZeroGPU Spaces with H200 hardware
- Spaces Dev Mode: fast iterations via SSH/VS Code

***Storage & data management***
- Increased public storage capacity for datasets and models.
- 1TB of private repository storage per seat in the subscription (i.e with 400 seats, your institution would have 400TB of included private storage)
- Dataset Viewer: enable visualization even on private datasets

***Administration & security***
- Centralized administration: seat assignment, revocation, and management at scale
- Seamless onboarding with academic email domains for secure and quick sign-up

***Collaboration & publishing***
- Larger collaboration capacity with higher quotas, priority queues, and governance tools
- Community blog & social posts: publish research outputs, updates, and stories directly to the Hugging Face community

***Community & resources***
- Connect with peers and mentors across institutions
- Access datasets, models, and projects tailored for academia


#### How to get started

1. Check your eligibility (see below)
2. Ask your university’s IT or Procurement Team to <a href="https://huggingface.co/contact/sales?from=academia" target="_blank">get in touch</a> to initiate the subscription process to the Academia Hub today. 
Academia Hub can not be initiated by students themselves. 
3. When Academia Hub is enabled, any affiliated user will need to add their `@your-university-name.edu` email address (or other university domain) to their HF account.

#### Eligibility

**Who is Academia Hub for?**
- **Students:** Unlock powerful features to learn about AI and Machine learning in the most efficient way.
- **Researchers:** Collaborate with peers using the standard AI ecosystem of tools.
- **Faculty members:** Enhance your classes' projects with PRO capabilities.

**Requirements**
- Must possess a valid university or college email address.
- Open to all students regardless of discipline or level of study.
- Pricing: Academia Hub is priced based on volume of usage and number of active users at your institution.




<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/academia-hub.md" />