# Team & Enterprise plans

> [!TIP]
> <a href="https://huggingface.co/enterprise" target="_blank">Subscribe to a Team or Enterprise plan</a> to get access to advanced features for your organization.

Team & Enterprise organization plans add advanced capabilities to organizations, enabling safe, compliant and managed collaboration for companies and teams on Hugging Face.

<a href="https://huggingface.co/enterprise" class="flex justify-center">
    <img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/enterprise/enterprise-header.png" />
    <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/enterprise/dark-enterprise-header.png" />
</a>

In this section we will document the following Enterprise Hub features:

- [Single Sign-On (SSO)](./enterprise-sso)
- [Advanced Single Sign-On (SSO)](./enterprise-hub-advanced-sso)
- [User Provisioning (SCIM)](./enterprise-hub-scim)
- [Audit Logs](./audit-logs)
- [Storage Regions](./storage-regions)
- [Data Studio for Private datasets](./enterprise-hub-datasets)
- [Resource Groups](./security-resource-groups)
- [Advanced Compute Options](./advanced-compute-options)
- [Advanced Security](./enterprise-hub-advanced-security)
- [Tokens Management](./enterprise-hub-tokens-management)
- [Publisher Analytics](./enterprise-hub-analytics)
- [Gating Group Collections](./enterprise-hub-gating-group-collections)
- [Network Security](./enterprise-hub-network-security)
- [Higher Rate limits](./rate-limits)

Finally, Team & Enterprise plans include vastly more [included public storage](./storage-limits), as well as 1TB of [private storage](./storage-limits) per seat in the subscription, i.e. if your organization has 40 members, then you have 40TB included storage for your private models and datasets.


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/enterprise-hub.md" />