import{s as Ms,n as ys,o as ws}from"../chunks/scheduler.f98c8ba5.js";import{S as Ts,i as Js,e as p,s as l,c as m,h as Us,a as i,d as e,b as n,f as js,g as c,j as d,k as v,l as Zs,m as a,n as r,t as h,o as u,p as g}from"../chunks/index.bbd0dad2.js";import{C as _s,H as is,E as $s}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.171ddfe5.js";import{C as F}from"../chunks/CodeBlock.de5625fe.js";function Gs(os){let b,V,X,H,f,Y,j,N,o,ms='<img alt="Open In Colab" class="!m-0" src="https://colab.research.google.com/assets/colab-badge.svg"/>',x,M,cs='<code>Safetensors</code> is really fast. Let’s compare it against <code>PyTorch</code> by loading <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a> weights. To run the <a href="#gpu-benchmark">GPU benchmark</a>, make sure your machine has GPU or you have selected <code>GPU runtime</code> if you are using Google Colab.',q,y,rs="Before you begin, make sure you have all the necessary libraries installed:",S,w,E,T,hs="Let’s start by importing all the packages that will be used:",L,J,P,U,us="Download safetensors & torch weights for gpt2:",z,Z,A,_,K,$,D,G,gs=`This speedup is due to the fact that this library avoids unnecessary copies by mapping the file directly. It is actually possible to do on <a href="https://gist.github.com/Narsil/3edeec2669a5e94e4707aa0f901d2282" rel="nofollow">pure pytorch</a>.
The currently shown speedup was gotten on:`,O,W,bs="<li>OS: Ubuntu 18.04.6 LTS</li> <li>CPU: Intel(R) Xeon(R) CPU @ 2.00GHz</li>",ss,B,ts,I,es,k,ds=`The speedup works because this library is able to skip unnecessary CPU allocations. It is unfortunately not replicable in pure pytorch as far as we know. The library works by memory mapping the file, creating the tensor empty with pytorch and calling <code>cudaMemcpy</code> directly to move the tensor directly on the GPU.
The currently shown speedup was gotten on:`,as,R,fs="<li>OS: Ubuntu 18.04.6 LTS.</li> <li>GPU: Tesla T4</li> <li>Driver Version: 460.32.03</li> <li>CUDA Version: 11.2</li>",ls,C,ns,Q,ps;return f=new _s({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new is({props:{title:"Speed Comparison",local:"speed-comparison",headingTag:"h1"}}),w=new F({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZmV0ZW5zb3JzJTIwaHVnZ2luZ2ZhY2VfaHViJTIwdG9yY2g=",highlighted:"pip install safetensors huggingface_hub torch",wrap:!1}}),J=new F({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBkYXRldGltZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEFmcm9tJTIwc2FmZXRlbnNvcnMudG9yY2glMjBpbXBvcnQlMjBsb2FkX2ZpbGUlMEFpbXBvcnQlMjB0b3JjaA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> datetime
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_file
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch`,wrap:!1}}),Z=new F({props:{code:"c2ZfZmlsZW5hbWUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTIyZ3B0MiUyMiUyQyUyMGZpbGVuYW1lJTNEJTIybW9kZWwuc2FmZXRlbnNvcnMlMjIpJTBBcHRfZmlsZW5hbWUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTIyZ3B0MiUyMiUyQyUyMGZpbGVuYW1lJTNEJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sf_filename = hf_hub_download(<span class="hljs-string">&quot;gpt2&quot;</span>, filename=<span class="hljs-string">&quot;model.safetensors&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pt_filename = hf_hub_download(<span class="hljs-string">&quot;gpt2&quot;</span>, filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),_=new is({props:{title:"CPU benchmark",local:"cpu-benchmark",headingTag:"h3"}}),$=new F({props:{code:"c3RhcnRfc3QlMjAlM0QlMjBkYXRldGltZS5kYXRldGltZS5ub3coKSUwQXdlaWdodHMlMjAlM0QlMjBsb2FkX2ZpbGUoc2ZfZmlsZW5hbWUlMkMlMjBkZXZpY2UlM0QlMjJjcHUlMjIpJTBBbG9hZF90aW1lX3N0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMjAtJTIwc3RhcnRfc3QlMEFwcmludChmJTIyTG9hZGVkJTIwc2FmZXRlbnNvcnMlMjAlN0Jsb2FkX3RpbWVfc3QlN0QlMjIpJTBBJTBBc3RhcnRfcHQlMjAlM0QlMjBkYXRldGltZS5kYXRldGltZS5ub3coKSUwQXdlaWdodHMlMjAlM0QlMjB0b3JjaC5sb2FkKHB0X2ZpbGVuYW1lJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQWxvYWRfdGltZV9wdCUyMCUzRCUyMGRhdGV0aW1lLmRhdGV0aW1lLm5vdygpJTIwLSUyMHN0YXJ0X3B0JTBBcHJpbnQoZiUyMkxvYWRlZCUyMHB5dG9yY2glMjAlN0Jsb2FkX3RpbWVfcHQlN0QlMjIpJTBBJTBBcHJpbnQoZiUyMm9uJTIwQ1BVJTJDJTIwc2FmZXRlbnNvcnMlMjBpcyUyMGZhc3RlciUyMHRoYW4lMjBweXRvcmNoJTIwYnklM0ElMjAlN0Jsb2FkX3RpbWVfcHQlMkZsb2FkX3RpbWVfc3QlM0EuMWYlN0QlMjBYJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start_st = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = load_file(sf_filename, device=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_st = datetime.datetime.now() - start_st
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded safetensors <span class="hljs-subst">{load_time_st}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>start_pt = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = torch.load(pt_filename, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_pt = datetime.datetime.now() - start_pt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded pytorch <span class="hljs-subst">{load_time_pt}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;on CPU, safetensors is faster than pytorch by: <span class="hljs-subst">{load_time_pt/load_time_st:<span class="hljs-number">.1</span>f}</span> X&quot;</span>)
Loaded safetensors <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.004015</span>
Loaded pytorch <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.307460</span>
on CPU, safetensors <span class="hljs-keyword">is</span> faster than pytorch by: <span class="hljs-number">76.6</span> X`,wrap:!1}}),B=new is({props:{title:"GPU benchmark",local:"gpu-benchmark",headingTag:"h3"}}),I=new F({props:{code:"JTIzJTIwVGhpcyUyMGlzJTIwcmVxdWlyZWQlMjBiZWNhdXNlJTIwdGhpcyUyMGZlYXR1cmUlMjBoYXNuJ3QlMjBiZWVuJTIwZnVsbHklMjB2ZXJpZmllZCUyMHlldCUyQyUyMGJ1dCUyMCUwQSUyMyUyMGl0J3MlMjBiZWVuJTIwdGVzdGVkJTIwb24lMjBtYW55JTIwZGlmZmVyZW50JTIwZW52aXJvbm1lbnRzJTBBb3MuZW52aXJvbiU1QiUyMlNBRkVURU5TT1JTX0ZBU1RfR1BVJTIyJTVEJTIwJTNEJTIwJTIyMSUyMiUwQSUwQSUyMyUyMENVREElMjBzdGFydHVwJTIwb3V0JTIwb2YlMjB0aGUlMjBtZWFzdXJlbWVudCUwQXRvcmNoLnplcm9zKCgyJTJDJTIwMikpLmN1ZGEoKSUwQSUwQXN0YXJ0X3N0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMEF3ZWlnaHRzJTIwJTNEJTIwbG9hZF9maWxlKHNmX2ZpbGVuYW1lJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUzQTAlMjIpJTBBbG9hZF90aW1lX3N0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMjAtJTIwc3RhcnRfc3QlMEFwcmludChmJTIyTG9hZGVkJTIwc2FmZXRlbnNvcnMlMjAlN0Jsb2FkX3RpbWVfc3QlN0QlMjIpJTBBJTBBc3RhcnRfcHQlMjAlM0QlMjBkYXRldGltZS5kYXRldGltZS5ub3coKSUwQXdlaWdodHMlMjAlM0QlMjB0b3JjaC5sb2FkKHB0X2ZpbGVuYW1lJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3VkYSUzQTAlMjIpJTBBbG9hZF90aW1lX3B0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMjAtJTIwc3RhcnRfcHQlMEFwcmludChmJTIyTG9hZGVkJTIwcHl0b3JjaCUyMCU3QmxvYWRfdGltZV9wdCU3RCUyMiklMEElMEFwcmludChmJTIyb24lMjBHUFUlMkMlMjBzYWZldGVuc29ycyUyMGlzJTIwZmFzdGVyJTIwdGhhbiUyMHB5dG9yY2glMjBieSUzQSUyMCU3QmxvYWRfdGltZV9wdCUyRmxvYWRfdGltZV9zdCUzQS4xZiU3RCUyMFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is required because this feature hasn&#x27;t been fully verified yet, but </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it&#x27;s been tested on many different environments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;SAFETENSORS_FAST_GPU&quot;</span>] = <span class="hljs-string">&quot;1&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CUDA startup out of the measurement</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>torch.zeros((<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)).cuda()

<span class="hljs-meta">&gt;&gt;&gt; </span>start_st = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = load_file(sf_filename, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_st = datetime.datetime.now() - start_st
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded safetensors <span class="hljs-subst">{load_time_st}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>start_pt = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = torch.load(pt_filename, map_location=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_pt = datetime.datetime.now() - start_pt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded pytorch <span class="hljs-subst">{load_time_pt}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;on GPU, safetensors is faster than pytorch by: <span class="hljs-subst">{load_time_pt/load_time_st:<span class="hljs-number">.1</span>f}</span> X&quot;</span>)
Loaded safetensors <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.165206</span>
Loaded pytorch <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.353889</span>
on GPU, safetensors <span class="hljs-keyword">is</span> faster than pytorch by: <span class="hljs-number">2.1</span> X`,wrap:!1}}),C=new $s({props:{source:"https://github.com/huggingface/safetensors/blob/main/docs/source/speed.mdx"}}),{c(){b=p("meta"),V=l(),X=p("p"),H=l(),m(f.$$.fragment),Y=l(),m(j.$$.fragment),N=l(),o=p("a"),o.innerHTML=ms,x=l(),M=p("p"),M.innerHTML=cs,q=l(),y=p("p"),y.textContent=rs,S=l(),m(w.$$.fragment),E=l(),T=p("p"),T.textContent=hs,L=l(),m(J.$$.fragment),P=l(),U=p("p"),U.textContent=us,z=l(),m(Z.$$.fragment),A=l(),m(_.$$.fragment),K=l(),m($.$$.fragment),D=l(),G=p("p"),G.innerHTML=gs,O=l(),W=p("ul"),W.innerHTML=bs,ss=l(),m(B.$$.fragment),ts=l(),m(I.$$.fragment),es=l(),k=p("p"),k.innerHTML=ds,as=l(),R=p("ul"),R.innerHTML=fs,ls=l(),m(C.$$.fragment),ns=l(),Q=p("p"),this.h()},l(s){const t=Us("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(e),V=n(s),X=i(s,"P",{}),js(X).forEach(e),H=n(s),c(f.$$.fragment,s),Y=n(s),c(j.$$.fragment,s),N=n(s),o=i(s,"A",{href:!0,target:!0,class:!0,"data-svelte-h":!0}),d(o)!=="svelte-lfr1jd"&&(o.innerHTML=ms),x=n(s),M=i(s,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1f2qiql"&&(M.innerHTML=cs),q=n(s),y=i(s,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1c9nexd"&&(y.textContent=rs),S=n(s),c(w.$$.fragment,s),E=n(s),T=i(s,"P",{"data-svelte-h":!0}),d(T)!=="svelte-x2g6fp"&&(T.textContent=hs),L=n(s),c(J.$$.fragment,s),P=n(s),U=i(s,"P",{"data-svelte-h":!0}),d(U)!=="svelte-ppqluq"&&(U.textContent=us),z=n(s),c(Z.$$.fragment,s),A=n(s),c(_.$$.fragment,s),K=n(s),c($.$$.fragment,s),D=n(s),G=i(s,"P",{"data-svelte-h":!0}),d(G)!=="svelte-12qeleu"&&(G.innerHTML=gs),O=n(s),W=i(s,"UL",{"data-svelte-h":!0}),d(W)!=="svelte-1truf0w"&&(W.innerHTML=bs),ss=n(s),c(B.$$.fragment,s),ts=n(s),c(I.$$.fragment,s),es=n(s),k=i(s,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1c8g3ot"&&(k.innerHTML=ds),as=n(s),R=i(s,"UL",{"data-svelte-h":!0}),d(R)!=="svelte-1emnou5"&&(R.innerHTML=fs),ls=n(s),c(C.$$.fragment,s),ns=n(s),Q=i(s,"P",{}),js(Q).forEach(e),this.h()},h(){v(b,"name","hf:doc:metadata"),v(b,"content",Ws),v(o,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/safetensors_doc/en/speed.ipynb"),v(o,"target","_blank"),v(o,"class","absolute z-10 right-0 top-0")},m(s,t){Zs(document.head,b),a(s,V,t),a(s,X,t),a(s,H,t),r(f,s,t),a(s,Y,t),r(j,s,t),a(s,N,t),a(s,o,t),a(s,x,t),a(s,M,t),a(s,q,t),a(s,y,t),a(s,S,t),r(w,s,t),a(s,E,t),a(s,T,t),a(s,L,t),r(J,s,t),a(s,P,t),a(s,U,t),a(s,z,t),r(Z,s,t),a(s,A,t),r(_,s,t),a(s,K,t),r($,s,t),a(s,D,t),a(s,G,t),a(s,O,t),a(s,W,t),a(s,ss,t),r(B,s,t),a(s,ts,t),r(I,s,t),a(s,es,t),a(s,k,t),a(s,as,t),a(s,R,t),a(s,ls,t),r(C,s,t),a(s,ns,t),a(s,Q,t),ps=!0},p:ys,i(s){ps||(h(f.$$.fragment,s),h(j.$$.fragment,s),h(w.$$.fragment,s),h(J.$$.fragment,s),h(Z.$$.fragment,s),h(_.$$.fragment,s),h($.$$.fragment,s),h(B.$$.fragment,s),h(I.$$.fragment,s),h(C.$$.fragment,s),ps=!0)},o(s){u(f.$$.fragment,s),u(j.$$.fragment,s),u(w.$$.fragment,s),u(J.$$.fragment,s),u(Z.$$.fragment,s),u(_.$$.fragment,s),u($.$$.fragment,s),u(B.$$.fragment,s),u(I.$$.fragment,s),u(C.$$.fragment,s),ps=!1},d(s){s&&(e(V),e(X),e(H),e(Y),e(N),e(o),e(x),e(M),e(q),e(y),e(S),e(E),e(T),e(L),e(P),e(U),e(z),e(A),e(K),e(D),e(G),e(O),e(W),e(ss),e(ts),e(es),e(k),e(as),e(R),e(ls),e(ns),e(Q)),e(b),g(f,s),g(j,s),g(w,s),g(J,s),g(Z,s),g(_,s),g($,s),g(B,s),g(I,s),g(C,s)}}}const Ws='{"title":"Speed Comparison","local":"speed-comparison","sections":[{"title":"CPU benchmark","local":"cpu-benchmark","sections":[],"depth":3},{"title":"GPU benchmark","local":"gpu-benchmark","sections":[],"depth":3}],"depth":1}';function Bs(os){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends Ts{constructor(b){super(),Js(this,b,Bs,Gs,Ms,{})}}export{Xs as component};
