import{s as Be,n as Le,o as He}from"../chunks/scheduler.f98c8ba5.js";import{S as Ee,i as Qe,e as o,s as n,c as d,h as Re,a as i,d as s,b as a,f as X,g as m,j as r,k as ze,l as h,m as l,n as p,t as c,o as f,p as M}from"../chunks/index.bbd0dad2.js";import{C as Ne,H as q,E as Ae}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.171ddfe5.js";import{C as we}from"../chunks/CodeBlock.de5625fe.js";function Ve(je){let w,F,V,K,b,P,U,D,T,O,g,ve=`Using specific functions, which should work in most cases for you.
This is not without side effects.`,ee,j,te,v,se,J,Je=`Pytorch uses shared tensors for some computation.
This is extremely interesting to reduce memory usage in general.`,le,$,$e=`One very classic use case is in transformers the <code>embeddings</code> are shared with
<code>lm_head</code>. By using the same matrix, the model uses less parameters, and gradients
flow much better to the <code>embeddings</code> (which is the start of the model, so they don’t
flow easily there, whereas <code>lm_head</code> is at the tail of the model, so gradients are
extremely good over there, since they are the same tensors, they both benefit)`,ne,C,ae,k,oe,I,Ce="Multiple reasons for that:",ie,y,H,ke=`<p><em>Not all frameworks support them</em> for instance <code>tensorflow</code> does not.
So if someone saves shared tensors in torch, there is no way to
load them in a similar fashion so we could not keep the same <code>Dict[str, Tensor]</code>
API.</p>`,ue,u,E,Ie=`<em>It makes lazy loading very quickly.</em>
Lazy loading is the ability to load only some tensors, or part of tensors for
a given file. This is trivial to do without sharing tensors but with tensor sharing`,be,Z,Ue,Q,Ze=`Now it’s impossible with this given code to “reshare” buffers after the fact.
Once we give the <code>a</code> tensor we have no way to give back the same memory when
you ask for <code>b</code>. (In this particular example we could keep track of given buffers
but this is not the case in general, since you could do arbitrary work with <code>a</code>
like sending it to another device before asking for <code>b</code>)`,Te,_,R,_e=`<em>It can lead to much larger file than necessary</em>.
If you are saving a shared tensor which is only a fraction of a larger tensor,
then saving it with pytorch leads to saving the entire buffer instead of saving
just what is needed.`,ge,x,re,G,xe=`Now with all those reasons being mentioned, nothing is set in stone in there.
Shared tensors do not cause unsafety, or denial of service potential, so this
decision could be revisited if current workarounds are not satisfactory.`,he,W,de,S,Ge=`The design is rather simple.
We’re going to look for all shared tensors, then looking for all tensors
covering the entire buffer (there can be multiple such tensors).
That gives us multiple names which can be saved, we simply choose the first one`,me,z,We=`During <code>load_model</code>, we are loading a bit like <code>load_state_dict</code> does, except
we’re looking into the model itself, to check for shared buffers, and ignoring
the “missed keys” which were actually covered by virtue of buffer sharing (they
were properly loaded since there was a buffer that loaded under the hood).
Every other error is raised as-is`,pe,B,Se=`<strong>Caveat</strong>: This means we’re dropping some keys within the file. meaning if you’re
checking for the keys saved on disk, you will see some “missing tensors” or if you’re
using <code>load_state_dict</code>. Unless we start supporting shared tensors directly in
the format there’s no real way around it.`,ce,L,fe,Y,Me;return b=new Ne({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new q({props:{title:"Torch shared tensors",local:"torch-shared-tensors",headingTag:"h1"}}),T=new q({props:{title:"TL;DR",local:"tldr",headingTag:"h2"}}),j=new we({props:{code:"ZnJvbSUyMHNhZmV0ZW5zb3JzLnRvcmNoJTIwaW1wb3J0JTIwbG9hZF9tb2RlbCUyQyUyMHNhdmVfbW9kZWwlMEElMEFzYXZlX21vZGVsKG1vZGVsJTJDJTIwJTIybW9kZWwuc2FmZXRlbnNvcnMlMjIpJTBBJTIzJTIwSW5zdGVhZCUyMG9mJTIwc2F2ZV9maWxlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMm1vZGVsLnNhZmV0ZW5zb3JzJTIyKSUwQSUwQWxvYWRfbW9kZWwobW9kZWwlMkMlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMjMlMjBJbnN0ZWFkJTIwb2YlMjBtb2RlbC5sb2FkX3N0YXRlX2RpY3QobG9hZF9maWxlKCUyMm1vZGVsLnNhZmV0ZW5zb3JzJTIyKSk=",highlighted:`<span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_model, save_model

save_model(model, <span class="hljs-string">&quot;model.safetensors&quot;</span>)
<span class="hljs-comment"># Instead of save_file(model.state_dict(), &quot;model.safetensors&quot;)</span>

load_model(model, <span class="hljs-string">&quot;model.safetensors&quot;</span>)
<span class="hljs-comment"># Instead of model.load_state_dict(load_file(&quot;model.safetensors&quot;))</span>`,wrap:!1}}),v=new q({props:{title:"What are shared tensors ?",local:"what-are-shared-tensors-",headingTag:"h2"}}),C=new we({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEFjbGFzcyUyME1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYSUyMCUzRCUyMG5uLkxpbmVhcigxMDAlMkMlMjAxMDApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iJTIwJTNEJTIwc2VsZi5hJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmIoc2VsZi5hKHgpKSUwQSUwQSUwQW1vZGVsJTIwJTNEJTIwTW9kZWwoKSUwQXByaW50KG1vZGVsLnN0YXRlX2RpY3QoKSklMEElMjMlMjBvZGljdF9rZXlzKCU1QidhLndlaWdodCclMkMlMjAnYS5iaWFzJyUyQyUyMCdiLndlaWdodCclMkMlMjAnYi5iaWFzJyU1RCklMEF0b3JjaC5zYXZlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMm1vZGVsLmJpbiUyMiklMEElMjMlMjBUaGlzJTIwZmlsZSUyMGlzJTIwbm93JTIwNDFrJTIwaW5zdGVhZCUyMG9mJTIwfjgwayUyQyUyMGJlY2F1c2UlMjBBJTIwYW5kJTIwQiUyMGFyZSUyMHRoZSUyMHNhbWUlMjB3ZWlnaHQlMjBoZW5jZSUyMG9ubHklMjAxJTIwaXMlMjBzYXZlZCUyMG9uJTIwZGlzayUyMHdpdGglMjBib3RoJTIwJTYwYSU2MCUyMGFuZCUyMCU2MGIlNjAlMjBwb2ludGluZyUyMHRvJTIwdGhlJTIwc2FtZSUyMGJ1ZmZlcg==",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Model</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.a = nn.Linear(<span class="hljs-number">100</span>, <span class="hljs-number">100</span>)
        self.b = self.a

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> self.b(self.a(x))


model = Model()
<span class="hljs-built_in">print</span>(model.state_dict())
<span class="hljs-comment"># odict_keys([&#x27;a.weight&#x27;, &#x27;a.bias&#x27;, &#x27;b.weight&#x27;, &#x27;b.bias&#x27;])</span>
torch.save(model.state_dict(), <span class="hljs-string">&quot;model.bin&quot;</span>)
<span class="hljs-comment"># This file is now 41k instead of ~80k, because A and B are the same weight hence only 1 is saved on disk with both \`a\` and \`b\` pointing to the same buffer</span>`,wrap:!1}}),k=new q({props:{title:"Why are shared tensors not saved in safetensors ?",local:"why-are-shared-tensors-not-saved-in-safetensors-",headingTag:"h2"}}),Z=new we({props:{code:"d2l0aCUyMHNhZmVfb3BlbiglMjJtb2RlbC5zYWZldGVuc29ycyUyMiUyQyUyMGZyYW1ld29yayUzRCUyMnB0JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGElMjAlM0QlMjBmLmdldF90ZW5zb3IoJTIyYSUyMiklMEElMjAlMjAlMjAlMjBiJTIwJTNEJTIwZi5nZXRfdGVuc29yKCUyMmIlMjIp",highlighted:`<span class="hljs-keyword">with</span> safe_open(<span class="hljs-string">&quot;model.safetensors&quot;</span>, framework=<span class="hljs-string">&quot;pt&quot;</span>) <span class="hljs-keyword">as</span> f:
    a = f.get_tensor(<span class="hljs-string">&quot;a&quot;</span>)
    b = f.get_tensor(<span class="hljs-string">&quot;b&quot;</span>)`,wrap:!1}}),x=new we({props:{code:"YSUyMCUzRCUyMHRvcmNoLnplcm9zKCgxMDAlMkMlMjAxMDApKSUwQWIlMjAlM0QlMjBhJTVCJTNBMSUyQyUyMCUzQSU1RCUwQXRvcmNoLnNhdmUoJTdCJTIyYiUyMiUzQSUyMGIlN0QlMkMlMjAlMjJtb2RlbC5iaW4lMjIpJTBBJTIzJTIwRmlsZSUyMGlzJTIwNDFrJTIwaW5zdGVhZCUyMG9mJTIwdGhlJTIwZXhwZWN0ZWQlMjA0MDAlMjBieXRlcyUwQSUyMyUyMEluJTIwcHJhY3RpY2UlMjBpdCUyMGNvdWxkJTIwaGFwcGVuJTIwdGhhdCUyMHlvdSUyMHNhdmUlMjBzZXZlcmFsJTIwMTBHQiUyMGluc3RlYWQlMjBvZiUyMDFHQi4=",highlighted:`a = torch.zeros((<span class="hljs-number">100</span>, <span class="hljs-number">100</span>))
b = a[:<span class="hljs-number">1</span>, :]
torch.save({<span class="hljs-string">&quot;b&quot;</span>: b}, <span class="hljs-string">&quot;model.bin&quot;</span>)
<span class="hljs-comment"># File is 41k instead of the expected 400 bytes</span>
<span class="hljs-comment"># In practice it could happen that you save several 10GB instead of 1GB.</span>`,wrap:!1}}),W=new q({props:{title:"How does it work ?",local:"how-does-it-work-",headingTag:"h2"}}),L=new Ae({props:{source:"https://github.com/huggingface/safetensors/blob/main/docs/source/torch_shared_tensors.mdx"}}),{c(){w=o("meta"),F=n(),V=o("p"),K=n(),d(b.$$.fragment),P=n(),d(U.$$.fragment),D=n(),d(T.$$.fragment),O=n(),g=o("p"),g.textContent=ve,ee=n(),d(j.$$.fragment),te=n(),d(v.$$.fragment),se=n(),J=o("p"),J.textContent=Je,le=n(),$=o("p"),$.innerHTML=$e,ne=n(),d(C.$$.fragment),ae=n(),d(k.$$.fragment),oe=n(),I=o("p"),I.textContent=Ce,ie=n(),y=o("ul"),H=o("li"),H.innerHTML=ke,ue=n(),u=o("li"),E=o("p"),E.innerHTML=Ie,be=n(),d(Z.$$.fragment),Ue=n(),Q=o("p"),Q.innerHTML=Ze,Te=n(),_=o("li"),R=o("p"),R.innerHTML=_e,ge=n(),d(x.$$.fragment),re=n(),G=o("p"),G.textContent=xe,he=n(),d(W.$$.fragment),de=n(),S=o("p"),S.textContent=Ge,me=n(),z=o("p"),z.innerHTML=We,pe=n(),B=o("p"),B.innerHTML=Se,ce=n(),d(L.$$.fragment),fe=n(),Y=o("p"),this.h()},l(e){const t=Re("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(s),F=a(e),V=i(e,"P",{}),X(V).forEach(s),K=a(e),m(b.$$.fragment,e),P=a(e),m(U.$$.fragment,e),D=a(e),m(T.$$.fragment,e),O=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1njntk5"&&(g.textContent=ve),ee=a(e),m(j.$$.fragment,e),te=a(e),m(v.$$.fragment,e),se=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-8wiat7"&&(J.textContent=Je),le=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-bbm4tq"&&($.innerHTML=$e),ne=a(e),m(C.$$.fragment,e),ae=a(e),m(k.$$.fragment,e),oe=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-10c7yzp"&&(I.textContent=Ce),ie=a(e),y=i(e,"UL",{});var N=X(y);H=i(N,"LI",{"data-svelte-h":!0}),r(H)!=="svelte-1screu0"&&(H.innerHTML=ke),ue=a(N),u=i(N,"LI",{});var A=X(u);E=i(A,"P",{"data-svelte-h":!0}),r(E)!=="svelte-p4qc76"&&(E.innerHTML=Ie),be=a(A),m(Z.$$.fragment,A),Ue=a(A),Q=i(A,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16k2rhu"&&(Q.innerHTML=Ze),A.forEach(s),Te=a(N),_=i(N,"LI",{});var ye=X(_);R=i(ye,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1hcigh9"&&(R.innerHTML=_e),ge=a(ye),m(x.$$.fragment,ye),ye.forEach(s),N.forEach(s),re=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1kbj28l"&&(G.textContent=xe),he=a(e),m(W.$$.fragment,e),de=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1vyibui"&&(S.textContent=Ge),me=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-t5lt8b"&&(z.innerHTML=We),pe=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1c5k75d"&&(B.innerHTML=Se),ce=a(e),m(L.$$.fragment,e),fe=a(e),Y=i(e,"P",{}),X(Y).forEach(s),this.h()},h(){ze(w,"name","hf:doc:metadata"),ze(w,"content",Ye)},m(e,t){h(document.head,w),l(e,F,t),l(e,V,t),l(e,K,t),p(b,e,t),l(e,P,t),p(U,e,t),l(e,D,t),p(T,e,t),l(e,O,t),l(e,g,t),l(e,ee,t),p(j,e,t),l(e,te,t),p(v,e,t),l(e,se,t),l(e,J,t),l(e,le,t),l(e,$,t),l(e,ne,t),p(C,e,t),l(e,ae,t),p(k,e,t),l(e,oe,t),l(e,I,t),l(e,ie,t),l(e,y,t),h(y,H),h(y,ue),h(y,u),h(u,E),h(u,be),p(Z,u,null),h(u,Ue),h(u,Q),h(y,Te),h(y,_),h(_,R),h(_,ge),p(x,_,null),l(e,re,t),l(e,G,t),l(e,he,t),p(W,e,t),l(e,de,t),l(e,S,t),l(e,me,t),l(e,z,t),l(e,pe,t),l(e,B,t),l(e,ce,t),p(L,e,t),l(e,fe,t),l(e,Y,t),Me=!0},p:Le,i(e){Me||(c(b.$$.fragment,e),c(U.$$.fragment,e),c(T.$$.fragment,e),c(j.$$.fragment,e),c(v.$$.fragment,e),c(C.$$.fragment,e),c(k.$$.fragment,e),c(Z.$$.fragment,e),c(x.$$.fragment,e),c(W.$$.fragment,e),c(L.$$.fragment,e),Me=!0)},o(e){f(b.$$.fragment,e),f(U.$$.fragment,e),f(T.$$.fragment,e),f(j.$$.fragment,e),f(v.$$.fragment,e),f(C.$$.fragment,e),f(k.$$.fragment,e),f(Z.$$.fragment,e),f(x.$$.fragment,e),f(W.$$.fragment,e),f(L.$$.fragment,e),Me=!1},d(e){e&&(s(F),s(V),s(K),s(P),s(D),s(O),s(g),s(ee),s(te),s(se),s(J),s(le),s($),s(ne),s(ae),s(oe),s(I),s(ie),s(y),s(re),s(G),s(he),s(de),s(S),s(me),s(z),s(pe),s(B),s(ce),s(fe),s(Y)),s(w),M(b,e),M(U,e),M(T,e),M(j,e),M(v,e),M(C,e),M(k,e),M(Z),M(x),M(W,e),M(L,e)}}}const Ye='{"title":"Torch shared tensors","local":"torch-shared-tensors","sections":[{"title":"TL;DR","local":"tldr","sections":[],"depth":2},{"title":"What are shared tensors ?","local":"what-are-shared-tensors-","sections":[],"depth":2},{"title":"Why are shared tensors not saved in safetensors ?","local":"why-are-shared-tensors-not-saved-in-safetensors-","sections":[],"depth":2},{"title":"How does it work ?","local":"how-does-it-work-","sections":[],"depth":2}],"depth":1}';function Xe(je){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class De extends Ee{constructor(w){super(),Qe(this,w,Xe,Ve,Be,{})}}export{De as component};
