# Flax API[[safetensors.flax.load_file]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.flax.load_file</name><anchor>safetensors.flax.load_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/flax.py#L102</source><parameters>[{"name": "filename", "val": ": typing.Union[str, os.PathLike]"}]</parameters><paramsdesc>- **filename** (`str`, or `os.PathLike`)) --
  The name of the file which contains the tensors</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, Array]`</rettype><retdesc>dictionary that contains name as key, value as `Array`</retdesc></docstring>

Loads a safetensors file into flax format.







<ExampleCodeBlock anchor="safetensors.flax.load_file.example">

Example:

```python
from safetensors.flax import load_file

file_path = "./my_folder/bert.safetensors"
loaded = load_file(file_path)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.flax.load</name><anchor>safetensors.flax.load</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/flax.py#L75</source><parameters>[{"name": "data", "val": ": bytes"}]</parameters><paramsdesc>- **data** (`bytes`) --
  The content of a safetensors file</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, Array]`</rettype><retdesc>dictionary that contains name as key, value as `Array` on cpu</retdesc></docstring>

Loads a safetensors file into flax format from pure bytes.







<ExampleCodeBlock anchor="safetensors.flax.load.example">

Example:

```python
from safetensors.flax import load

file_path = "./my_folder/bert.safetensors"
with open(file_path, "rb") as f:
    data = f.read()

loaded = load(data)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.flax.save_file</name><anchor>safetensors.flax.save_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/flax.py#L40</source><parameters>[{"name": "tensors", "val": ": typing.Dict[str, jax.Array]"}, {"name": "filename", "val": ": typing.Union[str, os.PathLike]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensors** (`Dict[str, Array]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **filename** (`str`, or `os.PathLike`)) --
  The filename we're saving into.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`None`</rettype></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.flax.save_file.example">

Example:

```python
from safetensors.flax import save_file
from jax import numpy as jnp

tensors = {"embedding": jnp.zeros((512, 1024)), "attention": jnp.zeros((256, 256))}
save_file(tensors, "model.safetensors")
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.flax.save</name><anchor>safetensors.flax.save</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/flax.py#L11</source><parameters>[{"name": "tensors", "val": ": typing.Dict[str, jax.Array]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensors** (`Dict[str, Array]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`bytes`</rettype><retdesc>The raw bytes representing the format</retdesc></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.flax.save.example">

Example:

```python
from safetensors.flax import save
from jax import numpy as jnp

tensors = {"embedding": jnp.zeros((512, 1024)), "attention": jnp.zeros((256, 256))}
byte_data = save(tensors)
```

</ExampleCodeBlock>


</div>

<EditOnGithub source="https://github.com/huggingface/safetensors/blob/main/docs/source/api/flax.mdx" />