# Numpy API[[safetensors.numpy.load_file]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.numpy.load_file</name><anchor>safetensors.numpy.load_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/numpy.py#L117</source><parameters>[{"name": "filename", "val": ": typing.Union[str, os.PathLike]"}]</parameters><paramsdesc>- **filename** (`str`, or `os.PathLike`)) --
  The name of the file which contains the tensors</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, np.ndarray]`</rettype><retdesc>dictionary that contains name as key, value as `np.ndarray`</retdesc></docstring>

Loads a safetensors file into numpy format.







<ExampleCodeBlock anchor="safetensors.numpy.load_file.example">

Example:

```python
from safetensors.numpy import load_file

file_path = "./my_folder/bert.safetensors"
loaded = load_file(file_path)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.numpy.load</name><anchor>safetensors.numpy.load</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/numpy.py#L90</source><parameters>[{"name": "data", "val": ": bytes"}]</parameters><paramsdesc>- **data** (`bytes`) --
  The content of a safetensors file</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, np.ndarray]`</rettype><retdesc>dictionary that contains name as key, value as `np.ndarray` on cpu</retdesc></docstring>

Loads a safetensors file into numpy format from pure bytes.







<ExampleCodeBlock anchor="safetensors.numpy.load.example">

Example:

```python
from safetensors.numpy import load

file_path = "./my_folder/bert.safetensors"
with open(file_path, "rb") as f:
    data = f.read()

loaded = load(data)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.numpy.save_file</name><anchor>safetensors.numpy.save_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/numpy.py#L52</source><parameters>[{"name": "tensor_dict", "val": ": typing.Dict[str, numpy.ndarray]"}, {"name": "filename", "val": ": typing.Union[str, os.PathLike]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensor_dict** (`Dict[str, np.ndarray]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **filename** (`str`, or `os.PathLike`)) --
  The filename we're saving into.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`None`</rettype></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.numpy.save_file.example">

Example:

```python
from safetensors.numpy import save_file
import numpy as np

tensors = {"embedding": np.zeros((512, 1024)), "attention": np.zeros((256, 256))}
save_file(tensors, "model.safetensors")
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.numpy.save</name><anchor>safetensors.numpy.save</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/numpy.py#L16</source><parameters>[{"name": "tensor_dict", "val": ": typing.Dict[str, numpy.ndarray]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensor_dict** (`Dict[str, np.ndarray]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`bytes`</rettype><retdesc>The raw bytes representing the format</retdesc></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.numpy.save.example">

Example:

```python
from safetensors.numpy import save
import numpy as np

tensors = {"embedding": np.zeros((512, 1024)), "attention": np.zeros((256, 256))}
byte_data = save(tensors)
```

</ExampleCodeBlock>


</div>

<EditOnGithub source="https://github.com/huggingface/safetensors/blob/main/docs/source/api/numpy.mdx" />