# PaddlePaddle API[[safetensors.paddle.load_file]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.paddle.load_file</name><anchor>safetensors.paddle.load_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/paddle.py#L108</source><parameters>[{"name": "filename", "val": ": typing.Union[str, os.PathLike]"}, {"name": "device", "val": " = 'cpu'"}]</parameters><paramsdesc>- **filename** (`str`, or `os.PathLike`)) --
  The name of the file which contains the tensors
- **device** (`Union[Dict[str, any], str]`, *optional*, defaults to `cpu`) --
  The device where the tensors need to be located after load.
  available options are all regular paddle device locations</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, paddle.Tensor]`</rettype><retdesc>dictionary that contains name as key, value as `paddle.Tensor`</retdesc></docstring>

Loads a safetensors file into paddle format.







<ExampleCodeBlock anchor="safetensors.paddle.load_file.example">

Example:

```python
from safetensors.paddle import load_file

file_path = "./my_folder/bert.safetensors"
loaded = load_file(file_path)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.paddle.load</name><anchor>safetensors.paddle.load</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/paddle.py#L77</source><parameters>[{"name": "data", "val": ": bytes"}, {"name": "device", "val": ": str = 'cpu'"}]</parameters><paramsdesc>- **data** (`bytes`) --
  The content of a safetensors file</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, paddle.Tensor]`</rettype><retdesc>dictionary that contains name as key, value as `paddle.Tensor` on cpu</retdesc></docstring>

Loads a safetensors file into paddle format from pure bytes.







<ExampleCodeBlock anchor="safetensors.paddle.load.example">

Example:

```python
from safetensors.paddle import load

file_path = "./my_folder/bert.safetensors"
with open(file_path, "rb") as f:
    data = f.read()

loaded = load(data)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.paddle.save_file</name><anchor>safetensors.paddle.save_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/paddle.py#L43</source><parameters>[{"name": "tensors", "val": ": typing.Dict[str, paddle.Tensor]"}, {"name": "filename", "val": ": typing.Union[str, os.PathLike]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensors** (`Dict[str, paddle.Tensor]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **filename** (`str`, or `os.PathLike`)) --
  The filename we're saving into.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`None`</rettype></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.paddle.save_file.example">

Example:

```python
from safetensors.paddle import save_file
import paddle

tensors = {"embedding": paddle.zeros((512, 1024)), "attention": paddle.zeros((256, 256))}
save_file(tensors, "model.safetensors")
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.paddle.save</name><anchor>safetensors.paddle.save</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/paddle.py#L11</source><parameters>[{"name": "tensors", "val": ": typing.Dict[str, paddle.Tensor]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensors** (`Dict[str, paddle.Tensor]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`bytes`</rettype><retdesc>The raw bytes representing the format</retdesc></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.paddle.save.example">

Example:

```python
from safetensors.paddle import save
import paddle

tensors = {"embedding": paddle.zeros((512, 1024)), "attention": paddle.zeros((256, 256))}
byte_data = save(tensors)
```

</ExampleCodeBlock>


</div>

<EditOnGithub source="https://github.com/huggingface/safetensors/blob/main/docs/source/api/paddle.mdx" />