# Tensorflow API[[safetensors.tensorflow.load_file]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.tensorflow.load_file</name><anchor>safetensors.tensorflow.load_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/tensorflow.py#L103</source><parameters>[{"name": "filename", "val": ": typing.Union[str, os.PathLike]"}]</parameters><paramsdesc>- **filename** (`str`, or `os.PathLike`)) --
  The name of the file which contains the tensors</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, tf.Tensor]`</rettype><retdesc>dictionary that contains name as key, value as `tf.Tensor`</retdesc></docstring>

Loads a safetensors file into tensorflow format.







<ExampleCodeBlock anchor="safetensors.tensorflow.load_file.example">

Example:

```python
from safetensors.tensorflow import load_file

file_path = "./my_folder/bert.safetensors"
loaded = load_file(file_path)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.tensorflow.load</name><anchor>safetensors.tensorflow.load</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/tensorflow.py#L76</source><parameters>[{"name": "data", "val": ": bytes"}]</parameters><paramsdesc>- **data** (`bytes`) --
  The content of a safetensors file</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, tf.Tensor]`</rettype><retdesc>dictionary that contains name as key, value as `tf.Tensor` on cpu</retdesc></docstring>

Loads a safetensors file into tensorflow format from pure bytes.







<ExampleCodeBlock anchor="safetensors.tensorflow.load.example">

Example:

```python
from safetensors.tensorflow import load

file_path = "./my_folder/bert.safetensors"
with open(file_path, "rb") as f:
    data = f.read()

loaded = load(data)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.tensorflow.save_file</name><anchor>safetensors.tensorflow.save_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/tensorflow.py#L41</source><parameters>[{"name": "tensors", "val": ": typing.Dict[str, tensorflow.python.framework.tensor.Tensor]"}, {"name": "filename", "val": ": typing.Union[str, os.PathLike]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensors** (`Dict[str, tf.Tensor]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **filename** (`str`, or `os.PathLike`)) --
  The filename we're saving into.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`None`</rettype></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.tensorflow.save_file.example">

Example:

```python
from safetensors.tensorflow import save_file
import tensorflow as tf

tensors = {"embedding": tf.zeros((512, 1024)), "attention": tf.zeros((256, 256))}
save_file(tensors, "model.safetensors")
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.tensorflow.save</name><anchor>safetensors.tensorflow.save</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/tensorflow.py#L10</source><parameters>[{"name": "tensors", "val": ": typing.Dict[str, tensorflow.python.framework.tensor.Tensor]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensors** (`Dict[str, tf.Tensor]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`bytes`</rettype><retdesc>The raw bytes representing the format</retdesc></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.tensorflow.save.example">

Example:

```python
from safetensors.tensorflow import save
import tensorflow as tf

tensors = {"embedding": tf.zeros((512, 1024)), "attention": tf.zeros((256, 256))}
byte_data = save(tensors)
```

</ExampleCodeBlock>


</div>

<EditOnGithub source="https://github.com/huggingface/safetensors/blob/main/docs/source/api/tensorflow.mdx" />