# Torch API[[safetensors.torch.load_file]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.torch.load_file</name><anchor>safetensors.torch.load_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/torch.py#L310</source><parameters>[{"name": "filename", "val": ": typing.Union[str, os.PathLike]"}, {"name": "device", "val": ": typing.Union[str, int] = 'cpu'"}]</parameters><paramsdesc>- **filename** (`str`, or `os.PathLike`) --
  The name of the file which contains the tensors
- **device** (`Union[str, int]`, *optional*, defaults to `cpu`) --
  The device where the tensors need to be located after load.
  available options are all regular torch device locations.</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, torch.Tensor]`</rettype><retdesc>dictionary that contains name as key, value as `torch.Tensor`</retdesc></docstring>

Loads a safetensors file into torch format.







<ExampleCodeBlock anchor="safetensors.torch.load_file.example">

Example:

```python
from safetensors.torch import load_file

file_path = "./my_folder/bert.safetensors"
loaded = load_file(file_path)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.torch.load</name><anchor>safetensors.torch.load</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/torch.py#L342</source><parameters>[{"name": "data", "val": ": bytes"}]</parameters><paramsdesc>- **data** (`bytes`) --
  The content of a safetensors file</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, torch.Tensor]`</rettype><retdesc>dictionary that contains name as key, value as `torch.Tensor` on cpu</retdesc></docstring>

Loads a safetensors file into torch format from pure bytes.







<ExampleCodeBlock anchor="safetensors.torch.load.example">

Example:

```python
from safetensors.torch import load

file_path = "./my_folder/bert.safetensors"
with open(file_path, "rb") as f:
    data = f.read()

loaded = load(data)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.torch.save_file</name><anchor>safetensors.torch.save_file</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/torch.py#L276</source><parameters>[{"name": "tensors", "val": ": typing.Dict[str, torch.Tensor]"}, {"name": "filename", "val": ": typing.Union[str, os.PathLike]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensors** (`Dict[str, torch.Tensor]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **filename** (`str`, or `os.PathLike`)) --
  The filename we're saving into.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`None`</rettype></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.torch.save_file.example">

Example:

```python
from safetensors.torch import save_file
import torch

tensors = {"embedding": torch.zeros((512, 1024)), "attention": torch.zeros((256, 256))}
save_file(tensors, "model.safetensors")
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.torch.save</name><anchor>safetensors.torch.save</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/torch.py#L244</source><parameters>[{"name": "tensors", "val": ": typing.Dict[str, torch.Tensor]"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}]</parameters><paramsdesc>- **tensors** (`Dict[str, torch.Tensor]`) --
  The incoming tensors. Tensors need to be contiguous and dense.
- **metadata** (`Dict[str, str]`, *optional*, defaults to `None`) --
  Optional text only metadata you might want to save in your header.
  For instance it can be useful to specify more about the underlying
  tensors. This is purely informative and does not affect tensor loading.</paramsdesc><paramgroups>0</paramgroups><rettype>`bytes`</rettype><retdesc>The raw bytes representing the format</retdesc></docstring>

Saves a dictionary of tensors into raw bytes in safetensors format.







<ExampleCodeBlock anchor="safetensors.torch.save.example">

Example:

```python
from safetensors.torch import save
import torch

tensors = {"embedding": torch.zeros((512, 1024)), "attention": torch.zeros((256, 256))}
byte_data = save(tensors)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.torch.load_model</name><anchor>safetensors.torch.load_model</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/torch.py#L190</source><parameters>[{"name": "model", "val": ": Module"}, {"name": "filename", "val": ": typing.Union[str, os.PathLike]"}, {"name": "strict", "val": ": bool = True"}, {"name": "device", "val": ": typing.Union[str, int] = 'cpu'"}]</parameters><paramsdesc>- **model** (`torch.nn.Module`) --
  The model to load onto.
- **filename** (`str`, or `os.PathLike`) --
  The filename location to load the file from.
- **strict** (`bool`, *optional*, defaults to True) --
  Whether to fail if you're missing keys or having unexpected ones.
  When false, the function simply returns missing and unexpected names.
- **device** (`Union[str, int]`, *optional*, defaults to `cpu`) --
  The device where the tensors need to be located after load.
  available options are all regular torch device locations.</paramsdesc><paramgroups>0</paramgroups><rettype>`(missing, unexpected)</rettype><retdesc>(List[str], List[str])`
`missing` are names in the model which were not modified during loading
`unexpected` are names that are on the file, but weren't used during
the load.</retdesc></docstring>

Loads a given filename onto a torch model.
This method exists specifically to avoid tensor sharing issues which are
not allowed in `safetensors`. [More information on tensor sharing](../torch_shared_tensors)








</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>safetensors.torch.save_model</name><anchor>safetensors.torch.save_model</anchor><source>https://github.com/huggingface/safetensors/blob/main/bindings/python/py_src/safetensors/torch.py#L141</source><parameters>[{"name": "model", "val": ": Module"}, {"name": "filename", "val": ": str"}, {"name": "metadata", "val": ": typing.Optional[typing.Dict[str, str]] = None"}, {"name": "force_contiguous", "val": ": bool = True"}]</parameters><paramsdesc>- **model** (`torch.nn.Module`) --
  The model to save on disk.
- **filename** (`str`) --
  The filename location to save the file
- **metadata** (`Dict[str, str]`, *optional*) --
  Extra information to save along with the file.
  Some metadata will be added for each dropped tensors.
  This information will not be enough to recover the entire
  shared structure but might help understanding things
- **force_contiguous** (`boolean`, *optional*, defaults to True) --
  Forcing the state_dict to be saved as contiguous tensors.
  This has no effect on the correctness of the model, but it
  could potentially change performance if the layout of the tensor
  was chosen specifically for that reason.</paramsdesc><paramgroups>0</paramgroups></docstring>

Saves a given torch model to specified filename.
This method exists specifically to avoid tensor sharing issues which are
not allowed in `safetensors`. [More information on tensor sharing](../torch_shared_tensors)




</div>

<EditOnGithub source="https://github.com/huggingface/safetensors/blob/main/docs/source/api/torch.mdx" />