import{s as Yl,o as Fl}from"../chunks/scheduler.65852ee5.js";import{S as Sl,i as Ql,g as s,s as a,r as m,A as zl,h as o,f as l,c as i,j as Pl,u as p,x as r,k as ql,y as El,a as n,v as d,d as u,t as f,w as h,m as Nl,n as Ol}from"../chunks/index.65a1b999.js";import{T as Dl}from"../chunks/Tip.e1601166.js";import{D as Kl,C as c}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as g,E as en}from"../chunks/getInferenceSnippets.0c19d6f8.js";function tn(Re){let b;return{c(){b=Nl(`By default, LlamaIndex uses a chunk size of 1024 and a chunk overlap of
20. For more details, see the [LlamaIndex
documentation](https://docs.llamaindex.ai/en/stable/optimizing/basic_strategies/basic_strategies.html#chunk-sizes).`)},l(w){b=Ol(w,`By default, LlamaIndex uses a chunk size of 1024 and a chunk overlap of
20. For more details, see the [LlamaIndex
documentation](https://docs.llamaindex.ai/en/stable/optimizing/basic_strategies/basic_strategies.html#chunk-sizes).`)},m(w,$){n(w,b,$)},d(w){w&&l(b)}}}function ln(Re){let b,w,$,He,x,Xe,M,Ae,v,ll='<em>Authored by: <a href="https://huggingface.co/jinnovation" rel="nofollow">Jonathan Jin</a></em>',Ve,T,Pe,C,nl=`This notebook demonstrates how to quickly build a RAG-based “librarian” for your
local ebook library.`,qe,J,al=`Think about the last time you visited a library and took advantage of the
expertise of the knowledgeable staff there to help you find what you need out of
the troves of textbooks, novels, and other resources at the library. Our RAG
“librarian” will do the same for us, except for our own local collection of
ebooks.`,Ye,U,Fe,k,il=`We’d like our librarian to be <strong>lightweight</strong> and <strong>run locally as much as
possible</strong> with <strong>minimal dependencies</strong>. This means that we will leverage
open-source to the fullest extent possible, as well as bias towards models that
can be <strong>executed locally on typical hardware, e.g. M1 Macbooks</strong>.`,Se,I,Qe,L,sl="Our solution will consist of the following components:",ze,G,ol=`<li><a href="https://docs.llamaindex.ai/en/stable/index.html" rel="nofollow">LlamaIndex</a>, a data framework for LLM-based applications that’s, unlike
<a href="https://python.langchain.com/docs/get_started/introduction" rel="nofollow">LangChain</a>, designed specifically for RAG;</li> <li><a href="https://ollama.com/" rel="nofollow">Ollama</a>, a user-friendly solution for running LLMs such as Llama 2 locally;</li> <li>The <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a>
embedding model, which performs <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">reasonably well and is reasonably lightweight
in size</a>;</li> <li><a href="https://ollama.com/library/llama2" rel="nofollow">Llama 2</a>, which we’ll run via <a href="https://ollama.com/" rel="nofollow">Ollama</a>.</li>`,Ee,j,Ne,_,rl="First let’s install our dependencies.",Oe,Z,De,W,Ke,B,ml="These dependencies help properly detect the GPU.",et,R,tt,H,pl="Install Ollama.",lt,X,nt,A,dl="Run Ollama service in the background.",at,V,it,P,ul="Pull Llama2 from the Ollama library.",st,q,ot,Y,rt,F,fl="Next, let’s create our test “library.”",mt,S,hl="For simplicity’s sake, let’s say that our “library” is simply a <strong>nested directory of <code>.epub</code> files</strong>. We can easily see this solution generalizing to, say, a Calibre library with a <code>metadata.db</code> database file. We’ll leave that extension as an exercise for the reader. 😇",pt,Q,gl='Let’s pull two <code>.epub</code> files from <a href="https://www.gutenberg.org/" rel="nofollow">Project Gutenberg</a> for our library.',dt,z,ut,E,ft,N,bl="RAG with LlamaIndex, at its core, consists of the following broad phases:",ht,O,cl=`<li><strong>Loading</strong>, in which you tell LlamaIndex where your data lives and how to
load it;</li> <li><strong>Indexing</strong>, in which you augment your loaded data to facilitate querying, e.g. with vector embeddings;</li> <li><strong>Querying</strong>, in which you configure an LLM to act as the query interface for
your indexed data.</li>`,gt,D,wl=`This explanation only scratches at the surface of what’s possible with
LlamaIndex. For more in-depth details, I highly recommend reading the
<a href="https://docs.llamaindex.ai/en/stable/getting_started/concepts.html" rel="nofollow">“High-Level Concepts” page of the LlamaIndex
documentation</a>.`,bt,K,ct,ee,yl="Naturally, let’s start with the <strong>loading</strong> phase.",wt,te,$l=`I mentioned before that LlamaIndex is designed specifically for RAG. This
immediately becomes obvious from its
<a href="https://docs.llamaindex.ai/en/stable/module_guides/loading/simpledirectoryreader.html" rel="nofollow"><code>SimpleDirectoryReader</code></a>
construct, which ✨ <strong>magically</strong> ✨ supports a whole host of multi-model file
types for free. Conveniently for us, <code>.epub</code> is in the supported set.`,yt,le,$t,ne,xl='<code>SimpleDirectoryReader.load_data()</code> converts our ebooks into a set of <a href="https://docs.llamaindex.ai/en/stable/api/llama_index.core.schema.Document.html" rel="nofollow"><code>Document</code>s</a> for LlamaIndex to work with.',xt,ae,Ml="One important thing to note here is that the documents <strong>have not been chunked at this stage</strong> — that will happen during indexing. Read on…",Mt,ie,vt,se,vl="Next up after <strong>loading</strong> the data is to <strong>index</strong> it. This will allow our RAG pipeline to look up the relevant context for our query to pass to our LLM to <strong>augment</strong> their generated response. This is also where document chunking will take place.",Tt,oe,Tl=`<a href="https://docs.llamaindex.ai/en/stable/module_guides/indexing/vector_store_index.html" rel="nofollow"><code>VectorStoreIndex</code></a>
is a “default” entrypoint for indexing in LlamaIndex. By default,
<code>VectorStoreIndex</code> uses a simple, in-memory dictionary to store the indices, but
LlamaIndex also supports <a href="https://docs.llamaindex.ai/en/stable/module_guides/storing/vector_stores.html" rel="nofollow">a wide variety of vector storage
solutions</a>
for you to graduate to as you scale.`,Ct,y,Jt,re,Cl=`Like mentioned before, we’ll use the
<a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-small-en-v1.5</code></a> to
generate our embeddings. By default, <a href="https://docs.llamaindex.ai/en/stable/getting_started/starter_example.html" rel="nofollow">LlamaIndex uses
OpenAI</a>
(specifically <code>gpt-3.5-turbo</code>), which we’d like to avoid given our desire for a lightweight, locally-runnable end-to-end solution.`,Ut,me,Jl="Thankfully, LlamaIndex supports retrieving embedding models from Hugging Face through the convenient <code>HuggingFaceEmbedding</code> class, so we’ll use that here.",kt,pe,It,de,Ul="We’ll pass that in to <code>VectorStoreIndex</code> as our embedding model to circumvent the OpenAI default behavior.",Lt,ue,Gt,fe,jt,he,kl="Now for the final piece of the RAG puzzle — wiring up the query layer.",_t,ge,Il="We’ll use Llama 2 for the purposes of this recipe, but I encourage readers to play around with different models to see which produces the “best” responses here.",Zt,be,Ll='First let’s start up the Ollama server. Unfortunately, there is no support in the <a href="https://github.com/ollama/ollama-python" rel="nofollow">Ollama Python client</a> for actually starting and stopping the server itself, so we’ll have to pop out of Python land for this.',Wt,ce,Gl="In a separate terminal, run: <code>ollama serve</code>. Remember to terminate this after we’re done here!",Bt,we,jl="Now let’s hook Llama 2 up to LlamaIndex and use it as the basis of our query engine.",Rt,ye,Ht,$e,Xt,xe,_l="With that, our basic RAG librarian is set up and we can start asking questions about our library. For example:",At,Me,Vt,ve,Zl=`Based on the context provided, there are two books available:

1. "Pride and Prejudice" by Jane Austen
2. "Les Misérables" by Victor Hugo

The context used to derive this answer includes:

* The file path for each book, which provides information about the location of the book files on the computer.
* The titles of the books, which are mentioned in the context as being available for reading.
* A list of words associated with each book, such as "epub" and "notebooks", which provide additional information about the format and storage location of each book.
`,Pt,Te,qt,Ce,Wl=`The main character of 'Pride and Prejudice' is Elizabeth Bennet.
`,Yt,Je,Ft,Ue,Bl="We’ve demonstrated how to build a basic RAG-based “librarian” that runs entirely locally, even on Apple silicon Macs. In doing so, we’ve also carried out a “grand tour” of LlamaIndex and how it streamlines the process of setting up RAG-based applications.",St,ke,Rl="That said, we’ve really only scratched the surface of what’s possible here. Here are some ideas of how to refine and build upon this foundation.",Qt,Ie,zt,Le,Hl="To guard against the risk of our librarian hallucinating, how might we require that it provide citations for everything that it says?",Et,Ge,Nt,je,Xl='Ebook library management solutions like <a href="https://calibre-ebook.com/" rel="nofollow">Calibre</a> create additional metadata for ebooks in a library. This can provide information such as publisher or edition that might not be readily available in the text of the book itself. How could we extend our RAG pipeline to account for additional sources of information that aren’t <code>.epub</code> files?',Ot,_e,Dt,Ze,Al="If we were to collect everything we built here into a script/executable, the resulting script would re-index our library on each invocation. For our tiny test library of two files, this is “fine,” but for any library of non-trivial size this will very quickly become annoying for users. How could we persist the embedding indices and only update them when the contents of the library have meaningfully changed, e.g. new books have been added?",Kt,We,el,Be,tl;return x=new Kl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_llamaindex_librarian.ipynb"}]}}),M=new g({props:{title:"Building A RAG Ebook “Librarian” Using LlamaIndex",local:"building-a-rag-ebook-librarian-using-llamaindex",headingTag:"h1"}}),T=new g({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),U=new g({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),I=new g({props:{title:"Components",local:"components",headingTag:"h2"}}),j=new g({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),Z=new c({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwJTVDJTBBJTIwJTIwJTIwJTIwbGxhbWEtaW5kZXglMjAlNUMlMEElMjAlMjAlMjAlMjBFYm9va0xpYiUyMCU1QyUwQSUyMCUyMCUyMCUyMGh0bWwydGV4dCUyMCU1QyUwQSUyMCUyMCUyMCUyMGxsYW1hLWluZGV4LWVtYmVkZGluZ3MtaHVnZ2luZ2ZhY2UlMjAlNUMlMEElMjAlMjAlMjAlMjBsbGFtYS1pbmRleC1sbG1zLW9sbGFtYQ==",highlighted:`%pip install -q \\
    llama-index \\
    EbookLib \\
    html2text \\
    llama-index-embeddings-huggingface \\
    llama-index-llms-ollama`,wrap:!1}}),W=new g({props:{title:"Ollama installation",local:"ollama-installation",headingTag:"h2"}}),R=new c({props:{code:"IWFwdCUyMGluc3RhbGwlMjBwY2l1dGlscyUyMGxzaHc=",highlighted:"!apt install pciutils lshw",wrap:!1}}),X=new c({props:{code:"IWN1cmwlMjAtZnNTTCUyMGh0dHBzJTNBJTJGJTJGb2xsYW1hLmNvbSUyRmluc3RhbGwuc2glMjAlN0MlMjBzaA==",highlighted:"!curl -fsSL https://ollama.com/install.sh | sh",wrap:!1}}),V=new c({props:{code:"Z2V0X2lweXRob24oKS5zeXN0ZW1fcmF3KCUyMm9sbGFtYSUyMHNlcnZlJTIwJTI2JTIyKQ==",highlighted:'get_ipython().system_raw(<span class="hljs-string">&quot;ollama serve &amp;&quot;</span>)',wrap:!1}}),q=new c({props:{code:"IW9sbGFtYSUyMHB1bGwlMjBsbGFtYTI=",highlighted:"!ollama pull llama2",wrap:!1}}),Y=new g({props:{title:"Test Library Setup",local:"test-library-setup",headingTag:"h2"}}),z=new c({props:{code:"IW1rZGlyJTIwLXAlMjAlMjIuJTJGdGVzdCUyRmxpYnJhcnklMkZqYW5lLWF1c3RlbiUyMiUwQSFta2RpciUyMC1wJTIwJTIyLiUyRnRlc3QlMkZsaWJyYXJ5JTJGdmljdG9yLWh1Z28lMjIlMEEhd2dldCUyMGh0dHBzJTNBJTJGJTJGd3d3Lmd1dGVuYmVyZy5vcmclMkZlYm9va3MlMkYxMzQyLmVwdWIubm9pbWFnZXMlMjAtTyUyMCUyMi4lMkZ0ZXN0JTJGbGlicmFyeSUyRmphbmUtYXVzdGVuJTJGcHJpZGUtYW5kLXByZWp1ZGljZS5lcHViJTIyJTBBIXdnZXQlMjBodHRwcyUzQSUyRiUyRnd3dy5ndXRlbmJlcmcub3JnJTJGZWJvb2tzJTJGMTM1LmVwdWIubm9pbWFnZXMlMjAtTyUyMCUyMi4lMkZ0ZXN0JTJGbGlicmFyeSUyRnZpY3Rvci1odWdvJTJGbGVzLW1pc2VyYWJsZXMuZXB1YiUyMg==",highlighted:`!mkdir -p <span class="hljs-string">&quot;./test/library/jane-austen&quot;</span>
!mkdir -p <span class="hljs-string">&quot;./test/library/victor-hugo&quot;</span>
!wget https://www.gutenberg.org/ebooks/<span class="hljs-number">1342.</span>epub.noimages -O <span class="hljs-string">&quot;./test/library/jane-austen/pride-and-prejudice.epub&quot;</span>
!wget https://www.gutenberg.org/ebooks/<span class="hljs-number">135.</span>epub.noimages -O <span class="hljs-string">&quot;./test/library/victor-hugo/les-miserables.epub&quot;</span>`,wrap:!1}}),E=new g({props:{title:"RAG with LlamaIndex",local:"rag-with-llamaindex",headingTag:"h2"}}),K=new g({props:{title:"Loading",local:"loading",headingTag:"h3"}}),le=new c({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIlMEElMEFsb2FkZXIlMjAlM0QlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIoJTBBJTIwJTIwJTIwJTIwaW5wdXRfZGlyJTNEJTIyLiUyRnRlc3QlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjByZWN1cnNpdmUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmVxdWlyZWRfZXh0cyUzRCU1QiUyMi5lcHViJTIyJTVEJTJDJTBBKSUwQSUwQWRvY3VtZW50cyUyMCUzRCUyMGxvYWRlci5sb2FkX2RhdGEoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> SimpleDirectoryReader

loader = SimpleDirectoryReader(
    input_dir=<span class="hljs-string">&quot;./test/&quot;</span>,
    recursive=<span class="hljs-literal">True</span>,
    required_exts=[<span class="hljs-string">&quot;.epub&quot;</span>],
)

documents = loader.load_data()`,wrap:!1}}),ie=new g({props:{title:"Indexing",local:"indexing",headingTag:"h3"}}),y=new Dl({props:{$$slots:{default:[tn]},$$scope:{ctx:Re}}}),pe=new c({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyUwQSUwQWVtYmVkZGluZ19tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding

embedding_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)`,wrap:!1}}),ue=new c({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBJTBBaW5kZXglMjAlM0QlMjBWZWN0b3JTdG9yZUluZGV4LmZyb21fZG9jdW1lbnRzKCUwQSUyMCUyMCUyMCUyMGRvY3VtZW50cyUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkX21vZGVsJTNEZW1iZWRkaW5nX21vZGVsJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex

index = VectorStoreIndex.from_documents(
    documents,
    embed_model=embedding_model,
)`,wrap:!1}}),fe=new g({props:{title:"Querying",local:"querying",headingTag:"h3"}}),ye=new c({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMub2xsYW1hJTIwaW1wb3J0JTIwT2xsYW1hJTBBJTBBbGxhbWElMjAlM0QlMjBPbGxhbWEoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJsbGFtYTIlMjIlMkMlMEElMjAlMjAlMjAlMjByZXF1ZXN0X3RpbWVvdXQlM0Q0MC4wJTJDJTBBKSUwQSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMGluZGV4LmFzX3F1ZXJ5X2VuZ2luZShsbG0lM0RsbGFtYSk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.ollama <span class="hljs-keyword">import</span> Ollama

llama = Ollama(
    model=<span class="hljs-string">&quot;llama2&quot;</span>,
    request_timeout=<span class="hljs-number">40.0</span>,
)

query_engine = index.as_query_engine(llm=llama)`,wrap:!1}}),$e=new g({props:{title:"Final Result",local:"final-result",headingTag:"h2"}}),Me=new c({props:{code:"cHJpbnQoJTBBJTIwJTIwJTIwJTIwcXVlcnlfZW5naW5lLnF1ZXJ5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoYXQlMjBhcmUlMjB0aGUlMjB0aXRsZXMlMjBvZiUyMGFsbCUyMHRoZSUyMGJvb2tzJTIwYXZhaWxhYmxlJTNGJTIwU2hvdyUyMG1lJTIwdGhlJTIwY29udGV4dCUyMHVzZWQlMjB0byUyMGRlcml2ZSUyMHlvdXIlMjBhbnN3ZXIuJTIyJTBBJTIwJTIwJTIwJTIwKSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    query_engine.query(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;What are the titles of all the books available? Show me the context used to derive your answer.&quot;</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>)`,wrap:!1}}),Te=new c({props:{code:"cHJpbnQocXVlcnlfZW5naW5lLnF1ZXJ5KCUyMldobyUyMGlzJTIwdGhlJTIwbWFpbiUyMGNoYXJhY3RlciUyMG9mJTIwJ1ByaWRlJTIwYW5kJTIwUHJlanVkaWNlJyUzRiUyMikp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(query_engine.query(<span class="hljs-string">&quot;Who is the main character of &#x27;Pride and Prejudice&#x27;?&quot;</span>))',wrap:!1}}),Je=new g({props:{title:"Conclusion and Future Improvements",local:"conclusion-and-future-improvements",headingTag:"h2"}}),Ie=new g({props:{title:"Forcing Citations",local:"forcing-citations",headingTag:"h3"}}),Ge=new g({props:{title:"Using Extended Metadata",local:"using-extended-metadata",headingTag:"h3"}}),_e=new g({props:{title:"Efficient Indexing",local:"efficient-indexing",headingTag:"h3"}}),We=new en({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_llamaindex_librarian.md"}}),{c(){b=s("meta"),w=a(),$=s("p"),He=a(),m(x.$$.fragment),Xe=a(),m(M.$$.fragment),Ae=a(),v=s("p"),v.innerHTML=ll,Ve=a(),m(T.$$.fragment),Pe=a(),C=s("p"),C.textContent=nl,qe=a(),J=s("p"),J.textContent=al,Ye=a(),m(U.$$.fragment),Fe=a(),k=s("p"),k.innerHTML=il,Se=a(),m(I.$$.fragment),Qe=a(),L=s("p"),L.textContent=sl,ze=a(),G=s("ul"),G.innerHTML=ol,Ee=a(),m(j.$$.fragment),Ne=a(),_=s("p"),_.textContent=rl,Oe=a(),m(Z.$$.fragment),De=a(),m(W.$$.fragment),Ke=a(),B=s("p"),B.textContent=ml,et=a(),m(R.$$.fragment),tt=a(),H=s("p"),H.textContent=pl,lt=a(),m(X.$$.fragment),nt=a(),A=s("p"),A.textContent=dl,at=a(),m(V.$$.fragment),it=a(),P=s("p"),P.textContent=ul,st=a(),m(q.$$.fragment),ot=a(),m(Y.$$.fragment),rt=a(),F=s("p"),F.textContent=fl,mt=a(),S=s("p"),S.innerHTML=hl,pt=a(),Q=s("p"),Q.innerHTML=gl,dt=a(),m(z.$$.fragment),ut=a(),m(E.$$.fragment),ft=a(),N=s("p"),N.textContent=bl,ht=a(),O=s("ol"),O.innerHTML=cl,gt=a(),D=s("p"),D.innerHTML=wl,bt=a(),m(K.$$.fragment),ct=a(),ee=s("p"),ee.innerHTML=yl,wt=a(),te=s("p"),te.innerHTML=$l,yt=a(),m(le.$$.fragment),$t=a(),ne=s("p"),ne.innerHTML=xl,xt=a(),ae=s("p"),ae.innerHTML=Ml,Mt=a(),m(ie.$$.fragment),vt=a(),se=s("p"),se.innerHTML=vl,Tt=a(),oe=s("p"),oe.innerHTML=Tl,Ct=a(),m(y.$$.fragment),Jt=a(),re=s("p"),re.innerHTML=Cl,Ut=a(),me=s("p"),me.innerHTML=Jl,kt=a(),m(pe.$$.fragment),It=a(),de=s("p"),de.innerHTML=Ul,Lt=a(),m(ue.$$.fragment),Gt=a(),m(fe.$$.fragment),jt=a(),he=s("p"),he.textContent=kl,_t=a(),ge=s("p"),ge.textContent=Il,Zt=a(),be=s("p"),be.innerHTML=Ll,Wt=a(),ce=s("p"),ce.innerHTML=Gl,Bt=a(),we=s("p"),we.textContent=jl,Rt=a(),m(ye.$$.fragment),Ht=a(),m($e.$$.fragment),Xt=a(),xe=s("p"),xe.textContent=_l,At=a(),m(Me.$$.fragment),Vt=a(),ve=s("pre"),ve.textContent=Zl,Pt=a(),m(Te.$$.fragment),qt=a(),Ce=s("pre"),Ce.textContent=Wl,Yt=a(),m(Je.$$.fragment),Ft=a(),Ue=s("p"),Ue.textContent=Bl,St=a(),ke=s("p"),ke.textContent=Rl,Qt=a(),m(Ie.$$.fragment),zt=a(),Le=s("p"),Le.textContent=Hl,Et=a(),m(Ge.$$.fragment),Nt=a(),je=s("p"),je.innerHTML=Xl,Ot=a(),m(_e.$$.fragment),Dt=a(),Ze=s("p"),Ze.textContent=Al,Kt=a(),m(We.$$.fragment),el=a(),Be=s("p"),this.h()},l(e){const t=zl("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),w=i(e),$=o(e,"P",{}),Pl($).forEach(l),He=i(e),p(x.$$.fragment,e),Xe=i(e),p(M.$$.fragment,e),Ae=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-15wt2km"&&(v.innerHTML=ll),Ve=i(e),p(T.$$.fragment,e),Pe=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-qfh19j"&&(C.textContent=nl),qe=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-17t611x"&&(J.textContent=al),Ye=i(e),p(U.$$.fragment,e),Fe=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1fw445c"&&(k.innerHTML=il),Se=i(e),p(I.$$.fragment,e),Qe=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-13bey4p"&&(L.textContent=sl),ze=i(e),G=o(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-azwmvi"&&(G.innerHTML=ol),Ee=i(e),p(j.$$.fragment,e),Ne=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1yta0e7"&&(_.textContent=rl),Oe=i(e),p(Z.$$.fragment,e),De=i(e),p(W.$$.fragment,e),Ke=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ffiog4"&&(B.textContent=ml),et=i(e),p(R.$$.fragment,e),tt=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1qqxvb"&&(H.textContent=pl),lt=i(e),p(X.$$.fragment,e),nt=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1ykyf08"&&(A.textContent=dl),at=i(e),p(V.$$.fragment,e),it=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-t4035a"&&(P.textContent=ul),st=i(e),p(q.$$.fragment,e),ot=i(e),p(Y.$$.fragment,e),rt=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-u4a6ea"&&(F.textContent=fl),mt=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-341xmi"&&(S.innerHTML=hl),pt=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1od3m7l"&&(Q.innerHTML=gl),dt=i(e),p(z.$$.fragment,e),ut=i(e),p(E.$$.fragment,e),ft=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1dd5h8w"&&(N.textContent=bl),ht=i(e),O=o(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-vs2u02"&&(O.innerHTML=cl),gt=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1arec5s"&&(D.innerHTML=wl),bt=i(e),p(K.$$.fragment,e),ct=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-vs6beo"&&(ee.innerHTML=yl),wt=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-atznhb"&&(te.innerHTML=$l),yt=i(e),p(le.$$.fragment,e),$t=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-17k0m2j"&&(ne.innerHTML=xl),xt=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-10xvxlh"&&(ae.innerHTML=Ml),Mt=i(e),p(ie.$$.fragment,e),vt=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-73j9ky"&&(se.innerHTML=vl),Tt=i(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1axkw64"&&(oe.innerHTML=Tl),Ct=i(e),p(y.$$.fragment,e),Jt=i(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-dzonf1"&&(re.innerHTML=Cl),Ut=i(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-fkwvyv"&&(me.innerHTML=Jl),kt=i(e),p(pe.$$.fragment,e),It=i(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1181vy7"&&(de.innerHTML=Ul),Lt=i(e),p(ue.$$.fragment,e),Gt=i(e),p(fe.$$.fragment,e),jt=i(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1v49o0l"&&(he.textContent=kl),_t=i(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-qxi4v1"&&(ge.textContent=Il),Zt=i(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1esi2jc"&&(be.innerHTML=Ll),Wt=i(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-z54bvc"&&(ce.innerHTML=Gl),Bt=i(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1xd6b55"&&(we.textContent=jl),Rt=i(e),p(ye.$$.fragment,e),Ht=i(e),p($e.$$.fragment,e),Xt=i(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1l7sm6m"&&(xe.textContent=_l),At=i(e),p(Me.$$.fragment,e),Vt=i(e),ve=o(e,"PRE",{"data-svelte-h":!0}),r(ve)!=="svelte-czhhw9"&&(ve.textContent=Zl),Pt=i(e),p(Te.$$.fragment,e),qt=i(e),Ce=o(e,"PRE",{"data-svelte-h":!0}),r(Ce)!=="svelte-13j10yu"&&(Ce.textContent=Wl),Yt=i(e),p(Je.$$.fragment,e),Ft=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-hu2ihj"&&(Ue.textContent=Bl),St=i(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-8meymn"&&(ke.textContent=Rl),Qt=i(e),p(Ie.$$.fragment,e),zt=i(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-5ludxz"&&(Le.textContent=Hl),Et=i(e),p(Ge.$$.fragment,e),Nt=i(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1qo1u1t"&&(je.innerHTML=Xl),Ot=i(e),p(_e.$$.fragment,e),Dt=i(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-aaxqx0"&&(Ze.textContent=Al),Kt=i(e),p(We.$$.fragment,e),el=i(e),Be=o(e,"P",{}),Pl(Be).forEach(l),this.h()},h(){ql(b,"name","hf:doc:metadata"),ql(b,"content",nn)},m(e,t){El(document.head,b),n(e,w,t),n(e,$,t),n(e,He,t),d(x,e,t),n(e,Xe,t),d(M,e,t),n(e,Ae,t),n(e,v,t),n(e,Ve,t),d(T,e,t),n(e,Pe,t),n(e,C,t),n(e,qe,t),n(e,J,t),n(e,Ye,t),d(U,e,t),n(e,Fe,t),n(e,k,t),n(e,Se,t),d(I,e,t),n(e,Qe,t),n(e,L,t),n(e,ze,t),n(e,G,t),n(e,Ee,t),d(j,e,t),n(e,Ne,t),n(e,_,t),n(e,Oe,t),d(Z,e,t),n(e,De,t),d(W,e,t),n(e,Ke,t),n(e,B,t),n(e,et,t),d(R,e,t),n(e,tt,t),n(e,H,t),n(e,lt,t),d(X,e,t),n(e,nt,t),n(e,A,t),n(e,at,t),d(V,e,t),n(e,it,t),n(e,P,t),n(e,st,t),d(q,e,t),n(e,ot,t),d(Y,e,t),n(e,rt,t),n(e,F,t),n(e,mt,t),n(e,S,t),n(e,pt,t),n(e,Q,t),n(e,dt,t),d(z,e,t),n(e,ut,t),d(E,e,t),n(e,ft,t),n(e,N,t),n(e,ht,t),n(e,O,t),n(e,gt,t),n(e,D,t),n(e,bt,t),d(K,e,t),n(e,ct,t),n(e,ee,t),n(e,wt,t),n(e,te,t),n(e,yt,t),d(le,e,t),n(e,$t,t),n(e,ne,t),n(e,xt,t),n(e,ae,t),n(e,Mt,t),d(ie,e,t),n(e,vt,t),n(e,se,t),n(e,Tt,t),n(e,oe,t),n(e,Ct,t),d(y,e,t),n(e,Jt,t),n(e,re,t),n(e,Ut,t),n(e,me,t),n(e,kt,t),d(pe,e,t),n(e,It,t),n(e,de,t),n(e,Lt,t),d(ue,e,t),n(e,Gt,t),d(fe,e,t),n(e,jt,t),n(e,he,t),n(e,_t,t),n(e,ge,t),n(e,Zt,t),n(e,be,t),n(e,Wt,t),n(e,ce,t),n(e,Bt,t),n(e,we,t),n(e,Rt,t),d(ye,e,t),n(e,Ht,t),d($e,e,t),n(e,Xt,t),n(e,xe,t),n(e,At,t),d(Me,e,t),n(e,Vt,t),n(e,ve,t),n(e,Pt,t),d(Te,e,t),n(e,qt,t),n(e,Ce,t),n(e,Yt,t),d(Je,e,t),n(e,Ft,t),n(e,Ue,t),n(e,St,t),n(e,ke,t),n(e,Qt,t),d(Ie,e,t),n(e,zt,t),n(e,Le,t),n(e,Et,t),d(Ge,e,t),n(e,Nt,t),n(e,je,t),n(e,Ot,t),d(_e,e,t),n(e,Dt,t),n(e,Ze,t),n(e,Kt,t),d(We,e,t),n(e,el,t),n(e,Be,t),tl=!0},p(e,[t]){const Vl={};t&2&&(Vl.$$scope={dirty:t,ctx:e}),y.$set(Vl)},i(e){tl||(u(x.$$.fragment,e),u(M.$$.fragment,e),u(T.$$.fragment,e),u(U.$$.fragment,e),u(I.$$.fragment,e),u(j.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(V.$$.fragment,e),u(q.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(E.$$.fragment,e),u(K.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(y.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u($e.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),u(Je.$$.fragment,e),u(Ie.$$.fragment,e),u(Ge.$$.fragment,e),u(_e.$$.fragment,e),u(We.$$.fragment,e),tl=!0)},o(e){f(x.$$.fragment,e),f(M.$$.fragment,e),f(T.$$.fragment,e),f(U.$$.fragment,e),f(I.$$.fragment,e),f(j.$$.fragment,e),f(Z.$$.fragment,e),f(W.$$.fragment,e),f(R.$$.fragment,e),f(X.$$.fragment,e),f(V.$$.fragment,e),f(q.$$.fragment,e),f(Y.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(K.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(y.$$.fragment,e),f(pe.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(ye.$$.fragment,e),f($e.$$.fragment,e),f(Me.$$.fragment,e),f(Te.$$.fragment,e),f(Je.$$.fragment,e),f(Ie.$$.fragment,e),f(Ge.$$.fragment,e),f(_e.$$.fragment,e),f(We.$$.fragment,e),tl=!1},d(e){e&&(l(w),l($),l(He),l(Xe),l(Ae),l(v),l(Ve),l(Pe),l(C),l(qe),l(J),l(Ye),l(Fe),l(k),l(Se),l(Qe),l(L),l(ze),l(G),l(Ee),l(Ne),l(_),l(Oe),l(De),l(Ke),l(B),l(et),l(tt),l(H),l(lt),l(nt),l(A),l(at),l(it),l(P),l(st),l(ot),l(rt),l(F),l(mt),l(S),l(pt),l(Q),l(dt),l(ut),l(ft),l(N),l(ht),l(O),l(gt),l(D),l(bt),l(ct),l(ee),l(wt),l(te),l(yt),l($t),l(ne),l(xt),l(ae),l(Mt),l(vt),l(se),l(Tt),l(oe),l(Ct),l(Jt),l(re),l(Ut),l(me),l(kt),l(It),l(de),l(Lt),l(Gt),l(jt),l(he),l(_t),l(ge),l(Zt),l(be),l(Wt),l(ce),l(Bt),l(we),l(Rt),l(Ht),l(Xt),l(xe),l(At),l(Vt),l(ve),l(Pt),l(qt),l(Ce),l(Yt),l(Ft),l(Ue),l(St),l(ke),l(Qt),l(zt),l(Le),l(Et),l(Nt),l(je),l(Ot),l(Dt),l(Ze),l(Kt),l(el),l(Be)),l(b),h(x,e),h(M,e),h(T,e),h(U,e),h(I,e),h(j,e),h(Z,e),h(W,e),h(R,e),h(X,e),h(V,e),h(q,e),h(Y,e),h(z,e),h(E,e),h(K,e),h(le,e),h(ie,e),h(y,e),h(pe,e),h(ue,e),h(fe,e),h(ye,e),h($e,e),h(Me,e),h(Te,e),h(Je,e),h(Ie,e),h(Ge,e),h(_e,e),h(We,e)}}}const nn='{"title":"Building A RAG Ebook “Librarian” Using LlamaIndex","local":"building-a-rag-ebook-librarian-using-llamaindex","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Components","local":"components","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2},{"title":"Ollama installation","local":"ollama-installation","sections":[],"depth":2},{"title":"Test Library Setup","local":"test-library-setup","sections":[],"depth":2},{"title":"RAG with LlamaIndex","local":"rag-with-llamaindex","sections":[{"title":"Loading","local":"loading","sections":[],"depth":3},{"title":"Indexing","local":"indexing","sections":[],"depth":3},{"title":"Querying","local":"querying","sections":[],"depth":3}],"depth":2},{"title":"Final Result","local":"final-result","sections":[],"depth":2},{"title":"Conclusion and Future Improvements","local":"conclusion-and-future-improvements","sections":[{"title":"Forcing Citations","local":"forcing-citations","sections":[],"depth":3},{"title":"Using Extended Metadata","local":"using-extended-metadata","sections":[],"depth":3},{"title":"Efficient Indexing","local":"efficient-indexing","sections":[],"depth":3}],"depth":2}],"depth":1}';function an(Re){return Fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends Sl{constructor(b){super(),Ql(this,b,an,ln,Yl,{})}}export{dn as component};
