import{s as Is,o as Vs,n as Cs}from"../chunks/scheduler.65852ee5.js";import{S as $s,i as Rs,g as i,s as a,r as p,A as ks,h as r,f as l,c as n,j as js,u as o,x as y,k as gs,y as Bs,a as s,v as M,d as m,t as U,w as u}from"../chunks/index.65a1b999.js";import{T as _s}from"../chunks/Tip.e1601166.js";import{D as Gs,C as w}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as b,E as Ns}from"../chunks/getInferenceSnippets.0c19d6f8.js";function Es(et){let c,J='If you are using Google Colab, SQLite is already installed. It may not be installed on your local computer.  If it’s not installed, follow the instructions on the <a href="https://www.sqlite.org/download.html" rel="nofollow">SQLite website</a> to install it. The Python interface code is built into Python and you don’t need to install any Python modules for it.';return{c(){c=i("p"),c.innerHTML=J},l(d){c=r(d,"P",{"data-svelte-h":!0}),y(c)!=="svelte-12vsqot"&&(c.innerHTML=J)},m(d,Ke){s(d,c,Ke)},p:Cs,d(d){d&&l(c)}}}function Zs(et){let c,J,d,Ke,h,tt,f,lt,j,Nl='<em>Authored by: <a href="https://github.com/scott-martens" rel="nofollow">Scott Martens</a> @ <a href="https://jina.ai" rel="nofollow">Jina AI</a></em>',st,g,El="This notebook will show you how to make a simple Retrieval Augmented Generation (RAG) system that draws on an SQL database instead of drawing information from a document store.",at,I,nt,V,Zl='<li>Given an SQL database, we extract SQL table definitions (the <code>CREATE</code> line in an SQL dump) and store them. In this tutorial, we’ve done this part for you and the definitions are stored in memory as a list. Scaling up from this example might require more sophisticated storage.</li> <li>The user enters a query in natural language.</li> <li><a href="https://jina.ai/reranker/" rel="nofollow">Jina Reranker v2</a> (<a href="https://huggingface.co/jinaai/jina-reranker-v2-base-multilingual" rel="nofollow"><code>jinaai/jina-reranker-v2-base-multilingual</code></a>), an SQL-aware reranking model from <a href="https://jina.ai" rel="nofollow">Jina AI</a>, sorts the table definitions in order of their relevance to the user’s query.</li> <li>We present <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.1" rel="nofollow">Mistral 7B Instruct v0.1 (<code>mistralai/Mistral-7B-Instruct-v0.1</code>)</a> with a prompt containing the user’s query and the top three table definitions, with a request to write an SQL query to fit the task.</li> <li>Mistral Instruct generates an SQL query and we run it against the database, retrieving a result.</li> <li>The SQL query result is converted to JSON and presented to Mistral Instruct in a new prompt, along with the user’s original query, the SQL query, and a request to compose an answer for the user in natural language.</li> <li>Mistral Instruct’s natural language text response is returned to the user.</li>',it,C,rt,$,Fl='For this tutorial, we are using a small open-access database of video game sales records <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">stored on GitHub</a>. We will be using the <a href="https://www.sqlite.org/index.html" rel="nofollow">SQLite</a> version because SQLite is very compact, cross-platform, and has built-in Python support.',pt,R,ot,k,Sl="We will be running the Jina Reranker v2 model locally. If you are using Google Colab to run this notebook, make sure you are using a runtime that has access to a GPU. If you are running it locally, you will need Python 3 (this tutorial was authored using a Python 3.11 installation) and it will run <em>much</em> faster with a CUDA-enabled GPU.",Mt,B,xl='We will also use the open-source <a href="https://www.llamaindex.ai/" rel="nofollow">LlamaIndex RAG framework</a> extensively in this tutorial, and the <a href="https://huggingface.co/inference-api/serverless" rel="nofollow">Hugging Face Inference API</a> to access Mistral 7B Instruct v0.1. You will need a <a href="https://huggingface.co/login" rel="nofollow">Hugging Face account</a> and an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a> with at least <code>READ</code> access.',mt,T,Ut,_,ut,G,yt,N,Ql="First, install the required Python modules:",wt,E,ct,Z,bt,F,vl='Next, download the SQLite database <code>videogames.db</code> from <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">GitHub</a> to the local filespace If <code>wget</code> is not available on your system, download the database from <a href="https://github.com/bbrumm/databasestar/raw/main/sample_databases/sample_db_videogames/sqlite/videogames.db" rel="nofollow">this link</a> and put it in the same directory where you’re running this notebook:',dt,S,Tt,x,Jt,Q,Wl="The following code will download the model <code>jina-reranker-v2-base-multilingual</code> and run it locally:",ht,v,ft,W,jt,X,Xl="We will use LlamaIndex to create a holder object for the connection to the Hugging Face inference API and to the copy of <code>mistralai/Mixtral-8x7B-Instruct-v0.1</code> running there.",gt,q,ql='First, get a Hugging Face access token from your <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face Account Settings page</a>.',It,H,Hl="Enter it when prompted below:",Vt,Y,Ct,L,Yl="Next, initialize an instance of the <code>HuggingFaceInferenceAPI</code> class from LlamaIndex and store it as <code>mistral_llm</code>:",$t,A,Rt,z,kt,P,Ll='We extracted the eight table definitions from the <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">database import files located on GitHub</a>. Run the command below to put them into a Python list named <code>table_declarations</code>:',Bt,D,_t,K,Al="Now, we define a function that takes a natural language query and the list of table definitions, scores all of them with Jina Reranker v2, returning them in order from highest scoring to lowest:",Gt,O,Nt,ee,zl="Jina Reranker v2 scores every table definition we give it and by default this function will return all of them with their scores. The optional argument <code>top_n</code> limits the number of results returned to a user-defined number, starting with the highest scoring one.",Et,te,Pl="Try it out. First, define a query:",Zt,le,Ft,se,Dl="Run <code>rank_tables</code> to get a list of table definitions back. Let’s set <code>top_n</code> to 3 to limit the return list size and assign it to the variable <code>ranked_tables</code>, then inspect the result:",St,ae,xt,ne,Kl="The output should include the tables <code>region_sales</code>, <code>platform</code> and <code>game_platform</code>, which all seem to be reasonable places to look for an answer to the query.",Qt,ie,vt,re,Ol="We’re going to have Mistral Instruct v0.1 write an SQL query that fulfils the user’s query, based on the declarations of the top three tables according to the reranker.",Wt,pe,es="First, we make a prompt for that purpose using LlamaIndex’ <code>PromptTemplate</code> class:",Xt,oe,qt,Me,ts="We use the <code>format</code> method to fill in the template fields with the user query and top three table declarations from Jina Reranker v2:",Ht,me,Yt,Ue,ls="You can see the actual text we’re going to pass to Mistral Instruct:",Lt,ue,At,ye,ss="Now let’s send the prompt to Mistral Instruct and retrieve its response:",zt,we,Pt,ce,Dt,be,as=`Use the built-in Python interface to SQLite to run the query above
against the database <code>videogames.db</code>:`,Kt,de,Ot,Te,ns='For details on the interface to SQLite, <a href="https://docs.python.org/3/library/sqlite3.html" rel="nofollow">see the Python3 documentation</a>.',el,Je,is="Inspect the result:",tl,he,ll,fe,rs="You can check if this is correct by running your own SQL query. The sales data stored in this database is in the form of floating point numbers, presumably thousands or millions of unit sales.",sl,je,al,ge,ps="Now we will pass the user’s query, the SQL query, and the result back to Mistral Instruct with a new prompt template.",nl,Ie,os="First, make the new prompt template using LlamaIndex, the same as above:",il,Ve,rl,Ce,Ms=`We will convert the SQL output into JSON, a format Mistral Instruct v0.1
understands.`,pl,$e,ms="Populate the template fields:",ol,Re,Ml,ke,Us="Now solicit a natural language response from Mistral Instruct:",ml,Be,Ul,_e,ul,Ge,us="Let’s organize all that into one function with exception trapping:",yl,Ne,wl,Ee,ys="Try it out:",cl,Ze,bl,Fe,ws="Try some other queries:",dl,Se,Tl,xe,Jl,Qe,hl,ve,fl,We,jl,Xe,cs="Try your own queries:",gl,qe,Il,He,Vl,Ye,bs="We’ve shown you how to make a very basic RAG (retrieval-augmented generation) system for natural language question-answering that uses an SQL database as an information source.  In this implementation, we use the same large language model (Mistral Instruct v0.1), to generate SQL queries and to construct natural language responses.",Cl,Le,ds="The database here is a very small example, and scaling this up might demand a more sophisticated approach than just ranking a list of table definitions. You might want to use a two-stage process, where an embedding model and vector store initially retrieve more results, but the reranker model prunes that down to whatever number you are able to put into a prompt for a generative language model.",$l,Ae,Ts="This notebook has assumed no request requires more than three tables to satisfy, and obviously, in practice, this cannot always be true. Mistral 7B Instruct v0.1 is not guaranteed to produce correct (or even executable) SQL output. In production, something like this requires much more in-depth error handling.",Rl,ze,Js="More sophisticated error handling, longer input context windows, and generative models specialized in SQL-specific tasks might make a big difference in practical applications.",kl,Pe,hs="Nonetheless, you can see here how the RAG concept extends to structured databases, expanding its scope for use dramatically.",Bl,De,_l,Oe,Gl;return h=new Gs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_sql_reranker.ipynb"}]}}),f=new b({props:{title:"RAG backed by SQL and Jina Reranker v2",local:"rag-backed-by-sql-and-jina-reranker-v2",headingTag:"h1"}}),I=new b({props:{title:"How it Works",local:"how-it-works",headingTag:"h3"}}),C=new b({props:{title:"The Database",local:"the-database",headingTag:"h3"}}),R=new b({props:{title:"Software and Hardware Requirements",local:"software-and-hardware-requirements",headingTag:"h3"}}),T=new _s({props:{warning:!0,$$slots:{default:[Es]},$$scope:{ctx:et}}}),_=new b({props:{title:"Setting Up",local:"setting-up",headingTag:"h2"}}),G=new b({props:{title:"Install Requirements",local:"install-requirements",headingTag:"h3"}}),E=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcVUlMjB0cmFuc2Zvcm1lcnMlMjBlaW5vcHMlMjBsbGFtYS1pbmRleCUyMGxsYW1hLWluZGV4LXBvc3Rwcm9jZXNzb3ItamluYWFpLXJlcmFuayUyMCUyMGxsYW1hLWluZGV4LWxsbXMtaHVnZ2luZ2ZhY2UlMjAlMjJodWdnaW5nZmFjZV9odWIlNUJpbmZlcmVuY2UlNUQlMjI=",highlighted:'!pip install -qU transformers einops llama-index llama-index-postprocessor-jinaai-rerank  llama-index-llms-huggingface <span class="hljs-string">&quot;huggingface_hub[inference]&quot;</span>',wrap:!1}}),Z=new b({props:{title:"Download the Database",local:"download-the-database",headingTag:"h3"}}),S=new w({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZiYnJ1bW0lMkZkYXRhYmFzZXN0YXIlMkZyYXclMkZtYWluJTJGc2FtcGxlX2RhdGFiYXNlcyUyRnNhbXBsZV9kYl92aWRlb2dhbWVzJTJGc3FsaXRlJTJGdmlkZW9nYW1lcy5kYg==",highlighted:"!wget https://github.com/bbrumm/databasestar/raw/main/sample_databases/sample_db_videogames/sqlite/videogames.db",wrap:!1}}),x=new b({props:{title:"Download and Run Jina Reranker v2",local:"download-and-run-jina-reranker-v2",headingTag:"h3"}}),v=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFyZXJhbmtlcl9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmppbmFhaSUyRmppbmEtcmVyYW5rZXItdjItYmFzZS1tdWx0aWxpbmd1YWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMEEpJTBBJTBBcmVyYW5rZXJfbW9kZWwudG8oJTIyY3VkYSUyMiklMjAlMjAlMjMlMjBvciUyMCdjcHUnJTIwaWYlMjBubyUyMEdQVSUyMGlzJTIwYXZhaWxhYmxlJTBBcmVyYW5rZXJfbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

reranker_model = AutoModelForSequenceClassification.from_pretrained(
    <span class="hljs-string">&quot;jinaai/jina-reranker-v2-base-multilingual&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>,
)

reranker_model.to(<span class="hljs-string">&quot;cuda&quot;</span>)  <span class="hljs-comment"># or &#x27;cpu&#x27; if no GPU is available</span>
reranker_model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),W=new b({props:{title:"Set up the Interface to Mistral Instruct",local:"set-up-the-interface-to-mistral-instruct",headingTag:"h3"}}),Y=new w({props:{code:"aW1wb3J0JTIwZ2V0cGFzcyUwQSUwQXByaW50KCUyMlBhc3RlJTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjZXNzJTIwdG9rZW4lMjBoZXJlJTNBJTIwJTIyKSUwQWhmX3Rva2VuJTIwJTNEJTIwZ2V0cGFzcy5nZXRwYXNzKCk=",highlighted:`<span class="hljs-keyword">import</span> getpass

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Paste your Hugging Face access token here: &quot;</span>)
hf_token = getpass.getpass()`,wrap:!1}}),A=new w({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSSUwQSUwQW1pc3RyYWxfbGxtJTIwJTNEJTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEkobW9kZWxfbmFtZSUzRCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTIwdG9rZW4lM0RoZl90b2tlbik=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

mistral_llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, token=hf_token)`,wrap:!1}}),z=new b({props:{title:"Using SQL-Aware Jina Reranker v2",local:"using-sql-aware-jina-reranker-v2",headingTag:"h2"}}),D=new w({props:{code:"dGFibGVfZGVjbGFyYXRpb25zJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyQ1JFQVRFJTIwVEFCTEUlMjBwbGF0Zm9ybSUyMCglNUNuJTVDdGlkJTIwSU5URUdFUiUyMFBSSU1BUlklMjBLRVklMkMlNUNuJTVDdHBsYXRmb3JtX25hbWUlMjBURVhUJTIwREVGQVVMVCUyME5VTEwlNUNuKSUzQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNSRUFURSUyMFRBQkxFJTIwZ2VucmUlMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RnZW5yZV9uYW1lJTIwVEVYVCUyMERFRkFVTFQlMjBOVUxMJTVDbiklM0IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDUkVBVEUlMjBUQUJMRSUyMHB1Ymxpc2hlciUyMCglNUNuJTVDdGlkJTIwSU5URUdFUiUyMFBSSU1BUlklMjBLRVklMkMlNUNuJTVDdHB1Ymxpc2hlcl9uYW1lJTIwVEVYVCUyMERFRkFVTFQlMjBOVUxMJTVDbiklM0IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDUkVBVEUlMjBUQUJMRSUyMHJlZ2lvbiUyMCglNUNuJTVDdGlkJTIwSU5URUdFUiUyMFBSSU1BUlklMjBLRVklMkMlNUNuJTVDdHJlZ2lvbl9uYW1lJTIwVEVYVCUyMERFRkFVTFQlMjBOVUxMJTVDbiklM0IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDUkVBVEUlMjBUQUJMRSUyMGdhbWUlMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RnZW5yZV9pZCUyMElOVEVHRVIlMkMlNUNuJTVDdGdhbWVfbmFtZSUyMFRFWFQlMjBERUZBVUxUJTIwTlVMTCUyQyU1Q24lNUN0Q09OU1RSQUlOVCUyMGZrX2dtX2dlbiUyMEZPUkVJR04lMjBLRVklMjAoZ2VucmVfaWQpJTIwUkVGRVJFTkNFUyUyMGdlbnJlKGlkKSU1Q24pJTNCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ1JFQVRFJTIwVEFCTEUlMjBnYW1lX3B1Ymxpc2hlciUyMCglNUNuJTVDdGlkJTIwSU5URUdFUiUyMFBSSU1BUlklMjBLRVklMkMlNUNuJTVDdGdhbWVfaWQlMjBJTlRFR0VSJTIwREVGQVVMVCUyME5VTEwlMkMlNUNuJTVDdHB1Ymxpc2hlcl9pZCUyMElOVEVHRVIlMjBERUZBVUxUJTIwTlVMTCUyQyU1Q24lNUN0Q09OU1RSQUlOVCUyMGZrX2dwdV9nYW0lMjBGT1JFSUdOJTIwS0VZJTIwKGdhbWVfaWQpJTIwUkVGRVJFTkNFUyUyMGdhbWUoaWQpJTJDJTVDbiU1Q3RDT05TVFJBSU5UJTIwZmtfZ3B1X3B1YiUyMEZPUkVJR04lMjBLRVklMjAocHVibGlzaGVyX2lkKSUyMFJFRkVSRU5DRVMlMjBwdWJsaXNoZXIoaWQpJTVDbiklM0IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDUkVBVEUlMjBUQUJMRSUyMGdhbWVfcGxhdGZvcm0lMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RnYW1lX3B1Ymxpc2hlcl9pZCUyMElOVEVHRVIlMjBERUZBVUxUJTIwTlVMTCUyQyU1Q24lNUN0cGxhdGZvcm1faWQlMjBJTlRFR0VSJTIwREVGQVVMVCUyME5VTEwlMkMlNUNuJTVDdHJlbGVhc2VfeWVhciUyMElOVEVHRVIlMjBERUZBVUxUJTIwTlVMTCUyQyU1Q24lNUN0Q09OU1RSQUlOVCUyMGZrX2dwbF9ncCUyMEZPUkVJR04lMjBLRVklMjAoZ2FtZV9wdWJsaXNoZXJfaWQpJTIwUkVGRVJFTkNFUyUyMGdhbWVfcHVibGlzaGVyKGlkKSUyQyU1Q24lNUN0Q09OU1RSQUlOVCUyMGZrX2dwbF9wbGElMjBGT1JFSUdOJTIwS0VZJTIwKHBsYXRmb3JtX2lkKSUyMFJFRkVSRU5DRVMlMjBwbGF0Zm9ybShpZCklNUNuKSUzQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNSRUFURSUyMFRBQkxFJTIwcmVnaW9uX3NhbGVzJTIwKCU1Q24lNUN0cmVnaW9uX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RnYW1lX3BsYXRmb3JtX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RudW1fc2FsZXMlMjBSRUFMJTJDJTVDbiUyMCUyMCUyMENPTlNUUkFJTlQlMjBma19yc19ncCUyMEZPUkVJR04lMjBLRVklMjAoZ2FtZV9wbGF0Zm9ybV9pZCklMjBSRUZFUkVOQ0VTJTIwZ2FtZV9wbGF0Zm9ybShpZCklMkMlNUNuJTVDdENPTlNUUkFJTlQlMjBma19yc19yZWclMjBGT1JFSUdOJTIwS0VZJTIwKHJlZ2lvbl9pZCklMjBSRUZFUkVOQ0VTJTIwcmVnaW9uKGlkKSU1Q24pJTNCJTIyJTJDJTBBJTVE",highlighted:`table_declarations = [
    <span class="hljs-string">&quot;CREATE TABLE platform (\\n\\tid INTEGER PRIMARY KEY,\\n\\tplatform_name TEXT DEFAULT NULL\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE genre (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgenre_name TEXT DEFAULT NULL\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE publisher (\\n\\tid INTEGER PRIMARY KEY,\\n\\tpublisher_name TEXT DEFAULT NULL\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE region (\\n\\tid INTEGER PRIMARY KEY,\\n\\tregion_name TEXT DEFAULT NULL\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE game (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgenre_id INTEGER,\\n\\tgame_name TEXT DEFAULT NULL,\\n\\tCONSTRAINT fk_gm_gen FOREIGN KEY (genre_id) REFERENCES genre(id)\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE game_publisher (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgame_id INTEGER DEFAULT NULL,\\n\\tpublisher_id INTEGER DEFAULT NULL,\\n\\tCONSTRAINT fk_gpu_gam FOREIGN KEY (game_id) REFERENCES game(id),\\n\\tCONSTRAINT fk_gpu_pub FOREIGN KEY (publisher_id) REFERENCES publisher(id)\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE game_platform (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgame_publisher_id INTEGER DEFAULT NULL,\\n\\tplatform_id INTEGER DEFAULT NULL,\\n\\trelease_year INTEGER DEFAULT NULL,\\n\\tCONSTRAINT fk_gpl_gp FOREIGN KEY (game_publisher_id) REFERENCES game_publisher(id),\\n\\tCONSTRAINT fk_gpl_pla FOREIGN KEY (platform_id) REFERENCES platform(id)\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE region_sales (\\n\\tregion_id INTEGER DEFAULT NULL,\\n\\tgame_platform_id INTEGER DEFAULT NULL,\\n\\tnum_sales REAL,\\n   CONSTRAINT fk_rs_gp FOREIGN KEY (game_platform_id) REFERENCES game_platform(id),\\n\\tCONSTRAINT fk_rs_reg FOREIGN KEY (region_id) REFERENCES region(id)\\n);&quot;</span>,
]`,wrap:!1}}),O=new w({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUdXBsZSUwQSUwQSUwQWRlZiUyMHJhbmtfdGFibGVzKHF1ZXJ5JTNBJTIwc3RyJTJDJTIwdGFibGVfc3BlY3MlM0ElMjBMaXN0JTVCc3RyJTVEJTJDJTIwdG9wX24lM0ElMjBpbnQlMjAlM0QlMjAwKSUyMC0lM0UlMjBMaXN0JTVCVHVwbGUlNUJmbG9hdCUyQyUyMHN0ciU1RCU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEdldCUyMHNvcnRlZCUyMHBhaXJzJTIwb2YlMjBzY29yZXMlMjBhbmQlMjB0YWJsZSUyMHNwZWNpZmljYXRpb25zJTJDJTIwdGhlbiUyMHJldHVybiUyMHRoZSUyMHRvcCUyME4lMkMlMEElMjAlMjAlMjAlMjBvciUyMGFsbCUyMGlmJTIwdG9wX24lMjBpcyUyMDAlMjBvciUyMGRlZmF1bHQuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcGFpcnMlMjAlM0QlMjAlNUIlNUJxdWVyeSUyQyUyMHRhYmxlX3NwZWMlNUQlMjBmb3IlMjB0YWJsZV9zcGVjJTIwaW4lMjB0YWJsZV9zcGVjcyU1RCUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMHJlcmFua2VyX21vZGVsLmNvbXB1dGVfc2NvcmUocGFpcnMpJTBBJTIwJTIwJTIwJTIwc2NvcmVkX3RhYmxlcyUyMCUzRCUyMCU1QihzY29yZSUyQyUyMHRhYmxlX3NwZWMpJTIwZm9yJTIwc2NvcmUlMkMlMjB0YWJsZV9zcGVjJTIwaW4lMjB6aXAoc2NvcmVzJTJDJTIwdGFibGVfc3BlY3MpJTVEJTBBJTIwJTIwJTIwJTIwc2NvcmVkX3RhYmxlcy5zb3J0KGtleSUzRGxhbWJkYSUyMHglM0ElMjB4JTVCMCU1RCUyQyUyMHJldmVyc2UlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9wX24lMjBhbmQlMjB0b3BfbiUyMCUzQyUyMGxlbihzY29yZWRfdGFibGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNjb3JlZF90YWJsZXMlNUIwJTNBdG9wX24lNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzY29yZWRfdGFibGVz",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">rank_tables</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span>, table_specs: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>], top_n: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span></span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">str</span>]]:
    <span class="hljs-string">&quot;&quot;&quot;
    Get sorted pairs of scores and table specifications, then return the top N,
    or all if top_n is 0 or default.
    &quot;&quot;&quot;</span>
    pairs = [[query, table_spec] <span class="hljs-keyword">for</span> table_spec <span class="hljs-keyword">in</span> table_specs]
    scores = reranker_model.compute_score(pairs)
    scored_tables = [(score, table_spec) <span class="hljs-keyword">for</span> score, table_spec <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(scores, table_specs)]
    scored_tables.sort(key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">0</span>], reverse=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">if</span> top_n <span class="hljs-keyword">and</span> top_n &lt; <span class="hljs-built_in">len</span>(scored_tables):
        <span class="hljs-keyword">return</span> scored_tables[<span class="hljs-number">0</span>:top_n]
    <span class="hljs-keyword">return</span> scored_tables`,wrap:!1}}),le=new w({props:{code:"dXNlcl9xdWVyeSUyMCUzRCUyMCUyMklkZW50aWZ5JTIwdGhlJTIwdG9wJTIwMTAlMjBwbGF0Zm9ybXMlMjBieSUyMHRvdGFsJTIwc2FsZXMuJTIy",highlighted:'user_query = <span class="hljs-string">&quot;Identify the top 10 platforms by total sales.&quot;</span>',wrap:!1}}),ae=new w({props:{code:"cmFua2VkX3RhYmxlcyUyMCUzRCUyMHJhbmtfdGFibGVzKHVzZXJfcXVlcnklMkMlMjB0YWJsZV9kZWNsYXJhdGlvbnMlMkMlMjB0b3BfbiUzRDMpJTBBcmFua2VkX3RhYmxlcw==",highlighted:`ranked_tables = rank_tables(user_query, table_declarations, top_n=<span class="hljs-number">3</span>)
ranked_tables`,wrap:!1}}),ie=new b({props:{title:"Using Mistral Instruct to Generate SQL",local:"using-mistral-instruct-to-generate-sql",headingTag:"h2"}}),oe=new w({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBQcm9tcHRUZW1wbGF0ZSUwQSUwQW1ha2Vfc3FsX3Byb21wdF90bXBsX3RleHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFHZW5lcmF0ZSUyMGElMjBTUUwlMjBxdWVyeSUyMHRvJTIwYW5zd2VyJTIwdGhlJTIwZm9sbG93aW5nJTIwcXVlc3Rpb24lMjBmcm9tJTIwdGhlJTIwdXNlciUzQSUwQSU1QyUyMiU3QnF1ZXJ5X3N0ciU3RCU1QyUyMiUwQSUwQVRoZSUyMFNRTCUyMHF1ZXJ5JTIwc2hvdWxkJTIwdXNlJTIwb25seSUyMHRhYmxlcyUyMHdpdGglMjB0aGUlMjBmb2xsb3dpbmclMjBTUUwlMjBkZWZpbml0aW9ucyUzQSUwQSUwQVRhYmxlJTIwMSUzQSUwQSU3QnRhYmxlXzElN0QlMEElMEFUYWJsZSUyMDIlM0ElMEElN0J0YWJsZV8yJTdEJTBBJTBBVGFibGUlMjAzJTNBJTBBJTdCdGFibGVfMyU3RCUwQSUwQU1ha2UlMjBzdXJlJTIweW91JTIwT05MWSUyMG91dHB1dCUyMGFuJTIwU1FMJTIwcXVlcnklMjBhbmQlMjBubyUyMGV4cGxhbmF0aW9uLiUwQSUyMiUyMiUyMiUwQW1ha2Vfc3FsX3Byb21wdF90bXBsJTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUobWFrZV9zcWxfcHJvbXB0X3RtcGxfdGV4dCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> PromptTemplate

make_sql_prompt_tmpl_text = <span class="hljs-string">&quot;&quot;&quot;
Generate a SQL query to answer the following question from the user:
\\&quot;{query_str}\\&quot;

The SQL query should use only tables with the following SQL definitions:

Table 1:
{table_1}

Table 2:
{table_2}

Table 3:
{table_3}

Make sure you ONLY output an SQL query and no explanation.
&quot;&quot;&quot;</span>
make_sql_prompt_tmpl = PromptTemplate(make_sql_prompt_tmpl_text)`,wrap:!1}}),me=new w({props:{code:"bWFrZV9zcWxfcHJvbXB0JTIwJTNEJTIwbWFrZV9zcWxfcHJvbXB0X3RtcGwuZm9ybWF0KCUwQSUyMCUyMCUyMCUyMHF1ZXJ5X3N0ciUzRHVzZXJfcXVlcnklMkMlMjB0YWJsZV8xJTNEcmFua2VkX3RhYmxlcyU1QjAlNUQlNUIxJTVEJTJDJTIwdGFibGVfMiUzRHJhbmtlZF90YWJsZXMlNUIxJTVEJTVCMSU1RCUyQyUyMHRhYmxlXzMlM0RyYW5rZWRfdGFibGVzJTVCMiU1RCU1QjElNUQlMEEp",highlighted:`make_sql_prompt = make_sql_prompt_tmpl.<span class="hljs-built_in">format</span>(
    query_str=user_query, table_1=ranked_tables[<span class="hljs-number">0</span>][<span class="hljs-number">1</span>], table_2=ranked_tables[<span class="hljs-number">1</span>][<span class="hljs-number">1</span>], table_3=ranked_tables[<span class="hljs-number">2</span>][<span class="hljs-number">1</span>]
)`,wrap:!1}}),ue=new w({props:{code:"cHJpbnQobWFrZV9zcWxfcHJvbXB0KQ==",highlighted:'<span class="hljs-built_in">print</span>(make_sql_prompt)',wrap:!1}}),we=new w({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBtaXN0cmFsX2xsbS5jb21wbGV0ZShtYWtlX3NxbF9wcm9tcHQpJTBBc3FsX3F1ZXJ5JTIwJTNEJTIwc3RyKHJlc3BvbnNlKSUwQXByaW50KHNxbF9xdWVyeSk=",highlighted:`response = mistral_llm.complete(make_sql_prompt)
sql_query = <span class="hljs-built_in">str</span>(response)
<span class="hljs-built_in">print</span>(sql_query)`,wrap:!1}}),ce=new b({props:{title:"Running the SQL query",local:"running-the-sql-query",headingTag:"h2"}}),de=new w({props:{code:"aW1wb3J0JTIwc3FsaXRlMyUwQSUwQWNvbiUyMCUzRCUyMHNxbGl0ZTMuY29ubmVjdCglMjJ2aWRlb2dhbWVzLmRiJTIyKSUwQWN1ciUyMCUzRCUyMGNvbi5jdXJzb3IoKSUwQXNxbF9yZXNwb25zZSUyMCUzRCUyMGN1ci5leGVjdXRlKHNxbF9xdWVyeSkuZmV0Y2hhbGwoKQ==",highlighted:`<span class="hljs-keyword">import</span> sqlite3

con = sqlite3.connect(<span class="hljs-string">&quot;videogames.db&quot;</span>)
cur = con.cursor()
sql_response = cur.execute(sql_query).fetchall()`,wrap:!1}}),he=new w({props:{code:"c3FsX3Jlc3BvbnNl",highlighted:"sql_response",wrap:!1}}),je=new b({props:{title:"Getting a Natural Language Answer",local:"getting-a-natural-language-answer",headingTag:"h2"}}),Ve=new w({props:{code:"cmFnX3Byb21wdF90bXBsX3N0ciUyMCUzRCUyMCUyMiUyMiUyMiUwQVVzZSUyMHRoZSUyMGluZm9ybWF0aW9uJTIwaW4lMjB0aGUlMjBKU09OJTIwdGFibGUlMjB0byUyMGFuc3dlciUyMHRoZSUyMGZvbGxvd2luZyUyMHVzZXIlMjBxdWVyeS4lMEFEbyUyMG5vdCUyMGV4cGxhaW4lMjBhbnl0aGluZyUyQyUyMGp1c3QlMjBhbnN3ZXIlMjBjb25jaXNlbHkuJTIwVXNlJTIwbmF0dXJhbCUyMGxhbmd1YWdlJTIwaW4lMjB5b3VyJTBBYW5zd2VyJTJDJTIwbm90JTIwY29tcHV0ZXIlMjBmb3JtYXR0aW5nLiUwQSUwQVVTRVIlMjBRVUVSWSUzQSUyMCU3QnF1ZXJ5X3N0ciU3RCUwQSUwQUpTT04lMjB0YWJsZSUzQSUwQSU3Qmpzb25fdGFibGUlN0QlMEElMEFUaGlzJTIwdGFibGUlMjB3YXMlMjBnZW5lcmF0ZWQlMjBieSUyMHRoZSUyMGZvbGxvd2luZyUyMFNRTCUyMHF1ZXJ5JTNBJTBBJTdCc3FsX3F1ZXJ5JTdEJTBBJTBBQW5zd2VyJTIwT05MWSUyMHVzaW5nJTIwdGhlJTIwaW5mb3JtYXRpb24lMjBpbiUyMHRoZSUyMHRhYmxlJTIwYW5kJTIwdGhlJTIwU1FMJTIwcXVlcnklMkMlMjBhbmQlMjBpZiUyMHRoZSUwQXRhYmxlJTIwZG9lcyUyMG5vdCUyMHByb3ZpZGUlMjB0aGUlMjBpbmZvcm1hdGlvbiUyMHRvJTIwYW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMkMlMjBhbnN3ZXIlMEElMjJObyUyMEluZm9ybWF0aW9uJTIyLiUwQSUyMiUyMiUyMiUwQXJhZ19wcm9tcHRfdG1wbCUyMCUzRCUyMFByb21wdFRlbXBsYXRlKHJhZ19wcm9tcHRfdG1wbF9zdHIp",highlighted:`rag_prompt_tmpl_str = <span class="hljs-string">&quot;&quot;&quot;
Use the information in the JSON table to answer the following user query.
Do not explain anything, just answer concisely. Use natural language in your
answer, not computer formatting.

USER QUERY: {query_str}

JSON table:
{json_table}

This table was generated by the following SQL query:
{sql_query}

Answer ONLY using the information in the table and the SQL query, and if the
table does not provide the information to answer the question, answer
&quot;No Information&quot;.
&quot;&quot;&quot;</span>
rag_prompt_tmpl = PromptTemplate(rag_prompt_tmpl_str)`,wrap:!1}}),Re=new w({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXJhZ19wcm9tcHQlMjAlM0QlMjByYWdfcHJvbXB0X3RtcGwuZm9ybWF0KCUwQSUyMCUyMCUyMCUyMHF1ZXJ5X3N0ciUzRCUyMklkZW50aWZ5JTIwdGhlJTIwdG9wJTIwMTAlMjBwbGF0Zm9ybXMlMjBieSUyMHRvdGFsJTIwc2FsZXMlMjIlMkMlMjBqc29uX3RhYmxlJTNEanNvbi5kdW1wcyhzcWxfcmVzcG9uc2UpJTJDJTIwc3FsX3F1ZXJ5JTNEc3FsX3F1ZXJ5JTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> json

rag_prompt = rag_prompt_tmpl.<span class="hljs-built_in">format</span>(
    query_str=<span class="hljs-string">&quot;Identify the top 10 platforms by total sales&quot;</span>, json_table=json.dumps(sql_response), sql_query=sql_query
)`,wrap:!1}}),Be=new w({props:{code:"cmFnX3Jlc3BvbnNlJTIwJTNEJTIwbWlzdHJhbF9sbG0uY29tcGxldGUocmFnX3Byb21wdCklMEFwcmludChzdHIocmFnX3Jlc3BvbnNlKSk=",highlighted:`rag_response = mistral_llm.complete(rag_prompt)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">str</span>(rag_response))`,wrap:!1}}),_e=new b({props:{title:"Try it yourself",local:"try-it-yourself",headingTag:"h2"}}),Ne=new w({props:{code:"ZGVmJTIwYW5zd2VyX3NxbCh1c2VyX3F1ZXJ5JTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYW5rZWRfdGFibGVzJTIwJTNEJTIwcmFua190YWJsZXModXNlcl9xdWVyeSUyQyUyMHRhYmxlX2RlY2xhcmF0aW9ucyUyQyUyMHRvcF9uJTNEMyklMEElMjAlMjAlMjAlMjBleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyUmFua2luZyUyMGZhaWxlZC4lNUNuVXNlciUyMHF1ZXJ5JTNBJTVDbiU3QnVzZXJfcXVlcnklN0QlNUNuJTVDbiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMChlKSUwQSUwQSUyMCUyMCUyMCUyMG1ha2Vfc3FsX3Byb21wdCUyMCUzRCUyMG1ha2Vfc3FsX3Byb21wdF90bXBsLmZvcm1hdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeV9zdHIlM0R1c2VyX3F1ZXJ5JTJDJTIwdGFibGVfMSUzRHJhbmtlZF90YWJsZXMlNUIwJTVEJTVCMSU1RCUyQyUyMHRhYmxlXzIlM0RyYW5rZWRfdGFibGVzJTVCMSU1RCU1QjElNUQlMkMlMjB0YWJsZV8zJTNEcmFua2VkX3RhYmxlcyU1QjIlNUQlNUIxJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwbWlzdHJhbF9sbG0uY29tcGxldGUobWFrZV9zcWxfcHJvbXB0KSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJTUUwlMjBxdWVyeSUyMGdlbmVyYXRpb24lMjBmYWlsZWQlNUNuUHJvbXB0JTNBJTVDbiU3Qm1ha2Vfc3FsX3Byb21wdCU3RCU1Q24lNUNuJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwKGUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQmFja3NsYXNoJTIwcmVtb3ZhbCUyMGlzJTIwYSUyMG5lY2Vzc2FyeSUyMGhhY2slMjBiZWNhdXNlJTIwc29tZXRpbWVzJTIwTWlzdHJhbCUyMHB1dHMlMjB0aGVtJTBBJTIwJTIwJTIwJTIwJTIzJTIwaW4lMjBpdHMlMjBnZW5lcmF0ZWQlMjBjb2RlLiUwQSUyMCUyMCUyMCUyMHNxbF9xdWVyeSUyMCUzRCUyMHN0cihyZXNwb25zZSkucmVwbGFjZSglMjIlNUMlNUMlMjIlMkMlMjAlMjIlMjIpJTBBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3FsX3Jlc3BvbnNlJTIwJTNEJTIwc3FsaXRlMy5jb25uZWN0KCUyMnZpZGVvZ2FtZXMuZGIlMjIpLmN1cnNvcigpLmV4ZWN1dGUoc3FsX3F1ZXJ5KS5mZXRjaGFsbCgpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlNRTCUyMHF1ZXJ5aW5nJTIwZmFpbGVkLiUyMFF1ZXJ5JTNBJTVDbiU3QnNxbF9xdWVyeSU3RCU1Q24lNUNuJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwKGUpJTBBJTBBJTIwJTIwJTIwJTIwcmFnX3Byb21wdCUyMCUzRCUyMHJhZ19wcm9tcHRfdG1wbC5mb3JtYXQocXVlcnlfc3RyJTNEdXNlcl9xdWVyeSUyQyUyMGpzb25fdGFibGUlM0Rqc29uLmR1bXBzKHNxbF9yZXNwb25zZSklMkMlMjBzcWxfcXVlcnklM0RzcWxfcXVlcnkpJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFnX3Jlc3BvbnNlJTIwJTNEJTIwbWlzdHJhbF9sbG0uY29tcGxldGUocmFnX3Byb21wdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzdHIocmFnX3Jlc3BvbnNlKSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJBbnN3ZXIlMjBnZW5lcmF0aW9uJTIwZmFpbGVkLiUyMFByb21wdCUzQSU1Q24lN0JyYWdfcHJvbXB0JTdEJTVDbiU1Q24lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjAoZSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_sql</span>(<span class="hljs-params">user_query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">try</span>:
        ranked_tables = rank_tables(user_query, table_declarations, top_n=<span class="hljs-number">3</span>)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Ranking failed.\\nUser query:\\n<span class="hljs-subst">{user_query}</span>\\n\\n&quot;</span>)
        <span class="hljs-keyword">raise</span> (e)

    make_sql_prompt = make_sql_prompt_tmpl.<span class="hljs-built_in">format</span>(
        query_str=user_query, table_1=ranked_tables[<span class="hljs-number">0</span>][<span class="hljs-number">1</span>], table_2=ranked_tables[<span class="hljs-number">1</span>][<span class="hljs-number">1</span>], table_3=ranked_tables[<span class="hljs-number">2</span>][<span class="hljs-number">1</span>]
    )

    <span class="hljs-keyword">try</span>:
        response = mistral_llm.complete(make_sql_prompt)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SQL query generation failed\\nPrompt:\\n<span class="hljs-subst">{make_sql_prompt}</span>\\n\\n&quot;</span>)
        <span class="hljs-keyword">raise</span> (e)

    <span class="hljs-comment"># Backslash removal is a necessary hack because sometimes Mistral puts them</span>
    <span class="hljs-comment"># in its generated code.</span>
    sql_query = <span class="hljs-built_in">str</span>(response).replace(<span class="hljs-string">&quot;\\\\&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)

    <span class="hljs-keyword">try</span>:
        sql_response = sqlite3.connect(<span class="hljs-string">&quot;videogames.db&quot;</span>).cursor().execute(sql_query).fetchall()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SQL querying failed. Query:\\n<span class="hljs-subst">{sql_query}</span>\\n\\n&quot;</span>)
        <span class="hljs-keyword">raise</span> (e)

    rag_prompt = rag_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=user_query, json_table=json.dumps(sql_response), sql_query=sql_query)
    <span class="hljs-keyword">try</span>:
        rag_response = mistral_llm.complete(rag_prompt)
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(rag_response)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer generation failed. Prompt:\\n<span class="hljs-subst">{rag_prompt}</span>\\n\\n&quot;</span>)
        <span class="hljs-keyword">raise</span> (e)`,wrap:!1}}),Ze=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJJZGVudGlmeSUyMHRoZSUyMHRvcCUyMDEwJTIwcGxhdGZvcm1zJTIwYnklMjB0b3RhbCUyMHNhbGVzLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Identify the top 10 platforms by total sales.&quot;</span>))',wrap:!1}}),Se=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJTdW1tYXJpemUlMjBzYWxlcyUyMGJ5JTIwcmVnaW9uLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Summarize sales by region.&quot;</span>))',wrap:!1}}),xe=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJMaXN0JTIwdGhlJTIwcHVibGlzaGVyJTIwd2l0aCUyMHRoZSUyMGxhcmdlc3QlMjBudW1iZXIlMjBvZiUyMHB1Ymxpc2hlZCUyMGdhbWVzLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;List the publisher with the largest number of published games.&quot;</span>))',wrap:!1}}),Qe=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJEaXNwbGF5JTIwdGhlJTIweWVhciUyMHdpdGglMjBtb3N0JTIwZ2FtZXMlMjByZWxlYXNlZC4lMjIpKQ==",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Display the year with most games released.&quot;</span>))',wrap:!1}}),ve=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJXaGF0JTIwaXMlMjB0aGUlMjBtb3N0JTIwcG9wdWxhciUyMGdhbWUlMjBnZW5yZSUyMG9uJTIwdGhlJTIwV2lpJTIwcGxhdGZvcm0lM0YlMjIpKQ==",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;What is the most popular game genre on the Wii platform?&quot;</span>))',wrap:!1}}),We=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJXaGF0JTIwaXMlMjB0aGUlMjBtb3N0JTIwcG9wdWxhciUyMGdhbWUlMjBnZW5yZSUyMG9mJTIwMjAxMiUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;What is the most popular game genre of 2012?&quot;</span>))',wrap:!1}}),qe=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjIlM0NJTlNFUlQlMjBRVUVTVElPTiUyME9SJTIwSU5TVFJVQ1RJT04lMjBIRVJFJTNFJTIyKSk=",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;&lt;INSERT QUESTION OR INSTRUCTION HERE&gt;&quot;</span>))',wrap:!1}}),He=new b({props:{title:"Review and Conclusions",local:"review-and-conclusions",headingTag:"h2"}}),De=new Ns({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_sql_reranker.md"}}),{c(){c=i("meta"),J=a(),d=i("p"),Ke=a(),p(h.$$.fragment),tt=a(),p(f.$$.fragment),lt=a(),j=i("p"),j.innerHTML=Nl,st=a(),g=i("p"),g.textContent=El,at=a(),p(I.$$.fragment),nt=a(),V=i("ul"),V.innerHTML=Zl,it=a(),p(C.$$.fragment),rt=a(),$=i("p"),$.innerHTML=Fl,pt=a(),p(R.$$.fragment),ot=a(),k=i("p"),k.innerHTML=Sl,Mt=a(),B=i("p"),B.innerHTML=xl,mt=a(),p(T.$$.fragment),Ut=a(),p(_.$$.fragment),ut=a(),p(G.$$.fragment),yt=a(),N=i("p"),N.textContent=Ql,wt=a(),p(E.$$.fragment),ct=a(),p(Z.$$.fragment),bt=a(),F=i("p"),F.innerHTML=vl,dt=a(),p(S.$$.fragment),Tt=a(),p(x.$$.fragment),Jt=a(),Q=i("p"),Q.innerHTML=Wl,ht=a(),p(v.$$.fragment),ft=a(),p(W.$$.fragment),jt=a(),X=i("p"),X.innerHTML=Xl,gt=a(),q=i("p"),q.innerHTML=ql,It=a(),H=i("p"),H.textContent=Hl,Vt=a(),p(Y.$$.fragment),Ct=a(),L=i("p"),L.innerHTML=Yl,$t=a(),p(A.$$.fragment),Rt=a(),p(z.$$.fragment),kt=a(),P=i("p"),P.innerHTML=Ll,Bt=a(),p(D.$$.fragment),_t=a(),K=i("p"),K.textContent=Al,Gt=a(),p(O.$$.fragment),Nt=a(),ee=i("p"),ee.innerHTML=zl,Et=a(),te=i("p"),te.textContent=Pl,Zt=a(),p(le.$$.fragment),Ft=a(),se=i("p"),se.innerHTML=Dl,St=a(),p(ae.$$.fragment),xt=a(),ne=i("p"),ne.innerHTML=Kl,Qt=a(),p(ie.$$.fragment),vt=a(),re=i("p"),re.textContent=Ol,Wt=a(),pe=i("p"),pe.innerHTML=es,Xt=a(),p(oe.$$.fragment),qt=a(),Me=i("p"),Me.innerHTML=ts,Ht=a(),p(me.$$.fragment),Yt=a(),Ue=i("p"),Ue.textContent=ls,Lt=a(),p(ue.$$.fragment),At=a(),ye=i("p"),ye.textContent=ss,zt=a(),p(we.$$.fragment),Pt=a(),p(ce.$$.fragment),Dt=a(),be=i("p"),be.innerHTML=as,Kt=a(),p(de.$$.fragment),Ot=a(),Te=i("p"),Te.innerHTML=ns,el=a(),Je=i("p"),Je.textContent=is,tl=a(),p(he.$$.fragment),ll=a(),fe=i("p"),fe.textContent=rs,sl=a(),p(je.$$.fragment),al=a(),ge=i("p"),ge.textContent=ps,nl=a(),Ie=i("p"),Ie.textContent=os,il=a(),p(Ve.$$.fragment),rl=a(),Ce=i("p"),Ce.textContent=Ms,pl=a(),$e=i("p"),$e.textContent=ms,ol=a(),p(Re.$$.fragment),Ml=a(),ke=i("p"),ke.textContent=Us,ml=a(),p(Be.$$.fragment),Ul=a(),p(_e.$$.fragment),ul=a(),Ge=i("p"),Ge.textContent=us,yl=a(),p(Ne.$$.fragment),wl=a(),Ee=i("p"),Ee.textContent=ys,cl=a(),p(Ze.$$.fragment),bl=a(),Fe=i("p"),Fe.textContent=ws,dl=a(),p(Se.$$.fragment),Tl=a(),p(xe.$$.fragment),Jl=a(),p(Qe.$$.fragment),hl=a(),p(ve.$$.fragment),fl=a(),p(We.$$.fragment),jl=a(),Xe=i("p"),Xe.textContent=cs,gl=a(),p(qe.$$.fragment),Il=a(),p(He.$$.fragment),Vl=a(),Ye=i("p"),Ye.textContent=bs,Cl=a(),Le=i("p"),Le.textContent=ds,$l=a(),Ae=i("p"),Ae.textContent=Ts,Rl=a(),ze=i("p"),ze.textContent=Js,kl=a(),Pe=i("p"),Pe.textContent=hs,Bl=a(),p(De.$$.fragment),_l=a(),Oe=i("p"),this.h()},l(e){const t=ks("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(l),J=n(e),d=r(e,"P",{}),js(d).forEach(l),Ke=n(e),o(h.$$.fragment,e),tt=n(e),o(f.$$.fragment,e),lt=n(e),j=r(e,"P",{"data-svelte-h":!0}),y(j)!=="svelte-15h4oc6"&&(j.innerHTML=Nl),st=n(e),g=r(e,"P",{"data-svelte-h":!0}),y(g)!=="svelte-igm0s6"&&(g.textContent=El),at=n(e),o(I.$$.fragment,e),nt=n(e),V=r(e,"UL",{"data-svelte-h":!0}),y(V)!=="svelte-1xkzjuz"&&(V.innerHTML=Zl),it=n(e),o(C.$$.fragment,e),rt=n(e),$=r(e,"P",{"data-svelte-h":!0}),y($)!=="svelte-qg7j5l"&&($.innerHTML=Fl),pt=n(e),o(R.$$.fragment,e),ot=n(e),k=r(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-tat797"&&(k.innerHTML=Sl),Mt=n(e),B=r(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1ddj9ti"&&(B.innerHTML=xl),mt=n(e),o(T.$$.fragment,e),Ut=n(e),o(_.$$.fragment,e),ut=n(e),o(G.$$.fragment,e),yt=n(e),N=r(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-u4asgs"&&(N.textContent=Ql),wt=n(e),o(E.$$.fragment,e),ct=n(e),o(Z.$$.fragment,e),bt=n(e),F=r(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-12d1e2b"&&(F.innerHTML=vl),dt=n(e),o(S.$$.fragment,e),Tt=n(e),o(x.$$.fragment,e),Jt=n(e),Q=r(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-w1clkv"&&(Q.innerHTML=Wl),ht=n(e),o(v.$$.fragment,e),ft=n(e),o(W.$$.fragment,e),jt=n(e),X=r(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-14xvb0y"&&(X.innerHTML=Xl),gt=n(e),q=r(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-1slmc83"&&(q.innerHTML=ql),It=n(e),H=r(e,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1fwr6sh"&&(H.textContent=Hl),Vt=n(e),o(Y.$$.fragment,e),Ct=n(e),L=r(e,"P",{"data-svelte-h":!0}),y(L)!=="svelte-1w3cr3e"&&(L.innerHTML=Yl),$t=n(e),o(A.$$.fragment,e),Rt=n(e),o(z.$$.fragment,e),kt=n(e),P=r(e,"P",{"data-svelte-h":!0}),y(P)!=="svelte-71eio4"&&(P.innerHTML=Ll),Bt=n(e),o(D.$$.fragment,e),_t=n(e),K=r(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-1twv85s"&&(K.textContent=Al),Gt=n(e),o(O.$$.fragment,e),Nt=n(e),ee=r(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-o4furo"&&(ee.innerHTML=zl),Et=n(e),te=r(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-pvuljo"&&(te.textContent=Pl),Zt=n(e),o(le.$$.fragment,e),Ft=n(e),se=r(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-19tx4wc"&&(se.innerHTML=Dl),St=n(e),o(ae.$$.fragment,e),xt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-t2kwnd"&&(ne.innerHTML=Kl),Qt=n(e),o(ie.$$.fragment,e),vt=n(e),re=r(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-gjatd0"&&(re.textContent=Ol),Wt=n(e),pe=r(e,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-ia63v2"&&(pe.innerHTML=es),Xt=n(e),o(oe.$$.fragment,e),qt=n(e),Me=r(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-1sgset9"&&(Me.innerHTML=ts),Ht=n(e),o(me.$$.fragment,e),Yt=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),y(Ue)!=="svelte-1ylx49h"&&(Ue.textContent=ls),Lt=n(e),o(ue.$$.fragment,e),At=n(e),ye=r(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-22s8s7"&&(ye.textContent=ss),zt=n(e),o(we.$$.fragment,e),Pt=n(e),o(ce.$$.fragment,e),Dt=n(e),be=r(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1difuxa"&&(be.innerHTML=as),Kt=n(e),o(de.$$.fragment,e),Ot=n(e),Te=r(e,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-1kju3zy"&&(Te.innerHTML=ns),el=n(e),Je=r(e,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-1mogpba"&&(Je.textContent=is),tl=n(e),o(he.$$.fragment,e),ll=n(e),fe=r(e,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-1q6p39s"&&(fe.textContent=rs),sl=n(e),o(je.$$.fragment,e),al=n(e),ge=r(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-oj1hte"&&(ge.textContent=ps),nl=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-1p8oufy"&&(Ie.textContent=os),il=n(e),o(Ve.$$.fragment,e),rl=n(e),Ce=r(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-1ugt2d7"&&(Ce.textContent=Ms),pl=n(e),$e=r(e,"P",{"data-svelte-h":!0}),y($e)!=="svelte-83tbvg"&&($e.textContent=ms),ol=n(e),o(Re.$$.fragment,e),Ml=n(e),ke=r(e,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-1k3bapg"&&(ke.textContent=Us),ml=n(e),o(Be.$$.fragment,e),Ul=n(e),o(_e.$$.fragment,e),ul=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-k87ysy"&&(Ge.textContent=us),yl=n(e),o(Ne.$$.fragment,e),wl=n(e),Ee=r(e,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-1de9wqs"&&(Ee.textContent=ys),cl=n(e),o(Ze.$$.fragment,e),bl=n(e),Fe=r(e,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-1xk2uad"&&(Fe.textContent=ws),dl=n(e),o(Se.$$.fragment,e),Tl=n(e),o(xe.$$.fragment,e),Jl=n(e),o(Qe.$$.fragment,e),hl=n(e),o(ve.$$.fragment,e),fl=n(e),o(We.$$.fragment,e),jl=n(e),Xe=r(e,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-o0veke"&&(Xe.textContent=cs),gl=n(e),o(qe.$$.fragment,e),Il=n(e),o(He.$$.fragment,e),Vl=n(e),Ye=r(e,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-14toh4c"&&(Ye.textContent=bs),Cl=n(e),Le=r(e,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-am4n5q"&&(Le.textContent=ds),$l=n(e),Ae=r(e,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-1b0e8j0"&&(Ae.textContent=Ts),Rl=n(e),ze=r(e,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-1cmyhxx"&&(ze.textContent=Js),kl=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),y(Pe)!=="svelte-1t5qd6f"&&(Pe.textContent=hs),Bl=n(e),o(De.$$.fragment,e),_l=n(e),Oe=r(e,"P",{}),js(Oe).forEach(l),this.h()},h(){gs(c,"name","hf:doc:metadata"),gs(c,"content",Fs)},m(e,t){Bs(document.head,c),s(e,J,t),s(e,d,t),s(e,Ke,t),M(h,e,t),s(e,tt,t),M(f,e,t),s(e,lt,t),s(e,j,t),s(e,st,t),s(e,g,t),s(e,at,t),M(I,e,t),s(e,nt,t),s(e,V,t),s(e,it,t),M(C,e,t),s(e,rt,t),s(e,$,t),s(e,pt,t),M(R,e,t),s(e,ot,t),s(e,k,t),s(e,Mt,t),s(e,B,t),s(e,mt,t),M(T,e,t),s(e,Ut,t),M(_,e,t),s(e,ut,t),M(G,e,t),s(e,yt,t),s(e,N,t),s(e,wt,t),M(E,e,t),s(e,ct,t),M(Z,e,t),s(e,bt,t),s(e,F,t),s(e,dt,t),M(S,e,t),s(e,Tt,t),M(x,e,t),s(e,Jt,t),s(e,Q,t),s(e,ht,t),M(v,e,t),s(e,ft,t),M(W,e,t),s(e,jt,t),s(e,X,t),s(e,gt,t),s(e,q,t),s(e,It,t),s(e,H,t),s(e,Vt,t),M(Y,e,t),s(e,Ct,t),s(e,L,t),s(e,$t,t),M(A,e,t),s(e,Rt,t),M(z,e,t),s(e,kt,t),s(e,P,t),s(e,Bt,t),M(D,e,t),s(e,_t,t),s(e,K,t),s(e,Gt,t),M(O,e,t),s(e,Nt,t),s(e,ee,t),s(e,Et,t),s(e,te,t),s(e,Zt,t),M(le,e,t),s(e,Ft,t),s(e,se,t),s(e,St,t),M(ae,e,t),s(e,xt,t),s(e,ne,t),s(e,Qt,t),M(ie,e,t),s(e,vt,t),s(e,re,t),s(e,Wt,t),s(e,pe,t),s(e,Xt,t),M(oe,e,t),s(e,qt,t),s(e,Me,t),s(e,Ht,t),M(me,e,t),s(e,Yt,t),s(e,Ue,t),s(e,Lt,t),M(ue,e,t),s(e,At,t),s(e,ye,t),s(e,zt,t),M(we,e,t),s(e,Pt,t),M(ce,e,t),s(e,Dt,t),s(e,be,t),s(e,Kt,t),M(de,e,t),s(e,Ot,t),s(e,Te,t),s(e,el,t),s(e,Je,t),s(e,tl,t),M(he,e,t),s(e,ll,t),s(e,fe,t),s(e,sl,t),M(je,e,t),s(e,al,t),s(e,ge,t),s(e,nl,t),s(e,Ie,t),s(e,il,t),M(Ve,e,t),s(e,rl,t),s(e,Ce,t),s(e,pl,t),s(e,$e,t),s(e,ol,t),M(Re,e,t),s(e,Ml,t),s(e,ke,t),s(e,ml,t),M(Be,e,t),s(e,Ul,t),M(_e,e,t),s(e,ul,t),s(e,Ge,t),s(e,yl,t),M(Ne,e,t),s(e,wl,t),s(e,Ee,t),s(e,cl,t),M(Ze,e,t),s(e,bl,t),s(e,Fe,t),s(e,dl,t),M(Se,e,t),s(e,Tl,t),M(xe,e,t),s(e,Jl,t),M(Qe,e,t),s(e,hl,t),M(ve,e,t),s(e,fl,t),M(We,e,t),s(e,jl,t),s(e,Xe,t),s(e,gl,t),M(qe,e,t),s(e,Il,t),M(He,e,t),s(e,Vl,t),s(e,Ye,t),s(e,Cl,t),s(e,Le,t),s(e,$l,t),s(e,Ae,t),s(e,Rl,t),s(e,ze,t),s(e,kl,t),s(e,Pe,t),s(e,Bl,t),M(De,e,t),s(e,_l,t),s(e,Oe,t),Gl=!0},p(e,[t]){const fs={};t&2&&(fs.$$scope={dirty:t,ctx:e}),T.$set(fs)},i(e){Gl||(m(h.$$.fragment,e),m(f.$$.fragment,e),m(I.$$.fragment,e),m(C.$$.fragment,e),m(R.$$.fragment,e),m(T.$$.fragment,e),m(_.$$.fragment,e),m(G.$$.fragment,e),m(E.$$.fragment,e),m(Z.$$.fragment,e),m(S.$$.fragment,e),m(x.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m(Y.$$.fragment,e),m(A.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(we.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(je.$$.fragment,e),m(Ve.$$.fragment,e),m(Re.$$.fragment,e),m(Be.$$.fragment,e),m(_e.$$.fragment,e),m(Ne.$$.fragment,e),m(Ze.$$.fragment,e),m(Se.$$.fragment,e),m(xe.$$.fragment,e),m(Qe.$$.fragment,e),m(ve.$$.fragment,e),m(We.$$.fragment,e),m(qe.$$.fragment,e),m(He.$$.fragment,e),m(De.$$.fragment,e),Gl=!0)},o(e){U(h.$$.fragment,e),U(f.$$.fragment,e),U(I.$$.fragment,e),U(C.$$.fragment,e),U(R.$$.fragment,e),U(T.$$.fragment,e),U(_.$$.fragment,e),U(G.$$.fragment,e),U(E.$$.fragment,e),U(Z.$$.fragment,e),U(S.$$.fragment,e),U(x.$$.fragment,e),U(v.$$.fragment,e),U(W.$$.fragment,e),U(Y.$$.fragment,e),U(A.$$.fragment,e),U(z.$$.fragment,e),U(D.$$.fragment,e),U(O.$$.fragment,e),U(le.$$.fragment,e),U(ae.$$.fragment,e),U(ie.$$.fragment,e),U(oe.$$.fragment,e),U(me.$$.fragment,e),U(ue.$$.fragment,e),U(we.$$.fragment,e),U(ce.$$.fragment,e),U(de.$$.fragment,e),U(he.$$.fragment,e),U(je.$$.fragment,e),U(Ve.$$.fragment,e),U(Re.$$.fragment,e),U(Be.$$.fragment,e),U(_e.$$.fragment,e),U(Ne.$$.fragment,e),U(Ze.$$.fragment,e),U(Se.$$.fragment,e),U(xe.$$.fragment,e),U(Qe.$$.fragment,e),U(ve.$$.fragment,e),U(We.$$.fragment,e),U(qe.$$.fragment,e),U(He.$$.fragment,e),U(De.$$.fragment,e),Gl=!1},d(e){e&&(l(J),l(d),l(Ke),l(tt),l(lt),l(j),l(st),l(g),l(at),l(nt),l(V),l(it),l(rt),l($),l(pt),l(ot),l(k),l(Mt),l(B),l(mt),l(Ut),l(ut),l(yt),l(N),l(wt),l(ct),l(bt),l(F),l(dt),l(Tt),l(Jt),l(Q),l(ht),l(ft),l(jt),l(X),l(gt),l(q),l(It),l(H),l(Vt),l(Ct),l(L),l($t),l(Rt),l(kt),l(P),l(Bt),l(_t),l(K),l(Gt),l(Nt),l(ee),l(Et),l(te),l(Zt),l(Ft),l(se),l(St),l(xt),l(ne),l(Qt),l(vt),l(re),l(Wt),l(pe),l(Xt),l(qt),l(Me),l(Ht),l(Yt),l(Ue),l(Lt),l(At),l(ye),l(zt),l(Pt),l(Dt),l(be),l(Kt),l(Ot),l(Te),l(el),l(Je),l(tl),l(ll),l(fe),l(sl),l(al),l(ge),l(nl),l(Ie),l(il),l(rl),l(Ce),l(pl),l($e),l(ol),l(Ml),l(ke),l(ml),l(Ul),l(ul),l(Ge),l(yl),l(wl),l(Ee),l(cl),l(bl),l(Fe),l(dl),l(Tl),l(Jl),l(hl),l(fl),l(jl),l(Xe),l(gl),l(Il),l(Vl),l(Ye),l(Cl),l(Le),l($l),l(Ae),l(Rl),l(ze),l(kl),l(Pe),l(Bl),l(_l),l(Oe)),l(c),u(h,e),u(f,e),u(I,e),u(C,e),u(R,e),u(T,e),u(_,e),u(G,e),u(E,e),u(Z,e),u(S,e),u(x,e),u(v,e),u(W,e),u(Y,e),u(A,e),u(z,e),u(D,e),u(O,e),u(le,e),u(ae,e),u(ie,e),u(oe,e),u(me,e),u(ue,e),u(we,e),u(ce,e),u(de,e),u(he,e),u(je,e),u(Ve,e),u(Re,e),u(Be,e),u(_e,e),u(Ne,e),u(Ze,e),u(Se,e),u(xe,e),u(Qe,e),u(ve,e),u(We,e),u(qe,e),u(He,e),u(De,e)}}}const Fs='{"title":"RAG backed by SQL and Jina Reranker v2","local":"rag-backed-by-sql-and-jina-reranker-v2","sections":[{"title":"How it Works","local":"how-it-works","sections":[],"depth":3},{"title":"The Database","local":"the-database","sections":[],"depth":3},{"title":"Software and Hardware Requirements","local":"software-and-hardware-requirements","sections":[],"depth":3},{"title":"Setting Up","local":"setting-up","sections":[{"title":"Install Requirements","local":"install-requirements","sections":[],"depth":3},{"title":"Download the Database","local":"download-the-database","sections":[],"depth":3},{"title":"Download and Run Jina Reranker v2","local":"download-and-run-jina-reranker-v2","sections":[],"depth":3},{"title":"Set up the Interface to Mistral Instruct","local":"set-up-the-interface-to-mistral-instruct","sections":[],"depth":3}],"depth":2},{"title":"Using SQL-Aware Jina Reranker v2","local":"using-sql-aware-jina-reranker-v2","sections":[],"depth":2},{"title":"Using Mistral Instruct to Generate SQL","local":"using-mistral-instruct-to-generate-sql","sections":[],"depth":2},{"title":"Running the SQL query","local":"running-the-sql-query","sections":[],"depth":2},{"title":"Getting a Natural Language Answer","local":"getting-a-natural-language-answer","sections":[],"depth":2},{"title":"Try it yourself","local":"try-it-yourself","sections":[],"depth":2},{"title":"Review and Conclusions","local":"review-and-conclusions","sections":[],"depth":2}],"depth":1}';function Ss(et){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qs extends $s{constructor(c){super(),Rs(this,c,Ss,Zs,Is,{})}}export{qs as component};
