import{s as ns,n as is,o as os}from"../chunks/scheduler.65852ee5.js";import{S as ps,i as rs,g as i,s as a,r,A as cs,h as o,f as s,c as n,j as ls,u as c,x as p,k as as,y as ms,a as l,v as m,d as h,t as M,w as y}from"../chunks/index.65a1b999.js";import{D as hs,C as j}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as u,E as Ms}from"../chunks/getInferenceSnippets.0c19d6f8.js";function ys(Ct){let T,ge,de,Ue,J,fe,d,Ie,w,bt='<em>Authored by: <a href="https://github.com/leemthompo" rel="nofollow">Liam Thompson</a></em>',Ce,g,vt="In this notebook we will learn how to implement semantic reranking in Elasticsearch by uploading a model from Hugging Face into an Elasticsearch cluster. We’ll use the <code>retriever</code> abstraction, a simpler Elasticsearch syntax for crafting queries and combining different search operations.",be,U,qt="You will:",ve,f,At='<li>Choose a cross-encoder model from Hugging Face to perform semantic reranking</li> <li>Upload the model to your Elasticsearch deployment using <a href="https://www.elastic.co/guide/en/elasticsearch/client/eland/current/machine-learning.html" rel="nofollow">Eland</a>— a Python client for machine learning with Elasticsearch</li> <li>Create an inference endpoint to manage your <code>rerank</code> task</li> <li>Query your data using the <code>text_similarity_rerank</code> retriever</li>',qe,I,Ae,C,$t="For this example, you will need:",$e,b,xt='<li>An Elastic deployment on version 8.15.0 or above (for non-serverless deployments)<ul><li>We’ll be using Elastic Cloud for this example (available with a <a href="https://cloud.elastic.co/registration" rel="nofollow">free trial</a>).</li> <li>See our other <a href="https://www.elastic.co/guide/en/elasticsearch/reference/current/elasticsearch-intro.html#elasticsearch-intro-deploy" rel="nofollow">deployment options</a></li></ul></li> <li>You’ll need to find your deployment’s Cloud ID and create an API key. <a href="https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#finding-your-cloud-id" rel="nofollow">Learn more</a>.</li>',xe,v,ke,q,kt="ℹ️ The <code>eland</code> installation will take a couple of minutes.",Ee,A,Be,$,Ge,x,Et="First you need to connect to your Elasticsearch instance.",Ne,k,Ze,E,Bt=`Elastic Cloud ID: ··········
Elastic Api Key: ··········
`,Qe,B,_e,G,Gt="Confirm that the Python client has connected to your Elasticsearch instance with this test.",Se,N,We,Z,Nt="This examples uses a small dataset of movies.",Re,Q,Xe,_,Zt="Done indexing documents into `movies` index!\n",Ve,S,ze,W,Qt="Now we’ll use Eland’s <code>eland_import_hub_model</code> command to upload the model to Elasticsearch. For this example we’ve chosen the <code>cross-encoder/ms-marco-MiniLM-L-6-v2</code> text similarity model.",Le,R,Fe,X,_t=`2024-08-13 17:04:12,386 INFO : Establishing connection to Elasticsearch
2024-08-13 17:04:12,567 INFO : Connected to serverless cluster 'bd8c004c050e4654ad32fb86ab159889'
2024-08-13 17:04:12,568 INFO : Loading HuggingFace transformer tokenizer and model 'cross-encoder/ms-marco-MiniLM-L-6-v2'
/usr/local/lib/python3.10/dist-packages/huggingface_hub/file_download.py:1132: FutureWarning: \`resume_download\` is deprecated and will be removed in version 1.0.0. Downloads always resume when possible. If you want to force a new download, use \`force_download=True\`.
  warnings.warn(
tokenizer_config.json: 100% 316/316 [00:00<00:00, 1.81MB/s]
config.json: 100% 794/794 [00:00<00:00, 4.09MB/s]
vocab.txt: 100% 232k/232k [00:00<00:00, 2.37MB/s]
special_tokens_map.json: 100% 112/112 [00:00<00:00, 549kB/s]
pytorch_model.bin: 100% 90.9M/90.9M [00:00<00:00, 135MB/s]
STAGE:2024-08-13 17:04:15 1454:1454 ActivityProfilerController.cpp:312] Completed Stage: Warm Up
STAGE:2024-08-13 17:04:15 1454:1454 ActivityProfilerController.cpp:318] Completed Stage: Collection
STAGE:2024-08-13 17:04:15 1454:1454 ActivityProfilerController.cpp:322] Completed Stage: Post Processing
2024-08-13 17:04:18,789 INFO : Creating model with id 'cross-encoder__ms-marco-minilm-l-6-v2'
2024-08-13 17:04:21,123 INFO : Uploading model definition
100% 87/87 [00:55<00:00,  1.57 parts/s]
2024-08-13 17:05:16,416 INFO : Uploading model vocabulary
2024-08-13 17:05:16,987 INFO : Starting model deployment
2024-08-13 17:05:18,238 INFO : Model successfully imported with id 'cross-encoder__ms-marco-minilm-l-6-v2'
`,He,V,Pe,z,St="Next we’ll create an inference endpoint for the <code>rerank</code> task to deploy and manage our model and, if necessary, spin up the necessary ML resources behind the scenes.",Ye,L,De,F,Wt="Run the following command to confirm your inference endpoint is deployed.",Ke,H,Oe,P,Rt=`⚠️ When you deploy your model, you might need to sync your ML saved objects in the Kibana (or Serverless) UI.
Go to <strong>Trained Models</strong> and select <strong>Synchronize saved objects</strong>.`,et,Y,tt,D,Xt="First let’s use a <code>standard</code> retriever to test out some lexical (or full-text) searches and then we’ll compare the improvements when we layer in semantic reranking.",st,K,lt,O,Vt="Let’s say we vaguely remember that there is a famous movie about a killer who eats his victims. For the sake of argument, pretend we’ve momentarily forgotten the word “cannibal”.",at,ee,zt='Let’s perform a <a href="https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-query-string-query.html" rel="nofollow"><code>query_string</code> query</a> to find the phrase “flesh-eating bad guy” in the <code>plot</code> fields of our Elasticsearch documents.',nt,te,it,se,Lt=`No search results found
`,ot,le,Ft="No results! Unfortunately we don’t have any near exact matches for “flesh-eating bad guy”. Because we don’t have any more specific information about the exact phrasing in the Elasticsearch data, we’ll need to cast our search net wider.",pt,ae,rt,ne,Ht="This lexical query performs a standard keyword search for the term “crime” within the “plot” and “genre” fields of our Elasticsearch documents.",ct,ie,mt,oe,Pt=`Title: The Godfather
Plot: An organized crime dynasty's aging patriarch transfers control of his clandestine empire to his reluctant son.

Title: Goodfellas
Plot: The story of Henry Hill and his life in the mob, covering his relationship with his wife Karen Hill and his mob partners Jimmy Conway and Tommy DeVito in the Italian-American crime syndicate.

Title: The Silence of the Lambs
Plot: A young F.B.I. cadet must receive the help of an incarcerated and manipulative cannibal killer to help catch another serial killer, a madman who skins his victims.

Title: Pulp Fiction
Plot: The lives of two mob hitmen, a boxer, a gangster and his wife, and a pair of diner bandits intertwine in four tales of violence and redemption.

Title: Se7en
Plot: Two detectives, a rookie and a veteran, hunt a serial killer who uses the seven deadly sins as his motives.

Title: The Departed
Plot: An undercover cop and a mole in the police attempt to identify each other while infiltrating an Irish gang in South Boston.

Title: The Usual Suspects
Plot: A sole survivor tells of the twisty events leading up to a horrific gun battle on a boat, which began when five criminals met at a seemingly random police lineup.

Title: The Dark Knight
Plot: When the menace known as the Joker wreaks havoc and chaos on the people of Gotham, Batman must accept one of the greatest psychological and physical tests of his ability to fight injustice.
`,ht,pe,Yt="That’s better! At least we’ve got some results now. We broadened our search criteria to increase the chances of finding relevant results.",Mt,re,Dt="But these results aren’t very precise in the context of our original query “flesh-eating bad guy”. We can see that “The Silence of the Lambs” is returned in the middle of the results set with this generic <code>match</code> query. Let’s see if we can use our semantic reranking model to get closer to the searcher’s original intent.",yt,ce,ut,me,Kt="In the following <code>retriever</code> syntax, we wrap our standard query retriever in a <code>text_similarity_reranker</code>. This allows us to leverage the NLP model we deployed to Elasticsearch to rerank the results based on the phrase “flesh-eating bad guy”.",jt,he,Tt,Me,Ot=`Title: The Silence of the Lambs
Plot: A young F.B.I. cadet must receive the help of an incarcerated and manipulative cannibal killer to help catch another serial killer, a madman who skins his victims.

Title: Pulp Fiction
Plot: The lives of two mob hitmen, a boxer, a gangster and his wife, and a pair of diner bandits intertwine in four tales of violence and redemption.

Title: Se7en
Plot: Two detectives, a rookie and a veteran, hunt a serial killer who uses the seven deadly sins as his motives.

Title: Goodfellas
Plot: The story of Henry Hill and his life in the mob, covering his relationship with his wife Karen Hill and his mob partners Jimmy Conway and Tommy DeVito in the Italian-American crime syndicate.

Title: The Dark Knight
Plot: When the menace known as the Joker wreaks havoc and chaos on the people of Gotham, Batman must accept one of the greatest psychological and physical tests of his ability to fight injustice.

Title: The Godfather
Plot: An organized crime dynasty's aging patriarch transfers control of his clandestine empire to his reluctant son.

Title: The Departed
Plot: An undercover cop and a mole in the police attempt to identify each other while infiltrating an Irish gang in South Boston.

Title: The Usual Suspects
Plot: A sole survivor tells of the twisty events leading up to a horrific gun battle on a boat, which began when five criminals met at a seemingly random police lineup.
`,Jt,ye,es="Success! “The Silence of the Lambs” is our top result. Semantic reranking helped us find the most relevant result by parsing a natural language query, overcoming the limitations of lexical search which relies more on exact matching.",dt,ue,ts="Semantic reranking enables semantic search in a few steps, without the need for generating and storing embeddings. Being able to use open source models hosted on Hugging Face natively in your Elasticsearch cluster is great for prototyping, testing, and building search experiences.",wt,je,gt,Te,ss='<li>For this example we’ve chosen the <a href="https://huggingface.co/cross-encoder/ms-marco-MiniLM-L-6-v2" rel="nofollow"><code>cross-encoder/ms-marco-MiniLM-L-6-v2</code></a> text similarity model. Refer to <a href="https://www.elastic.co/guide/en/machine-learning/8.15/ml-nlp-model-ref.html#ml-nlp-model-ref-text-similarity" rel="nofollow">the Elastic NLP model reference</a> for a list of third-party text similarity models supported by Elasticsearch.</li> <li>Learn more about <a href="https://www.elastic.co/search-labs/integrations/hugging-face" rel="nofollow">integrating Hugging Face</a> with Elasticsearch.</li> <li>Check out Elastic’s catalogue of Python notebooks in the <a href="https://github.com/elastic/elasticsearch-labs/tree/main/notebooks" rel="nofollow"><code>elasticsearch-labs</code> repo</a>.</li> <li>Learn more about <a href="https://www.elastic.co/guide/en/elasticsearch/reference/current/retrievers-reranking-overview.html" rel="nofollow">retrievers and reranking in Elasticsearch</a></li>',Ut,Je,ft,we,It;return J=new hs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/semantic_reranking_elasticsearch.ipynb"}]}}),d=new u({props:{title:"Semantic reranking with Elasticsearch and Hugging Face",local:"semantic-reranking-with-elasticsearch-and-hugging-face",headingTag:"h1"}}),I=new u({props:{title:"🧰 Requirements",local:"-requirements",headingTag:"h2"}}),v=new u({props:{title:"Install and import packages",local:"install-and-import-packages",headingTag:"h2"}}),A=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcVUlMjBlbGFzdGljc2VhcmNoJTBBIXBpcCUyMGluc3RhbGwlMjBlbGFuZCU1QnB5dG9yY2glNUQlMEFmcm9tJTIwZWxhc3RpY3NlYXJjaCUyMGltcG9ydCUyMEVsYXN0aWNzZWFyY2glMkMlMjBoZWxwZXJz",highlighted:`!pip install -qU elasticsearch
!pip install eland[pytorch]
<span class="hljs-keyword">from</span> elasticsearch <span class="hljs-keyword">import</span> Elasticsearch, helpers`,wrap:!1}}),$=new u({props:{title:"Initialize Elasticsearch Python client",local:"initialize-elasticsearch-python-client",headingTag:"h2"}}),k=new j({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZ3d3cuZWxhc3RpYy5jbyUyRnNlYXJjaC1sYWJzJTJGdHV0b3JpYWxzJTJGaW5zdGFsbC1lbGFzdGljc2VhcmNoJTJGZWxhc3RpYy1jbG91ZCUyM2ZpbmRpbmcteW91ci1jbG91ZC1pZCUwQUVMQVNUSUNfQ0xPVURfSUQlMjAlM0QlMjBnZXRwYXNzKCUyMkVsYXN0aWMlMjBDbG91ZCUyMElEJTNBJTIwJTIyKSUwQSUwQSUyMyUyMGh0dHBzJTNBJTJGJTJGd3d3LmVsYXN0aWMuY28lMkZzZWFyY2gtbGFicyUyRnR1dG9yaWFscyUyRmluc3RhbGwtZWxhc3RpY3NlYXJjaCUyRmVsYXN0aWMtY2xvdWQlMjNjcmVhdGluZy1hbi1hcGkta2V5JTBBRUxBU1RJQ19BUElfS0VZJTIwJTNEJTIwZ2V0cGFzcyglMjJFbGFzdGljJTIwQXBpJTIwS2V5JTNBJTIwJTIyKSUwQSUwQSUyMyUyMENyZWF0ZSUyMHRoZSUyMGNsaWVudCUyMGluc3RhbmNlJTBBY2xpZW50JTIwJTNEJTIwRWxhc3RpY3NlYXJjaCglMEElMjAlMjAlMjAlMjAlMjMlMjBGb3IlMjBsb2NhbCUyMGRldmVsb3BtZW50JTBBJTIwJTIwJTIwJTIwJTIzJTIwaG9zdHMlM0QlNUIlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBOTIwMCUyMiU1RCUwQSUyMCUyMCUyMCUyMGNsb3VkX2lkJTNERUxBU1RJQ19DTE9VRF9JRCUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RFTEFTVElDX0FQSV9LRVklMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#finding-your-cloud-id</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ELASTIC_CLOUD_ID = getpass(<span class="hljs-string">&quot;Elastic Cloud ID: &quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#creating-an-api-key</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ELASTIC_API_KEY = getpass(<span class="hljs-string">&quot;Elastic Api Key: &quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the client instance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = Elasticsearch(
<span class="hljs-meta">... </span>    <span class="hljs-comment"># For local development</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># hosts=[&quot;http://localhost:9200&quot;]</span>
<span class="hljs-meta">... </span>    cloud_id=ELASTIC_CLOUD_ID,
<span class="hljs-meta">... </span>    api_key=ELASTIC_API_KEY,
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new u({props:{title:"Test connection",local:"test-connection",headingTag:"h2"}}),N=new j({props:{code:"cHJpbnQoY2xpZW50LmluZm8oKSk=",highlighted:'<span class="hljs-built_in">print</span>(client.info())',wrap:!1}}),Q=new j({props:{code:"ZnJvbSUyMHVybGxpYi5yZXF1ZXN0JTIwaW1wb3J0JTIwdXJsb3BlbiUwQWltcG9ydCUyMGpzb24lMEFpbXBvcnQlMjB0aW1lJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGbGVlbXRob21wbyUyRnNtYWxsLW1vdmllcyUyRnJhdyUyRm1haW4lMkZzbWFsbC1tb3ZpZXMuanNvbiUyMiUwQXJlc3BvbnNlJTIwJTNEJTIwdXJsb3Blbih1cmwpJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMHJlc3BvbnNlJTIwZGF0YSUyMGludG8lMjBhJTIwSlNPTiUyMG9iamVjdCUwQWRhdGFfanNvbiUyMCUzRCUyMGpzb24ubG9hZHMocmVzcG9uc2UucmVhZCgpKSUwQSUwQSUyMyUyMFByZXBhcmUlMjB0aGUlMjBkb2N1bWVudHMlMjB0byUyMGJlJTIwaW5kZXhlZCUwQWRvY3VtZW50cyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMGRvYyUyMGluJTIwZGF0YV9qc29uJTNBJTBBJTIwJTIwJTIwJTIwZG9jdW1lbnRzLmFwcGVuZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJfaW5kZXglMjIlM0ElMjAlMjJtb3ZpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJfc291cmNlJTIyJTNBJTIwZG9jJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMyUyMFVzZSUyMGhlbHBlcnMuYnVsayUyMHRvJTIwaW5kZXglMEFoZWxwZXJzLmJ1bGsoY2xpZW50JTJDJTIwZG9jdW1lbnRzKSUwQSUwQXByaW50KCUyMkRvbmUlMjBpbmRleGluZyUyMGRvY3VtZW50cyUyMGludG8lMjAlNjBtb3ZpZXMlNjAlMjBpbmRleCElMjIpJTBBdGltZS5zbGVlcCgzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> urllib.request <span class="hljs-keyword">import</span> urlopen
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/leemthompo/small-movies/raw/main/small-movies.json&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = urlopen(url)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the response data into a JSON object</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>data_json = json.loads(response.read())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare the documents to be indexed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>documents = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> data_json:
<span class="hljs-meta">... </span>    documents.append(
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;_index&quot;</span>: <span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;_source&quot;</span>: doc,
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use helpers.bulk to index</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>helpers.bulk(client, documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Done indexing documents into \`movies\` index!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>time.sleep(<span class="hljs-number">3</span>)`,wrap:!1}}),S=new u({props:{title:"Upload Hugging Face model using Eland",local:"upload-hugging-face-model-using-eland",headingTag:"h2"}}),R=new j({props:{code:"IWVsYW5kX2ltcG9ydF9odWJfbW9kZWwlMjAlNUMlMEElMjAlMjAtLWNsb3VkLWlkJTIwJTI0RUxBU1RJQ19DTE9VRF9JRCUyMCU1QyUwQSUyMCUyMC0tZXMtYXBpLWtleSUyMCUyNEVMQVNUSUNfQVBJX0tFWSUyMCU1QyUwQSUyMCUyMC0taHViLW1vZGVsLWlkJTIwY3Jvc3MtZW5jb2RlciUyRm1zLW1hcmNvLU1pbmlMTS1MLTYtdjIlMjAlNUMlMEElMjAlMjAtLXRhc2stdHlwZSUyMHRleHRfc2ltaWxhcml0eSUyMCU1QyUwQSUyMCUyMC0tY2xlYXItcHJldmlvdXMlMjAlNUMlMEElMjAlMjAtLXN0YXJ0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>!eland_import_hub_model \\
<span class="hljs-meta">... </span>  --cloud-<span class="hljs-built_in">id</span> $ELASTIC_CLOUD_ID \\
<span class="hljs-meta">... </span>  --es-api-key $ELASTIC_API_KEY \\
<span class="hljs-meta">... </span>  --hub-model-<span class="hljs-built_in">id</span> cross-encoder/ms-marco-MiniLM-L-<span class="hljs-number">6</span>-v2 \\
<span class="hljs-meta">... </span>  --task-<span class="hljs-built_in">type</span> text_similarity \\
<span class="hljs-meta">... </span>  --clear-previous \\
<span class="hljs-meta">... </span>  --start`,wrap:!1}}),V=new u({props:{title:"Create inference endpoint",local:"create-inference-endpoint",headingTag:"h2"}}),L=new j({props:{code:"Y2xpZW50LmluZmVyZW5jZS5wdXQoJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIycmVyYW5rJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5mZXJlbmNlX2lkJTNEJTIybXktbXNtYXJjby1taW5pbG0tbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBpbmZlcmVuY2VfY29uZmlnJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2VydmljZSUyMiUzQSUyMCUyMmVsYXN0aWNzZWFyY2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXJ2aWNlX3NldHRpbmdzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWxfaWQlMjIlM0ElMjAlMjJjcm9zcy1lbmNvZGVyX19tcy1tYXJjby1taW5pbG0tbC02LXYyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybnVtX2FsbG9jYXRpb25zJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV90aHJlYWRzJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`client.inference.put(
    task_type=<span class="hljs-string">&quot;rerank&quot;</span>,
    inference_id=<span class="hljs-string">&quot;my-msmarco-minilm-model&quot;</span>,
    inference_config={
        <span class="hljs-string">&quot;service&quot;</span>: <span class="hljs-string">&quot;elasticsearch&quot;</span>,
        <span class="hljs-string">&quot;service_settings&quot;</span>: {
            <span class="hljs-string">&quot;model_id&quot;</span>: <span class="hljs-string">&quot;cross-encoder__ms-marco-minilm-l-6-v2&quot;</span>,
            <span class="hljs-string">&quot;num_allocations&quot;</span>: <span class="hljs-number">1</span>,
            <span class="hljs-string">&quot;num_threads&quot;</span>: <span class="hljs-number">1</span>,
        },
    },
)`,wrap:!1}}),H=new j({props:{code:"Y2xpZW50LmluZmVyZW5jZS5nZXQoKQ==",highlighted:"client.inference.get()",wrap:!1}}),Y=new u({props:{title:"Lexical queries",local:"lexical-queries",headingTag:"h2"}}),K=new u({props:{title:"Lexical match with query_string query",local:"lexical-match-with-querystring-query",headingTag:"h3"}}),te=new j({props:{code:"cmVzcCUyMCUzRCUyMGNsaWVudC5zZWFyY2goJTBBJTIwJTIwJTIwJTIwaW5kZXglM0QlMjJtb3ZpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXRyaWV2ZXIlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFuZGFyZCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlcnlfc3RyaW5nJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlcnklMjIlM0ElMjAlMjJmbGVzaC1lYXRpbmclMjBiYWQlMjBndXklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZWZhdWx0X2ZpZWxkJTIyJTNBJTIwJTIycGxvdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEElMEFpZiUyMHJlc3AlNUIlMjJoaXRzJTIyJTVEJTVCJTIyaGl0cyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGhpdCUyMGluJTIwcmVzcCU1QiUyMmhpdHMlMjIlNUQlNUIlMjJoaXRzJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlMjAlM0QlMjBoaXQlNUIlMjJfc291cmNlJTIyJTVEJTVCJTIydGl0bGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbG90JTIwJTNEJTIwaGl0JTVCJTIyX3NvdXJjZSUyMiU1RCU1QiUyMnBsb3QlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyVGl0bGUlM0ElMjAlN0J0aXRsZSU3RCU1Q25QbG90JTNBJTIwJTdCcGxvdCU3RCU1Q24lMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMk5vJTIwc2VhcmNoJTIwcmVzdWx0cyUyMGZvdW5kJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>resp = client.search(
<span class="hljs-meta">... </span>    index=<span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>    retriever={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;standard&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;query&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;query_string&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;flesh-eating bad guy&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;default_field&quot;</span>: <span class="hljs-string">&quot;plot&quot;</span>,
<span class="hljs-meta">... </span>                }
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> resp[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> resp[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
<span class="hljs-meta">... </span>        title = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
<span class="hljs-meta">... </span>        plot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;plot&quot;</span>]
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Title: <span class="hljs-subst">{title}</span>\\nPlot: <span class="hljs-subst">{plot}</span>\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;No search results found&quot;</span>)`,wrap:!1}}),ae=new u({props:{title:"Simple multi_match query",local:"simple-multimatch-query",headingTag:"h3"}}),ie=new j({props:{code:"cmVzcCUyMCUzRCUyMGNsaWVudC5zZWFyY2goJTBBJTIwJTIwJTIwJTIwaW5kZXglM0QlMjJtb3ZpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXRyaWV2ZXIlM0QlN0IlMjJzdGFuZGFyZCUyMiUzQSUyMCU3QiUyMnF1ZXJ5JTIyJTNBJTIwJTdCJTIybXVsdGlfbWF0Y2glMjIlM0ElMjAlN0IlMjJxdWVyeSUyMiUzQSUyMCUyMmNyaW1lJTIyJTJDJTIwJTIyZmllbGRzJTIyJTNBJTIwJTVCJTIycGxvdCUyMiUyQyUyMCUyMmdlbnJlJTIyJTVEJTdEJTdEJTdEJTdEJTJDJTBBKSUwQSUwQWZvciUyMGhpdCUyMGluJTIwcmVzcCU1QiUyMmhpdHMlMjIlNUQlNUIlMjJoaXRzJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwdGl0bGUlMjAlM0QlMjBoaXQlNUIlMjJfc291cmNlJTIyJTVEJTVCJTIydGl0bGUlMjIlNUQlMEElMjAlMjAlMjAlMjBwbG90JTIwJTNEJTIwaGl0JTVCJTIyX3NvdXJjZSUyMiU1RCU1QiUyMnBsb3QlMjIlNUQlMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGl0bGUlM0ElMjAlN0J0aXRsZSU3RCU1Q25QbG90JTNBJTIwJTdCcGxvdCU3RCU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>resp = client.search(
<span class="hljs-meta">... </span>    index=<span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>    retriever={<span class="hljs-string">&quot;standard&quot;</span>: {<span class="hljs-string">&quot;query&quot;</span>: {<span class="hljs-string">&quot;multi_match&quot;</span>: {<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;crime&quot;</span>, <span class="hljs-string">&quot;fields&quot;</span>: [<span class="hljs-string">&quot;plot&quot;</span>, <span class="hljs-string">&quot;genre&quot;</span>]}}}},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> resp[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
<span class="hljs-meta">... </span>    title = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
<span class="hljs-meta">... </span>    plot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;plot&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Title: <span class="hljs-subst">{title}</span>\\nPlot: <span class="hljs-subst">{plot}</span>\\n&quot;</span>)`,wrap:!1}}),ce=new u({props:{title:"Semantic reranker",local:"semantic-reranker",headingTag:"h2"}}),he=new j({props:{code:"cmVzcCUyMCUzRCUyMGNsaWVudC5zZWFyY2goJTBBJTIwJTIwJTIwJTIwaW5kZXglM0QlMjJtb3ZpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXRyaWV2ZXIlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0X3NpbWlsYXJpdHlfcmVyYW5rZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXRyaWV2ZXIlMjIlM0ElMjAlN0IlMjJzdGFuZGFyZCUyMiUzQSUyMCU3QiUyMnF1ZXJ5JTIyJTNBJTIwJTdCJTIybXVsdGlfbWF0Y2glMjIlM0ElMjAlN0IlMjJxdWVyeSUyMiUzQSUyMCUyMmNyaW1lJTIyJTJDJTIwJTIyZmllbGRzJTIyJTNBJTIwJTVCJTIycGxvdCUyMiUyQyUyMCUyMmdlbnJlJTIyJTVEJTdEJTdEJTdEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmllbGQlMjIlM0ElMjAlMjJwbG90JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5mZXJlbmNlX2lkJTIyJTNBJTIwJTIybXktbXNtYXJjby1taW5pbG0tbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbmZlcmVuY2VfdGV4dCUyMiUzQSUyMCUyMmZsZXNoLWVhdGluZyUyMGJhZCUyMGd1eSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEElMEFmb3IlMjBoaXQlMjBpbiUyMHJlc3AlNUIlMjJoaXRzJTIyJTVEJTVCJTIyaGl0cyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHRpdGxlJTIwJTNEJTIwaGl0JTVCJTIyX3NvdXJjZSUyMiU1RCU1QiUyMnRpdGxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwcGxvdCUyMCUzRCUyMGhpdCU1QiUyMl9zb3VyY2UlMjIlNUQlNUIlMjJwbG90JTIyJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlRpdGxlJTNBJTIwJTdCdGl0bGUlN0QlNUNuUGxvdCUzQSUyMCU3QnBsb3QlN0QlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>resp = client.search(
<span class="hljs-meta">... </span>    index=<span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>    retriever={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;text_similarity_reranker&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;retriever&quot;</span>: {<span class="hljs-string">&quot;standard&quot;</span>: {<span class="hljs-string">&quot;query&quot;</span>: {<span class="hljs-string">&quot;multi_match&quot;</span>: {<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;crime&quot;</span>, <span class="hljs-string">&quot;fields&quot;</span>: [<span class="hljs-string">&quot;plot&quot;</span>, <span class="hljs-string">&quot;genre&quot;</span>]}}}},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;field&quot;</span>: <span class="hljs-string">&quot;plot&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;inference_id&quot;</span>: <span class="hljs-string">&quot;my-msmarco-minilm-model&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;inference_text&quot;</span>: <span class="hljs-string">&quot;flesh-eating bad guy&quot;</span>,
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> resp[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
<span class="hljs-meta">... </span>    title = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
<span class="hljs-meta">... </span>    plot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;plot&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Title: <span class="hljs-subst">{title}</span>\\nPlot: <span class="hljs-subst">{plot}</span>\\n&quot;</span>)`,wrap:!1}}),je=new u({props:{title:"Learn more",local:"learn-more",headingTag:"h2"}}),Je=new Ms({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/semantic_reranking_elasticsearch.md"}}),{c(){T=i("meta"),ge=a(),de=i("p"),Ue=a(),r(J.$$.fragment),fe=a(),r(d.$$.fragment),Ie=a(),w=i("p"),w.innerHTML=bt,Ce=a(),g=i("p"),g.innerHTML=vt,be=a(),U=i("p"),U.textContent=qt,ve=a(),f=i("ul"),f.innerHTML=At,qe=a(),r(I.$$.fragment),Ae=a(),C=i("p"),C.textContent=$t,$e=a(),b=i("ul"),b.innerHTML=xt,xe=a(),r(v.$$.fragment),ke=a(),q=i("p"),q.innerHTML=kt,Ee=a(),r(A.$$.fragment),Be=a(),r($.$$.fragment),Ge=a(),x=i("p"),x.textContent=Et,Ne=a(),r(k.$$.fragment),Ze=a(),E=i("pre"),E.textContent=Bt,Qe=a(),r(B.$$.fragment),_e=a(),G=i("p"),G.textContent=Gt,Se=a(),r(N.$$.fragment),We=a(),Z=i("p"),Z.textContent=Nt,Re=a(),r(Q.$$.fragment),Xe=a(),_=i("pre"),_.textContent=Zt,Ve=a(),r(S.$$.fragment),ze=a(),W=i("p"),W.innerHTML=Qt,Le=a(),r(R.$$.fragment),Fe=a(),X=i("pre"),X.textContent=_t,He=a(),r(V.$$.fragment),Pe=a(),z=i("p"),z.innerHTML=St,Ye=a(),r(L.$$.fragment),De=a(),F=i("p"),F.textContent=Wt,Ke=a(),r(H.$$.fragment),Oe=a(),P=i("p"),P.innerHTML=Rt,et=a(),r(Y.$$.fragment),tt=a(),D=i("p"),D.innerHTML=Xt,st=a(),r(K.$$.fragment),lt=a(),O=i("p"),O.textContent=Vt,at=a(),ee=i("p"),ee.innerHTML=zt,nt=a(),r(te.$$.fragment),it=a(),se=i("pre"),se.textContent=Lt,ot=a(),le=i("p"),le.textContent=Ft,pt=a(),r(ae.$$.fragment),rt=a(),ne=i("p"),ne.textContent=Ht,ct=a(),r(ie.$$.fragment),mt=a(),oe=i("pre"),oe.textContent=Pt,ht=a(),pe=i("p"),pe.textContent=Yt,Mt=a(),re=i("p"),re.innerHTML=Dt,yt=a(),r(ce.$$.fragment),ut=a(),me=i("p"),me.innerHTML=Kt,jt=a(),r(he.$$.fragment),Tt=a(),Me=i("pre"),Me.textContent=Ot,Jt=a(),ye=i("p"),ye.textContent=es,dt=a(),ue=i("p"),ue.textContent=ts,wt=a(),r(je.$$.fragment),gt=a(),Te=i("ul"),Te.innerHTML=ss,Ut=a(),r(Je.$$.fragment),ft=a(),we=i("p"),this.h()},l(e){const t=cs("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(s),ge=n(e),de=o(e,"P",{}),ls(de).forEach(s),Ue=n(e),c(J.$$.fragment,e),fe=n(e),c(d.$$.fragment,e),Ie=n(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-15h9vzq"&&(w.innerHTML=bt),Ce=n(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1sgmmyr"&&(g.innerHTML=vt),be=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1xbnm7h"&&(U.textContent=qt),ve=n(e),f=o(e,"UL",{"data-svelte-h":!0}),p(f)!=="svelte-s2bfhc"&&(f.innerHTML=At),qe=n(e),c(I.$$.fragment,e),Ae=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-3aq2ds"&&(C.textContent=$t),$e=n(e),b=o(e,"UL",{"data-svelte-h":!0}),p(b)!=="svelte-pk6dgn"&&(b.innerHTML=xt),xe=n(e),c(v.$$.fragment,e),ke=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-c1ile"&&(q.innerHTML=kt),Ee=n(e),c(A.$$.fragment,e),Be=n(e),c($.$$.fragment,e),Ge=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1mu35i"&&(x.textContent=Et),Ne=n(e),c(k.$$.fragment,e),Ze=n(e),E=o(e,"PRE",{"data-svelte-h":!0}),p(E)!=="svelte-1x47hmf"&&(E.textContent=Bt),Qe=n(e),c(B.$$.fragment,e),_e=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-7uwvg8"&&(G.textContent=Gt),Se=n(e),c(N.$$.fragment,e),We=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-18d4ymf"&&(Z.textContent=Nt),Re=n(e),c(Q.$$.fragment,e),Xe=n(e),_=o(e,"PRE",{"data-svelte-h":!0}),p(_)!=="svelte-1m77zdm"&&(_.textContent=Zt),Ve=n(e),c(S.$$.fragment,e),ze=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1ca2x37"&&(W.innerHTML=Qt),Le=n(e),c(R.$$.fragment,e),Fe=n(e),X=o(e,"PRE",{"data-svelte-h":!0}),p(X)!=="svelte-1o6q6qn"&&(X.textContent=_t),He=n(e),c(V.$$.fragment,e),Pe=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-it6ukr"&&(z.innerHTML=St),Ye=n(e),c(L.$$.fragment,e),De=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-ovxxa0"&&(F.textContent=Wt),Ke=n(e),c(H.$$.fragment,e),Oe=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-qyxqyq"&&(P.innerHTML=Rt),et=n(e),c(Y.$$.fragment,e),tt=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1lhom78"&&(D.innerHTML=Xt),st=n(e),c(K.$$.fragment,e),lt=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-17srll"&&(O.textContent=Vt),at=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-h70xlg"&&(ee.innerHTML=zt),nt=n(e),c(te.$$.fragment,e),it=n(e),se=o(e,"PRE",{"data-svelte-h":!0}),p(se)!=="svelte-k5qxm1"&&(se.textContent=Lt),ot=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1ednygn"&&(le.textContent=Ft),pt=n(e),c(ae.$$.fragment,e),rt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-wglz1c"&&(ne.textContent=Ht),ct=n(e),c(ie.$$.fragment,e),mt=n(e),oe=o(e,"PRE",{"data-svelte-h":!0}),p(oe)!=="svelte-t0ny4t"&&(oe.textContent=Pt),ht=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-7lrowr"&&(pe.textContent=Yt),Mt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1rxzbcx"&&(re.innerHTML=Dt),yt=n(e),c(ce.$$.fragment,e),ut=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1644ogc"&&(me.innerHTML=Kt),jt=n(e),c(he.$$.fragment,e),Tt=n(e),Me=o(e,"PRE",{"data-svelte-h":!0}),p(Me)!=="svelte-vpj64j"&&(Me.textContent=Ot),Jt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-xlaql4"&&(ye.textContent=es),dt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1ekzpnb"&&(ue.textContent=ts),wt=n(e),c(je.$$.fragment,e),gt=n(e),Te=o(e,"UL",{"data-svelte-h":!0}),p(Te)!=="svelte-gd4z7i"&&(Te.innerHTML=ss),Ut=n(e),c(Je.$$.fragment,e),ft=n(e),we=o(e,"P",{}),ls(we).forEach(s),this.h()},h(){as(T,"name","hf:doc:metadata"),as(T,"content",us)},m(e,t){ms(document.head,T),l(e,ge,t),l(e,de,t),l(e,Ue,t),m(J,e,t),l(e,fe,t),m(d,e,t),l(e,Ie,t),l(e,w,t),l(e,Ce,t),l(e,g,t),l(e,be,t),l(e,U,t),l(e,ve,t),l(e,f,t),l(e,qe,t),m(I,e,t),l(e,Ae,t),l(e,C,t),l(e,$e,t),l(e,b,t),l(e,xe,t),m(v,e,t),l(e,ke,t),l(e,q,t),l(e,Ee,t),m(A,e,t),l(e,Be,t),m($,e,t),l(e,Ge,t),l(e,x,t),l(e,Ne,t),m(k,e,t),l(e,Ze,t),l(e,E,t),l(e,Qe,t),m(B,e,t),l(e,_e,t),l(e,G,t),l(e,Se,t),m(N,e,t),l(e,We,t),l(e,Z,t),l(e,Re,t),m(Q,e,t),l(e,Xe,t),l(e,_,t),l(e,Ve,t),m(S,e,t),l(e,ze,t),l(e,W,t),l(e,Le,t),m(R,e,t),l(e,Fe,t),l(e,X,t),l(e,He,t),m(V,e,t),l(e,Pe,t),l(e,z,t),l(e,Ye,t),m(L,e,t),l(e,De,t),l(e,F,t),l(e,Ke,t),m(H,e,t),l(e,Oe,t),l(e,P,t),l(e,et,t),m(Y,e,t),l(e,tt,t),l(e,D,t),l(e,st,t),m(K,e,t),l(e,lt,t),l(e,O,t),l(e,at,t),l(e,ee,t),l(e,nt,t),m(te,e,t),l(e,it,t),l(e,se,t),l(e,ot,t),l(e,le,t),l(e,pt,t),m(ae,e,t),l(e,rt,t),l(e,ne,t),l(e,ct,t),m(ie,e,t),l(e,mt,t),l(e,oe,t),l(e,ht,t),l(e,pe,t),l(e,Mt,t),l(e,re,t),l(e,yt,t),m(ce,e,t),l(e,ut,t),l(e,me,t),l(e,jt,t),m(he,e,t),l(e,Tt,t),l(e,Me,t),l(e,Jt,t),l(e,ye,t),l(e,dt,t),l(e,ue,t),l(e,wt,t),m(je,e,t),l(e,gt,t),l(e,Te,t),l(e,Ut,t),m(Je,e,t),l(e,ft,t),l(e,we,t),It=!0},p:is,i(e){It||(h(J.$$.fragment,e),h(d.$$.fragment,e),h(I.$$.fragment,e),h(v.$$.fragment,e),h(A.$$.fragment,e),h($.$$.fragment,e),h(k.$$.fragment,e),h(B.$$.fragment,e),h(N.$$.fragment,e),h(Q.$$.fragment,e),h(S.$$.fragment,e),h(R.$$.fragment,e),h(V.$$.fragment,e),h(L.$$.fragment,e),h(H.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),It=!0)},o(e){M(J.$$.fragment,e),M(d.$$.fragment,e),M(I.$$.fragment,e),M(v.$$.fragment,e),M(A.$$.fragment,e),M($.$$.fragment,e),M(k.$$.fragment,e),M(B.$$.fragment,e),M(N.$$.fragment,e),M(Q.$$.fragment,e),M(S.$$.fragment,e),M(R.$$.fragment,e),M(V.$$.fragment,e),M(L.$$.fragment,e),M(H.$$.fragment,e),M(Y.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(ce.$$.fragment,e),M(he.$$.fragment,e),M(je.$$.fragment,e),M(Je.$$.fragment,e),It=!1},d(e){e&&(s(ge),s(de),s(Ue),s(fe),s(Ie),s(w),s(Ce),s(g),s(be),s(U),s(ve),s(f),s(qe),s(Ae),s(C),s($e),s(b),s(xe),s(ke),s(q),s(Ee),s(Be),s(Ge),s(x),s(Ne),s(Ze),s(E),s(Qe),s(_e),s(G),s(Se),s(We),s(Z),s(Re),s(Xe),s(_),s(Ve),s(ze),s(W),s(Le),s(Fe),s(X),s(He),s(Pe),s(z),s(Ye),s(De),s(F),s(Ke),s(Oe),s(P),s(et),s(tt),s(D),s(st),s(lt),s(O),s(at),s(ee),s(nt),s(it),s(se),s(ot),s(le),s(pt),s(rt),s(ne),s(ct),s(mt),s(oe),s(ht),s(pe),s(Mt),s(re),s(yt),s(ut),s(me),s(jt),s(Tt),s(Me),s(Jt),s(ye),s(dt),s(ue),s(wt),s(gt),s(Te),s(Ut),s(ft),s(we)),s(T),y(J,e),y(d,e),y(I,e),y(v,e),y(A,e),y($,e),y(k,e),y(B,e),y(N,e),y(Q,e),y(S,e),y(R,e),y(V,e),y(L,e),y(H,e),y(Y,e),y(K,e),y(te,e),y(ae,e),y(ie,e),y(ce,e),y(he,e),y(je,e),y(Je,e)}}}const us='{"title":"Semantic reranking with Elasticsearch and Hugging Face","local":"semantic-reranking-with-elasticsearch-and-hugging-face","sections":[{"title":"🧰 Requirements","local":"-requirements","sections":[],"depth":2},{"title":"Install and import packages","local":"install-and-import-packages","sections":[],"depth":2},{"title":"Initialize Elasticsearch Python client","local":"initialize-elasticsearch-python-client","sections":[],"depth":2},{"title":"Test connection","local":"test-connection","sections":[],"depth":2},{"title":"Upload Hugging Face model using Eland","local":"upload-hugging-face-model-using-eland","sections":[],"depth":2},{"title":"Create inference endpoint","local":"create-inference-endpoint","sections":[],"depth":2},{"title":"Lexical queries","local":"lexical-queries","sections":[{"title":"Lexical match with query_string query","local":"lexical-match-with-querystring-query","sections":[],"depth":3},{"title":"Simple multi_match query","local":"simple-multimatch-query","sections":[],"depth":3}],"depth":2},{"title":"Semantic reranker","local":"semantic-reranker","sections":[],"depth":2},{"title":"Learn more","local":"learn-more","sections":[],"depth":2}],"depth":1}';function js(Ct){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gs extends ps{constructor(T){super(),rs(this,T,js,ys,ns,{})}}export{gs as component};
